/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class ISCBinaryValue {
    public static boolean isBinary(Object obj) {
        return obj instanceof InputStream || obj instanceof Byte[] || obj instanceof byte[] || obj instanceof File;
    }

    public static void copyToOutputStream(Object source, OutputStream os) throws IOException, SQLException {
        if (source instanceof InputStream) {
            IOUtil.copyStreams((InputStream)source, os);
        } else if (source instanceof Byte[]) {
            byte[] work = new byte[((Byte[])source).length];
            for (int i = 0; i < work.length; ++i) {
                work[i] = ((Byte[])source)[i];
            }
            os.write(work);
        } else if (source instanceof byte[]) {
            os.write((byte[])source);
        } else if (source instanceof File) {
            FileInputStream fis = new FileInputStream((File)source);
            IOUtil.copyStreams(fis, os);
        } else {
            throw new IOException("Unexpected object type " + source.getClass().getName() + " encountered when processing binary data.  The only supported types are " + " byte[], Byte[] and InputStream");
        }
    }
}

