/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceBeanFilter;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ISCBinaryValue;
import com.isomorphic.datasource.PartialCommitException;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.CurrentMillisMarker;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.KeepPropertiesBeanFilter;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.HttpServletRequestParser;
import com.isomorphic.rpc.QueueAlreadyStartedException;
import com.isomorphic.rpc.RPCManagerCompletionCallback;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import com.isomorphic.velocity.ServletRequestAttributeMapFacade;
import com.isomorphic.velocity.SessionAttributeMapFacade;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCManager {
    private static Config config = Config.getGlobal();
    private static int maxRequestDebugLength = config.getInt("RPCManager.maxRequestDebugLength", 1024);
    private static boolean globalOmitNullMapValuesInResponse = config.getBoolean((Object)"RPCManager.omitNullMapValuesInResponse", false);
    private static boolean globalPrettyPrintResponse = config.getBoolean((Object)"RPCManager.prettyPrintResponse", false);
    public static final String structuredRPCStart = "//isc_RPCResponseStart-->";
    public static final String structuredRPCEnd = "//isc_RPCResponseEnd";
    private static final String IFRAME_RECURSE_UP = "iframe";
    private static final String IFRAME_NEW_WINDOW = "iframeNewWindow";
    private static final String IFRAME_TARGET = "__iframeTarget__";
    private static final String IFRAME_CALLBACK_METHOD = "isc.Comm.hiddenFrameReply";
    private RequestContext context;
    private Map responseMap = new HashMap();
    private Long transactionNum;
    private String jsCallback;
    private Map transaction;
    private List requests;
    private boolean responseIsCustom = false;
    private static boolean initNotRunMessageShown = false;
    private boolean isDownload = false;
    private String charset = config.getString("RPCManager.defaultCharset", "UTF-8");
    public boolean closeConnection = false;
    public boolean omitNullMapValuesInResponse = globalOmitNullMapValuesInResponse;
    public boolean prettyPrintResponse = globalPrettyPrintResponse;
    private Map templateContext = new HashMap();
    public static Logger log = new Logger(RPCManager.class.getName());
    private boolean isExport = false;
    public boolean enableAllDS = false;
    private long constructed;
    private long started;
    String customHTML = config.getString("RPCManager.customHTML", null);
    String serverVersion = config.getString("iscVersionNumber");
    boolean devenv = config.getBoolean((Object)"devenv", false);
    private List dataSourcesToFree = new ArrayList();
    private Boolean authenticated;
    private List userRoles;
    private String userId;
    private Map attributes = new HashMap();
    protected Set callbacks = new LinkedHashSet();
    protected int transactionPolicy = Config.getGlobal().getInt("RPCManager.transactionPolicy", 0);
    protected boolean requestProcessingStarted = false;
    private List associatedRequests = new ArrayList();
    private Map<String, DataSource> cachedDataSources = new HashMap<String, DataSource>();

    public RequestContext getContext() {
        return this.context;
    }

    public RPCManager omitNullMapValuesInResponse(boolean value) {
        this.omitNullMapValuesInResponse = value;
        return this;
    }

    public RPCManager prettyPrintResponse(boolean value) {
        this.prettyPrintResponse = value;
        return this;
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public Object getFromTemplateContext(Object key) {
        return this.templateContext.get(key);
    }

    public void addToTemplateContext(Object key, Object value) {
        this.templateContext.put(key, value);
    }

    public void enableAllDataSources() {
        this.enableAllDS = true;
    }

    public long getConstructedTimestamp() {
        return this.constructed;
    }

    public long getStartedTimestamp() {
        return this.started;
    }

    public void setJsCallback(String jsCallback) {
        this.jsCallback = jsCallback;
    }

    public boolean isREST() {
        DSRequest dsReq = this.getDSRequest(true);
        if (dsReq != null) {
            return Boolean.TRUE.equals(dsReq.getREST());
        }
        return false;
    }

    public boolean isREST(Object req) {
        if (req instanceof DSRequest) {
            DSRequest dsReq = (DSRequest)req;
            return Boolean.TRUE.equals(dsReq.getREST());
        }
        return false;
    }

    public static boolean isRPC(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return queryString.indexOf("isc_rpc=1") != -1 || queryString.indexOf("is_isc_rpc=true") != -1;
    }

    public static boolean isXmlHttp(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return queryString.indexOf("isc_xhr=1") != -1 || queryString.indexOf("xmlHttp=true") != -1;
    }

    public static long getTransactionNum(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String transactionNum = (String)queryParams.get("isc_tnum");
            if (transactionNum == null) {
                transactionNum = (String)queryParams.get("iscTNum");
            }
            if (RPCManager.isXmlHttp(request)) {
                transactionNum = request.getParameter("isc_tnum");
            }
            if (transactionNum == null) {
                return -1L;
            }
            return Long.valueOf(transactionNum);
        }
        catch (Exception e) {
            log.warn((Object)"Error parsing transaction from query params", e);
            return -1L;
        }
    }

    private static String getClientVersion(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String version = (String)queryParams.get("isc_v");
            if (version == null) {
                version = (String)queryParams.get("isc_clientVersion");
            }
            return version;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine client version");
            return null;
        }
    }

    public static void writeDocumentDomain(Writer out, RequestContext context) throws IOException {
        String documentDomain = RPCManager.getDocumentDomain((HttpServletRequest)context.request);
        if (documentDomain != null) {
            out.write("<SCRIPT>document.domain = '" + documentDomain + "';</SCRIPT>\n");
        }
    }

    private static String getDocumentDomain(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String dd = (String)queryParams.get("isc_dd");
            if (dd == null) {
                dd = (String)queryParams.get("docDomain");
            }
            if (dd != null) {
                StringBuffer escaped = new StringBuffer();
                for (int i = 0; i < dd.length(); ++i) {
                    char c = dd.charAt(i);
                    if (c < '\u0100') {
                        if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                            escaped.append(c);
                            continue;
                        }
                        escaped.append("\\x");
                        escaped.append(Integer.toHexString(c));
                        continue;
                    }
                    escaped.append(c);
                }
                dd = escaped.toString();
            }
            return dd;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine docDomain");
            return null;
        }
    }

    public RPCManager(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this(servlet, request, response, null);
    }

    public RPCManager(Servlet servlet, HttpServletRequest request, HttpServletResponse response, HttpServletRequestParser parser) throws Exception {
        this.constructed = System.currentTimeMillis();
        if (!ISCInit.isInitialized() && !initNotRunMessageShown) {
            log.warn("ISC Init has not been run.");
            initNotRunMessageShown = true;
        }
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance(servlet, request, response);
        this.initLog(request);
        if (parser == null) {
            this.parseRequest();
        } else {
            parser.parseRequest(this, request);
        }
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
        this.started = System.currentTimeMillis();
        for (int i = 0; i < this.requests.size(); ++i) {
            Object obj = this.requests.get(i);
            if (!(obj instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)obj;
            dsRequest.recordTimingData("RPCManager construction", DSRequest.TimingLogType.END, this.getStartedTimestamp());
            dsRequest.recordTimingData("RPCManager processing", DSRequest.TimingLogType.START, this.getStartedTimestamp());
        }
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance(ISCFile.servletContext, (ServletRequest)request, (ServletResponse)response);
        this.initLog(request);
        this.parseRequest();
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
    }

    protected void initLog(HttpServletRequest request) {
        try {
            Map queryParams = ServletTools.parseQueryString(request.getQueryString());
            String logging = (String)queryParams.get("isc_rpc_logging");
            if ("off".equals(logging)) {
                log.setInstanceLevel(Logger.OFF);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error initializing log settings", e);
        }
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response, Writer out) throws Exception {
        this(request, response);
        this.context.setOut(out);
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession()));
    }

    public void setCustomHTML(String customHTML) {
        this.customHTML = customHTML;
    }

    public void doCustomResponse() {
        this.responseIsCustom = true;
    }

    public void setResponseCharset(String charset) {
        this.charset = charset;
    }

    public Object getData() {
        return this.getRequest().getData();
    }

    public DSRequest getDSRequest() {
        return this.getDSRequest(false);
    }

    public DSRequest getDSRequest(boolean skipWarning) {
        Object req;
        int requestCount = this.requestCount();
        if (requestCount > 1 && !skipWarning) {
            log.warn((Object)("getDSRequest() on multiop RPC (" + requestCount + " requests pending) "), new Exception());
        }
        if ((req = this.requests.get(0)) instanceof DSRequest) {
            return (DSRequest)req;
        }
        return null;
    }

    public RPCRequest getRequest() {
        int requestCount = this.requestCount();
        if (requestCount > 1) {
            log.warn((Object)("getRequest() on multiop RPC (" + requestCount + " requests pending) "), new Exception());
        }
        return (RPCRequest)this.requests.get(0);
    }

    public List getRequests() {
        return this.requests;
    }

    public int requestCount() {
        return this.requests.size();
    }

    public void send(Object data) throws Exception {
        this.send(new RPCResponse(data));
    }

    public void send(RPCResponse rpcResponse) throws Exception {
        RPCRequest rpcRequest = this.getRequest();
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("Single-argument send() method called twice.  This method may only be called once in response to a single RPCRequest.");
        }
        this.send(rpcRequest, rpcResponse);
    }

    public void send(RPCRequest rpcRequest, RPCResponse rpcResponse) throws Exception {
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("send(rpcRequest, rpcResponse) called twice for the same rpcRequest.  Only one RPCResponse can be sent to an RPCRequest.");
        }
        this.responseMap.put(rpcRequest, rpcResponse);
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(RPCRequest rpcRequest, Object data) throws Exception {
        RPCResponse rpcResponse = new RPCResponse();
        rpcResponse.setData(data);
        rpcResponse.setStatus(RPCResponse.STATUS_SUCCESS);
        this.send(rpcRequest, rpcResponse);
    }

    public void sendXMLString(RPCRequest rpcRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        validationContext.freeResources();
        this.send(rpcRequest, data);
    }

    public void send(DSRequest dsRequest, DSResponse dsResponse) throws Exception {
        if (!this.isDownload) {
            this.isDownload = dsRequest.isDownload();
        }
        if (!this.isExport) {
            this.isExport = dsRequest.isExport();
        }
        this.responseMap.put(dsRequest, dsResponse);
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(DSRequest dsRequest, Object data) throws Exception {
        DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
        dsResponse.setData(data);
        dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
        this.send(dsRequest, dsResponse);
    }

    public void sendXMLString(DSRequest dsRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        validationContext.freeResources();
        this.send(dsRequest, data);
    }

    public void sendSuccess(RPCRequest rpcRequest) throws Exception {
        RPCResponse rpcResponse = new RPCResponse("success");
        this.send(rpcRequest, rpcResponse);
    }

    public void sendFailure(Object request, String error) throws Exception {
        if (request instanceof DSRequest) {
            DSResponse dsResponse = new DSResponse(((DSRequest)request).getDataSource(), DSResponse.STATUS_FAILURE);
            dsResponse.setData(error);
            this.send((DSRequest)request, dsResponse);
        } else {
            RPCResponse rpcResponse = new RPCResponse(error);
            rpcResponse.setStatus(RPCResponse.STATUS_FAILURE);
            this.send((RPCRequest)request, rpcResponse);
        }
    }

    public void sendFailure(Object request, Throwable t) throws Exception {
        this.sendFailure(request, DataTools.getStackTrace(Reflection.getRealTargetException(t)));
    }

    public static Object filterDSResponseData(DSResponse dsResponse, DataSource ds) throws Exception {
        Map jsResponse = dsResponse.getJSResponse();
        Object data = jsResponse.get("data");
        if (ds == null || dsResponse.getBypassDataFilter().booleanValue()) {
            return data;
        }
        if (data instanceof JSONFilter) {
            IBeanFilter beanFilter = ((JSONFilter)data).getBeanFilter();
            if (beanFilter instanceof KeepPropertiesBeanFilter) {
                Collection propsToKeep = ((KeepPropertiesBeanFilter)beanFilter).getPropsToKeep();
                Object obj = ((JSONFilter)data).getObj();
                DataSourceBeanFilter newFilter = new DataSourceBeanFilter(ds, propsToKeep);
                return new JSONFilter(obj, newFilter);
            }
        } else {
            boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
            if (dsResponse.getDropExtraFields() != null) {
                dropExtraFields = dsResponse.getDropExtraFields();
                log.debug("DMI response, dropExtraFields: " + dropExtraFields);
            } else {
                if (ds.dropExtraFieldsDefined()) {
                    dropExtraFields = ds.dropExtraFields();
                }
                log.debug("non-DMI response, dropExtraFields: " + dropExtraFields);
            }
            return new JSONFilter(data, ds, dropExtraFields);
        }
        return data;
    }

    public static Object filterDSResponseData(DSRequest dsRequest, DSResponse dsResponse, DataSource ds) throws Exception {
        Map jsResponse = dsResponse.getJSResponse();
        Object data = jsResponse.get("data");
        if (ds == null || dsResponse.getBypassDataFilter().booleanValue()) {
            return data;
        }
        if (data instanceof JSONFilter) {
            return RPCManager.filterDSResponseData(dsResponse, ds);
        }
        boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
        if (dsResponse.getDropExtraFields() != null) {
            dropExtraFields = dsResponse.getDropExtraFields();
            log.debug("DMI response, dropExtraFields: " + dropExtraFields);
        } else {
            if (ds.dropExtraFieldsDefined()) {
                dropExtraFields = ds.dropExtraFields();
            }
            log.debug("non-DMI response, dropExtraFields: " + dropExtraFields);
        }
        DataSourceBeanFilter filter = new DataSourceBeanFilter(ds, dsRequest.getConsolidatedOutputs(), dsRequest.getDroppedFields(), dropExtraFields, true);
        return new JSONFilter(data, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeResponse() throws Exception {
        block156: {
            block153: {
                block152: {
                    block151: {
                        block150: {
                            block149: {
                                Iterator i5;
                                block148: {
                                    try {
                                        try {
                                            Writer out;
                                            block161: {
                                                ArrayList<Map> orderedResponseList;
                                                block159: {
                                                    ValidationContext vc;
                                                    DSRequest dsReq;
                                                    boolean isXMLHttp;
                                                    block155: {
                                                        JSTranslater jsTrans;
                                                        block160: {
                                                            block157: {
                                                                block158: {
                                                                    JSTranslater jsTrans2;
                                                                    Map opBinding;
                                                                    if (this.responseIsCustom) {
                                                                        Object var32_1 = null;
                                                                        i5 = this.requests.iterator();
                                                                        break block148;
                                                                    }
                                                                    if (this.isDownload) {
                                                                        Object binaryObj;
                                                                        String nativeName;
                                                                        String fileNameInURL;
                                                                        DSRequest dsRequest = (DSRequest)this.getRequests().get(0);
                                                                        String fileName = fileNameInURL = dsRequest.getDownloadFileName();
                                                                        String fieldName = dsRequest.getDownloadFieldName();
                                                                        DataSource ds = dsRequest.getDataSource();
                                                                        DSField field = ds.getField(fieldName);
                                                                        DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
                                                                        Object dataObj = dsResponse.getData();
                                                                        Map<String, Object> data = dsResponse.getRecord();
                                                                        if (data == null) {
                                                                            log.warn("dsResponse.getRecord() returned null when attempting to process a data member of type " + (dataObj == null ? "null" : dataObj.getClass().getName()) + ". Can't continue.");
                                                                            break block149;
                                                                        }
                                                                        String storedFileName = (String)data.get(fieldName + "_filename");
                                                                        String fieldMimeType = field.getMimeType();
                                                                        if (fieldMimeType != null) {
                                                                            this.context.setContentType(fieldMimeType);
                                                                        } else if ((this.context.requestPath.indexOf(".") == -1 || fileName == null) && storedFileName != null) {
                                                                            String mimeTypeForStoredFileName = DataTools.mimeTypeForFileName(storedFileName);
                                                                            if (mimeTypeForStoredFileName != null) {
                                                                                this.context.setContentType(mimeTypeForStoredFileName);
                                                                            }
                                                                        } else {
                                                                            String mimeType = ServletTools.mimeTypeForContext(this.context);
                                                                            this.context.setContentType(mimeType);
                                                                        }
                                                                        if (fileName == null) {
                                                                            fileName = storedFileName;
                                                                        }
                                                                        if ((nativeName = field.getNativeName()) == null) {
                                                                            nativeName = fieldName;
                                                                        }
                                                                        long contentLength = 0L;
                                                                        Object lengthObj = data.get(ds.getFilesizeField(nativeName));
                                                                        if (lengthObj != null) {
                                                                            contentLength = Long.valueOf(lengthObj.toString());
                                                                        }
                                                                        if (!ISCBinaryValue.isBinary(binaryObj = data.get(fieldName))) {
                                                                            log.warn("dsResponse.getData().get(\"" + fieldName + "\") returned " + (binaryObj == null ? "null" : " an instance of " + binaryObj.getClass().getName()) + " when we were expecting an InputStream, Byte[] or byte[]. Can't continue.");
                                                                            break block150;
                                                                        }
                                                                        if (dsRequest.getOperationType().equals("downloadFile")) {
                                                                            this.setContentDispositionHeader("attachment", fileNameInURL, fileName);
                                                                        } else {
                                                                            this.setContentDispositionHeader("inline", fileNameInURL, fileName);
                                                                        }
                                                                        if (contentLength > 0L) {
                                                                            this.context.response.setContentLength((int)contentLength);
                                                                        }
                                                                        ServletOutputStream os = this.context.response.getOutputStream();
                                                                        ISCBinaryValue.copyToOutputStream(binaryObj, (OutputStream)os);
                                                                        os.flush();
                                                                        break block151;
                                                                    }
                                                                    if (!this.isExport) break block157;
                                                                    DSRequest dsRequest = (DSRequest)this.getRequests().get(0);
                                                                    DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
                                                                    if (!(dsResponse.getExportAs() != null && dsResponse.getExportAs() != "" || !"json".equals(dsRequest.getExportAs()) || (opBinding = dsRequest.getDataSource().getOperationBinding(dsRequest)) != null && "json".equals(opBinding.get("exportAs")))) {
                                                                        String err = "For security reasons, client is not allowed to specify exportAs: 'json'.  Either use a different format or create an operationBinding that specifies exportAs: 'json' instead.";
                                                                        log.warn(err);
                                                                        this.context.out().write(err);
                                                                        break block152;
                                                                    }
                                                                    dsRequest.copyExportSettingsToResponse(dsResponse);
                                                                    if (dsResponse.getStatus() != DSResponse.STATUS_SUCCESS && !dsResponse.shouldExportToClient().booleanValue()) {
                                                                        jsTrans2 = JSTranslater.instance();
                                                                        jsTrans2.omitNullMapValues(this.omitNullMapValuesInResponse);
                                                                        jsTrans2.enablePrettyPrinting(this.prettyPrintResponse);
                                                                        jsTrans2.setObfuscation(false);
                                                                        jsTrans2 = this.setEnumProperties(jsTrans2);
                                                                        ValidationContext vc2 = new ValidationContext();
                                                                        vc2.setDSRequest(dsRequest);
                                                                        jsTrans2.setTypeLookupVC(vc2);
                                                                        ArrayList<Map> responseList = new ArrayList<Map>();
                                                                        responseList.add(dsResponse.getJSResponse());
                                                                        this.context.out().write(structuredRPCStart);
                                                                        jsTrans2.toJS(responseList, this.context.out());
                                                                        this.context.out().write(structuredRPCEnd);
                                                                        vc2.freeResources();
                                                                        break block153;
                                                                    }
                                                                    if (dsResponse.shouldExportToClient().booleanValue() || dsResponse.shouldExportToFilesystem().booleanValue() && dsResponse.getExportTo() == null) {
                                                                        String separator;
                                                                        String lineBreakStyle;
                                                                        String exportAs;
                                                                        List<Map> data = new ArrayList();
                                                                        Iterator iterator = null;
                                                                        Object initData = dsResponse.getData();
                                                                        if (initData instanceof List) {
                                                                            data = (List)initData;
                                                                        } else if (initData instanceof Map[]) {
                                                                            Map[] arr = (Map[])initData;
                                                                            data.addAll(Arrays.asList(arr));
                                                                        } else if (initData instanceof Iterator) {
                                                                            iterator = (Iterator)initData;
                                                                        } else {
                                                                            data.add((Map)initData);
                                                                        }
                                                                        HashMap<String, String> fieldMap = new HashMap<String, String>();
                                                                        DataSource ds = dsResponse.getDataSource() != null ? dsResponse.getDataSource() : dsRequest.getDataSource();
                                                                        List<String> fieldNames = ds != null ? ds.getFieldNames() : dsResponse.getExportFields();
                                                                        List<String> exportFields = dsResponse.getExportFields();
                                                                        if (exportFields == null) {
                                                                            exportFields = fieldNames;
                                                                        }
                                                                        Map exportFieldTitles = dsResponse.getExportFieldTitles();
                                                                        HashMap<String, String> exportOtherFields = (HashMap<String, String>)dsResponse.getParameter("exportOtherFields");
                                                                        if (exportOtherFields == null) {
                                                                            exportOtherFields = new HashMap<String, String>();
                                                                        }
                                                                        if ((exportAs = dsResponse.getExportAs()) != null) {
                                                                            exportAs = exportAs.toLowerCase();
                                                                        }
                                                                        if ((lineBreakStyle = dsResponse.getLineBreakStyle()) != null) {
                                                                            lineBreakStyle = lineBreakStyle.toLowerCase();
                                                                        }
                                                                        if ((separator = dsResponse.getExportTitleSeparatorChar()) == null) {
                                                                            separator = "";
                                                                        }
                                                                        boolean isExcelExport = "ooxml".equals(exportAs) || "xls".equals(exportAs);
                                                                        boolean isXMLExport = "xml".equals(exportAs);
                                                                        boolean isJSONExport = "json".equals(exportAs);
                                                                        for (int i2 = 0; i2 < exportFields.size(); ++i2) {
                                                                            String fieldName = exportFields.get(i2);
                                                                            String fieldTitle = null;
                                                                            fieldTitle = exportFieldTitles != null && exportFieldTitles.containsKey(fieldName) ? (String)exportFieldTitles.get(fieldName) : (String)exportOtherFields.get(fieldName);
                                                                            if (fieldTitle == null) {
                                                                                DSField field;
                                                                                fieldTitle = fieldName;
                                                                                if (ds != null && (field = ds.getField(fieldName)) != null && !field.getBoolean("hidden")) {
                                                                                    String string = fieldTitle = field.getProperty("exportTitle") != null ? field.getProperty("exportTitle") : field.getTitle();
                                                                                }
                                                                            }
                                                                            if (isXMLExport) {
                                                                                if (fieldTitle == null) {
                                                                                    fieldTitle = fieldName;
                                                                                }
                                                                                fieldTitle = fieldTitle.replaceAll("[$&<>()\"'\\n ]", separator);
                                                                            }
                                                                            if (isExcelExport) {
                                                                                fieldMap.put(fieldName, fieldName);
                                                                                exportOtherFields.put(fieldName, fieldTitle);
                                                                                continue;
                                                                            }
                                                                            fieldMap.put(fieldName, fieldTitle);
                                                                        }
                                                                        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
                                                                        settings.put("exportAs", exportAs);
                                                                        settings.put("lineBreakStyle", lineBreakStyle);
                                                                        settings.put("exportDelimiter", dsResponse.getExportDelimiter());
                                                                        settings.put("dataSource", ds);
                                                                        settings.put("exportFields", exportFields);
                                                                        settings.put("exportHeader", dsResponse.getExportHeader());
                                                                        settings.put("exportHeaderless", dsResponse.getExportHeaderless());
                                                                        settings.put("exportFooter", dsResponse.getExportFooter());
                                                                        settings.put("exportOtherFields", exportOtherFields);
                                                                        settings.put("exportDatesAsFormattedString", dsResponse.getExportDatesAsFormattedString());
                                                                        settings.put("formulaFields", dsResponse.getParameter("formulaFields"));
                                                                        settings.put("formulaRemap", dsResponse.getParameter("formulaRemap"));
                                                                        settings.put("exportDefaultBGColor", dsResponse.getParameter("exportDefaultBGColor"));
                                                                        settings.put("exportAlternateRowBGColor", dsResponse.getParameter("exportAlternateRowBGColor"));
                                                                        settings.put("exportRowBGColors", dsResponse.getParameter("exportRowBGColors"));
                                                                        settings.put("exportColumnBGColors", dsResponse.getParameter("exportColumnBGColors"));
                                                                        settings.put("exportRawValues", dsResponse.getParameter("exportRawValues"));
                                                                        settings.put("exportCurrencySymbol", dsResponse.getParameter("exportCurrencySymbol"));
                                                                        settings.put("exportHeaderHeight", dsResponse.getParameter("exportHeaderHeight"));
                                                                        settings.put("exportHeaderSpans", dsResponse.getParameter("exportHeaderSpans"));
                                                                        settings.put("exportFieldPixelWidths", dsResponse.getParameter("exportFieldPixelWidths"));
                                                                        settings.put("exportWidthScale", dsResponse.getParameter("exportWidthScale"));
                                                                        settings.put("exportWrapHeaderTitles", dsResponse.getParameter("exportWrapHeaderTitles"));
                                                                        settings.put("exportAlignments", dsResponse.getParameter("exportAlignments"));
                                                                        settings.put("exportStreaming", dsResponse.getParameter("exportStreaming"));
                                                                        settings.put("exportPropertyIdentifier", dsResponse.getParameter("exportPropertyIdentifier"));
                                                                        if (dsRequest.getValues(false) != null && dsRequest.getValues(false).size() != 0) {
                                                                            settings.put("useTitlesAsAttributeNames", true);
                                                                        } else {
                                                                            settings.put("useTitlesAsAttributeNames", false);
                                                                        }
                                                                        DataExport de = DataExport.getDataExport(settings, dsRequest);
                                                                        OutputStream os1 = null;
                                                                        BufferedOutputStream os2 = null;
                                                                        String fileName = dsResponse.getExportFilename();
                                                                        if (fileName == null) {
                                                                            fileName = "export";
                                                                        }
                                                                        if (fileName.indexOf(".") == -1) {
                                                                            fileName = fileName + "." + ("ooxml".equals(exportAs) ? "xlsx" : exportAs);
                                                                        }
                                                                        String qname = config.getPath("export.location");
                                                                        if (!config.getBoolean((Object)"export.allow.filesystem", false) && dsResponse.shouldExportToFilesystem().booleanValue()) {
                                                                            log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                                                                            dsResponse.setExportToFilesystem(false);
                                                                        } else if (dsResponse.shouldExportToFilesystem().booleanValue()) {
                                                                            String path;
                                                                            if (qname == null) {
                                                                                qname = "";
                                                                            }
                                                                            if (!qname.endsWith("/") && qname.length() > 0) {
                                                                                qname = qname + "/";
                                                                            }
                                                                            if ((path = dsResponse.getExportPath()) != null) {
                                                                                qname = qname + path;
                                                                            }
                                                                            if (!qname.endsWith("/") && qname.length() > 0) {
                                                                                qname = qname + "/";
                                                                            }
                                                                            if (fileName != null) {
                                                                                qname = qname + fileName;
                                                                            }
                                                                            os1 = new BufferedOutputStream(new FileOutputStream(qname));
                                                                        }
                                                                        if (dsRequest.shouldExportToClient()) {
                                                                            String fileNameEncoding = this.encodeParameter("fileName", fileName);
                                                                            if (dsResponse.getExportDisplay().equals("download")) {
                                                                                this.setContentDispositionHeader("attachment", dsResponse.getExportFilename(), fileName);
                                                                                this.context.setContentType(DataExport.getMimeTypeForFormat(exportAs));
                                                                            } else {
                                                                                this.setContentDispositionHeader("inline", dsResponse.getExportFilename(), fileName);
                                                                            }
                                                                            if (os1 == null) {
                                                                                os1 = new BufferedOutputStream((OutputStream)this.context.response.getOutputStream());
                                                                            } else {
                                                                                os2 = new BufferedOutputStream((OutputStream)this.context.response.getOutputStream());
                                                                            }
                                                                        }
                                                                        if (iterator == null) {
                                                                            iterator = data.iterator();
                                                                        }
                                                                        int contentLength = de.exportResultSet(iterator, fieldMap, os1, os2, dsResponse);
                                                                        if (dsResponse.shouldExportToFilesystem().booleanValue() && os1 != null) {
                                                                            os1.flush();
                                                                            os1.close();
                                                                        }
                                                                        if (!dsRequest.shouldExportToClient() && !dsRequest.getExportObjectCalled()) {
                                                                            JSTranslater jsTrans3 = JSTranslater.instance();
                                                                            jsTrans3.omitNullMapValues(this.omitNullMapValuesInResponse);
                                                                            jsTrans3.enablePrettyPrinting(this.prettyPrintResponse);
                                                                            jsTrans3.setObfuscation(false);
                                                                            jsTrans3 = this.setEnumProperties(jsTrans3);
                                                                            ValidationContext vc3 = new ValidationContext();
                                                                            vc3.setDSRequest(dsRequest);
                                                                            jsTrans3.setTypeLookupVC(vc3);
                                                                            DSResponse clientResponse = new DSResponse();
                                                                            clientResponse.setStatus(DSResponse.STATUS_SUCCESS);
                                                                            if (dsResponse.shouldExportToFilesystem().booleanValue()) {
                                                                                clientResponse.setData("Successfully exported " + qname);
                                                                            }
                                                                            ArrayList<Map> responseList = new ArrayList<Map>();
                                                                            responseList.add(clientResponse.getJSResponse());
                                                                            this.context.out().write(structuredRPCStart);
                                                                            jsTrans3.toJS(responseList, this.context.out());
                                                                            this.context.out().write(structuredRPCEnd);
                                                                            vc3.freeResources();
                                                                        }
                                                                    } else if (dsResponse.shouldSendExportResponse().booleanValue()) {
                                                                        jsTrans2 = JSTranslater.instance();
                                                                        jsTrans2.omitNullMapValues(this.omitNullMapValuesInResponse);
                                                                        jsTrans2.enablePrettyPrinting(this.prettyPrintResponse);
                                                                        jsTrans2.setObfuscation(false);
                                                                        jsTrans2 = this.setEnumProperties(jsTrans2);
                                                                        ValidationContext vc4 = new ValidationContext();
                                                                        vc4.setDSRequest(dsRequest);
                                                                        jsTrans2.setTypeLookupVC(vc4);
                                                                        DSResponse clientResponse = new DSResponse();
                                                                        clientResponse.setStatus(DSResponse.STATUS_SUCCESS);
                                                                        clientResponse.setData(dsResponse.getData());
                                                                        ArrayList<Map> responseList = new ArrayList<Map>();
                                                                        responseList.add(clientResponse.getJSResponse());
                                                                        this.context.out().write(structuredRPCStart);
                                                                        jsTrans2.toJS(responseList, this.context.out());
                                                                        this.context.out().write(structuredRPCEnd);
                                                                        vc4.freeResources();
                                                                    }
                                                                    if (dsRequest.shouldExportToClient()) break block158;
                                                                    if (dsRequest.sendRegularDSResponse()) break block157;
                                                                }
                                                                Object var32_7 = null;
                                                                for (Object request : this.requests) {
                                                                    if (!(request instanceof DSRequest)) continue;
                                                                    DSRequest dsRequest = (DSRequest)request;
                                                                    if (!dsRequest.getFreeOnExecute()) {
                                                                        dsRequest.freeResources();
                                                                    }
                                                                    dsRequest.freeQueueResources();
                                                                }
                                                                this.freeRPCResources();
                                                                return;
                                                            }
                                                            isXMLHttp = this.context.response != null && RPCManager.isXmlHttp((HttpServletRequest)this.context.request);
                                                            try {
                                                                this.context.setNoCacheHeaders();
                                                            }
                                                            catch (Exception e) {
                                                                log.warn(e.toString());
                                                            }
                                                            try {
                                                                String contentType;
                                                                String string = contentType = isXMLHttp ? "text/plain" : "text/html";
                                                                if (this.charset != null && !this.charset.trim().equals("") && !this.charset.toLowerCase().equals("none")) {
                                                                    contentType = contentType + "; charset=" + this.charset;
                                                                }
                                                                this.context.setContentType(contentType);
                                                                log.debug("Content type for RPC transaction: " + contentType);
                                                            }
                                                            catch (Exception e) {
                                                                log.warn(e.toString());
                                                            }
                                                            out = config.getBoolean((Object)"IDACall.showClientOutput", false) && (this.getDSRequest(true) == null || !this.getDSRequest(true).shouldStreamResults()) ? new StringWriter() : this.context.out();
                                                            boolean failure = this.queueHasFailures();
                                                            boolean partialCommit = false;
                                                            try {
                                                                if (failure) {
                                                                    this.onFailure();
                                                                } else {
                                                                    this.onSuccess();
                                                                }
                                                            }
                                                            catch (PartialCommitException pce) {
                                                                partialCommit = true;
                                                            }
                                                            catch (Exception e) {
                                                                log.warn(DataTools.getStackTrace(Reflection.getRealTargetException(e)));
                                                            }
                                                            long rpcCompletionTimestamp = System.currentTimeMillis();
                                                            orderedResponseList = new ArrayList<Map>();
                                                            for (Object request : this.requests) {
                                                                Map timing;
                                                                Object response = this.responseMap.get(request);
                                                                if (response == null) {
                                                                    throw new Exception("No response for request: " + request.toString());
                                                                }
                                                                if (response instanceof RPCResponse) {
                                                                    HashMap<String, Object> payload = new HashMap<String, Object>();
                                                                    payload.put("data", ((RPCResponse)response).getData());
                                                                    payload.put("status", new Integer(((RPCResponse)response).getStatus()));
                                                                    if (((RPCResponse)response).getStacktrace() != null) {
                                                                        payload.put("stacktrace", ((RPCResponse)response).getStacktrace());
                                                                    }
                                                                    orderedResponseList.add(payload);
                                                                    if (((RPCResponse)response).getStatus() >= 0) continue;
                                                                    failure = true;
                                                                    continue;
                                                                }
                                                                if (!(response instanceof DSResponse)) continue;
                                                                DSResponse dsResponse = (DSResponse)response;
                                                                if (dsResponse.wantsConnectionClosed()) {
                                                                    this.closeConnection = true;
                                                                }
                                                                if (dsResponse.getStatus() < 0) {
                                                                    failure = true;
                                                                }
                                                                Map jsResponse = dsResponse.getJSResponse(true);
                                                                DSRequest dsRequest = (DSRequest)request;
                                                                String dsName = dsRequest.getDataSourceName();
                                                                DataSource ds = dsRequest.getDataSource();
                                                                if (ds != null) {
                                                                    Object data = RPCManager.filterDSResponseData(dsRequest, dsResponse, ds);
                                                                    jsResponse.put("data", data);
                                                                }
                                                                if (dsRequest.trackTimings() && (timing = (Map)jsResponse.get("timing")) != null) {
                                                                    List topLevelChildren = (List)timing.get("children");
                                                                    if (topLevelChildren != null) {
                                                                        for (int k = 0; k < topLevelChildren.size(); ++k) {
                                                                            Map entry = (Map)topLevelChildren.get(k);
                                                                            if (!"RPCManager processing".equals(entry.get("name"))) continue;
                                                                            entry.put("end", rpcCompletionTimestamp);
                                                                            break;
                                                                        }
                                                                    }
                                                                    LinkedMap serialize = new LinkedMap();
                                                                    serialize.put("name", "DSResponse serialization");
                                                                    serialize.put("start", rpcCompletionTimestamp);
                                                                    serialize.put("end", new CurrentMillisMarker());
                                                                    topLevelChildren.add(serialize);
                                                                    timing.put("end", new CurrentMillisMarker());
                                                                }
                                                                orderedResponseList.add(jsResponse);
                                                            }
                                                            dsReq = this.getDSRequest(true);
                                                            if (!isXMLHttp && !this.isREST(dsReq)) break block159;
                                                            if (this.isREST(dsReq)) {
                                                                if (this.jsCallback != null) {
                                                                    RPCManager.writeIframePrefix(out, this, null, null);
                                                                }
                                                                if (!isXMLHttp && dsReq.getWrapJSONResponses().booleanValue() && "json".equalsIgnoreCase(dsReq.getDataFormat())) {
                                                                    out.write(dsReq.getJsonPrefix());
                                                                }
                                                            } else {
                                                                out.write(structuredRPCStart);
                                                            }
                                                            jsTrans = JSTranslater.instance();
                                                            jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
                                                            jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
                                                            jsTrans.setObfuscation(false);
                                                            jsTrans = this.setEnumProperties(jsTrans);
                                                            vc = new ValidationContext();
                                                            vc.setDSRequest(dsReq);
                                                            vc.setEncodeBinaryFields(true);
                                                            jsTrans.setTypeLookupVC(vc);
                                                            Boolean trimMillis = null;
                                                            if (dsReq != null && dsReq.getDataSource() != null && dsReq.getDataSource().getConfig().containsKey("trimMilliseconds")) {
                                                                trimMillis = DataTools.getBooleanObject(dsReq.getDataSource().getConfig(), "trimMilliseconds");
                                                                jsTrans.setTrimMilliseconds(trimMillis);
                                                            }
                                                            if (!this.isREST(dsReq)) break block160;
                                                            jsTrans.strictJSONMode();
                                                            jsTrans.setWriteXMLSchemaDate(true);
                                                            if (trimMillis == null) {
                                                                trimMillis = config.getBoolean((Object)"rest.trimMilliseconds", false);
                                                                jsTrans.setTrimMilliseconds(trimMillis);
                                                            }
                                                            if ("json".equalsIgnoreCase(dsReq.getDataFormat())) {
                                                                if (orderedResponseList.size() > 1) {
                                                                    ArrayList<LinkedMap> restList = new ArrayList<LinkedMap>();
                                                                    for (int i3 = 0; i3 < orderedResponseList.size(); ++i3) {
                                                                        LinkedMap restContainer = new LinkedMap();
                                                                        restContainer.put("response", orderedResponseList.get(i3));
                                                                        restList.add(restContainer);
                                                                    }
                                                                    jsTrans.toJS(restList, out);
                                                                    break block155;
                                                                } else {
                                                                    LinkedMap restContainer = new LinkedMap();
                                                                    restContainer.put("response", orderedResponseList.get(0));
                                                                    jsTrans.toJS(restContainer, out);
                                                                }
                                                                break block155;
                                                            } else {
                                                                StringWriter sw = new StringWriter();
                                                                sw.write("<?xml version=\"1.0\"?>\n");
                                                                if (orderedResponseList.size() > 1) {
                                                                    sw.write("<responses>\n");
                                                                }
                                                                for (int i4 = 0; i4 < this.requests.size(); ++i4) {
                                                                    dsReq = (DSRequest)this.requests.get(i4);
                                                                    DSResponse response = (DSResponse)this.responseMap.get(dsReq);
                                                                    response.setDataSource(dsReq.getDataSource());
                                                                    sw.write("<response>\n");
                                                                    sw.write("<status>" + response.getStatus() + "</status>\n");
                                                                    Object queueStatus = response.getProperty("queueStatus");
                                                                    if (queueStatus != null) {
                                                                        sw.write("<queueStatus>" + queueStatus + "</queueStatus>");
                                                                    }
                                                                    if (response.statusIsSuccess()) {
                                                                        sw.write("<startRow>" + response.getStartRow() + "</startRow>\n");
                                                                        sw.write("<endRow>" + response.getEndRow() + "</endRow>\n");
                                                                        sw.write("<totalRows>" + response.getTotalRows() + "</totalRows>\n");
                                                                        for (String propKey : response.getSetPropsList()) {
                                                                            String strValue;
                                                                            Object value = response.getProperty(propKey);
                                                                            if (value instanceof Boolean || value instanceof Number) {
                                                                                strValue = value.toString();
                                                                            } else if (value instanceof String) {
                                                                                strValue = XML.quoteXMLString((String)value, false);
                                                                            } else if (value instanceof ISCDate) {
                                                                                strValue = new SimpleDateFormat("yyyy-MM-dd").format((ISCDate)value);
                                                                            } else if (value instanceof ISCTime) {
                                                                                strValue = new SimpleDateFormat("HH:mm:ss").format((ISCTime)value);
                                                                            } else if (value instanceof Date) {
                                                                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                                                                                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                                                                                strValue = sdf.format((Date)value);
                                                                            } else {
                                                                                strValue = "Invalid value type: " + value.getClass().getName();
                                                                            }
                                                                            sw.write("<" + propKey + ">" + strValue + "</" + propKey + ">");
                                                                        }
                                                                        sw.write("<data>\n");
                                                                        Object data = response.getData();
                                                                        XML.recordsToXML("record", response.getRecords(vc), sw, false, dsReq);
                                                                        sw.write("</data>\n");
                                                                    } else {
                                                                        XML.recordToXML("errors", (Map)((Object)response.getErrorReport()), sw, false, dsReq);
                                                                    }
                                                                    sw.write("</response>\n");
                                                                }
                                                                if (orderedResponseList.size() > 1) {
                                                                    sw.write("</responses>");
                                                                }
                                                                out.write(sw.toString());
                                                            }
                                                            break block155;
                                                        }
                                                        if (dsReq != null && dsReq.getUseStrictJSON()) {
                                                            jsTrans.strictJSONMode();
                                                        }
                                                        jsTrans.toJS(orderedResponseList, out);
                                                    }
                                                    vc.freeResources();
                                                    if (this.isREST(dsReq)) {
                                                        if (!isXMLHttp && dsReq.getWrapJSONResponses().booleanValue() && "json".equalsIgnoreCase(dsReq.getDataFormat())) {
                                                            out.write(dsReq.getJsonSuffix());
                                                        }
                                                        if ("json".equalsIgnoreCase(dsReq.getDataFormat())) {
                                                            this.context.setContentType("application/json", true);
                                                        } else {
                                                            this.context.setContentType("text/xml", true);
                                                        }
                                                        if (this.jsCallback != null) {
                                                            this.context.setContentType("text/html", true);
                                                            RPCManager.writeIframePostfix(out);
                                                        }
                                                        break block161;
                                                    } else {
                                                        out.write(structuredRPCEnd);
                                                    }
                                                    break block161;
                                                }
                                                this.iframeWrite(out, true, orderedResponseList);
                                            }
                                            out.flush();
                                            if (out instanceof StringWriter) {
                                                String output = out.toString();
                                                int outputSize = output.length();
                                                log.debug("Uncompressed result size: " + outputSize + " bytes");
                                                this.context.out().write(output);
                                                this.context.out().flush();
                                                if (config.getBoolean((Object)"devenv", false)) {
                                                    log.debug((Object)"Output to client", output);
                                                }
                                            }
                                            this.context.completeResponse();
                                            break block156;
                                        }
                                        catch (Exception e) {
                                            try {
                                                try {
                                                    this.onFailure();
                                                }
                                                catch (Exception e2) {
                                                    log.warn(DataTools.getStackTrace(Reflection.getRealTargetException(e2)));
                                                    Object var30_107 = null;
                                                    throw e;
                                                }
                                                Object var30_106 = null;
                                                throw e;
                                            }
                                            catch (Throwable throwable) {
                                                Object var30_108 = null;
                                                throw e;
                                            }
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var32_9 = null;
                                        Iterator i5 = this.requests.iterator();
                                        while (true) {
                                            if (!i5.hasNext()) {
                                                this.freeRPCResources();
                                                throw throwable;
                                            }
                                            Object request = i5.next();
                                            if (!(request instanceof DSRequest)) continue;
                                            DSRequest dsRequest = (DSRequest)request;
                                            if (!dsRequest.getFreeOnExecute()) {
                                                dsRequest.freeResources();
                                            }
                                            dsRequest.freeQueueResources();
                                        }
                                    }
                                }
                                while (i5.hasNext()) {
                                    Object request = i5.next();
                                    if (!(request instanceof DSRequest)) continue;
                                    DSRequest dsRequest = (DSRequest)request;
                                    if (!dsRequest.getFreeOnExecute()) {
                                        dsRequest.freeResources();
                                    }
                                    dsRequest.freeQueueResources();
                                }
                                this.freeRPCResources();
                                return;
                            }
                            Object var32_2 = null;
                            for (Object request : this.requests) {
                                if (!(request instanceof DSRequest)) continue;
                                DSRequest dsRequest = (DSRequest)request;
                                if (!dsRequest.getFreeOnExecute()) {
                                    dsRequest.freeResources();
                                }
                                dsRequest.freeQueueResources();
                            }
                            this.freeRPCResources();
                            return;
                        }
                        Object var32_3 = null;
                        for (Object request : this.requests) {
                            if (!(request instanceof DSRequest)) continue;
                            DSRequest dsRequest = (DSRequest)request;
                            if (!dsRequest.getFreeOnExecute()) {
                                dsRequest.freeResources();
                            }
                            dsRequest.freeQueueResources();
                        }
                        this.freeRPCResources();
                        return;
                    }
                    Object var32_4 = null;
                    for (Object request : this.requests) {
                        if (!(request instanceof DSRequest)) continue;
                        DSRequest dsRequest = (DSRequest)request;
                        if (!dsRequest.getFreeOnExecute()) {
                            dsRequest.freeResources();
                        }
                        dsRequest.freeQueueResources();
                    }
                    this.freeRPCResources();
                    return;
                }
                Object var32_5 = null;
                for (Object request : this.requests) {
                    if (!(request instanceof DSRequest)) continue;
                    DSRequest dsRequest = (DSRequest)request;
                    if (!dsRequest.getFreeOnExecute()) {
                        dsRequest.freeResources();
                    }
                    dsRequest.freeQueueResources();
                }
                this.freeRPCResources();
                return;
            }
            Object var32_6 = null;
            for (Object request : this.requests) {
                if (!(request instanceof DSRequest)) continue;
                DSRequest dsRequest = (DSRequest)request;
                if (!dsRequest.getFreeOnExecute()) {
                    dsRequest.freeResources();
                }
                dsRequest.freeQueueResources();
            }
            this.freeRPCResources();
            return;
        }
        Object var32_8 = null;
        for (Object request : this.requests) {
            if (!(request instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)request;
            if (!dsRequest.getFreeOnExecute()) {
                dsRequest.freeResources();
            }
            dsRequest.freeQueueResources();
        }
        this.freeRPCResources();
    }

    protected void freeRPCResources() {
        for (DSRequest associatedRequest : this.associatedRequests) {
            if (this.requests.contains(associatedRequest)) continue;
            associatedRequest.freeResources();
            associatedRequest.freeQueueResources();
        }
    }

    public boolean queueHasFailures() {
        for (Object req : this.requests) {
            Object resp = this.responseMap.get(req);
            if (resp instanceof RPCResponse && ((RPCResponse)resp).getStatus() < 0) {
                return true;
            }
            if (!(resp instanceof DSResponse) || ((DSResponse)resp).getStatus() >= 0) continue;
            return true;
        }
        return false;
    }

    protected void onFailure() throws Exception {
        this.onFailure(null);
    }

    protected void onFailure(DataSource testDS) throws Exception {
        boolean transactionalFailure = false;
        for (Object obj : this.requests) {
            if (!(obj instanceof DSRequest)) continue;
            DSRequest req = (DSRequest)obj;
            BasicDataSource ds = (BasicDataSource)req.getDataSource();
            if (testDS != null && ds != null && !ds.getName().equals(testDS.getName())) continue;
            DSResponse resp = this.getResponse((DSRequest)obj);
            if (testDS == null && (resp == null || resp.getStatus() >= 0)) continue;
            if (req.isPartOfTransaction()) {
                transactionalFailure = true;
                break;
            }
            if (req.isPartOfTransactionKnown() || ds == null || !ds.shouldAutoJoinTransaction(req) || !ds.shouldAutoStartTransaction(req, true) && !this.requestQueueIncludesPriorUpdate(req)) continue;
            transactionalFailure = true;
            break;
        }
        for (Object obj : this.requests) {
            Object trxObj2;
            Object trxObj1;
            if (!(obj instanceof DSRequest)) continue;
            DSResponse resp = this.getResponse((DSRequest)obj);
            resp.setProperty("queueStatus", -1);
            if (!transactionalFailure) continue;
            DSRequest req = (DSRequest)obj;
            if (testDS != null && testDS instanceof BasicDataSource && req.getDataSource() instanceof BasicDataSource && (trxObj1 = ((BasicDataSource)testDS).getTransactionObject(req)) != (trxObj2 = ((BasicDataSource)req.getDataSource()).getTransactionObject(req)) || !req.isPartOfTransaction() || resp == null || resp.getStatus() != DSResponse.STATUS_SUCCESS) continue;
            resp.setStatus(-10);
        }
        ArrayList list = new ArrayList();
        int dsPosition = 0;
        for (Object obj : this.callbacks) {
            if (obj instanceof DataSource) {
                list.add(dsPosition++, obj);
                continue;
            }
            list.add(obj);
        }
        for (RPCManagerCompletionCallback callback : list) {
            if (testDS != null && callback instanceof DataSource && !((DataSource)((Object)callback)).getName().equals(testDS.getName())) continue;
            try {
                callback.onFailure(this, transactionalFailure);
            }
            catch (Exception e) {
                if (testDS == null) {
                    log.warn((Object)"Exception thrown during onFailure processing", e);
                    continue;
                }
                throw e;
            }
        }
    }

    protected void onSuccess() throws Exception {
        for (Object requestObj : this.requests) {
            if (!(requestObj instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)requestObj;
            DSResponse dsResponse = this.getResponse(dsRequest);
            dsResponse.setProperty("queueStatus", 0);
        }
        ArrayList<String> partialCommits = new ArrayList<String>();
        ArrayList list = new ArrayList();
        int dsPosition = 0;
        for (Object obj : this.callbacks) {
            if (obj instanceof DataSource) {
                list.add(dsPosition++, obj);
                continue;
            }
            list.add(obj);
        }
        for (RPCManagerCompletionCallback callback : list) {
            try {
                callback.onSuccess(this);
            }
            catch (Exception e) {
                String warning = "Exception thrown during onSuccess processing in class " + callback.getClass().getName();
                if (callback instanceof DataSource) {
                    warning = warning + " (DataSource " + ((DataSource)((Object)callback)).getName() + ")" + " - changes might not have been committed";
                    partialCommits.add("DataSource " + ((DataSource)((Object)callback)).getName());
                    log.warn((Object)warning, e);
                    try {
                        this.onFailure((DataSource)((Object)callback));
                    }
                    catch (Exception e2) {
                        log.warn((Object)"Exception thrown during onFailure processing invoked to handle a failure detected during onSuccess", e2);
                    }
                    continue;
                }
                partialCommits.add(callback.getClass().getName());
                log.warn((Object)warning, e);
            }
        }
        if (partialCommits.size() > 0) {
            throw new PartialCommitException("Some callbacks failed during onSuccess processing - changes might not have been committed.  Failing classes: " + ((Object)partialCommits).toString());
        }
    }

    public void encodeBinaryStreams() throws Exception {
        for (Object request : this.requests) {
            if (!(request instanceof DSRequest)) continue;
            DSResponse resp = this.getResponse((DSRequest)request);
            DataSource ds = resp.getDataSource();
            List data = null;
            if (ds == null) continue;
            List fields = ds.getFields();
            for (DSField field : fields) {
                if (field == null || !field.shouldEncodeInResponse()) continue;
                if (data == null) {
                    data = resp.getRecords();
                }
                for (Map record : data) {
                    String encoded;
                    if (record == null) continue;
                    Object value = record.get(field.getName());
                    if (value instanceof File) {
                        value = new FileInputStream((File)value);
                    }
                    if (value instanceof InputStream) {
                        encoded = DataTools.base64Encode((InputStream)value);
                        record.put(field.getName(), encoded);
                        continue;
                    }
                    if (!(value instanceof byte[])) continue;
                    encoded = DataTools.base64Encode((byte[])value);
                    record.put(field.getName(), encoded);
                }
            }
        }
    }

    public DSResponse getResponse(DSRequest req) {
        Object resp = this.responseMap.get(req);
        if (resp instanceof DSResponse) {
            return (DSResponse)resp;
        }
        return null;
    }

    public DSResponse findLastResponse(String dsName, String opType) {
        return this.findResponse("last", dsName, opType);
    }

    public DSResponse findFirstResponse(String dsName, String opType) {
        return this.findResponse("first", dsName, opType);
    }

    public RPCResponse getResponse(RPCRequest req) {
        Object resp = this.responseMap.get(req);
        if (resp instanceof RPCResponse) {
            return (RPCResponse)resp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSTranslater setEnumProperties(JSTranslater jsTrans) throws Exception {
        Object requestObj = null;
        for (int i = 0; i < this.requests.size() && !(requestObj instanceof DSRequest); ++i) {
            requestObj = this.requests.get(i);
        }
        if (!(requestObj instanceof DSRequest)) return jsTrans;
        String dsName = ((DSRequest)requestObj).getDataSourceName();
        if (dsName == null) {
            return jsTrans;
        }
        DataSource ds = ((DSRequest)requestObj).getDataSource();
        boolean freeDS = false;
        if (ds == null) {
            ds = DataSourceManager.getDataSource(dsName, requestObj);
            freeDS = true;
        }
        if (ds == null) {
            return jsTrans;
        }
        try {
            jsTrans.setEnumTranslateStrategy(ds.getEnumTranslateStrategy());
            jsTrans.setEnumOrdinalProperty(ds.getEnumOrdinalProperty());
            jsTrans.setEnumConstantProperty(ds.getEnumConstantProperty());
            Object var7_7 = null;
            if (!freeDS) return jsTrans;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!freeDS) throw throwable;
            DataSourceManager.freeDataSource(ds);
            throw throwable;
        }
        DataSourceManager.freeDataSource(ds);
        return jsTrans;
    }

    public String encodeURIComponent(String s) {
        String result;
        try {
            if (s == null) {
                s = "";
            }
            result = URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    public void setContentDispositionHeader(String contentDisposition, String fileNameInURL, String fallbackFileName) {
        String fileNameEncoding = "";
        if (!config.getBoolean((Object)"RPCManager.downloadsRelyOnFilenameInURL", true) || fileNameInURL == null) {
            fileNameEncoding = this.encodeFilename(fileNameInURL != null ? fileNameInURL : fallbackFileName);
        }
        this.context.response.addHeader("content-disposition", contentDisposition + "; " + fileNameEncoding);
    }

    public String encodeFilename(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        String fileNameEncoding = "filename=\"" + fileName + "\"";
        fileNameEncoding = fileNameEncoding + "; filename*=UTF-8''" + this.encodeURIComponent(fileName);
        return fileNameEncoding;
    }

    public String encodeParameter(String name, String value) {
        Pattern tspecials = Pattern.compile("[<()@,;:/?={} >\"\\[\\]\\t\\\\]");
        Matcher matcher = tspecials.matcher(value);
        if (value.length() <= 78) {
            if (!matcher.find()) {
                return name + "=" + value;
            }
            return name + "=" + "\"" + value + "\"";
        }
        return name + "=" + "\"" + value + "\"";
    }

    private void iframeWrite(Writer out, boolean structured, Object data) throws IOException, UnconvertableException {
        RPCManager.writeIframePrefix(out, this, null, null);
        if (structured) {
            out.write(structuredRPCStart);
        }
        JSTranslater jsTrans = new JSTranslater();
        jsTrans.quoteForTextArea();
        jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
        jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
        jsTrans.setObfuscation(false);
        try {
            jsTrans = this.setEnumProperties(jsTrans);
        }
        catch (Exception e) {
            UnconvertableException uce = new UnconvertableException();
            uce.initCause(e);
            throw uce;
        }
        jsTrans.toJS(data, out);
        if (structured) {
            out.write(structuredRPCEnd);
        }
        RPCManager.writeIframePostfix(out);
    }

    private void writeCustomIFramePrefix(Writer out) throws IOException {
        if (this.customHTML != null) {
            out.write(this.customHTML);
        }
    }

    public static void writeIframePostfix(Writer out) throws IOException {
        out.write("</TEXTAREA>");
        out.write("</FORM>\n");
        out.write("</BODY></HTML>");
    }

    public static void writeIframePrefix(Writer out, RPCManager rpc, RequestContext context, String jsCallback) throws IOException {
        if (context == null && rpc != null) {
            context = rpc.getContext();
        }
        if (jsCallback == null && rpc != null) {
            jsCallback = rpc.jsCallback;
        }
        out.write("<HTML>\n");
        RPCManager.writeDocumentDomain(out, context);
        if (rpc != null) {
            rpc.writeCustomIFramePrefix(out);
        }
        out.write("<BODY ONLOAD='var results = document.formResults.results.value;" + jsCallback + "'>");
        out.write("<BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR>");
        out.write("<FORM name='formResults'><TEXTAREA readonly name='results'>\n");
    }

    private void parseRequest() throws Exception {
        Object operationData;
        if (!RPCManager.isRPC((HttpServletRequest)this.context.request)) {
            throw new Exception("Non-RPC request ignored.");
        }
        String clientVersion = RPCManager.getClientVersion((HttpServletRequest)this.context.request);
        if (!(this.devenv || clientVersion != null && this.serverVersion.equals(clientVersion))) {
            if (clientVersion == null) {
                clientVersion = "pre-5.5b2";
            }
            log.warn("client/server version mismatch.  Client is version: " + clientVersion + ", server is version: " + this.serverVersion + " - mixing different client/server versions is generally not supported." + "  If you've installed a more recent client version, try clearing" + " the browser cache and reloading the page.");
        }
        Map queryParamsMap = new HashMap();
        try {
            queryParamsMap = ServletTools.parseQueryString(this.context.request.getQueryString());
        }
        catch (Exception e) {
            log.error((Object)"caught exception parsing queryParams", e);
        }
        String rawTransactionData = (String)queryParamsMap.get("_transaction");
        if (rawTransactionData == null) {
            rawTransactionData = this.context.request.getParameter("_transaction");
        }
        if (rawTransactionData == null || rawTransactionData.equals("")) {
            String logMessage = "Unexpected empty RPCManager transaction: POST'd data appears to have been removed from the request before the server framework received it. This may be due to application / server settings restricting maximum POST / file upload size, or due to security software on your server, browser or network that erroneously blocked the request, or due to bugs in servlet filters.  ";
            Writer out = this.context.out();
            ServletTools.sendHTMLStart(out);
            RPCManager.writeDocumentDomain(out, this.context);
            out.write("<SCRIPT>");
            if (RPCManager.isXmlHttp((HttpServletRequest)this.context.request) || "1".equals(queryParamsMap.get("isc_resubmit"))) {
                log.warn(logMessage + "Please see the documentation for isc.RPCResponse.STATUS_MAX_POST_SIZE_EXCEEDED");
                out.write("parent.isc.RPCManager.handleMaxPostSizeExceeded(window.name);");
            } else {
                String tnum = this.context.request.getQueryParameter("isc_tnum");
                if (this.context.request.isAborted()) {
                    log.warn((Object)("Transaction " + tnum + " aborted.  Caused by: "), this.context.request.getAbortReason());
                    out.write("parent.isc.RPCManager.handleRequestAborted(" + tnum + ");");
                } else {
                    logMessage.concat("Attempting to ask browser to retry transaction " + tnum + ".");
                    out.write("parent.isc.RPCManager.retryOperation(window.name);");
                }
                log.warn(logMessage);
            }
            out.write("</SCRIPT>");
            ServletTools.sendHTMLEnd(out);
            out.flush();
            this.context.response.flushBuffer();
            throw new ClientMustResubmitException("");
        }
        Object transactionData = null;
        if (rawTransactionData.trim().startsWith("{")) {
            transactionData = JSTranslater.instance().fromJS(rawTransactionData);
        } else {
            ValidationContext validationContext = new ValidationContext();
            validationContext.setRestrictedXMLMode(true);
            transactionData = XML.toDSRecords(new StringReader(rawTransactionData), validationContext);
            validationContext.freeResources();
        }
        if (!(transactionData instanceof Map)) {
            throw new Exception("Invalid transaction format: " + (transactionData == null ? "null" : transactionData.getClass().getName()));
        }
        this.transaction = (Map)transactionData;
        this.jsCallback = (String)this.transaction.get("jscallback");
        Long transactionNum = (Long)this.transaction.get("transactionNum");
        Boolean nullValuesHandling = (Boolean)this.transaction.get("omitNullMapValuesInResponse");
        if (nullValuesHandling != null) {
            this.omitNullMapValuesInResponse(nullValuesHandling);
        }
        if (this.jsCallback != null && !DataTools.isIdentifier(this.jsCallback)) {
            throw new Exception("Invalid jsCallback parameter: " + DataTools.escapeHTML(this.jsCallback));
        }
        if (IFRAME_NEW_WINDOW.equals(this.jsCallback) || IFRAME_RECURSE_UP.equals(this.jsCallback)) {
            this.jsCallback = this.generateIFrameCallback(this.jsCallback, transactionNum);
        }
        if (!((operationData = this.transaction.get("operations")) instanceof List)) {
            throw new Exception("Invalid 'operations' format" + operationData.getClass().getName());
        }
        List operations = (List)operationData;
        int requestNum = 0;
        log.debug("Processing " + operations.size() + " requests.");
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            Map m;
            ++requestNum;
            Object payload = i.next();
            if (payload instanceof Map && (m = (Map)payload).get("appID") != null && m.get("operation") != null) {
                BasicDataSource ds;
                DSRequest dsRequest;
                Object criteria;
                if (!config.getBoolean((Object)"datasource.allowClientAdditionalOutputs", true)) {
                    m.remove("additionalOutputs");
                }
                if ((criteria = m.remove("where")) != null) {
                    m.put("criteria", criteria);
                }
                if ((dsRequest = new DSRequest(m, this.context, this)).shouldStreamResults()) {
                    dsRequest.setFreeOnExecute(false);
                }
                if ((ds = (BasicDataSource)dsRequest.getDataSource()) != null && DataTools.getBoolean(ds.getConfig(), "noNullUpdates")) {
                    for (Object key : m.keySet()) {
                        if (!key.equals("criteria") && !key.equals("values")) continue;
                        Map values = (Map)m.get(key);
                        for (String vKey : values.keySet()) {
                            DSField field;
                            Object value = values.get(vKey);
                            if (value != null || !ds.getSimpleBaseType((field = ds.getField(vKey)).getType()).equals("text")) continue;
                            values.put(vKey, "");
                        }
                    }
                }
                if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                    String payloadString = DataTools.prettyPrint(m);
                    if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                        payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength" + " to desired max bytes (in server.properties)" + " - zero disables/negative value allows arbitrary length messages].";
                    }
                    log.debug("Request #" + requestNum + " (DSRequest) payload: " + payloadString);
                }
                this.addRequest(dsRequest);
                continue;
            }
            if (payload instanceof String) {
                if ("__ISC_NULL__".equals((String)payload)) {
                    payload = null;
                } else if ("__ISC_EMPTY_STRING__".equals((String)payload)) {
                    payload = "";
                }
            }
            if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                String payloadString = DataTools.prettyPrint(payload);
                if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                    payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength" + " to desired max bytes (in server.properties)" + " - zero disables/negative value allows arbitrary length messages].";
                }
                log.debug("Request #" + requestNum + " (RPCRequest) data: " + payloadString);
            }
            RPCRequest rpcRequest = new RPCRequest(payload, this.context);
            rpcRequest.rpc = this;
            this.addRequest(rpcRequest);
        }
        String localeName = this.context.request.getParameter("locale");
        if (localeName != null) {
            Locale locale = DataTools.deriveLocaleFromName(localeName);
            if (locale == null) {
                log.warn("Locale " + localeName + " was explicitly specified on the " + "HttpServletRequest, but it is not a valid locale name.  Ignoring.");
            } else if (this.context != null) {
                this.context.setLocale(locale);
            }
        }
    }

    public void addRequest(DSRequest req) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        this.requests.add(req);
    }

    private String generateIFrameCallback(String jsCallback, Long transactionNum) {
        if (IFRAME_NEW_WINDOW.equals(jsCallback)) {
            return "window.opener.parent.isc.Comm.hiddenFrameReply(" + transactionNum + ",results,window)";
        }
        return "if (!(new RegExp(\"^(\\\\d{1,3}\\\\.){3}\\\\d{1,3}$\").test(document.domain))) {while (!window.isc && document.domain.indexOf(\".\") != -1 ) { try { parent.isc; break;} catch (e) {document.domain = document.domain.replace(/.*?\\./, \"\");}}}parent.isc.Comm.hiddenFrameReply(" + transactionNum + ",results)";
    }

    public void addRequest(RPCRequest req) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        this.requests.add(req);
    }

    public Long getTransactionNum() {
        return this.transactionNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block12: {
            RequestTimer requestTimer = new RequestTimer(request);
            RPCManager rpc = null;
            RequestContext.instance((ServletRequest)request, (ServletResponse)response);
            try {
                rpc = new RPCManager(null, request, response);
            }
            catch (ClientMustResubmitException cmre) {
                Object var6_6 = null;
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            rpc.processRPCTransaction();
            Object var6_7 = null;
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
            break block12;
            {
                catch (Throwable e) {
                    Logger.observeThread();
                    log.error((Object)"Error processing RPC Request: ", Reflection.getRealTargetException(e));
                    ServletTools.handleServletError(response, " top-level exception", e);
                    Object var6_8 = null;
                    requestTimer.stop();
                    try {
                        response.flushBuffer();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void processRPCTransaction() throws Exception {
        log.info("Performing " + this.requestCount() + " operation(s)");
        for (Object r : this.getRequests()) {
            if (r instanceof RPCRequest) {
                RPCRequest rpcRequest = (RPCRequest)r;
                this.send(rpcRequest, rpcRequest.execute());
                continue;
            }
            DSRequest dsRequest = (DSRequest)r;
            try {
                this.send(dsRequest, dsRequest.execute());
            }
            catch (Exception e) {
                Logger.observeThread();
                try {
                    log.error((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sendFailure((Object)dsRequest, e);
            }
        }
    }

    public DataSource getDataSource(String dsName) throws Exception {
        return this.getDataSource(dsName, null);
    }

    public DataSource getDataSource(String dsName, DSRequest dsRequest) throws Exception {
        DataSource ds = DataSourceManager.getDataSource(dsName, dsRequest);
        if (ds != null) {
            this.dataSourcesToFree.add(ds);
        }
        return ds;
    }

    public void freeDataSources() throws Exception {
        Iterator i = this.dataSourcesToFree.iterator();
        while (i.hasNext()) {
            DataSourceManager.free((DataSource)i.next());
        }
    }

    public void applyEarlierResponseValues(DSRequest dsReq) throws Exception {
        String value;
        Object valueObj;
        String fieldName;
        String opId;
        DataSource ds;
        this.requestProcessingStarted = true;
        Date currentDate = new Date();
        this.addToTemplateContext("currentDate", currentDate);
        if (this.getFromTemplateContext("transactionDate") == null) {
            this.addToTemplateContext("transactionDate", currentDate);
        }
        if ((ds = dsReq.getDataSource()) == null) {
            return;
        }
        String opType = dsReq.getOperationType();
        Map opBinding = ds.getOperationBinding(opType, opId = dsReq.getOperationId());
        if (opBinding == null) {
            return;
        }
        Object criteriaObj = opBinding.get("criteria");
        Object valuesObj = opBinding.get("values");
        if (criteriaObj == null && valuesObj == null) {
            return;
        }
        Map params = Velocity.getStandardContextMap(dsReq);
        if (criteriaObj != null) {
            ArrayList criteria;
            if (criteriaObj instanceof List) {
                criteria = (ArrayList)criteriaObj;
            } else {
                criteria = new ArrayList();
                criteria.add(criteriaObj);
            }
            for (Map map : criteria) {
                fieldName = (String)map.get("fieldName");
                valueObj = map.get("value");
                value = valueObj instanceof String ? (String)valueObj : null;
                String operator = (String)map.get("operator");
                String start = (String)map.get("start");
                String end = (String)map.get("end");
                if (fieldName == null) continue;
                Object evalValue = null;
                Object evalEnd = null;
                Object evalStart = null;
                if (!"isNull".equals(operator) && !"notNull".equals(operator)) {
                    if (valueObj == null && start == null && end == null) {
                        log.warn("DataSource " + ds.getID() + ", operation " + opId + ": Found a <criteria> definition for field '" + fieldName + "', operator '" + operator + "' " + "that does not specify value, start or end - skipping");
                        continue;
                    }
                    evalValue = value != null ? Velocity.evaluate(value, params, "transactionChainingCriteriaValue", null, false, true) : (Object)valueObj;
                    if (start != null) {
                        evalStart = Velocity.evaluate(start, params, "transactionChainingCriteriaStart", null, false, true);
                    }
                    if (end != null) {
                        evalEnd = Velocity.evaluate(end, params, "transactionChainingCriteriaEnd", null, false, true);
                    }
                }
                dsReq.addToCriteria(fieldName, operator, evalValue, evalStart, evalEnd);
            }
        }
        if (valuesObj != null) {
            ArrayList values;
            if (valuesObj instanceof List) {
                values = (ArrayList)valuesObj;
            } else {
                values = new ArrayList();
                values.add(valuesObj);
            }
            for (Map map : values) {
                fieldName = (String)map.get("fieldName");
                valueObj = map.get("value");
                String string = value = valueObj instanceof String ? (String)valueObj : null;
                if (fieldName == null || value == null) continue;
                Object evaluation = null;
                evaluation = valueObj instanceof String ? Velocity.evaluate(value, params, "transactionChainingValue", null, false, true) : (Object)valueObj;
                dsReq.getValues().put(fieldName, evaluation);
            }
        }
    }

    public DSResponse findResponse(String firstOrLast, String dsName, String opType) {
        DSRequest dsReq;
        int stop;
        int inc;
        int loop;
        DSRequest thisDSReq = null;
        for (Object obj : this.requests) {
            if (!(obj instanceof DSRequest) || this.responseMap.get(obj) != null) continue;
            thisDSReq = (DSRequest)obj;
            break;
        }
        if (thisDSReq == this.requests.get(0)) {
            log.debug("Transaction chaining invoked on first request, ignoring");
            return null;
        }
        if (firstOrLast.equals("first")) {
            loop = 0;
            inc = 1;
            stop = this.requests.size();
        } else {
            inc = -1;
            stop = -1;
            for (loop = this.requests.size() - 1; loop != stop; --loop) {
                dsReq = (DSRequest)this.requests.get(loop);
                if (dsReq != thisDSReq) continue;
                --loop;
                break;
            }
        }
        while (loop != stop) {
            if (this.requests.get(loop) instanceof DSRequest) {
                dsReq = (DSRequest)this.requests.get(loop);
                if ((dsName == null || dsName.equals(dsReq.getDataSourceName())) && (opType == null || opType.equals(dsReq.getOperationType()))) {
                    DSResponse dsResp = (DSResponse)this.responseMap.get(dsReq);
                    if (dsResp == null) {
                        log.warn("Found null DSResponse mapped to valid-looking DSRequest when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Maybe requests " + "have been run out of order?");
                        return null;
                    }
                    return dsResp;
                }
            }
            loop += inc;
        }
        log.warn("Could not find a suitable dsRequest searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType);
        return null;
    }

    public Object findResponseData(String firstOrLast, String dsName, String opType) {
        Object data = null;
        DSResponse dsResponse = this.findResponse(firstOrLast, dsName, opType);
        if (dsResponse != null) {
            data = dsResponse.getData();
        }
        if (data == null) {
            log.warn("Found null dsResponse.data when searching for " + firstOrLast + " operation on DataSource " + dsName + " with operation type " + opType + ". Looks like the " + "operation does not return anything.");
            return null;
        }
        if (data instanceof List) {
            data = ((List)data).get(0);
        }
        return data;
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.setAuthenticated(true);
    }

    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        if (this.context.request != null) {
            return this.context.request.getRemoteUser();
        }
        return null;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = new Boolean(authenticated);
    }

    public void setAuthenticated(Boolean newValue) {
        this.authenticated = newValue;
    }

    public List getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(String rolesString) {
        this.userRoles = new ArrayList();
        String[] roles = rolesString.split(",");
        for (int i = 0; i < roles.length; ++i) {
            this.userRoles.add(roles[i].trim());
        }
    }

    public void setUserRoles(List rolesList) {
        this.userRoles = rolesList;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public void registerCallback(RPCManagerCompletionCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public int getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public void setTransactionPolicy(int tp) throws QueueAlreadyStartedException {
        if (this.requestProcessingStarted) {
            throw new QueueAlreadyStartedException("Queue processing has started; transaction policy cannot be changed");
        }
        this.transactionPolicy = tp;
    }

    public boolean requestQueueIncludesPriorUpdate(DSRequest req) {
        return this._requestQueueIncludesPriorUpdate(req);
    }

    public boolean requestQueueIncludesUpdates() {
        return this._requestQueueIncludesPriorUpdate(null);
    }

    private boolean _requestQueueIncludesPriorUpdate(DSRequest req) {
        try {
            if (req != null && req.getDataSource().isModificationRequest(req)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Object requestObj : this.requests) {
            if (requestObj.equals(req)) {
                return false;
            }
            if (!(requestObj instanceof DSRequest)) continue;
            DSRequest request = (DSRequest)requestObj;
            try {
                if (!request.getDataSource().isModificationRequest(request)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public Connection startSQLTransaction(DSRequest dsReq) throws Exception {
        if (dsReq != null) {
            DataSource ds = dsReq.getDataSource();
            if (ds instanceof ISQLDataSource) {
                dsReq.registerFreeResourcesHandler(ds);
                return ((ISQLDataSource)((Object)ds)).getTransactionalConnection(dsReq);
            }
            log.warn("RPCManager.startSQLTransaction is only applicable to SQL DataSources but was called was called for a DSRequest on a non-SQL DataSource ('" + ds.getName() + "', which is of type " + ds.getClass().getCanonicalName() + ")");
        }
        return null;
    }

    public void dumpResponseMap() {
        log.debug(this.responseMap);
    }

    public void addAssociatedRequest(DSRequest request) {
        this.associatedRequests.add(request);
    }

    public Map<String, DataSource> getCachedDataSourceInstances() {
        return this.cachedDataSources;
    }
}

