/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.store.ExpiringCache;
import com.isomorphic.store.ExpiringValue;
import com.isomorphic.store.ProcessedFileCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.keyvalue.MultiKey;

public class DataStructCache
extends Base {
    private static Logger log = new Logger(DataStructCache.class.getName());
    private static JSTranslater jsTrans = JSTranslater.instance();
    public static StructCache cache = new StructCache();
    public static int disableDsPaths = 0;
    private static ExpiringCache<MultiKey, String> instanceFileCache = new ExpiringCache(Config.getGlobal().getLong((Object)"file.stalenessCheckInterval", 500L), 100L);
    public static int instanceFileCacheHits = 0;
    public static int instanceFileCacheMisses = 0;
    public static int getInstanceFileCalls = 0;
    public static int getInstanceFileTime = 0;
    static Boolean logLoadLocations = null;

    public static Map getDataMap(String filename) throws Exception {
        return cache.getDataMap(filename);
    }

    public static List getSingleList(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        return DataStructCache.singleList(myMap, filename);
    }

    public static List singleList(Map myMap, String name) throws Exception {
        if (myMap.size() > 1) {
            log.warn("getSingleList: Found multiple js variables in file " + name + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + name);
        }
        return (List)myMap.get(myMap.keySet().iterator().next());
    }

    public static Object getJSVariableFromFile(String filename, String variableName) throws Exception {
        return DataStructCache.getDataMap(filename).get(variableName);
    }

    public static Map getSingleDataMap(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        if (myMap.size() > 1) {
            log.warn("getSingleDataMap: Found multiple js variables in file " + filename + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + filename);
        }
        return (Map)myMap.get(myMap.keySet().iterator().next());
    }

    public static void addCachedObjectWithNoConfigFile(String typeName, Object config) {
        cache.setDataMapForTypeName(typeName, config);
    }

    public static void removeCachedObjectWithNoConfigFile(String typeName) {
        cache.removeDataMapForTypeName(typeName);
    }

    public static Object getCachedObjectWithNoConfigFile(String typeName) {
        return cache.getDataMapForTypeName(typeName);
    }

    public static Object getInstance(String ID, String typeName, String suffix) throws Exception {
        String filename = DataStructCache.getInstanceFile(ID, typeName, suffix);
        if (filename == null) {
            return null;
        }
        return DataStructCache.loadInstance(filename, ID, suffix);
    }

    public static Object loadInstance(String filename, String ID, String suffix) throws Exception {
        return DataStructCache.loadInstance(filename, ID, suffix, null);
    }

    public static Object loadInstance(String filename, String ID, String suffix, Map flags) throws Exception {
        if (filename.endsWith(".js")) {
            return DataStructCache.getJSVariableFromFile(filename, ID + suffix);
        }
        return XML.loadCacheableDSRecords(new ISCFile(filename), flags);
    }

    public static synchronized void disableDsPaths() {
        ++disableDsPaths;
    }

    public static synchronized void enableDsPaths() {
        --disableDsPaths;
    }

    public static String getInstanceFile(String ID, String typeName, String suffix) throws Exception {
        return DataStructCache.getInstanceFile(ID, typeName, suffix, false);
    }

    public static String getInstanceFile(String ID, String typeName, String suffix, boolean isSchemaless) throws Exception {
        String result;
        long start = System.currentTimeMillis();
        MultiKey cacheKey = new MultiKey((Object)ID, (Object)typeName, (Object)suffix.toLowerCase(), (Object)isSchemaless);
        ExpiringValue<String> value = instanceFileCache.get(cacheKey);
        if (value == null) {
            result = DataStructCache._getInstanceFile(ID, typeName, suffix, isSchemaless);
            instanceFileCache.put(cacheKey, result);
            ++instanceFileCacheMisses;
        } else {
            result = value.get();
            ++instanceFileCacheHits;
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("getInstanceFile (" + (result != null ? "success" : "failure") + "): '" + ID + "' instance of " + typeName + ": " + (end - start) + "ms");
        }
        ++getInstanceFileCalls;
        getInstanceFileTime = (int)((long)getInstanceFileTime + (end - start));
        return result;
    }

    public static String _getInstanceFile(String ID, String typeName, String suffix, boolean isSchemaless) throws Exception {
        Iterator i;
        List paths;
        String filePath;
        suffix = suffix.toLowerCase();
        String filename = ID + "." + suffix;
        String instanceDir = config.getPath(typeName + "." + ID + ".location");
        if (instanceDir != null) {
            filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
            if (filePath != null) {
                return filePath;
            }
            if (instanceDir != null) {
                log.warning("File " + filename + " not found at explicitly specified location " + instanceDir + ", checking project-wide area");
            }
        }
        if (!isSchemaless && (paths = config.getCommaSeparatedList("project." + typeName)) != null) {
            i = paths.iterator();
            while (i.hasNext()) {
                instanceDir = ISCFile.canonicalizePath((String)i.next());
                if (instanceDir.startsWith("ds:/") && disableDsPaths != 0 || (filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename)) == null) continue;
                return filePath;
            }
        }
        if ((paths = config.getCommaSeparatedList("framework." + typeName)) != null) {
            i = paths.iterator();
            while (i.hasNext()) {
                instanceDir = ISCFile.canonicalizePath((String)i.next());
                filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
                if (filePath == null) continue;
                return filePath;
            }
        }
        return null;
    }

    public static String getInstanceDir(String ID, String typeName, String fileSuffix) throws Exception {
        String instanceFilename = DataStructCache.getInstanceFile(ID, typeName, fileSuffix);
        if (instanceFilename == null) {
            return null;
        }
        if (instanceFilename.startsWith("ds://")) {
            String path = instanceFilename.substring("ds://".length());
            String parent = new File(path).getParent();
            return "ds://" + parent;
        }
        return new File(instanceFilename).getParent();
    }

    public static String XMLOrJSFile(String baseName) throws IOException {
        boolean allowJS = config.getBoolean((Object)"allowJSDataSource", false);
        if (baseName == null) {
            return null;
        }
        String xmlName = baseName + ".xml";
        String jsName = baseName + ".js";
        ISCFile iscFile = new ISCFile(xmlName);
        if (iscFile.exists()) {
            String path = iscFile.getCanonicalPath();
            if (logLoadLocations == null) {
                logLoadLocations = Config.getGlobal().getBoolean((Object)"datasource.logLoadLocations", false);
            }
            if (logLoadLocations.booleanValue()) {
                System.out.println("file exists at: " + xmlName + "\r\nwill load from: " + path);
            }
            return path;
        }
        if (allowJS && (iscFile = new ISCFile(jsName)).exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    public static class StructCache
    extends ProcessedFileCache {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object loadObjectFromFile(ISCFile file) throws Exception {
            long start = System.currentTimeMillis();
            InputStream inStream = null;
            Map result = null;
            try {
                inStream = file.getInputStream();
                result = (Map)jsTrans.fromJSMap(inStream);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    inStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inStream.close();
            }
            catch (Exception exception) {}
            long end = System.currentTimeMillis();
            Logger.timing.debug("Parsed JS file '" + file.getCanonicalPath() + "': " + (end - start) + "ms");
            return result;
        }

        public Map getDataMap(String filename) throws Exception {
            return (Map)this.getObjectFromFile(DataTools.makePathAbsolute(filename));
        }

        public Object getDataMapForTypeName(String typeName) {
            return this.cache.get(typeName);
        }

        public synchronized void setDataMapForTypeName(String typeName, Object dataMap) {
            this.cache.put(typeName, dataMap);
        }

        public synchronized void removeDataMapForTypeName(String typeName) {
            this.cache.remove(typeName);
        }
    }
}

