/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.EasyX509TrustManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.RegexRule;
import com.isomorphic.xml.XML;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.LRUMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class HttpProxyServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    public String proxyHost;
    public String rulesFile;
    public String webXmlRules;
    public boolean useURLCache = true;
    public int urlCacheSize = 4096;
    protected Map<String, RegexRule> urlCache;
    protected List<RegexRule> rules;
    public boolean acceptInvalidAndExpiredSSLCertificates = false;
    public boolean includeSOAPAttachments = true;
    public String SOAPAttachmentDataSource = "sessionFiles";
    public int proxyPort = -1;
    private static final Set<String> headersToNotRelay;
    private static final String[] headersToNotRelay_initiaData;

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public void setRulesFile(String value) {
        this.rulesFile = value;
    }

    public void setRules(String value) {
        this.webXmlRules = value;
    }

    public void setUseURLCache(String value) {
        this.useURLCache = Boolean.valueOf(value);
    }

    public void setUrlCacheSize(String value) {
        this.urlCacheSize = Integer.valueOf(value);
    }

    public void setAcceptInvalidAndExpiredSSLCertificates(String value) {
        this.acceptInvalidAndExpiredSSLCertificates = Boolean.valueOf(value);
    }

    public void setIncludeSOAPAttachments(String value) {
        this.includeSOAPAttachments = Boolean.valueOf(value);
    }

    public void setSOAPAttachmentDataSource(String value) {
        this.SOAPAttachmentDataSource = value;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (this.webXmlRules != null) {
            for (String rule : DataTools.simpleSplit(this.webXmlRules, "\n")) {
                if ((rule = rule.trim()).length() <= 1) continue;
                try {
                    if (this.rules == null) {
                        this.rules = new ArrayList<RegexRule>();
                    }
                    this.rules.add(new RegexRule(rule, "rules init-param in web.xml"));
                }
                catch (Exception e) {
                    this.log.warn(e.toString() + " - dropping this rule.");
                }
            }
        }
        if (this.rulesFile != null) {
            if (this.webXmlRules != null) {
                this.log.warn("Both the rules and rulesFile params are defined in web.xml. Rules defined in the rulesFile: " + this.rulesFile + " will be appended to those defined in the rules param in web.xml");
            }
            if (!this.rulesFile.startsWith("/")) {
                this.rulesFile = "/" + this.rulesFile;
            }
            List rulesFromFile = null;
            try {
                rulesFromFile = DataStructCache.getSingleList(webRoot + this.rulesFile);
            }
            catch (Exception e) {
                this.log.error("Failed to parse rules file: " + webRoot + this.rulesFile);
            }
            if (rulesFromFile != null) {
                for (String rule : rulesFromFile) {
                    try {
                        if (this.rules == null) {
                            this.rules = new ArrayList<RegexRule>();
                        }
                        this.rules.add(new RegexRule(rule, "rulesFile: " + this.rulesFile));
                    }
                    catch (Exception e) {
                        this.log.warn(e.toString() + " - dropping this rule.");
                    }
                }
            }
        }
        if (this.rules == null) {
            this.useURLCache = false;
            this.log.info("No rules defined - proxying all incoming URLs.");
        }
        if (this.useURLCache) {
            this.urlCache = Collections.synchronizedMap(new LRUMap(this.urlCacheSize));
            this.log.debug("URL Cache enabled - max size: " + this.urlCacheSize + " entries");
        }
    }

    public void setProxyPort(String value) {
        this.proxyPort = Integer.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block73: {
            block69: {
                block68: {
                    requestTimer = new RequestTimer(request);
                    try {
                        try {
                            block72: {
                                requestData = request.getParameter("data");
                                vc = new ValidationContext();
                                vc.setRestrictedXMLMode(true);
                                data = (Map)XML.toDSRecords(new StringReader(requestData), vc);
                                vc.freeResources();
                                this.log.debug("ProxyData is: " + DataTools.prettyPrint(data));
                                url = (String)data.get("url");
                                if (this.rules != null) {
                                    matchedRule = null;
                                    if (this.useURLCache) {
                                        matchedRule = this.urlCache.get(url);
                                    }
                                    if (matchedRule == null) {
                                        for (RegexRule rule : this.rules) {
                                            match = false;
                                            try {
                                                match = rule.match(url);
                                            }
                                            catch (Exception e) {
                                                this.log.warn("Syntax error in rule: " + rule.toString() + " - ignoring rule");
                                            }
                                            if (!match) continue;
                                            matchedRule = rule;
                                            break;
                                        }
                                    }
                                    if (matchedRule == null) {
                                        error = "HttpProxy to URL: " + url + " DENIED.  The URL did not match " + "any rule - returning HTTP code 403 (Forbidden) to client.";
                                        this.log.warn(error);
                                        response.sendError(403);
                                        var36_16 = null;
                                        requestTimer.stop();
                                        break block68;
                                    }
                                    action = matchedRule.action;
                                    if ("block".equals(action) || "ignore".equals(action)) {
                                        error = "HttpProxy to URL: " + url + " DENIED by rule " + matchedRule.toString() + " - returning HTTP code 403 (Forbidden) " + "to client.";
                                        this.log.warn(error);
                                        response.sendError(403);
                                        break block69;
                                    }
                                    if (this.useURLCache) {
                                        this.urlCache.put(url, matchedRule);
                                    }
                                }
                                params = map = (HashMap<String, String>)data.get("params");
                                method = (String)data.get("httpMethod");
                                if (method == null) {
                                    method = "GET";
                                }
                                uploadFileName = (String)data.get("uploadFileName");
                                client = HttpClients.custom().build();
                                if (this.acceptInvalidAndExpiredSSLCertificates) {
                                    sslContext = HttpProxyServlet.createEasySSLContext();
                                    sslsf = new SSLConnectionSocketFactory(sslContext);
                                    socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
                                    connPoolControl = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                                    client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connPoolControl).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
                                }
                                httpRequest /* !! */  = null;
                                httpHeaders = (Map)data.get("httpHeaders");
                                requestBody = null;
                                rbObj = data.get("requestBody");
                                if (rbObj instanceof Map) {
                                    method = "POST";
                                    this.setIncludeSOAPAttachments("false");
                                    start = requestData.indexOf("<requestBody");
                                    start = requestData.indexOf(">", start);
                                    end = requestData.indexOf("</requestBody>");
                                    requestBody = requestData.substring(start + 1, end);
                                    requestBody = "<transaction xmlns:xsi=\"http://www.w3.org/2000/10/XMLSchema-instance\" xsi:type=\"xsd:Object\"><operations xsi:type=\"xsd:List\"> <elem xsi:type=\"xsd:Object\"> " + requestBody;
                                    requestBody = requestBody + "</elem></operations></transaction>";
                                    if (params == null) {
                                        params = new HashMap<String, String>();
                                    }
                                    params.put("_transaction", requestBody);
                                    url = url + "?isc_rpc=1&isc_xhr=1";
                                    requestBody = null;
                                } else {
                                    requestBody = (String)data.get("requestBody");
                                    if ("".equals(requestBody)) {
                                        requestBody = null;
                                    }
                                }
                                contentType = (String)data.get("contentType");
                                if (method.equals("PUT")) {
                                    httpRequest /* !! */  = new HttpPut(url);
                                    if (contentType == null) {
                                        httpRequest /* !! */ .setEntity((HttpEntity)new StringEntity(requestBody));
                                    } else {
                                        httpRequest /* !! */ .setEntity((HttpEntity)new StringEntity(requestBody, ContentType.create((String)contentType)));
                                    }
                                } else if (method.equals("POST")) {
                                    if (requestBody == null && uploadFileName == null) {
                                        httpRequest /* !! */  = new HttpPost(url);
                                    } else if (uploadFileName != null) {
                                        this.log.warn("uploading file: " + uploadFileName);
                                        file = new ISCFile(Config.getGlobal().get("webRoot") + uploadFileName);
                                        httpRequest /* !! */  = new HttpXMLPost(url, file, method);
                                    } else {
                                        if (this.includeSOAPAttachments && contentType != null && contentType.contains("xml")) {
                                            doc = XML.parseXML(new InputSource(new StringReader(requestBody)));
                                            namespaces = DataTools.buildMap("xop", "http://www.w3.org/2004/08/xop/include");
                                            binaryNodes = XML.selectNodes(doc, "//xop:Include", namespaces);
                                            for (Element node : binaryNodes) {
                                                primaryKey = node.getAttribute("href");
                                                dsRequest = new DSRequest(this.SOAPAttachmentDataSource, "fetch");
                                                dsRequest.context = context = RequestContext.instance((Servlet)this, request, response);
                                                dsRequest.setCriteria(DataTools.buildMap("primaryKey", primaryKey));
                                                dsResponse = dsRequest.execute();
                                                responseData = (Map)dsResponse.getData();
                                                if (responseData == null) {
                                                    throw new Exception("Unable to locate binary file for primaryKey: " + primaryKey);
                                                }
                                                binary = (byte[])responseData.get("file_binary");
                                                encoder = new Base64();
                                                binary64Text = new String(encoder.encode(binary));
                                                newNode = doc.createTextNode(binary64Text);
                                                parentNode = node.getParentNode();
                                                parentNode.replaceChild(newNode, node);
                                            }
                                            requestBody = XML.toXML(doc);
                                        }
                                        httpRequest /* !! */  = new HttpXMLPost(url, requestBody, method);
                                    }
                                    if (contentType != null) {
                                        httpRequest /* !! */ .addHeader("Content-Type", contentType);
                                    }
                                } else {
                                    if (!method.equals("GET")) {
                                        if (method.equals("DELETE") == false) throw new Exception("Unsupported HTTP method: " + method);
                                    }
                                    httpRequest /* !! */  = method.equals("GET") != false ? new HttpGet(url) : new HttpDelete(url);
                                }
                                if (this.proxyHost != null) {
                                    ph = new HttpHost(this.proxyHost, this.proxyPort);
                                    hostConfig = RequestConfig.custom().setProxy(ph).build();
                                    httpRequest /* !! */ .setConfig(hostConfig);
                                }
                                if (data.get("username") != null) {
                                    credentials = new UsernamePasswordCredentials((String)data.get("username"), (String)data.get("password"));
                                    ((DefaultHttpClient)client).getCredentialsProvider().setCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)credentials);
                                    requestConfig = RequestConfig.custom().setAuthenticationEnabled(true).build();
                                    httpRequest /* !! */ .setConfig(requestConfig);
                                }
                                if (httpHeaders != null) {
                                    for (String headerName : httpHeaders.keySet()) {
                                        httpRequest /* !! */ .setHeader(headerName, (String)httpHeaders.get(headerName));
                                    }
                                }
                                httpRequest /* !! */ .setProtocolVersion(new ProtocolVersion("HTTP", 1, 1));
                                queryParamsList = new ArrayList<BasicNameValuePair>();
                                callbackParam = (String)data.get("callbackParam");
                                if (callbackParam != null) {
                                    callbackParamValue = request.getParameter(callbackParam);
                                    if (callbackParam != null && callbackParamValue != null) {
                                        queryParamsList.add(new BasicNameValuePair(callbackParam, callbackParamValue));
                                    }
                                }
                                if (params != null && params.size() > 0) {
                                    for (String key : params.keySet()) {
                                        value /* !! */  = params.get(key);
                                        if (value /* !! */  == null) {
                                            value /* !! */  = "";
                                        }
                                        if (value /* !! */  instanceof List) {
                                            valueList = (List)value /* !! */ ;
                                            for (j = 0; j < valueList.size(); ++j) {
                                                nextValue = (String)valueList.get(j);
                                                if (nextValue == null) {
                                                    value /* !! */  = "";
                                                }
                                                queryParamsList.add(new BasicNameValuePair(key, nextValue));
                                            }
                                            continue;
                                        }
                                        queryParamsList.add(new BasicNameValuePair(key, value /* !! */ .toString()));
                                    }
                                }
                                if (queryParamsList.size() > 0) {
                                    if (method.equals("POST") && requestBody == null) {
                                        ((HttpPost)httpRequest /* !! */ ).setEntity((HttpEntity)new UrlEncodedFormEntity(queryParamsList));
                                    } else {
                                        uriBuilder = new URIBuilder(httpRequest /* !! */ .getURI());
                                        uriBuilder.addParameters(queryParamsList);
                                        httpRequest /* !! */ .setURI(uriBuilder.build());
                                    }
                                }
                                responseBody = null;
                                httpResponse = null;
                                try {
                                    block71: {
                                        try {
                                            httpResponse = client.execute((HttpUriRequest)httpRequest /* !! */ );
                                            statusCode = httpResponse.getStatusLine().getStatusCode();
                                            if (statusCode < 200 || statusCode > 300) {
                                                this.log.warn("Method failed: " + httpResponse.getStatusLine());
                                            } else {
                                                this.log.info("Method succeeded: " + httpResponse.getStatusLine());
                                            }
                                            response.setStatus(statusCode);
                                            responseBody = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                                            if (responseBody != null) break block71;
                                            this.log.info("Empty response body");
                                        }
                                        catch (UnknownHostException e) {
                                            this.log.warn("Tried to proxy to unknown host, returning error");
                                            e.printStackTrace();
                                            response.addHeader("X-ISC-HttpProxy-Status", "-91");
                                            response.setStatus(200);
                                            var34_60 = null;
                                            httpRequest /* !! */ .releaseConnection();
                                            break block72;
                                        }
                                        catch (SocketException e) {
                                            this.log.warn("SocketException in proxy - is the remote server down? Returning error");
                                            e.printStackTrace();
                                            response.addHeader("X-ISC-HttpProxy-Status", "-92");
                                            response.setStatus(200);
                                            var34_60 = null;
                                            httpRequest /* !! */ .releaseConnection();
                                            break block72;
                                        }
                                        catch (IOException e) {
                                            this.log.warn("Fatal transport error: " + e.getMessage());
                                            e.printStackTrace();
                                            var34_60 = null;
                                            httpRequest /* !! */ .releaseConnection();
                                            break block72;
                                        }
                                    }
                                    var34_60 = null;
                                }
                                catch (Throwable var33_62) {
                                    var34_61 = null;
                                    httpRequest /* !! */ .releaseConnection();
                                    throw var33_62;
                                }
                                httpRequest /* !! */ .releaseConnection();
                            }
                            cookieHeader = httpResponse.getFirstHeader("Set-Cookie");
                            if (cookieHeader != null && cookieHeader.getValue() != null) {
                                response.addHeader("X-Proxied-Set-Cookie", cookieHeader.getValue());
                            }
                            responseHeaders = httpResponse.getAllHeaders();
                            for (hdrIdx = 0; hdrIdx < responseHeaders.length; ++hdrIdx) {
                                header = responseHeaders[hdrIdx];
                                if (HttpProxyServlet.headersToNotRelay.contains(header.getName()) || response.containsHeader(header.getName())) continue;
                                response.addHeader(header.getName(), header.getValue());
                            }
                            if (responseBody != null) {
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Response:\n" + new String(responseBody));
                                }
                                IOUtil.copyStreams(new ByteArrayInputStream(responseBody), (OutputStream)response.getOutputStream());
                            }
                            break block73;
                        }
                        catch (Throwable e) {
                            this.handleError(response, e);
                            var36_19 = null;
                            requestTimer.stop();
                            try {
                                response.flushBuffer();
                                return;
                            }
                            catch (IOException var37_24) {
                                return;
                            }
                        }
                    }
                    catch (Throwable var35_63) {
                        var36_20 = null;
                        requestTimer.stop();
                        ** try [egrp 5[TRYBLOCK] [17 : 2435->2444)] { 
lbl253:
                        // 1 sources

                        response.flushBuffer();
                        throw var35_63;
lbl255:
                        // 1 sources

                        catch (IOException var37_25) {
                            // empty catch block
                        }
                        throw var35_63;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [17 : 2435->2444)] { 
lbl260:
                // 1 sources

                response.flushBuffer();
                return;
lbl262:
                // 1 sources

                catch (IOException var37_21) {
                    // empty catch block
                }
                return;
            }
            var36_17 = null;
            requestTimer.stop();
            ** try [egrp 5[TRYBLOCK] [17 : 2435->2444)] { 
lbl269:
            // 1 sources

            response.flushBuffer();
            return;
lbl271:
            // 1 sources

            catch (IOException var37_22) {
                // empty catch block
            }
            return;
        }
        var36_18 = null;
        requestTimer.stop();
        try {}
        catch (IOException var37_23) {}
        response.flushBuffer();
        return;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private static SSLContext createEasySSLContext() throws Exception {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new EasyX509TrustManager(null)}, null);
            return context;
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
    }

    static {
        headersToNotRelay_initiaData = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Location", "Content-MD5", "Content-Range", "Cookie", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Retry-After", "Server", "Set-Cookie", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
        headersToNotRelay = new HashSet(headersToNotRelay_initiaData.length){

            public boolean add(Object o) {
                return super.add(o.toString().toLowerCase());
            }

            public boolean remove(Object o) {
                return super.remove(o.toString().toLowerCase());
            }

            public boolean contains(Object o) {
                return super.contains(o.toString().toLowerCase());
            }
        };
        for (int i = 0; i < headersToNotRelay_initiaData.length; ++i) {
            headersToNotRelay.add(headersToNotRelay_initiaData[i]);
        }
    }

    class HttpXMLPost
    extends HttpEntityEnclosingRequestBase {
        private ISCFile _uploadFile = null;
        private String _requestBody = "<foo></foo>";
        private String _methodName = "POST";

        public HttpXMLPost(String url, String requestBody, String methodName) throws URISyntaxException, IOException {
            this.setURI(new URI(url));
            this._requestBody = requestBody;
            this._methodName = methodName;
            this.setEntity((HttpEntity)new StringEntity(requestBody));
        }

        public HttpXMLPost(String url, ISCFile file, String methodName) throws URISyntaxException, IOException {
            this.setURI(new URI(url));
            this._uploadFile = file;
            this._methodName = methodName;
            this.setEntity((HttpEntity)new InputStreamEntity(file.getInputStream()));
        }

        public String getName() {
            return this._methodName;
        }

        protected long getRequestContentLength() {
            return this._requestBody.length();
        }

        public String getMethod() {
            return this._methodName;
        }
    }
}

