/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

public class ScriptExceptionItem {
    private int scriptSourceLineNumber = -1;
    private Type type = null;
    private String source = null;
    private int lineNumber = -1;
    private int colNumber = -1;
    private String message = null;
    private String stderr = null;

    public ScriptExceptionItem(Type type, int lineNumber, String message) {
        this(type, null, lineNumber, -1, -1, message, null);
    }

    public ScriptExceptionItem(Type type, String source, int lineNumber, String message) {
        this(type, source, lineNumber, -1, -1, message, null);
    }

    public ScriptExceptionItem(Type type, String source, int lineNumber, int colNumber, String message) {
        this(type, source, lineNumber, -1, colNumber, message, null);
    }

    public ScriptExceptionItem(Type type, String source, int lineNumber, int scriptSourceLineNumber, int colNumber, String message) {
        this(type, source, lineNumber, scriptSourceLineNumber, colNumber, message, null);
    }

    public ScriptExceptionItem(Type type, String source, int lineNumber, int scriptSourceLineNumber, int colNumber, String message, String stderr) {
        this.type = type;
        this.source = source;
        this.lineNumber = lineNumber;
        this.scriptSourceLineNumber = scriptSourceLineNumber;
        this.colNumber = colNumber;
        this.message = message;
        this.stderr = stderr;
    }

    public int getScriptSourceLineNumber() {
        return this.scriptSourceLineNumber;
    }

    public Type getType() {
        return this.type;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSource() {
        return this.source;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String toString() {
        String s = "";
        s = s + (this.getType() == null ? "" : this.getType().toString());
        s = s + (this.getSource() == null || "".equals(this.getSource().trim()) ? "" : " in " + this.getSource());
        s = s + (this.getScriptSourceLineNumber() < 0 ? "" : ", source line " + this.getScriptSourceLineNumber());
        s = s + (this.getLineNumber() < 0 ? "" : ", script line " + this.getLineNumber());
        s = s + (this.getColNumber() < 0 ? "" : ", column " + this.getColNumber()) + (this.getMessage() == null || "".equals(this.getMessage().trim()) ? "" : ", message: " + this.getMessage()) + (this.getStderr() == null || "".equals(this.getStderr().trim()) ? "" : ", stderr: " + this.getStderr());
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PARSE("Parse error"),
        RUNTIME("Runtime error");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

