/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp;

import com.opera.core.systems.internal.SocketMonitor;
import com.opera.core.systems.scope.handlers.ConnectionHandler;
import com.opera.core.systems.scope.handlers.EventHandler;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.stp.StpConnectionListener;
import java.io.IOException;
import java.util.logging.Logger;

public class StpThread
extends Thread {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final StpConnectionListener listener;
    private final SocketMonitor monitor = new SocketMonitor();
    private volatile boolean cancelled;

    public StpThread(int port, ConnectionHandler handler, EventHandler eventHandler, boolean manualConnect) throws IOException {
        this.listener = new StpConnectionListener(port, handler, eventHandler, manualConnect, this.monitor);
        this.setName("stp-thread");
    }

    public void shutdown() {
        this.cancelled = true;
        this.listener.stop();
        this.monitor.stop();
    }

    @Override
    public void run() {
        this.logger.finer("Started StpThread");
        while (!this.cancelled) {
            this.monitor.poll(OperaIntervals.RESPONSE_TIMEOUT.getMs());
        }
        this.logger.finer("Stopping StpThread");
    }
}

