/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.criterion.DateRangeCriterion;
import com.isomorphic.criteria.criterion.DoubleRangeCriterion;
import com.isomorphic.criteria.criterion.FloatRangeCriterion;
import com.isomorphic.criteria.criterion.IntegerRangeCriterion;
import com.isomorphic.criteria.criterion.LongRangeCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.log.Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RangeOperator
extends OperatorBase {
    private static final String MAX_KEY = "end";
    private static final String MIN_KEY = "start";
    private static Logger log = new Logger(RangeOperator.class.getName());

    public abstract String getID();

    public boolean isRequiresFieldName() {
        return true;
    }

    public boolean isRequiresValue() {
        return false;
    }

    public boolean isRequiresCriteria() {
        return false;
    }

    public Criterion parseCriterion(Map criteriaData) {
        super.parseCriterion(criteriaData);
        String fieldName = (String)criteriaData.get("fieldName");
        Object minValue = criteriaData.get(MIN_KEY);
        Object maxValue = criteriaData.get(MAX_KEY);
        if (minValue instanceof Double || maxValue instanceof Double) {
            return new DoubleRangeCriterion(fieldName, this.getID(), (Double)minValue, (Double)maxValue);
        }
        if (minValue instanceof Float || maxValue instanceof Float) {
            return new FloatRangeCriterion(fieldName, this.getID(), (Float)minValue, (Float)maxValue);
        }
        if (minValue instanceof Long || maxValue instanceof Long) {
            return new LongRangeCriterion(fieldName, this.getID(), (Long)minValue, (Long)maxValue);
        }
        if (minValue instanceof Integer || maxValue instanceof Integer) {
            return new IntegerRangeCriterion(fieldName, this.getID(), (Integer)minValue, (Integer)maxValue);
        }
        if (minValue instanceof Date) {
            return new DateRangeCriterion(fieldName, this.getID(), (Date)minValue, (Date)maxValue);
        }
        if (minValue instanceof Comparable && maxValue instanceof Comparable) {
            return new RangeCriterion(fieldName, this.getID(), (Comparable)minValue, (Comparable)maxValue);
        }
        log.error("Unknown class for range comparison " + (minValue == null ? "null" : minValue.getClass()));
        return null;
    }

    public Criterion parseCriterion(String fieldName, Object value, List criterias) {
        return null;
    }

    public Map convertToMap(Criterion criterion) {
        RangeCriterion sc = (RangeCriterion)criterion;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("operator", sc.getOperatorId());
        result.put("fieldName", sc.getFieldName());
        if (sc.getMin() instanceof Number) {
            result.put(MIN_KEY, sc.getMin().toString());
        } else {
            result.put(MIN_KEY, sc.getMin());
        }
        if (sc.getMax() instanceof Number) {
            result.put(MAX_KEY, sc.getMax().toString());
        } else {
            result.put(MAX_KEY, sc.getMax());
        }
        return result;
    }
}

