/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.log.RevolvingMemoryAppender;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.IImageExporter;
import com.isomorphic.rpc.IPdfExporter;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.rpc.Scripting;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.taglib.LoadWSDLTag;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XMLParsingException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinRPC
extends Base {
    protected static Logger log = new Logger(BuiltinRPC.class.getName());
    public static String cssStylenameSuffix = "$style";

    public static void downloadWSDL(String url, String format, String fileName, RPCManager rpc, HttpServletRequest request, HttpServletResponse response) throws Exception {
        rpc.doCustomResponse();
        RequestContext.setNoCacheHeaders(response);
        response.setContentType(DataTools.mimeTypeForFileName(fileName));
        response.addHeader("content-disposition", "attachment; " + rpc.encodeParameter("fileName", fileName));
        XML.loadWSDL(LoadWSDLTag.getAbsoluteURL(url, null), format, response.getWriter());
    }

    public static void downloadClientContent(String fileContents, String fileName, String mimeType, RPCManager rpc, HttpServletRequest request, HttpServletResponse response) throws Exception {
        rpc.doCustomResponse();
        RequestContext.setNoCacheHeaders(response);
        response.setContentType(mimeType);
        response.addHeader("content-disposition", "attachment; " + rpc.encodeParameter("fileName", fileName));
        PrintWriter writer = response.getWriter();
        if (log.isDebugEnabled()) {
            log.debug("downloadClientContent() writing fileContents: " + fileContents);
        }
        ((Writer)writer).write(fileContents);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static RPCResponse xmlToJS(String xmlString) throws Exception {
        StringWriter out = new StringWriter();
        try {
            XML.toJS(new StringReader(xmlString), (Writer)out).freeResources();
        }
        catch (XMLParsingException e) {
            log.info("Error parsing inbound XML - assuming multiple top-level elements and retrying with wrapper tag.");
            SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", new StringReader(xmlString), "</isomorphicXML>");
            out = new StringWriter();
            XML.toJS(reader, (Writer)out);
        }
        return new RPCResponse(out.toString());
    }

    public static RPCResponse uploadProgressCheck(HttpSession session, String formID) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("formID", formID);
        List errors = (List)session.getAttribute("errors");
        if (errors != null) {
            responseData.put("errors", errors);
        }
        responseData.put("bytesSoFar", session.getAttribute("bytesSoFar"));
        responseData.put("totalBytes", session.getAttribute("totalBytes"));
        return new RPCResponse(responseData);
    }

    public static RPCResponse deleteFile(String path) throws Exception {
        path = BuiltinRPC.validateFilePath(path, "deleteFile");
        log.debug("Deleting: " + path);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse saveFile(String path, String data) throws Exception {
        path = BuiltinRPC.validateFilePath(path, "saveFile");
        log.debug("Saving: " + path);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        } else {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        IOUtil.copyCharacterStreams(new StringReader(data), new FileWriter(file));
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse appendToFile(String path, String data) throws Exception {
        path = BuiltinRPC.validateFilePath(path, "appendToFile");
        log.debug("Appending to: " + path);
        File file = new File(path);
        IOUtil.copyCharacterStreams(new StringReader(data), new FileWriter(file, true));
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse loadFile(String path) throws Exception {
        path = BuiltinRPC.validateFilePath(path, "loadFile");
        log.debug("Loading: " + path);
        File file = new File(path);
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(new FileReader(file), sw);
        RPCResponse response = new RPCResponse();
        response.setData(sw.toString());
        return response;
    }

    public static String validateFileName(String fileName) throws Exception {
        int extStartPos;
        if (fileName == null || fileName.length() == 0) {
            throw new Exception("fileName cannot be null or empty");
        }
        int slashPos = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92));
        if (slashPos >= 0) {
            fileName = fileName.substring(slashPos + 1);
        }
        if ((extStartPos = fileName.indexOf(46)) >= 0) {
            String ext = fileName.substring(fileName.lastIndexOf(46), fileName.length());
            fileName = fileName.substring(0, extStartPos);
            fileName = fileName + ext;
        }
        return fileName;
    }

    public static String validateFileDir(String fileDir, String methodName) throws Exception {
        boolean noValidation = config.getList("RPCManager.enabledBuiltinMethods", new ArrayList()).contains("*");
        if (!noValidation) {
            List enabledPrefixes = config.getList("RPCManager.builtin." + methodName + ".enabledPrefixes", new ArrayList());
            if (fileDir == null || fileDir.length() == 0) {
                throw new Exception("fileDir cannot be null or empty");
            }
            if (!fileDir.startsWith("[")) {
                fileDir = "[WEBROOT]" + (fileDir.startsWith("/") ? fileDir : "/" + fileDir);
            }
            if (fileDir.indexOf("..") != -1) {
                throw new Exception("Invalid fileDir: " + fileDir + " - contains relative path reference");
            }
            String leadingPathExpansionVar = fileDir.substring(0, fileDir.indexOf("]") + 1);
            if (!enabledPrefixes.contains(leadingPathExpansionVar) && !enabledPrefixes.contains("*")) {
                throw new Exception("Leading path expansion variable: " + leadingPathExpansionVar + " for fileDir: " + fileDir + " is not listed as an enabled prefix." + " If this prefix is allowed, please list it in server.properties" + " under the RPCManager.builtin." + methodName + ".enabledPrefixes config var.");
            }
            if (!Arrays.asList(Config.getPathExpansionVariables()).contains(leadingPathExpansionVar) && !"[READ_ONLY]".equals(leadingPathExpansionVar)) {
                throw new Exception("Invalid leading path expansion variable: " + leadingPathExpansionVar + " in fileDir: " + fileDir);
            }
            if (leadingPathExpansionVar.equals("[READ_ONLY]")) {
                return fileDir;
            }
        }
        String serverFileDir = Config.expandPathVariables(fileDir, false);
        if (ISCFile.inContainerIOMode()) {
            serverFileDir = Config.expandPathVariables(fileDir, true);
        }
        return ISCFile.canonicalizePath(serverFileDir);
    }

    public static String validateFilePath(String filePath, String methodName) throws Exception {
        if (filePath.indexOf("/") == -1) {
            throw new Exception("Invalid filePath: " + filePath + " - must contain / ");
        }
        String fileName = filePath.substring(filePath.lastIndexOf("/"), filePath.length());
        fileName = BuiltinRPC.validateFileName(fileName);
        String fileDir = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        fileDir = BuiltinRPC.validateFileDir(fileDir, methodName);
        return fileDir + "/" + fileName;
    }

    public static Map getAvailableScriptEngines() throws Exception {
        return Scripting.getAvailableScriptEngines();
    }

    public static RPCResponse evalGroovyScript(DataTypeMap data) throws Exception {
        return Scripting.evalGroovyScript(data);
    }

    public static RPCResponse evalServerScript(DataTypeMap data) throws Exception {
        return Scripting.evalServerScript(data);
    }

    public static RPCResponse devConsoleEvalServerScript(RequestContext context, DataTypeMap data) throws Exception {
        return Scripting.devConsoleEvalServerScript(context, data);
    }

    public static RPCResponse evalJava(String javaCode, RequestContext context) throws Exception {
        if (ISCFile.inContainerIOMode()) {
            throw new Exception("Can't execute Java code in container-IO mode - to fix, explicitly set webRoot in server.properties");
        }
        String webRoot = config.getPath("webRoot");
        String tmpPath = "/tools/devConsoleEval.jsp";
        File tmpJSP = new File(webRoot + tmpPath);
        if (tmpJSP.exists()) {
            tmpJSP.delete();
        }
        tmpJSP.createNewFile();
        File header = new File(webRoot + "/shared/jsp/evalJavaHeader.jsp");
        File footer = new File(webRoot + "/shared/jsp/evalJavaFooter.jsp");
        FileWriter fw = new FileWriter(tmpJSP);
        if (header.exists()) {
            IOUtil.copyCharacterStreams(new FileReader(header), fw);
        }
        IOUtil.copyCharacterStreams(new StringReader(javaCode), fw);
        if (footer.exists()) {
            IOUtil.copyCharacterStreams(new FileReader(footer), fw);
        }
        ByteArrayOutputStream wrapBuf = new ByteArrayOutputStream();
        ProxyHttpServletResponse wrapResponse = new ProxyHttpServletResponse(context.response, new ProxyServletOutputStream(wrapBuf), "evalJava");
        RPCResponse response = new RPCResponse();
        try {
            ServletTools.include(context.servletContext, (ServletRequest)context.request, (ServletResponse)wrapResponse, tmpPath);
            try {
                wrapResponse.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            wrapBuf.flush();
            response.setData(wrapBuf.toString());
            response.setStatus(RPCResponse.STATUS_SUCCESS);
        }
        catch (Throwable t) {
            response.setData(t.toString());
            response.setStatus(RPCResponse.STATUS_FAILURE);
        }
        return response;
    }

    public static RPCResponse loadSharedXML(String type, String ID) throws Exception {
        boolean returnXML = true;
        boolean returnJS = true;
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("type", type);
        responseData.put("ID", ID);
        try {
            String typeName = BuiltinRPC.getTypeNameForExtension(type);
            if (typeName == null) {
                throw new Exception("Unknown type: " + type);
            }
            log.debug("loadSharedXML - ID: " + ID + " typeName: " + typeName + " type: " + type);
            String path = DataStructCache.getInstanceFile(ID, typeName, type);
            log.debug("loadSharedXML - loading from path: " + path);
            if (path == null) {
                throw new Exception("Can't find " + type + " " + ID);
            }
            ISCFile file = new ISCFile(path);
            if (!file.exists()) {
                throw new Exception("Can't find " + type + " " + ID);
            }
            String xml = DataTools.fileContentsAsString(file);
            if (returnXML) {
                responseData.put("xml", xml);
            }
            if (returnJS) {
                StringReader reader = new StringReader(xml);
                StringWriter sw = new StringWriter();
                XML.toJS(reader, null, sw, false).freeResources();
                responseData.put("js", sw.toString());
            }
        }
        catch (Exception e) {
            responseData.put("error", e.toString());
        }
        return new RPCResponse(responseData);
    }

    public static RPCResponse saveSharedXML(String type, String ID, String contents) throws Exception {
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("type", type);
        responseData.put("ID", ID);
        Object error = null;
        try {
            if (ISCFile.inContainerIOMode()) {
                throw new Exception("SmartClient server running in Container-IO mode - unable to save.");
            }
            String typeName = BuiltinRPC.getTypeNameForExtension(type);
            if (typeName == null) {
                throw new Exception("Unknown type: " + type);
            }
            log.debug("saveSharedXML - ID: " + ID + " typeName: " + typeName + " type: " + type);
            String path = DataStructCache.getInstanceFile(ID, typeName, type);
            if (path == null) {
                List paths = config.getCommaSeparatedList("project." + typeName);
                path = (String)paths.get(0);
                if (path == null) {
                    throw new Exception("Unable to determine default storage path for type: " + type + " was looking for config param: project." + typeName);
                }
                path = path + "/" + ID + "." + type.toLowerCase() + ".xml";
            }
            log.warn("Saving " + type + " " + ID + " at location: " + path);
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            IOUtil.copyCharacterStreams(new StringReader(contents), new FileWriter(file));
        }
        catch (Exception e) {
            responseData.put("error", e.toString());
        }
        return new RPCResponse(responseData);
    }

    private static String getTypeNameForExtension(String type) {
        String typeName = null;
        if ("DS".equals(type)) {
            typeName = "datasources";
        } else if ("APP".equals(type)) {
            typeName = "apps";
        } else if ("UI".equals(type)) {
            typeName = "ui";
        }
        return typeName;
    }

    public static List getLogNames() throws Exception {
        if (Logger.useLog4j()) {
            return RevolvingMemoryAppender.getLogNames();
        }
        String msg = "Changing logging level at runtime and reading/clearing log entries features are not supported if SLF4J logging facade is used.";
        log.warn(msg);
        throw new Exception(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLogEntries(String logName) throws Exception {
        if (Logger.useLog4j()) {
            ArrayList logEntries;
            ArrayList arrayList = logEntries = RevolvingMemoryAppender.getLogEntries(logName);
            synchronized (arrayList) {
                logEntries = new ArrayList(logEntries);
            }
            return logEntries;
        }
        String msg = "Changing logging level at runtime and reading/clearing log entries features are not supported if SLF4J logging facade is used.";
        log.warn(msg);
        throw new Exception(msg);
    }

    public static void clearLogEntries(String logName) throws Exception {
        if (!Logger.useLog4j()) {
            String msg = "Changing logging level at runtime and reading/clearing log entries features are not supported if SLF4J logging facade is used.";
            log.warn(msg);
            throw new Exception(msg);
        }
        RevolvingMemoryAppender.clearLogEntries(logName);
    }

    public static void setLogThreshold(String category, String threshold) throws Exception {
        if (!Logger.useLog4j()) {
            String msg = "Changing logging level at runtime and reading/clearing log entries features are not supported if SLF4J logging facade is used.";
            log.warn(msg);
            throw new Exception(msg);
        }
        Logger.getLoggerRepository().getLogger(category).setLevel(Level.toLevel((String)threshold));
        log.info("Category " + category + " now at: " + threshold);
    }

    public static void setTemporaryLogThreshold(String category, String threshold) throws Exception {
        if (!Logger.useLog4j()) {
            String msg = "Changing logging level at runtime and reading/clearing log entries features are not supported if SLF4J logging facade is used.";
            log.warn(msg);
            throw new Exception(msg);
        }
        Logger.saveCurrentThreshold(category);
        Logger.getLoggerRepository().getLogger(category).setLevel(Level.toLevel((String)threshold));
        log.info("Category " + category + " now at: " + threshold + " (temporary)");
    }

    public static void revertTemporaryLogThresholds() throws Exception {
        if (!Logger.useLog4j()) {
            String msg = "Changing logging level at runtime and reading/clearing log entries features are not supported if SLF4J logging facade is used.";
            log.warn(msg);
            throw new Exception(msg);
        }
        Logger.restoreSavedThresholds();
        log.info("Reverting temporary log thresholds");
    }

    public static List getLogThresholds() throws Exception {
        if (Logger.useLog4j()) {
            ArrayList<Map> loggers = new ArrayList<Map>();
            Enumeration e = Logger.getLoggerRepository().getCurrentLoggers();
            while (e.hasMoreElements()) {
                org.apache.log4j.Logger logger = (org.apache.log4j.Logger)e.nextElement();
                if (logger.getLevel() == null) continue;
                loggers.add(DataTools.buildMap("category", logger.getName(), "threshold", logger.getLevel().toString()));
            }
            return loggers;
        }
        String msg = "Changing logging level at runtime and reading/clearing log entries features are not supported if SLF4J logging facade is used.";
        log.warn(msg);
        throw new Exception(msg);
    }

    public static void downloadClientExport(List<? extends Map<String, Object>> records, String exportAs, String fileName, String exportDisplay, Map<String, Object> settings, HttpServletResponse response, RPCManager rpc, RPCRequest request) throws Exception {
        if (settings == null) {
            settings = new HashMap<String, Object>();
        }
        if (exportAs == null) {
            exportAs = (String)settings.get("exportAs");
        } else {
            settings.put("exportAs", exportAs);
        }
        if ("json".equals(exportAs)) {
            log.warn("Client request for 'json' format data export is not allowed for security reasons - using CSV instead");
            exportAs = "csv";
            settings.put("exportAs", exportAs);
        }
        if (log.isInfoEnabled()) {
            log.info("Export data passed to server:\n" + DataTools.prettyPrint(records));
        }
        settings.put("useTitlesAsAttributeNames", true);
        rpc.doCustomResponse();
        boolean toClient = DataTools.getBoolean(settings, "exportToClient", true);
        boolean toFilesystem = DataTools.getBoolean(settings, "exportToFilesystem", false);
        if (toClient || toFilesystem) {
            Object os1 = null;
            BufferedOutputStream os2 = null;
            if (fileName == null) {
                fileName = (String)settings.get("exportFilename");
            }
            if (fileName != null && fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (fileName == null) {
                fileName = "export";
            }
            if (fileName.indexOf(".") == -1) {
                fileName = fileName + "." + ("ooxml".equals(exportAs) ? "xlsx" : exportAs);
            }
            if (records != null && !records.isEmpty()) {
                int contentLength;
                String qname;
                block41: {
                    HashMap<String, String> exportOtherFields;
                    if (toClient) {
                        String mimeType = DataExport.getMimeTypeForFormat(exportAs);
                        String fileNameEncoding = rpc.encodeParameter("fileName", fileName);
                        if (exportDisplay.equals("download")) {
                            response.addHeader("content-disposition", "attachment; " + fileNameEncoding);
                            response.setContentType(mimeType);
                        } else {
                            response.addHeader("content-disposition", "inline; " + fileNameEncoding);
                        }
                        os1 = response.getOutputStream();
                    }
                    qname = config.getPath("export.location");
                    if (!config.getBoolean((Object)"export.allow.filesystem", false) && toFilesystem) {
                        log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                        toFilesystem = false;
                    } else if (toFilesystem) {
                        String path;
                        if (qname == null) {
                            qname = "";
                        }
                        if (!qname.endsWith("/") && qname.length() > 0) {
                            qname = qname + "/";
                        }
                        if ((path = (String)settings.get("exportPath")) != null) {
                            qname = qname + path;
                        }
                        if (!qname.endsWith("/") && qname.length() > 0) {
                            qname = qname + "/";
                        }
                        if (fileName != null) {
                            qname = qname + fileName;
                        }
                        if (os1 == null) {
                            os1 = new BufferedOutputStream(new FileOutputStream(qname));
                        } else {
                            os2 = new BufferedOutputStream(new FileOutputStream(qname));
                        }
                    }
                    List<? extends Map<String, Object>> rows = records;
                    log.info("Generating and streaming " + exportAs + " file...");
                    Map<String, Object> firstRow = rows.get(0);
                    ArrayList<String> columns = new ArrayList<String>();
                    HashMap<String, String> fieldMap = new HashMap<String, String>();
                    String separator = (String)settings.get("exportTitleSeparatorChar");
                    if (separator == null) {
                        separator = "";
                    }
                    if ((exportOtherFields = (HashMap<String, String>)settings.get("exportOtherFields")) == null) {
                        exportOtherFields = new HashMap<String, String>();
                    }
                    Map exportFieldTitles = (Map)settings.get("exportFieldTitles");
                    boolean isExcelExport = "ooxml".equals(exportAs) || "xls".equals(exportAs);
                    boolean isXMLExport = "xml".equals(exportAs);
                    boolean createOtherFields = settings.get("exportHeaderSpans") == null && exportOtherFields.isEmpty();
                    for (String fieldName : firstRow.keySet()) {
                        if (!isExcelExport && fieldName.endsWith(cssStylenameSuffix)) continue;
                        String fieldTitle = (String)exportOtherFields.get(fieldName);
                        if (fieldTitle == null) {
                            String string = fieldTitle = exportFieldTitles != null ? (String)exportFieldTitles.get(fieldName) : null;
                        }
                        if (fieldTitle == null) {
                            fieldTitle = fieldName;
                        }
                        if (isXMLExport) {
                            fieldTitle = fieldTitle.replaceAll("[$&<>()\"'\\n ]", separator);
                        }
                        if (isExcelExport) {
                            fieldMap.put(fieldName, fieldName);
                            if (createOtherFields) {
                                exportOtherFields.put(fieldName, fieldTitle);
                                if (!settings.containsKey("exportOtherFields")) {
                                    settings.put("exportOtherFields", exportOtherFields);
                                }
                            }
                        } else {
                            fieldMap.put(fieldName, fieldTitle);
                        }
                        columns.add(fieldName);
                    }
                    if (settings.get("exportFields") == null) {
                        settings.put("exportFields", columns);
                    }
                    DataExport exportObj = DataExport.getDataExport(settings);
                    contentLength = 0;
                    try {
                        contentLength = exportObj.exportResultSet(rows.iterator(), fieldMap, (OutputStream)os1, os2, null);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception during export - continuing anyway to avoid sending the client to a blank screen", e);
                        if (!toClient) break block41;
                        response.getOutputStream().print("  *** Exception during export - please check server logs ***");
                    }
                }
                if (toClient) {
                    response.setContentLength(contentLength);
                } else {
                    BuiltinRPC.writeResponse(RPCResponse.STATUS_SUCCESS, "Successfully exported " + qname, response);
                }
                return;
            }
            log.warn("Provided data was null or empty - abandoning");
            if (!toClient) {
                BuiltinRPC.writeResponse(RPCResponse.STATUS_FAILURE, "Provided data was null or empty - abandoning", response);
            }
        } else {
            log.warn("Export requested, but neither client nor filesystem specified - doing nothing");
            BuiltinRPC.writeResponse(RPCResponse.STATUS_FAILURE, "Export requested, but neither client nor filesystem specified - we did nothing", response);
        }
    }

    private static void writeResponse(int status, String data, HttpServletResponse response) throws Exception {
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.setObfuscation(false);
        HashMap<String, Object> clientResponse = new HashMap<String, Object>();
        clientResponse.put("status", status);
        clientResponse.put("data", data);
        PrintWriter w = response.getWriter();
        ((Writer)w).write("//isc_RPCResponseStart-->");
        jsTrans.toJS(clientResponse, w);
        ((Writer)w).write("//isc_RPCResponseEnd");
    }

    public static void getPdfObject(String html, Map settings, HttpServletResponse response, RPCManager rpc) throws Exception {
        IPdfExporter pdfFactory = (IPdfExporter)InterfaceProvider.load("IPdfExporter");
        pdfFactory.getPdfObject(html, settings, response, rpc);
    }

    public static RPCResponse exportImage(String svgString, Map settings, HttpServletResponse response, RPCManager rpc) throws Exception {
        Object os;
        String usedFormat;
        if (settings == null) {
            settings = Collections.EMPTY_MAP;
        }
        IImageExporter imageExporter = (IImageExporter)InterfaceProvider.load("IImageExporter");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String imageFormat = (String)settings.get("exportImageFormat");
        if (imageFormat == null || "png".equals(imageFormat)) {
            imageExporter.writePNG(baos, svgString);
            usedFormat = "png";
        } else if ("jpeg".equals(imageFormat)) {
            double quality = DataTools.asDouble(settings.get("exportImageQuality"));
            Float qualityF = Double.isNaN(quality) || quality < 0.0 || 1.0 < quality ? null : Float.valueOf((float)quality);
            imageExporter.writeJPEG(baos, svgString, qualityF);
            usedFormat = "jpeg";
        } else {
            throw new Exception("Unsupported export image format '" + imageFormat + "'");
        }
        String exportDisplay = (String)settings.get("exportDisplay");
        if ("return".equals(exportDisplay)) {
            HashMap<String, String> responseData = new HashMap<String, String>();
            String encodedImageData = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
            responseData.put("usedFormat", usedFormat);
            responseData.put("base64", encodedImageData);
            RPCResponse rpcResponse = new RPCResponse(responseData);
            rpcResponse.setStatus(RPCResponse.STATUS_SUCCESS);
            return rpcResponse;
        }
        rpc.doCustomResponse();
        String fileName = (String)settings.get("exportFilename");
        if (fileName != null && fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        if (fileName == null) {
            fileName = "image";
        }
        if (fileName.lastIndexOf(".") == -1) {
            fileName = fileName + "." + usedFormat;
        }
        boolean toFilesystem = DataTools.getBoolean(settings, "exportToFilesystem", false);
        String qname = config.getPath("export.location");
        if (toFilesystem) {
            String path;
            List enabledBuiltinMethods = config.getList("RPCManager.enabledBuiltinMethods");
            if (!enabledBuiltinMethods.contains("saveFile") && !enabledBuiltinMethods.contains("*")) {
                throw new Exception("Attempt to execute RPC DMI Builtin 'exportImage' in a way that saves to the filesystem DENIED by server.properties configuration.  To enable saving exported images to the filesystem, add 'saveFile' to the list of methods under RPCManager.enabledBuiltinMethods in server.properties");
            }
            if (qname == null) {
                qname = "";
            }
            if (!qname.endsWith("/") && qname.length() > 0) {
                qname = qname + "/";
            }
            if ((path = (String)settings.get("exportPath")) != null) {
                qname = qname + path;
            }
            if (!qname.endsWith("/") && qname.length() > 0) {
                qname = qname + "/";
            }
            if (fileName != null) {
                qname = qname + fileName;
            }
            os = new FileOutputStream(qname);
        } else {
            String mimeType = DataExport.getMimeTypeForImageFormat(usedFormat);
            response.setContentType(mimeType);
            String encodedFileNameParam = rpc.encodeParameter("fileName", fileName);
            if ("download".equals(exportDisplay)) {
                response.addHeader("content-disposition", "attachment; " + encodedFileNameParam);
            } else {
                response.addHeader("content-disposition", "inline; " + encodedFileNameParam);
            }
            os = response.getOutputStream();
        }
        baos.writeTo((OutputStream)os);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        return null;
    }

    public static RPCResponse areServerTimingsTracked(HttpServletRequest req) {
        Boolean tracked = (Boolean)req.getSession().getAttribute("__isc_trackServerTimings");
        if (tracked == null) {
            tracked = config.getBoolean((Object)"DSRequest.returnTimingData", false);
        }
        return new RPCResponse(tracked);
    }

    public static RPCResponse trackServerTimings(boolean track, HttpServletRequest req) {
        req.getSession().setAttribute("__isc_trackServerTimings", (Object)track);
        return new RPCResponse(track);
    }
}

