/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;

public class ErrorReport
extends LinkedMap
implements Serializable {
    public void addError(String fieldName, String message) {
        ErrorMessage em = new ErrorMessage();
        em.setErrorString(message);
        DataTools.putMultiple((Map)((Object)this), fieldName, em);
    }

    public void addError(String fieldName, String message, String suggestedValue) {
        ErrorMessage em = new ErrorMessage();
        em.setErrorString(message);
        em.setSuggestedValue(suggestedValue);
        DataTools.putMultiple((Map)((Object)this), fieldName, em);
    }

    public void addError(String fieldName, ErrorMessage error) {
        DataTools.putMultiple((Map)((Object)this), fieldName, error);
    }

    public List getErrors(String fieldName) {
        return DataTools.makeListIfSingle(this.get(fieldName));
    }

    public static ErrorReport toImpliedForm(Map in) {
        ErrorReport out = new ErrorReport();
        for (String path : in.keySet()) {
            ErrorReport er = (ErrorReport)in.get(path);
            String[] tokens = path.split("/");
            String[] namePath = new String[tokens.length / 2 - 1];
            int[] index = new int[namePath.length];
            int k = 0;
            for (int j = 2; j < tokens.length; ++j) {
                namePath[k] = tokens[j++];
                try {
                    index[k] = Integer.parseInt(tokens[j]);
                    ++j;
                }
                catch (NumberFormatException nfe) {
                    index[k] = -1;
                }
                if (++k >= namePath.length) break;
            }
            ErrorReport work = out;
            for (int j = 0; j < namePath.length; ++j) {
                List<ErrorReport> list;
                if (namePath[j] == null || "".equals(namePath[j])) continue;
                if (work.get(namePath[j]) == null) {
                    if (index[j] == -1) {
                        work.put(namePath[j], new ErrorReport());
                    } else {
                        list = new ExpandingList();
                        list.add(index[j], new ErrorReport());
                        work.put(namePath[j], list);
                    }
                } else if (index[j] != -1) {
                    list = (List)work.get(namePath[j]);
                    if (list.size() <= index[j]) {
                        list.add(index[j], new ErrorReport());
                    } else if (list.get(index[j]) == null) {
                        list.set(index[j], new ErrorReport());
                    }
                }
                work = index[j] == -1 ? (ErrorReport)work.get(namePath[j]) : (ErrorReport)((List)work.get(namePath[j])).get(index[j]);
            }
            for (String fieldName : er.keySet()) {
                if ("recordPath".equals(fieldName)) continue;
                work.put(fieldName, er.get(fieldName));
            }
        }
        return out;
    }

    public static class ExpandingList
    extends ArrayList {
        public void add(int arg0, Object arg1) {
            if (this.size() <= arg0) {
                while (this.size() <= arg0) {
                    this.add(null);
                }
                super.set(arg0, arg1);
            } else {
                super.add(arg0, arg1);
            }
        }
    }
}

