/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.MemoryDataSource;
import com.isomorphic.datasource.MemoryStore;
import com.isomorphic.hibernate.HibernateDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTableCreator;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.tools.BuiltinRPC;
import com.isomorphic.tools.DataImport;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.hibernate.cfg.Configuration;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class SQLImport
extends Base {
    private static Logger log = new Logger(SQLImport.class.getName());
    static PrintStream out = System.out;
    static PrintStream err = System.err;
    public static boolean interactive = true;
    public static boolean debug = true;
    public static boolean doWork = true;
    public static boolean continueOnError = false;
    public static boolean dropTables = false;
    public static boolean createTables = true;
    public static boolean schemaOnly = false;
    public static boolean showHelp = false;
    public static boolean onlySimpleModeList = false;
    public static boolean projectDataSources = false;
    public static boolean oracle = false;
    public static boolean mysql = false;
    public static boolean postgres = false;
    public static boolean sqlserver = false;
    public static boolean db2 = false;
    public static boolean hsqldb = false;
    public static boolean cache = false;
    public static boolean firebird = false;
    public static boolean generic = false;
    public static boolean informix = false;
    public static boolean doShutdown = true;

    public static List getFullDSList(List dataSources) {
        ArrayList<String> fullDSList = new ArrayList<String>();
        for (String dsName : dataSources) {
            if (dsName.indexOf("/") != -1) {
                File dsDir = new File(dsName);
                if (!dsDir.isDirectory()) continue;
                File[] fileList = dsDir.listFiles();
                for (int ii = 0; ii < fileList.length; ++ii) {
                    String fileName;
                    File f = fileList[ii];
                    if (!f.isFile() || (fileName = f.getName()).indexOf(".ds.") == -1 || fullDSList.contains(dsName = fileName.substring(0, fileName.indexOf(".ds.")))) continue;
                    fullDSList.add(dsName);
                }
                continue;
            }
            if (fullDSList.contains(dsName)) continue;
            fullDSList.add(dsName);
        }
        return fullDSList;
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "sqlImport [options] <dataSourceList>";
        Options options = new Options();
        options.addOption("b", "batch", false, "Enable non-interactive mode");
        options.addOption("d", "debug", false, "Output debugging messages");
        options.addOption("n", false, "Show what would be done only - do not make changes to db");
        options.addOption("k", false, "Do not exit on error");
        options.addOption("t", "droptables", false, "Drop (i.e. delete) tables if they already exist");
        options.addOption("s", "schemaonly", false, "Create tables only - do not import test data");
        options.addOption("h", "help", false, "Show usage message and exit");
        options.addOption("l", "simpleModeList", false, "Also import DataSources listed in config parameter datasources.simpleModeList");
        options.addOption("p", "projectDataSources", false, "Also import all datasources found in paths specified by the project.datasources config param");
        options.addOption("o", "onlySimpleModeList", false, "ONLY import DataSources from simpleModeList");
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("b")) {
                interactive = false;
            }
            if (line.hasOption("d")) {
                debug = true;
            }
            if (line.hasOption("n")) {
                doWork = false;
            }
            if (line.hasOption("k")) {
                continueOnError = true;
            }
            if (line.hasOption("t")) {
                dropTables = true;
            }
            if (line.hasOption("s")) {
                schemaOnly = true;
            }
            if (line.hasOption("o")) {
                onlySimpleModeList = true;
            }
            if (line.hasOption("p")) {
                projectDataSources = true;
            }
            if (line.hasOption("h")) {
                SQLImport.outputHelp(cmdLineSyntax, options);
                System.exit(1);
            }
            List dataSources = line.getArgList();
            if (line.hasOption("l") || line.hasOption("o")) {
                List l = config.getList((Object)"datasources.simpleModeList", new ArrayList());
                dataSources.addAll(l);
            }
            if (line.hasOption("p")) {
                List projectDataSourcePaths = config.getList((Object)"project.datasources", new ArrayList());
                for (String dsPath : projectDataSourcePaths) {
                    String project = config.getString((Object)"project");
                    if (config.getBoolean((Object)"devenv", false) && !"SDKPackage".equals(project) && (dsPath.contains("/SDKPackage/") || dsPath.contains("/QA/") || dsPath.contains("/webroot/tools/"))) continue;
                    dataSources.add(dsPath);
                }
            }
            if (dataSources.size() == 0) {
                System.err.println("No datasources specified");
                SQLImport.outputHelp(cmdLineSyntax, options);
                System.exit(1);
            }
            dataSources = SQLImport.getFullDSList(dataSources);
            LinkedList<String> hibernateDSNames = new LinkedList<String>();
            LinkedList<String> nonHBDSNames = new LinkedList<String>();
            for (String dsName : dataSources) {
                DataSource ds = DataSourceManager.getDataSource((String)dsName, null);
                if (ds != null && "hibernate".equals(ds.getType())) {
                    hibernateDSNames.add(dsName);
                    continue;
                }
                nonHBDSNames.add(dsName);
            }
            if (dropTables && hibernateDSNames.size() > 0) {
                if (interactive) {
                    System.out.println("You have specified that tables should be dropped, and at least one Hibernate DataSource is to be imported.");
                    System.out.println("This will cause ALL Hibernate-managed tables to be dropped and re-imported.  Is this OK? (y/n)");
                    int input = System.in.read();
                    if (input != 121 && input != 89) {
                        return;
                    }
                }
                SQLImport.recreateHibernateSchema();
                if (!onlySimpleModeList) {
                    List allDSList = BuiltinRPC.getDefinedDataSourcesAsList();
                    for (Map dsDef : allDSList) {
                        if (!"hibernate".equals(dsDef.get("dsType")) || hibernateDSNames.contains(dsDef.get("dsName"))) continue;
                        hibernateDSNames.add((String)dsDef.get("dsName"));
                    }
                }
            }
            ArrayList<String> failed = new ArrayList<String>();
            ArrayList<String> succeeded = new ArrayList<String>();
            for (String dsName : hibernateDSNames) {
                err.println("Importing datasource: " + dsName);
                try {
                    SQLImport.processDataSource(dsName);
                    succeeded.add(dsName);
                }
                catch (ConstraintViolationException cve) {
                    failed.add(dsName);
                }
                catch (Exception e) {
                    log.error((Object)("Attempt to process datasource '" + dsName + "' caught top-level exception"), (Throwable)e);
                }
            }
            log.warn((Object)("We successfully imported the following dataSources: " + succeeded));
            if (failed.size() > 0) {
                log.warn((Object)("We failed to import the following dataSources: " + failed));
            }
            for (String dsName : nonHBDSNames) {
                err.println("Importing datasource: " + dsName);
                try {
                    SQLImport.processDataSource(dsName);
                }
                catch (Exception e) {
                    log.error((Object)("Attempt to process datasource '" + dsName + "' caught top-level exception"), (Throwable)e);
                }
            }
            try {
                if (doShutdown) {
                    SQLConnectionManager.shutdownHSQLDatabases();
                }
            }
            catch (Exception he) {
                log.error((Object)"Problem shutting down HSQL dtabases", (Throwable)he);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nUtility to create database table(s) in the current project's SQL database (as set up by the 'dev' script), from the datasource and test data files.\n\n Examples:\n> sqlImport -tk supplyItem\n> sqlImport --schemaonly task");
    }

    public static boolean processDataSource(String dsName) throws Exception {
        block11: {
            if (dsName.endsWith(".ds.js")) {
                dsName = dsName.substring(0, dsName.length() - 6);
            } else if (dsName.endsWith(".ds.xml")) {
                dsName = dsName.substring(0, dsName.length() - 7);
            }
            DataSource ds = DataSourceManager.getDataSource((String)dsName, null);
            if (ds == null) {
                throw new Exception("Could not find datasource: " + dsName);
            }
            try {
                if (ds instanceof SQLDataSource) {
                    SQLImport.processSQLDataSource((SQLDataSource)ds);
                    break block11;
                }
                if (ds instanceof HibernateDataSource) {
                    SQLImport.processHibernateDataSource((HibernateDataSource)ds);
                    break block11;
                }
                if (ds instanceof MemoryDataSource) {
                    if (dropTables) {
                        MemoryStore.deleteStore((String)((MemoryDataSource)ds).getStoreName());
                        MemoryStore.createStore((String)((MemoryDataSource)ds).getStoreName(), (DataSource)((MemoryDataSource)ds));
                    }
                    SQLImport.importData(ds);
                    break block11;
                }
                err.println("Skipping non-SQL DataSource: '" + dsName + "'");
                boolean bl = false;
                return bl;
            }
            finally {
                DataSourceManager.freeDataSource((DataSource)ds);
            }
        }
        return true;
    }

    public static void recreateHibernateSchema() {
        try {
            Configuration hibernateConfig = HibernateDataSource.getStaticHibernateConfig();
            SchemaExport se = new SchemaExport(hibernateConfig);
            se.drop(debug, doWork);
            se.create(debug, doWork);
            List exceptions = se.getExceptions();
            if (exceptions != null && exceptions.size() > 0) {
                Iterator i = exceptions.iterator();
                while (i.hasNext()) {
                    log.warn((Object)"SchemaExport", i.next());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error recreating Hibernate schema", (Throwable)e);
        }
    }

    public static void processHibernateDataSource(HibernateDataSource ds) throws Exception {
        String dsName = ds.getName();
        Configuration hibernateConfig = ds.getHibernateConfig();
        if (!dropTables) {
            SchemaUpdate su = new SchemaUpdate(hibernateConfig);
            su.execute(debug, doWork);
        }
        if (!schemaOnly && doWork) {
            SQLImport.importData((DataSource)ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processSQLDataSource(SQLDataSource ds) throws Exception {
        Connection conn = SQLConnectionManager.getConnection((String)ds.getDriver().getDBName());
        String dbURL = conn.getMetaData().getURL();
        SQLConnectionManager.free((Connection)conn);
        Map dsConfig = ds.getConfig();
        String databaseName = (String)dsConfig.get("dbName");
        if (databaseName == null) {
            databaseName = config.getString((Object)"sql.defaultDatabase");
        }
        if (databaseName == null) {
            throw new Exception("config file for datasource: " + ds.getName() + " does not define a database and no default has been specified in the master config file. Unable to continue");
        }
        if (config.getBoolean((Object)"wwwProduction", false) && !databaseName.equals("webdemos") && !config.getBoolean((Object)"allowWWWProductionDSImport", false)) {
            throw new Exception("Refusing DataSource import for non-webdemos production table.");
        }
        if (dbURL != null && dbURL.contains("www") && !dbURL.contains("-test") && !config.getBoolean((Object)"allowWWWProductionDSImport", false)) {
            throw new Exception("Processing DataSource '" + ds.getName() + "' would alter production www data (JDBC URL: " + dbURL + ") - cowardly refusing to process this DataSource - to  override, set allowWWWProductionDSImport: true in server.properties");
        }
        if (dbURL != null && dbURL.contains("wrath") && !config.getBoolean((Object)"allowWrathProductionDSImport", false)) {
            throw new Exception("Processing DataSource '" + ds.getName() + "' would alter production wrath data (JDBC URL: " + dbURL + ") - cowardly refusing to process this DataSource - to  override, set allowWrathProductionDSImport: true in server.properties");
        }
        StringBuffer tableBuild = new StringBuffer();
        informix = false;
        generic = false;
        firebird = false;
        hsqldb = false;
        db2 = false;
        sqlserver = false;
        postgres = false;
        mysql = false;
        oracle = false;
        String dbType = config.getString((Object)("sql." + databaseName + ".database.type"));
        if (dbType.equals("oracle")) {
            oracle = true;
        } else if (dbType.equals("mysql")) {
            mysql = true;
        } else if (dbType.equals("postgresql")) {
            postgres = true;
        } else if (dbType.equals("sqlserver")) {
            sqlserver = true;
        } else if (dbType.equals("db2") || dbType.equals("db2iSeries")) {
            db2 = true;
        } else if (dbType.equals("hsqldb")) {
            hsqldb = true;
        } else if (dbType.equals("cache")) {
            cache = true;
        } else if (dbType.equals("firebirdsql") || dbType.equals("firebird")) {
            firebird = true;
        } else if (dbType.equals("generic")) {
            generic = true;
        } else if (dbType.equals("informix")) {
            informix = true;
        }
        SQLTableCreator.createTable((SQLDataSource)ds, (boolean)dropTables, (boolean)debug, (boolean)doWork, (boolean)false);
        boolean importSuccess = true;
        if (!schemaOnly && doWork) {
            importSuccess = SQLImport.importData((DataSource)ds);
        }
        if ((oracle || postgres) && importSuccess && dropTables && doWork) {
            SQLImport.rebuildSequences(ds);
        }
        if (mysql) {
            ds.executeNativeUpdate("SET foreign_key_checks = 1", null);
        } else if (sqlserver) {
            ds.executeNativeUpdate("EXEC sp_msforeachtable \"ALTER TABLE ? WITH CHECK CHECK CONSTRAINT all\"");
        }
        DataSource auditDS = null;
        try {
            auditDS = ds.getAuditDataSource();
            if (auditDS != null) {
                SQLImport.processSQLDataSource((SQLDataSource)auditDS);
            }
        }
        finally {
            DataSourceManager.free((DataSource)auditDS);
        }
    }

    public static void rebuildSequences(SQLDataSource ds) throws Exception {
        Map sequences = ds.getTable().getSequences();
        for (String sequence : sequences.keySet()) {
            String sequenceFieldName = ds.getFieldNameFromColumnName(sequence);
            String sequenceName = SQLDriver.getSequenceName((String)sequence, (Map)sequences, (String)ds.getTable().getName(), (SQLDriver)ds.getDriver());
            try {
                Long newCount = new Long(0L);
                String startString = (String)ds.getField(sequenceFieldName).get((Object)"sequenceStart");
                if (startString != null) {
                    newCount = Long.parseLong(startString);
                }
                if (newCount == 0L) {
                    Object count = ds.getDriver().executeScalar("SELECT MAX(" + ds.escapeColumnName((Object)sequence) + ") FROM " + ds.getTable().getName(), null);
                    Long currentCount = new Long(0L);
                    if (count != null) {
                        currentCount = new Long(count.toString());
                    }
                    newCount = new Long(currentCount + 1L);
                }
                ds.executeNativeUpdate("DROP SEQUENCE " + sequenceName, null);
                String sequenceCreate = "CREATE SEQUENCE " + sequenceName;
                int increment = 0;
                String incrementString = (String)ds.getField(sequenceFieldName).get((Object)"sequenceIncrement");
                if (incrementString != null) {
                    increment = Integer.parseInt(incrementString);
                }
                if (increment == 0) {
                    increment = 1;
                }
                if (oracle || db2) {
                    sequenceCreate = sequenceCreate + " INCREMENT BY " + increment + " START WITH ";
                }
                if (postgres) {
                    sequenceCreate = sequenceCreate + " INCREMENT " + increment + " START ";
                }
                sequenceCreate = sequenceCreate + newCount.toString();
                ds.executeNativeUpdate(sequenceCreate, null);
            }
            catch (Exception ee) {
                out.println("unable to rebuild sequence: " + sequenceName + " for sequenced column: " + sequence);
                throw ee;
            }
        }
    }

    public static String dsTypeForDBType(Number dbType, String dbName) throws Exception {
        switch (dbType.intValue()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return "text";
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "number";
            }
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
        }
        return "text";
    }

    public static boolean dsTypeIsString(String dsType) {
        return "text".equals(dsType);
    }

    public static boolean importData(DataSource ds) throws Exception {
        if (ds == null) {
            return false;
        }
        String testFileName = ds.getTestFileName();
        if (testFileName == null) {
            log.warn((Object)("importData(" + ds.getName() + "): No test file"));
            return false;
        }
        log.warn((Object)("importData(" + ds.getName() + "): Got test filename " + testFileName));
        Object rowData = null;
        DataImport dataImport = null;
        if (testFileName.endsWith(".xml")) {
            dataImport = new DataImport(DataImport.ImportFormat.XML, null);
        } else if (testFileName.endsWith(".csv")) {
            dataImport = new DataImport();
        }
        if (dataImport != null) {
            DSResponse resp = ds.executeGetTestData(new DSRequest());
            Reader testDataReader = (Reader)resp.getDataMap().get("testData");
            rowData = dataImport.importToRows(testDataReader, null, null, ds);
            try {
                testDataReader.close();
            }
            catch (IOException iOException) {}
        } else {
            rowData = SQLImport.loadJSTestData(ds, testFileName);
        }
        if (!(rowData instanceof List)) {
            log.warn((Object)("Test data loaded for DS '" + ds.getName() + "' from file " + testFileName + (rowData == null ? " is null" : " is a " + rowData.getClass().getName()) + ".  Test data must be a list of records."));
            return false;
        }
        List rows = (List)rowData;
        rows = (List)ds.toRecords((Object)rows);
        log.warn((Object)("importData(" + ds.getName() + "): " + rows.size() + " rows"));
        try {
            DSRequest req = new DSRequest(ds.getName(), "insert");
            req.setSkipAudit(true);
            req.setValues((Object)rows);
            req.forceInvalidateCache(true);
            ds.execute(req);
            if ("hibernate".equals(ds.getType())) {
                ((HibernateDataSource)ds).freeResources(req);
            }
        }
        catch (Exception e) {
            if (!continueOnError) {
                throw e;
            }
            e.printStackTrace();
        }
        return true;
    }

    public static Object loadJSTestData(DataSource ds, String testFileName) throws Exception {
        Map dataMap = DataStructCache.getDataMap((String)testFileName);
        DataStructCache.cache.clearCacheEntry((Object)testFileName);
        String variableName = ds.getName() + "TestData";
        Object testData = dataMap.get(variableName);
        if (testData == null && dataMap.size() > 0) {
            log.warn((Object)("Variable " + variableName + " not found in test data file " + testFileName + " falling back to first declared variable"));
            variableName = (String)dataMap.keySet().iterator().next();
            testData = dataMap.get(variableName);
        }
        if (testData == null) {
            log.warn((Object)("No variables declared in test data file " + testFileName));
            return null;
        }
        return testData;
    }
}

