/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class HSQLDBDriver
extends SQLDriver {
    private static Logger log = new Logger(HSQLDBDriver.class.getName());
    public static final int UNIQUE_CONSTRAINT_VIOLATED = 1;
    boolean supportsSQLLimit = true;

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new HSQLDBDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new HSQLDBDriver(dbName);
    }

    public HSQLDBDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public HSQLDBDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    public boolean supportsSQLLimit() {
        return true;
    }

    public String limitQuery(String query, long startRow, long batchSize, List outputColumns) {
        return "SELECT LIMIT " + startRow + " " + batchSize + " " + query.substring("SELECT".length());
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("HSQLDB can't handle more than one auto_increment primary_key");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            String obj = HSQLDBDriver.getScalarResult("CALL IDENTITY()", this.dbConnection, this.dbName, this, req).toString();
            Long sequenceValue = new Long(obj.toString());
            primaryKeys.put(sequenceName, sequenceValue);
        }
        return primaryKeys;
    }

    public String formatValue(Object value) {
        return value.toString();
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/g", value.toString());
        if (escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\'g", escaped);
            escaped = globalPerl.substitute("s'%'\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\_'g", escaped);
        }
        return escaped;
    }

    public String escapeClause() {
        return " ESCAPE '\\'";
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "null";
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        return this.caseExpression(column, valueMap.entrySet().iterator(), request);
    }

    private String caseExpression(String column, Iterator entries, DSRequest request) {
        if (!entries.hasNext()) {
            return "CAST (" + column + " AS LONGVARCHAR)";
        }
        Map.Entry entry = (Map.Entry)entries.next();
        String actualValue = (String)entry.getKey();
        String displayValue = this.getLocalizedDisplayValue(entry.getValue(), request);
        displayValue = this.escapeValue(displayValue);
        return "CASEWHEN(" + column + "='" + actualValue + "', " + displayValue + ", " + this.caseExpression(column, entries, request) + ")";
    }

    public Timestamp adjustTimestamp(Timestamp timestamp) {
        long millis = timestamp.getTime();
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(millis);
        return new Timestamp(millis + (long)offset);
    }

    public boolean canSetFetchSize() {
        return false;
    }

    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    public String sqlConcat(String ... strings) {
        return super.sqlConcat(strings);
    }

    public String getDummyQuery() {
        return "SELECT 1 FROM (VALUES(0))";
    }
}

