/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.interfaces.IAssembly;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSSyntaxScanner;
import com.isomorphic.js.TrailingCommaException;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSSyntaxScannerFilter
extends BaseFilter {
    Map ignoreList;
    public boolean scanAssembledFiles = false;
    public List scannableMimeTypes = null;
    public boolean sendErrorsToBrowser = true;
    private String isomorphicPathComponent;
    private String isomorphicURIComponent;
    private boolean devenv;

    public void setScanAssembledFiles(String value) {
        this.scanAssembledFiles = Boolean.valueOf(value);
    }

    public void setScannableMimeTypes(String value) {
        List<String> list = DataTools.commaSeparatedStringToList(value);
        this.scannableMimeTypes = new ArrayList();
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            String mimeType = i.next().toString().toLowerCase();
            if (mimeType.equals("")) continue;
            this.scannableMimeTypes.add(mimeType);
        }
    }

    public void setSendErrorsToBrowser(String value) {
        this.sendErrorsToBrowser = Boolean.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            if (!this.scanAssembledFiles) {
                JSSyntaxScannerFilter jSSyntaxScannerFilter = this;
                synchronized (jSSyntaxScannerFilter) {
                    if (this.ignoreList == null) {
                        this.ignoreList = new HashMap();
                    }
                    if (InterfaceProvider.exists("IAssembly")) {
                        try {
                            IAssembly assembly = (IAssembly)InterfaceProvider.load("IAssembly");
                            Iterator i = assembly.getRegisteredURLs().iterator();
                            while (i.hasNext()) {
                                this.ignoreList.put(i.next(), "URL is registered with the FileAssembler");
                            }
                        }
                        catch (Exception e) {
                            this.log.info("Couldn't load list of FileAssembler URLs - if the filter intercepts those URLs, they will be scanned.");
                        }
                    }
                    this.log.debug("Ignore list: " + DataTools.prettyPrint(this.ignoreList));
                }
            }
            this.isomorphicPathComponent = ISCFile.canonicalizePath("/" + config.getString("isomorphicPathRootRelative") + "/");
            this.isomorphicURIComponent = ISCFile.canonicalizePath("/" + config.getString("isomorphicURIRootRelative") + "/");
            this.devenv = config.getBoolean((Object)"devenv", false);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize JSSyntaxScannerFilter.", e);
            throw new ServletException(e.getMessage());
        }
    }

    private boolean mimeTypeIsScannable(String mimeType) {
        if (mimeType == null || this.scannableMimeTypes == null) {
            return false;
        }
        mimeType = mimeType.toLowerCase();
        for (String scannableMimeType : this.scannableMimeTypes) {
            if (mimeType.indexOf(scannableMimeType) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        block42: {
            block40: {
                block39: {
                    request = (HttpServletRequest)req;
                    response = (HttpServletResponse)res;
                    context = null;
                    try {
                        try {
                            block41: {
                                context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
                                logPrefix = context.requestPath + ": ";
                                requestURI = ServletTools.getCurrentRequestURI((HttpServletRequest)context.request);
                                scan = true;
                                if (!ServletTools.compressionWorksForContext(context, this.log)) {
                                    scan = false;
                                }
                                mimeType = ServletTools.mimeTypeForContext(context);
                                if (scan && mimeType != null && !this.mimeTypeIsScannable(mimeType)) {
                                    scan = false;
                                    this.log.debug(logPrefix + "ignoring non-scannable mimeType: " + mimeType + ", not bufferring");
                                }
                                if (this.ignoreList != null && (ignoreReason = (String)this.ignoreList.get(requestURI)) != null) {
                                    scan = false;
                                    this.log.debug(logPrefix + "not scanning URI: " + requestURI + " because: " + ignoreReason);
                                }
                                if (scan) {
                                    if (this.devenv) {
                                        if (requestURI.contains(this.isomorphicPathComponent + "modules/") || requestURI.contains(this.isomorphicURIComponent + "development/") || requestURI.contains(this.isomorphicPathComponent + "modules/") || requestURI.contains(this.isomorphicURIComponent + "development/")) {
                                            scan = false;
                                        }
                                    } else if (requestURI.contains(this.isomorphicPathComponent) || requestURI.contains(this.isomorphicURIComponent)) {
                                        scan = false;
                                    }
                                }
                                if (!scan) {
                                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                    var25_15 = null;
                                    break block39;
                                }
                                wrapBuf = new ByteArrayOutputStream();
                                wrapResponse = new ProxyHttpServletResponse(response, new ProxyServletOutputStream(wrapBuf), "JSSyntaxScannerFilter");
                                chain.doFilter((ServletRequest)request, (ServletResponse)wrapResponse);
                                if (wrapResponse.dontCopyStreams) {
                                    this.log.debug(logPrefix + "WrapResponse dictates no stream - not scanning.");
                                    break block40;
                                }
                                wrapResponse.flushBuffer();
                                if (response.containsHeader("Content-Encoding")) {
                                    scan = false;
                                    this.log.debug(logPrefix + "Content-Encoding was set by filtered content - not scanning");
                                }
                                if ((wrapMimeType = wrapResponse.iscGetContentType()) != null) {
                                    mimeType = wrapMimeType;
                                }
                                if (scan && !this.mimeTypeIsScannable(mimeType)) {
                                    scan = false;
                                    this.log.debug(logPrefix + "ignoring non-scannable mimeType: " + mimeType);
                                }
                                doSendErrorsToBrowser = this.sendErrorsToBrowser;
                                errors = null;
                                if (scan) {
                                    scanner = JSSyntaxScanner.instance();
                                    try {
                                        if (mimeType.indexOf("text/html") != -1) {
                                            fileName = requestURI;
                                            if (requestURI.toLowerCase().endsWith(".jsp")) {
                                                fileName = fileName + " (line numbers refer to result of jsp execution, considering only JS script blocks)";
                                            }
                                            this.log.info(logPrefix + "scanning <script> tags in html output");
                                            scanner.scanHTML(wrapBuf.toString(), fileName);
                                        } else {
                                            doSendErrorsToBrowser = false;
                                            this.log.info(logPrefix + "scanning js source");
                                            scanner.scanJS(wrapBuf.toString(), requestURI);
                                        }
                                    }
                                    catch (TrailingCommaException tce) {
                                        errors = tce.toString();
                                        this.log.error(tce);
                                        source = IOUtil.inputStreamToString(this.servletContext.getResourceAsStream(requestURI));
                                        if (source == null) {
                                            source = wrapBuf.toString();
                                        }
                                        reader = new LineNumberReader(new StringReader(source));
                                        commaLine = tce.commaLine;
                                        foundMatch = false;
                                        while ((line = reader.readLine()) != null) {
                                            if (!line.startsWith(commaLine)) continue;
                                            foundMatch = true;
                                            errorLocation = "possible source of last error: " + requestURI + ", line: " + reader.getLineNumber() + " - line reads:\n" + line;
                                            errors = errors + "\n" + errorLocation;
                                            this.log.error(errorLocation);
                                        }
                                        if (foundMatch) break block41;
                                        commaLine = commaLine.trim();
                                        while ((line = reader.readLine()) != null) {
                                            if (line.indexOf(commaLine) == -1) continue;
                                            errorLocation = "possible source of last error: " + requestURI + ", line: " + reader.getLineNumber() + " - line reads:\n" + line;
                                            errors = errors + "\n" + errorLocation;
                                            this.log.error(errorLocation);
                                        }
                                    }
                                }
                            }
                            if (errors != null && doSendErrorsToBrowser) {
                                context.out().write("<HTML><BODY><B><U>JSSyntaxScannerFilter Error Report:</U></B><P><PRE>");
                                context.out().write(errors);
                                context.out().write("</PRE></BODY></HTML>");
                                break block42;
                            } else {
                                out = response.getOutputStream();
                                wrapBuf.writeTo((OutputStream)out);
                                try {
                                    out.flush();
                                }
                                catch (Exception var17_32) {
                                }
                            }
                            break block42;
                        }
                        catch (ServletException se) {
                            throw se;
                        }
                        catch (IOException ioe) {
                            throw ioe;
                        }
                        catch (Exception e) {
                            this.log.error("Caught exception in doFilter() - for URI: " + request.getRequestURI() + "\n" + DataTools.getStackTrace(e));
                            var25_18 = null;
                            try {
                                response.flushBuffer();
                                return;
                            }
                            catch (Exception var26_23) {
                                return;
                            }
                        }
                    }
                    catch (Throwable var24_39) {
                        var25_19 = null;
                        ** try [egrp 4[TRYBLOCK] [16 : 1200->1210)] { 
lbl118:
                        // 1 sources

                        response.flushBuffer();
                        throw var24_39;
lbl120:
                        // 1 sources

                        catch (Exception var26_24) {
                            // empty catch block
                        }
                        throw var24_39;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [16 : 1200->1210)] { 
lbl125:
                // 1 sources

                response.flushBuffer();
                return;
lbl127:
                // 1 sources

                catch (Exception var26_20) {
                    // empty catch block
                }
                return;
            }
            var25_16 = null;
            ** try [egrp 4[TRYBLOCK] [16 : 1200->1210)] { 
lbl133:
            // 1 sources

            response.flushBuffer();
            return;
lbl135:
            // 1 sources

            catch (Exception var26_21) {
                // empty catch block
            }
            return;
        }
        var25_17 = null;
        try {}
        catch (Exception var26_22) {}
        response.flushBuffer();
        return;
    }
}

