/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.ByIdentifier;
import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ClassUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

class Operation {
    private String operator;
    private List<Object> operands;
    private boolean andWait;
    private static String[] stringOnlyOperators = new String[]{"sendKeys", "type", "verifyText", "verifyTable", "waitForText", "waitForEval"};

    public Operation(String operator, String operand1, String operand2) {
        Object parsed2;
        this.operator = this.convertSeleneseCommandToWebDriver(operator);
        this.operands = new ArrayList<Object>();
        Object parsed1 = this.parse(operand1);
        if (parsed1 instanceof List) {
            for (Object operand : (List)parsed1) {
                this.operands.add(operand);
            }
        } else if (parsed1 != null) {
            this.operands.add(parsed1);
        }
        if ((parsed2 = this.parse(operand2)) instanceof List) {
            for (Object operand : (List)parsed2) {
                this.operands.add(operand);
            }
        } else if (parsed2 != null) {
            this.operands.add(parsed2);
        }
    }

    private Object parse(String operand) {
        String lcOperand;
        if (operand == null) {
            return null;
        }
        String stringOperand = operand;
        if (operand.startsWith("\\")) {
            operand = operand.substring(1);
        }
        if (operand.startsWith("//")) {
            operand = "xpath=" + operand;
        }
        if ((lcOperand = operand.toLowerCase()).startsWith("sclocator=")) {
            Pattern pattern;
            Matcher matcher;
            operand = operand.substring(10);
            if (this.operator.endsWith("Table") && (matcher = (pattern = Pattern.compile("(.*)\\.(\\d+)\\.(\\d+)")).matcher(operand)).find()) {
                return new ArrayList<Object>(){
                    {
                        this.add(ByScLocator.scLocator(matcher.group(1)));
                        this.add(Long.parseLong(matcher.group(2)));
                        this.add(Long.parseLong(matcher.group(3)));
                    }
                };
            }
            return ByScLocator.scLocator(operand);
        }
        if (lcOperand.startsWith("id=")) {
            return By.ById.id((String)operand.substring(3));
        }
        if (lcOperand.startsWith("name=")) {
            return By.ByName.name((String)operand.substring(5));
        }
        if (lcOperand.startsWith("identifier=")) {
            return ByIdentifier.identifier(operand.substring(11));
        }
        if (lcOperand.startsWith("xpath=")) {
            return By.ByXPath.xpath((String)operand.substring(6));
        }
        if (this.isSendKeys()) {
            stringOperand = stringOperand.replaceAll("\\$\\{KEY_ESC\\}", "\\${KEY_ESCAPE}");
            stringOperand = stringOperand.replaceAll("\\$\\{KEY_CTRL\\}", "\\${KEY_CONTROL}");
        }
        for (int i = 0; i < stringOnlyOperators.length; ++i) {
            if (!this.operator.startsWith(stringOnlyOperators[i])) continue;
            return stringOperand;
        }
        if (Operation.isBoolean(operand)) {
            return Boolean.valueOf(operand);
        }
        return Operation.isLong(operand) ? Long.valueOf(Long.parseLong(operand)) : stringOperand;
    }

    protected static boolean isBoolean(String operand) {
        return "true".equalsIgnoreCase(operand) || "false".equalsIgnoreCase(operand);
    }

    protected static boolean isLong(String operand) {
        try {
            Long.parseLong(operand);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public boolean isVerify() {
        return this.operator.startsWith("verify");
    }

    public boolean isWaitFor() {
        return this.operator.startsWith("waitFor");
    }

    public boolean isAssert() {
        return this.operator.startsWith("assert");
    }

    public boolean isSendKeys() {
        return this.operator.startsWith("sendKeys");
    }

    public Object execute(SmartClientWebDriver driver, Class driverClass) throws Exception {
        boolean isSendKeys = this.operator.startsWith("sendKeys");
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList types = new ArrayList();
        for (Object operand : this.operands) {
            if (isSendKeys && operand instanceof String) {
                operand = this.convertSeleneseKeysToWebDriver((String)operand);
            }
            args.add(operand);
            types.add(operand.getClass());
        }
        Class[] typesArray = new Class[types.size()];
        typesArray = types.toArray(typesArray);
        for (Method method : driverClass.getMethods()) {
            Class[] params;
            if (!method.getName().equals(this.operator) || (params = method.getParameterTypes()).length != typesArray.length || !ClassUtils.isAssignable((Class[])typesArray, (Class[])params, (boolean)true)) continue;
            try {
                Boolean bl = driver != null ? method.invoke((Object)driver, args.toArray()) : Boolean.valueOf(true);
                return bl;
            }
            catch (Exception e) {
                System.err.println("!!! Problem executing: " + this);
                throw e;
            }
            finally {
                if (this.andWait) {
                    System.err.println("!!! Webdriver implictly waits and doesn't 100% support: " + this.operator + "AndWait");
                    if (driver != null) {
                        Thread.sleep(3000L);
                    }
                }
            }
        }
        throw new NoSuchMethodException("No match for: " + this);
    }

    public boolean getAndWait() {
        return this.andWait;
    }

    private String convertSeleneseCommandToWebDriver(String operator) {
        if ("dragAndDropToObject".equals(operator)) {
            return "dragAndDrop";
        }
        if ("contextMenu".equals(operator)) {
            return "contextClick";
        }
        if ("open".equals(operator)) {
            return "get";
        }
        if (operator.endsWith("AndWait")) {
            operator = operator.substring(0, operator.indexOf("AndWait"));
            this.andWait = true;
        }
        return operator;
    }

    private String convertSeleneseKeysToWebDriver(String operand) {
        Pattern keyPattern = Pattern.compile("\\$\\{KEY_([A-Z_]+)\\}");
        Matcher keyMatcher = keyPattern.matcher(operand);
        while (keyMatcher.find()) {
            Keys currentKey = Keys.valueOf((String)keyMatcher.group(1));
            operand = keyMatcher.replaceFirst(currentKey.toString());
            keyMatcher = keyPattern.matcher(operand);
        }
        return operand;
    }

    public String toJavaString() {
        String result = "driver." + this.operator + "(";
        for (int i = 0; i < this.operands.size(); ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            Object operand = this.operands.get(i);
            result = result + this.toJavaString(operand, this.operator);
        }
        return result + ");";
    }

    private String toJavaString(Object operand, String operator) {
        if (operand instanceof ByScLocator) {
            return ((ByScLocator)((Object)operand)).toJavaString();
        }
        if (operand instanceof String) {
            if (operator.startsWith("sendKeys")) {
                return this.seleneseKeysToJavaString((String)operand);
            }
            return "\"" + operand.toString() + "\"";
        }
        if (operand instanceof Long) {
            return operand.toString() + "L";
        }
        return operand.toString();
    }

    private String seleneseKeysToJavaString(String operand) {
        Pattern keyPattern = Pattern.compile("\\$\\{KEY_([A-Z_]+)\\}");
        Matcher keyMatcher = keyPattern.matcher(operand);
        if (!keyMatcher.find()) {
            return "\"" + operand + "\"";
        }
        String result = "\"" + keyMatcher.replaceAll("\" + Keys.$1 + \"") + "\"";
        result = result.replaceAll("^\"\"\\s*\\+\\s*|\\s*\\+\\s*\"\"$", "");
        if ((result = result.replaceAll("\\s*\\+\\s*\"\"\\s*\\+\\s*", " + ")).indexOf("\"") < 0) {
            result = "\"\" + " + result;
        }
        return result;
    }

    public String toString() {
        String result = this.operator + "(";
        for (int i = 0; i < this.operands.size(); ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            Object operand = this.operands.get(i);
            result = result + operand + "/" + operand.getClass().getSimpleName();
        }
        return result + ")";
    }

    public String getOperator() {
        return this.operator;
    }
}

