/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Namespace;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;

@JsxClass(isJSObject=false, isDefinedInStandardsMode=false, browsers={@WebBrowser(value=BrowserName.IE)})
public class NamespaceCollection
extends SimpleScriptable
implements Function {
    private final HTMLDocument doc_;
    private final List<Namespace> namespaces_;

    public NamespaceCollection() {
        this.doc_ = null;
        this.namespaces_ = new ArrayList<Namespace>();
    }

    public NamespaceCollection(HTMLDocument doc) {
        this.doc_ = doc;
        this.namespaces_ = new ArrayList<Namespace>();
        this.setParentScope(doc);
        this.setPrototype(this.getPrototype(this.getClass()));
        Map<String, String> namespacesMap = this.doc_.getHtmlPage().getNamespaces();
        for (Map.Entry<String, String> entry : namespacesMap.entrySet()) {
            String key = entry.getKey();
            if (key.isEmpty()) continue;
            this.namespaces_.add(new Namespace(this.doc_, key, entry.getValue()));
        }
    }

    @JsxFunction
    public final Namespace add(String namespace, String urn, String url) {
        Namespace n = new Namespace(this.doc_, namespace, urn);
        this.namespaces_.add(n);
        return n;
    }

    @JsxGetter
    public final int getLength() {
        return this.namespaces_.size();
    }

    @JsxFunction
    public final Object item(Object index) {
        if (index instanceof Number) {
            Number n = (Number)index;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(index);
        return this.get(key, (Scriptable)this);
    }

    public Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.namespaces_.size()) {
            return this.namespaces_.get(index);
        }
        return super.get(index, start);
    }

    @Override
    public Object get(String name, Scriptable start) {
        for (Namespace n : this.namespaces_) {
            if (!StringUtils.equals((CharSequence)n.getName(), (CharSequence)name)) continue;
            return n;
        }
        return super.get(name, start);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length != 1) {
            return NOT_FOUND;
        }
        return this.item(args[0]);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }
}

