/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.taglib.VirtualTag;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import java.io.File;
import java.io.FileReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class LoadWSDLTag
extends VirtualTag {
    private static Map cacheMap = Collections.synchronizedMap(new HashMap());
    public String url = null;
    public Integer cache = null;

    public int doStartTag() throws JspException {
        block9: {
            this.init();
            if (this.cache == null) {
                this.cache = config.getInteger((Object)"loadWebServices.cache", new Integer(3600));
            }
            String absoluteURL = null;
            try {
                absoluteURL = LoadWSDLTag.getAbsoluteURL(this.url, (HttpServletRequest)this.pageContext.getRequest());
                if (!ISCFile.inContainerIOMode() && this.cache > 0) {
                    File cacheFile;
                    String cacheFileName = (String)cacheMap.get(absoluteURL);
                    if (cacheFileName == null) {
                        cacheFileName = webRoot + "/isomorphicCache/loadWebService/" + DataTools.getPlaintextMD5Hash(absoluteURL);
                        cacheMap.put(absoluteURL, cacheFileName);
                    }
                    if (!(cacheFile = new File(cacheFileName)).exists() || cacheFile.lastModified() < System.currentTimeMillis() - (long)(this.cache * 1000)) {
                        try {
                            StringWriter sw = new StringWriter();
                            XML.loadWSDL(absoluteURL, sw);
                            cacheFile.getParentFile().mkdirs();
                            IOUtil.atomicWrite(sw.toString(), cacheFileName);
                        }
                        catch (Exception e) {
                            if (cacheFile.exists()) {
                                this.log.warn("Failed to fetch: " + absoluteURL + ", using possibly stale cache.");
                            }
                            throw e;
                        }
                    }
                    IOUtil.copyCharacterStreams(new FileReader(cacheFile), (Writer)this.pageContext.getOut());
                    break block9;
                }
                XML.loadWSDL(absoluteURL, (Writer)this.pageContext.getOut());
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to load schema from url: " + this.url + " (absoluteURL: " + absoluteURL + ")"), e);
            }
        }
        return 0;
    }

    public static String getAbsoluteURL(String url, HttpServletRequest request) throws Exception {
        String absoluteURL = url;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            if (!url.startsWith("/")) {
                if (request == null) {
                    throw new Exception("getAbsoulteURL() passed relative path: " + url + " with no request for context.");
                }
                String requestURI = request.getRequestURI();
                int lastSlashIndex = requestURI.lastIndexOf("/");
                absoluteURL = lastSlashIndex == -1 ? "/" + url : requestURI.substring(0, lastSlashIndex + 1) + url;
            }
            absoluteURL = Config.getGlobal().getPath("webRoot") + absoluteURL;
        }
        return absoluteURL;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setCache(Integer cache) {
        this.cache = cache;
    }

    public Integer getCache() {
        return this.cache;
    }
}

