/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;

public class SQLTableCreator
extends Base {
    private static Logger log = new Logger(SQLTableCreator.class.getName());

    public static void createTable(SQLDataSource ds, boolean dropTables) throws Exception {
        SQLTableCreator.createTable(ds, dropTables, false, true);
    }

    public static void createTable(SQLDataSource ds, boolean dropTables, boolean debug, boolean doWork) throws Exception {
        SQLTableCreator.createTable(ds, dropTables, debug, doWork, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(SQLDataSource ds, boolean dropTables, boolean debug, boolean doWork, boolean recreateSequences) throws Exception {
        Map constraints;
        Connection conn = null;
        String dbURL = null;
        try {
            conn = SQLConnectionManager.getConnection(ds.getDriver().getDBName());
            dbURL = conn.getMetaData().getURL();
        }
        catch (Throwable throwable) {
            SQLConnectionManager.free(conn);
            throw throwable;
        }
        SQLConnectionManager.free(conn);
        Map dsConfig = ds.getConfig();
        String databaseName = (String)dsConfig.get("dbName");
        if (databaseName == null) {
            databaseName = config.getString((Object)"sql.defaultDatabase");
        }
        if (databaseName == null) {
            throw new Exception("config file for datasource: " + ds.getName() + " does not define a database and no default has been specified in the master config file. Unable to continue");
        }
        if (config.getBoolean((Object)"wwwProduction", false) && !databaseName.equals("webdemos") && !config.getBoolean((Object)"allowWWWProductionDSImport", false)) {
            throw new Exception("Refusing DataSource import for non-webdemos production table.");
        }
        if (dbURL != null && dbURL.contains("www") && !dbURL.contains("-test") && !config.getBoolean((Object)"allowWWWProductionDSImport", false)) {
            throw new Exception("Processing DataSource '" + ds.getName() + "' would alter production www data (JDBC URL: " + dbURL + ") - cowardly refusing to process this DataSource - to  override, set allowWWWProductionDSImport: true in server.properties");
        }
        if (dbURL != null && dbURL.contains("wrath") && !config.getBoolean((Object)"allowWrathProductionDSImport", false)) {
            throw new Exception("Processing DataSource '" + ds.getName() + "' would alter production wrath data (JDBC URL: " + dbURL + ") - cowardly refusing to process this DataSource - to  override, set allowWrathProductionDSImport: true in server.properties");
        }
        String tableName = ds.getTable().getNameQuotedIfNecessary(ds);
        String tableDrop = "DROP TABLE " + tableName;
        StringBuffer tableBuild = new StringBuffer();
        DatabaseType databaseType = DatabaseType.Generic;
        String dbType = config.getString((Object)("sql." + databaseName + ".database.type"));
        if (dbType.equals("oracle")) {
            databaseType = DatabaseType.Oracle;
        } else if (dbType.equals("mysql")) {
            databaseType = DatabaseType.MySQL;
        } else if (dbType.equals("postgresql")) {
            databaseType = DatabaseType.Postgres;
        } else if (dbType.equals("sqlserver")) {
            databaseType = DatabaseType.SQLServer;
        } else if (dbType.equals("db2") || dbType.equals("db2iSeries")) {
            databaseType = DatabaseType.DB2;
        } else if (dbType.equals("hsqldb")) {
            databaseType = DatabaseType.HSQLDB;
        } else if (dbType.equals("cache")) {
            databaseType = DatabaseType.Cache;
        } else if (dbType.equals("firebirdsql") || dbType.equals("firebird")) {
            databaseType = DatabaseType.Firebird;
        } else if (dbType.equals("generic")) {
            databaseType = DatabaseType.Generic;
        } else if (dbType.equals("informix")) {
            databaseType = DatabaseType.Informix;
        }
        tableBuild.append("CREATE " + (databaseType == DatabaseType.HSQLDB ? "CACHED " : "") + "TABLE " + tableName + " (");
        boolean gotColumn = false;
        LinkedHashSet noDups = new LinkedHashSet(ds.getFieldNames());
        for (String fieldName : noDups) {
            DSField field = ds.getField(fieldName);
            String fieldTable = (String)field.get((Object)"tableName");
            if (fieldTable != null && !fieldTable.equals(ds.getTable().getName())) continue;
            String columnName = ds.getColumnName(fieldName);
            String sqlColumn = SQLTableCreator.dsFieldToSQLColumn(ds, fieldName, databaseType);
            if (sqlColumn == null) continue;
            if (gotColumn) {
                tableBuild.append(", ");
            }
            gotColumn = true;
            tableBuild.append(ds.escapeColumnName(columnName) + " " + sqlColumn);
        }
        if (!gotColumn) {
            throw new Exception("Empty table definition");
        }
        List primaryKeys = ds.getPrimaryKeys();
        if (primaryKeys.size() > 0) {
            if (databaseType == DatabaseType.Cache) {
                Iterator i = primaryKeys.iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    DSField dsField = ds.getField(key);
                    String nativeName = dsField.getNativeName();
                    if (nativeName == null) {
                        nativeName = key;
                    }
                    if (!nativeName.equals("ID") && !nativeName.equals("%ID")) continue;
                    i.remove();
                }
            }
            if (primaryKeys.size() > 0) {
                tableBuild.append(", " + SQLTableCreator.sqlForConstraint(ds, primaryKeys, "PRIMARY KEY", databaseType));
            }
        }
        if ((constraints = (Map)dsConfig.get("unique")) != null) {
            for (String constraintID : constraints.keySet()) {
                Map constraint = (Map)constraints.get(constraintID);
                String constraintType = (String)constraint.get("type");
                if (constraintType == null) {
                    constraintType = "UNIQUE";
                }
                List constraintFields = (List)constraint.get("fields");
                String sqlConstraint = SQLTableCreator.sqlForConstraint(ds, constraintFields, constraintType, constraintID, databaseType);
                tableBuild.append(", " + sqlConstraint);
            }
        }
        tableBuild.append(")");
        if (databaseType == DatabaseType.MySQL) {
            boolean innoDB = config.getBoolean((Object)"sql.mysql.alwaysUseInnoDB");
            if (!innoDB && "true".equals(dsConfig.get("supportTransactions"))) {
                innoDB = true;
            }
            if (innoDB) {
                tableBuild.append(" ENGINE=InnoDB");
            }
        }
        if (databaseType == DatabaseType.Oracle || databaseType == DatabaseType.Postgres || databaseType == DatabaseType.Firebird) {
            SQLTableCreator.buildSequences(ds, dropTables, doWork, debug, databaseType);
        }
        if (debug && dropTables) {
            log.info((Object)("rebuilding table: " + tableName));
        }
        if (doWork && dropTables) {
            try {
                if (databaseType == DatabaseType.Oracle) {
                    tableDrop = tableDrop + " CASCADE CONSTRAINTS";
                }
                if (databaseType == DatabaseType.HSQLDB || databaseType == DatabaseType.Postgres) {
                    tableDrop = tableDrop + " CASCADE";
                }
                if (debug) {
                    log.debug((Object)("issuing table drop command: " + tableDrop));
                }
                if (databaseType == DatabaseType.MySQL) {
                    ds.executeNativeUpdate("SET foreign_key_checks = 0", null);
                } else if (databaseType == DatabaseType.SQLServer) {
                    ds.executeNativeUpdate("EXEC sp_msforeachtable \"ALTER TABLE ? NOCHECK CONSTRAINT all\"");
                }
                ds.executeNativeUpdate(tableDrop, null);
                log.warn((Object)"DROP TABLE COMPLETE");
                if (databaseType == DatabaseType.Oracle || databaseType == DatabaseType.Postgres) {
                    Map sequences = (Map)dsConfig.get("sequences");
                    if (databaseType == DatabaseType.Oracle && sequences != null) {
                        for (String sequenceName : sequences.keySet()) {
                            String sequenceDelete = "DROP SEQUENCE " + ds.escapeColumnName(sequenceName);
                            if (debug) {
                                log.error((Object)("dropping sequence via: " + sequenceDelete));
                            }
                            ds.executeNativeUpdate(sequenceDelete, null);
                        }
                    }
                }
            }
            catch (SQLException sequences) {
                // empty catch block
            }
        }
        if (debug) {
            log.debug((Object)("issuing table create command: " + tableBuild));
        }
        if (doWork) {
            HashMap droppedFKs = new HashMap();
            if (databaseType == DatabaseType.MySQL) {
                List fks = ds.executeNativeQuery("SELECT table_name, constraint_name FROM   information_schema.KEY_COLUMN_USAGE WHERE  referenced_table_name = '" + tableName + "'");
                for (int i = 0; i < fks.size(); ++i) {
                    Map record = (Map)fks.get(i);
                    if (droppedFKs.get(record.get("CONSTRAINT_NAME")) != null) continue;
                    droppedFKs.put(record.get("CONSTRAINT_NAME"), true);
                    try {
                        ds.executeNativeUpdate("ALTER TABLE " + record.get("TABLE_NAME") + " DROP FOREIGN KEY " + record.get("CONSTRAINT_NAME"));
                        continue;
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception while dropping remote foreign keys - ignoring", (Throwable)e);
                    }
                }
            }
            ds.executeNativeUpdate(tableBuild.toString(), null);
        }
        Map sequences = (Map)dsConfig.get("sequences");
        if (databaseType == DatabaseType.Oracle && sequences != null) {
            for (String sequenceName : sequences.keySet()) {
                Map sequenceDef = (Map)sequences.get(sequenceName);
                Integer startWith = new Integer(1);
                if (sequenceDef.get("startWith") != null) {
                    startWith = Integer.valueOf(sequenceDef.get("startWith").toString());
                }
                Integer incrementBy = new Integer(1);
                if (sequenceDef.get("incrementBy") != null) {
                    incrementBy = Integer.valueOf(sequenceDef.get("incrementBy").toString());
                }
                String sequenceCreate = "CREATE SEQUENCE " + ds.escapeColumnName(sequenceName) + " START WITH " + startWith + " INCREMENT BY " + incrementBy;
                if (debug) {
                    log.debug((Object)("creating standalone sequence via: " + sequenceCreate));
                }
                ds.executeNativeUpdate(sequenceCreate, null);
            }
        }
        if (doWork && "true".equals(dsConfig.get("createForeignKeys"))) {
            SQLTableCreator.createForeignKeys(ds, databaseType);
        }
    }

    public static String dsFieldToSQLColumn(SQLDataSource ds, String fieldName, DatabaseType databaseType) {
        String sqlType;
        DSField field = ds.getField(fieldName);
        if (field.isDerived()) {
            return null;
        }
        if (ds.isPureInherited(field) && DataSource.DSInheritanceMode.NONE.equals((Object)ds.getInheritanceMode())) {
            return null;
        }
        if (field.getBoolean("customSQL")) {
            return null;
        }
        if (field.get((Object)"customSelectExpression") != null) {
            return null;
        }
        if (field.get((Object)"includeFrom") != null) {
            return null;
        }
        if (field.isInapplicable() || field.ignore()) {
            return null;
        }
        String type = field.getType();
        if (type == null || "".equals(type)) {
            type = "text";
        }
        String title = field.getTitle();
        long length = -1L;
        boolean boolInt = false;
        if (field.getLength() != null) {
            length = field.getLength();
        }
        if (type.equals("boolean") && (sqlType = field.getProperty("sqlStorageStrategy")) != null) {
            if (sqlType.equals("number") || sqlType.equals("integer")) {
                type = "integer";
                boolInt = true;
            } else if (sqlType.startsWith("singleChar")) {
                type = "text";
                length = 1L;
            }
        }
        String result = "";
        if (SQLDataSource.typeIsNumeric(type) && !SQLDataSource.typeIsDecimal(type)) {
            if (field.isMultiple() && (field.getProperty("sqlStorageStrategy") != null || field.getMultipleStorage() != null)) {
                String sqlType2 = field.getProperty("sqlStorageStrategy");
                if (sqlType2 == null) {
                    sqlType2 = "text";
                }
                if ("text".equals(sqlType2)) {
                    result = length > 0L ? result + "varchar(" + length + ")" : result + "varchar(255)";
                } else {
                    log.warn((Object)("sqlStorage specified for multiple field " + fieldName + " however is not 'text', but " + sqlType2 + " which is unhandled.Ignoring"));
                }
            } else {
                if (boolInt) {
                    result = result + (databaseType == DatabaseType.Cache ? "number" : "integer");
                } else if (databaseType == DatabaseType.Oracle) {
                    result = result + "integer";
                } else if (databaseType == DatabaseType.Cache) {
                    result = result + "number";
                } else if (databaseType == DatabaseType.MySQL) {
                    result = result + "integer";
                } else if (databaseType == DatabaseType.Postgres) {
                    result = result + "bigint";
                } else if (databaseType == DatabaseType.SQLServer) {
                    result = result + "bigint";
                } else if (databaseType == DatabaseType.Firebird) {
                    result = result + "bigint";
                } else if (databaseType == DatabaseType.Generic) {
                    result = result + "bigint";
                } else if (databaseType == DatabaseType.DB2) {
                    result = result + "bigint";
                } else if (databaseType == DatabaseType.HSQLDB) {
                    result = result + "integer";
                }
                if ("sequence".equals(type) || "integer".equals(type) && field.isAutoGenerated()) {
                    if (databaseType == DatabaseType.MySQL) {
                        result = result + " auto_increment";
                    } else if (databaseType == DatabaseType.Oracle || databaseType == DatabaseType.Postgres || databaseType == DatabaseType.Firebird) {
                        result = result + " default 0";
                    } else if (databaseType == DatabaseType.SQLServer) {
                        result = result + " identity (1, 1)";
                    } else if (databaseType == DatabaseType.DB2) {
                        result = result + " GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20)";
                    } else if (databaseType == DatabaseType.HSQLDB) {
                        result = result + " GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1)";
                    } else if (databaseType == DatabaseType.Informix) {
                        result = result + "serial8";
                    }
                } else {
                    if (databaseType == DatabaseType.Informix && !boolInt) {
                        result = result + "int8";
                    }
                    if (!field.isPrimaryKey()) {
                        result = result + " default null";
                    }
                }
            }
        } else if (SQLDataSource.typeIsDecimal(type)) {
            if (field.isMultiple() && (field.getProperty("sqlStorageStrategy") != null || field.getMultipleStorage() != null)) {
                String sqlType3 = field.getProperty("sqlStorageStrategy");
                if (sqlType3 == null) {
                    sqlType3 = "text";
                }
                if ("text".equals(sqlType3)) {
                    result = length > 0L ? result + "varchar(" + length + ")" : result + "varchar(255)";
                } else {
                    log.warn((Object)("sqlStorage specified for multiple field " + fieldName + " however is not 'text', but " + sqlType3 + " which is unhandled.Ignoring"));
                }
            } else if (databaseType == DatabaseType.MySQL || databaseType == DatabaseType.DB2 || databaseType == DatabaseType.HSQLDB || databaseType == DatabaseType.Cache) {
                result = result + "double default 0.0";
            } else if (databaseType == DatabaseType.Postgres) {
                result = result + "real default 0.0";
            } else if (databaseType == DatabaseType.Oracle || databaseType == DatabaseType.SQLServer || databaseType == DatabaseType.Firebird || databaseType == DatabaseType.Generic || databaseType == DatabaseType.Informix) {
                result = result + "float default 0.0";
            }
        } else if (type.equals("date") || type.equals("datetime") || type.equals("time") || type.equals("modifierTimestamp") || type.equals("creatorTimestamp")) {
            String format;
            String sqlType4;
            boolean overridden = false;
            if (type.equals("date")) {
                sqlType4 = field.getProperty("sqlStorageStrategy");
                if (sqlType4 == null) {
                    log.debug((Object)("field " + field.getName() + " is date, sqlType is null, multipleStorage= " + field.getMultipleStorage() + "/" + field.getProperty("multipleStorage")));
                    if (field.getMultipleStorage() != null && field.isMultiple()) {
                        result = result + "varchar(";
                        result = field.getLength() != null && field.getLength() > 0L ? result + field.getLength() : result + "256";
                        result = result + ")";
                        overridden = true;
                    } else {
                        String defaultDateType = config.getString((Object)("sql." + ds.getDriver().getDBName() + ".defaultDateType"));
                        if (defaultDateType == null) {
                            defaultDateType = config.getString((Object)("sql." + ds.getDriver().getDBType() + ".defaultDateType"));
                        }
                        if (defaultDateType != null) {
                            result = result + defaultDateType;
                            overridden = true;
                        }
                    }
                } else if (sqlType4.equals("nativeDate")) {
                    result = result + "date";
                    overridden = true;
                } else if (sqlType4.equals("number") || sqlType4.equals("integer")) {
                    if (databaseType == DatabaseType.Oracle || databaseType == DatabaseType.Cache) {
                        result = result + "number";
                    } else if (databaseType == DatabaseType.MySQL) {
                        result = result + "integer";
                    } else if (databaseType == DatabaseType.Postgres) {
                        result = result + "bigint";
                    } else if (databaseType == DatabaseType.SQLServer || databaseType == DatabaseType.Firebird || databaseType == DatabaseType.Generic) {
                        result = result + "bigint";
                    } else if (databaseType == DatabaseType.DB2) {
                        result = result + "bigint";
                    } else if (databaseType == DatabaseType.HSQLDB) {
                        result = result + "integer";
                    } else if (databaseType == DatabaseType.Informix) {
                        result = result + "int8";
                    }
                    overridden = true;
                } else if (sqlType4.equals("text")) {
                    result = result + "varchar(";
                    format = field.getProperty("sqlDateFormat");
                    result = format == null ? (field.isMultiple() && field.getLength() != 0L ? result + field.getLength() : result + "10") : result + format.length();
                    result = result + ")";
                    overridden = true;
                } else {
                    result = result + sqlType4;
                    overridden = true;
                }
            }
            if (type.equals("datetime") || type.equals("modifierTimestamp") || type.equals("creatorTimestamp")) {
                type = "datetime";
                sqlType4 = field.getProperty("sqlStorageStrategy");
                if (sqlType4 != null) {
                    if (sqlType4.equals("number") || sqlType4.equals("integer")) {
                        if (databaseType == DatabaseType.Oracle || databaseType == DatabaseType.Cache) {
                            result = result + "number";
                        } else if (databaseType == DatabaseType.MySQL) {
                            result = result + "bigint";
                        } else if (databaseType == DatabaseType.Postgres) {
                            result = result + "bigint";
                        } else if (databaseType == DatabaseType.SQLServer) {
                            result = result + "bigint";
                        } else if (databaseType == DatabaseType.DB2) {
                            result = result + "bigint";
                        } else if (databaseType == DatabaseType.HSQLDB) {
                            result = result + "bigint";
                        } else if (databaseType == DatabaseType.Firebird) {
                            result = result + "bigint";
                        } else if (databaseType == DatabaseType.Generic) {
                            result = result + "bigint";
                        } else if (databaseType == DatabaseType.Informix) {
                            result = result + "int8";
                        }
                        overridden = true;
                    } else if (sqlType4.equals("text")) {
                        result = result + "varchar(";
                        format = field.getProperty("sqlDateFormat");
                        result = format == null ? (field.isMultiple() && field.getLength() != 0L ? result + field.getLength() : result + "23") : result + format.length();
                        result = result + ")";
                        overridden = true;
                    }
                } else if (field.getMultipleStorage() != null && field.isMultiple()) {
                    result = result + "varchar(";
                    result = field.getLength() != null && field.getLength() > 0L ? result + field.getLength() : result + "256";
                    result = result + ")";
                    overridden = true;
                }
            }
            if (type.equals("time") && field.isMultiple()) {
                sqlType4 = field.getProperty("sqlStorageStrategy");
                if (sqlType4 != null) {
                    result = result + sqlType4;
                    overridden = true;
                } else {
                    sqlType4 = "text";
                    result = result + "varchar(";
                    result = field.getLength() != null && field.getLength() > 0L ? result + field.getLength() : result + "256";
                    result = result + ")";
                    overridden = true;
                }
            }
            if (!overridden) {
                if (databaseType == DatabaseType.MySQL) {
                    result = result + type;
                    if ("datetime".equals(type) && field.shouldStoreMilliseconds()) {
                        result = result + "(3)";
                    }
                } else if (databaseType == DatabaseType.HSQLDB && !"time".equals(type)) {
                    result = result + type;
                } else if (databaseType == DatabaseType.SQLServer) {
                    result = result + "datetime";
                    if ("datetime".equals(type) && field.shouldStoreMilliseconds()) {
                        result = result + "2(3)";
                    }
                } else if (databaseType == DatabaseType.Oracle && !"datetime".equals(type)) {
                    result = result + "date";
                } else if (databaseType == DatabaseType.HSQLDB || databaseType == DatabaseType.Postgres || databaseType == DatabaseType.DB2 || databaseType == DatabaseType.Cache || databaseType == DatabaseType.Firebird || databaseType == DatabaseType.Generic || databaseType == DatabaseType.Oracle) {
                    result = result + "timestamp";
                    if ("datetime".equals(type) && field.shouldStoreMilliseconds() && (databaseType == DatabaseType.Postgres || databaseType == DatabaseType.Oracle)) {
                        result = result + "(3)";
                    }
                } else if (databaseType == DatabaseType.Informix) {
                    result = result + "datetime YEAR to ";
                    result = "datetime".equals(type) && field.shouldStoreMilliseconds() ? result + "FRACTION(3)" : result + "SECOND";
                }
            }
        } else if (type.equals("binary") || type.equals("blob") || type.equals("imageFile")) {
            if (databaseType == DatabaseType.MySQL) {
                result = result + "longblob";
            } else if (databaseType == DatabaseType.Postgres) {
                result = result + "bytea";
            } else if (databaseType == DatabaseType.Oracle || databaseType == DatabaseType.DB2) {
                result = result + "blob";
            } else if (databaseType == DatabaseType.Cache) {
                result = result + "binary";
            } else if (databaseType == DatabaseType.HSQLDB) {
                result = result + "blob(1G)";
            } else if (databaseType == DatabaseType.SQLServer) {
                result = result + "image";
            } else if (databaseType == DatabaseType.Firebird) {
                result = result + "BLOB";
            } else if (databaseType == DatabaseType.Generic) {
                result = result + config.getString((Object)"sql.generic.binary.type");
            } else if (databaseType == DatabaseType.Informix) {
                result = result + "blob";
            }
        } else {
            if (type.equals("boolean")) {
                type = "text";
                if (length < 6L) {
                    length = 6L;
                }
            }
            if (type.equals("creator") || type.equals("modifier")) {
                type = "text";
            }
            if (!type.equals("text") && !type.equals("string")) {
                log.warn((Object)("Unrecognized type: '" + type + "' in datasource: " + ds.getName() + " mapping to type text."));
                type = "text";
            }
            if (length == -1L) {
                length = 255L;
            }
            if (databaseType == DatabaseType.MySQL) {
                if (length <= 255L) {
                    result = result + "varchar(" + length + ")";
                } else if (length <= 65535L) {
                    result = result + "text";
                } else if (length <= 0xFFFFFFL) {
                    result = result + "mediumtext";
                } else if (length <= 0xFFFFFFFFL) {
                    result = result + "longtext";
                }
            } else {
                result = databaseType == DatabaseType.Oracle || databaseType == DatabaseType.DB2 ? (length <= 4000L && !type.equals("clob") ? result + "varchar(" + length + ")" : result + "clob") : (databaseType == DatabaseType.Postgres ? (length <= 4000L ? result + "varchar(" + length + ")" : result + "text") : (databaseType == DatabaseType.SQLServer ? (length <= 8000L ? result + "varchar(" + length + ")" : result + "text") : (databaseType == DatabaseType.HSQLDB ? result + "varchar_ignorecase(" + length + ")" : (databaseType == DatabaseType.Firebird ? (length <= 32767L ? result + "varchar(" + length + ")" : result + "BLOB SUB_TYPE 1") : (databaseType == DatabaseType.Informix ? (length <= 255L ? result + "varchar(" + length + ")" : (length < 32739L ? result + "lvarchar(" + length + ")" : result + "text")) : result + "varchar(" + length + ")")))));
            }
            if (field.isPrimaryKey() || field.isRequired()) {
                if (databaseType == DatabaseType.Cache) {
                    result = result + " default \"\"";
                } else if (databaseType != DatabaseType.MySQL || length <= 255L) {
                    result = result + " default ''";
                }
            }
        }
        if (field.isPrimaryKey() && (databaseType == DatabaseType.MySQL || databaseType == DatabaseType.DB2) || field.getBoolean("defineSQLColumnAsNotNull")) {
            result = result + " not null";
        }
        return result;
    }

    private static String sqlForConstraint(SQLDataSource ds, List fieldNames, String constraintType, DatabaseType databaseType) {
        return SQLTableCreator.sqlForConstraint(ds, fieldNames, constraintType, null, databaseType);
    }

    private static String sqlForConstraint(SQLDataSource ds, List fieldNames, String constraintType, String constraintName, DatabaseType databaseType) {
        if (constraintName == null) {
            constraintName = SQLTableCreator.indexNameForTable(ds.getTable().getName(), databaseType);
        }
        log.debug((Object)("Creating constraint of type " + constraintType + " on fields " + fieldNames));
        String constraint = databaseType != DatabaseType.Informix ? "CONSTRAINT " + ds.escapeColumnName(constraintName) + " " + constraintType + " (" : constraintType + " (";
        Iterator e = fieldNames.iterator();
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            String columnName = ds.getColumnName(fieldName);
            if (columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            constraint = constraint + ds.escapeColumnName(columnName);
            if (!e.hasNext()) continue;
            constraint = constraint + ", ";
        }
        constraint = constraint + ")";
        if (databaseType == DatabaseType.Informix) {
            constraint = constraint + " CONSTRAINT " + ds.escapeColumnName(constraintName);
        }
        return constraint;
    }

    private static void buildSequences(SQLDataSource ds, boolean dropTables, boolean doWork, boolean debug, DatabaseType databaseType) throws Exception {
        Map sequences = ds.getTable().getSequences();
        for (String columnName : sequences.keySet()) {
            String sequenceCreate;
            String sequenceName;
            block13: {
                block12: {
                    sequenceName = SQLDriver.getSequenceName(columnName, sequences, ds.getTable().getName(), ds.getDriver());
                    sequenceCreate = "CREATE SEQUENCE " + sequenceName;
                    if (databaseType == DatabaseType.Oracle) break block12;
                    if (databaseType != DatabaseType.DB2) break block13;
                }
                sequenceCreate = sequenceCreate + " INCREMENT BY 1 START WITH 1";
            }
            if (databaseType == DatabaseType.Postgres) {
                sequenceCreate = sequenceCreate + " INCREMENT 1 START 1";
            }
            if (debug) {
                log.debug((Object)("creating sequence named: " + sequenceName + " for column: " + columnName));
            }
            if (!doWork) {
                log.debug((Object)("create command: " + sequenceCreate));
                continue;
            }
            try {
                ds.executeNativeUpdate(sequenceCreate, null);
            }
            catch (SQLException se) {
                if (!dropTables) continue;
                try {
                    if (debug) {
                        log.debug((Object)"sequence exists, destroying and re-creating...");
                    }
                    ds.executeNativeUpdate("DROP SEQUENCE " + sequenceName, null);
                    ds.executeNativeUpdate(sequenceCreate, null);
                }
                catch (SQLException se2) {
                    log.debug((Object)("unable create sequence: " + sequenceName));
                    throw se;
                }
            }
        }
    }

    private static void createForeignKeys(SQLDataSource ds, DatabaseType databaseType) throws Exception {
        String tableName;
        LinkedMap fks = new LinkedMap();
        Iterator i = ds.getFieldNames().iterator();
        while (i.hasNext()) {
            String[] fkElems;
            DSField field = ds.getField((String)i.next());
            String fkDec = field.getForeignKey();
            if (fkDec == null || (fkElems = fkDec.split("\\.")).length != 2) continue;
            if (!fks.containsKey(fkElems[0])) {
                fks.put(fkElems[0], new ArrayList());
            }
            List keyFields = (List)fks.get(fkElems[0]);
            HashMap<String, String> keyField = new HashMap<String, String>();
            keyField.put("from", field.getName());
            keyField.put("to", fkElems[1]);
            keyFields.add(keyField);
        }
        if (fks.keySet().size() == 0) {
            return;
        }
        if (databaseType == DatabaseType.MySQL) {
            ds.executeNativeUpdate("SET foreign_key_checks = 0");
        }
        if ((tableName = (String)ds.getConfig().get("tableName")) == null) {
            tableName = ds.getID();
        }
        for (String dsName : fks.keySet()) {
            String sql;
            DataSource work = DataSourceManager.get((String)dsName);
            if (!(work instanceof SQLDataSource)) continue;
            SQLDataSource related = (SQLDataSource)work;
            String relatedTableName = (String)related.getConfig().get("tableName");
            if (relatedTableName == null) {
                relatedTableName = related.getID();
            }
            List keyFields = (List)fks.get(dsName);
            String fromList = "";
            String toList = "";
            String firstField = null;
            for (Map keyField : keyFields) {
                String from = (String)keyField.get("from");
                String to = (String)keyField.get("to");
                from = (String)ds.ds2NativeFieldMap().get(from);
                if (from.contains(".")) {
                    from = from.substring(from.lastIndexOf(".") + 1);
                }
                if ((to = (String)related.ds2NativeFieldMap().get(to)).contains(".")) {
                    to = to.substring(to.lastIndexOf(".") + 1);
                }
                if (firstField == null) {
                    firstField = from;
                }
                from = ds.escapeColumnName(from);
                to = related.escapeColumnName(to);
                if (!"".equals(fromList)) {
                    fromList = fromList + ", ";
                    toList = toList + ", ";
                }
                fromList = fromList + from;
                toList = toList + to;
            }
            String hashCode = Integer.toHexString((tableName + relatedTableName).hashCode());
            if (databaseType == DatabaseType.MySQL) {
                sql = "ALTER TABLE " + tableName + " ADD INDEX ";
                sql = sql + "IX_" + hashCode;
                sql = sql + " (" + fromList + ")";
                ds.executeNativeUpdate(sql);
            }
            sql = "ALTER TABLE " + tableName + " ADD CONSTRAINT ";
            if (databaseType != DatabaseType.Informix) {
                sql = sql + "FK_" + hashCode;
            }
            sql = sql + " FOREIGN KEY (" + fromList + ")";
            sql = sql + " REFERENCES " + relatedTableName + " (" + toList + ")";
            if (databaseType == DatabaseType.Informix) {
                sql = sql + " CONSTRAINT FK_" + hashCode;
            }
            ds.executeNativeUpdate(sql);
        }
        if (databaseType == DatabaseType.MySQL) {
            ds.executeNativeUpdate("SET foreign_key_checks = 1");
        }
    }

    private static String indexNameForTable(String tableName, DatabaseType databaseType) {
        if (databaseType == DatabaseType.DB2 && tableName.length() > 15) {
            tableName = tableName.substring(0, 15);
        }
        return tableName + "_UI";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DatabaseType {
        Oracle,
        MySQL,
        Postgres,
        SQLServer,
        DB2,
        HSQLDB,
        Firebird,
        Generic,
        Informix,
        Cache;

    }
}

