/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.criteria.criterion.IsNullCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.NotNullCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.OtherFieldCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaUtils {
    private CriteriaUtils() {
    }

    public static boolean equals(Criterion c1, Criterion c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null ^ c2 == null) {
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        if (!c1.getClass().equals(c2.getClass())) {
            return false;
        }
        if (!CriteriaUtils.equalsOrBothNull(c1.getOperatorId(), c2.getOperatorId())) {
            return false;
        }
        if (c1 instanceof LogicalCriterion) {
            List<Criterion> subcriteria1 = ((LogicalCriterion)c1).getCriteria();
            List<Criterion> subcriteria2 = ((LogicalCriterion)c2).getCriteria();
            if (subcriteria1 == null && subcriteria2 == null) {
                return true;
            }
            if (subcriteria1 == null ^ subcriteria2 == null) {
                return false;
            }
            if (subcriteria1.equals(subcriteria2)) {
                return true;
            }
            int size1 = 0;
            for (Criterion subcriterion1 : subcriteria1) {
                if (!(subcriterion1 instanceof Criterion)) continue;
                if (!CriteriaUtils.contains(subcriteria2, subcriterion1)) {
                    return false;
                }
                ++size1;
            }
            int size2 = 0;
            for (Criterion subcriterion2 : subcriteria2) {
                if (!(subcriterion2 instanceof Criterion)) continue;
                ++size2;
            }
            return size1 == size2;
        }
        if (!CriteriaUtils.equalsOrBothNull(c1.getFieldName(), c2.getFieldName())) {
            return false;
        }
        if (c1 instanceof RangeCriterion) {
            RangeCriterion rc1 = (RangeCriterion)c1;
            RangeCriterion rc2 = (RangeCriterion)c2;
            return CriteriaUtils.equalsOrBothNull(rc1.getMin(), rc2.getMin()) && CriteriaUtils.equalsOrBothNull(rc1.getMax(), rc2.getMax());
        }
        if (c1 instanceof SetCriterion) {
            Collection values1 = ((SetCriterion)c1).getValues();
            Collection values2 = ((SetCriterion)c2).getValues();
            if (values1 == null && values2 == null) {
                return true;
            }
            if (values1 == null ^ values2 == null) {
                return false;
            }
            return values1.equals(values2);
        }
        if (c1 instanceof IsNullCriterion || c1 instanceof NotNullCriterion) {
            return true;
        }
        if (!CriteriaUtils.equalsOrBothNull(c1.getValue(), c2.getValue())) {
            return false;
        }
        if (c1 instanceof OtherFieldCriterion) {
            return CriteriaUtils.equalsOrBothNull(((OtherFieldCriterion)c1).getOtherFieldName(), ((OtherFieldCriterion)c2).getOtherFieldName());
        }
        if (c1 instanceof CustomCriterion) {
            return c1.equals(c2);
        }
        return true;
    }

    private static Criterion reduceUselessLogic(Criterion criterion) {
        List<Criterion> subcriteria;
        if ((criterion instanceof AndCriterion || criterion instanceof OrCriterion) && (subcriteria = ((LogicalCriterion)criterion).getCriteria()) != null) {
            Criterion sc = null;
            for (Criterion subcriterion : subcriteria) {
                if (!(subcriterion instanceof Criterion)) continue;
                if (sc == null) {
                    sc = subcriterion;
                    continue;
                }
                return criterion;
            }
            if (sc != null) {
                return CriteriaUtils.reduceUselessLogic(sc);
            }
        }
        return criterion;
    }

    private static AndCriterion reduceAnd(AndCriterion criterion) {
        List<Criterion> subcriteria = criterion.getCriteria();
        if (subcriteria == null) {
            return criterion;
        }
        boolean needNewCriterion = false;
        ArrayList<Criterion> ret = new ArrayList<Criterion>();
        for (Criterion subcriterion : subcriteria) {
            if (subcriterion instanceof Criterion) {
                if (subcriterion instanceof AndCriterion) {
                    needNewCriterion = true;
                    ret.addAll(CriteriaUtils.reduceAnd((AndCriterion)subcriterion).getCriteria());
                    continue;
                }
                ret.add(subcriterion);
                continue;
            }
            needNewCriterion = true;
        }
        return needNewCriterion ? new AndCriterion(ret) : criterion;
    }

    private static OrCriterion reduceOr(OrCriterion criterion) {
        List<Criterion> subcriteria = criterion.getCriteria();
        if (subcriteria == null) {
            return criterion;
        }
        boolean needNewCriterion = false;
        ArrayList<Criterion> ret = new ArrayList<Criterion>();
        for (Criterion subcriterion : subcriteria) {
            if (subcriterion instanceof Criterion) {
                if (subcriterion instanceof OrCriterion) {
                    needNewCriterion = true;
                    ret.addAll(CriteriaUtils.reduceOr((OrCriterion)subcriterion).getCriteria());
                    continue;
                }
                ret.add(subcriterion);
                continue;
            }
            needNewCriterion = true;
        }
        return needNewCriterion ? new OrCriterion(ret) : criterion;
    }

    private static Criterion reduceNotNot(NotCriterion criterion) {
        List<Criterion> subcriteria = criterion.getCriteria();
        if (subcriteria != null) {
            ArrayList<Criterion> ret = new ArrayList<Criterion>();
            int validCount = 0;
            int notCount = 0;
            for (Criterion subcriterion : subcriteria) {
                if (!(subcriterion instanceof Criterion)) continue;
                ++validCount;
                if (!(subcriterion instanceof NotCriterion)) continue;
                ++notCount;
                List<Criterion> subSubcriteria = ((NotCriterion)subcriterion).getCriteria();
                if (subSubcriteria == null) continue;
                ArrayList<Criterion> subRet = new ArrayList<Criterion>();
                boolean subValidCount = false;
                for (Criterion subSubcriterion : subSubcriteria) {
                    if (!(subSubcriterion instanceof Criterion)) continue;
                    subRet.add(subSubcriterion);
                }
                ret.add(!subValidCount ? (Criterion)subRet.get(0) : new OrCriterion(subRet));
            }
            if (notCount == validCount && validCount > 0) {
                return CriteriaUtils.reduceAnd(new AndCriterion(ret));
            }
        }
        return criterion;
    }

    private static Criterion addNot(Criterion criterion) {
        return CriteriaUtils.reduceNotNot(new NotCriterion(criterion));
    }

    private static NotCriterion addNotNot(Criterion criterion) {
        return new NotCriterion(new NotCriterion(criterion));
    }

    private static OrCriterion rewriteToOr(Criterion criterion) {
        if (criterion instanceof LogicalCriterion) {
            if (criterion instanceof OrCriterion) {
                return CriteriaUtils.reduceOr((OrCriterion)criterion);
            }
            LogicalCriterion lc = (LogicalCriterion)criterion;
            List<Criterion> subcriteria = lc.getCriteria();
            if (subcriteria != null && !subcriteria.isEmpty()) {
                if (criterion instanceof AndCriterion) {
                    ArrayList<Criterion> factors = new ArrayList<Criterion>();
                    LogicalCriterion orFactor = null;
                    for (Criterion criterion2 : subcriteria) {
                        OrCriterion orCriterion;
                        List<Criterion> subSubcriteria;
                        if (!(criterion2 instanceof Criterion)) continue;
                        if (orFactor == null && criterion2 instanceof OrCriterion && (subSubcriteria = (orCriterion = (OrCriterion)criterion2).getCriteria()) != null && !subSubcriteria.isEmpty()) {
                            int validCount = 0;
                            for (Criterion subSubcriterion : subSubcriteria) {
                                if (subSubcriterion instanceof Criterion && ++validCount == 2) break;
                            }
                            if (validCount >= 2) {
                                orFactor = (OrCriterion)criterion2;
                                continue;
                            }
                        }
                        factors.add(criterion2);
                    }
                    if (orFactor == null) {
                        return null;
                    }
                    ArrayList<AndCriterion> ret = new ArrayList<AndCriterion>();
                    for (Criterion criterion3 : orFactor.getCriteria()) {
                        if (!(criterion3 instanceof Criterion)) continue;
                        ArrayList<Criterion> subRet = new ArrayList<Criterion>();
                        subRet.addAll(factors);
                        subRet.add(criterion3);
                        ret.add(CriteriaUtils.reduceAnd(new AndCriterion(subRet)));
                    }
                    return new OrCriterion(ret);
                }
                if (criterion instanceof NotCriterion) {
                    Criterion reduced = CriteriaUtils.reduceNotNot((NotCriterion)criterion);
                    if (reduced != criterion) {
                        return CriteriaUtils.rewriteToOr(reduced);
                    }
                    AndCriterion andSubcriterion = null;
                    for (Criterion criterion4 : subcriteria) {
                        if (!(criterion4 instanceof Criterion)) continue;
                        Criterion criterion5 = CriteriaUtils.reduceUselessLogic(criterion4);
                        AndCriterion asc = criterion5 instanceof AndCriterion ? (AndCriterion)criterion4 : CriteriaUtils.rewriteToAnd(criterion5);
                        if (asc == null) {
                            return null;
                        }
                        List<Criterion> subSubcriteria = asc.getCriteria();
                        if (subSubcriteria == null || subSubcriteria.isEmpty()) continue;
                        if (andSubcriterion != null) {
                            andSubcriterion = asc;
                            continue;
                        }
                        return null;
                    }
                    if (andSubcriterion != null) {
                        andSubcriterion = CriteriaUtils.reduceAnd(andSubcriterion);
                        ArrayList ret = new ArrayList();
                        for (Criterion criterion6 : andSubcriterion.getCriteria()) {
                            if (!(criterion6 instanceof Criterion)) continue;
                            ret.add(CriteriaUtils.addNot(criterion6));
                        }
                        return new OrCriterion(ret);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static AndCriterion rewriteToAnd(Criterion criterion) {
        if ((criterion = CriteriaUtils.reduceUselessLogic(criterion)) instanceof LogicalCriterion) {
            if (criterion instanceof AndCriterion) {
                return CriteriaUtils.reduceAnd((AndCriterion)criterion);
            }
            LogicalCriterion lc = (LogicalCriterion)criterion;
            List<Criterion> subcriteria = lc.getCriteria();
            if (subcriteria != null && !subcriteria.isEmpty()) {
                if (criterion instanceof OrCriterion) {
                    List<Criterion> subSubcriteria;
                    ArrayList<Criterion> commonFactors = new ArrayList<Criterion>();
                    ArrayList<AndCriterion> andSubcriteria = new ArrayList<AndCriterion>();
                    boolean first = true;
                    for (Criterion criterion2 : subcriteria) {
                        AndCriterion asc;
                        if (!(criterion2 instanceof Criterion) || (subSubcriteria = (asc = (asc = CriteriaUtils.rewriteToAnd(criterion2)) != null ? CriteriaUtils.reduceAnd(asc) : new AndCriterion(criterion2)).getCriteria()) == null) continue;
                        andSubcriteria.add(asc);
                        if (first) {
                            for (Criterion subSubcriterion : subSubcriteria) {
                                if (!(subSubcriterion instanceof Criterion)) continue;
                                first = false;
                                commonFactors.add(subSubcriterion);
                            }
                            continue;
                        }
                        Iterator it = commonFactors.iterator();
                        while (it.hasNext()) {
                            Criterion c = (Criterion)it.next();
                            if (CriteriaUtils.contains(subSubcriteria, c)) continue;
                            it.remove();
                        }
                    }
                    if (!commonFactors.isEmpty()) {
                        ArrayList ret = new ArrayList();
                        for (AndCriterion subcriterion : andSubcriteria) {
                            subSubcriteria = subcriterion.getCriteria();
                            ArrayList<Criterion> uncommonFactors = new ArrayList<Criterion>();
                            for (Criterion subSubcriterion : subSubcriteria) {
                                if (!(subSubcriterion instanceof Criterion) || CriteriaUtils.contains(commonFactors, subSubcriterion)) continue;
                                uncommonFactors.add(subSubcriterion);
                            }
                            int size = uncommonFactors.size();
                            if (size == 0) {
                                return new AndCriterion(commonFactors);
                            }
                            if (size == 1) {
                                ret.add(uncommonFactors.get(0));
                                continue;
                            }
                            ret.add(new AndCriterion(uncommonFactors));
                        }
                        commonFactors.add(new OrCriterion(ret));
                        return new AndCriterion(commonFactors);
                    }
                } else if (criterion instanceof NotCriterion) {
                    void var7_15;
                    Criterion reduced = CriteriaUtils.reduceNotNot((NotCriterion)criterion);
                    if (reduced != criterion) {
                        return CriteriaUtils.rewriteToAnd(reduced);
                    }
                    ArrayList<OrCriterion> orSubcriteria = new ArrayList<OrCriterion>();
                    for (Criterion subcriterion : subcriteria) {
                        if (!(subcriterion instanceof Criterion)) continue;
                        OrCriterion orCriterion = CriteriaUtils.rewriteToOr(subcriterion);
                        orSubcriteria.add((OrCriterion)(orCriterion != null ? orCriterion : subcriterion));
                    }
                    OrCriterion orSubcriterion = CriteriaUtils.reduceOr(new OrCriterion(orSubcriteria));
                    ArrayList<Criterion> ret = new ArrayList<Criterion>();
                    boolean bl = false;
                    for (Criterion subcriterion : orSubcriterion.getCriteria()) {
                        if (!(subcriterion instanceof Criterion)) continue;
                        ++var7_15;
                        ret.add(CriteriaUtils.addNot(subcriterion));
                    }
                    if (var7_15 > true) {
                        return new AndCriterion(ret);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private static boolean equalsOrBothNull(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean contains(List criteria, Criterion criterion) {
        if (criteria != null) {
            for (Object c : criteria) {
                if (!(c instanceof Criterion) || !CriteriaUtils.equals(criterion, (Criterion)c)) continue;
                return true;
            }
        }
        return false;
    }

    public static AdvancedCriteria remapFields(AdvancedCriteria advanced, Map<String, String> fieldNameMap) {
        Criterion remappedCriterion;
        Criterion criterion = advanced.asCriterion();
        if (criterion == (remappedCriterion = CriteriaUtils.remapFields(criterion, fieldNameMap))) {
            return advanced;
        }
        if (remappedCriterion == null) {
            return null;
        }
        return new AdvancedCriteria(remappedCriterion);
    }

    public static Criterion remapFields(Criterion criterion, Map<String, String> fieldNameMap) {
        OtherFieldCriterion otherFieldCriterion;
        String otherFieldName;
        if (fieldNameMap == null) {
            throw new IllegalArgumentException("fieldNameMap cannot be null");
        }
        String currentName = criterion.getFieldName();
        if (fieldNameMap.containsKey(currentName)) {
            String newName = fieldNameMap.get(currentName);
            if (newName == null) {
                return null;
            }
            criterion.setFieldName(newName);
        }
        if (criterion instanceof OtherFieldCriterion && fieldNameMap.containsKey(otherFieldName = (otherFieldCriterion = (OtherFieldCriterion)criterion).getOtherFieldName())) {
            String newName = fieldNameMap.get(otherFieldName);
            if (newName == null) {
                return null;
            }
            otherFieldCriterion.setOtherFieldName(newName);
        }
        if (criterion instanceof LogicalCriterion) {
            LogicalCriterion logicalCriterion = (LogicalCriterion)criterion;
            List<Criterion> criteria = logicalCriterion.getCriteria();
            ListIterator<Criterion> iterator = criteria.listIterator();
            while (iterator.hasNext()) {
                Criterion current = iterator.next();
                Criterion result = CriteriaUtils.remapFields(current, fieldNameMap);
                if (result != null) continue;
                if (criterion instanceof AndCriterion) {
                    iterator.remove();
                    continue;
                }
                return null;
            }
            if (criterion instanceof AndCriterion && criteria.size() == 0) {
                return null;
            }
        }
        return criterion;
    }
}

