/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.util.List;
import org.apache.commons.collections.map.LinkedMap;
import org.w3c.dom.Element;

public class UserTypeFieldMap
extends BasicDataSource {
    private static Logger log = new Logger(UserTypeFieldMap.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (!(data instanceof Element)) {
            log.warning("Unexpected type passed to Constraints: " + data.getClass().getName());
            return data;
        }
        Element element = (Element)data;
        LinkedMap constraintMap = new LinkedMap();
        DataSource listDS = DataSourceManager.getDataSource("List", null);
        try {
            List constraints = XML.getElementChildren(element);
            for (Element constraint : constraints) {
                String userType = XML.getAttribute(constraint, "userType");
                if (userType == null) {
                    userType = XML.getAttribute(constraint, "ID");
                }
                if (userType == null) {
                    log.warning("Constraint with no 'userType' or 'ID' attribute");
                    continue;
                }
                List value = null;
                List elementChildren = XML.getElementChildren(constraint);
                value = elementChildren.isEmpty() ? DataTools.buildList("*") : (List)listDS.toRecords(constraint);
                constraintMap.put(userType, value);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            DataSourceManager.freeDataSource(listDS);
            throw throwable;
        }
        DataSourceManager.freeDataSource(listDS);
        return constraintMap;
    }
}

