/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io.file;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.file.ISCUrlFile;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISCClassPathFile
extends ISCUrlFile {
    public ISCClassPathFile(String path, DSRequest request) throws IOException {
        super(path, request, false);
        String strippedPath = StringUtils.substringAfter((String)path, (String)"{CLASSPATH}");
        this.url = ISCClassPathFile.class.getResource(ISCClassPathFile.canonicalizePath(strippedPath));
    }

    public ISCClassPathFile(String path) throws IOException {
        this(path, null);
    }

    @Override
    public ISCFile getChild(Map<String, Object> primaryKeys, DSRequest request) throws IOException {
        if (request == null) {
            request = this.requestContext;
        }
        return this.getChild(ISCFile.expandFileExtensions(primaryKeys), request);
    }

    @Override
    public ISCFile getChild(String path, DSRequest request) throws IOException {
        if (request == null) {
            request = this.requestContext;
        }
        return new ISCClassPathFile(this.filename + "/" + path, request);
    }
}

