/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util.date;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Period {
    MILLISECOND(14, "MS", "ms", "millisecond"),
    SECOND(13, "S", "s", "second"),
    MINUTE(12, "MN", "N", "mn", "n", "minute"),
    HOUR(11, "H", "h", "hour"),
    DAY(5, "D", "d", "day"),
    WEEK(7, 5, "W", "w", "week"),
    MONTH(2, "M", "m", "month"),
    QUARTER(3, 2, "Q", "q", "quarter"),
    YEAR(1, "Y", "YY", "YYYY", "y", "yy", "yyyy", "year"),
    DECADE(10, 1, "DC", "dc", "decade"),
    CENTURY(100, 1, "C", "c", "century");

    private final int modifier;
    private final List units;
    private final int calendarField;

    private Period(int calendarField, String ... units) {
        this(1, calendarField, units);
    }

    private Period(int modifier, int calendarField, String ... units) {
        this.modifier = modifier;
        this.calendarField = calendarField;
        this.units = Arrays.asList(units);
    }

    public int getModifier() {
        return this.modifier;
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public boolean isDateTimePeriod() {
        List<String> qualifierPeriodOptions = Arrays.asList("ms", "MS", "s", "S", "mn", "MN", "n", "N", "h", "H", "d", "D");
        for (String validPeriod : qualifierPeriodOptions) {
            if (!this.units.contains(validPeriod)) continue;
            return true;
        }
        return false;
    }

    public static Period parse(String timeUnitString) {
        return Period.parse(timeUnitString, null);
    }

    public static Period parse(String periodString, Period defaultUnitIfNull) {
        for (Period period : Period.values()) {
            if (period.units.isEmpty() || !period.units.contains(periodString)) continue;
            return period;
        }
        return defaultUnitIfNull;
    }
}

