/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.spring;

import com.isomorphic.base.Config;
import com.isomorphic.interfaces.IHibernateSpringBridge;
import com.isomorphic.interfaces.ISpringTransactionObjectProvider;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.log.Logger;
import com.isomorphic.spring.SpringApplicationContextProvider;
import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTransactionObjectProvider
implements ISpringTransactionObjectProvider {
    private static Logger log = new Logger(SpringTransactionObjectProvider.class.getName());
    private static ApplicationContext ac = SpringApplicationContextProvider.getInstance();
    private static DataSource jdbcDataSource;

    public <T> T getSpringTransactionObject(String key) throws Exception {
        if ("hibernate".equals(key)) {
            return (T)SpringTransactionObjectProvider.getSpringHibernateTransaction();
        }
        return (T)SpringTransactionObjectProvider.getSpringJDBCConnection();
    }

    public static Connection getSpringJDBCConnection() throws Exception {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new Exception("An attempt was made to use the Spring transaction when there is no Spring transaction active.  Please scan the client-side docs for 'useSpringTransaction' to read about correct usage of Spring transaction support in SmartClient/SmartGWT");
        }
        if (ac == null) {
            throw new Exception("Failed to acquire Spring Application Context.");
        }
        if (jdbcDataSource == null) {
            String jdbcBeanName = Config.getGlobal().getString((Object)"sql.spring.jdbcDataSourceBean");
            if (jdbcBeanName == null || jdbcBeanName.length() == 0) {
                throw new Exception("No value for property sql.spring.jdbcDataSourceBean found in server.properties");
            }
            jdbcDataSource = (DataSource)ac.getBean(jdbcBeanName, DataSource.class);
            if (jdbcDataSource == null) {
                throw new Exception("Failed to acquire Spring bean '" + Config.getGlobal().getString((Object)"sql.spring.jdbcDataSourceBean"));
            }
        }
        Connection conn = DataSourceUtils.getConnection((DataSource)jdbcDataSource);
        log.debug((Object)("Returning Spring transactional connection '" + conn.hashCode() + "'"));
        return conn;
    }

    public static Object getSpringHibernateTransaction() throws Exception {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new Exception("An attempt was made to use the Spring transaction when there is no Spring transaction active.  Please scan the client-side docs for 'useSpringTransaction' to read about correct usage of Spring transaction support in SmartClient/SmartGWT");
        }
        if (ac == null) {
            throw new Exception("Failed to acquire Spring Application Context.");
        }
        String hbBeanName = Config.getGlobal().getString((Object)"hibernate.spring.sessionFactoryBean");
        if (hbBeanName == null || hbBeanName.length() == 0) {
            throw new Exception("No value for property hibernate.spring.sessionFactoryBean found in server.properties");
        }
        IHibernateSpringBridge provider = (IHibernateSpringBridge)InterfaceProvider.load((String)"IHibernateSpringBridge");
        return provider.getTransaction(hbBeanName);
    }

    static {
        if (ac == null) {
            log.warn((Object)"Couldn't acquire ApplicationContext");
        }
    }
}

