/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;

public class ISCInvocationHandler
implements InvocationHandler {
    protected static Logger log = new Logger(ISCInvocationHandler.class.getName());
    protected static Config config = Config.getGlobal();
    protected Object target = null;

    public Object getTarget() {
        return this.target;
    }

    public Object wrap(Object target) {
        this.target = target;
        return Reflection.proxyWrap(target, this);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.invoke(method, args);
        }
        catch (Throwable t) {
            if (t instanceof UndeclaredThrowableException) {
                Throwable cause = ((UndeclaredThrowableException)t).getCause();
                if (cause != null) {
                    throw cause;
                }
            } else if (t instanceof InvocationTargetException) {
                throw Reflection.getRealTargetException(t);
            }
            throw t;
        }
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        return method.invoke(this.target, args);
    }
}

