/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.HttpServletRequestParser;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RestRequestParser
implements HttpServletRequestParser {
    private Logger log = new Logger(this.getClass().getCanonicalName());
    public static final String ISC_META_DATA_PREFIX_PARAMETER_NAME = "isc_metaDataPrefix";
    public static final String DEFAULT_ISC_META_DATA_PREFIX = "_";
    private static final String DEFAULT_JSON_PREFIX = "<SCRIPT>//'\"]]>>isc_JSONResponseStart>>";
    private static final String DEFAULT_JSON_SUFFIX = "//isc_JSONResponseEnd";
    private String defaultDataFormat = "xml";
    private Boolean wrapJSONResponses = Boolean.TRUE;
    private String jsonPrefix;
    private String jsonSuffix;
    private String dynamicDataFormatParamName;
    SimpleDateFormat xmlSchemaDatetime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    SimpleDateFormat xmlSchemaDatetimeTZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    SimpleDateFormat xmlSchemaDatetimeMillis = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    SimpleDateFormat xmlSchemaDatetimeMillisTZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    SimpleDateFormat xmlSchemaDate = new SimpleDateFormat("yyyy-MM-dd");

    public String getDefaultDataFormat() {
        return this.defaultDataFormat;
    }

    public void setDefaultDataFormat(String defaultDataFormat) {
        if (!"xml".equalsIgnoreCase(defaultDataFormat) && !"json".equalsIgnoreCase(defaultDataFormat)) {
            throw new IllegalArgumentException("Accepted values: xml, json. Passed value:" + defaultDataFormat);
        }
        this.defaultDataFormat = defaultDataFormat.toLowerCase();
    }

    public void setDynamicDataFormatParamName(String dynamicDataFormatParamName) {
        this.dynamicDataFormatParamName = dynamicDataFormatParamName;
    }

    public Boolean getWrapJSONResponses() {
        return this.wrapJSONResponses;
    }

    public void setWrapJSONResponses(Boolean wrapJSONResponses) {
        this.wrapJSONResponses = wrapJSONResponses;
    }

    public String getJSONPrefix() {
        return this.jsonPrefix;
    }

    public String getJSONSuffix() {
        return this.jsonPrefix;
    }

    public void setJSONPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setJSONSuffix(String jsonSuffix) {
        this.jsonSuffix = jsonSuffix;
    }

    public RestRequestParser() {
    }

    public RestRequestParser(String defaultDataFormat, String dynamicDataFormatParamName) {
        this.setDefaultDataFormat(defaultDataFormat);
        this.setDynamicDataFormatParamName(dynamicDataFormatParamName);
    }

    /*
     * WARNING - void declaration
     */
    public void parseRequest(RPCManager rpc, HttpServletRequest req) throws Exception {
        ISCHttpServletRequest request;
        Map reqProps = null;
        String dataFormat = req.getParameter(this.dynamicDataFormatParamName);
        if (dataFormat == null) {
            dataFormat = this.getDefaultDataFormat();
        }
        if ((request = rpc.getContext().request).isMultipart()) {
            reqProps = request.getStringParams();
            String t = (String)reqProps.get("_transaction");
            if (t != null) {
                ValidationContext vc = new ValidationContext();
                vc.setRestrictedXMLMode(true);
                Object to = XML.toDSRecords(new StringReader(t), vc);
                vc.freeResources();
                reqProps.put("transaction", to);
                rpc.setJsCallback((String)((Map)to).get("jscallback"));
            }
        } else {
            Object reqPropsObj;
            String js = "";
            String contentType = req.getContentType();
            if (contentType == null || !contentType.contains("application/x-www-form-urlencoded")) {
                int charsRead;
                BufferedReader r = req.getReader();
                StringBuilder sb = new StringBuilder();
                char[] cArray = new char[512];
                while ((charsRead = r.read(cArray)) != -1) {
                    sb.append(cArray, 0, charsRead);
                }
                js = sb.toString().trim();
            }
            if ((dataFormat = req.getParameter(this.dynamicDataFormatParamName)) == null) {
                dataFormat = this.getDefaultDataFormat();
            }
            if (js.length() > 0) {
                if ("xml".equals(dataFormat)) {
                    this.log.debug("Parsing xml object: '" + js + "'");
                    ValidationContext vc = new ValidationContext();
                    vc.setRestrictedXMLMode(true);
                    reqPropsObj = XML.toDSRecords(new StringReader(js), vc);
                    vc.freeResources();
                } else {
                    JSTranslater jst = JSTranslater.get();
                    jst.preserveLiteralNulls(true);
                    this.log.debug("Parsing json object: '" + js + "'");
                    reqPropsObj = jst.fromJS(js);
                }
            } else {
                reqProps = request.getStringParams();
                reqPropsObj = reqProps;
                String t = (String)reqProps.get("_transaction");
                if (t != null) {
                    ValidationContext validationContext = new ValidationContext();
                    validationContext.setRestrictedXMLMode(true);
                    Object to = XML.toDSRecords(new StringReader(t), validationContext);
                    validationContext.freeResources();
                    reqProps.put("transaction", to);
                    rpc.setJsCallback((String)((Map)to).get("jscallback"));
                }
            }
            if (!(reqPropsObj instanceof Map)) {
                throw new Exception("Invalid request format: " + (reqPropsObj == null ? "null" : reqPropsObj.getClass().getName()));
            }
            reqProps = reqPropsObj;
        }
        boolean isQueue = false;
        List queue = null;
        Map trx = (Map)reqProps.get("transaction");
        if (trx != null) {
            isQueue = true;
            queue = (ArrayList<Map>)trx.get("operations");
        } else if (reqProps.get("operations") instanceof Map) {
            Map operations = (Map)reqProps.get("operations");
            if (operations.get("request") instanceof List) {
                queue = (List)operations.get("request");
            }
        } else {
            queue = new ArrayList<Map>();
            queue.add(reqProps);
        }
        if (queue == null) {
            throw new Exception("Fail: The request doesn't look like a single request, and it doesn't look like a queue either!");
        }
        for (Object e : queue) {
            String metaDataPrefix;
            Map<String, ArrayList<Object>> data;
            Object dsName;
            void var10_17;
            if (e instanceof String) {
                JSTranslater jst = JSTranslater.get();
                jst.preserveLiteralNulls(true);
                Object object = jst.fromJS((String)e);
            }
            reqProps = (Map)var10_17;
            if ("xml".equals(dataFormat) && (dsName = reqProps.get("dataSource")) != null && (data = (Map<String, ArrayList<Object>>)reqProps.get("data")) instanceof Map && data.containsKey(dsName)) {
                Object dsData = ((Map)data).get(dsName);
                ((Map)data).remove(dsName);
                if (dsData == null) {
                    reqProps.put("data", new HashMap());
                } else {
                    reqProps.put("data", dsData);
                }
            }
            Object dataObj = reqProps.get("data");
            data = null;
            if (dataObj instanceof Map) {
                data = (HashMap<String, String>)dataObj;
            }
            if (data == null) {
                data = new HashMap<String, String>();
            }
            if ((metaDataPrefix = req.getParameter(ISC_META_DATA_PREFIX_PARAMETER_NAME)) == null) {
                metaDataPrefix = DEFAULT_ISC_META_DATA_PREFIX;
            }
            boolean advancedCriteria = false;
            Enumeration parameterNames = req.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String[] values;
                String parameterName = (String)parameterNames.nextElement();
                this.log.debug("Parameter:'" + parameterName + "'. Value:'" + req.getParameter(parameterName) + "'.");
                if (ISC_META_DATA_PREFIX_PARAMETER_NAME.equals(parameterName) || this.dynamicDataFormatParamName.equals(parameterName)) continue;
                if (parameterName.equals("_constructor")) {
                    String constructor = req.getParameter(parameterName);
                    if (!"AdvancedCriteria".equals(constructor)) continue;
                    advancedCriteria = true;
                    data.put(parameterName, (ArrayList<Object>)((Object)constructor));
                    continue;
                }
                if (parameterName.startsWith(metaDataPrefix)) {
                    String realParameterName = parameterName.substring(metaDataPrefix.length());
                    reqProps.put(realParameterName, req.getParameter(parameterName));
                    continue;
                }
                if ("criteria".equals(parameterName)) {
                    values = req.getParameterValues(parameterName);
                    for (int i = 0; i < values.length; ++i) {
                        Object critObj = JSTranslater.get().fromJS(values[i]);
                        if (critObj instanceof Map) {
                            if (values.length == 1) {
                                data = (Map)critObj;
                                continue;
                            }
                            ArrayList<Object> subCriteria = (ArrayList<Object>)data.get("criteria");
                            if (subCriteria == null) {
                                subCriteria = new ArrayList<Object>();
                                data.put("criteria", subCriteria);
                            }
                            subCriteria.add(critObj);
                            continue;
                        }
                        throw new Exception("Invalid criteria object: " + DataTools.prettyPrint(critObj) + " - must be an object literal");
                    }
                    continue;
                }
                if ("summaryFunctions".equals(parameterName)) {
                    String[] summaryFunctionValues;
                    LinkedHashMap summaryFunctions = new LinkedHashMap();
                    for (String summaryfunctionAsJsonString : summaryFunctionValues = req.getParameterValues(parameterName)) {
                        Object jsObject = JSTranslater.get().fromJS(summaryfunctionAsJsonString);
                        if (!(jsObject instanceof Map)) continue;
                        summaryFunctions.putAll((Map)jsObject);
                    }
                    reqProps.put("summaryFunctions", summaryFunctions);
                    continue;
                }
                if ("groupBy".equals(parameterName)) {
                    String[] groupByValues = req.getParameterValues(parameterName);
                    reqProps.put("groupBy", new LinkedList<String>(Arrays.asList(groupByValues)));
                    continue;
                }
                values = req.getParameterValues(parameterName);
                if (values.length > 1) {
                    ArrayList<Object> critValues = new ArrayList<Object>();
                    for (int i = 0; i < values.length; ++i) {
                        critValues.add(JSTranslater.get().fromJS(values[i]));
                    }
                    data.put(parameterName, critValues);
                    continue;
                }
                data.put(parameterName, (ArrayList<Object>)((Object)req.getParameter(parameterName)));
            }
            reqProps.put("data", data);
            if (reqProps.get("dataSource") == null) {
                throw new Exception("The DataSource ID was missing from the request.");
            }
            DataSource ds = DataSourceManager.get((String)reqProps.get("dataSource"), null);
            String opType = (String)reqProps.get("operationType");
            if ("add".equals(opType) || "saveFile".equals(opType) || "getFile".equals(opType) || "hasFile".equals(opType) || "renameFile".equals(opType) || "removeFile".equals(opType)) {
                reqProps.put("values", data);
            } else if ("fetch".equals(opType) || "viewFile".equals(opType) || "listFiles".equals(opType)) {
                reqProps.put("criteria", data);
            } else {
                reqProps.put("values", data);
                HashMap criteria = new HashMap();
                if (ds != null) {
                    for (String fieldName : data.keySet()) {
                        DSField field = ds.getField(fieldName);
                        if (field == null || !field.isPrimaryKey()) continue;
                        criteria.put(fieldName, data.get(fieldName));
                    }
                }
                reqProps.put("criteria", criteria);
            }
            this.convertStringsToSchemaType(data, ds);
            HashMap opConfig = new HashMap();
            opConfig.put("operationType", reqProps.get("operationType"));
            opConfig.put("dataSource", reqProps.get("dataSource"));
            if (reqProps.get("textMatchStyle") != null) {
                opConfig.put("textMatchStyle", reqProps.get("textMatchStyle"));
            }
            reqProps.put("operationConfig", opConfig);
            if (reqProps.get("operationId") != null) {
                reqProps.put("operation", reqProps.get("operationId"));
            } else {
                reqProps.put("operation", reqProps.get("dataSource") + DEFAULT_ISC_META_DATA_PREFIX + reqProps.get("operationType"));
            }
            DSRequest dsReq = new DSRequest(reqProps, rpc.getContext(), rpc);
            dsReq.setREST(Boolean.TRUE);
            dsReq.setDataFormat(dataFormat);
            dsReq.setWrapJSONResponses(this.getWrapJSONResponses());
            if (ds != null) {
                String dsJSONPrefix = (String)ds.getConfig().get("jsonPrefix");
                if (dsJSONPrefix != null) {
                    dsReq.setJsonPrefix(dsJSONPrefix);
                } else if (this.jsonPrefix != null) {
                    dsReq.setJsonPrefix(this.jsonPrefix);
                } else {
                    dsReq.setJsonPrefix(DEFAULT_JSON_PREFIX);
                }
                String dsJSONSuffix = (String)ds.getConfig().get("jsonSuffix");
                if (dsJSONSuffix != null) {
                    dsReq.setJsonSuffix(dsJSONSuffix);
                } else if (this.jsonSuffix != null) {
                    dsReq.setJsonPrefix(this.jsonSuffix);
                } else {
                    dsReq.setJsonSuffix(DEFAULT_JSON_SUFFIX);
                }
            } else {
                if (this.jsonPrefix != null) {
                    dsReq.setJsonPrefix(this.jsonPrefix);
                } else {
                    dsReq.setJsonPrefix(DEFAULT_JSON_PREFIX);
                }
                if (this.jsonSuffix != null) {
                    dsReq.setJsonSuffix(this.jsonSuffix);
                } else {
                    dsReq.setJsonSuffix(DEFAULT_JSON_SUFFIX);
                }
            }
            rpc.addRequest(dsReq);
        }
    }

    protected void convertStringsToSchemaType(Map props, DataSource ds) {
        Map criteriaMap;
        if (props == null) {
            return;
        }
        if (!(ds instanceof BasicDataSource)) {
            this.log.warn("parseOutCriteria: " + (ds == null ? "'null'" : ds.getName()) + " is not a BasicDataSource, cannot continue");
            return;
        }
        BasicDataSource bds = (BasicDataSource)ds;
        Object criteria = props.get("criteria");
        if (criteria instanceof Map && (criteriaMap = (Map)criteria).size() == 1 && criteriaMap.get("criterion") != null) {
            Object crit = criteriaMap.get("criterion");
            if (crit instanceof List) {
                props.put("criteria", crit);
            } else {
                ArrayList list = new ArrayList();
                list.add(crit);
                props.put("criteria", list);
            }
        }
        if ((criteria = props.get("criteria")) instanceof List) {
            List criteriaList = (List)criteria;
            for (int i = 0; i < criteriaList.size(); ++i) {
                String baseType;
                DSField field;
                Object crit = criteriaList.get(i);
                if (!(crit instanceof Map)) continue;
                Map critMap = (Map)crit;
                this.convertStringsToSchemaType((Map)criteriaList.get(i), ds);
                String fieldName = (String)critMap.get("fieldName");
                if (fieldName == null || (field = bds.getField(fieldName)) == null) continue;
                try {
                    baseType = bds.getSimpleBaseType(field.getType());
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error during getSimpleBaseType call", e);
                    return;
                }
                this.convertValueToSchemaType(fieldName, baseType, critMap, true);
            }
        }
        if (!props.containsKey("criteria")) {
            HashSet keys = new HashSet(props.keySet());
            for (String fieldName : keys) {
                String baseType;
                DSField field;
                if (fieldName == null || (field = bds.getField(fieldName)) == null) continue;
                try {
                    baseType = bds.getSimpleBaseType(field.getType());
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error during getSimpleBaseType call", e);
                    return;
                }
                this.convertValueToSchemaType(fieldName, baseType, props, false);
            }
        }
    }

    private void convertValueToSchemaType(String fieldName, String baseType, Map critMap, boolean isAdvanced) {
        ArrayList<Object> values = null;
        boolean wasMultiple = false;
        String keyName = isAdvanced ? "value" : fieldName;
        Object valueObj = critMap.get(keyName);
        if (valueObj instanceof List) {
            values = (ArrayList<Object>)valueObj;
            wasMultiple = true;
        } else {
            values = new ArrayList<Object>();
            values.add(valueObj);
        }
        for (int i = 0; i < values.size(); ++i) {
            Object converted;
            block19: {
                converted = values.get(i);
                if (converted instanceof String) {
                    String value = (String)converted;
                    if ("date".equals(baseType)) {
                        String dateValue = value;
                        try {
                            if (dateValue.length() == 19 || dateValue.length() == 23) {
                                dateValue = dateValue + "-0000";
                            }
                            if (dateValue.length() == 24) {
                                converted = this.xmlSchemaDatetimeTZ.parse(dateValue);
                                break block19;
                            }
                            converted = this.xmlSchemaDatetimeMillisTZ.parse(dateValue);
                        }
                        catch (ParseException pe) {
                            try {
                                converted = this.xmlSchemaDate.parse(dateValue);
                            }
                            catch (ParseException pe2) {
                                this.log.warn("Parse failure attempting to parse a date for field " + fieldName + " in criteria.  String value was '" + dateValue + "'.  Values for date fields should be sent in XML Schema format - eg '2006-08-03T11:27:17'");
                            }
                        }
                    } else if ("boolean".equals(baseType)) {
                        converted = new Boolean("true".equals(value));
                    } else if ("integer".equals(baseType)) {
                        converted = new Long(value);
                    } else if ("float".equals(baseType)) {
                        converted = new Double(value);
                    }
                }
            }
            values.set(i, converted);
        }
        if (wasMultiple) {
            critMap.put(keyName, values);
        } else {
            critMap.put(keyName, values.get(0));
        }
    }
}

