/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.ClassWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ClassBuilder
extends AbstractBuilder {
    public static final String ROOT = "ClassDoc";
    private ClassDoc classDoc;
    private ClassWriter writer;
    private boolean isInterface = false;
    private boolean isEnum = false;

    private ClassBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ClassBuilder getInstance(Configuration configuration, ClassDoc classDoc, ClassWriter classWriter) throws Exception {
        ClassBuilder classBuilder = new ClassBuilder(configuration);
        classBuilder.configuration = configuration;
        classBuilder.classDoc = classDoc;
        classBuilder.writer = classWriter;
        if (classDoc.isInterface()) {
            classBuilder.isInterface = true;
        } else if (classDoc.isEnum()) {
            classBuilder.isEnum = true;
            Util.setEnumDocumentation(configuration, classDoc);
        }
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
        return classBuilder;
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public void build() throws IOException {
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    public String getName() {
        return ROOT;
    }

    public void buildClassDoc(List list) throws Exception {
        this.build(list);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc packageDoc = this.classDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, packageDoc) >= 0 || containingPackagesSeen.contains(packageDoc.name()))) {
            Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.classDoc.containingPackage()) + DirectoryManager.getDirectoryPath(this.classDoc.containingPackage()) + File.separator, "doc-files", true);
            containingPackagesSeen.add(packageDoc.name());
        }
    }

    public void buildClassHeader() {
        String string = this.isInterface ? "doclet.Interface" : (this.isEnum ? "doclet.Enum" : "doclet.Class");
        this.writer.writeHeader(this.configuration.getText(string) + " " + this.classDoc.name());
    }

    public void buildClassTree() {
        this.writer.writeClassTree();
    }

    public void buildImplementedInterfacesInfo() {
        this.writer.writeImplementedInterfacesInfo();
    }

    public void buildSuperInterfacesInfo() {
        this.writer.writeSuperInterfacesInfo();
    }

    public void buildTypeParamInfo() {
        this.writer.writeTypeParamInfo();
    }

    public void buildSubClassInfo() {
        this.writer.writeSubClassInfo();
    }

    public void buildSubInterfacesInfo() {
        this.writer.writeSubInterfacesInfo();
    }

    public void buildInterfaceUsageInfo() {
        this.writer.writeInterfaceUsageInfo();
    }

    public void buildNestedClassInfo() {
        this.writer.writeNestedClassInfo();
    }

    public void buildDeprecationInfo() {
        this.writer.writeClassDeprecationInfo();
    }

    public void buildClassSignature() {
        StringBuffer stringBuffer = new StringBuffer(this.classDoc.modifiers() + " ");
        if (this.isEnum) {
            stringBuffer.append("enum ");
            int n = stringBuffer.indexOf("abstract");
            if (n >= 0) {
                stringBuffer.delete(n, n + new String("abstract").length());
                stringBuffer = new StringBuffer(Util.replaceText(stringBuffer.toString(), "  ", " "));
            }
            if ((n = stringBuffer.indexOf("final")) >= 0) {
                stringBuffer.delete(n, n + new String("final").length());
                stringBuffer = new StringBuffer(Util.replaceText(stringBuffer.toString(), "  ", " "));
            }
        } else if (!this.isInterface) {
            stringBuffer.append("class ");
        }
        this.writer.writeClassSignature(stringBuffer.toString());
    }

    public void buildClassDescription() {
        this.writer.writeClassDescription();
    }

    public void buildClassTagInfo() {
        this.writer.writeClassTagInfo();
    }

    public void buildMemberSummary(List list) throws Exception {
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).build(list);
        this.writer.completeMemberSummaryBuild();
    }

    public void buildEnumConstantsDetails(List list) throws Exception {
        this.configuration.getBuilderFactory().getEnumConstantsBuilder(this.writer).build(list);
    }

    public void buildFieldDetails(List list) throws Exception {
        this.configuration.getBuilderFactory().getFieldBuilder(this.writer).build(list);
    }

    public void buildConstructorDetails(List list) throws Exception {
        this.configuration.getBuilderFactory().getConstructorBuilder(this.writer).build(list);
    }

    public void buildMethodDetails(List list) throws Exception {
        this.configuration.getBuilderFactory().getMethodBuilder(this.writer).build(list);
    }

    public void buildClassFooter() {
        this.writer.writeFooter();
    }
}

