/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Config;
import com.isomorphic.base.ConfigLoader;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.naming.JNDI;
import com.isomorphic.naming.JNDISearchResult;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.sql.PoolableSQLConnectionFactory;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.taglib.LoadSystemSchemaTag;
import com.isomorphic.tools.BuiltinRPC;
import com.isomorphic.tools.SQLImport;
import com.isomorphic.tools.SQLTestException;
import com.isomorphic.util.DataTools;
import java.io.CharArrayWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.collections.map.LinkedMap;
import org.hibernate.exception.ConstraintViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminConsole
extends com.isomorphic.rpc.BuiltinRPC {
    private static String createTest = "CREATE TABLE isc_admin_test (foo varchar(1))";
    private static String dropTest = "DROP TABLE isc_admin_test";
    public static List restoreDBList = Collections.synchronizedList(SetUniqueList.decorate(new ArrayList()));

    public static DataTypeMap sanitizeConfig(Map passedConfig) throws Exception {
        if (passedConfig == null) {
            return null;
        }
        DataTypeMap sanitizedConfig = new DataTypeMap();
        ArrayList keys = new ArrayList(passedConfig.keySet());
        for (String key : keys) {
            if (passedConfig.get(key) == null || !key.startsWith("database") && !key.startsWith("interface") && !key.startsWith("driver") && !key.startsWith("autoJoinTransactions") && !key.startsWith("pool")) continue;
            Object value = passedConfig.get(key);
            key = key.replace('_', '.');
            sanitizedConfig.put((Object)key, value);
        }
        return sanitizedConfig;
    }

    public static void saveDBConfig(Map values) throws Exception {
        DataTypeMap form = new DataTypeMap(values);
        String dbName = form.getString((Object)"dbName");
        String interfaceType = (String)(form = AdminConsole.sanitizeConfig((Map)form)).get((Object)"interface.type");
        if (interfaceType != null && interfaceType.equals("jndi")) {
            form.put((Object)"pool.enabled", (Object)"false");
        }
        HashMap<String, Object> newConfig = new HashMap<String, Object>();
        for (String key : form.keySet()) {
            newConfig.put("sql." + dbName + "." + key, form.get((Object)key));
        }
        Config.persistProperties(newConfig, (String)ConfigLoader.server);
        DataTools.mapMerge(newConfig, (Map)config);
        String urlProperty = "sql." + dbName + ".driver.url";
        if (newConfig.get(urlProperty) == null) {
            try {
                Config.deleteProperty((String)urlProperty);
            }
            catch (Exception exception) {
                // empty catch block
            }
            config.remove((Object)urlProperty);
        }
        SQLConnectionManager.restartPoolManager();
        DataSourceManager.restartPoolManager();
    }

    public static RPCResponse testDB(String dbName, Map passedConfig) throws Exception {
        RPCResponse result = new RPCResponse();
        Config dbConfig = null;
        if (passedConfig != null) {
            dbConfig = new Config((Map)AdminConsole.sanitizeConfig(passedConfig));
        }
        log.info((Object)("testing db '" + dbName + "' with config: " + DataTools.prettyPrint((Object)dbConfig)));
        try {
            AdminConsole.testDBCore(dbName, dbConfig, null);
        }
        catch (SQLTestWarningException e) {
            result.setData((Object)("<font color='red'><b>WARNING:</b></font> Database " + dbName + " is connectable but the connection is limited.  We were unable to create or drop a test table, which means you are likely to experience problems importing DataSources."));
            return result;
        }
        catch (SQLTestException e) {
            result.setData((Object)("Failure: " + e.error + ". Error from Driver: " + e.originalException.toString()));
            result.setStatus(-1);
            return result;
        }
        result.setData((Object)("Database '" + dbName + "' is OK."));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void testDBCore(String dbName, Config dbConfig, Map result) throws SQLTestException {
        Connection conn = null;
        try {
            conn = AdminConsole.getConnectionForConfig(dbName, dbConfig);
            if (result != null) {
                SQLMetaData smd = new SQLMetaData(conn);
                Map pv = smd.getProductNameAndVersion();
                result.put("dbProductName", pv.get("productName"));
                result.put("dbProductVersion", pv.get("productVersion"));
            }
            if (conn == null) {
                throw new Exception("Can't get connection to '" + dbName + "'");
            }
            Statement s = null;
            try {
                s = conn.createStatement();
                s.executeUpdate(createTest);
            }
            catch (SQLException se) {
                try {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    s = conn.createStatement();
                    s.executeUpdate(dropTest);
                    s.executeUpdate(createTest);
                }
                catch (SQLException se2) {
                    throw new SQLTestWarningException("Limited: User has insufficient privileges to create or drop tables", se2);
                }
            }
            finally {
                block52: {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                    s = conn.createStatement();
                    s.executeUpdate(dropTest);
                    try {
                        s.close();
                        SQLConnectionManager.free((Connection)conn);
                    }
                    catch (Exception exception) {}
                    break block52;
                    catch (SQLException sQLException) {
                        try {
                            s.close();
                            SQLConnectionManager.free((Connection)conn);
                        }
                        catch (Exception exception) {}
                        catch (Throwable throwable) {
                            try {
                                s.close();
                                SQLConnectionManager.free((Connection)conn);
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                }
            }
        }
        catch (SQLTestWarningException stwe) {
            throw stwe;
        }
        catch (Exception e) {
            log.info((Object)("testDB (" + dbName + ") error: " + e.toString()));
            if (e.toString().indexOf("ClassNotFoundException") != -1) {
                throw new SQLTestException("JDBC Driver not installed", e);
            }
            throw new SQLTestException("Unable to connect", e);
        }
    }

    public static Connection getConnectionForConfig(String dbName, Config dbConfig) throws Exception {
        if (dbConfig == null) {
            log.debug((Object)("Testing DB connection for database: " + dbName));
            return SQLConnectionManager.getNewConnection((String)dbName);
        }
        log.debug((Object)("Testing DB connection for database: " + dbName + " with config: " + DataTools.prettyPrint((Object)dbConfig)));
        PoolableSQLConnectionFactory factory = new PoolableSQLConnectionFactory(dbName, dbConfig);
        Connection conn = (Connection)factory.makeObject();
        return conn;
    }

    public static List getDefinedDatabases(boolean testConnection) throws Exception {
        ArrayList<LinkedMap> dbList = new ArrayList<LinkedMap>();
        List dbNames = SQLConnectionManager.getDefinedDatabaseNames();
        String defaultDatabase = config.getString((Object)"sql.defaultDatabase");
        for (String dbName : dbNames) {
            Config dbConfig = config.getSubtree("sql." + dbName);
            boolean reload = false;
            if (dbConfig.size() == 0) {
                reload = true;
            }
            dbConfig.put((Object)"dbName", (Object)dbName);
            if (dbName.equals(defaultDatabase)) {
                dbConfig.put((Object)"isDefault", (Object)new Boolean(true));
            }
            if (!testConnection) {
                dbConfig.put((Object)"dbStatus", (Object)"Not tested");
            } else {
                try {
                    AdminConsole.testDBCore(dbName, null, (Map)dbConfig);
                    if (reload) {
                        dbConfig = config.getSubtree("sql." + dbName);
                        dbConfig.put((Object)"dbName", (Object)dbName);
                    }
                    dbConfig.put((Object)"dbStatus", (Object)"OK");
                }
                catch (SQLTestWarningException e) {
                    dbConfig.put((Object)"dbStatus", (Object)"OK, Read-Only");
                }
                catch (SQLTestException e) {
                    dbConfig.put((Object)"dbStatus", (Object)e.error);
                }
            }
            LinkedMap alteredConfig = new LinkedMap();
            for (Object key : dbConfig.keySet()) {
                Object value = dbConfig.get(key);
                key = key.toString().replace('.', '_');
                alteredConfig.put(key, value);
            }
            dbList.add(alteredConfig);
        }
        Collections.sort(dbList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map m1 = (Map)o1;
                Map m2 = (Map)o2;
                if ("true".equals(m1.get("driver.autoConfigured")) && !"true".equals(m1.get("driver.autoConfigured"))) {
                    return 1;
                }
                return ((String)m1.get("dbName")).compareTo((String)m2.get("dbName"));
            }
        });
        return dbList;
    }

    public static List discoverJNDIDatabases() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        List contextRoots = config.getList((Object)"sql.jndi.autoDetectRoots", new ArrayList());
        ArrayList l = new ArrayList();
        for (String contextRoot : contextRoots) {
            log.info((Object)("Discovering datasources at JNDI root: " + contextRoot));
            if (contextRoot.equals("__root__")) {
                contextRoot = "";
            }
            List searchResult = null;
            try {
                searchResult = JNDI.searchTreeForClass((String)contextRoot, javax.sql.DataSource.class, (List)DataTools.buildList((Object[])new Object[]{"java:comp/Resources"}));
            }
            catch (NamingException ne) {
                log.warn((Object)("Failure during JNDI datasource discovery: " + ne.getMessage()));
            }
            DataTools.addAll(l, (List)searchResult);
        }
        for (JNDISearchResult sr : l) {
            String path = sr.getPath();
            if (result.contains(path)) continue;
            log.info((Object)("Auto-discovered JNDI DataSource: " + path));
            result.add(path);
        }
        return result;
    }

    public static String setDefaultDB(String dbName) throws Exception {
        if (dbName == null || dbName.equals(config.getString((Object)"sql.defaultDatabase"))) {
            return dbName;
        }
        Config.persistProperty((String)"sql.defaultDatabase", (String)dbName, (String)ConfigLoader.server);
        config.put((Object)"sql.defaultDatabase", (Object)dbName);
        SQLConnectionManager.restartPoolManager();
        DataSourceManager.restartPoolManager();
        return dbName;
    }

    public static synchronized void testStart(String testURL, List<String> snapshotDBList) throws Exception {
        log.info((Object)testURL);
        if (config.getBoolean((Object)"autotest.running", false)) {
            log.warn((Object)"detected autotest.running: true on testStart - calling testEnd before proceeding");
            AdminConsole.testEnd(config.getString((Object)"autotest.testURL", "N/A"));
        }
        config.put((Object)"autotest.testURL", (Object)testURL);
        config.put((Object)"autotest.running", (Object)"true");
        config.put((Object)"autotest.restoreDBList", (Object)restoreDBList);
        String defaultDatabase = config.getString((Object)"sql.defaultDatabase");
        config.put((Object)"autotest.defaultDatabase", (Object)defaultDatabase);
        restoreDBList.clear();
        snapshotDBList = SetUniqueList.decorate(snapshotDBList);
        if (snapshotDBList.size() != 0) {
            for (String dbName : snapshotDBList) {
                List defaultDbAliases = DataTools.buildList((Object[])new Object[]{"isomorphic", "default", "defaultDatabase"});
                restoreDBList.add(defaultDbAliases.contains(dbName) ? defaultDatabase : dbName);
            }
            AdminConsole.snapshotDB(restoreDBList);
            log.info((Object)("explicit snapshotDB: " + DataTools.prettyPrint((Object)restoreDBList)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void testEnd(String testURL) throws Exception {
        try {
            log.info((Object)testURL);
            if (restoreDBList.size() != 0) {
                log.info((Object)("restoreDB flag is set, restoring database(s): " + DataTools.prettyPrint((Object)restoreDBList)));
                long start = new Date().getTime();
                AdminConsole.restoreDB(restoreDBList);
                long end = new Date().getTime();
                log.info((Object)("restore complete - took: " + (end - start) + "ms"));
            }
        }
        finally {
            restoreDBList.clear();
            try {
                AdminConsole.setDefaultDB(config.getString((Object)"autotest.defaultDatabase"));
            }
            finally {
                config.clearSubtree("autotest");
            }
        }
    }

    public static void snapshotDB(List<String> dbList) throws Exception {
        for (String dbName : dbList) {
            SQLDriver.snapshotDB((String)dbName);
        }
    }

    public static void restoreDB(List<String> dbList) throws Exception {
        Exception e = null;
        for (String dbName : dbList) {
            try {
                SQLDriver.restoreDB((String)dbName);
            }
            catch (Exception ee) {
                if (e == null) continue;
                e = ee;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPCResponse importDataSources(List dsList, boolean importTestData, boolean replaceTables) throws Exception {
        RPCResponse result = new RPCResponse();
        if (replaceTables) {
            boolean atLeastOneHB = false;
            for (String dsName : dsList) {
                DataSource ds = DataSourceManager.get((String)dsName, null);
                try {
                    String catalog;
                    String dbName;
                    if (ds == null) continue;
                    if ("hibernate".equals(ds.getType())) {
                        atLeastOneHB = true;
                    }
                    if ((dbName = (String)ds.getConfig().get("dbName")) == null) {
                        dbName = config.getString((Object)"sql.defaultDatabase");
                    }
                    if ((catalog = config.getString((Object)("sql." + dbName + ".driver.databaseName"))) != null) continue;
                    catalog = config.getString((Object)("sql." + dbName + ".driver.url"));
                    if (catalog == null) {
                        catalog = "isomorphic";
                        continue;
                    }
                    catalog = catalog.substring(catalog.lastIndexOf("/") + 1);
                }
                finally {
                    DataSourceManager.free((DataSource)ds);
                }
            }
            if (atLeastOneHB) {
                SQLImport.recreateHibernateSchema();
                List allDSList = BuiltinRPC.getDefinedDataSourcesAsList();
                for (Map dsDef : allDSList) {
                    if (!"hibernate".equals(dsDef.get("dsType")) || dsList.contains(dsDef.get("dsName"))) continue;
                    dsList.add(dsDef.get("dsName"));
                }
            }
        }
        boolean bl = SQLImport.schemaOnly = !importTestData;
        if (replaceTables) {
            SQLImport.dropTables = true;
            SQLImport.createTables = true;
        } else {
            SQLImport.dropTables = false;
            SQLImport.createTables = false;
        }
        ArrayList<String> successful = new ArrayList<String>();
        ArrayList<String> failedCVE = new ArrayList<String>();
        for (String dsName : dsList) {
            try {
                if (!SQLImport.processDataSource(dsName)) continue;
                successful.add(dsName);
            }
            catch (ConstraintViolationException cve) {
                failedCVE.add(dsName);
            }
            catch (Exception ee) {
                String exceptionStackTrace = DataTools.getStackTrace((Throwable)ee);
                String error = "There was a problem importing datasource '" + dsName + "'.  The error report below may indicate what the problem was.";
                log.error((Object)error, (Throwable)ee);
                result.setStatus(-1);
                result.setData((Object)(error + "\n\n" + exceptionStackTrace));
                return result;
            }
        }
        for (String dsName : failedCVE) {
            try {
                if (!SQLImport.processDataSource(dsName)) continue;
                successful.add(dsName);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        String message = "DataSources imported: " + successful;
        if (successful.size() != dsList.size()) {
            dsList.removeAll(successful);
            message = message + "\nThe following DataSources could not be imported: " + dsList + ".  Check the server log for details.";
        }
        result.setData((Object)message);
        return result;
    }

    public static String loadFrameworkDataSources() throws Exception {
        CharArrayWriter out = new CharArrayWriter();
        LoadSystemSchemaTag.loadFrameworkDataSources((Writer)out);
        return out.toString();
    }

    static class SQLTestWarningException
    extends SQLTestException {
        public SQLTestWarningException(String error, Exception e) {
            super(error, e);
        }
    }
}

