/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.opera.core.systems.OperaProduct;
import java.io.File;
import java.util.List;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;

public class OperaBinary {
    public static final String OPERA_PATH_ENV_VAR = "OPERA_PATH";
    private static final Platform platform = Platform.getCurrent();
    private final File binary;

    public OperaBinary(OperaProduct product) {
        this(OperaBinary.find(product));
        if (this.binary == null) {
            throw new WebDriverException("Cannot find Opera binary in your PATH or in OPERA_PATH");
        }
    }

    public OperaBinary(String userSpecifiedPath) {
        this(new File(userSpecifiedPath));
    }

    public OperaBinary(File userSpecifiedBinary) {
        this.binary = (File)Preconditions.checkNotNull((Object)userSpecifiedBinary);
        OperaBinary.checkExecutable(this.binary);
    }

    public File getFile() {
        return this.binary;
    }

    public static File find() {
        return OperaBinary.find(OperaProduct.DESKTOP);
    }

    public static File find(OperaProduct product) {
        File binary = OperaBinary.findBinaryBasedOnEnvironmentVariable();
        if (binary != null) {
            return binary;
        }
        return OperaBinary.findBinaryBasedOnPlatform(product);
    }

    private static File findBinaryBasedOnEnvironmentVariable() {
        String binaryPath = System.getenv(OPERA_PATH_ENV_VAR);
        if (binaryPath == null) {
            return null;
        }
        File binary = new File(binaryPath);
        if (binary.exists() && binary.isFile()) {
            return binary;
        }
        ImmutableList.Builder paths = ImmutableList.builder();
        switch (platform) {
            case WINDOWS: 
            case VISTA: 
            case XP: {
                if (!binaryPath.endsWith(".exe")) {
                    paths.add((Object)(binaryPath + ".exe"));
                    break;
                }
                paths.add((Object)binaryPath);
                break;
            }
            case MAC: {
                if (!binaryPath.endsWith(".app")) {
                    binaryPath = binaryPath + ".app";
                }
                for (String internalAppDirectory : ImmutableList.of((Object)"Contents/MacOS", (Object)"Contents/Resources/Opera Mobile.app/Contents/MacOS")) {
                    for (String b : OperaBinary.buildMobileBinaries()) {
                        paths.add((Object)String.format("%s/%s/%s", binaryPath, internalAppDirectory, b));
                    }
                }
                break;
            }
        }
        for (String path : paths.build()) {
            File possibleBinary = new File(path);
            if (!possibleBinary.exists()) continue;
            return possibleBinary;
        }
        return null;
    }

    private static File findBinaryBasedOnPlatform(OperaProduct product) {
        List<String> binaries;
        List<String> paths;
        switch (product) {
            case ALL: 
            case DESKTOP: {
                paths = OperaBinary.buildDesktopPaths();
                binaries = OperaBinary.buildDesktopBinaries();
                break;
            }
            case MOBILE: {
                paths = OperaBinary.buildMobilePaths();
                binaries = OperaBinary.buildMobileBinaries();
                break;
            }
            default: {
                return null;
            }
        }
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            return file;
        }
        for (String binary : binaries) {
            String systemOpera = CommandLine.find((String)binary);
            if (systemOpera == null) continue;
            return new File(systemOpera);
        }
        return null;
    }

    private static List<String> buildDesktopPaths() {
        ImmutableList.Builder paths = ImmutableList.builder();
        switch (platform) {
            case LINUX: 
            case UNIX: {
                paths.add((Object)"/usr/bin/opera");
                paths.add((Object)"/usr/bin/opera-next");
                break;
            }
            case MAC: {
                paths.add((Object)"/Applications/Opera.app/Contents/MacOS/Opera");
                paths.add((Object)"/Applications/Opera Next.app/Contents/MacOS/Opera");
                break;
            }
            case WINDOWS: 
            case VISTA: 
            case XP: {
                paths.addAll((Iterable)WindowsUtils.getPathsInProgramFiles((String)"Opera\\opera.exe"));
                paths.addAll((Iterable)WindowsUtils.getPathsInProgramFiles((String)"Opera Next\\opera.exe"));
            }
        }
        return paths.build();
    }

    private static List<String> buildDesktopBinaries() {
        return platform.is(Platform.WINDOWS) ? ImmutableList.of((Object)"opera.exe") : ImmutableList.of((Object)"opera", (Object)"opera-next");
    }

    private static List<String> buildMobilePaths() {
        ImmutableList.Builder paths = ImmutableList.builder();
        if (platform.is(Platform.WINDOWS)) {
            paths.addAll((Iterable)WindowsUtils.getPathsInProgramFiles((String)"Opera Mobile Emulator\\OperaMobileEmu.exe"));
            return paths.build();
        }
        String path = "";
        switch (platform) {
            case LINUX: 
            case UNIX: {
                path = "/usr/bin";
                break;
            }
            case MAC: {
                path = "/Applications/Opera Mobile Emulator.app/Contents/Resources/Opera Mobile.app/Contents/MacOS";
            }
        }
        for (String binary : OperaBinary.buildMobileBinaries()) {
            paths.add((Object)(path + binary));
        }
        return paths.build();
    }

    private static List<String> buildMobileBinaries() {
        switch (platform) {
            case WINDOWS: {
                return ImmutableList.of((Object)"OperaMobileEmu.exe");
            }
            case MAC: {
                return ImmutableList.of((Object)"Opera Mobile", (Object)"operamobile");
            }
            case LINUX: 
            case UNIX: {
                return ImmutableList.of((Object)"operamobile");
            }
        }
        return ImmutableList.of();
    }

    private static void checkExecutable(File executable) {
        Preconditions.checkState((boolean)executable.exists(), (String)"The executable does not exist: %s", (Object[])new Object[]{executable.getPath()});
        Preconditions.checkState((!executable.isDirectory() ? 1 : 0) != 0, (String)"The executable is a directory: %s", (Object[])new Object[]{executable.getPath()});
        Preconditions.checkState((boolean)executable.canExecute(), (String)"The file is not executable: %s", (Object[])new Object[]{executable.getPath()});
    }
}

