/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.protos.CoreProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.Core;
import com.opera.core.systems.scope.stp.services.messages.CoreMessage;
import java.util.List;

public class ScopeCore
extends AbstractService
implements Core {
    private boolean supportsMeta = false;
    private CoreProtos.BrowserInformation browserInformation;

    public ScopeCore(ScopeServices services) {
        super(services, "core");
        if (this.isVersionInRange("1.2")) {
            this.supportsMeta = true;
        }
        services.setCore(this);
    }

    private void assertHasMetaInformation() {
        if (!this.supportsMeta) {
            throw new UnsupportedOperationException("not available in this product");
        }
    }

    @Override
    public void init() {
        if (this.supportsMeta) {
            this.browserInformation = this.getBrowserInformation();
        }
    }

    @Override
    public String getCoreVersion() {
        this.assertHasMetaInformation();
        return this.browserInformation.getCoreVersion();
    }

    @Override
    public String getOperatingSystem() {
        this.assertHasMetaInformation();
        return this.browserInformation.getOperatingSystem();
    }

    @Override
    public String getProduct() {
        this.assertHasMetaInformation();
        return this.browserInformation.getProduct();
    }

    @Override
    public String getBinaryPath() {
        this.assertHasMetaInformation();
        return this.browserInformation.getBinaryPath();
    }

    @Override
    public String getUserAgent() {
        this.assertHasMetaInformation();
        return this.browserInformation.getUserAgent();
    }

    @Override
    public Integer getProcessID() {
        this.assertHasMetaInformation();
        return this.browserInformation.getProcessID();
    }

    @Override
    public void clearPrivateData(List<CoreProtos.ClearFlags> flags) {
        CoreProtos.ClearPrivateDataArg.Builder arg = CoreProtos.ClearPrivateDataArg.newBuilder();
        arg.addAllClearList(flags);
        this.executeMessage(CoreMessage.CLEAR_PRIVATE_DATA, (AbstractMessage.Builder<?>)arg);
    }

    public void clearPrivateData(OperaDriver.PrivateData ... flags) {
        this.clearPrivateData(this.privateDataFlagsToScope(flags));
    }

    private CoreProtos.BrowserInformation getBrowserInformation() {
        UmsProtos.Response response = this.executeMessage(CoreMessage.GET_BROWSER_INFORMATION);
        CoreProtos.BrowserInformation.Builder builder = CoreProtos.BrowserInformation.newBuilder();
        ScopeCore.buildPayload(response, builder);
        return builder.build();
    }

    private List<CoreProtos.ClearFlags> privateDataFlagsToScope(OperaDriver.PrivateData ... flags) {
        ImmutableList.Builder clearFlags = ImmutableList.builder();
        block18: for (OperaDriver.PrivateData flag : flags) {
            switch (flag) {
                case ALL: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_ALL);
                    continue block18;
                }
                case VISITED_LINKS: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_VISITED_LINKS);
                    continue block18;
                }
                case DISK_CACHE: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_DISK_CACHE);
                    continue block18;
                }
                case IMAGE_CACHE: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_IMAGE_CACHE);
                    continue block18;
                }
                case MEMORY_CACHE: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_MEMORY_CACHE);
                    continue block18;
                }
                case SENSITIVE_DATA: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_SENSITIVE_DATA);
                    continue block18;
                }
                case SESSION_COOKIES: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_SESSION_COOKIES);
                    continue block18;
                }
                case ALL_COOKIES: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_ALL_COOKIES);
                    continue block18;
                }
                case GLOBAL_HISTORY: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_GLOBAL_HISTORY);
                    continue block18;
                }
                case CONSOLE: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_CONSOLE);
                    continue block18;
                }
                case THUMBNAILS: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_THUMBNAILS);
                    continue block18;
                }
                case WEBDATABASES: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_WEBDATABASES);
                    continue block18;
                }
                case WEBSTORAGE: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_WEBSTORAGE);
                    continue block18;
                }
                case APPCACHE: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_APPCACHE);
                    continue block18;
                }
                case GEOLOCATION_PERMISSIONS: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_GEOLOCATION_PERMISSIONS);
                    continue block18;
                }
                case SITE_PREFS: {
                    clearFlags.add((Object)CoreProtos.ClearFlags.CLEAR_SITE_PREFS);
                    continue block18;
                }
                default: {
                    throw new ScopeException("Unhandled private data flag: " + (Object)((Object)flag));
                }
            }
        }
        return clearFlags.build();
    }
}

