/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.File;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;

public class SeleniumServerHelper {
    private static Logger log = new Logger(SeleniumServerHelper.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private static SeleniumServerHelper INSTANCE;
    private static int defaultSeleniumServerPort;
    private SeleniumServer seleniumServer;

    private SeleniumServerHelper() {
    }

    public static SeleniumServerHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SeleniumServerHelper();
        }
        return INSTANCE;
    }

    public SeleniumServer getSeleniumServer() {
        return this.seleniumServer;
    }

    public int getSeleniumPort() {
        if (this.seleniumServer == null) {
            return 0;
        }
        return this.seleniumServer.getPort();
    }

    public void startSeleniumServer() {
        try {
            TestRunnerConfiguration config = TestRunner.getConfiguration();
            File userExtensions = ISCFile.getCanonicalFile((String)config.getUserExtensionsFile());
            int port = defaultSeleniumServerPort;
            String seleniumServerPortString = System.getenv("DEV_SELENIUM_SERVER_PORT");
            try {
                if (seleniumServerPortString != null) {
                    port = Integer.valueOf(seleniumServerPortString);
                    log.info((Object)("Selenium server port set to: " + port));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to initialize selenium port from env var 'DEV_SELENIUM_SERVER_PORT' with value: " + seleniumServerPortString + " - backing off to default value: " + defaultSeleniumServerPort), (Throwable)e);
                port = defaultSeleniumServerPort;
            }
            RemoteControlConfiguration conf = new RemoteControlConfiguration();
            if (userExtensions != null && userExtensions.exists()) {
                conf.setUserExtensions(userExtensions);
            } else {
                log.error((Object)("Coudn't find the selenium user extensions configured to be at " + config.getUserExtensionsFile()));
            }
            log.info((Object)("Selenium server starting on port: " + port));
            conf.setPort(port);
            conf.setLogOutFileName(tmpDir + "/selenium.log");
            conf.setTimeoutInSeconds(15 * 60);
            this.seleniumServer = new SeleniumServer(false, conf);
            this.seleniumServer.boot();
            log.info((Object)("Selenium server started on port: " + port));
        }
        catch (Exception e) {
            log.error((Object)("Could not " + (this.seleniumServer == null ? "create" : "start") + " Selenium Server."), (Throwable)e);
        }
    }

    public void stopSeleniumServer() {
        if (this.seleniumServer != null) {
            try {
                this.seleniumServer.stop();
                log.info((Object)"Selenium server stopped");
                this.seleniumServer = null;
            }
            catch (Exception e) {
                log.error((Object)"Could not stop Selenium Server.", (Throwable)e);
            }
        }
    }

    static {
        defaultSeleniumServerPort = Config.getGlobal().getInt((Object)"selenium.server.port", 4444);
    }
}

