/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.Utils;
import com.thoughtworks.selenium.Selenium;

public class TestSpecifier {
    private TestSpecifierType m_type;
    private String m_identifier;
    private String m_fileName;
    private String m_testTarget;
    private String m_completeJS;

    TestSpecifier(String url, String name) {
        this.m_fileName = name;
        this.m_type = TestSpecifierType.tsUrl;
        this.m_testTarget = Utils.addURLArgument(url, "autotest=runner");
    }

    TestSpecifier(String id, String name, String locator) {
        this.m_type = TestSpecifierType.tsLocator;
        this.m_identifier = id;
        this.m_fileName = name;
        this.m_testTarget = locator;
    }

    TestSpecifier(String url, String name, String classes, ShowcaseSpecifier showcase) {
        if (classes != null) {
            TestRunnerConfiguration config = TestRunner.getConfiguration();
            url = Utils.addURLArgument(url, config.getGwtDevArgument());
            this.m_testTarget = Utils.addURLArgument(url, "classes=" + classes);
            this.m_type = TestSpecifierType.tsUrl;
        } else {
            this.m_testTarget = showcase.getNextTestCallback();
            this.m_type = TestSpecifierType.tsCallback;
        }
        this.m_completeJS = showcase.getTestCompleteCallback();
        this.m_fileName = name;
    }

    public String getTestId() {
        return this.m_identifier;
    }

    public String getTestName() {
        switch (this.m_type) {
            case tsUrl: 
            case tsCallback: {
                return this.m_fileName;
            }
            case tsLocator: {
                String id = null == this.m_identifier ? "[no id found]" : this.m_identifier;
                String url = null == this.m_fileName ? "[no URL found]" : this.m_fileName;
                return id + ":" + url;
            }
        }
        return null;
    }

    public void run(Selenium selenium) {
        TestRunnerConfiguration config = TestRunner.getConfiguration();
        switch (this.m_type) {
            case tsUrl: {
                String url = this.m_testTarget;
                if (config.shouldSaveServerLogs()) {
                    url = Utils.addURLArgument(url, "serverLogMode=" + config.getServerLogMode());
                }
                selenium.open(url);
                break;
            }
            case tsLocator: {
                selenium.click(this.m_testTarget);
                break;
            }
            case tsCallback: {
                Utils.getEvalWithTry(selenium, this.m_testTarget);
            }
        }
    }

    public void complete(Selenium selenium) {
        if (this.m_completeJS != null) {
            Utils.getEvalWithTry(selenium, this.m_completeJS);
        }
    }

    public static enum TestSpecifierType {
        tsUrl,
        tsLocator,
        tsCallback;

    }
}

