
/*

  SmartClient Ajax RIA system
  Version v11.0p_2022-11-10/EVAL Deployment (2022-11-10)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_Grids){isc.module_Grids=1;isc._moduleStart=isc._Grids_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'Grids load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;


if (window.isc && isc.version != "v11.0p_2022-11-10/EVAL Deployment" && !isc.DevUtil) {
    isc.logWarn("SmartClient module version mismatch detected: This application is loading the core module from "
        + "SmartClient version '" + isc.version + "' and additional modules from 'v11.0p_2022-11-10/EVAL Deployment'. Mixing resources from different "
        + "SmartClient packages is not supported and may lead to unpredictable behavior. If you are deploying resources "
        + "from a single package you may need to clear your browser cache, or restart your browser."
        + (isc.Browser.isSGWT ? " SmartGWT developers may also need to clear the gwt-unitCache and run a GWT Compile." : ""));
}





//> @interface List
// An interface for an ordered collection of items.
// <P>
// This is the interface that is expected by list-oriented display components such as the
// ListGrid.  The JavaScript native Array object is retrofitted to support the List interface.
// Also, a valid List can be created by mixing the List interface into any class that supports:
// <ul>
// <li> for read-only support: get(position), getLength()
// <li> for modifiable support: set(position), addAt(object, position), removeAt(position)
// </ul>
// <P>
// NOTE: this interface is compatible with the java.util.List interface, except that:
// <ul>
// <li> for removal by index, removeAt() must be called instead of remove().  In Java, remove()
// is an overloaded method that takes either an int or Object, whereas in JavaScript, a
// Number is an Object.
// <li> Iterators don't exist.
// </ul>
// Some methods from the Java List interface have been omitted from the documentation to avoid
// redundancy.
//
// @treeLocation Client Reference/System
// @visibility external
//<
isc.ClassFactory.defineInterface("List");

// Read-only
// --------------------------------------------------------------------------------------------
// - basics that must be implemented
//   "get", "getLength",
//
// - routines that can be implemented in terms of basics
//   - trivial routines
//     "isEmpty", "itemIsPresent", "rangeIsPresent", "first", "last",
//   - routines to consider for a custom implementation for performance
//     "indexOf", "lastIndexOf", "contains", "containsAll", "intersect",
//     "getItems", "getRange", "duplicate",

// Modification
// --------------------------------------------------------------------------------------------
// - basics that must be implemented
//   "set", "addAt", "removeAt",
//   - NOTE: technically, set() and setLength() are sufficient as a minimal interface, however,
//     this means that addAt() and removeAt() would need to be implemented by
//     lengthening/shortening the List and then setting every slot beyond the modified point,
//     which seems like a very silly default implementation.

// - routines that can be implemented in terms of basics
//   - trivial routines
//     "add", "addList",
//   - routines to consider for a custom implementation for performance
//      "setLength", "addListAt", "remove", "removeList", "sort", "sortByProperty"

//   - notifications
//     "dataChanged", "_startChangingData", "_doneChangingData",




isc.List.addInterfaceMethods({

init : function () {
    if (!this.data) this.data = [];
},

// --------------------------------------------------------------------------------------------
// Read-only Interface
// --------------------------------------------------------------------------------------------

// Basics that must be implemented
// --------------------------------------------------------------------------------------------

//> @method     list.get()
// Return the item at a particular position
// @group access
//
// @param pos (Number) position of the element to get
// @return    (object) whatever's at that position, or <code>undefined</code> if not found
//
// @visibility external
//<
// expected to be implemented by target

//>    @method        list.getLength()
// Return the number of items in this list
//
// @group access
//
//        @return    (Number)    number of items in the list
// @visibility external
//<
// expected to be implemented by target

// Implementable in terms of basics
// --------------------------------------------------------------------------------------------

//>    @method        list.isEmpty()
// Return whether or not this array is empty
//
// @group access
//        @return    (boolean)    true == this array is empty, false == some items in the array
// @visibility external
//<
// [stolen from Array]

//>    @method        list.first()
// Return the first item in this list
//
// @group access
//        @return    (any)    first item in the list
// @visibility external
//<
first : function () {
    return this.get(0);
},

//>    @method        list.last()
// Return the last item in this list
//
// @group access
//        @return    (any)    last item in the list
// @visibility external
//<
last : function () {
    return this.get(this.getLength()-1);
},

// Below might need custom implementations for performance
// --------------------------------------------------------------------------------------------

//>    @method        list.indexOf()
// Return the position in the list of the first instance of the specified object.
// <p>
// If pos is specified, starts looking after that position.
// <p>
// Returns -1 if not found.
//
// @group access
//        @param    obj         (any)        object to look for
//        @param    [pos]     (number)    earliest index to consider
//        @param    [endPos] (number)    last index to consider
//
//        @return    (number)            position of the item, if found, -1 if not found
// @visibility external
//<
indexOf : function (obj, pos, endPos) {
    // normalize position to the start of the list
    if (pos == null) pos = 0;
    if (endPos == null) endPos = this.getLength() - 1;

    for (var i = pos; i <= endPos; i++) {
        if (this.get(i) == obj) return i;
    }

    // not found -- return the not found flag
    return -1;
},

//>    @method        list.lastIndexOf()
// Return the position in the list of the last instance of the specified object.
// <p>
// If pos is specified, starts looking before that position.
// <p>
// Returns -1 if not found.
//
// @param    obj        (any)        object to look for
// @param    [pos]     (number)    last index to consider
// @param    [endPos] (number)    earliest index to consider
//
// @return    (number)            position of the item, if found, -1 if not found
//
// @group access
// @visibility external
//<
lastIndexOf : function (obj, pos, endPos) {
    // normalize position to the end of the list
    if (pos == null) pos = this.getLength() - 1;
    if (endPos == null) endPos = 0;

    for (var i = pos; i >= endPos; i--)
        if (this.get(i) == obj) return i;

    // not found -- return the not found flag
    return -1;
},

//>    @method        list.findIndex()
// Find the index of the first Object where property == value in the object.
// <P>
// Pass an Object instead to match multiple properties.
// <P>
// Note: for string values, matches are case sensitive.
//
// @param propertyName (String or Object or AdvancedCriteria) property to match, or if an Object is passed, set of
//                                        properties and values to match
// @param [value] (any) value to compare against (if propertyName is a string)
// @return (int) index of the first matching Object or -1 if not found
//
// @group access, find
// @visibility external
//<
// [stolen from Array]

//>    @method        list.findNextIndex()
// Like +link{findIndex()}, but inspects a range from <code>startIndex</code> to <code>endIndex</code>.
// <smartclient>
// <p>
// For convenience, findNextIndex() may also be called with a function (called the predicate
// function) for the <code>propertyName</code> parameter. In this usage pattern, the predicate
// function is invoked for each value of the list until the predicate returns a true value.
// The predicate function is passed three parameters: the current value, the current index, and
// the list. The value of <code>this</code> when the predicate function is called is the
// <code>value</code> parameter. For example:
// <pre>var currentUserRecord = recordList.findNextIndex(0, function (record, i, recordList) {
//    if (record.username == currentUsername && !record.accountDisabled) {
//        return true;
//    }
//});</pre>
// </smartclient>
//
// @param startIndex (int) first index to consider.
// @param propertyName (String or Function or Object or AdvancedCriteria) property to match;
// <smartclient>or, if a function is passed, the predicate function to call;</smartclient>
// or, if an object is passed, set of properties and values to match.
// @param [value] (any) value to compare against (if <code>propertyName</code> is a string)
// <smartclient>or the value of <code>this</code> when the predicate function is invoked (if
// <code>propertyName</code> is a function)</smartclient>
// @param [endIndex] (int) last index to consider (inclusive).
// @return (int) index of the first matching value or -1 if not found.
// @group access, find
// @visibility external
//<

findNextIndex : function (start, property, value, endPos, getContext) {
    var length = this.getLength();
    if (start == null) start = 0;
    else if (start >= length) return -1;
    if (endPos == null) endPos = length - 1;
    if (property == null) return -1;

    if (isc.isA.String(property)) {
        // single property to match
        for (var i = start; i <= endPos; i++) {
            var item = this.get(i, getContext);
            if (item && item[property] == value) return i;
        }
        // return -1 if we didn't find the object
        return -1;

    } else if (isc.isA.Function(property)) {
        var predicate = property,
            thisArg = value;
        for (var i = start; i <= endPos; i++) {
            value = this.get(i, getContext);
            if (predicate.call(thisArg, value, i, this)) return i;
        }
        return -1;

    } else {
        // "property" is an object specifying a set of properties to match
        return this.findNextMatch(property, start, endPos);
    }
},

//>    @method list.find()
// Like +link{findIndex()}, but returns the object itself instead of its index.
//
// @param propertyName (String or Object or AdvancedCriteria) property to match, or if an Object is passed, set of
//                                        properties and values to match
// @param [value] (any) value to compare against (if propertyName is a string)
// @return (Object) first matching object or null if not found
//
// @group access, find
// @visibility external
//<
// [stolen from Array]

//>    @method list.findAll()
// Find all objects where property == value in the object.
// <P>
// Pass an Object as the <code>propertyName</code> argument to match multiple properties.
//
// @param propertyName (String or Object or AdvancedCriteria) property to match, or if an Object is passed, set of
//                                        properties and values to match
// @param [value] (any) value to compare against (if propertyName is a string)
// @return (Array) all matching Objects or null if none found
//
// @group access, find
// @visibility external
//<
findAll : function (property, value) {

    if (property == null) return null;

    if (isc.isA.String(property)) {
        var matches = null,
            l = this.getLength()
        ;
        // single property to match
        for (var i = 0; i < l; i++) {
            var item = this.get(i);
            if (item && item[property] == value) {
                if (matches == null) matches = [];
                matches.add(item);
            }
        }
        return matches;
    } else {
        // "property" is an object specifying a set of properties to match
        return this.findAllMatches(property);
    }
},

//>    @method        list.contains()
// Return if this list contains the specified object.
// <P>
// If pos is specified, starts looking after that position.
//
// @group access
//        @param    obj        (any)        item to look for
//        @param    [pos]    (number)    optional position in the list to look after
//
//        @return    (boolean)    true == item was found, false == not found
// @visibility external
//<
// [stolen from Array]

//> @method     list.containsAll()
// Return whether this list contains all the item in the specified list.
//
// @group access
//      @param list     (List)      items to look for
//      @return (boolean)   whether all items were found
// @visibility external
//<
// [stolen from Array]

//>    @method        list.intersect()
// Return the list of items that are in both this list and the passed-in list(s).
//
//        @group    arrayMath
//
//        @param    lists    (all List arguments)        lists to intersect with
//        @return    (List)    intersection
// @visibility external
//<
// [stolen from Array]

//> @method     list.equals()
// Return whether this list is equal to another list.
// <P>
// Two lists are equal only if they have the same length and all contained items are in the same
// order and are also equal.
//
// @group access
//      @param list     (List)      list to check for equality
//      @return (boolean)   whether the specified list is equal to this list
// @visibility external
//<
// [stolen from Array]

//>    @method        list.getItems()
// Return the items at a list of specified positions.
//
// @group access
//        @param    itemList    (List of Number)        array of positions
//
//        @return    (array)        subset of the array, in the same order as itemList
// @visibility external
//<
// [stolen from Array]

//>    @method        list.getRange()
// Return the items between position start and end, non-inclusive at the end.
//
// @group access
//        @param    start    (number)    start position
//        @param    end        (number)    end position
//
//        @return    (Array)        subset of the array from start -&gt; end-1
// @visibility external
//<
getRange : function (start, end) {
    if (end == null) end = this.getLength() - 1;
    var output = [];
    for (var i = start; i < end; i++) {
        output[output.length] = this.get(i);
    }
    return output;
},

// see ResultSet.getCachedRow()
getCachedRow : function (rowNum) { return this.get(rowNum); },

//>    @method        list.duplicate()    (A)
// Return an Array that is a shallow copy of the list, that is, containing the same items.
//
// @group access
//        @return    (Array)        new array, pointing to the same items
// @visibility external
//<
duplicate : function () {
    return this.getClass().create().addList(this);
},

// --------------------------------------------------------------------------------------------
// Modification Interface
// --------------------------------------------------------------------------------------------

// Basics that must be implemented
// --------------------------------------------------------------------------------------------

//> @method     list.set()
// Change the array element at a particular position.
// <P>
// set() can be used to expand the length of the list.
//
// @param pos (number) position in the list to change
// @param obj (object) new value for that position
// @return    (object) previous value at that position, or <code>undefined</code> if not found
//
// @group modification
// @visibility external
//<
// expected to be implemented by target

//>    @method        list.addAt()
// Add a single item to this array at a specific position in the list, sliding other items over
// to fit.
//
// @group modification
//        @param        obj    (object)    object to add
//        @param        pos    (number)    position in the list to add at
//
//        @return            (object)    object that was added
// @visibility external
//<
// expected to be implemented by target

//>    @method        list.removeAt()
// Remove the item at the specified position, rearranging all subsequent items to fill the gap
//
// @group modification
//        @param    pos    (number)    position to remove
//
//        @return    (any)    item that was removed
// @visibility external
//<
// expected to be implemented by target

// Implementable in terms of basics
// --------------------------------------------------------------------------------------------

//>    @method        list.add()
// Add an object to this list, at the end
//
// @group modification
//        @param    object    (any)    object to add
//
//        @return    (any)            pointer to the object passed in
// @visibility external
//<
// As implemented below, if no position is specified, the object will be added to the end of
// the list.
// Note that array.add will attempt to preserve sort order if it is currently sorted when
// add() is called with no explicit position param.

add : function (object, secondArg) {
    var undef;
    if (secondArg !== undef) {
        // support calling as add(object, index)
        return this.addAt(object, secondArg);
    }
    this.addAt(object, this.getLength());

    // return the object that was added
    return object;
},

//>    @method        list.addList()
// Add a list of items to this array.
// <P>
// Note: you can specify that a subset range be added by passing start and end indices
//
// @group modification
//        @param    list    (array)        list of items to add
//        @param    [listStartRow]    (number)    optional start index in list
//        @param    [listEndRow]    (number)    optional end index in list (non-inclusive)
//
//        @return    (list)                list of items that were added
// @visibility external
//<
// [stolen from Array]

// Below might need custom implementations for performance
// --------------------------------------------------------------------------------------------

//>    @method        list.setLength()
// Set the length of this list.
// <P>
// If the length of the list is shortened, any elements past the new length of the list are removed.
// If the length is increased, all positions past the old length have the value
// <code>undefined</code>.
//
// @group modification
//        @param    length    (number)    new length
// @visibility external
//<
setLength : function (length) {
    this._startChangingData();
    if (length > this.getLength()) {
        // pad the list with empty slots
        var undef;
        while (length > this.getLength()) this.add(undef);
    } else {
        // remove everything beyond the specified length
        while (length < this.getLength()) this.removeAt(this.getLength()-1);
    }
    this._doneChangingData();
},

// Below methods need to shift indices of all existing items
// --------------------------------------------------------------------------------------------

//>    @method        list.addListAt()
// Add list of items list to this array at item pos.  All items after array[pos] will slide down to
// fit new items.
//
// @group modification
//        @param    list    (array)        new array of items
//        @param    pos        (number)    position in this list to put the new items
//
//        @return    (array)        the list of items that was added
// @visibility external
//<
addListAt : function (list, pos) {
    this._startChangingData();

    var length = list.getLength();
    for (var i = 0; i < length; i++) {
        this.addAt(list.get(i), pos+i);
    }

    this._doneChangingData();

    // return the list that was added
    return list;
},

//>    @method        list.remove()
// Remove first instance of the passed object from this array, sliding other items around to
// fill gaps.
//
// @group modification
// @param obj (any) item to remove
//
// @return (boolean) true if a matching object was found and removed, false if no matching
// object was found and the list remains unchanged.
// @visibility external
//<
remove : function (obj) {

    // return removed item, per java.util.List
    // if (isc.isA.Number(obj)) return this.removeAt(obj);

    var index = this.indexOf(obj);
    if (index == -1) return false;

    this._startChangingData();

    var length = this.getLength();
    for (var i = index; i < length; i++) this.set(i, this.get(i+1));
    this.setLength(length-1);

    this._doneChangingData();

    return true; // indicating object was removed, per java.util.Collection
},

//>    @method        list.removeList()
// Remove all instances of objects in the specified list from this list, sliding the remaining
// objects around to fill gaps.
//
// @group modification
//        @param    list    (array)        list of items to remove
//
//        @return    (list)    list of items passed in
// @visibility external
//<
removeList : function (removeList) {
    if (removeList == null) return null;

    // get ready to change data...
    this._startChangingData();

    var changed = false;
    for (var i = 0; i < this.getLength(); i++) {
        var item = this.get(i);

        // remove the current item and stay at the same position in the list
        if (removeList.contains(item)) {
            changed = true;
            this.removeAt(i);
            i--;
        }
    }
    this._doneChangingData();

    // return whether the list was changed
    return removeList;
},



//> @method    list.sort()
// Sorts the elements of the List in place.
// <P>
// The optional comparator function should take two parameters "a" and "b" which are the two list
// items to compare, and should return:
// <ul>
// <li> a value less than zero, if "a" is less than "b" such that "a" should appear earlier in the
//      list
// <li> zero, if "a" and "b" are equal
// <li> a value greater than zero, if "a" is greater than "b" such that "b" should appear earlier in
//      the list
// </ul>
//
//     @param    [comparator]  (function) comparator function to use
//     @return   (List)                   the list itself
// @visibility external
//<
sort : function (comparator) {
    // dump all the items to a native Array and sort them
    var items = this.getRange(0, this.getLength());
    items.sort(comparator);

    // then set every slot in the current List
    for (var i = 0; i < items.length; i++) this.set(i, items[i]);

    return this;
},

//>    @method list.getProperty()
// Return a new Array where the value of item i is the value of "property" of item i in this
// array.  If an item doesn't have that property or is null, return item will be null.
//
// @param property (string)    name of the property to look for
//
// @return (Array) array of the values of property in each item of this list
// @group iteration
// @visibility external
//<
getProperty : function (property) {
    var values = [];
    // then set every slot in the current List
    for (var i = 0; i < this.getLength(); i++) {
        var item = this.get(i);
        values[i] = item != null ? item[property] : null;
    }
    return values;
},


//>    @method        list.sortByProperty()
// Sort a list of objects by a given property of each item.
// <P>
// The optional normalizer, if passed as a function, is called for each item in the List, and
// should return whatever value should be used for sorting, which does not have to agree with
// the property value. By passing a normalizer function you can achieve any kind of sorting
// you'd like, including sorting by multiple properties.
// <P>
// NOTE: string sort is case INsensitive by default
//
//        @group    sorting
//
//        @param    property      (string)    name of the property to sort by
//        @param    up              (boolean)    true == sort ascending, false == sort descending
//        @param    [normalizer] (function or ValueMap)
//              May be specified as a function, with signature
//              <code>normalize(item, propertyName, context)</code>, where <code>item</code> is
//              a pointer to the item in the array, <code>propertyName</code> is the
//              property by which the array is being sorted, and <code>context</code> is the
//              arbitrary context passed into this method. Normalizer function should return
//              the value normalized for sorting.<br>
//              May also be specified as a ValueMap which maps property values to sortable values.
//      @param [context] (any) Callers may pass an arbitrary context into the sort method, which
//                          will then be made available to the normalizer function
//      @return (List) the list itself
//
// @visibility external
//<
sortByProperty : function (property, direction, normalizer, context) {
    // dump all the items to a native Array and sort them
    var items = this.getRange(0, this.getLength());
    items.sortByProperty(property, direction, normalizer, context);

    // then set every slot in the current List
    for (var i = 0; i < items.length; i++) this.set(i, items[i]);

    return this;
},


//> @method list.getValueMap()
// Get a map of the form <code>{ item[idField] -&gt; item[displayField] }</code>, for all
// items in the list.  Note that if more than one item has the same <code>idProperty</code>,
// the value for the later item in the list will clobber the value for the earlier item.
//
// @param idField (string)  Property to use as ID (data value) in the valueMap
// @param displayField (string) Property to use a display value in the valueMap
// @return (object) valueMap object
// @visibility external
//<
// imported as part of isc._stealArrayMethods


// DataChanged notification
// --------------------------------------------------------------------------------------------

//>    @method        list.dataChanged()    (A)
// Method called when this array changes in some way.  Observe the method to react to changes in
// this list.
// <P>
// Note: dataChanged() will only fire when items are added, removed or rearranged.  If a list
// contains objects, dataChanged() will not fire if changes are made to objects within the list
// without changing their position within the list.  If an observer of dataChanged() needs to react
// to such a change, you can manually fire dataChanged() by simply calling it.
// <P>
// Note: may be called multiple times as the result of a multi-item add or remove, etc.
//
// @group modification
// @visibility external
//<
dataChanged : function () {

    if (this.onDataChanged) this.onDataChanged()
}

//>    @method        list._startChangingData()    (A)
//            Internal method to indicate that data will be changed within the context of a function.
//            Each occurance of a call to this method should be matched with an occurance of
//            _doneChangingData() -- when they balance, the public dataChanged() method will be called
//            exactly once.  This lets observers of the dataChanged() method only get called once for
//            a set of changes.
//
//            For example, clearRange() calls clearItem() repeatedly; we don't want each of
//             these "nested" calls to clearItem to generate a dataChanged message,
//             (we only want one when clearRange is done).  However, clearItem() when called by
//             itself (outside of any higher-level operation) *should* call dataChanged when it
//             is done.
//
//<
// [stolen from Array]

//>    @method        list._doneChangingData()    (A)
//            Internal method to indicate that we're done changing data in the current scope.
//            See list._startChangingData()
//<
// [stolen from Array]

});

// steal methods from Array
isc._stealArrayMethods = function () {
    var methodList = [
                      // these are internal helpers only
                      "containsSubstring", "containsAllSubstring", "intersectDates", "intersectSubstring",
                      // methods that are implemented using only the List API on Array (because
                      // performance difference doesn't matter)
                      "isEmpty", "contains", "containsAll", "intersect", "equals",
                      "getItems", "addList", "getValueMap", "removeEvery",
                      "_startChangingData", "_doneChangingData", "_isChangingData",
                      // old ISC backcompat
                      "getItem", "setItem", "removeItem", "clearAll",
                      // find
                      "find", "findIndex", "findAllIndices", "findNextMatch", "findAllMatches", "findByKeys",
                      // Java.util.List compat
                      "size", "subList", "addAll", "removeAll", "clear"];
    // NOTE: applyMask won't work here, since the input is an Array instance, which is
    // ambiguous with passing an Array full of objects to mask.
    var methods = {};
    for (var i = 0; i < methodList.length; i++) {
        var methodName = methodList[i];
        methods[methodName] = Array.prototype[methodName];
    }

    isc.List.addInterfaceMethods(methods);
}
isc._stealArrayMethods();


// Override isA.List to return true for arrays as well as lists
// we have to do this here after the List interface has been defined...
isc.addMethods(isc.isA, {
//> @classMethod isA.List()
// Does <code>object</code> implement the  <code>List</code> interface?
// @param   object  (object)    object to test
// @return (boolean) <code>true</code> if the object is an Array or belongs to another class that
//                   implements the <code>List</code> API.
// @visibility external
//<
_$List:"List",
List : function (object) {
    if (object == null) return false;
    if (isc.isA.Array(object)) return true;
    // standard implementation for objects inheriting from interfaces/classes
    return object.isA && object.isA(this._$List);
}

});




//>    @class    Tree
//
// A Tree is a data model representing a set of objects linked into a hierarchy.
// <P>
// A Tree has no visual presentation, it is displayed by a +link{TreeGrid} or +link{ColumnTree}
// when supplied as +link{treeGrid.data} or +link{columnTree.data}.
// <P>
// A Tree can be constructed out of a List of objects interlinked by IDs or via explicitly
// specified Arrays of child objects.  See +link{attr:Tree.modelType} for an explanation of how
// to pass data to a Tree.
// <P>
// Typical usage is to call +link{treeGrid.fetchData()} to cause automatic creation of a
// +link{ResultTree}, which is a type of Tree that automatically handles loading data on
// demand.  For information on DataBinding Trees, see +link{group:treeDataBinding}.
//
// @implements List
// @treeLocation Client Reference/System
// @visibility external
//<
isc.ClassFactory.defineClass("Tree", null, "List");

// List.getProperty() needs to be explicitly installed because there is a Class.getProperty()
isc.Tree.addProperties({
    getProperty : isc.List.getInstanceProperty("getProperty")
})

//> @groupDef ancestry
// Parent/child relationships
//<

//> @groupDef openList
// Managing the list of currently visible nodes based on the open state of parents
// <P>
// This state may move to the TreeGrid
// @visibility internal
//<

isc.Tree.addClassProperties({

//>    @type    DisplayNodeType
//
// Flag passed to functions as displayNodeType, telling the function whether it should work on
// folders, leaves or both at once.
//        @group    ancestry
// @visibility external
//
//    @value    null/unset                      operate on both folders and leaves
FOLDERS_AND_LEAVES:null,
//     @value    "folders"                       operate on folders only, ignoring leaves
FOLDERS_ONLY: "folders",
//    @value    "leaves"                        operate on leaves only, ignoring folders
LEAVES_ONLY: "leaves",
//<

//>    @type    LoadState
// Trees that dynamically load nodes keep track of whether each node has loaded its children.
//
//    @value    isc.Tree.UNLOADED                    children have not been loaded and are not loading
UNLOADED: "unloaded",
//    @value    isc.Tree.LOADING                    currently in the process of loading
LOADING: "loading",
//    @value    isc.Tree.FOLDERS_LOADED                folders only are already loaded
FOLDERS_LOADED: "foldersLoaded",
//    @value    isc.Tree.LOADED                        already fully loaded
LOADED: "loaded",
//    @value    isc.Tree.LOADED_PARTIAL_CHILDREN    children form a ResultSet having only a partial
//                                                cache (applies only to the "paged"
//                                                +link{resultTree.fetchMode,fetchMode})
LOADED_PARTIAL_CHILDREN: "loadedPartialChildren",
// @group loadState
// @visibility external
//<

//> @type TreeModelType
//
// @value "parent" In this model, each node has an ID unique across the whole tree and a
// parent ID that points to its parent.  The name of the unique ID property can be specified
// via +link{attr:Tree.idField} and the name of the parent ID property can be specified via
// +link{attr:Tree.parentIdField}.  The initial set of nodes can be passed in as a list to
// +link{attr:Tree.data} and also added as a list later via +link{method:Tree.linkNodes}.
// Whether or not a given node is a folder is determined by the value of the property specified
// by +link{attr:Tree.isFolderProperty}.
// <br><br>
// The "parent" modelType is best for integrating with relational storage (because nodes can
// map easily to rows in a table) and collections of Beans and is the model used for DataBound
// trees.
PARENT:"parent",
//
// @value "children" In this model, nodes specify their children as a list of nodes.  The
// property that holds the children nodes is determined by +link{attr:Tree.childrenProperty}.
// Nodes are not required to have an ID that is unique across the whole tree (in fact, no ID is
// required at all).  Node names (specified by the +link{attr:Tree.nameProperty}, unique within
// their siblings, are optional but not required.  Whether or not a given node is a folder is
// determined by the presence of the children list (+link{attr:Tree.childrenProperty}).
CHILDREN:"children",
//
// @visibility external
//<

//> @type TreeFilterMode
// Mode for applying criteria to a tree.
// @value "strict" only nodes that actually match criteria are shown.  If a parent does not
//                 match the criteria, it will not be shown, even if it has children that do
//                 match the criteria
STRICT:"strict",
// @value "keepParents" parent nodes are kept if they have children which match the criteria,
//                      or, in a tree with
//                      +link{resultTree.loadDataOnDemand,loadDataOnDemand:true}, if they have
//                      not loaded children yet.
KEEP_PARENTS:"keepParents",
// @group treeFilter
// @visibility external
//<

autoID: 0

});


//
//    add instance defaults to the tree
//
isc.Tree.addProperties({

//> @attr tree.modelType (TreeModelType: "children" : IRWA)
//
// Selects the model used to construct the tree representation.  See +link{TreeModelType} for
// the available options and their implications.
// <P>
// If the "parent" modelType is used, you can provide the initial parent-linked data set to the
// tree via the +link{attr:Tree.data} attribute.  If the "children" modelType is used, you can
// provide the initial tree structure to the Tree via the +link{attr:Tree.root} attribute.
//
// @see attr:Tree.data
// @see attr:Tree.root
//
// @visibility external
// @example nodeTitles
//<
modelType: "children",

//> @attr tree.isFolderProperty (String: "isFolder": IRW)
//
// Name of property that defines whether a node is a folder.  By default this is set to
// +link{TreeNode.isFolder}.
//
// @see TreeNode.isFolder
// @visibility external
//<
isFolderProperty: "isFolder",

//> @attr tree.defaultIsFolder (boolean : null : IR)
// Controls whether nodes are assumed to be folders or leaves by default.
// <P>
// Nodes that have children or have the +link{isFolderProperty} set to true will be considered
// folders by default.  Other nodes will be considered folders or leaves by default according
// to this setting.
// <p>
// See also +link{resultTree.defaultIsFolder} for more details on how
// <code>defaultIsFolder</code> interacts with
// +link{treeGrid.loadDataOnDemand,loading data on demand}.
//
// @visibility external
//<

//> @attr tree.reportCollisions (Boolean : true : IR)
// If new nodes are added to a tree with modelType:"parent" which have the same
// +link{tree.idField,id field value} as existing nodes, the existing nodes are removed when
// the new nodes are added.
// <P>
// If reportCollisions is true, the Tree will log a warning in the developer console about this.
// <P>
// Note that if an id collision occurs between a new node and its ancestor, the ancestor will be
// removed and the new node will not be added to the tree.
// @visibility external
//<
reportCollisions:true,

// Whether to automatically create child -> parent links if modelType is "children"
// (so children are provided as arrays under the childrenProperty)
autoSetupParentLinks:true,

//> @attr tree.pathDelim (String : "/" : IRWA)
//
// Specifies the delimiter between node names.  The pathDelim is used to construct a unique
// path to each node. A path can be obtained for any node by calling
// +link{method:Tree.getPath} and can be used to find any node in the tree by calling
// +link{method:Tree.find}.  Note that you can also hand-construct a path - in other words
// you are not required to call +link{method:Tree.getPath} in order to later use
// +link{method:Tree.find} to retrieve it.
// <br><br>
// The pathDelim can be any character or sequence of characters, but must be a unique string
// with respect to the text that can appear in the +link{attr:Tree.nameProperty} that's used
// for naming the nodes.  So for example, if you have the following tree:
// <pre>
// one
//   two
//     three/four
// </pre>
// Then you will be unable to find the <code>three/four</code> node using
// +link{method:Tree.find} if your tree is using the default pathDelim of /.
// In such a case, you can use a different pathDelim for the tree.  For example if you used |
// for the path delim, then you can find the <code>three/four</code> node in the tree above by
// calling <code>tree.find("one|two|three/four")</code>.
// <br><br>
// The pathDelim is used only by +link{method:Tree.getPath} and +link{method:Tree.find} and
// does not affect any aspect of the tree structure or other forms of tree navigation (such as
// via +link{method:Tree.getChildren}).
//
// @see attr:Tree.nameProperty
// @see method:Tree.find
// @visibility external
//<
pathDelim:"/",

// not documented:
// parentProperty : always generated, // direct pointer to parent node

treeProperty : "_isc_tree", // internal property pointing back to the origin tree

//>    @attr tree.nameProperty     (string : "name" : IRW)
//
// Name of the property on a +link{TreeNode} that holds a name for the node that is unique
// among its immediate siblings, thus allowing a unique path to be used to identify the node,
// similar to a file system.  Default value is "name".  See +link{TreeNode.name} for usage.
//
// @see TreeNode.name
// @visibility external
// @example nodeTitles
//<
nameProperty:"name",

//>    @attr tree.titleProperty    (string : "title" : IRW)
//
// Name of the property on a +link{TreeNode} that holds the title of the node as it should be
// shown to the user.  Default value is "title".  See +link{TreeNode.title} for usage.
//
// @visibility external
//<
titleProperty:"title",

//> @attr tree.idField    (string : "id" : IRA)
//
// Name of the property on a +link{TreeNode} that holds an id for the node which is unique
// across the entire Tree.  Required for all nodes for trees with modelType "parent".
// Default value is "id".  See +link{TreeNode.id} for usage.
//
// @see TreeNode.id
// @visibility external
// @example nodeTitles
//<

//> @attr tree.parentIdField (string : "parentId" : IRA)
//
// For trees with modelType "parent", this property specifies the name of the property
// that contains the unique parent ID of a node.  Default value is "parentId".  See
// +link{TreeNode.parentId} for usage.
//
// @see TreeNode.parentId
// @visibility external
// @example nodeTitles
//<

//>    @attr    tree.childrenProperty    (string : "children" : IRW)
//
// For trees with the modelType "children", this property specifies the name of the property
// that contains the list of children for a node.
//
// @see attr:Tree.modelType
// @visibility external
// @example childrenArrays
//<
childrenProperty:"children",

//>    @attr    tree.openProperty    (string : null : IRWA)
//
// The property consulted by the default implementation of +link{Tree.isOpen()} to determine if the
// node is open or not.  By default, this property is auto-generated for you, but you can set
// it to a custom value if you want to declaratively specify this state, but be careful - if
// you display this Tree in multiple TreeGrids at the same time, the open state will not be
// tracked independently - see +link{group:sharingNodes} for more info on this.
//
// @group    openList
// @see group:sharingNodes
// @visibility external
// @example initialData
//<

//>    @attr    tree.cacheOpenList    (boolean : true : IRWA)
//        @group    openList
//            If true, we cache the open list and only recalculate it
//            if the tree has been marked as dirty.  If false, we get the openList
//            every time.
//<
cacheOpenList:true,

//>    @attr    tree.openListCriteria    (string|function : null : IRWA)
//        @group    openList
//            Criteria for whether or not nodes are included in the openList
//<


//> @attr tree.data             (List of TreeNode : null : IR)
//
// Optional initial data for the tree. How this data is interpreted depends on this tree's
// +link{tree.modelType}.
// <P>
// If <code>modelType</code> is <code>"parent"</code>, the list that you provide will be passed
// to +link{method:Tree.linkNodes}, integrating the nodes into the tree.
// <p>
// In this case the root node may be supplied explicitly via +link{Tree.root}, or auto generated,
// picking up its <code>id</code> via +link{Tree.rootValue}. Any nodes in the data with no
// explicitly specified +link{treeNode.parentId} will be added as children to this root element.
// <P>
// To create this tree:
// <pre>
// foo
//   bar
// zoo
// </pre>
// with modelType:"parent", you can do this:
// <pre>
// Tree.create({
//   data: [
//     {name: "foo", id: "foo"},
//     {name: "bar", id: "bar", parentId: "foo"},
//     {name: "zoo", id: "zoo"}
// });
// </pre>
// Or this (explicitly specified root):
// <pre>
// Tree.create({
//   root: {id: "root"},
//   data: [
//     {name: "foo", id: "foo", parentId: "root"},
//     {name: "bar", id: "bar", parentId: "foo"},
//     {name: "zoo", id: "zoo", parentId: "root"}
// });
// </pre>
// Or this (explicitly specified rootValue):
// <pre>
// Tree.create({
//   rootValue: "root",
//   data: [
//     {name: "foo", id: "foo", parentId: "root"},
//     {name: "bar", id: "bar", parentId: "foo"},
//     {name: "zoo", id: "zoo", parentId: "root"}
// });
// </pre>
// Specifying the root node explicitly allows you to give it a name, changing the way path
// derivation works (see +link{Tree.root} for more on naming the root node).
// <P>
// For <code>modelType:"children"</code> trees, the data passed in will be assumed to be an
// array of children of the tree's root node.
//
// @see attr:Tree.modelType
// @see TreeNode
// @visibility external
// @example nodeTitles
//<

//> @attr tree.rootValue             (string|number : null : IR)
//
// If you are using the "parent" modelType and did not specify a root node via +link{Tree.root}
// with an id (+link{Tree.idField}), then you can provide the root node's id via this property.
// See the example in +link{Tree.data} for more info.
//
// @see Tree.data
// @visibility external
// @example nodeTitles
//<

//>    @attr    tree.root        (TreeNode : null : IRW)
//
// If you're using the "parent" modelType, you can provide the root node configuration via this
// property.  If you don't provide it, one will be auto-created for you with an empty name.
// Read on for a description of what omitting the name property on the root node means for path
// derivation.
// <p>
// If you're using the "children" modelType, you can provide the initial tree data via this
// property.  So, for example, to construct the following tree:
// <pre>
// foo
//   bar
// zoo
// </pre>
// You would initialize the tree as follows:
// <smartclient>
// <pre>
// Tree.create({
//     root: { name:"root", children: [
//         { name:"foo", children: [
//             { name: "bar" }
//         ]},
//         { name: "zoo" }
//     ]}
// });
// </pre>
// Note that if you provide a <code>name</code> property for the root node, then the path to
// any node underneath it will start with that name.  So in the example above, the path to the
// <code>bar</code> node would be <code>root/foo/bar</code> (assuming you're using the default
// +link{attr:Tree.pathDelim}.  If you omit the name attribute on the root node, then its name
// is automatically set to the +link{attr:Tree.pathDelim} value.  So in the example above, if
// you omitted <code>name:"root"</code>, then the path to the <code>bar</code> node would be
// <code>/foo/bar</code>.
// </smartclient>
// <smartgwt>
// <pre>
// Tree tree = new Tree();
// tree.setRoot(
//     new TreeNode("root",
//         new TreeNode("foo",
//             new TreeNode("bar")),
//         new TreeNode("zoo")
//     )
// );
// </pre>
// </smartgwt>
// <br><br>
// Note: if you initialize a Tree with no <code>root</code> value, a root node will be
// auto-created for you.  You can then call +link{method:Tree.add} to construct the tree.
//
// @see Tree.modelType
// @see Tree.setRoot()
//
// @visibility external
// @example childrenArrays
//<

//discardParentlessNodes

//> @attr tree.discardParentlessNodes (Boolean : false : IRA)
// If this tree has +link{Tree.modelType,modelType:"parent"}, should nodes in the data array for the
// tree be dropped if they have an explicitly specified value for the +link{attr:Tree.parentIdField}
// which doesn't match any other nodes in the tree. If set to false these nodes will be added as
// children of the root node.
// @visibility external
//<
discardParentlessNodes:false,

//> @attr Tree.indexByLevel (boolean : false : IR)
// If enabled, the tree keeps an index of nodes by level, so that +link{tree.getLevelNodes()}
// can operate more efficiently
//<
indexByLevel: false,

//> @object TreeNode
//
// Every node in the tree is represented by a TreeNode object which is an object literal with a
// set of properties that configure the node.
// <p>
// When a Tree is supplied as +link{TreeGrid.data} to +link{TreeGrid}, you can also set
// properties from +link{ListGridRecord} on the TreeNode (e.g. setting
// +link{ListGridRecord.enabled}:<code>false</code> on the node).
//
// @treeLocation Client Reference/Grids/TreeGrid
// @treeLocation Client Reference/System/Tree
// @visibility external
//<


//> @attr treeNode.enabled  (boolean : null : IR)
// @include ListGridRecord.enabled
// @visibility external
//<

//> @attr treeNode.canDrag  (boolean : null : IRA)
// Governs whether this node can be dragged. Only has an effect if this node is displayed in
// a +link{TreeGrid} where +link{TreeGrid.canDragRecordsOut}, +link{TreeGrid.canReorderRecords}
// or +link{TreeGrid.canReparentNodes} is <code>true</code>.
// @visibility external
//<

//> @attr treeNode.canAcceptDrop (boolean : null : IRA)
//
// Governs whether dragged data (typically other <code>treeNode</code>s) may be dropped over
// this node. Only has an effect if this node is displayed in a +link{TreeGrid} where
// +link{TreeGrid.canAcceptDroppedRecords}, +link{TreeGrid.canReorderRecords} or
// +link{TreeGrid.canReparentNodes} is true.
//
// @visibility external
//<

//> @attr treeNode.isFolder (Boolean or String : null : IR)
//
// Set to <code>true</code> or a string that is not equal to (ignoring case)
// <code>"false"</code> to explicitly mark this node as a folder.  See +link{Tree.isFolder} for
// a full description of how the +link{Tree} determines whether a node is a folder or not.
// <p>
// Note: the name of this property can be changed by setting +link{Tree.isFolderProperty}.
//
// @see Tree.isFolderProperty
// @visibility external
//<

//> @attr treeNode.name (String : null, but see below : IR)
//
// Provides a name for the node that is unique among its immediate siblings, thus allowing a
// unique path to be used to identify the node, similar to a file system.  See
// +link{Tree.getPath()}.
// <p>
// If the nameProperty is not set on a given node, the +link{TreeNode.id} will be used instead.  If
// this is also missing, +link{tree.getName()} and +link{tree.getPath()} will auto-generate a
// unique name for you.  Thus names are not required, but if the dataset you are using already
// has usable names for each node, using them can make APIs such as +link{tree.find()} more
// useful.  Alternatively, if your dataset has unique ids consider providing those as
// +link{TreeNode.id}.
// <P>
// If a value provided for the nameProperty of a node (e.g. node.name) is not a
// string, it will be converted to a string by the Tree via ""+value.
// <p>
// This property is also used as the default title for the node (see +link{Tree.getTitle()})
// if +link{TreeNode.title} is not specified.
// <p>
// Note: the name of this property can be changed by setting +link{Tree.nameProperty}.
//
// @see Tree.nameProperty
// @see Tree.pathDelim
// @see Tree.getPath
// @see Tree.getTitle
// @visibility external
//<

//> @attr treeNode.title (HTML : null : IR)
//
// The title of the node as it should appear next to the node icon in the +link{Tree}.  If left
// unset, the value of +link{TreeNode.name} is used by default.  See the description in
// +link{Tree.getTitle()} for full details.
// <p>
// Note: the name of this property can be changed by setting +link{Tree.titleProperty}.
//
// @see Tree.titleProperty
// @see Tree.getTitle()
// @visibility external
//<

//> @attr treeNode.id (String or Number: null : IR)
//
// Specifies the unique ID of this node.
// <P>
// Required for trees with +link{Tree.modelType} "parent".  With modelType:"parent", the unique
// ID of a node, together with the unique ID of its parent (see +link{TreeNode.parentId}) is
// used by +link{Tree.linkNodes} to link a list of nodes into a tree.
// <p>
// Note: the name of this property can be changed by setting +link{Tree.idField}.
//
// @see TreeNode.parentId
// @see Tree.linkNodes()
// @see Tree.modelType
// @see Tree.idField
// @visibility external
//<

//> @attr treeNode.parentId (String or Number : null : IR)
//
// For trees with modelType:"parent", this property specifies the unique ID of this node's
// parent node.
// The unique ID of a node, together with the unique ID of its parent is used by
// +link{method:Tree.linkNodes} to link a list of nodes into a tree.
// <p>
// Note: the name of this property can be changed by setting +link{Tree.parentIdField}.
//
// @see TreeNode.id
// @see Tree.linkNodes()
// @see Tree.modelType
// @see Tree.parentIdField
// @visibility external
//<

//> @attr treeNode.children (List of TreeNode : null : IRW)
//
// For trees with the modelType "children", this property specifies the children of this
// TreeNode.
// <p>
// Note: the name of this property can be changed by setting +link{Tree.childrenProperty}
//
// @see Tree.modelType
// @see Tree.childrenProperty
// @visibility external
//<

//> @attr   treeNode.icon   (SCImgURL : null : [IRW])
// This Property allows the developer to customize the icon displayed next to a node.
// Set <code>node.icon</code> to the URL of the desired icon to display and
// it will be shown instead of the standard +link{treeGrid.nodeIcon} for this node.<br>
// Note that if +link{TreeNode.showOpenIcon} and/or +link{TreeNode.showDropIcon}
// is true for this node, customized icons for folder nodes will be appended with the
// +link{treeGrid.openIconSuffix} or +link{treeGrid.dropIconSuffix} suffixes on state change
// as with the standard +link{TreeGrid.folderIcon} for this treeGrid.  Also note that for
// custom folder icons, the +link{treeGrid.closedIconSuffix} will never be appended.
// <P>You can change the name of this property by setting
// +link{TreeGrid.customIconProperty}.
// @group treeIcons
// @visibility external
//<

//> @attr   treeNode.showOpenIcon (Boolean : false : [IRWA])
// For folder nodes showing custom icons (set via +link{treeNode.icon}),
// this property allows the developer to specify on a per-node basis whether an
// open state icon should be displayed when the folder is open.
// Set <code>node.showOpenIcon</code> to true to show the open state
// icons, or false to suppress this.<br>
// If not specified, this behavior is determined by +link{TreeGrid.showCustomIconOpen}
// for this node.
// <P>You can change the name of this property by setting
// +link{TreeGrid.customIconOpenProperty}.
// @see treeGrid.customIconProperty
// @see treeGrid.showCustomIconOpen
// @visibility external
// @group treeIcons
//<
showOpenIcon: false,

//> @attr   treeNode.showDropIcon (Boolean : false : [IRWA])
// For folder nodes showing custom icons (set via +link{treeNode.icon}),
// this property allows the developer to specify on a per-node basis whether a
// drop state icon should be displayed when the
// user drop-hovers over this folder.<br>
// Set <code>node.showDropIcon</code> to true to show the drop state
// icon, or false to suppress this.<br>
// If not specified, this behavior is determined by +link{treeGrid.showCustomIconDrop}
// for this node.
// <P>You can change the name of this property by setting
// +link{TreeGrid.customIconDropProperty}.
// @see treeGrid.customIconProperty
// @see treeGrid.showCustomIconDrop
// @visibility external
// @group treeIcons
//<
showDropIcon: false,


//>    @attr    tree.sortProp            (string : null : IRW)
//        @group    openList
//            Name of the property to sort by.
//            Set to null because we don't sort by default.
//<


//>    @attr    tree.sortDirection                (SortDirection : "ascending" : IRW)
//            Sort ascending by default
//<
sortDirection: "ascending",

//>    @attr tree.showRoot (Boolean : false : IRW)
// Controls whether the implicit root node is returned as part of the visible tree,
// specifically, whether it is returned in +link{getOpenList()}, which is the API view
// components typically use to get the list of visible nodes.
// <p>
// Default is to have the root node be implicit and not included in the open list, which means
// that the visible tree begins with the children of root.  This allows multiple nodes to
// appear at the top level of the tree.
// <P>
// You can set <code>showRoot:true</code> to show the single, logical root node as the only
// top-level node.  This property is only meaningful for Trees where you supplied a value for
// +link{Tree.root}, otherwise, you will see an automatically generated root node that is
// meaningless to the user.
//
// @visibility external
//<
showRoot: false,

//>    @attr tree.autoOpenRoot            (Boolean : true : IRW)
//
// If true, the root node is automatically opened when the tree is created or
// +link{Tree.setRoot()} is called.
//
// @visibility external
//<
autoOpenRoot: true,

//>    @attr tree.separateFolders    (Boolean : false : IRW)
// Should folders be sorted separately from leaves or should nodes be ordered according to
// their sort field value regardless of whether the node is a leaf or folder?
// @see tree.sortFoldersBeforeLeaves
// @visibility external
//<
separateFolders:false,

//>    @attr tree.sortFoldersBeforeLeaves (Boolean : true : IRW)
// If +link{tree.separateFolders} is true, should folders be displayed above or below leaves?
// When set to <code>true</code> folders will appear above leaves when the
// <code>sortDirection</code> applied to the tree is +link{type:SortDirection,"ascending"}
// @visibility external
//<
sortFoldersBeforeLeaves:true,

//>    @attr tree.defaultNodeTitle (string : "Untitled" : IRW)
//
// Title assigned to nodes without a +link{attr:Tree.titleProperty} value or a
// +link{attr:Tree.nameProperty} value.
//
// @visibility external
//<
defaultNodeTitle:"Untitled",

//>    @attr tree.defaultLoadState (LoadState : isc.Tree.UNLOADED : IRW)
//        @group    loadState
//            default load state for nodes where is has not been explicitly set
//<
// ResultTree defines a setter for this property.
defaultLoadState: isc.Tree.UNLOADED

});

//
//    add methods to the tree
//
isc.Tree.addMethods({
//>    @method    tree.init()    (A)
// Initialize the tree.<br><br>
//
// Links the initially provided nodes of the tree according to the tree.modelType.
// <br><br>
//
// Gives the tree a global ID and places it in the global scope.
//
//        @group    creation
//
//        @param    [all arguments]    (object)    objects with properties to override from default
//
// @see group:sharingNodes
//<
init : function () {
    this.setupProperties();

    // if a root wasn't specified, create one
    this.setRoot(this.root || this.makeRoot());

    // load breadth-first on init if so configured
    if (this.loadOnInit && this.loadBatchSize >= 0) this.loadSubtree(null, null, true);
},

setupProperties : function () {
    // make sure we have a global ID, but avoid doing this more than once as subclasses may
    // already have set up an ID
    if (this.ID == null || window[this.ID] != this) isc.ClassFactory.addGlobalID(this);

    // use a unique property for the parent link so that nodes moved between trees can't get
    // confused.  Advanced usages may still override.
    if (!this.parentProperty) this.parentProperty = "_parent_"+this.ID;

    // we rely on being able to scribble the isFolderProperty on nodes - if the user set this
    // to null or the empty string, create a unique identifier.
    if (!this.isFolderProperty) this.isFolderProperty = "_isFolder_"+this.ID;

    // initialize here instead of in addProperties() so we can detect if the user provided
    // explicit values - used by ResultTree.
    if (this.idField == null) this.idField = "id";
    if (this.parentIdField == null) this.parentIdField = "parentId";

    // set the openProperty if it wasn't set already
    if (!this.openProperty) this.openProperty = "_isOpen_" + this.ID;

    // Create an empty _levelNodes array if we're indexing by level
    if (this.indexByLevel) this._levelNodes = [];

    // An auto-generated property name to store precomputed lengths of open lists
    this._cachedLengthProperty = "_cachedLength_" + this.ID;

    // An auto-generated property name to store a boolean flag for whether the lengths of the
    // ancestors of a node will be updated to reflect changes to the node or one of its
    // descendants.  The value of the property is actually a number (or undefined) and it
    // is said to have a true value when the number is greater than zero.
    this._recursionCountProperty = "_recursionCount_" + this.ID;
},

//> @method tree.duplicate()
// Create a copy of tree. If includeData is <code>true</code>, the tree nodes are copied.
// Otherwise, just the tree settings and an empty root node are in the new tree.
//
// @param [includeData] (bool)  Should tree nodes be copied?
// @param [includeLoadState] (bool)  Should tree node loadState be retained?
// @return (tree) copy of tree.
// @group creation
// @visibility internal
//<
_knownProperties : ["autoOpenRoot", "childrenProperty", "defaultIsFolder",
                    "defaultNodeTitle", "discardParentlessNodes", "idField",
                    "isFolderProperty", "modelType", "nameProperty",
                    "parentIdField", "pathDelim", "reportCollisions", "rootValue",
                    "showRoot", "titleProperty", "isMultiDSTree", "dataSource", "operation" ],
_$openProperty: "openProperty",
_copyKnownProperties : function (newTree) {
    var undef;

    // Copy known properties
    for (var i = 0; i < this._knownProperties.length; i++) {
        var propertyName = this._knownProperties[i],
            value = this[propertyName];
        if (value !== undef) {
            newTree[propertyName] = value;
        }
    }

    // Handle some special dynamic properties
    var value = this[this._$openProperty];
    if (value !== undef && !value.startsWith("_isOpen_")) {
        newTree[this._$openProperty] = value;
    }
},
duplicate : function (includeData, includeLoadState) {

    // Create a new tree object
    var newTree = isc.Tree.create();
    this._copyKnownProperties(newTree);

    // Create a clean root node
    newTree.setRoot(this.getCleanNodeData(this.getRoot(), false, false, includeLoadState));

    // Copy nodes
    if (includeData) {
        var nodes = this.getOpenList(null, isc.Tree.FOLDERS_AND_LEAVES, null, null, null, null, true);
        nodes = this.getCleanNodeData(nodes, false, false, includeLoadState);
        newTree._linkNodes(nodes);
    }

    return newTree;
},


destroy : function () {
    this.destroyed = true;
    if (this._openNormalizer != null) this._openNormalizer.call(window);

    isc.ClassFactory.dereferenceGlobalID(this);
    this.Super("destroy", arguments);
},

//>    @method    tree.makeRoot()
//        @group    creation
//             Make a new, empty root node.
//
//        @return    (object)     new root node.
//<
makeRoot : function () {
    var root = {};
    var undef;
    if (this.idField !== undef) root[this.idField] = this.rootValue;
    root[this.treeProperty] = this.ID;
    return root;
},

// Convert a node to a folder and return any change in the length of the node's parent
// resulting from that conversion.  Callers are expected to add the change in length to all
// parents of the node.
convertToFolder : function (node) {

    var pagedResultTree = (
            isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged()),
        prevState = pagedResultTree && this.getLoadState(node),
        wasFolder = this.isFolder(node),
        changesParentLength = !wasFolder && node != this.root,
        origLength, parent;
    if (changesParentLength) {
        parent = this.getParent(node);
        changesParentLength = (parent != null);
        if (changesParentLength) {
            origLength = this._getNodeLengthToParent(node, parent);
        }
    }

    // Mark the node as a folder.
    node[this.isFolderProperty] = true;


    if (pagedResultTree) {
        var newState = this.getLoadState(node),
            prevFlag = (
                prevState === isc.Tree.LOADED ||
                prevState === isc.Tree.LOADED_PARTIAL_CHILDREN),
            newFlag = (
                newState === isc.Tree.LOADED ||
                newState === isc.Tree.LOADED_PARTIAL_CHILDREN);

        if (prevFlag != newFlag) {
            // Only update the _visibleDescendantsCachedProperty if it has been set before on
            // the node.
            var parent = this.getParent(node);
            if (isc.isA.Boolean(node[this._visibleDescendantsCachedProperty])) {
                this._setVisibleDescendantsCached(node, null, parent, false);
            }
        }
    }

    // Update the length of the node.
    var cachedLength = node[this._cachedLengthProperty];
    if (cachedLength == null) cachedLength = 0;
    node[this._cachedLengthProperty] = cachedLength + this._getDeltaLength(node, wasFolder, true);


    // Return any change in the length of the parent caused by converting the node to
    // a folder.
    if (changesParentLength) {
        return this._getNodeLengthToParent(node, parent) - origLength;
    } else {
        return 0;
    }
},

//>    @method    tree.makeNode()
//             Make a new, empty node from just a path
//            NOTE: creates any parents along the chain, as necessary
//        @group    creation
//        @return    (TreeNode)     new node
//<
// autoConvertParents forces the conversion of nodes in the parent chain to leaf or folder status as
// necessary to avoid dups.  For example, makeNode('foo') followed by makeNode('foo/') would
// normally create a leaf foo and a folder foo.  If autoConvertParents is set to true, there would
// only be the folder foo regardless of the makeNode() call order.
//
makeNode : function (path, autoConvertParents) {

    // first try to find the node -- if we can find it, just return it
    var node = this.find(path);
    if (node) {
        if (autoConvertParents) {
            var deltaLength = this.convertToFolder(node);
            if (deltaLength != 0 && node != this.root) {
                this._updateParentLengths(this.getParent(node), deltaLength);
            }
        }
        return node;
    }

    // The path will be in the format:
    // "root/p1/p2/p3/newLeaf" or
    // "/p1/p2/p3/newFolder/"
    //      where p1 etc are existing parents

    // get the parent path for this node
    var pathComponents = path.split(this.pathDelim);    // array:['','p1','p2','p3','newNode']

    // The path must start at the root - if it doesn't, assume it was intended to
    var rootName = this.getRoot()[this.nameProperty];
    if (rootName.endsWith(this.pathDelim)) {
        rootName = rootName.substring(0, rootName.length - this.pathDelim.length);
    }

    if (pathComponents[0] != rootName) pathComponents.addAt(rootName, 0);

    // If we're making a folder rather than a leaf, the path passed in will finish with the path
    // delimiter, so we'll have a blank at the end of the array
    var newNodeName = pathComponents[pathComponents.length - 1],
        makingLeaf = (newNodeName != isc.emptyString);

    if (!makingLeaf) {
        // chop off the empty slot at the end
        pathComponents.length = pathComponents.length -1;
        newNodeName = pathComponents[pathComponents.length - 1]
    }
//    this.logWarn("makingLeaf: " + makingLeaf + ", pathComponents:" + pathComponents);

    var parentPath = pathComponents.slice(0, (pathComponents.length -1)).join(this.pathDelim)
                     + this.pathDelim;


    // get a pointer to the parent
    var parent = this.find(parentPath);


    if (parent == null) {
        parent = this.find(parentPath.substring(0, parentPath.length - this.pathDelim.length));
    }

    // We need to create the parent if it doesn't exist, or is a leaf, and we're not converting
    // parents.  Call ourselves recursively to get the parent.
    // NOTE: this should bottom out at the root, which should always be defined
    if (!parent) {
        parent = this.makeNode(parentPath, autoConvertParents);
    } else if (!this.isFolder(parent)) {
        // If necessary convert the leaf parent to a folder
        var deltaLength = this.convertToFolder(parent);
        if (deltaLength != 0 && parent != this.root) {
            this._updateParentLengths(this.getParent(parent), deltaLength);
        }
    }

    // make the actual node
    var node = {};

    // set the name and path of the node
    node[this.nameProperty] = newNodeName;

    // making a folder - convert the node to a folder
    if (!makingLeaf) {
        var deltaLength = this.convertToFolder(node);
        if (deltaLength != 0 && node != this.root) {
            this._updateParentLengths(this.getParent(node), deltaLength);
        }
    }

    // and add it to the tree
    return this._add(node, parent);
},


//>    @method    tree.isRoot()
//
// Return true if the passed node is the root node.
//
// @param    node    (TreeNode)     node to test
// @return            (Boolean)    true if the node is the root node
//
// @visibility external
//<
isRoot : function (node) {
    return this.root == node;
},

//>    @method    tree.setupParentLinks()    (A)
//            Make sure the parent links are set up in all children of the root.
//            This lets you create a simple structure without back-links, while
//             having the back-links set up automatically
//        @group    ancestry
//
//        @param    [node]    (TreeNode)    parent node to set up child links to
//                                     (default is this.root)
//<
setupParentLinks : function (node) {
    // if the node wasn't passed in, use the root
    if (!node) node = this.root;
    return this._traverse(node, true, false, false, false);
},

// Recursively traverse the tree to implement setupParentLinks() and to assign the correct
// node lengths to the node and its descendants.  The setupParentLinks and assignCachedLengths
// are boolean arguments.  The node is the tree node and is expected to exist.  The last
// argument, recurse, is a boolean flag used internally to determine whether the current
// execution is at the top level of recursive calls to this method.
_traverse : function (node, setupParentLinks, assignCachedLengths, canonicalizeChildren, recurse) {


    if (setupParentLinks && node[this.idField] != null) {
        this.nodeIndex[node[this.idField]] = node;
    }

    // get the children array of the node
    var children = node[this.childrenProperty];


    if (children) {
        if (setupParentLinks) {
            // current assumption whenever loading subtrees is that if any children are returned
            // for a node, it's the complete set, and the node is marked "loaded"
            this.setLoadState(node, isc.Tree.LOADED);
        }

        // handle the children property containing a single child object.
        if (!(isc.isAn.Array(children) || isc.isA.ResultSet(children))) {
            children = node[this.childrenProperty] = [children];
        }
    }

    if (children) {
        // for each child
        var isArray = isc.isAn.Array(children),
            isResultSet = !isArray && isc.isA.ResultSet(children);

        var length = (isResultSet ? children._getCachedLength() : children.getLength());
        for (var i = 0; i < length; ++i) {
            var child = (isArray ? children[i] : children.getCachedRow(i));

            // if the child is null, skip it
            if (!child) continue;

            if (setupParentLinks) {
                // set the parentId on the child if it isn't set already
                if (child[this.parentIdField] == null && node[this.idField] != null)
                    child[this.parentIdField] = node[this.idField];

                // set the child's parent to the parent
                child[this.parentProperty] = node;

                this._addToLevelCache(child, node);
            }

            // If the child is a folder, call this method recursively on the child.
            if (this.isFolder(child)) {
                this._traverse(
                    child, setupParentLinks, assignCachedLengths, canonicalizeChildren, true);
            } else if (setupParentLinks && child[this.idField] != null) {
                this.nodeIndex[child[this.idField]] = child; // link into the nodeIndex
            }

            // Assign the _cachedLengthProperty on the child.  This is done after the recursive
            // call as the child's length can depend on the node lengths of its children.
            if (assignCachedLengths) {
                child[this._cachedLengthProperty] = this._getNodeLength(child);
            }
        }
    }

    if (canonicalizeChildren && children) {

        children = node[this.childrenProperty] = this._canonicalizeChildren(node, children, true);
        if (isc.isA.ResultSet(children)) {
            if (!(children.lengthIsKnown() && children.allMatchingRowsCached())) {
                this._setVisibleDescendantsCached(node, false, null, false);
            }
        }
    }

    // If this is the top level of the recursion, then the _cachedLengthProperty has been set
    // on all nodes except for the original node.  Set node[this._cachedLengthProperty] here.
    if (assignCachedLengths && !recurse) {
        node[this._cachedLengthProperty] = this._getNodeLength(node);
    }
},

//> @method tree.linkNodes()
// Adds an array of tree nodes into a Tree of +link{modelType} "parent".
// <P>
// The provided TreeNodes must contain, at a minimum, a field containing a unique ID for the
// node (specified by +link{attr:Tree.idField}) and a field containing the ID of the node's
// parent node (specified by +link{attr:Tree.parentIdField}).
// <P>
// This method handles receiving a mixture of leaf nodes and parent nodes, even out of order and
// with any tree depth.
// <P>
// Nodes may be passed with the +link{childrenProperty} already populated with an Array of
// children that should also be added to the Tree, and this is automatically handled.
//
// @param nodes (Array of TreeNode) list of nodes to link into the tree.
//
// @see attr:Tree.data
// @see attr:Tree.modelType
// @visibility external
//<
connectByParentID : function (records, idProperty, parentIdProperty, rootValue, isFolderProperty) {
    this._linkNodes(records, idProperty, parentIdProperty, rootValue, isFolderProperty);
},
connectByParentId : function (records, idProperty, parentIdProperty, rootValue, isFolderProperty) {
    this._linkNodes(records, idProperty, parentIdProperty, rootValue, isFolderProperty);
},


// NOTE: this does not handle multi-column (multi-property) primary keys
linkNodes : function (records, idProperty, parentIdProperty, rootValue, isFolderProperty, contextNode, suppressDataChanged) {
    return this._linkNodes(records, idProperty, parentIdProperty, rootValue, isFolderProperty, contextNode, suppressDataChanged);
},
_linkNodes : function (records, idProperty, parentIdProperty, rootValue, isFolderProperty, contextNode, suppressDataChanged) {

    if (this.modelType == "fields") {
        this.connectByFields(records);
        return;
    }

    records = records || this.data;
    idProperty = (idProperty != null) ? idProperty : this.idField;
    parentIdProperty = (parentIdProperty != null) ? parentIdProperty : this.parentIdField;
    rootValue = (rootValue != null) ? rootValue : this.rootValue;

    var newNodes = [];
    newNodes.addList(records);

    // build a local index of the nodes passed in. this will allow us to find parents within the
    // tree without having to do multiple array.finds (so it'll be linear time lookup)
    var localNodeIndex = {};
    for (var i = 0; i < newNodes.length; i++) {
        var id = newNodes[i][idProperty];
        if (id != null) localNodeIndex[id] = newNodes[i];
    }

    for (var i = 0; i < newNodes.length; i++) {
        var node = newNodes[i];

        // We look up parent chains and add interlinked nodes in parent order
        // so if we already have this node in the tree, skip it
        if (this.nodeIndex[node[idProperty]] == node) continue;
        if (node == null) continue;

        // Our parentId property may point to another node passed in (potentially in a chain)
        // In this case, ensure we link these parents into the tree first.
        var newParentId = node[parentIdProperty],
            newParent = newParentId != null ? localNodeIndex[newParentId] : null,
            newParents = []
        ;

        while (newParent != null) {
            if (newParent) newParents.add(newParent);
            newParentId = newParent[parentIdProperty];
            // Note: don't infinite loop if parentId==id - that's bad data, really, but such
            // datasets exist in the wild..
            newParent = newParentId != null && newParentId != node[parentIdProperty] ? localNodeIndex[newParentId] : null;
        }

        for (var ii = newParents.length; ii--; ) {
            if (this.logIsDebugEnabled(this._$treeLinking)) {
                this.logDebug("linkNodes running - adding interlinked parents to the tree in "+
                    " reverse hierarchical order -- currently adding node with id:"+
                    newParents[ii][idProperty], this._$treeLinking);
            }
            this._linkNode(newParents[ii], idProperty, parentIdProperty,
                           contextNode, rootValue);
            // at this point the parent is linked into the real tree --
            // blank out the entry in the local index so other nodes linked to it do
            // the right thing
            delete localNodeIndex[newParents[ii][idProperty]];
        }
        // Actually link in this node
        this._linkNode(node, idProperty, parentIdProperty, contextNode, rootValue);
        // blank out this slot - this will avoid us picking up this node in the newParents
        // array of other nodes when it has already been added to the tree if appropriate
        delete localNodeIndex[node[idProperty]];
    }

    this._clearNodeCache(true);
    if (!suppressDataChanged) this.dataChanged();
},

// old synonyms for backcompat
connectByParentID : function (records, idProperty, parentIdProperty, rootValue, isFolderProperty) {
    this._linkNodes(records, idProperty, parentIdProperty, rootValue, isFolderProperty);
},
connectByParentId : function (records, idProperty, parentIdProperty, rootValue, isFolderProperty) {
    this._linkNodes(records, idProperty, parentIdProperty, rootValue, isFolderProperty);
},

// _linkNode - helper to actually attach a node to our tree - called from the for-loop in _linkNodes()
// returns true if the node was successfully added to the tree.
_$treeLinking:"treeLinking",
_linkNode : function (node, idProperty, parentIdProperty, contextNode, rootValue) {

    var logDebugEnabled = this.logIsDebugEnabled(this._$treeLinking);

    var id = node[idProperty],
        parentId = node[parentIdProperty],
        undef,
        nullRootValue = (rootValue == null),
        // Note explicit === for emptyString comparison necessary as
        // 0 == "", but zero is a valid identifier
        nullParent = (parentId == null || parentId == -1 || parentId === isc.emptyString),
        parent = this.nodeIndex[parentId];

    if (parent) {
        if (logDebugEnabled) {
            this.logDebug("found parent " + parent[idProperty] +
                         " for child " + node[idProperty], this._$treeLinking);
        }
        this.__add(node, parent);
    } else if (!nullRootValue && parentId == rootValue) {

        if (logDebugEnabled) {
            this.logDebug("root node: " + node[idProperty], this._$treeLinking);
        }
        // this is a root node
        this.__add(node, this.root);

    } else {
        // Drop nodes with an explicit parent we can't find if discardParentlessNodes is true
        if (!nullParent && this.discardParentlessNodes) {
            this.logWarn("Couldn't find parent: " + parentId + " for node with id:" + id,
                         this._$treeLinking);
        } else {

            var defaultParent = contextNode || this.root;
            // if a contextNode was supplied, use that as the default parent node for all
            // nodes that are missing a parentId - this is for loading immediate children
            // only, without specifying a parentId
            if (logDebugEnabled) {
                this.logDebug("child:" + node[idProperty] +
                              (nullParent ? " has no explicit parent " :
                                        (" unable to find specified parent:" + parentId)) +
                              "- linking to default node " +
                              defaultParent[idProperty], this._$treeLinking);
            }
            this.__add(node, defaultParent);
        }
    }
},

connectByFields : function (data) {
    if (!data) data = this.data;
    // for each record
    for (var i = 0; i < data.length; i++) {
        this.addNodeByFields(data[i]);
    }
},

addNodeByFields : function (node) {
    // go through each field in this.fields in turn, descending through the hierarchy, creating
    // hierarchy as necessary


    var parent = this.root;
    for (var i = 0; i < this.fieldOrder.length; i++) {
        var fieldName = this.fieldOrder[i],
            fieldValue = node[fieldName];

        var folderName = isc.isA.String(fieldValue) ? fieldValue :
                                                      fieldValue + isc.emptyString,
            childNum = this.findChildNum(parent, folderName),
            child;
        if (childNum != -1) {
            //this.logWarn("found child for '" + fieldName + "':'" + fieldValue + "'");
            child = this.getChildren(parent).get(childNum);
        } else {
            // if there's no child with this field value, create one
            //this.logWarn("creating child for '" + fieldName + "':'" + fieldValue + "'");
            child = {};
            child[this.nameProperty] = folderName;
            this._add(child, parent);
            var deltaLength = this.convertToFolder(child);
            if (deltaLength != 0) {
                this._updateParentLengths(parent, deltaLength);
            }
        }
        parent = child;
    }
    // add the new node to the Tree
    //this.logWarn("adding node at: " + this.getPath(parent));
    this._add(node, parent);
},

//>    @method    tree.getRoot()
//
// Returns the root node of the tree.
//
// @return  (TreeNode)    the root node
//
// @visibility external
//<
getRoot : function () {
    return this.root;
},

//>    @method    tree.setRoot()
//
// Set the root node of the tree.
//
// @param   newRoot (TreeNode)    new root node
// @param   autoOpen (boolean)  set to true to automatically open the new root node.
//
// @visibility external
//<
setRoot : function (newRoot, autoOpen) {

    // assign the new root
    this.root = newRoot;

    // avoid issues if setRoot() is used to re-root a Tree on one of its own nodes
    var newRootFromSameTree = (newRoot && isc.endsWith(this.parentProperty, this.ID));
    if (newRootFromSameTree) newRoot[this.parentProperty] = null;


    var calcLength = !(newRootFromSameTree && this.root[this._cachedLengthProperty] != null);

    // make sure root points to us as its tree
    this.root[this.treeProperty] = this.ID;

    if (this.rootValue == null) this.rootValue = this.root[this.idField];

    // If the root node has no name, assign the path property to it.  This is for backcompat
    // and also a reasonable default.
    var rootName = this.root[this.nameProperty];
    if (rootName == null || rootName == isc.emptyString) {
        var wasFolder = !calcLength && this.isFolder(this.root);

        this.root[this.nameProperty] = this.pathDelim;
        // Setting the name can change the folderness of the node so update the root node's
        // length.
        if (!calcLength) {
            this.root[this._cachedLengthProperty] += this._getDeltaLength(
                this.root, wasFolder, this.isFolder(this.root));
        }
    }

    // Set the initial cached length of the new root node.
    if (calcLength) {
        var isFolder = this.isFolder(this.root);
        this.root[this._cachedLengthProperty] = (
            (isFolder && this.openDisplayNodeType != isc.Tree.LEAVES_ONLY) ||
            (!isFolder && this.openDisplayNodeType != isc.Tree.FOLDERS_ONLY) ? 1 : 0);
    }

    var pagedResultTree = (
            isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged());
    if (pagedResultTree) {
        if (this.root[this._visibleDescendantsCachedProperty] == null) {
            this.root[this._visibleDescendantsCachedProperty] = true;
            this._setVisibleDescendantsCached(this.root, null, null, true);
        }
    }

    // the root node is always a folder
    if (!this.isFolder(this.root)) {
        this.convertToFolder(this.root);
    }

    // NOTE: this index is permanent, staying with this Tree instance so that additional sets of
    // nodes can be incrementally linked into the existing structure.
    this.nodeIndex = {};

    // (re)create the structure of the Tree according to the model type
    if ("parent" == this.modelType) {
        // nodes provided as flat list (this.data); each record is expected to have a property
        // which is a globally unique ID (this.idField) and a property which has the globally
        // unique ID of its parent (this.parentIdField).

        // assemble the tree from this.data if present
        // Pass in the param to suppress dataChanged since we'll fire that below
        if (this.data) {
            this._linkingNodes = true;
            this._linkNodes(null, null, null, null, null, null, true);
            delete this._linkingNodes;
        }
    } else if ("fields" == this.modelType) {

        // nodes provided as flat list; a list of fields, in order, defines the Tree
        if (this.data) this.connectByFields();

    } else if ("children" == this.modelType) {

        // Each parent has an array of children.  Traverse the tree, starting at the root,
        // to setup the parent links (assuming this.autoSetupParentLinks is true) and to
        // assign the initial node lengths (i.e. _cachedLengthProperty) on all of the nodes.
        this._traverse(this.root, this.autoSetupParentLinks, true, false, false);

        if (this.data) {
            var data = this.data;
            this.data = null;
            this._addList(data, this.root);
        }
    } else {
        this.logWarn("Unsupported modelType: " + this.modelType);
    }

    // Slot the root node into nodeIndex
    this.setupParentLinks();

    // open the new root if autoOpen: true passed in or this.autoOpenRoot is true.  Suppress
    // autoOpen if autoOpen:false passed in
    if (autoOpen !== false && (this.autoOpenRoot || autoOpen)) {
        this.openFolder(newRoot);
    }

    // Slot the root node into nodeIndex, and, for paged ResultTrees, change the container
    // of the children of any node with a valid childCountProperty value from an array to
    // a ResultSet.
    this._traverse(this.root, true, false, pagedResultTree, false);

    // mark the tree as dirty and note that the data has changed
    this._clearNodeCache();
    this.dataChanged();
},

// get a copy of these nodes without all the properties the Tree scribbles on them.
// Note the intent here is that children should in fact be serialized unless the caller has
// explicitly trimmed them.
getCleanNodeData : function (nodeList, includeChildren, cleanChildren, includeLoadState) {

    return isc.Tree.getCleanNodeData(nodeList, includeChildren, true, includeLoadState, this);
},

//
// identity methods -- override these for your custom trees
//

//>    @method    tree.getName()
//
// Get the 'name' of a node.  This is node[+link{Tree.nameProperty}].  If that value has not
// been set on the node, a unique value (within this parent) will be auto-generated and
// returned.
//
// @param    node    (TreeNode)    node in question
// @return            (string)    name of the node
//
// @visibility external
//<
_autoName : 0,
getName : function (node) {
    var ns = isc._emptyString;

    if (!node) return ns;

    var name = node[this.nameProperty];
    if (name == null) name = node[this.idField];
    if (name == null) {
        // unnamed node: give it a unique name.


        // never assign an autoName to a node not from our tree
        if (!this.isDescendantOf(node, this.root) && node != this.root) return null;

        // assign unique autoNames per tree so we don't get cross-tree name collisions on D&D
        if (!this._autoNameBase) this._autoNameBase = isc.Tree.autoID++ + "_";
        name = this._autoNameBase+this._autoName++;
        // set a flag noting that we auto-assigned this name.
        // This is useful in databinding for us to determine whether path-based state
        // information can be reliably mapped to new data, for example on cache
        // invalidation.
        node._autoAssignedName = true;
    }

    // convert to string because we call string methods on this value elsewhere
    if (!isc.isA.String(name)) name = ns+name;

    // cache
    node[this.nameProperty] = name;
    return name;
},

//>    @method    tree.getTitle()
//
// Return the title of a node -- the name as it should be presented to the user.  This method
// works as follows:
// <ul>
// <li> If a +link{attr:Tree.titleProperty} is set on the node, the value of that property is
// returned.
// <li> Otherwise, if the +link{attr:Tree.nameProperty} is set on the node, that value is
// returned, minus any trailing +link{attr:Tree.pathDelim}.
// <li> Finally, if none of the above yielded a title, the value of
// +link{attr:Tree.defaultNodeTitle} is returned.
// </ul>
// You can override this method to return the title of your choice for a given node.
// <br><br>
// To override the title for an auto-constructed tree (for example, in a databound TreeGrid),
// override +link{method:TreeGrid.getNodeTitle} instead.
//
// @param node  (TreeNode) node for which the title is being requested
// @return      (string) title to display
//
// @see method:TreeGrid.getNodeTitle
//
// @visibility external
//<
getTitle : function (node) {
    if (!node) return null;
    // if the node has an explicit title, return that
    if (node[this.titleProperty] != null) return node[this.titleProperty];

    // otherwise derive from the name
    var name = node[this.nameProperty];
    if (name == null) name = this.defaultNodeTitle;
    return (isc.endsWith(name, this.pathDelim)
                ? name.substring(0,name.length-this.pathDelim.length)
                : name);
},

//>    @method    tree.getPath()
//
// Returns the path of a node - a path has the following format:
// <code>([name][pathDelim]?)*</code>
// <br><br>
// For example, in this tree:
// <pre>
// root
//   foo
//     bar
// </pre>
// Assuming that +link{attr:Tree.pathDelim} is the default <code>/</code>, the <code>bar</code>
// node would have the path <code>root/foo/bar</code> and the path for the <code>foo</code>
// node would be <code>root/foo</code>.
// <br><br>
// Once you have a path to a node, you can call find(path) to retrieve a reference to the node
// later.
//
// @param    node    (TreeNode)    node in question
// @return            (string)    path to the node
//
// @see method:Tree.getParentPath
// @visibility external
//<
getPath : function (node) {
    var parent = this.getParent(node);
    if (parent == null) return this.getName(node);

    var parentName = this.getName(parent);
    return this.getPath(parent) +
            (parentName == this.pathDelim ? isc.emptyString : this.pathDelim) +
                this.getName(node);
},

//>    @method    tree.getParentPath()
//
// Given a node, return the path to its parent.  This works just like
// +link{method:Tree.getPath} except the node itself is not reported as part of the path.
//
// @param    node    (TreeNode)    node in question
// @return            (string) path to the node's parent
//
// @see method:Tree.getPath
// @visibility external
//<
getParentPath : function (node) {
    // get the node's path
    var name = this.getName(node),
        path = this.getPath(node);

    // return the path minus the name of the node
    return path.substring(0, path.length - name.length - this.pathDelim.length);
},

//>    @method    tree.getParent()
//
// Returns the parent of this node.
//
// @param   node    (TreeNode)    node in question
// @return  (node)              parent of this node
//
// @visibility external
//<
getParent : function (node) {
    if (node == null) return null;
    return node[this.parentProperty];
},

//>    @method    tree.getParents()
//
// Given a node, return an array of the node's parents with the immediate parent first.  The
// node itself is not included in the result.  For example, for the following tree:
// <pre>
// root
//   foo
//     bar
// </pre>
// Calling <code>tree.getParents(bar)</code> would return: <code>[foo, root]</code>.  Note that
// the returned array will contain references to the nodes, not the names.
//
// @param   node    (TreeNode)            node in question
// @return          (Array)             array of node's parents
//
// @visibility external
//<
getParents : function (node) {
    var list = [],
        parent = this.getParent(node);
    // while parents exist
    while (parent) {
        // add them to the list
        list.add(parent);

        // if the parent is the root, jump out!
        //    this lets us handle subTrees of other trees
        if (parent == this.root) break;

        // and get the next parent in the chain
        parent = this.getParent(parent);
    }
    // return the list of parents
    return list;
},

//>    @method    tree.getLevel()    (A)
//
// Return the number of levels deep this node is in the tree.  For example, for this tree:
// <pre>
// root
//   foo
//     bar
// </pre>
// Calling <code>tree.getLevel(bar)</code> will return <code>2</code>.
// <P>
// Note +link{showRoot} defaults to false so that multiple nodes can be shown at top level.  In
// this case, the top-level nodes still have root as a parent, so have level 1, even though
// they have no visible parents.
//
// @param   node    (TreeNode)    node in question
// @return          (number)    number of parents the node has
//
// @visibility external
//<
getLevel : function (node) {
    return this.getParents(node).length;
},

// Given a node, iterate up the parent chain and return an array containing each level for
// which the node or its ancestor has a following sibling
// Required for treeGrid connectors
// We could improve performance here by cacheing this information on each node and having this
// method be called recursively on parents rather than iterating through the parents' array
// for every node this method is called on.
_getFollowingSiblingLevels : function (node) {
    var levels = [],
        parents = this.getParents(node),
        level = parents.length;
    // note that parents come back ordered with the root last so iterate through them forwards
    // to iterate up the tree
    for (var i = 0; i < level; i++) {
        var children = this.getChildren(parents[i]),
            childrenLength = (
                isc.isA.ResultSet(children) ?
                    children._getCachedLength() : children.getLength());
        if (children.indexOf(node) != childrenLength - 1) {
            levels.add(level - i);
        }
        node = parents[i];
    }
    return levels;
},

//>    @method    tree.isFolder()
//
// Determines whether a particular node is a folder.  The logic works as follows:<br><br>
// <ul>
// <li> If the +link{TreeNode} has a value for the +link{attr:Tree.isFolderProperty}
// (+link{TreeNode.isFolder} by default) that value is returned.
// <li> Next, the existence of the +link{attr:Tree.childrenProperty} (by default
// +link{TreeNode.children}) is checked on the +link{TreeNode}.  If the node has the children
// property defined (regardless of whether it actually has any children), then isFolder()
// returns true for that node.
// </ul>
// <smartclient>
// <P>
// You can override this method to provide your own interpretation of what constitutes a folder.
// However, you cannot change the return value for a node after the associated folder is loaded.
// </smartclient>
//
// @param    node    (TreeNode)    node in question
// @return            (Boolean)    true if the node is a folder
//
// @visibility external
//<
isFolder : function (node) {
    if (node == null) return false;

    // explicit isFolder set
    var isFolder = node[this.isFolderProperty];
    if (isFolder != null) return isFolder;

    // has a children array (may have zero actual children currently, but having a children
    // array is sufficient for us to regard this as a folder).  Note that we scribble the
    // children array on the nodes even in modelTypes other than "children", so this check
    // is correct for other modelTypes as well.
    if (node[this.childrenProperty]) return true;

    // infer folderness from the name of the node
    // XXX 10/13/2005 : this is purposefully not documented.  We have it here for backcompat
    // with trees that may have relied on this, but disclosing this will confuse people -
    // they'll start to think about having to tack on the path delimiter on their nodes to
    // signify folderness, which in turn translates into confusion about when you should or
    // should not supply the slash or give back a trailing slash from e.g. getPath()
    var name = this.getName(node);

    // if there's no name, we have no way of knowing
       if (name == null) return false;

    // if the last character is the pathDelim, it's a folder.
    return isc.endsWith(name, this.pathDelim);
},

//>    @method    tree.isLeaf()
//
// Returns true if the passed in node is a leaf.
//
// @param   node    (TreeNode)    node in question
// @return          (Boolean)   true if the node is a leaf
//
// @visibility external
// @see isFolder()
//<
isLeaf : function (node) {
    return ! this.isFolder(node);
},

//> @method tree.isFirst() (A)
// Note: because this needs to take the sort order into account, it can be EXTREMELY expensive!
// @group ancestry
// Return true if this item is the first one in its parent's list.
//
// @param  node (TreeNode)  node in question
// @return (boolean)  true == node is the first child of its parent
//<
isFirst : function (node) {
    var parent = this.getParent(node);
    if (! parent) return true;

    var kids = this.getChildren(parent, this.opendisplayNodeType,
            this._openNormalizer, this.sortDirection, null, this._sortContext);
    if (isc.isA.ResultSet(kids)) {
        return (kids._getCachedLength() > 0 && kids.getCachedRow(0) == node);
    } else {
        return (kids.first() == node);
    }
},

//>    @method    tree.isLast()    (A)
//         Note: because this needs to take the sort order into account, it can be EXTREMELY expensive!
//        @group    ancestry
//            Return true if this item is the last one in its parent's list.
//
//        @param    node    (TreeNode)    node in question
//        @return            (boolean)    true == node is the last child of its parent
//<
isLast : function (node) {
    var parent = this.getParent(node);
    if (! parent) return true;

    var kids = this.getChildren(parent, this.opendisplayNodeType,
            this._openNormalizer, this.sortDirection, null, this._sortContext);
    if (isc.isA.ResultSet(kids)) {
        var length = kids._getCachedLength();
        return (length > 0 && kids.getCachedRow(length - 1) == node);
    } else {
        return (kids.last() == node);
    }
},


//
//    finding a node
//

//>    @method    tree.findById()    (A)
//
// Find the node with the specified ID.  Specifically, it returns the node whose idField
// matches the id passed to this method. If the tree is using the "parent" modelType, this
// lookup will be constant-time.  For all other modelTypes, the tree will be searched
// recursively.
//
// @group   location
// @param   id (string)    ID of the node to return.
// @return  (object)       node with appropriate ID, or null if not found.
//
// @see attr:Tree.idField
// @see method:Tree.find
//
// @visibility external
//<
findById : function (id) {
    return this.find(this.idField, id);
},


//>    @method    tree.find()
//
// Find nodes within this tree using a string path or by attribute value(s).
//
// This method can be called with 1 or 2 arguments.
//
// If a single String argument is supplied, the value of the argument is treated as the path to the node.  If a
// single argument of type Object is provided, it is treated as a set of field name/value
// pairs to search for (see +link{List.find}).
// <br>
// If 2 arguments are supplied, this method will treat the first argument as a fieldName, and
// return the first node encountered where <code>node[fieldName]</code> matches the second
// argument.  So for example, given this tree:
// <pre>
// foo
//   zoo
//     bar
//   moo
//     bar
// </pre>
// Assuming your +link{attr:Tree.pathDelim} is the default <code>/</code> and <code>foo</code>
// is the name of the root node, then
// <code>tree.find("foo/moo/bar")</code> would return the <code>bar</code> node under the
// <code>moo</code> node.
// <br>
// <br>
// <code>tree.find("name", "bar")</code> would return the first <code>bar</code> node because
// it is the first one in the list whose <code>name</code> (default value of
// +link{attr:Tree.nameProperty}) property matches the value
// <code>bar</code>.  The two argument usage is generally more interesting when your tree nodes
// have some custom unique property that you wish to search on.  For example if your tree nodes
// had a unique field called "UID", their serialized form would look something like this:
// <pre>
// { name: "foo", children: [...], UID:"someUniqueId"}
// </pre>
// You could then call <code>tree.find("UID", "someUniqueId")</code> to find that node.  Note
// that the value doesn't have to be a string - it can be any valid value, but since this
// data generally comes from the server, the typical types are string, number, and boolean.
// Also note that a find() on the +link{idField} will be constant time, and that find() will
// not work on the idField if idField is set to a property that is not unique or not present
// on all nodes in the Tree.
// <br><br>
// The usage where you pass a single object is interesting when your tree nodes have a number
// of custom properties that you want to search for in combination.  Say your tree nodes had
// properties for "color" and "shape"; <code>tree.find({color: "green", shape: "circle"})</code>
// would return the first node in the tree where both properties matched.
// <br><br>
// When searching by path, trailing path delimiters are ignored.  So for example
// <code>tree.find("foo/zoo/bar")</code> is equivalent to
// <code>tree.find("foo/zoo/bar/")</code>
//
// @group location
// @param fieldNameOrPath   (string)    Either the path to the node to be found, or the name of
//                                      a field which should match the value passed as a second
//                                      parameter
// @param [value]          (any)     If specified, this is the desired value for the
//                                   appropriate field
// @return (object) the node matching the supplied criteria or null if not found
//
// @see attr:Tree.root
// @see attr:Tree.pathDelim
// @see attr:Tree.nameProperty
//
// @visibility external
//<
// NOTE: This should be a good generic implemention, try overriding findChildNum instead.
find : function (fieldName, value) {
    var undef;
    if (value === undef && isc.isA.String(fieldName)) return this._findByPath(fieldName);

    if (value !== undef) {
        // constant time lookup when we have nodeIndex
        if (fieldName == this.idField) return this.nodeIndex[value];
        // special-case root, which may not appear in getDescendants() depending on this.showRoot
        if (this.root[fieldName] == value) return this.root;
        // Use 'getDescendants()' to retrieve both open and closed nodes.
        return this.getDescendants(undef, undef, undef, true).find(fieldName, value);
    } else {
        // fieldName is an Object, so use the multi-property option of List.find()
        var searchList = this.getDescendants(undef, undef, undef, true);
        searchList.add(this.root);
        return searchList.find(fieldName);
    }
},

findAll : function (fieldName, value) {
    // Use 'getDescendants()' to retrieve both open and closed nodes.
    var undef;
    return this.getDescendants(undef, undef, undef, true).findAll(fieldName, value);
},

// Find a node within this tree by path.
_findByPath : function (path) {



    // return early for cases of referring to just root
    if (path == this.pathDelim) return this.root;
    var rootPath = this.getPath(this.root);
    if (path == rootPath) return this.root;

    var node = this.root,
        lastDelimPosition = 0,
        delimLength = this.pathDelim.length;

    // if the path starts with a references to root, start beyond it
    if (isc.startsWith(path, rootPath)) {
        lastDelimPosition = rootPath.length;
    } else if (isc.startsWith(path, this.pathDelim)) {
        lastDelimPosition += delimLength;
    }

    //this.logWarn("path: " + path);

    while (true) {
        var delimPosition = path.indexOf(this.pathDelim, lastDelimPosition);

        //this.logWarn("delimPosition: " + delimPosition);

        // skip over two delims in a row (eg "//") and trailing (single) delimeter
        if (delimPosition == lastDelimPosition) {
            //this.logWarn("extra delimeter at: " + delimPosition);
            lastDelimPosition += delimLength;
            continue;
        }

        var moreDelims = (delimPosition != -1),
            // name of the child to look for at this level
            name = path.substring(lastDelimPosition, moreDelims ? delimPosition : path.length),
            // find the node number of that child
            nodeNum = this.findChildNum(node, name);

        //this.logWarn("name: " + name);

        if (nodeNum == -1) return null;

        node = node[this.childrenProperty].getCachedRow(nodeNum);

        // if there are no more delimeters we're done
        if (!moreDelims) return node;

        // advance the lastDelimiter
        lastDelimPosition = delimPosition + delimLength;

        // if we got all the way to the end of the path, we're done:  return the node
        if (lastDelimPosition == path.length) return node;
    }
},

//>    @method    tree.findChildNum()    (A)
//        @group    location
//            Given a parent and the name of a child, return the number of that child.
//
//         Note: names of folder nodes will have pathDelim stuck to the end
//
//        @param    parent    (TreeNode)    parent node
//        @param    name    (string)    name of the child node to find
//        @return            (number)    index number of the child, -1 if not found
//<
findChildNum : function (parent, name) {
    var children = this.getChildren(parent);

    if (children == null) {
        return -1;
    }
    if (name == null) return -1;

    var length = (
            isc.isA.ResultSet(children) ? children._getCachedLength() : children.getLength()),
        nameHasDelim = isc.endsWith(name, this.pathDelim),
        delimLength = this.pathDelim.length;
    for (var i = 0; i < length; i++) {

        var child = children.getCachedRow(i);
        if (child != null) {
            var childName = this.getName(child),
                lengthDiff = childName.length - name.length;

            if (lengthDiff == 0 && childName == name) return i;

            if (lengthDiff == delimLength) {
                // match if childName has trailing delim and name does not
                if (isc.startsWith(childName, name) &&
                    isc.endsWith(childName, this.pathDelim) && !nameHasDelim)
                {
                    return i;
                }
            } else if (nameHasDelim && lengthDiff == -delimLength) {
                // match if name has trailing delim and childName does not
                if (isc.startsWith(name, childName)) return i;
            }
        }
    }

    // not found, return -1
    return -1;
},


//> @method     tree.findIndex()
// Like +link{list.findIndex()}, but operates only on the list of currently opened nodes.  To search all loaded nodes
// open or closed, use +link{findNodeIndex()}.
//
// @param propertyName (String or Object or AdvancedCriteria) property to match, or if an Object is passed, set of
//                                        properties and values to match
// @param [value] (any) value to compare against (if propertyName is a string)
// @return (int) index of the first matching Object or -1 if not found
//
// @group access, find
// @visibility external
//<

//> @method tree.findNodeIndex()
// Like +link{findIndex()}, but searches all tree nodes regardless of their open/closed state.
//
// @param propertyName (String or Object or AdvancedCriteria) property to match, or if an Object is passed, set of
//                                        properties and values to match
// @param [value] (any) value to compare against (if propertyName is a string)
// @return (int) index of the first matching Object or -1 if not found
//
// @group access, find
// @visibility external
//<
findNodeIndex : function (propertyName, value) {
    return this.getNodeList().findIndex(propertyName, value);
},

//> @method     tree.findNextIndex()
// Like +link{findIndex()}, but inspects a range from <code>startIndex</code> to <code>endIndex</code>.  Note
// that as in +link{findIndex()}, only open nodes are included.  To include both open and closed nodes, use
// +link{findNextNodeIndex()}.
// <smartclient>
// <p>
// For convenience, findNextIndex() may also be called with a function (called the predicate
// function) for the <code>propertyName</code> parameter. In this usage pattern, the predicate
// function is invoked for each value of the list until the predicate returns a true value.
// The predicate function is passed three parameters: the current value, the current index, and
// the list. The value of <code>this</code> when the predicate function is called is the
// <code>value</code> parameter. For example:
// <pre>var currentUserRecord = recordList.findNextIndex(0, function (record, i, recordList) {
//    if (record.username == currentUsername && !record.accountDisabled) {
//        return true;
//    }
//});</pre>
// </smartclient>
//
// @param startIndex (int) first index to consider.
// @param propertyName (String or Function or Object or AdvancedCriteria) property to match;
// <smartclient>or, if a function is passed, the predicate function to call;</smartclient>
// or, if an object is passed, set of properties and values to match.
// @param [value] (any) value to compare against (if <code>propertyName</code> is a string)
// <smartclient>or the value of <code>this</code> when the predicate function is invoked (if
// <code>propertyName</code> is a function)</smartclient>
// @param [endIndex] (int) last index to consider (inclusive).
// @return (int) index of the first matching value or -1 if not found.
// @group access, find
// @visibility external
//<

//> @method tree.findNextNodeIndex()
// Like +link{findNextIndex()}, but includes both open and closed nodes.
// @param startIndex (int) first index to consider.
// @param propertyName (String or Function or Object or AdvancedCriteria) property to match;
// <smartclient>or, if a function is passed, the predicate function to call;</smartclient>
// or, if an object is passed, set of properties and values to match.
// @param [value] (any) value to compare against (if <code>propertyName</code> is a string)
// <smartclient>or the value of <code>this</code> when the predicate function is invoked (if
// <code>propertyName</code> is a function)</smartclient>
// @param [endIndex] (int) last index to consider (inclusive).
// @return (int) index of the first matching value or -1 if not found.
// @group access, find
// @visibility external
//<
findNextNodeIndex : function (startIndex, propertyName, value, endIndex) {
    return this.getNodeList().findNextIndex(startIndex, propertyName, value, endIndex);
},

//>    @method    tree.getChildren()
//
// Returns all children of a node.  If the node is a leaf, this method returns null.
// <P>
// For databound trees the return value could be a +link{class:ResultSet} rather than a simple
// array - so it's important to access the return value using the +link{interface:List}
// interface instead of as a native Javascript Array.
// <smartclient>
// The case that a ResultSet may be returned can only happen if the tree is a
// +link{class:ResultTree} and the +link{resultTree.fetchMode} is set to "paged".
// </smartclient>
// <smartgwt>
// If the underlying set of children is incomplete then this method will return only those
// nodes that have already been loaded from the server.
// </smartgwt>
//
// @param node (TreeNode) The node whose children you want to fetch.
// @return (List of TreeNode) List of children for the node, including an empty List if the
//                            node has no children.  For a leaf, returns null.
// @see tree.getChildrenResultSet()
// @visibility external
//<

getChildren : function (parentNode, displayNodeType, normalizer, sortDirection, criteria,
                        context, returnNulls, treatEmptyFoldersAsLeaves, dontUseNormalizer) {


    // If separateFolders is true, we need to have an openNormalizer so we can sort/separate
    // leaves and folders
    // This will not actually mark the tree as sorted by any property since we're not setting up
    // a sortProp.

    if (!dontUseNormalizer &&
        normalizer == null && this._openNormalizer == null && this.separateFolders)
    {

        if (this._sortSpecifiers != null) this.setSort(this._sortSpecifiers);
        else this.sortByProperty();

        if (!this._openNormalizer) this._makeOpenNormalizer();
        normalizer = this._openNormalizer;
    }

    if (parentNode == null) parentNode = this.root;

    // if we're passed a leaf, it has no children, return empty array
    if (this.isLeaf(parentNode)) return null;

    // if the parentNode doesn't have a child array, create one
    if (parentNode[this.childrenProperty] == null) {
        if (returnNulls) return null;
        var children = [];
        parentNode[this.childrenProperty] = children;
        // just return the new empty children array
        return children;
    }

    var pagedResultTree = isc.ResultTree && isc.isA.ResultTree(this) && this.isPaged(),
        list = parentNode[this.childrenProperty],
        subset;

    // If a criteria was passed in, remove all items that don't pass the criteria.
    if (criteria) {
        subset = [];

        var listLength = (pagedResultTree && isc.isA.ResultSet(list) ?
                list._getCachedLength() : list.getLength());
        for (var i = 0; i < listLength; ++i) {
            var childNode = list.getCachedRow(i);
            if (childNode != null) {
                // CALLBACK API:  available variables:  "node,parent,tree"
                if (this.fireCallback(
                        criteria, "node,parent,tree", [childNode, parentNode, this]))
                {
                    subset[subset.length] = childNode;
                }
            }
        }

        list = subset;
    }

    // Reduce the list if a displayNodeType was specified.
    if (displayNodeType == isc.Tree.FOLDERS_ONLY) {
        // If only folders were specified, get the subset that are folders.
        subset = [];
        var listLength = (pagedResultTree && isc.isA.ResultSet(list) ?
                list._getCachedLength() : list.getLength());
        for (var i = 0; i < listLength; ++i) {
            var childNode = list.getCachedRow(i);
            if (childNode != null) {
                var isFolder = this.isFolder(childNode);
                if (isFolder && treatEmptyFoldersAsLeaves) {
                    var c = childNode[this.childrenProperty];
                    isFolder = !(c != null && c.isEmpty());
                }
                if (isFolder) {
                    subset[subset.length] = childNode;
                }
            }
        }
    } else if (displayNodeType == isc.Tree.LEAVES_ONLY) {
        // If only leaves were specified, get the subset that are leaves.
        subset = [];
        var listLength = (pagedResultTree && isc.isA.ResultSet(list) ?
                list._getCachedLength() : list.getLength());
        for (var i = 0; i < listLength; ++i) {
            var childNode = list.getCachedRow(i);
            if (childNode != null) {
                var isLeaf = this.isLeaf(childNode);
                if (!isLeaf && treatEmptyFoldersAsLeaves) {
                    var c = childNode[this.childrenProperty];
                    isLeaf = (c != null && c.isEmpty());
                }
                if (isLeaf) {
                    subset[subset.length] = childNode;
                }
            }
        }
    } else {
        // Otherwise return the entire list (folders and leaves).
        subset = list;
    }


    if (this.isSubsetSortDirty(subset) && (normalizer ||
         (!pagedResultTree || !isc.isA.ResultSet(subset)) && dontUseNormalizer == false))
    {


        var sortProps = this._sortSpecifiers ? this._sortSpecifiers.getProperty("property") : [];


        var isOpenNormalizer = normalizer === this._openNormalizer;
        if (this._sortSpecifiers && normalizer && (!isOpenNormalizer || !pagedResultTree)) {


            var  ascendingComparator = null,
                descendingComparator = null;
            if (isc.Browser.isFirefox && isOpenNormalizer) {
                 ascendingComparator = this._openAscendingComparator;
                descendingComparator = this._openDescendingComparator;
            }

            // Update the normalizer on each sort-spec if one isn't present.
            for (var spec = this._sortSpecifiers.length; spec--; ) {
                var specObj = this._sortSpecifiers[spec];
                if (!specObj.normalizer) {
                    specObj.normalizer = normalizer;
                    specObj._comparator = (
                        Array.shouldSortAscending(specObj.direction) ?
                            ascendingComparator : descendingComparator);
                }
            }
        }

        // we now support sorting on all of the groupByFields
        var groupByField = !this._groupByField ? null :
              (isc.isAn.Array(this._groupByField) ? this._groupByField : [this._groupByField]);

        if (// we're not in a grouped LG OR
                !groupByField ||
                // the special 'alwaysSortGroupHeaders' flag is set (indicating group headers have
                // multiple meaningful field values, as when we show summaries in headers) OR
                this.alwaysSortGroupHeaders
                ||
                //// we're not grouping on the first sortField and this isn't a group-node OR
                (!groupByField.contains(sortProps[0]) && parentNode != this.getRoot()) ||
                //// we're sorting the group-nodes and the sort-field IS the first groupByField
                (groupByField.contains(sortProps[0]))
        ) {
            if (this._sortSpecifiers) {

                if (pagedResultTree && isc.isA.ResultSet(subset)) {
                    subset = subset.getAllVisibleRows() || [];
                }

                if (parentNode.groupMembers) {
                    // The parentNode is a group-node in a grid.  Process it if it's also
                    // being sorted.
                    var process = (this._sortSpecifiers.find("property",
                            parentNode.groupName) != null);

                    var isRoot = parentNode == this.getRoot();
                    // if it's the rootNode, process it anyway (there'll be no groupName)
                    process = process || isRoot;

                    if (process) {
                        subset.map(function (record) {
                            if (record._isGroup) {
                                // if the record is a group, add values to it for the fields
                                // being sorted, such that we sort them properly according to
                                // the sort specifiers
                                if (parentNode.groupValue && !record[parentNode.groupName] && isRoot) {
                                    record[parentNode.groupName] = parentNode.groupValue;
                                }
                                if (!record[record.groupName]) {
                                    record[record.groupName] = record.groupValue;
                                }
                            }
                        });
                    }
                }

                // remove any summary-rows from the subset before sorting, and then add them
                // back afterwards, so they're always at the end of the subset
                var summaryRows = subset.findAll(this._summaryRecordFlag, true) || [];
                if (summaryRows.length > 0) subset.removeList(summaryRows);
                subset.setSort(this._sortSpecifiers);
                this.markSubsetAsSorted(subset);

                // Summary rows may be implemented as children or siblings of the
                // header nodes (depending on whether we want them to show up
                // when the group is collapsed).
                if (summaryRows.length > 0) {
                    var addAsChildren = [];
                    for (var i = 0; i < summaryRows.length; ) {
                        if (summaryRows[i] == null) break;
                        var groupSummaries = [],
                            currentSummaryRow = summaryRows[i],
                            // summaryTargetNode flag set up in ListGrid grouping
                            // logic
                            target = currentSummaryRow[this._summaryTargetNode];
                        if (target == null) {
                            addAsChildren.add(currentSummaryRow);
                            i++;
                            continue;
                        } else {

                            do {
                                groupSummaries.add(currentSummaryRow);
                                currentSummaryRow = summaryRows[i+1];
                                i++;
                            } while (currentSummaryRow &&
                                     currentSummaryRow[this._summaryTargetNode] == target);
                            // Slot in the summaries as siblings after the
                            // summary header node.
                            subset.addListAt(groupSummaries, subset.indexOf(target)+1);
                        }
                    }
                    if (addAsChildren.length > 0) {
                        subset.addListAt(addAsChildren, subset.length);
                    }
                }
            }
        }
    }


    return subset;
},

//> @method tree.getChildrenResultSet()
// Returns a ResultSet that provides access to any partially-loaded children of a node.  If the
// node is a leaf, this method returns null.
// @param node (TreeNode) The node whose children you want to fetch.
// @return (ResultSet) List of children for the node, including an empty ResultSet if the node
// has no children.  For a leaf, returns null.
// @see tree.getChildren()
// @see tree.allChildrenLoaded()
// @visibility external
//<
getChildrenResultSet : function (node) {
    var children = this.getChildren(node);
    return (isc.isA.ResultSet(children) ? children : null);
},

//>    @method    tree.getFolders()
//
// Returns all the first-level folders of a node.
// <br><br>
// For load on demand trees (those that only have a partial representation client-side), this
// method will return only nodes that have already been loaded from the server.
//
// @param   node    (TreeNode)    node in question
// @return  (List)              List of immediate children that are folders
//
// @visibility external
//<

getFolders : function (node, normalizer, sortDirection, criteria, context) {
    var folders = this.getChildren(node, isc.Tree.FOLDERS_ONLY, normalizer, sortDirection,
                                   criteria, context);

    return folders;
},

//>    @method    tree.getLeaves()
//
// Return all the first-level leaves of a node.
// <br><br>
// For load on demand trees (those that only have a partial representation client-side), this
// method will return only nodes that have already been loaded from the server.
//
// @param   node    (TreeNode)    node in question
// @return          (List)      List of immediate children that are leaves.
//
// @visibility external
//<

getLeaves : function (node, normalizer, sortDirection, criteria, context) {
    var leaves = this.getChildren(node, isc.Tree.LEAVES_ONLY, normalizer, sortDirection,
                                  criteria, context);

    return leaves;
},

//> @method Tree.getLevelNodes()
// Get all nodes of a certain depth within the tree, optionally starting from
// a specific node.  Level 0 means the immediate children of the passed node,
// so if no node is passed, level 0 is the children of root
// @param depth (integer) level of the tree
// @param [node] (TreeNode) option node to start from
// @return (Array of TreeNode)
//<
getLevelNodes : function (depth, node) {

    if (this.indexByLevel && (node == null || node == this.getRoot())) {
        return this._levelNodes[depth] || [];
    } else {
        if (!node) node = this.getRoot();
        var children = this.getChildren(node);

        if (depth == 0) {

            if (isc.isA.ResultSet(children)) {
                return children.getAllLoadedRows();
            } else {
                return children;
            }
        }
        var result = [];
        if (children) {
            var length = (isc.isA.ResultSet(children) ?
                    children._getCachedLength() : children.getLength());
            for (var i = 0; i < length; ++i) {
                var child = children.getCachedRow(i),
                    nestedChildren = (
                        child != null && this.getLevelNodes(depth - 1, child));
                if (nestedChildren) result.addList(nestedChildren);
            }
        }
        return result;
    }
},

getDepth : function () {
    if (this._levelNodes) return this._levelNodes.length;
    return null;
},

//>    @method    tree.hasChildren()
//
// Returns true if this node has any children.
//
// @param    node            (TreeNode)            node in question
// @return                    (Boolean)            true if the node has children
//
// @visibility external
//<

hasChildren : function (node, displayNodeType) {
    var children = this.getChildren(node, displayNodeType);
    return (children != null && !children.isEmpty());
},

//>    @method    tree.hasFolders()
//
// Return true if this this node has any children that are folders.
//
// @param    node    (TreeNode)    node in question
// @return         (Boolean)   true if the node has children that are folders
//
// @visibility external
//<
hasFolders : function (node) {
    return this.hasChildren(node, isc.Tree.FOLDERS_ONLY);
},

//>    @method    tree.hasLeaves()
//
//  Return whether this node has any children that are leaves.
//
//    @param    node    (TreeNode)    node in question
//    @return            (Boolean)   true if the node has children that are leaves
//
// @visibility external
//<
hasLeaves : function (node) {
    return this.hasChildren(node, isc.Tree.LEAVES_ONLY);
},


//>    @method    tree.isDescendantOf()
//            Is one node a descendant of the other?
//
//        @param    child    (TreeNode)    child node
//        @param    parent    (TreeNode)    parent node
//        @return            (Boolean)    true == parent is an ancestor of child
// @visibility external
//<
isDescendantOf : function (child, parent) {
    if (child == parent) return false;
    var nextParent = child;
    while (nextParent != null) {
        if (nextParent == parent) return true;
        nextParent = nextParent[this.parentProperty];
    }
    return false;
},

//>    @method    tree.getDescendants()
//
// Returns the list of all descendants of a node.  Note: this method can be very slow,
// especially on large trees because it assembles a list of all descendants recursively.
// Generally, +link{method:Tree.find} in combination with +link{method:Tree.getChildren} will
// be much faster.
// <br><br>
// For load on demand trees (those that only have a partial representation client-side), this
// method will return only nodes that have already been loaded from the server.
//
// @param   [node]  (TreeNode)    node in question (the root node is assumed if none is specified)
// @return  (List)              List of descendants of the node.
//
// @visibility external
//<

getDescendants : function (node, displayNodeType, condition, dontSkipUnloadedFolders) {
    if (!node) node = this.root;

    // create an array to hold the descendants
    var list = [];

    // if condition wasn't passed in, set it to an always true condition
    // XXX convert this to a function if a string, similar to getChildren()
    if (!condition) condition = isc.Class.RET_TRUE;

    // if the node is a leaf, return the empty list
    if (this.isLeaf(node)) return list;

    // skip unloaded folders
    if (!dontSkipUnloadedFolders && this.getLoadState(node) != isc.Tree.LOADED) {
        return list;
    }
    // iterate through all the children of the node
    // Note that this can't depend on getChildren() to subset the nodes,
    //    because a folder may have children that meet the criteria but not meet the criteria itself.

    var children = this.getChildren(node);
    if (!children) {
        return list;
    }



    // for each child
    var length = (isc.isA.ResultSet(children) ?
            children._getCachedLength() : children.getLength());
    for (var i = 0; i < length; ++i) {
        // get a pointer to the child
        var child = children.getCachedRow(i);

        if (child == null) {
            // Do nothing.
        } else if (this.isFolder(child)) { // if that child is a folder
            // if we're not exluding folders, add the child
            if (displayNodeType != isc.Tree.LEAVES_ONLY && condition(child)) {
                list[list.length] = child;
            }

            // now concatenate the list with the descendants of the child
            list = list.concat(
                this.getDescendants(
                    child, displayNodeType, condition, dontSkipUnloadedFolders));

        } else {
            // if we're not excluding leaves, add the leaf to the list
            if (displayNodeType != isc.Tree.FOLDERS_ONLY && condition(child)) {
                list[list.length] = child;
            }
        }
    }
    // finally, return the entire list
    return list;
},

//>    @method    tree.getDescendantFolders()
//
// Returns the list of all descendants of a node that are folders.  This works just like
// +link{method:Tree.getDescendants}, except leaf nodes are not part of the returned list.
// Like +link{method:Tree.getDescendants}, this method can be very slow for large trees.
// Generally, +link{method:Tree.find} in combination with +link{method:Tree.getFolders}
// will be much faster.
// <br><br>
// For load on demand trees (those that only have a partial representation client-side), this
// method will return only nodes that have already been loaded from the server.
//
// @param   [node]      (TreeNode)    node in question (the root node is assumed if none is specified)
// @return  (List)        List of descendants of the node that are folders.
//
// @visibility external
//<

getDescendantFolders : function (node, condition) {
     return this.getDescendants(node, isc.Tree.FOLDERS_ONLY, condition)
},
//>    @method    tree.getDescendantLeaves()
//
// Returns the list of all descendants of a node that are leaves.  This works just like
// +link{method:Tree.getDescendants}, except folders are not part of the returned list.
// Folders are still recursed into, just not returned.  Like +link{method:Tree.getDescendants},
// this method can be very slow for large trees.  Generally, +link{method:Tree.find} in
// combination with +link{method:Tree.getLeaves} will be much faster.
// <br><br>
// For load on demand trees (those that only have a partial representation client-side), this
// method will return only nodes that have already been loaded from the server.
//
// @param   [node]      (TreeNode)    node in question (the root node is assumed if none specified)
// @return  (List)        List of descendants of the node that are leaves.
//
// @visibility external
//<

getDescendantLeaves : function (node, condition) {
    return this.getDescendants(node, isc.Tree.LEAVES_ONLY, condition)
},


//>    @method    tree.dataChanged()    (A)
//
// Called when the structure of this tree is changed in any way.  Intended to be observed.
// <br><br>
// Note that on a big change (many items being added or deleted) this may be called multiple times
//
// @visibility external
//<
dataChanged : function () {},


//
// adding nodes
//

//> @groupDef sharingNodes
//
// For local Trees, that is, Trees that don't use load on demand, SmartClient supports setting
// up the Tree structure by setting properties such as "childrenProperty", directly on data
// nodes.  This allows for simpler, faster structures for many common tree uses, but can create
// confusion if nodes need to be shared across Trees.
// <P>
// <b>using one node in two places in one Tree</b>
// <P>
// To do this, either clone the shared node like so:<pre>
//
//     tree.add(isc.addProperties({}, sharedNode));
//
// </pre> or place the shared data in a shared subobject instead.
// <P>
// <b>sharing nodes or subtrees across Trees</b>
// <P>
// Individual nodes within differing tree structures can be shared by two Trees only if
// +link{Tree.nameProperty}, +link{Tree.childrenProperty}, and +link{Tree.openProperty} have
// different values in each Tree.
// <P>
// As a special case of this, two Trees can maintain different open state across a single
// read-only structure as long as just "openProperty" has a different value in each Tree.
//
// @title Sharing Nodes
// @visibility external
//<


//>    @method    tree.add()
//
// Add a single node under the specified parent.  See +link{ResultTree,"Modifying ResultTrees"}
// when working with a <code>ResultTree</code> for limitations.
//
// @param    node        (TreeNode)    node to add
// @param    parent        (String or TreeNode)    Parent of the node being added.  You can pass
//                                          in either the +link{TreeNode} itself, or a path to
//                                            the node (as a String), in which case a
//                                            +link{method:Tree.find} is performed to find
//                                            the node.
// @param    [position]    (number)    Position of the new node in the children list. If not
//                                    specified, the node will be added at the end of the list.
// @return (TreeNode or null) The added node. Will return null if the node was not added (typically
//    because the specified <code>parent</code> could not be found in the tree).
//
// @see group:sharingNodes
// @see method:Tree.addList
// @visibility external
//<
// Note: the node passed in is directly integrated into the tree, so you will see properties
// written onto it, etc. We may want to duplicate it before adding, then return a pointer
// to the node as added.
add : function (node, parent, position) {
    return this._add(node, parent, position);
},
_add : function (node, parent, position) {
    if (parent == null && this.modelType == isc.Tree.PARENT) {
        var parentId = node[this.parentIdField];
        if (parentId != null) parent = this.findById(parentId);
    }
    // normalize the parent parameter into a node
    if (isc.isA.String(parent)) {
        parent = this.find(parent);
    } else if (!this.getParent(parent) && parent !== this.getRoot()) {
        // if parent is not in the tree, bail
        isc.logWarn('Tree.add(): specified parent node:' + this.echo(parent) +
                    ' is not in the tree, returning');
        return null;
    }
    // if the parent wasn't found, return null
    // XXX note that we could actually add to the root, but that's probably not what you want
    if (! parent) {
        // get the parentName of the node
        var parentPath = this.getParentPath(node);
        if (parentPath) parent = this.find(parentPath);
        if (! parent) return null;
    }

    // we'll need to resort the children of this parent
    var children = parent[this.childrenProperty];
    if (children) this.markSubsetSortDirty(children);

    this.__add(node, parent, position);

    this._clearNodeCache(true);

    // call the dataChanged method
    this.dataChanged();

    return node;
},

_reportCollision : function (ID) {
    if (this.reportCollisions) {
        this.logWarn("Adding node to tree with id property set to:"+ ID +
            ". A node with this ID is already present in this Tree - that node will be " +
            "replaced. Note that this warning may be disabled by setting the " +
            "reportCollisions attribute to false.");
    }
},

// internal interface, used by _linkNodes(), _addList(), and any other place where we are adding a
// batch of new nodes to the Tree.  This implementation doesn't call _clearNodeCache() or
// dataChanged() and assumes you passed in the parent node as a node object, not a string.

__add : function (node, parent, position) {
    var pagedResultTree = (
            isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged());


    var info = {};
    parent[this._recursionCountProperty] = 1 + (parent[this._recursionCountProperty] || 0);
    this._preAdd(node, parent, true, info);
    var deltaParentLength = info.deltaParentLength,
        grandParent = info.grandParent,
        origParentLength = info.origParentLength,
        children = info.children;


    // If position wasn't specified, set it as the last item.
    // NOTE: Specifying position > children.length is technically wrong but happens easily
    // with a remove followed by an add.
    if (position == null || position > children.length) {
        children.add(node);
    } else {
        // add the node to the parent - addAt is slower, so only do this if your position was
        // passed in
        children.addAt(node, position);
    }

    this._postAdd(node, parent, position, info);
    var grandChildren = (pagedResultTree
            ? this._canonicalizeChildren(node, info.grandChildren, false) : info.grandChildren);

    if (pagedResultTree) {
        var fromParent = (parent[this.canReturnOpenSubfoldersProperty] != null),
            openSubfoldersAllowed = (fromParent ?
                parent[this.canReturnOpenSubfoldersProperty] : this.canReturnOpenFolders);

        if (!openSubfoldersAllowed &&
            this.isOpen(node) &&
            grandChildren != null && !grandChildren.isEmpty())
        {
            this.logWarn(
                "Adding the open folder node '" + this.getPath(node) + "' as a child of the " +
                "parent node '" + this.getPath(parent) + "' is contradictory to the setting " +
                "of the " + (fromParent ? "'" + this.canReturnOpenSubfoldersProperty + "' " +
                "property of the parent node." : "'canReturnOpenFolders' property of the tree."));
        }
    }

    var deltaLength = 0;
    if (pagedResultTree && isc.isA.ResultSet(grandChildren)) {
        if (!(grandChildren.lengthIsKnown() && grandChildren.allMatchingRowsCached())) {
            this._setVisibleDescendantsCached(node, false, parent, false);
        }
    } else if (grandChildren != null) {
        // If the node has children, recursively add them to the node.  This ensures that
        // their parent link is set up correctly.

        // Handle children being specified as a single element recursively.
        // _add will slot the element into the new children array.
        if (!isc.isAn.Array(grandChildren)) {
            this.__add(grandChildren, node);
        } else if (grandChildren.length > 0) {
            this.__addList(grandChildren, node);
        }

        // if a children array is present, mark the node as loaded even if the children array
        // is empty - this is a way of indicating an empty folder in XML or JSON results
        this.setLoadState(node, isc.Tree.LOADED);
    }


    if ((--parent[this._recursionCountProperty]) == 0) {
        delete parent[this._recursionCountProperty];

        if (grandParent) {
            // Check if changes in the length of the parent affect the length of the grandParent.
            deltaParentLength += (this._getNodeLengthToParent(parent, grandParent) - origParentLength);

            // Update the lengths of some of the ancestors.
            this._updateParentLengths(grandParent, deltaParentLength);
        }
    }
},

_removeCollision : function (collision) {

    var pagedResultTree = (
            isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged());
    if (pagedResultTree) {
        var parent = this.getParent(collision),
            siblings = (parent != null ? this.getChildren(parent) : null);

        if (isc.isA.ResultSet(siblings)) {
            var j = siblings.indexOf(collision);
            if (j != -1) {

                siblings.fillCacheData([null], j);
            }
            return;
        }
    }

    // Otherwise simply remove the collision node.
    this._remove(collision);
},

_findCollision : function (node) {

    var ID = node[this.idField];
    if (ID != null && this.modelType == isc.Tree.PARENT) {
        // note: in modelType:"children", while we do maintain a nodeIndex, an idField is not
        // required and the tree does not depend on globally unique ids
        var collision = this.findById(ID);
        if (collision) {
            return collision;
        }
    }
    return null;
},


_preAdd : function (node, parent, removeCollisions, info) {


    // convert name to a string - we rely on this fact in getTitle() and possibly other
    // places.  Also, ultimately getName() will convert it to a string anyway and at that
    // point, if new values are not strings from the start, sorting won't work as expected (the
    // non-strings will be segregated from the strings).
    this.getName(node);

    // convert the parent node to a folder if necessary
    var deltaParentLength = info.deltaParentLength = this.convertToFolder(parent);

    var grandParent = info.grandParent = (parent != this.root && this.getParent(parent)),
        origParentLength = info.origParentLength = (
            grandParent && this._getNodeLengthToParent(parent, grandParent));

    var collision = this._findCollision(node);
    if (collision) {
        var ID = collision[this.idField];
        this._reportCollision(ID);
        if (removeCollisions) {
            this._removeCollision(collision);
        }
    }

    var children = parent[this.childrenProperty];
    if (!children) children = parent[this.childrenProperty] = [];
    info.children = children;

    // if the children attr contains a single object, assume it to be a single child of
    // the node.

    var childrenResultSet = info.childrenResultSet = isc.isA.ResultSet(children);
    if (children != null && !isc.isAn.Array(children) && !childrenResultSet) {
        parent[this.childrenProperty] = children = [children];
    }

    // parentId-based loading can be used without the parentId
    // appearing in the child nodes, for example, if loading nodes from a large XML structure,
    // we may use the parentId to store the XPath to the parent, and load children via accessing
    // the parentElement.childNodes Array.
    //
    // set the parentId on the node if it isn't set already
    var idField = this.idField
    // just do this unconditionally - it doesn't make sense for the parentId field of the child
    // not to match the idField of the parent.
    node[this.parentIdField] = parent[idField];
    // link to the parent
    node[this.parentProperty] = parent;
},


_postAdd : function (node, parent, position, info) {
    var idField = this.idField;

    // Link to the Tree (by String ID, not direct pointer).
    node[this.treeProperty] = this.ID;

    // Update nodeIndex.
    // If we don't do a null check there are cases where null values get added into the
    // nodeIndex and children get added to the wrong parent, i.e. when using autoFetch and
    // modeltype 'children' within a treegrid.
    if (node[idField] != null) this.nodeIndex[node[idField]] = node;

    if (!info.childrenResultSet) {
        // Current assumption whenever loading subtrees is that if any
        // children are returned for a node, it's the complete set, and the node is marked "loaded".
        this.setLoadState(parent, isc.Tree.LOADED);
    }

    this._addToLevelCache(node, parent, position);

    // Set the cached length of the node.
    var nodeIsFolder = this.isFolder(node);
    node[this._cachedLengthProperty] = (
        this.openDisplayNodeType != (nodeIsFolder ? isc.Tree.LEAVES_ONLY : isc.Tree.FOLDERS_ONLY) ? 1 : 0);

    var grandChildren = info.grandChildren = node[this.childrenProperty],
        deltaLength;
    if (grandChildren != null) {
        node[this.childrenProperty] = [];
        deltaLength = this._getNodeLengthToParent(node, parent);
    } else {
        deltaLength = this._getNodeLengthToParent(node, parent);

        // canonicalize the isFolder flag on the node
        var wasFolder = this.isFolder(node),
            isFolder = node[this.isFolderProperty];

        // convert to boolean
        if (isFolder != null && !isc.isA.Boolean(isFolder)) {
            isFolder = isc.booleanValue(isFolder, true);
        }

        // ResultTree nodes that don't specify isFolder default to isFolder: true,
        // But Trees work exactly the opposite way
        if (isFolder == null && this.defaultIsFolder) isFolder = true;

        if (isFolder && !wasFolder) {
            deltaLength += this.convertToFolder(node);
        }
        node[this.isFolderProperty] = isFolder;
    }

    // Add deltaLength to the length of the parent.

    parent[this._cachedLengthProperty] += deltaLength;
},

_addToLevelCache : function (nodes, parent, position) {
    if (!this.indexByLevel) return;

    var level = this.getLevel(parent);
    if (!this._levelNodes[level]) this._levelNodes[level] = [];
    var levelNodes = this._levelNodes[level];

    // Special case - array is empty, just add the node to the end
    if (levelNodes.length == 0) {
        if (!isc.isAn.Array(nodes)) {
            levelNodes.push(nodes);
        } else {
            levelNodes.concat(nodes);
        }
    } else {
        // Make sure none of these nodes is already cached
        if (!isc.isAn.Array(nodes)) {
            if (levelNodes.contains(nodes)) return;
        } else {
            var cleanNodes = [];
            for (var j = 0; j < nodes.length; j++) {
                if (!levelNodes.contains(nodes[j])) {
                    cleanNodes.push(nodes[j]);
                }
            }
        }
        // Slot the node(s) into the level cache at the correct position
        var startedThisParent = false,
            siblingCount = 0,
            i = 0;
        for (i; i < levelNodes.length; i++) {
            if (this.getParent(levelNodes[i]) == parent) {
                startedThisParent = true;
            } else if (startedThisParent) {
                break;
            } else {
                continue;
            }
            // Exact equality is important - position 0 means first, position null means last
            if (siblingCount === position) {
                break;
            }
            siblingCount++;
        }

        if (!isc.isAn.Array(nodes)) {
            levelNodes.splice(i, 0, nodes);
        } else {
            // Using concat() because splice, push and unshift all insert the array itself,
            // not the array's contents, and a solution involving a Javascript loop would
            // presumably cause far more churn in the array than passing everything in a
            // single native call and letting the browser deal with it
            if (i == 0) {
                this._levelNodes[level] = cleanNodes.concat(levelNodes);
            } else if (i == levelNodes.length) {
                this._levelNodes[level] = levelNodes.concat(cleanNodes);
            } else {
                this._levelNodes[level] =
                            levelNodes.slice(0, i).concat(cleanNodes, levelNodes.slice(i));
            }
        }
    }
},

//>    @method    tree.addList()
//
// Add a list of nodes to some parent.  See +link{ResultTree,"Modifying ResultTrees"}
// when working with a <code>ResultTree</code> for limitations.
//
// @param   nodeList      (List of TreeNode) The list of nodes to add
// @param    parent        (String or TreeNode)    Parent of the nodes being added.  You can pass
//                                          in either the +link{TreeNode} itself, or a path to
//                                            the node (as a String), in which case a
//                                            +link{method:Tree.find} is performed to find
//                                            the node.
// @param    [position]    (number)    Position of the new nodes in the children list. If not
//                                    specified, the nodes will be added at the end of the list.
// @return    (List)    List of added nodes.
//
// @see group:sharingNodes
// @visibility external
//<
addList : function (nodeList, parent, position) {
    return this._addList(nodeList, parent, position);
},
_addList : function (nodeList, parent, position) {
    // normalize the parent property into a node
    if (isc.isA.String(parent)) parent = this.find(parent);

    // if the parent wasn't found, return null
    if (!parent) return null;

    // we'll need to resort the children of this parent
    var children = parent[this.childrenProperty];
    if (children) this.markSubsetSortDirty(children);

    this.__addList(nodeList, parent, position);

    if (!this._deferDataChanged) {
        this._clearNodeCache(true);
        this.dataChanged();
    }

    return nodeList;
},

__addList : function (nodeList, parent, position) {
    // Simply call add repeatedly for each child.
    var length = (
            isc.isA.ResultSet(nodeList) ? nodeList._getCachedLength() : nodeList.getLength());
    for (var i = 0; i < length; ++i) {
        var node = nodeList.getCachedRow(i);
        if (node != null) {
            this.__add(node, parent, position != null ? (position + i) : null);
        }
    }
},


// Structural changes
// --------------------------------------------------------------------------------------------

//>    @method    tree.move()
//
// Moves the specified node to a new parent.
//
// @param    node        (TreeNode)    node to move
// @param    newParent    (TreeNode)    new parent to move the node to
// @param    [position]    (Integer)    Position of the new node in the children list. If not
//                                    specified, the node will be added at the end of the list.
// @visibility external
//<
move : function (node, newParent, position) {
    return this._move(node, newParent, position);
},
_move : function (node, newParent, position) {
    this.moveList([node], newParent, position);
},


// In some cases - EG treeGrid drag/drop, we want to slot a node before a specific
// sibling.
// In this case if any node(s) being moved are being reordered within a parent, the
// final position may differ from what you'd expect (not necessarily index-of-next-node -1)
moveBefore : function (node, nextNode) {
    this.moveListBefore([node], nextNode);
},
moveListBefore : function (nodes, nextNode) {
    var parentNode = this.getParent(nextNode);
    var siblings = this.getChildren(parentNode),
        position = siblings.indexOf(nextNode),
        offset = 0;

    // adjust the target position to account for nodes which are currently
    // before the target position and will be shifted forward.
    for (var i = 0; i < position; i++) {
        if (nodes.contains(siblings[i])) {
            offset += 1;
        }
    }
    this.moveList(nodes, parentNode, position-offset);
},


//>    @method    tree.moveList()
//            Move a list of nodes under a new parent.
//
//        @group    dataChanges
//
//        @param    nodeList    (List of TreeNode)    list of nodes to move
//        @param    newParent    (TreeNode)    new parent node
//        @param    [position]    (number)    position to place new nodes at.
//                                        If not specified, it'll go at the end
//<
moveList : function (nodeList, newParent, position) {

    for (var i = nodeList.length, duplicated = false; i--; ) {
        var node = nodeList[i];
        if (node == newParent || this.isDescendantOf(newParent, node)) {
            if (!duplicated) {

                duplicated = true;
                nodeList = nodeList.duplicate();
            }

            this.logWarn(
                "Tree.moveList():  Specified node '" + this.getPath(node) + "' is an " +
                "ancestor of the new parent node '" + this.getPath(newParent) + "' and " +
                "therefore cannot be made a child of that parent.  The specified node will " +
                "remain where it is.");
            nodeList.removeAt(i);
        }
    }
    if (nodeList.length == 0) {

        return;
    }

    // internal flag that prevents dataChanged from firing 3 times (from the individual
    // remove/add calls, and then at the end of this method)
    this._deferDataChanged = true;

    // remove the nodes from their old parents
    this._removeList(nodeList);

    // Note: we've removed all nodes from the list now, so no need to adjust the target
    // position to account for reshuffling etc - that's already happened.
    // just make sure that if the parent's child list has shortened because some
    // nodes from this parent were removed, we don't leave gaps.

    var children = this.getChildren(newParent);
    if (children) {
        var childrenLength = (isc.isA.ResultSet(children) ?
                children._getCachedLength() : children.getLength());
        if (position > childrenLength) {
            position = childrenLength;
        }
    }

    // add the nodes to the new parent
    this._addList(nodeList, newParent, position);
    // call the dataChanged method to notify anyone who's observing it
    delete this._deferDataChanged;
    this._clearNodeCache(true);
    this.dataChanged();
},

//>    @method    tree.remove()
//
// Removes a node, along with all its children.  See +link{ResultTree,"Modifying ResultTrees"}
// when working with a <code>ResultTree</code> for limitations.
//
// @param    node    (TreeNode)    node to remove
// @return            (Boolean)    true if the tree was changed as a result of this call
//
// @visibility external
//<
remove : function (node, noDataChanged) {
    return this._remove(node, noDataChanged);
},
_remove : function (node, noDataChanged) {
    // get the parent of the node
    var parent = this.getParent(node);
    if (! parent) return false;

//    this.logWarn("removing: " + isc.Log.echoAll(node) + " from: " + isc.Log.echoAll(parent));

    // get the children list of the parent and the name of the node
    var children = this.getChildren(parent);
    if (children) {
        // Figure out the child number.
        var position = children.indexOf(node);
        if (position != -1) {
            this.__remove(node, parent, children, position);

            // This can be expensive if we're called iteratively for a large set of nodes  -
            // e.g. via _removeList(), so consult noDataChanged flag.
            if (!noDataChanged) {
                // Mark the entire tree as dirty.
                this._clearNodeCache(true);
                // Call the dataChanged method to notify anyone who's observing it.
                this.dataChanged();
            }
            return true;
        }
    }

    return false;
},


__remove : function (node, parent, children, position) {
    var pagedResultTree = (
            isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged());


    parent[this._recursionCountProperty] = 1 + (parent[this._recursionCountProperty] || 0);

    var info = {};
    this._preRemove(node, parent, info);
    var deltaLength = info.deltaLength,
        grandParent = info.grandParent,
        origParentLength = info.origParentLength;

    // Remove the node
    children.remove(node);

    this._postRemove(node, parent, info);

    // Update the length of the ancestors according to the removal of the child node.
    // If the removed node was the last of the parent's children, then the parent will look
    // like a leaf to the grandparent, which may affect the lengths of the grandparent and
    // more distant ancestors.
    var grandParent = info.grandParent;

    if ((--parent[this._recursionCountProperty]) == 0) {
        delete parent[this._recursionCountProperty];
        if (grandParent) {
            var deltaParentLength = (
                    this._getNodeLengthToParent(parent, grandParent) - origParentLength);
            this._updateParentLengths(grandParent, deltaParentLength);
        }
    }
},

_preRemove : function (node, parent, info) {
    // Recursively remove the node and its children from the node index.  We do this rather
    // than call _remove() because we don't want to remove the children from the node
    // itself, just from the tree's cache
    this._removeFromNodeIndex(node);

    info.deltaLength = -this._getNodeLengthToParent(node, parent);
    var grandParent = info.grandParent = (parent != this.root && this.getParent(parent));
    info.origParentLength = grandParent && this._getNodeLengthToParent(parent, grandParent);

    this._removeFromLevelCache(node);

    delete node[this.parentProperty];
    delete node[this.treeProperty];
},

_postRemove : function (node, parent, info) {

    // Update the length of the parent according to the removal of the child node.
    var deltaLength = info.deltaLength;

    parent[this._cachedLengthProperty] += deltaLength;
},

_removeFromNodeIndex : function (node) {
    delete this.nodeIndex[node[this.idField]];
    var children = this.getChildren(node, null, null, null, null, null, true);
    if (!children) return;
    var length = (isc.isA.ResultSet(children) ?
            children._getCachedLength() : children.getLength());
    for (var i = 0; i < length; ++i) {
        var child = children.getCachedRow(i);
        if (child != null) {
            this._removeFromNodeIndex(child);
        }
    }
},

//>    @method    tree.removeList()
//
// Remove a list of nodes (not necessarily from the same parent), and all children of those
// nodes.  See +link{ResultTree,"Modifying ResultTrees"} when working with a
// <code>ResultTree</code> for limitations.
//
// @param    nodeList    (List of TreeNode)    list of nodes to remove
// @return                (boolean)    true if the tree was changed as a result of this call
//
// @visibility external
//<
removeList : function (nodeList) {
    return this._removeList(nodeList);
},
_removeList : function (nodeList) {
    // this is our return value
    var changed = false;

    // simply call remove for each node that was removed

    // We can be passed the result of tree.getChildren() - if that happens, then remove() will
    // operate on the same array that we're iterating over, which means nodeList will shrink as
    // we iterate, so count down from nodeList.length instead of counting up.
    // Also note that getChildren() may return a ResultSet so the nodeList argument may be a
    // ResultSet.
    var i = (isc.isA.ResultSet(nodeList) ? nodeList._getCachedLength() : nodeList.getLength());
    while (i--) {
        var node = nodeList.getCachedRow(i);
        if (node != null) {
            if (this._remove(node, true)) {
                changed = true;
            }
        }
    }

    // call the dataChanged method to notify anyone who's observing it
    if (changed && !this._deferDataChanged) {
        this._clearNodeCache(true);
        this.dataChanged();
    }

    return changed;
},

_removeFromLevelCache : function (node, level) {
    if (!this.indexByLevel) return;

    level = level || this.getLevel(node) - 1;

    // Remove index entries for descendants first
    var nodeChildren = this.getChildren(node);
    if (nodeChildren) {
        var length = (isc.isA.ResultSet(nodeChildren) ?
                nodeChildren._getCachedLength() : nodeChildren.getLength());
        for (var i = 0; i < length; ++i) {
            var child = nodeChildren.getCachedRow(i);
            if (child != null) {
                this._removeFromLevelCache(child, level + 1);
            }
        }
    }

    if (this._levelNodes[level]) {
        var levelNodes = this._levelNodes[level];
        for (var i = 0; i < levelNodes.length; i++) {
            if (levelNodes[i] == node) {
                levelNodes.splice(i, 1);
                break;
            }
        }
    }
},


// Loading and unloading of children
// --------------------------------------------------------------------------------------------


//>    @method    tree.getLoadState()
// What is the loadState of a given folder?
//
// @param node (TreeNode) folder in question
// @return (LoadState) state of the node
// @group loadState
// @visibility external
//<
getLoadState : function (node) {
    if (!node) return null;
    if (this.isLeaf(node)) return isc.Tree.LOADED;
    if (!node._loadState) return this.defaultLoadState;
    return node._loadState;
},

//>    @method    tree.isLoaded()
// For a databound tree, has this folder either already loaded its children or is it in the
// process of loading them.
//
// @param node (TreeNode) folder in question
// @return (Boolean) folder is loaded or is currently loading
// @group loadState
// @visibility external
//<
isLoaded : function (node) {
    var loadState = this.getLoadState(node);
    return (
        loadState == isc.Tree.LOADED ||
        loadState == isc.Tree.LOADING ||
        loadState == isc.Tree.LOADED_PARTIAL_CHILDREN);
},

// helper to support ResultTree.hideLoadingNodes
isLoading : function (node) {
    return this.getLoadState(node) == isc.Tree.LOADING;
},

//>    @method    tree.allChildrenLoaded()
// For a databound tree, do the children of this folder form a ResultSet with a full cache.
// <P>
// Note that this method only applies to +link{resultTree.fetchMode} "paged".
// @param node (TreeNode) folder in question
// @return (Boolean) folder's children are a ResultSet with a full cache
// @group loadState
// @see tree.getChildrenResultSet()
// @visibility external
//<
allChildrenLoaded : function (node) {
    var loadState = this.getLoadState(node);
    return (loadState == isc.Tree.LOADED);
},

//>    @method    tree.setLoadState()
// Set the load state of a particular node.
// @group loadState
// @param node (TreeNode) node in question
// @param newState (string) new state to set to
// @return (boolean) folder is loaded or is currently loading
//<
setLoadState : function (node, newState) {
    var prevState = this.getLoadState(node);
    node._loadState = newState;
    newState = this.getLoadState(node);

    // The load state of the node affects the _visibleDescendantsCachedProperty set on the
    // nodes of paged ResultTrees.  Update the value of that property of the node if necessary.
    var prevFlag = (
            prevState === isc.Tree.LOADED ||
            prevState === isc.Tree.LOADED_PARTIAL_CHILDREN),
        newFlag = (
            newState === isc.Tree.LOADED ||
            newState === isc.Tree.LOADED_PARTIAL_CHILDREN),
        pagedResultTree = (
            isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged());
    if (pagedResultTree && (prevFlag != newFlag)) {
        // Only update the _visibleDescendantsCachedProperty if it has been set before on the
        // node.
        var parent = this.getParent(node);
        if (isc.isA.Boolean(node[this._visibleDescendantsCachedProperty])) {
            this._setVisibleDescendantsCached(node, null, parent, false);
        }
    }
},

//>    @method    tree.loadRootChildren()
//            Load the root node's children.
//            Broken out into a special function so you can override more cleanly
//                 (default implementation just calls loadChildren)
//      @param  [callback]  (callback) StringMethod to fire when loadChildren() has loaded data.
//        @group    loadState
//<
loadRootChildren : function (callback) {
    this.loadChildren(this.root, callback);
},

//>    @method    tree.loadChildren()
// Load the children of a given node.
// <P>
// For a databound tree this will trigger a fetch against the Tree's DataSource.
//
//
// @param node    (TreeNode)    node in question
// @param [callback] (DSCallback) Optional callback (stringMethod) to fire when loading
//                      completes. Has a single param <code>node</code> - the node whose
//                      children have been loaded, and is fired in the scope of the Tree.
// @group loadState
// @visibility external
//<
loadChildren : function (node, callback) {
    if (!node) {
        node = this.root;
    }
    var pagedResultTree = (
            isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged());
    if (pagedResultTree) {
        this._loadChildren(node, 0, this.resultSize, callback);
    } else {
        this._loadChildren(node, null, null, callback);
    }
},


_loadChildren : function (node, start, end, callback) {


    // mark the node as loaded
    this.setLoadState(node, isc.Tree.LOADED);
    if (callback) {
        //Fire the callback in the scope of this tree
        this.fireCallback(callback, "node", [node], this);
    }
},

//>    @method    tree.unloadChildren()
// Unload the children of a folder, returning the folder to the "unloaded" state.
//
// @param node (TreeNode) folder in question
// @group loadState
// @deprecated It's recommended that you instead use +link{tree.reloadChildren()} to reload the
// children of a folder, or +link{tree.removeChildren()} if you need to clear the cached children
// of a folder to add specific local data.
// @visibility external
//<
// NOTE internal parameter:    [displayNodeType]    (DisplayNodeType)    Type of children to drop
unloadChildren : function (node, displayNodeType, markAsLoaded) {
    if (node == null || this.isLeaf(node)) {
        return;
    }

    var droppedChildren, newChildren, newLoadState;
    if (displayNodeType == isc.Tree.LEAVES_ONLY) {
        // set the children array to just the folders
        droppedChildren = this.getLeaves(node);
        newChildren = this.getFolders(node);
        // and mark the node as only the folders are loaded
        newLoadState = isc.Tree.FOLDERS_LOADED;
    } else {
        // clear out the children Array
        droppedChildren = node[this.childrenProperty];
        newChildren = [];
        // and mark the node as unloaded
        newLoadState = isc.Tree.UNLOADED;
    }

    var parent, origLength;
    if (droppedChildren) {
        parent = (node != this.root && this.getParent(node));
        origLength = parent && this._getNodeLengthToParent(node, parent);

        for (var i = 0; i < droppedChildren.getLength(); i++) {
            var droppedChild = droppedChildren.get(i);

            // skip anything that doesn't appear to be a valid child node of parent
            if (!isc.isAn.Object(droppedChild) || droppedChild[this.idField] == null) continue;

            // take the droppedChildren out of the node index
            // NOTE: we shouldn't just call _remove() to do this.  unloadChildren() is essentially
            // discarding cache, whereas calling _remove() in a dataBound tree would actually kick off a
            // DataSource "remove" operation
            this._removeFromNodeIndex(droppedChild);


            node[this._cachedLengthProperty] -= this._getNodeLengthToParent(droppedChild, node);
        }
    }

    node[this.childrenProperty] = newChildren;
    this.setLoadState(node, markAsLoaded ? isc.Tree.LOADED : newLoadState);

    if (droppedChildren && parent) {
        // Update the lengths of the ancestors of the dropped children.  The children's parent,
        // node, already has had its length updated.  Now just update the length of the node's
        // ancestors.
        var deltaLength = (this._getNodeLengthToParent(node, parent) - origLength);
        this._updateParentLengths(parent, deltaLength);
    }

    // mark the tree as dirty and note that the data has changed
    this._clearNodeCache(true);
    this.dataChanged();
},

//>    @method    tree.reloadChildren()
// Reload the children of a folder.
//
// @param node (TreeNode) node in question
// @see removeChildren()
// @group loadState
// @visibility external
//<

reloadChildren : function (node, displayNodeType) {
    this.unloadChildren(node, displayNodeType);
    this.loadChildren(node, displayNodeType);
},

//>    @method    tree.removeChildren()
// Removes all children of the node and sets it to a loaded state.  For non-+link{ResultTree}s,
// or non-+link{ResultTree.fetchMode,paged} <code>ResultTree</code>s, +link{add()} or
// +link{addList()} can then be used to provide new children.  For
// +link{ResultTree.fetchMode,paged} <code>ResultTrees</code>, +link{DataSource.updateCaches()}
// must be used to insert nodes into the cache as local data, since such
// <code>ResultTree</code>s are considered read-only, and +link{add} and +link{addList()} are
// not perrmitted.
//
// @param node (TreeNode) folder in question
// @see getLoadState()
// @see reloadChildren()
// @group loadState
// @visibility external
//<

removeChildren : function (node, displayNodeType) {

    this.unloadChildren(node, displayNodeType, true);
},

//>    @method    tree.setChildren()
// Replaces the existing children of a parent node, leaving the node in the loaded state.
// Only a flat list of children nodes is supported, as in +link{addList()}.
//
// @param parent                (TreeNode) parent of children
// @param newChildren   (List of TreeNode) children to be set
//
// @see removeChildren()
// @see dataSource.updateCaches()
//
// @group loadState
// @visibility external
//<
setChildren : function (parent, newChildren) {
    // remove current children
    this.removeChildren(parent);
    // add new children to parent
    this.addList(newChildren || [], parent);
},

//
//    open and close semantics for a set of tree nodes
//


// clears the open node cache (used by getOpenList())
// and optionally the all node cache (used by getNodeList()).
_clearNodeCache : function (allNodes) {
    if (allNodes) this._allListCache = null;
    this._openListCache = null;
},

//>    @method    tree.isOpen()
//
// Whether a particular node is open or closed (works for leaves and folders).
//
// @param    node    (TreeNode)    node in question
// @return  (Boolean)           true if the node is open
//
// @visibility external
//<
isOpen : function (node) {
    return node != null && !!node[this.openProperty];
},


//>    @method    tree.getOpenFolders()
//        Return the list of sub-folders of this tree that have been marked as open.
//        Note: unlike tree.getOpenList(), this only returns *folders* (not files),
//            and this will return nodes that are open even if their parent is not open.
//        @group    openList
//
//        @param    node    (TreeNode)    node to start with.  If not passed, this.root will be used.
//<
getOpenFolders : function (node) {
    if (node == null) node = this.root;
    var openProperty = this.openProperty;
    var openNodes = this.getDescendantFolders(node, function (node) {
        return node[openProperty];
    });
    if (this.isOpen(node)) openNodes.add(node);
    return openNodes;
},

//>    @method    tree.getOpenFolderPaths()
//        Return the list of sub-folders of this tree that have been marked as open.
//        Note: unlike tree.getOpenList(), this only returns *folders* (not files),
//            and this will return nodes that are open even if their parent is not open.
//        @group    openList
//
//        @param    node    (TreeNode)    node to start with.  If not passed, this.root will be used.
//<
getOpenFolderPaths : function (node) {
    var openNodes = this.getOpenFolders(node);
    for (var i = 0; i < openNodes.length; i++) {
        openNodes[i] = this.getPath(openNodes[i]);
    }
    return openNodes;
},

//>    @method    tree.changeDataVisibility()    (A)
// Open or close a node.<br><br>
//
// Note that on a big change (many items being added or deleted) this may be called multiple times.
//
//        @group    openList
//
//        @param    node        (TreeNode)    node in question
//        @param    newState    (boolean)    true == open, false == close
//      @param  [callback] (callback) Optional callback (stringMethod) to fire when loading
//                      completes. Has a single param <code>node</code> - the node whose
//                      children have been loaded, and is fired in the scope of the Tree.
//<
changeDataVisibility : function (node, newState, callback) {
//!DONTOBFUSCATE  (obfuscation breaks the inline function definitions)

    // if they're trying to open a leaf return false
    if (this.isLeaf(node)) {
        if (callback) {
            // Fire the callback in the scope of this tree
            this.fireCallback(callback, "node", [node], this);
        }
        return false;
    }

    // mark the node as open or closed
    var state = node[this.openProperty],
        closedToOpen = !state && newState,
        openToClosed = state && !newState;

    // If the node's openness has changed then its cached length may also have changed.
    if (closedToOpen || openToClosed) {
        var parent = (node != this.root && this.getParent(node)) || null,
            prevLength = parent && this._getNodeLengthToParent(node, parent),
            newLength = (this.openDisplayNodeType != isc.Tree.LEAVES_ONLY ? 1 : 0);

        node[this.openProperty] = newState;

        if (closedToOpen) {
            // node went from closed to open so its length includes the lengths of the children.
            var childrenInOpenList = this.getChildren(
                    node, isc.Tree.FOLDERS_AND_LEAVES, null,
                    this.sortDirection, this.openListCriteria, this._sortContext,
                    true, true, true),
                loadingMarker = (
                    isc.ResultSet != null ? isc.ResultSet.getLoadingMarker() : null);
            // If getChildren returned null, convert to an empty array

            if (childrenInOpenList == null) childrenInOpenList = [];
            var i = (isc.isA.ResultSet(childrenInOpenList) ?
                    childrenInOpenList._getCachedLength() : childrenInOpenList.getLength());


            var pagedResultTree = (
                    isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged()),
                knownLengthNulls = pagedResultTree;
            if (pagedResultTree) {
                var openSubfoldersAllowed = (
                        node[this.canReturnOpenSubfoldersProperty] != null ?
                        node[this.canReturnOpenSubfoldersProperty] : this.canReturnOpenFolders),
                    defaultChildLength = (
                        this.openDisplayNodeType == isc.Tree.FOLDERS_AND_LEAVES ? 1 : 0);

                knownLengthNulls = !(openSubfoldersAllowed || defaultChildLength == 0);
            }

            while (i--) {
                var child = childrenInOpenList.getCachedRow(i);
                if (child != null && child != loadingMarker) {
                    newLength += this._getNodeLengthToParent(child, node);
                } else if (knownLengthNulls) {
                    ++newLength;
                }
            }
        }


        var prevCachedLength = node[this._cachedLengthProperty];
        node[this._cachedLengthProperty] = newLength;

        // Add the change in length to all ancestors.
        if (parent) {
            var deltaLength = this._getNodeLengthToParent(node, parent) - prevLength;
            this._updateParentLengths(parent, deltaLength);
        }

        // Incrementally add/remove the node to/from the _openListCache array.
        var affectsOpenListCache = (
                this._openListCache != null &&
                // If the node is the root then this optimization would just be regenerating
                // the open list anyway.  It would be better not to do anything here and let
                // the open list be regenerated lazily by _getOpenList().
                parent != null &&
                // If the `openDisplayNodeType` allows only leaves then only the leaves under
                // the root folder will ever appear in the open list, so the node and its
                // descendants cannot appear in the open list.
                this.openDisplayNodeType != isc.Tree.LEAVES_ONLY &&
                // Skip if there are no nodes to add/remove from the open list.
                (closedToOpen ? newLength > prevCachedLength : newLength < prevCachedLength) &&
                this._includeNodeLengthInParent(node, parent));
        for (var n = node, p = parent; p != null && affectsOpenListCache; ) {
            n = p;
            p = this.getParent(p);
            affectsOpenListCache = (p == null || this._includeNodeLengthInParent(n, p));
        }
        if (parent == null) {
            this._clearNodeCache(false);
        } else if (affectsOpenListCache) {
            // Count the number of nodes preceding `node` in the open list.  Add one to get
            // the starting index of the descendants of `node` in the open list.  This will
            // be passed to splice() to add/remove nodes starting at that index.
            var loadingMarker = (isc.ResultSet != null ? isc.ResultSet.getLoadingMarker() : null),
                foldersInOpenList = (this.openDisplayNodeType != isc.Tree.LEAVES_ONLY),
                // When getting lists of children, the displayNodeType must match all folders
                // (so that we can find a specific folder `n` in each iteration of the
                // following loop) and it must incorporate the current `openDisplayNodeType`
                // (so that all nodes with nonzero length are counted).
                displayNodeType = (
                    this.openDisplayNodeType == isc.Tree.FOLDERS_ONLY
                        ? isc.Tree.FOLDERS_ONLY : isc.Tree.FOLDERS_AND_LEAVES),
                openListIndex = (foldersInOpenList && this.showRoot ? 1 : 0);
            for (var n = node, p = parent; p != null; ) {
                var children = this.getChildren(
                        p, displayNodeType, this._openNormalizer, this.sortDirection,
                        this.openListCriteria, this._sortContext, true);
                if (children == null) children = [];

                var length = (isc.ResultSet != null && isc.isA.ResultSet(children) ?
                        children._getCachedLength() : children.getLength());


                for (var i = 0; i < length; ++i) {
                    var child = children.getCachedRow(i);
                    if (child == n) {
                        if (foldersInOpenList) {
                            ++openListIndex;
                        }
                        // Break from the loop.
                        i = length;
                    } else if (!(child == null || child == loadingMarker)) {
                        openListIndex += this._getNodeLengthToParent(child, p);
                    }
                }

                n = p;
                p = this.getParent(p);
            }


            if (closedToOpen) {
                var args = this.getOpenList(
                        node, this.openDisplayNodeType, this._openNormalizer,
                        this.sortDirection, this.openListCriteria, this._sortContext, false);


                // Set the first two arguments so that no nodes are removed from the
                // _openListCache and that nodes are added starting at the `openListIndex`.
                if (foldersInOpenList) {
                    args[0] = 0;
                    args.unshift(openListIndex);
                } else {
                    args.unshift(openListIndex, 0);
                }

                this._openListCache.splice.apply(this._openListCache, args);
            } else { // openToClosed
                this._openListCache.splice(openListIndex, prevCachedLength - newLength);
            }
        }
    } else {
        node[this.openProperty] = newState;
    }

    // if the node is not loaded, load it!
    if (newState && !this.isLoaded(node)) {
        this.loadChildren(node, callback);
    } else if (callback) {
        // Fire the callback in the scope of this tree
        this.fireCallback(callback, "node", [node], this);
    }
},

//>    @method    tree.toggleFolder()
//            Toggle the open state for a particular node
//        @group    openList
//
//        @param    node    (TreeNode)    node in question
//<
toggleFolder : function (node) {
    this.changeDataVisibility(node, !this.isOpen(node));
},


//>    @method    tree.openFolder()
//
// Open a particular node
//
// @param    node    (TreeNode)    node to open
// @param  [callback] (callback) Optional callback (stringMethod) to fire when loading
//                      completes. Has a single param <code>node</code> - the node whose
//                      children have been loaded, and is fired in the scope of the Tree.
// @see ResultTree.dataArrived
// @visibility external
//<
openFolder : function (node, callback) {
    if (node == null) node = this.root;

    // if the node is not already set to the newState
    if (!this.isOpen(node)) {
        // call the dataChanged method to notify anyone who's observing it
        this.changeDataVisibility(node, true, callback);
    } else if (callback) {
        // Fire the callback in the scope of this tree
        this.fireCallback(callback, "node", [node], this);
    }
},


//>    @method    tree.openFolders()
//
// Open a set of folders, specified by path or as pointers to nodes.
//
// @param    nodeList    (List of TreeNode)        List of nodes or node paths.
//
// @see ResultTree.dataArrived
// @visibility external
//<
openFolders : function (nodeList) {
    for (var i = 0; i < nodeList.length; i++) {
        var node = nodeList[i];
        if (node == null) continue;
        if (isc.isA.String(node)) node = this.find(node);
        if (node != null) {
            this.openFolder(node);
        }
    }
},

//>    @method    tree.closeFolder()
//
// Closes a folder
//
// @param    node    (TreeNode)    folder to close
//
// @visibility external
//<
closeFolder : function (node) {
    // if the node is not already set to the newState
    if (this.isOpen(node)) {
        // call the dataChanged method to notify anyone who's observing it
        this.changeDataVisibility(node, false);
    }
},

//>    @method    tree.closeFolders()
//
// Close a set of folders, specified by path or as pointers to nodes.
//
// @param    nodeList    (List of TreeNode)        List of nodes or node paths.
//
// @visibility external
//<
closeFolders : function (nodeList) {
    for (var i = 0; i < nodeList.length; i++) {
        var node = nodeList[i];
        if (node == null) continue;
        if (isc.isA.String(node)) node = this.find(node);
        if (node != null) {
            this.closeFolder(node);
        }
    }
},

//>    @method    tree.openAll()
//
// Open all nodes under a particular node.
//
// @param    [node]    (TreeNode)    node from which to open folders (if not specified, the root
//                              node is used)
// @visibility external
// @example parentLinking
//<
openAll : function (node) {
    if (!node) node = this.root;
    if (node == this.root) {
        // Mark the open node list as dirty.  This avoids an optimization to incrementally
        // maintain the _openListCache array that would not work very well for a bulk operation
        // like this.
        this._clearNodeCache(false);
    }
    var nodeList = this.getDescendants(node, isc.Tree.FOLDERS_ONLY);
    for (var i = 0, length = nodeList.length; i < length; i++) {
        // if the node is not already set to the newState
        if (!this.isOpen(nodeList[i])) {
            // call the dataChanged method to notify anyone who's observing it
            this.changeDataVisibility(nodeList[i], true);
        }
    }
    // make the node itself open
    this.changeDataVisibility(node, true);
},

//>    @method    tree.closeAll()
// Close all nodes under a particular node
//
// @param    [node]    (TreeNode)    node from which to close folders (if not specified, the root
//                              node is used)
//
// @visibility external
//<
closeAll : function (node) {
    if (!node) node = this.root;
    if (node == this.root) {
        // Mark the open node list as dirty.  This avoids an optimization to incrementally
        // maintain the _openListCache array that would not work very well for a bulk operation
        // like this.
        this._clearNodeCache(false);
    }
    var nodeList = this.getDescendants(node, isc.Tree.FOLDERS_ONLY);
    for (var i = 0, length = nodeList.length; i < length; i++) {
        // if the node is not already set to the newState
        if (this.isOpen(nodeList[i])) {
            // call the dataChanged method to notify anyone who's observing it
            this.changeDataVisibility(nodeList[i], false);
        }
    }

    // close the node as well, unless (node==this.root and this.showRoot == false)
    //    this way we make sure you won't close an invisible root,
    //  leaving no way to re-open it.
    if (!(node == this.root && this.showRoot == false)) this.changeDataVisibility(node, false);
},

setOpenDisplayNodeType : function (openDisplayNodeType) {
    var prevOpenDisplayNodeType = this.openDisplayNodeType;
    this.openDisplayNodeType = openDisplayNodeType;
    if (prevOpenDisplayNodeType != openDisplayNodeType) {
        this._clearNodeCache(true);
    }
},

setOpenListCriteria : function (openListCriteria) {
    var prevOpenListCriteria = this.openListCriteria;
    this.openListCriteria = openListCriteria;
    if (prevOpenListCriteria != openListCriteria) {
        this._clearNodeCache(true);
    }
},

setSortProp : function (sortProp) {
    var prevSortProp = this.sortProp;
    this.sortProp = sortProp;
    if (prevSortProp != sortProp) {
        this._clearNodeCache(true);
    }
},

setSortDirection : function (sortDirection) {
    var prevSortDirection = this.sortDirection;
    this.sortDirection = sortDirection;
    if (prevSortDirection != sortDirection) {
        this._clearNodeCache(true);
    }
},

//> @method tree.setShowRoot()
// Setter for +link{Tree.showRoot}.
// @param showRoot (Boolean) new <code>showRoot</code> value
// @visibility external
//<
setShowRoot : function (showRoot) {
    var prevShowRoot = this.showRoot;
    this.showRoot = showRoot;
    if (this.openDisplayNodeType != isc.Tree.LEAVES_ONLY) {
        if (!prevShowRoot && showRoot) {
            // Add the root to the _allListCache and the _openListCache.
            if (this._allListCache != null) {
                this._allListCache.unshift(this.root);
            }
            if (this._openListCache != null) {
                this._openListCache.unshift(this.root);
            }
        } else if (prevShowRoot && !showRoot) {

            // Remove the root from the _allListCache and the _openListCache.
            if (this._allListCache != null) {
                this._allListCache.shift();
            }
            if (this._openListCache != null) {
                this._openListCache.shift();
            }
        }
    }
},

//> @method tree.setSeparateFolders()
// Setter for +link{Tree.separateFolders}.
// @param separateFolders (Boolean) new <code>separateFolders</code> value
// @visibility external
//<
setSeparateFolders : function (separateFolders) {
    var prevSeparateFolders = this.separateFolders;
    this.separateFolders = separateFolders;
    if (prevSeparateFolders ? !separateFolders : separateFolders) {
        this._clearNodeCache(true);
    }
},

//> @method tree.setSortFoldersBeforeLeaves()
// Setter for +link{Tree.sortFoldersBeforeLeaves}.
// @param sortFoldersBeforeLeaves (Boolean) new <code>sortFoldersBeforeLeaves</code> value
// @visibility external
//<
setSortFoldersBeforeLeaves : function (sortFoldersBeforeLeaves) {
    var prevSortFoldersBeforeLeaves = this.sortFoldersBeforeLeaves;
    this.sortFoldersBeforeLeaves = sortFoldersBeforeLeaves;
    if (prevSortFoldersBeforeLeaves ? !sortFoldersBeforeLeaves : sortFoldersBeforeLeaves) {
        this._clearNodeCache(true);
    }
},





//>    @method    tree.getOpenList()
// Return a flattened list of all nodes that are visible under some parent based on whether the node
// itself or any folders underneath it are open.  Returned list will include the passed node.
// <p>
// If the passed in node is a leaf, this method returns null.
//
// @param [node]            (TreeNode)            node in question
// @return                    (List of TreeNode)              flattened list of open nodes
//
// @visibility external
//<

getOpenList : function (node, displayNodeType, normalizer, sortDirection, criteria, context,
                        getAll, dontUseNormalizer)
{
    // default to the tree root
    if (! node) node = this.root;

    // default the normalizer to this._openNormalizer and sortDirection to this.sortDirection
    if (dontUseNormalizer) normalizer = null;
    else if (normalizer == null) normalizer = this._openNormalizer;
    if (sortDirection == null)        sortDirection = this.sortDirection;
    if (context == null) context = this._sortContext;
    // if the node is a leaf, return the empty list since it's not going to have any children
    if (this.isLeaf(node)) {
        // prevents mysterious crash if an isFolder() override claims root is a leaf
        if (node == this.root) return [];
        return null;
    }

    // create an array to hold the descendants
    var list = [];

    // add the node if we're not skipping folders (except if the node is the root and showRoot is false)
    if (displayNodeType != isc.Tree.LEAVES_ONLY && (node != this.root || this.showRoot)) {
        list[list.length] = node;
    }

    // if this node is closed or loading, just return the list and don't look for children
    if (!getAll && !this.isOpen(node) || this.hideLoadingNodes && this.isLoading(node)) {
        return list;
    }

    // iterate through all the children of the node
    var children = this.getChildren(node, isc.Tree.FOLDERS_AND_LEAVES, normalizer,
                       sortDirection, criteria, context, false, false, dontUseNormalizer);
    // for each child
    var loadingMarker = (isc.ResultSet != null ? isc.ResultSet.getLoadingMarker() : null),
        length = (isc.ResultSet != null && isc.isA.ResultSet(children) ?
            children._getCachedLength() : children.getLength());
    for (var i = 0; i < length; ++i) {
        // get a pointer to the child
        var child = children.getCachedRow(i);
        if (child == null || child == loadingMarker) {
            //>DEBUG
            //alert("getOpenList: child # " + i + " of folder " + node.path + " is null!");
            //<DEBUG
            continue;
        }

        // if the child is a folder, recurse, but check that it actually has children -
        // otherwise we eat a function call, array alloc, empty concat, and a bunch of other
        // checks (top of this function) all for nothing.  This is a typical case for loading a
        // large set of folders from the server in loadOnDemand mode
        //
        var grandChildren = child[this.childrenProperty];
        if (grandChildren && !grandChildren.isEmpty()) {
            // now concatenate the list with the descendants of the child

            var subList = this.getOpenList(child, displayNodeType, normalizer, sortDirection,
                                           criteria, context, getAll, dontUseNormalizer);
            if (subList) {
                for (var j = 0; j < subList.length; j++) list[list.length] = subList[j];
            }

        } else {
            // if we're not excluding leaves, add the leaf to the list

            if (displayNodeType != isc.Tree.FOLDERS_ONLY) {
                list[list.length] = child;
            }
        }
    }

    // finally, return the entire list
    return list;
},
// _getOpenListAsync() is an asynchronous method equivalent to getOpenList().
_getOpenListAsync : function (node, displayNodeType, normalizer, sortDirection, criteria, context, getAll,
            thisArg, timerEventProp, batchSize, callback, state) {

    var node0 = node,
        done = false,
        list,
        indexStack, childrenStack,
        i, children;
    if (state == null) {
        // default to the tree root
        if (! node) node0 = node = this.root;

        // default the normalizer to this._openNormalizer and sortDirection to this.sortDirection
        if (normalizer == null)         normalizer = this._openNormalizer;
        if (sortDirection == null)        sortDirection = this.sortDirection;
        if (context == null) context = this._sortContext;

        // create an array to hold the descendants
        list = [];

        // if the node is a leaf, return the empty list since it's not going to have any children
        if (this.isLeaf(node)) {
            // prevents mysterious crash if an isFolder() override claims root is a leaf
            var ret = (node == this.root ? [] : null);
            callback.call(thisArg, ret);
            return;
        }

        indexStack = [];
        childrenStack = [];
        state = {
            list: list,
            node: node,
            indexStack: indexStack,
            childrenStack: childrenStack
        };
    } else {
        list = state.list;
        node = state.node;
        indexStack = state.indexStack;
        childrenStack = state.childrenStack;
        i = indexStack.last();
        children = childrenStack.last();
    }

    for (var count = 0; !done && count < batchSize; ++count) {
        if (node != null) {
            // if the node is a leaf, return the empty list since it's not going to have any children
            if (this.isLeaf(node)) {
                node = null;
                continue;
            }

            // add the node if we're not skipping folders (except if the node is the root and showRoot is false)
            if (displayNodeType != isc.Tree.LEAVES_ONLY && (node != this.root || this.showRoot)) {
                list[list.length] = node;
            }

            // if this node is closed, return the list
            if (!getAll && !this.isOpen(node)) {
                node = null;
                continue;
            }

            // iterate through all the children of the node
            i = 0;
            children = this.getChildren(node, displayNodeType, normalizer, sortDirection,
                                        criteria, context);
            indexStack.push(i);
            childrenStack.push(children);
        }

        // Set the node to null to skip the above checks in the next few iterations of the outer,
        // loop.  All that remains is to check this node's children (who have been pushed onto
        // childrenStack).
        node = null;

        // for each child
        var escapeToOuterLoop = false,
            length = (isc.isA.ResultSet(children) ?
                children._getCachedLength() : children.getLength());
        for (; !escapeToOuterLoop && i < length && count < batchSize; ++i) {
            // get a pointer to the child
            var child = children.getCachedRow(i);
            if (child == null) {
                //>DEBUG
                //alert"getOpenList: child # " + i + " of folder " + node.path + " is null!");
                //<DEBUG
                continue;
            }

            // if the child is a folder, recurse, but check that it actually has children -
            // otherwise we eat a function call, array alloc, empty concat, and a bunch of other
            // checks (top of this function) all for nothing.  This is a typical case for loading a
            // large set of folders from the server in loadOnDemand mode
            //
            var grandChildren = child[this.childrenProperty];
            if (grandChildren && !grandChildren.isEmpty()) {
                // now concatenate the list with the descendants of the child
                escapeToOuterLoop = true;
                node = state.node = child;
                continue;
            } else {
                // if we're not excluding leaves, add the leaf to the list

                if (displayNodeType != isc.Tree.FOLDERS_ONLY) {
                    list[list.length] = child;
                }
                ++count;
            }
        }

        // `i` is supposed to be an alias variable for the last index in the indexStack.
        indexStack[indexStack.length - 1] = i;
        if (!escapeToOuterLoop && i >= length) {
            if (indexStack.length > 1) {
                indexStack.pop();
                childrenStack.pop();
                i = indexStack.last();
                children = childrenStack.last();
            } else {
                done = true;
            }
        }
    }

    if (done) {
        // finally, return the entire list
        callback.call(thisArg, list);
    } else {
        state.node = node;
        thisArg[timerEventProp] = this.delayCall(
            "_getOpenListAsync",
            [node0, displayNodeType, normalizer, sortDirection, criteria, context, getAll,
             thisArg, timerEventProp, batchSize, callback, state], 0);
    }
},

//>    @method    tree._getOpenList()    (A)
// Internal routine to set the open list if it needs to be set
//        @group    openList
//<
_getOpenList : function () {
    // if the _openListCache hasn't been calculated,
    //        or we're not supposed to cache the openList
    if (!this._openListCache || !this.cacheOpenList) {
        // recalculate the open list
        this._openListCache = this.getOpenList(this.root, this.openDisplayNodeType,
                                               this._openNormalizer, this.sortDirection,
                                               this.openListCriteria);
    }
    return this._openListCache;
},

//> @method tree.getNodeList()
// Return a flattened list of all nodes in the tree.
//<
getNodeList : function (onlyOpen, dontSort) {
    // Call _getOpenList() if:
    // - we only need opened nodes
    // - either dontSort is not true or we have a (sorted) cache anyway, so the hint
    //   not to use the normalizer is unnecessary information.
    // If we don't have an _openListCache and dontSort is true, then we will want to
    // respect the request to not apply the normalizer, as this is probably faster that recalculating
    // the _openListCache, which will apply the normalizer.
    if (onlyOpen && (dontSort != true || (this._openListCache && this.cacheOpenList))) {
        return this._getOpenList();

    } else if (dontSort) {
        return this.getOpenList(this.root, this.openDisplayNodeType,
                                null, null, this.openListCriteria, null, (onlyOpen != true),
                                dontSort);

    // if the _allListCache hasn't been calculated,
    // or we're not supposed to cache the openList
    } else if (!this._allListCache || !this.cacheAllList) {
        // recalculate the node list
        this._allListCache = this.getAllNodes(this.root);
    }
    return this._allListCache;
},
// _getNodeListAsync() is an asynchronous method equivalent to getNodeList().
_getNodeListAsync : function (thisArg, timerEventProp, batchSize, callback) {
    // if the _allListCache hasn't been calculated,
    // or we're not supposed to cache the openList
    if (! this._allListCache || !this.cacheAllList) {
        // recalculate the node list
        var me = this;
        this._getAllNodesAsync(this.root, thisArg, timerEventProp, batchSize, function (nodes) {
            me._allListCache = nodes;
            callback.call(thisArg, nodes);
        });
    } else {
        return this._allListCache;
    }
},

//> @method tree.getAllNodes()
// Get all the nodes that exist in the tree under a particular node, as a flat list, in
// depth-first traversal order.
//
// @param [node] optional node to start from.  Default is root.
// @return (Array of TreeNode) all the nodes that exist in the tree
// @visibility external
//<
getAllNodes : function (node) {
    return this.getOpenList(node, null, null, null, null, null, true);
},
// _getAllNodesAsync() is an asynchronous method equivalent to getAllNodes().
_getAllNodesAsync : function (node, thisArg, timerEventProp, batchSize, callback) {
    this._getOpenListAsync(node, null, null, null, null, null, true, thisArg, timerEventProp,
                           batchSize, callback);
},

// List API
// --------------------------------------------------------------------------------------------

//>    @method    tree.getLength()
//
// Returns the number of items in the current open list.
//
// @return        (number)    number of items in open list
//
// @see method:Tree.getOpenList
// @visibility external
//<
getLength : function () {

    var length = (this.root[this._cachedLengthProperty] - (
        !this.showRoot && this.openDisplayNodeType != isc.Tree.LEAVES_ONLY ? 1 : 0));

    // assert (length == this._getOpenList().length);

   return length;
},

// _getLengthAsync() is an asynchronous version of getLength().
_getLengthAsync : function (thisArg, timerEventProp, batchSize, callback) {
    callback.call(thisArg, this.getLength());
},

//> @method tree.get()
// Get the item in the openList at a particular position.
// @param pos (Number) position of the node to get
// @return (TreeNode) node at that position
// @group openList, Items
//<
get : function (pos) {
    return this._getOpenList()[pos];
},

// see ResultSet.getCachedRow()
getCachedRow : function (rowNum) {
    return this.get(rowNum);
},

//>    @method    tree.getRange()
//            Get a range of items from the open list
//        @group    openList, Items
//
//      @param  start (number) start position
//      @param  end   (number) end position (NOT inclusive)
//      @return       (Array of TreeNode) list of nodes in the open list
//<
getRange : function (start, end) {
    if (!(0 <= start && start < end)) return [];
    return this._getOpenList().slice(start, end);
},

//>    @method    tree.indexOf()
// @include list.indexOf
//<
indexOf : function (node, pos, endPos) {
    return this._getOpenList().indexOf(node, pos, endPos);
},

//>    @method    tree.lastIndexOf()
// @include list.lastIndexOf
//<
lastIndexOf : function (node, pos, endPos) {
    return this._getOpenList().lastIndexOf(node, pos, endPos);
},

//>    @method    tree.getAllItems()
//            Get the entire list (needed by Selection)
//        @group    openList, Items
//
//        @return        (TreeNode)    all nodes in the open list
//<
getAllItems : function () {
    return this._getOpenList();
},



//>    @method    tree.sortByProperty()
// Handle a 'sortByProperty' call to change the default sort order of the tree
//        @group    sorting
//
//        @param    [property]    (string)    name of the property to sort by
//        @param    [direction]        (boolean)    true == sort ascending
//        @param    [normalizer](function)    sort normalizer (will be derived if not specified)
//<
sortByProperty : function (property, direction, normalizer, context) {
    if (!property && this.separateFolders == false) {
        // if we were called without a sort-property and this.sortProp is set, use it...
        if (this.sortProp) property = this.sortProp;
        else property = this.titleProperty;
    }
    if (!direction) direction = this.sortDirection;
    this.setSort([{
        property: property,
        direction: (isc.isA.String(direction) ? direction :
            (direction == true) ? "ascending" : "descending"),
        normalizer: normalizer,
        context: context
    }]);
},

getSort : function () {
    return this._sortSpecifiers;
},

// helper APIs to track whether setSort() should be called on a subset (Array, ResultSet, etc.)
isSubsetSortDirty : function (subset) {
    return this._sortSpecifierCounter != subset._sortSpecifierCounter;
},
markSubsetSortDirty : function (subset) {
    delete subset._sortSpecifierCounter;
},
markSubsetAsSorted : function (subset) {
    subset._sortSpecifierCounter = this._sortSpecifierCounter;
},

_sortSpecifierCounter: 1,
setSort : function (sortSpecifiers) {
    // bump a counter each time setSort() is called
    this._sortSpecifierCounter++;

    if (!sortSpecifiers || !sortSpecifiers.length) {
        if (this.sortProp) {
            var direction = this.sortDirection;
            sortSpecifiers = [
                {
                    property: this.sortProp,
                    direction: (isc.isA.String(direction) ? direction :
                        (direction == true) ? "ascending" : "descending")
                }
            ];
        }
    } else {
        // duplicate the sortSpecifiers. We manipulate them directly
        // (adding sort-normalizer, for example) and we don't want upstream code
        // to be affected

        var dup = [];
        var ds = this.dataSource ? isc.DS.getDataSource(this.dataSource) : null;
        for (var i = 0; i < sortSpecifiers.length; i++) {
            var item = sortSpecifiers[i];
            if (item) {
                if (item.context  && !isc.isA.String(item.context)) {
                    var undef,
                        dsField = ds ? ds.getField(item.property) : null,
                        field = item.context.getField(item.property) || dsField;

                    var displayField = field && field.displayField;
                    if (displayField === undef) displayField = dsField && dsField.displayField;
                    var sortByDisplayField = field && field.sortByDisplayField;
                    if (sortByDisplayField === undef) sortByDisplayField = dsField && dsField.sortByDisplayField;

                    if (displayField && (sortByDisplayField != false)) {
                        var opDs = (field && field.optionDataSource) ||
                                    (dsField && dsField.optionDataSource);
                        if (opDs) {
                            opDs = isc.DataSource.getDataSource(field.optionDataSource);
                        }

                        if (!opDs || opDs == isc.DataSource.getDataSource(this.dataSource)) {
                        //if (!field.optionDataSource || opDs == isc.DataSource.getDataSource(this.dataSource)) {
                            this.logInfo("Field:" + field.name + " has displayField:" + displayField +
                                " (with optionDataSource:" + opDs + "). " +
                                "Sorting by displayField. Set field.sortByDisplayField to false to disable this.",
                                "sorting");
                            // store the original fieldName as the owningProperty - used when editing
                            // this sortSpecifier later, in a MultiSort[Panel/Dialog]
                            item.owningField = item.property;
                            if (!item.sortByField) {
                                item.property = field.displayField;
                            } else {
                                item.sortByProperty = field.displayField;
                            }
                        }
                    }
                }
                dup.add(isc.addProperties({}, item));
            }
        }
        sortSpecifiers = dup;
    }

    this._sortSpecifiers = sortSpecifiers;

    // mark as dirty so any list who points to us will be redrawn
    this._clearNodeCache(true);

    this._makeOpenNormalizer();

    // always hang onto the context
    this._sortContext = sortSpecifiers && sortSpecifiers.length > 0 ? sortSpecifiers[0].context : null;

    // call the dataChanged method to notify anyone who's observing it
    this.dataChanged();
},

//>    @method    tree._makeOpenNormalizer()    (A)
// Create a normalizer function according to the sortProp and sortDirection variables
//        @group    sorting
//<
_makeOpenNormalizer : function () {
    var tree = this,
        separateFolders = this.separateFolders != false,
        sortProps = this._sortSpecifiers,
        titleProperty = this.titleProperty;

    var folderPrefix,
        leafPrefix;
    if (this.sortFoldersBeforeLeaves) {
        folderPrefix = "0:";
        leafPrefix = "1:";
    } else {
        folderPrefix = "1:";
        leafPrefix = "0:";
    }

    sortProps.removeEmpty();
    if (sortProps.isEmpty()) {
        this._openNormalizer = isc.Class.NO_OP;
        return;
    }

    var propNames = sortProps.getProperty("property");


    if ((!separateFolders || propNames.length > 1 || !!propNames[0]) &&
        !propNames.contains(titleProperty))
    {
        propNames.add(titleProperty);
    }

    this._openNormalizer = function (obj, property) {
        if (tree == null || tree.destroyed) {
            tree = null;
            return;
        }

        var value = "";

        if (separateFolders) {
            value += (tree.isFolder(obj) ? folderPrefix : leafPrefix);
        }

        for (var i = 0; i < propNames.length; ++i) {
            var innerProp = propNames[i];
            if (!innerProp) continue;

            var isTitle = innerProp == titleProperty;

            var prop = isTitle ? tree.getTitle(obj) : obj[innerProp];
            if (prop == null) continue;


            if (isc.isA.Number(prop)) {
                if (prop > 0) {
                    prop = "1" + prop.stringify(12, true);
                } else {
                    prop = 999999999999 + prop;
                    prop = "0" + prop.stringify(12, true);
                }
            } else if (isc.isA.Date(prop)) {
                prop = prop.getTime();
            }

            if (isTitle) {
                value += String(prop).toLowerCase() + ":";
            } else {
                value += prop + ":";
            }
        }

        return value;
    };


    if (isc.Browser.isFirefox) {
        this._openAscendingComparator = function (first, second) {
            if (first == null || second == null) {
                return Array.compareAscending(first, second);
            }
            var m = first.length,
                n = second.length;
            if (m == 0 || n == 0) {
                return Array.compareAscending(first, second);
            }

            var i = 0,
                j = first.indexOf(":", i),
                k = 0,
                l = second.indexOf(":", k);
            if (j == -1) j = m;
            if (l == -1) l = n;

            for (;;) {
                var cmp = Array.compareAscending(
                    first.substring(i, j), second.substring(k, l));
                if (cmp != 0) {
                    return cmp;
                } else {
                    i = j + 1;
                    k = l + 1;
                    if (i >= m) {
                        if (k >= n) {
                            return 0;
                        } else {
                            return -1;
                        }
                    } else if (k >= n) {
                        return 1;
                    } else {
                        j = first.indexOf(":", i);
                        l = second.indexOf(":", k);
                        if (j == -1) j = m;
                        if (l == -1) l = n;
                    }
                }
            }
        };

        // Same as above, except with `compareDescending` instead of `compareAscending`,
        // `return 1` instead of `return -1`, and `return -1` instead of `return 1`.
        this._openDescendingComparator = function (first, second) {
            if (first == null || second == null) {
                return Array.compareDescending(first, second);
            }
            var m = first.length,
                n = second.length;
            if (m == 0 || n == 0) {
                return Array.compareDescending(first, second);
            }

            var i = 0,
                j = first.indexOf(":", i),
                k = 0,
                l = second.indexOf(":", k);
            if (j == -1) j = m;
            if (l == -1) l = n;

            for (;;) {
                var cmp = Array.compareDescending(
                    first.substring(i, j), second.substring(k, l));
                if (cmp != 0) {
                    return cmp;
                } else {
                    i = j + 1;
                    k = l + 1;
                    if (i >= m) {
                        if (k >= n) {
                            return 0;
                        } else {
                            return 1;
                        }
                    } else if (k >= n) {
                        return -1;
                    } else {
                        j = first.indexOf(":", i);
                        l = second.indexOf(":", k);
                        if (j == -1) j = m;
                        if (l == -1) l = n;
                    }
                }
            }
        };
    }
    return;
},

// Loading batches of children: breadth-first loading up to a maximum
// ---------------------------------------------------------------------------------------

loadBatchSize:50,
loadSubtree : function (node, max, initTime) {
    if (!node) node = this.getRoot();
    if (max == null) max = this.loadBatchSize;

    //this.logWarn("loading subtree of node: " + this.echoLeaf(node) +
    //             "up to max: " + max);

    this._loadingBatch = initTime ? 2 : 1;

    var count = 0,
        stopDepth = 1;
    // load at increasing depth until we hit max or run out of children
    while (count < max) {
        var numLoaded = this._loadToDepth(max, node, count, stopDepth++);
        if (numLoaded == 0) break; // nothing left to load
        count += numLoaded;
    }

    this._loadingBatch = null;

    if (count > 0) this._clearNodeCache(true);
},

// allows loadChildren() to detect we're loading a batch of children and defer loading a folder
// that doesn't have interesting children
loadingBatch : function (initOnly) {
    if (initOnly) return this._loadingBatch == 2;
    else return this._loadingBatch;
},

_loadToDepth : function (max, node, count, stopDepth) {

    var numLoaded = 0;
    if (!this.isOpen(node)) {
        if (!this.isLoaded(node)) this.loadChildren(node);

        // NOTE: we assume that during batch loading, folders can decline to actually load or
        // open, and these should remain closed
        if (this.isLoaded(node)) {
            if (this.openFolder(node) === false) return numLoaded;
        }

        var nodeChildren = node[this.childrenProperty];
        if (nodeChildren) {
            var nodeChildrenLength = (isc.isA.ResultSet(nodeChildren) ?
                    nodeChildren._getCachedLength() : nodeChildren.getLength());
            numLoaded += nodeChildrenLength;
            count += nodeChildrenLength;
        }
    }

    var childNodes = node[this.childrenProperty];

    if (count >= max || stopDepth == 0 || childNodes == null) return numLoaded;

    var length = (isc.isA.ResultSet(childNodes) ?
            childNodes._getCachedLength() : childNodes.getLength());
    for (var i = 0; i < length; ++i) {
        var child = childNodes.getCachedRow(i);
        if (child != null) {
            var loaded = this._loadToDepth(max, child, count, stopDepth - 1);

            numLoaded += loaded;
            count += loaded;

            //this.logWarn("recursed into: " + this.getTitle(child) +
            //             " and loaded: " + loaded +
            //             ", total count: " + count);

            if (count >= max) return numLoaded;
        }
    }
    return numLoaded;
},

// Tree Filtering
// ---------------------------------------------------------------------------------------

//> @attr tree.dataSource (DataSource | ID : null : IR)
// Specifies what +link{DataSource} this tree is associated with.
// <P>
// A +link{dataSource} is required when filtering a tree, even if it isn't a +link{ResultTree},
// though it may be passed to +link{getFilteredTree()} rather than set on the tree itself.  If
// a +link{dataSource} is specified it will also affect sorting, where relevant, such as if the
// tree is set as +link{treeGrid.data}.
//
// @see dataBoundComponent.dataSource
// @group treeFilter
// @visibility external
//<

//> @method tree.getFilteredTree()
// Filters this tree by the provided criteria, returning a new Tree containing just the nodes
// that match the criteria.
// <P>
// If <code>filterMode</code> is "keepParents", parents are retained if
// any of their children match the criteria even if those parents do not match the criteria.
// <P>
// Note that the +link{dataSource} argument is <b>required</b> if one is not
// +link{dataSource,already specified} on the tree.
// <P>
// If you want a +link{TreeGrid} with local tree data that supports filtering, please consider
// using a +link{TreeGrid} bound to a +link{dataSource.clientOnly,client-only DataSource}
// rather than writing your own code to filter the tree's data with this method.
//
// @param criteria (Criteria or AdvancedCriteria) criteria to filter by
// @param [filterMode] (TreeFilterMode) mode to use for filtering, defaults to "strict"
// @param [dataSource] (DataSource) dataSource to use for filtering, if this Tree does not
//                                  already have one
// @param [requestProperties] (DSRequest) Request properties block. This allows developers to
//     specify properties that would impact the filter such as +link{DSRequest.textMatchStyle}
// @return (Tree) filtered tree
//
// @see TreeGrid.setCriteria()
// @see TreeGrid.filterData()
// @see ResultTree
// @group treeFilter
// @visibility external
//<
getFilteredTree : function (criteria, filterMode, dataSource, context) {
    filterMode = filterMode || isc.Tree.STRICT;

    var dataSource = this.dataSource || dataSource;
    if (!dataSource) {
        isc.logWarn("Cannot apply filter to Tree without dataSource");
        return null;
    }

    // Filter the tree in-place to avoid moving nodes around as we add
    // missing parent nodes back in place. We also retain loadState.
    var tree = this.duplicate(true, true);
    if (isc.ResultTree && isc.isA.ResultTree(tree) && tree.isPaged()) {
        tree.setCriteria(isc.DataSource.combineCriteria(criteria, tree.criteria));
    }
    tree._filterChildren(criteria, filterMode, dataSource, tree.getRoot(), context);
    return tree;
},

// Returns true if any children match criteria
_filterChildren : function (criteria, filterMode, dataSource, parent, context) {

    var strict = (filterMode == isc.Tree.STRICT),
        keepParents = !strict;

    var children = parent[this.childrenProperty];
    if (children == null || children.isEmpty()) return false;

    var haveMatchingNodes = false;

    if (isc.isA.String(dataSource)) dataSource = isc.DS.get(dataSource);


    var isResultSet = isc.isA.ResultSet(children);
    strict = strict || isResultSet;

    var i = (isResultSet ? children._getCachedLength() : children.getLength());
    while (i--) {
        var node = children.getCachedRow(i);
        if (node != null) {
            var hasImmediateMatches = false,
                nodeChildren = node[this.childrenProperty];

            if (keepParents) {
                if (nodeChildren != null && !nodeChildren.isEmpty()) {
                    hasImmediateMatches = this._filterChildren(criteria, filterMode, dataSource, node, context);
                }
                haveMatchingNodes = haveMatchingNodes || hasImmediateMatches;
            }

            // Don't have to filter parent node (this child) if keeping parent nodes
            // and there are matching children.
            if (!hasImmediateMatches || strict) {

                var matches = dataSource.applyFilter([node], criteria, context);
                if (matches != null && matches.length > 0) {
                    haveMatchingNodes = true;

                    if (strict && nodeChildren != null && !nodeChildren.isEmpty()) {
                        this._filterChildren(criteria, filterMode, dataSource, node, context);
                    }
                } else {
                    this._remove(node, parent, children, i);
                }
            }
        }
    }
    return haveMatchingNodes;
},


_includeNodeLengthInParent : function (node, parent) {

    // The parent must be open.
    return this.isOpen(parent);
},


_isNodeVisibleToParent : function (node, parent) {
    if (!this._includeNodeLengthInParent(node, parent)) {
        return false;
    } else {
        // Even if the node is technically a folder, if it has no children then, at this point,
        // it is treated as a leaf.
        var grandChildren = node[this.childrenProperty],
            isFolder = this.isFolder(node) && (grandChildren && grandChildren.length);
        return (this.openDisplayNodeType != (isFolder ? isc.Tree.LEAVES_ONLY : isc.Tree.FOLDERS_ONLY));
    }
},


_getNodeLengthToParent : function (node, parent) {


    if (this._includeNodeLengthInParent(node, parent)) {

        var length = node[this._cachedLengthProperty],
            grandChildren = node[this.childrenProperty],
            isFolder = this.isFolder(node),
            treatAsFolder = (grandChildren && grandChildren.length);

        // Even if the node is technically a folder, if it has no children then, at this point,
        // it is treated as a leaf.  This can result in a difference of +/-1 in the length of
        // the node according to the parent.
        if (isFolder != treatAsFolder) {
            length += (
                -(this.openDisplayNodeType != (isFolder ? isc.Tree.LEAVES_ONLY : isc.Tree.FOLDERS_ONLY) ? 1 : 0) +
                (this.openDisplayNodeType != (treatAsFolder ? isc.Tree.LEAVES_ONLY : isc.Tree.FOLDERS_ONLY) ? 1 : 0));
        }

        return length;
    } else {
        return 0;
    }
},

_getNodeLength : function (node) {
    var isFolder = this.isFolder(node),
        isOpen = isFolder && this.isOpen(node),
        length = (this.openDisplayNodeType != (isFolder ? isc.Tree.LEAVES_ONLY :
                                                          isc.Tree.FOLDERS_ONLY) ? 1 : 0);
    if (isOpen) {
        var childrenInOpenList = this.getChildren(node, this.openDisplayNodeType, null,
                this.sortDirection, this.openListCriteria, this._sortContext, null, null, true),
            loadingMarker = (
                isc.ResultSet != null ? isc.ResultSet.getLoadingMarker() : null),
            i = (isc.ResultSet != null && isc.isA.ResultSet(childrenInOpenList) ?
                childrenInOpenList._getCachedLength() : childrenInOpenList.getLength());


        var pagedResultTree = (
                isc.ResultTree != null && isc.isA.ResultTree(this) && this.isPaged()),
            knownLengthNulls = pagedResultTree;
        if (pagedResultTree) {
            var openSubfoldersAllowed = (
                    node[this.canReturnOpenSubfoldersProperty] != null ?
                    node[this.canReturnOpenSubfoldersProperty] : this.canReturnOpenFolders),
                defaultChildLength = (
                    this.openDisplayNodeType == isc.Tree.FOLDERS_AND_LEAVES ? 1 : 0);

            knownLengthNulls = !(openSubfoldersAllowed || defaultChildLength == 0);
        }

        while (i--) {
            var child = childrenInOpenList.getCachedRow(i);
            if (child != null && child != loadingMarker) {
                length += this._getNodeLengthToParent(child, node);
            } else if (knownLengthNulls) {
                ++length;
            }
        }
    }

    return length;
},


_getDeltaLength : function (node, wasFolder, isFolder) {
    if (wasFolder != isFolder) {
        var wasLeaf = !wasFolder,
            isLeaf = !isFolder,
            deltaLength = (
                // The node was a folder (leaf) and now is no longer a folder (leaf)
                // so subtract 1 from the length if the node was displayed in the
                // open list.
                -((wasLeaf && this.openDisplayNodeType != isc.Tree.FOLDERS_ONLY) ||
                (wasFolder && this.openDisplayNodeType != isc.Tree.LEAVES_ONLY) ? 1 : 0) +

                // The node is a new folder (leaf) so add 1 if it is now going to be
                // displayed in the open list.
                ((isLeaf && this.openDisplayNodeType != isc.Tree.FOLDERS_ONLY) ||
                (isFolder && this.openDisplayNodeType != isc.Tree.LEAVES_ONLY) ? 1 : 0));


        return deltaLength;
    } else {
        return 0;
    }
},


_updateParentLengths : function (parent, deltaLength) {

    if (deltaLength != 0) {
        for (;;) {

            parent[this._cachedLengthProperty] += deltaLength;
            var recursionFlag = ((parent[this._recursionCountProperty] || 0) > 0);
            if (!(parent == this.root || recursionFlag)) {
                var grandParent = this.getParent(parent);
                if (this._includeNodeLengthInParent(parent, grandParent)) {
                    parent = grandParent;
                    continue;
                }
            }
            break;
        }
    }
}
});    // END isc.Tree.addMethods()

isc.Tree.addClassMethods({
    // Tree Discovery
    // ---------------------------------------------------------------------------------------
    // utilities for discovering the tree structure of a block of data heuristically

    // heuristically find a property that appears to contain child objects.
    // Searches through an object and find a property that is either Array or Object valued.
    // Returns the property name they were found under.
    // mode:
    // "any" assume the first object or array value we find is the children property
    // "array" assume the first array we find is the children property, no matter the contents
    // "object" assume the first object or array of objects we find is the children property
    //          (don't allow arrays that don't have objects)
    // "objectArray" accept only an array of objects as the children property
    findChildrenProperty : function (node, mode) {
        if (!isc.isAn.Object(node)) return;

        if (!mode) mode = "any";

        var any = (mode == "any"),
            requireObject = (mode == "object"),
            requireArray = (mode == "array"),
            requireObjectArray = (mode == "objectArray");

        for (var propName in node) {
            var propValue = node[propName];
            // note: isAn.Object() matches both Array and Object
            if (isc.isAn.Object(propValue)) {
                if (any) return propName;
                if (isc.isAn.Array(propValue)) {
                    // array of objects always works
                    if (isc.isAn.Object(propValue[0])) return propName;
                    // simple array satisfies all but "object" and "objectArray"
                    if (!requireObject && !requireObjectArray) return propName;
                } else {
                    // object works only for "object" and "any" ("any" covered above)
                    if (requireObject) return propName;
                }
            }
        }
    },

    // given a hierarchy of objects with children under mixed names, heuristically discover the
    // property that holds children and copy it to a single, uniform childrenProperty.  Label each
    // discovered child with a configurable "typeProperty" set to the value of the property
    // that held the children.
    discoverTree : function (nodes, settings, parentChildrenField) {
        if (!settings) settings = {}; // less null checks

        var childrenMode = settings.childrenMode || "any";

        // scanMode: how to scan for the childrenProperty
        // "node": take each node individually
        // "branch": scan direct siblings as a group, looking for best fit
        // "level": scan entire tree levels as a group, looking for best fit
        var scanMode = settings.scanMode || "branch";

        // tieMode: what to do if there is more than one possible childrenProperty when using
        // scanMode "branch" or "level"
        // "node": continue, but pick childrenProperty on a per-node basis (will detect
        //             mixed)
        // "highest": continue, picking the childrenProperty that occurred most as the single
        //            choice
        // "stop": if there's a tie, stop at this level (assume no further children)
        // NOT SUPPORTED YET: "branch": if using scanMode:"level", continue but with scanMode
        //                              "branch"
        var tieMode = settings.tieMode || "node";

            // what to rename the array of children once discovered
        var newChildrenProperty = settings.newChildrenProperty ||
                                  isc.Tree.getInstanceProperty("childrenProperty"),
            typeProperty = settings.typeProperty || "nodeType",
            // for string leaf nodes (if allowed), what property to store the string under in
            // the auto-created object
            nameProperty = settings.nameProperty || "name";

        if (!isc.isAn.Array(nodes)) nodes = [nodes];

        // go through all the nodes on this level and figure out what property occurs most
        // often as a children property.  This allows us to handle edge cases where the
        // property occurs sometimes as an Array and sometimes singular
        var globalBestCandidate;
        if (scanMode == "level" || scanMode == "branch") {
            var candidateCount = {};
            for (var i = 0; i < nodes.length; i++) {
                var node = nodes[i],
                    childrenProperty = null;

                // optimization: this node was up-converted from a String, it can't have
                // children
                if (node._fromString) continue;

                childrenProperty = this.findChildrenProperty(node, childrenMode);

                if (childrenProperty == null) continue;

                candidateCount[childrenProperty] = (candidateCount[childrenProperty] || 0);
                candidateCount[childrenProperty]++;
            }
            var counts = isc.getValues(candidateCount),
                candidates = isc.getKeys(candidateCount);

            if (candidates.length == 0) {
                // no children property could be found
                return;
            } else if (candidates.length == 1) {
                // use the only candidate
                globalBestCandidate = candidates[0];
            } else if (tieMode == "node") {
                // multiple candidates found, don't set globalBestCandidate and we will
                // automatically go per-node
            } else if (tieMode == "stop") {
                return;
            } else { // tieMode == "highest"
                // pick highest and proceed
                var max = counts.max(),
                    maxIndex = counts.indexOf(max);
                globalBestCandidate = candidates[maxIndex];
            }

            //this.logWarn("counts are: " + this.echo(candidateCount) +
            //             ", globalBestCandidate: " + globalBestCandidate);
        }

        var allChildren = [];
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];

            // default to the globalBestCandidate if there is one
            var bestCandidate = globalBestCandidate;

            if (node._fromString) continue; // can't have children

            // determine the best children property individually per node if we haven't already
            // determined it by scanning all nodes
            if (!bestCandidate) {
                bestCandidate = this.findChildrenProperty(node, childrenMode);
                //this.logWarn("individual bestCandidate: " + bestCandidate +
                //             " found for node: " + this.echo(node));
            }

            // no children found
            if (bestCandidate == null) continue;

            // normalize children to an Array (even if absent, if a single bestCandidate
            // property was determined for the level)
            var children = node[bestCandidate];
            if (children != null && !isc.isAn.Array(children)) children = [children];
            else if (children == null) children = [];

            // copy discovered children to the normalized childrenProperty
            node[newChildrenProperty] = children;

            // mark all children with a "type" property indicating the property they were found
            // under.  Needed because this information is missing once we normalize all children
            // arrays to appear under the same property name
            for (var j = 0; j < children.length; j++) {
                var child = children[j];
                // if we end up with Strings in the children (valid only with childrenMode
                // "array") auto-convert them to Objects
                if (isc.isA.String(child)) {
                    children[j] = child = {
                        name:child,
                        _fromString:true
                    }
                }
                child[typeProperty] = bestCandidate;
            }

            // proceed with this node's children
            if (scanMode == "level") {
                allChildren.addAll(children);
            } else {
                this.discoverTree(children, settings, bestCandidate);
            }
        }
        if (scanMode == "level" && allChildren.length > 0) this.discoverTree(allChildren, settings);
    },

    getCleanNodeData : function (nodeList, includeChildren, cleanChildren, includeLoadState,
                                tree)
    {
        if (nodeList == null) return null;

        var nodes = [], wasSingular = false;
        if (!isc.isAn.Array(nodeList)) {
            nodeList = [nodeList];
            wasSingular = true;
        }

        // known imperfections:
        // - by default, isFolderProperty is "isFolder", we write this into nodes and sent it when
        //   saving
        // - we create empty children arrays for childless nodes, and save them

        for (var i = 0; i < nodeList.length; i++) {
            var treeNode = nodeList[i],
                node = {};
            if (tree == null) {
                var treeID = treeNode._isc_tree;
                if (treeID) tree = window[treeID];
            }

            // copy the properties of the tree node, dropping some Tree/TreeGrid artifacts
            for (var propName in treeNode) {

                if ((tree != null && propName == tree.parentProperty) ||
                    // currently hardcoded
                    (!includeLoadState && propName == "_loadState") ||
                    // Explicit false passed as 'includeChildren' param.
                    (includeChildren == false && tree && propName == tree.childrenProperty) ||

                    propName == "_isc_tree" ||

                    propName == "__ref" ||
                    propName == "__module" ||

                    // class of child nodes, set up by ResultTree
                    propName == "_derivedChildNodeType" ||

                    propName == "_autoAssignedName"




                    )
                {
                    continue;
                } else if (propName.startsWith("_") && (
                    // all the internal metadata attributes start with an underscore

                    // default nameProperty from ResultTree, which by default does not have
                    // meaningful node names
                    propName.startsWith("__nodePath") ||
                    // the openProperty and isFolderProperty are documented and settable, and if
                    // they've been set should be saved, so only remove these properties if they
                    // use the prefix that indicates they've been auto-generated (NOTE: this prefix
                    // is obfuscated)
                    propName.startsWith("_isOpen_") ||
                    propName.startsWith("_isFolder_") ||

                    // shared nodes may have parentProperty from other trees
                    propName.startsWith("_parent_") ||

                    // from selection model
                    propName.startsWith("_selection_") ||

                    // from grouped grid
                    propName.startsWith("_groupTree_") ||

                    // Do not copy the precalculated length of the tree node.
                    propName.startsWith("_cachedLength_") ||

                    // Do not copy a recursion flag on the tree node.
                    propName.startsWith("_recursionCount_") ||

                    // Do not copy a flag used for paged ResultTrees.
                    propName.startsWith("_visibleDescendantsCached_") ||

                    // Do not copy temporary state used during initial loads of children.
                    propName.startsWith("_initialLoadingState_") ||
                    propName.startsWith("_initialLoadingFetchCount_") ||

                    // from TileGrid
                    propName.startsWith("_tileID_"))
                    )
                {
                    continue;
                }
                node[propName] = treeNode[propName];

                // Clean up the children as well (if there are any)
                if (cleanChildren &&
                    tree &&
                    propName == tree.childrenProperty &&
                    isc.isAn.Array(node[propName]))
                {
                    node[propName] = isc.Tree.getCleanNodeData(node[propName],
                                                               includeChildren, cleanChildren,
                                                               includeLoadState, tree);
                }
            }
            nodes.add(node);
        }
        if (wasSingular) return nodes[0];
        return nodes;
    }
});







//>    @class    Selection
//
// Maintains a 'selected' subset of a List or Array of objects, such as records in a record
// set, or widgets in a selectable header.
// <p>
// Includes methods for selecting objects and checking which objects are selected, and also for
// selecting objects as a result of mouse events, including drag selection support.
// The selection object is used automatically to handle selection APIs on +link{class:ListGrid}
// and +link{class:TreeGrid} instances.
// <p>
// Note that selection and deselection are skipped for objects that aren't enabled, or that are
// marked as non-selectable.  For a +link{ListGrid}, the relevant properties are
// +link{ListGrid.recordEnabledProperty} and +link{ListGrid.recordCanSelectProperty}.  The
// recommended approach to affect disabled objects via the Selection APIs is to temporarily
// enable them beforehand.
//
// @visibility external
// @see ListGrid.selection
// @see DataBoundComponent.selectRange()
// @see DataBoundComponent.selectRecord()
// @treeLocation Client Reference/System
//<


//
//    create the Selection class
//
isc.ClassFactory.defineClass("Selection");

// add default properties to the class
isc.Selection.addProperties({
    //> @attr selection.selectionProperty (String : null : [IRA])
    // Property to use to mark records as selected.
    // <P>
    // Defaults to an auto-generated property name that starts with an underscore.
    // @visibility serverSelection
    //<
    //selectionProperty:null,

    //>@attr selection.data (Array | List : null : [IRWA])
    //  The set of data for which selection is being managed.  If not specified at init time
    //  this can be set up via the <code>selection.setData()</code> method.
    // @visibility serverSelection
    //<

    //> @attr selection.enabledProperty (String : "enabled" : [IRA])
    // Property used to indicated records as being disabled (therefore unselectable).
    //<

    enabledProperty:"enabled",

    //> @attr selection.canSelectProperty (string : "canSelect" : [IRA])
    // If set to false on a item, selection of that item is not allowed.
    //<

    canSelectProperty:"canSelect",

    //> @attr selection.cascadeSelection (boolean : false : [IRA])
    // Should children be selected when parent is selected? And should parent be
    // selected when any child is selected?
    // <p>
    // Note: Unloaded children are not affected and no load-on-demand is triggered.
    //<
    cascadeSelection:false,

    // _dirty - manages whether we need to update the cache of selected records.
    _dirty:true


});

isc.Selection.addClassProperties({
    //>    @type    SelectionStyle
    //    Different styles of selection that a list, etc. might support
    //        @visibility external
    //        @group    selection
    //
    //    @value    isc.Selection.NONE        don't select at all
    NONE :         "none",
    //    @value    isc.Selection.SINGLE    select only one item at a time
    SINGLE:        "single",
    //    @value    isc.Selection.MULTIPLE    select one or more items
    MULTIPLE:    "multiple",
    //    @value    isc.Selection.SIMPLE    select one or more items as a toggle
    //                                   so you don't need to hold down control keys to select
    //                                  more than one object
    SIMPLE:        "simple",
    //<

    // for generating unique IDs for each Selection
    _selectionID : 0
});


isc.Selection.addMethods({

//>    @method    selection.init()    (A)
//  Initialize this selection instance.<br>
//  Note: if the <code>data</code> property is not set at init time, it should be passed to
//  the selection using the <code>selection.setData</code> method
//        @group    selection
//        @param    [all arguments]    (object)    objects with properties to override from default
// @visibility serverSelection
//<
init : function () {
    this._cache = [];

    // get unique ID and selection properties
    var initialSelectionProperty = this.selectionProperty;
    if (!initialSelectionProperty) this.selectionProperty = "_selection_" + isc.Selection._selectionID++;
    this.partialSelectionProperty = "_partial" + this.selectionProperty;

    // set the data object so we get notification for add and delete, etc.
    // NOTE: if the data object wasn't set, use a new array.
    this.setData(this.data ? this.data : []);

    // if the selectionProperty was generated, then no records can be selected initially and
    // the full selection cache is not dirty.
    if (!initialSelectionProperty) this._dirty = false;
},

// override destroy to clean up pointers to this.data
destroy : function () {
    if (this.data) this.ignoreData(this.data);
    delete this.data;

    // selections aren't stored in global scope so no need to clear window[this.ID]
    this.Super("destroy", arguments);
},

//>    @method    selection.setData()
//            Initialize selection data.<br><br>
//            Call this method to associate the selection with a different data object.<br>
//          <i>Note: No need to call this if the contents of the selection's data is modified</i>
//        @group    selection
//        @param        newData    (array)        new data to maintain selection in
// @visibility serverSelection
//<
setData : function (newData) {

    // if we are currently pointing to data, stop observing it
    if (this.data != null) this.ignoreData(this.data);

    // remember the new data
    this.data = newData;

    // observe the new data so we will update automatically when it changes
    if (this.data != null) this.observeData(this.data);

    // Note that any cache we have is out of date.
    this.markForRedraw();
},


//>    @method    selection.observeData()    (A)
//            Observe methods on the data so we change our state.
//            Called automatically by selection.setData().
//            Observes the data.dataChanged() method to invalidate the selection cache
//        @group    selection
//
//
//    @param    data    (array)        new data to be observed
// @visibility internal
//<
observeData : function (data) {
    var isRS = isc.ResultSet && isc.isA.ResultSet(data);
    if (isRS) {
        this.observe(data, "dataChanged", function (operationType, originalRecord, rowNum, updateData, filterChanged, dataFromCache) {
            this.dataChanged(operationType, originalRecord, rowNum, updateData, filterChanged, dataFromCache);
        });
    } else {
        this.observe(data, "dataChanged", function () {
            this.dataChanged();
        });
    }

    if (data.dataArrived) {
        if (isRS) {
            this.observe(data, "dataArrived", function (startRow, endRow, dataFromCache) {
                this.dataArrived(startRow, endRow, dataFromCache);
            });
        } else {
            this.observe(data, "dataArrived", function () {
                this.dataChanged();
            });
        }
    }
},

//>    @method    selection.ignoreData()    (A)
//            Stop observing methods on data when it goes out of scope.
//            Called automatically by setData
//        @group    selection
//
//        @param    data    (array)        old data to be ignored
// @visibility internal
//<
ignoreData : function (data) {
    if (!data) return;
    if (this.isObserving(data, "dataChanged")) this.ignore(data, "dataChanged");
    if (this.isObserving(data, "dataArrived")) this.ignore(data, "dataArrived");
},

// dataChanged implementation performs a couple of tasks:
// - reselectOnUpdate attribute set by DBC. If set, reapply selection when
//   an updated record is folded back into the ResultSet cache
// - if the dataChange is due to a local filter revealing new records that were
//   in the ResultSet's local cache but hidden due to non-matching criteria,
//   wipe any "selected" property from them so we don't have odd stale-seeming
//   selections popping up on refilter.
// - wipe our complete selection cache to account for records that may have been
//   removed from this.data
dataArrived : function (startRow,endRow,dataFromCache) {
    if (!this.data) return;


    var updateOp,
        originalRecord,
        updateData,
        rowNum,
        filterChanged;
    if (this.data._isChangingData() && isc.isA.ResultSet(this.data)) {
        updateOp = this.data._lastUpdateOperation;
        updateData = this.data._lastUpdateData;
        originalRecord = this.data._lastOrigRecord;
        rowNum = this.data._lastUpdateRow;

    }

    this.dataChanged(updateOp, originalRecord, rowNum, updateData, false, dataFromCache);
    // This method can fire from ResultSet dataChanged doing a filterLocalData()
    // In this case, suppress the next dataChanged() which fires at the end of the
    // resultSet 'dataChanged' method

    if (this.data._isChangingData()) {
        this._ignoreNextDataChanged = true;
    }
},

dataChanged : function (operationType,originalRecord,rowNum,updateData,filterChanged,dataFromCache) {
    if (this._ignoreNextDataChanged) {
        delete this._ignoreNextDataChanged;
        return;
    }

    if (this.reselectOnUpdate && operationType == "update" && originalRecord != null &&
        originalRecord[this.selectionProperty])
    {

        var modifiedRecord = this.data.findByKey(originalRecord);
        if (modifiedRecord) this.performReselectOnUpdate(modifiedRecord);

    // 'dataFromCache' param - only applies to resultSets:
    // Implies the change of data was satisfied from a client side cache of records
    // rather than fresh data coming from the server, and as such we (the selection)
    // may have already seen these records and marked as selected.
    // If this is the case, the selected property should be considered stale and
    // cleared.
    // Use case: A record was selected in a resultSet, the criteria were changed
    // such that it was removed from the filtered data (but retained in
    // the client-side "allRows" cache), then the criteria changed again such that
    // the record is re-introduced into the filtered data set
    // We have to treat as stale - otherwise it's easy to run into bugs such as
    // selectionType:"single" widgets ending up with multiple selected rows.
    } else if (dataFromCache) {

        if (this._dirty) this.cacheSelection();
        // return the cached selection list if possible
        var selection = this._cache,
            newCache = [],
            data = this.getItemList(),
            length = data.getLength();

        if (selection == null ||
            isc.isA.ResultSet != null && isc.isA.ResultSet(data) && !data.lengthIsKnown()) {
        } else {
            for (var i = 0; i < length; i++) {
                // getCachedRow won't trigger fetches if working with a remote dataset
                var item = data.getCachedRow(i),
                    selected = item == null ? false :


                        !!item[this.selectionProperty];

                var inCache;
                if (selected) {
                    inCache = selection.contains(item);
                    if (inCache) {
                        newCache.add(item);
                    } else {

                        item[this.selectionProperty] = false;
                    }
                }
                // If the record is not marked as selected, nothing to do
            }


        }
    }
    this.markForRedraw();
},


performReselectOnUpdate : function (modifiedRecord) {
    this.select(modifiedRecord);
},

//>    @method    selection.markForRedraw()
//            Mark the selection as dirty, so it will be recalculated automatically
//        @group    selection
// @visibility internal
//<
markForRedraw : function () {
    this._dirty = true;
    this._openCache = null;
},

//>    @method    selection.isSelected()
// Return true if a particular item is selected
//
// @param item (object) object to check
// @return (boolean) true == object is selected, false == object is not selected
// @group selection
// @visibility external
//<
// @param [onlyOpen] (Boolean) if we only require searching among open nodes when the data
// is a Tree. For example, in drawing the body of a TreeGrid, we need to know whether an open
// node is selected, so we call isSelected() with onlyOpen = true. This is an optimization
// for large sorted trees.
isSelected : function (item, onlyOpen) {
    // If the data is not a tree or cascade selection is enabled, then set onlyOpen to false.
    // onlyOpen makes sense for trees only, where it is an optimization hint to consider only
    // the open nodes.
    // Cascade selection is fundamentally incompatible with onlyOpen because if a partially
    // selected node is closed, we still want to know whether the closed children of the node
    // are selected so that they may be selected or deselected.
    if (onlyOpen && (this.cascadeSelection || !isc.isA.Tree(this.data))) {
        onlyOpen = false;
    }

    if (this._dirty && !(onlyOpen == true && this._openCache != null) && !this._cachingSelection) {
        this.cacheSelection(onlyOpen);
    }



    if (item == null) return false;

    return !!item[this.selectionProperty];
},

//> @method selection.isPartiallySelected()
// When using tree-oriented selection modes like +link{treeGrid.cascadeSelection}, returns true
// if the record is considered partially selected because only some of it's children are
// selected.
//
// @param  item    (object)  object to check
// @return (boolean)      true == object is partially selected
//                        false == object is not partially selected
// @group  selection
// @visibility external
//<
isPartiallySelected : function (item) {


    if (this._dirty && !this._cachingSelection) this.cacheSelection();
    if (item == null) return false;

    return !!item[this.partialSelectionProperty];
},


//>    @method    selection.anySelected()
// Whether at least one item is selected
//        @group    selection
//
//        @return        (boolean)    true == at least one item is selected
//                                false == nothing at all is selected
// @visibility external
//<
anySelected : function () {
    // return if the selection is non-empty
    return this._getSelection().length > 0;
},

//>    @method    selection.getLength()
// Returns the number of selected records.
//
// @return (int) number of selected records
// @group selection
// @visibility external
//<
getLength : function () {
    return this._getSelection().length;
},


//>    @method    selection.multipleSelected()
//    Whether multiple items are selected
//        @group    selection
//
//        @return        (boolean)    true == more than one item is selected
//                                false == no items are selected, or only one item is selected
// @visibility external
//<
multipleSelected : function () {
    return this._getSelection().length > 1;
},


//> @method selection.getSelection()
// Return an ordered array of all of the selected items
// @param [excludePartialSelections] (Boolean) When true, partially selected records will not be returned.
//                                   Otherwise, all fully and partially selected records are
//                                   returned.
// @return (array) list of selected items
// @group selection
// @visibility external
//<
getSelection : function (excludePartialSelections, dontSort) {
    var selection = this._getSelection(excludePartialSelections, dontSort);
    // duplicate the selection so subsequent manipulation of our cache doesn't confuse
    // callers.

    return selection.duplicate();
},
_getSelection : function (excludePartialSelections, dontSort) {
    // if the selection is dirty, cache it again
    if (this._dirty) {
        if (this._cachingSelection) this._cachingSelection = false;
        this.cacheSelection(false, dontSort);
    }

    // return the cached selection list if possible
    var selection = this._cache;
    // If partial selections are excluded, built a new list of full selections only.
    if (excludePartialSelections && selection != null && selection.length > 0) {
        var cache = this._cache;
        selection = [];

        // Cache includes both fully and partially selected nodes.
        for (var i = 0; i < cache.length; i++) {
            var item = cache[i];
            if (!this.isPartiallySelected(item)) {
                selection[selection.length] = item;
            }
        }
    }



    return selection;
},


//>    @method    selection.getSelectedRecord()
//            Return the first item in the list that is selected.<br><br>
//
//            Note that this should only be used if you know that one only one item
//             may be selected, or you really don't care about items after the first one.<br><br>
//
//            To get all selected objects, use <code>+link{method:selection.getSelection()}</code>
//        @group    selection
//
//        @return        (object)    first selected record, or null if nothing selected
// @visibility external
//<
getSelectedRecord : function () {
    var selection = this._getSelection();
    if (selection && selection.length > 0) return selection[0];
},


//>    @method    selection.cacheSelection()    (A)
// Cache the selected records since we operate on it so often.
// Sets an internal variable _cache to hold the selection.
// @group selection
// @visibility internal
//<

accessResultSetCache:true,
cacheSelection : function (onlyOpen, dontSort) {


    // Don't allow this method to fire recursively, or in response to 'setSelection'
    // if we're marked as dirty
    if (this._settingSelected || this._suppressCaching) {

        return;
    } else if (this._cachingSelection) {

        return;
    }
    // create a new array to hold the cached selection
    // When onlyOpen is true, we create an "openCache", which is a list of all selected open
    // nodes. As long as we're only interested in the open nodes, we can use the openCache
    // if available.
    var cache;
    if (onlyOpen) {
        cache = this._openCache = [];

    } else {

        cache = this._cache = [];
        this._openCache = null;
    }

    var data = this.getItemList(onlyOpen, dontSort);

    // This is critical path code - for maximum efficiency, if we're working with a
    // ResultSet, look directly at its localData array rather than going through the
    // getCachedRow() API
    // undocumented accessResultSetCache attribute allows us to turn this optimization
    // off for cases where it won't work (EG custom class which implements the List interface)
    var isRSCache = false;
    if (this.accessResultSetCache && isc.isA.ResultSet(data)) {
        isRSCache = true;
        data = data.localData || [];
    }
    var useGetCachedRow = !isc.isAn.Array(data),
        length = data.getLength();


    if (isc.isA.ResultSet != null && isc.isA.ResultSet(data) && !data.lengthIsKnown()) {
        this._dirty = false;
        return;
    }
    this._cachingSelection = true;
    this._cachingOnlyOpen = onlyOpen;

    // iterate over the records of the list, selecting those that have the selection property set
    // Critical path - avoid the "cascadeSelection" logic if it doesn't apply
    if (this.cascadeSelection) {
        var delayCache = false;
        for (var i = 0; i < length; i++) {

            // getCachedRow won't trigger fetches if working with a remote dataset
            var item = useGetCachedRow ? data.getCachedRow(i) : data[i];
            if (item != null && item !== Array.LOADING && this.isSelected(item, onlyOpen)) {
                // If cascadeSelection is true and new data has arrived, it may be
                // selected. In this case we need to update the 'partial' selected state
                // of parents, and the selected state of descendents.
                // To handle this - call 'setSelected' with the flag to force a recalculation of
                // cascading selection, and then loop through all records a second time, updating
                // cache.

                if (!this.isPartiallySelected(item)) {
                    this.setSelected(item, true, null, true);
                    delayCache = true;
                }
                if (!delayCache) {
                    cache[cache.length] = item
                }
            }
        }
        // cascading selection - we may have actually manipulated our selection to mark
        // parents as partially selected / children as entirely selected - loop through all
        // nodes again!
        if (delayCache) {
            if (onlyOpen) {
                cache = this._openCache = [];

            } else {
                cache = this._cache = [];
                this._openCache = null;
            }
            for (var i = 0; i < length; i++) {

                // getCachedRow won't trigger fetches if working with a remote dataset
                var item = useGetCachedRow ? data.getCachedRow(i) : data[i];
                if (item != null && item !== Array.LOADING && this.isSelected(item, onlyOpen)) {
                    cache[cache.length] = item
                }
            }
        }
    // no cascade selection
    } else {

        if (isRSCache) {
            for (var i = 0; i < length; i++) {
                var item = data[i];
                if (item != null && item !== Array.LOADING && this.isSelected(item, onlyOpen)) {
                    cache[cache.length] = item
                }
            }
        } else {
            for (var i = 0; i < length; i++) {
                var item = useGetCachedRow ? data.getCachedRow(i) : data[i];
                if (item != null && this.isSelected(item, onlyOpen)) {
                    cache[cache.length] = item
                }
            }
        }
    }

    this._cachingSelection = false;
    //this.logWarn("***** - selection re-cached - *******");

    // note that the selection is no longer dirty if we cached the entire selection
    // The _dirty flag is set if and only if the _cache (the list of all selected nodes whether
    // or not they are open) is current. Thus, if we just prepared an openCache, we shouldn't
    // unset the _dirty flag.
    if (!onlyOpen) this._dirty = false;
},


_cacheSelectionAsync : function (thisArg, timerEventProp, batchSize, callback, state) {

    if (state == null || state.afterGetItemList) {
        if (state == null) {
            // Don't allow this method to fire recursively, or in response to 'setSelection'
            // if we're marked as dirty
            if (this._cachingSelection || this._settingSelected || this._suppressCaching) {
                callback.call(thisArg);
                return;
            }

            var me = this;
            this._getItemListAsync(thisArg, timerEventProp, batchSize, function (data) {
                var state = { data: data, afterGetItemList: true };
                thisArg[timerEventProp] = me.delayCall(
                    "_cacheSelectionAsync", [thisArg, timerEventProp, batchSize, callback, state], 0);
            });
            return;
        }

        state.afterGetItemList = false;

        // create a new array to hold the cached selection
        state.cache = [];
        state.length = state.data.getLength();


        if (isc.isA.ResultSet != null && isc.isA.ResultSet(state.data) && !state.data.lengthIsKnown()) {
            this._dirty = false;
            this._cache = cache;
            this._openCache = null;
            callback.call(thisArg);
            return;
        }
        this._cachingSelection = true;
        this._cachingOnlyOpen = false;
        state.inFirstLoop = true;
        state.delayCache = false;
        state.i = 0;
    }
    var cache = state.cache,
        data = state.data,
        length = state.length,
        inFirstLoop = state.inFirstLoop,
        delayCache = state.delayCache,
        i = state.i,
        dirty = this._dirty;

    // Prevent isSelected() from calling cacheSelection().
    this._dirty = false;

    if (inFirstLoop) {
        // iterate over the records of the list, selecting those that have the selection property set
        var maxI = Math.min(length, i + batchSize);
        for (; i < maxI; i = state.i = i + 1) {

            // getCachedRow won't trigger fetches if working with a remote dataset
            var item = data.getCachedRow(i);
            if (item != null && this.isSelected(item)) {
                // If cascadeSelection is true and new data has arrived, it may be
                // selected. In this case we need to update the 'partial' selected state
                // of parents, and the selected state of descendents.
                // To handle this - call 'setSelected' with the flag to force a recalculation of
                // cascading selection, and then loop through all records a second time, updating
                // cache.

                if (this.cascadeSelection && !this.isPartiallySelected(item)) {
                    this.setSelected(item, true, null, true);
                    delayCache = state.delayCache = true;
                }
                if (!delayCache) {
                    cache[cache.length] = item;
                }
            }
        }
        if (i != length) {
            this._dirty = dirty;
            if (dirty) this._openCache = null;
            this._cachingSelection = false;
            thisArg[timerEventProp] = this.delayCall(
                "_cacheSelectionAsync", [thisArg, timerEventProp, batchSize, callback, state], 0);
            return;
        }
        inFirstLoop = state.inFirstLoop = false;
    }
    if (!inFirstLoop && delayCache) {
        // cascading selection - we may have actually manipulated our selection to mark
        // parents as partially selected / children as entirely selected - loop through all
        // nodes again!

        cache = state.cache = [];
        i = state.i = 0;
        var maxI = Math.min(length, i + batchSize);
        for (; i < length; i = state.i = i + 1) {

            // getCachedRow won't trigger fetches if working with a remote dataset
            var item = data.getCachedRow(i);
            if (item != null && this.isSelected(item)) {
                cache[cache.length] = item;
            }
        }
        if (i != length) {
            this._dirty = dirty;
            if (dirty) this._openCache = null;
            this._cachingSelection = false;
            thisArg[timerEventProp] = this.delayCall(
                "_cacheSelectionAsync", [thisArg, timerEventProp, batchSize, callback, state], 0);
            return;
        }
    }

    this._cachingSelection = false;
    //this.logWarn("***** - selection re-cached - *******");

    // note that the selection is no longer dirty
    this._dirty = false;

    this._cache = cache;
    this._openCache = null;
    callback.call(thisArg);
    return;
},


//>    @method    selection.setSelected()    (A)
// Select or deselect a particular item.<br><br>
// All other selection routines go through this one, so by observing this routine you can
// monitor all selection changes.
//        @group    selection
//
//        @param    item        (object)    object to select
//        @param    newState    (boolean)    turn selection on or off
//
//        @return            (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
// We need the cascadingDirection to avoid changing direction while recursing through tree.
_$up:"up",
_$down:"down",
setSelected : function (item, newState, cascadingDirection, recalculate) {

    // bail if we don't have valid data
    if (this.data == null || this.data.destroyed) {
        return false;
    }

    if (!this._canSelectItem(item)) return false;

     var settingSelected = this._settingSelected;
     this._settingSelected = true;

    var property = this.selectionProperty,
        partialProperty = this.partialSelectionProperty,
        childProp = this.data.childrenProperty || "children",
        isNode = false;

    var oldPartialValue = (isNode ? item.getAttribute(partialProperty) : item[partialProperty]);

    // default to selecting the item
    if (newState == null) newState = true;

    // Set partial property as needed.
    if (this.cascadeSelection && !this.useRemoteSelection) {
        // If this is a parent node and we are selecting/deselecting up the tree,
        // need to determine if the selection is full or partial.
        if (cascadingDirection == this._$up) {
            var partialValue = false,
                length = item[childProp] ? item[childProp].length : 0;

            for (var i = 0; i < length; i++) {
                var child = item[childProp].get(i),
                    isChildNode = false;

                var partialChild = (isChildNode ? child.getAttribute(partialProperty)
                                                : child[partialProperty])
                ;
                if (partialChild ||
                    (newState && !this.isSelected(child)) ||
                    (!newState && this.isSelected(child)))
                {
                    partialValue = true;
                    break;
                }
            }

            if (isNode) {
                item.setAttribute(partialProperty, partialValue + "");
            } else {
                item[partialProperty] = partialValue;
            }

            // If deselecting but there is a partial selection, the node must still be selected.
            if (newState != partialValue) newState = true;
        } else if (item[childProp] && item[childProp].length > 0) {
            // Make sure a left over partial selection is cleared
            if (isNode) {
                item.removeAttribute(partialProperty);
            } else {
                delete item[partialProperty];
            }
        }
    }

    // get the oldState of the item, for detecting changes
    var oldState = isNode ? item.getAttribute(property) : item[property];
    if (oldState == null) oldState = false;
    // set the state of the item
    if (isNode) {

        item.setAttribute(property, (newState == true) + "");
        //this.logWarn("set attribute on: " + this.echoLeaf(item) + " to: " + newState +
        //             ", now reads: " + item.getAttribute(property));
    } else {
        item[property] = newState;
    }



    // remember that this was the last item to be selected
    this.lastSelectionItem = item;
    this.lastSelectionState = newState;
    this.lastSelectionPreviousState = oldState;
    this.lastSelectionPartialValue = partialValue;
    this.lastSelectionPreviousPartialValue = oldPartialValue;

    // if no change to state of item, simply return false
    var newPartialValue = (isNode ? item.getAttribute(partialProperty) : item[partialProperty]);
    var changed = true;
    if (newState == oldState && newPartialValue == oldPartialValue) {
        changed = false;
    }
    if (!recalculate && changed == false) {
        if (!settingSelected) this._settingSelected = false;
        return false;
    }



    // note that the selection is dirty so it can be recalculated
    this.markForRedraw();

    // Select/deselect parent and child records
    if (this.cascadeSelection &&
        !this.useRemoteSelection)
    {
        var lastItem = item,
            lastState = newState,
            lastPrevState = oldState,
            lastPartialState = partialValue,
            lastPrevPartialState = oldPartialValue;


        var cascadeSource = false;
        if (this.cascadeSyncOnly == null) {
            cascadeSource = true;
            this.cascadeSyncOnly = !changed;
        }


        // Select/deselect child records
        if (cascadingDirection != this._$up && !isNode &&
            item[childProp] && item[childProp].length > 0)
        {
            this.selectList(item[childProp], newState);
        }

        if (changed || cascadeSource) {
        // Select/deselect parent records
            if (cascadingDirection != this._$down && isc.isA.Tree(this.data)) {
                var parent = this.data.getParent(item);
                // note: we do this even if isSelected == newState -- we may need
                // to set a partial selected state to fully selected or vice-versa.
                if (parent) {
                    this.setSelected (parent, newState, this._$up);
                }
            }
        }

        this.lastSelectionItem = lastItem;
        this.lastSelectionState = lastState;
        this.lastSelectionPreviousState = lastPrevState;
        this.lastSelectionPartialValue = lastPartialState;
        this.lastSelectionPreviousPartialValue = lastPrevPartialState;
        if (cascadeSource) {
            this.cascadeSyncOnly = null;
        }
    }
    if (!settingSelected) this._settingSelected = false;

    // Fire selectionChange on this.target if present

    if (changed && this.target && this.target.selectionChange) {
        this.target.selectionChange(item, newState);
    }
    // return true to indicate that there was a change in the selection state
    return true;
},

_canSelectItem : function (item) {
    // if the item is null, just return
    if (item == null) {
        return false;
    }

    // if the item is not enabled, just return
    if (item[this.enabledProperty] == false) return false;
    // if the item cannot be selected, just return
    if (item[this.canSelectProperty] == false) return false;

    return true;
},


//>    @method    selection.select()
//            Select a particular item
//        @group    selection
//
//        @param        item    (object)    object to select
//        @return                (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
select : function (item) {
    return this.setSelected(item, true);
},

//>    @method    selection.deselect()
//            Deselect a particular item
//        @group    selection
//
//        @param        item    (object)    object to select
//        @return                (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
deselect : function (item) {
    return this.setSelected(item, false);
},


//>    @method    selection.selectSingle()
// Select a single item and deselect everything else
//        @group    selection
//
//        @param        item    (object)    object to select
//        @return                (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
  selectSingle : function (item) {
    var itemWasSelected, othersWereSelected;


    // deselect the item if selected (and remember whether it was)
    itemWasSelected = this.deselect(item);
    // deselect everything else
    othersWereSelected = this.deselectAll();
    // Reselect the single item
    this.select(item);

    // return true if the item became selected or others were cleared
    return !itemWasSelected || othersWereSelected;
},

//>    @method    selection.selectList()
// Select an array of items (subset of the entire list)
// @group selection
//
// @param list (object[]) array of objects to select
// @return (boolean) true == selection actually changed, false == no change
// @visibility external
//<
selectList : function (list, newState, selectionChanged, caller) {


    if (newState == null) newState = true;
    if (!list) return false;
    // Ensure the current cache is up to date
    if (this._dirty) this.cacheSelection();

    var cache = this._cache;
    var length = list.getLength();

    // The deselectAll() API uses the selectionChanged parameter to avoid a potentially costly
    // sort. Because deselectAll() gets the full list of selected records (in some order, but
    // the order doesn't matter for deselectAll()), we know that the selectionChanged list is
    // identical to the list of selected records, which are to be deselected.
    if (selectionChanged == null) {
        selectionChanged = [];
        var data = this.getItemList();

        // This is critical path code - for maximum efficiency, if we're working with a
        // ResultSet, look directly at its localData array rather than going through the
        // getCachedRow() API
        // undocumented accessResultSetCache attribute allows us to turn this optimization
        // off for cases where it won't work (EG custom class which implements the List interface)
        var isRSCache = false,
            pkFields = null,
            ds = null
        ;

        if (caller != null) {
            ds = caller.getDataSource();
            pkFields = ds && ds.getPrimaryKeyFields();
            // if there are no PK fields in the DS, getPrimaryKeyFields() will return {}
        if (pkFields && isc.isA.emptyObject(pkFields)) pkFields = null;
        }

        if (this.accessResultSetCache && isc.isA.ResultSet(data)) {
            isRSCache = true;
            data = data.localData || [];
        }

        for (var i = 0; i < length; i++) {
            var item = list.get(i),
                selected = this.isSelected(item),
                index = null
            ;

            if (selected == newState) continue;

            if (pkFields) {
                // if there's a DS and it has PK fields, scan the data by passing those to
                // findIndex(), which checks attribute-values on the objects in the array
                var pks = ds && ds.filterPrimaryKeyFields(item);
                if (pks) {
                    index = data.findIndex(pks);
                    if (index >= 0) item = data[index];
                }
            } else {
                // use a reference equality check
                index = data.fastIndexOf(item);
            }
            // Skip anything which isn't actually in our data
            if (index == null || index == -1) {

                continue;
            }

            // put together a list of all records that are changing to a new selection state
            if (this._canSelectItem(item)) selectionChanged[selectionChanged.length] = item;
        }
    } else {


        if (cache === selectionChanged) selectionChanged = selectionChanged.duplicate();
    }

    var anyChanged = false,
        length = selectionChanged.length;


    var orig_suppressCaching = this._suppressCaching;
    this._suppressCaching = true;

    // Set a flag indicating we're selecting a range of rows

    var orig_selectingList = this._selectingList;
    this._selectingList = length > 1 ? true : false;

    if (length > 0) this._openCache = null;

    for (var i = 0; i < length; i++) {
        var item = selectionChanged[i];
        // incrementally update the cache before calling 'setSelected'

        if (newState) {
            // selecting new records: add newly selected records at the end of the cache

            cache[cache.length] = item;
        } else {
            // deselecting records: remove the item from the cache
            cache.remove(item);
        }

        anyChanged = this.setSelected(item, newState) || anyChanged;
    }

    this._suppressCaching = orig_suppressCaching;

    // We've been updating the cache as we go. Calling "cacheSelection" here will
    // re-cache.
    // If cascadeSelection is false, this is unnecessary - simply mark as
    // not dirty (note that setSelected calls above will have marked as dirty)
    // Otherwise explicitly call cacheSelection to ensure items not explicitly
    // passed in, but selected by cascading selection, get picked up too


    if (this.cascadeSelection) {
        if (this._dirty) this.cacheSelection();
    } else {
        this._dirty = false;
    }

    this._selectingList = orig_selectingList;

    return anyChanged;
},

//>    @method    selection.deselectList()
//            Deselect an array of items (subset of the entire list)
//        @group    selection
//
//        @param        list    (object[])    array of objects to select
//        @return                (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
deselectList : function (list, caller) {
    return this.selectList(list, false, null, caller);
},


//>    @method    selection.selectAll()
// Select all records of the list.
// @param [visibleNodesOnly] (boolean) If this selection's data object is a tree,
//   if <code>true</code> is passed for this parameter,
//   only visible nodes will be selected. Nodes embedded in a closed parent folder
//   (and thus hidden from the user) will not be selected.
// @return (boolean) Returns <code>true</code> if the selection actually changed,
//   <code>false</code> if not.
// @visibility external
// @group    selection
//<

selectAll : function (visibleNodesOnly) {
    // data.getLength() will only include the visible items (open) for Tree data
    if (visibleNodesOnly) return this.selectRange(0, this.data.getLength());
    else return this.selectList(this.getItemList());
},

//>    @method    selection.deselectAll()
//            Deselect ALL records of the list
//        @group    selection
//
//        @return                (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
deselectAll : function () {




    // When getting the selection, it does not matter the order in which the items are deselected
    // so pass true for the dontSort optimization hint.
    var selectionChanged = this._getSelection(false, true);

    var returnVal = this.selectList(selectionChanged, false, selectionChanged);

    // Because we now know that everything has been deselected, mark the selection as not dirty
    // and set the selection _cache to an empty array.
    this._dirty = false;
    this._cache = [];
    this._openCache = null;

    return returnVal;
},


//>    @method    selection.selectItem()
// Select a particular item by its position in the list
//
//        @param    position    (number)    index of the item to be selected
//        @return                (boolean)    true == selection actually changed, false == no change
// @group selection
// @visibility external
//<
selectItem : function (position) {
    return this.selectRange(position, position+1);
},


//>    @method    selection.deselectItem()
// Deselect a particular item by its position in the list
//
//        @param    position    (number)    index of the item to be selected
//        @return                (boolean)    true == selection actually changed, false == no change
// @group selection
// @visibility external
//<
deselectItem : function (position) {
    return this.deselectRange(position, position+1);
},





//>    @method    selection.selectRange()
//            Select range of records from <code>start</code> to <code>end</code>, non-inclusive.
//        @group    selection
//
//        @param    start        (number)    start index to select
//        @param    end            (number)    end index (non-inclusive)
//      @param  [newState]  (boolean)   optional new selection state to set.  True means
//                                      selected, false means unselected.  Defaults to true.
//
//        @return                (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
selectRange : function (start, end, newState) {
    if (newState == null) newState = true;

    // Use visible records for range selection
    var data = this.data;



    if (isc.isA.ResultSet != null && isc.isA.ResultSet(data) &&
        !data.rangeIsLoaded(start, end))
    {
        this.warnSelectionRangeNotLoaded();
        return false; // no change
    }

    return this.selectList(data.getRange(start, end), newState);
},

warnSelectionRangeNotLoaded : function () {
    this.logWarn("selectRange called - selection range not loaded. Showing " +
                "selectionRangeNotLoadedMessage to the user.");
    isc.warn(this.selectionRangeNotLoadedMessage);
},

//> @attr selection.selectionRangeNotLoadedMessage (String : Can't select that many records at once.&lt;br&gt;&lt;br&gt;Please try working in smaller batches. : IRWA)
//
// Message to display to the user in a <code>warn</code> dialog if +link{selection.selectRange()} is
// called for a selection on a ResultSet, where the range of records to be selected has not been
// loaded.
// @group i18nMessages
// @visibility external
//<
selectionRangeNotLoadedMessage:"Can't select that many records at once.<br><br>" +
                                "Please try working in smaller batches.",


//>    @method    selection.deselectRange()
//            Deselect range of records from <code>start</code> to <code>end</code>, non-inclusive
//
//        @group    selection
//
//        @param    start    (number)    start index to select
//        @param    end        (number)    end index (non-inclusive)
//
//        @return                (boolean)    true == selection actually changed, false == no change
// @visibility external
//<
deselectRange : function (start, end) {
    return this.selectRange(start, end, false);
},

// DOCFIX: this methods shouldn't require the "target", a Canvas.  Need to fix that before we make
// them public.

//>    @method    selection.selectOnMouseDown()    (A)
// Update the selection as the result of a mouseDown event.
// Handles shift, control, etc. key selection as well.
// Call this from a mouseDown handler.
//
// @group selection, mouseEvents
//
// @param target (Canvas) target object
// @param position (number) position where mouse went down on
//
// @return (boolean) true == selection was changed, false == no change
//<
selectOnMouseDown : function (target, recordNum) {

    // modify selection according to the specified style (defaulting to multiple selection)
    var selectionType = target.selectionType || isc.Selection.MULTIPLE;

    // if the target's selectionType is NONE, just bail
    if (selectionType == isc.Selection.NONE)    return false;

    // remember mouseDown location in case we start drag selecting
    this.startRow = this.lastRow = recordNum;

    //>DEBUG
    this.logDebug("selectOnMouseDown: recordNum: " + recordNum);
    //<DEBUG

    // Pull record based on the visible records
    var record = this.data.get(recordNum),
        recordSelected = this.isSelected(record, true),
        selection // only compute this when used because it can be expensive
    ;

    // prevent mouse-based selection of the LOADING record.  This doesn't make sense and create
    // client-side JS errors very easily.
    if (Array.isLoading(record)) return false;

    // clear flags for deselecting records on mouseUp
    // these are set in the simple and normal cases below (3 and 5)
    // see selectOnMouseUp() for details
    this.deselectRecordOnMouseUp = false;
    this.deselectOthersOnMouseUp = false;


    var lastRecordClicked = this._lastRecordClicked;
    this._lastRecordClicked = record;

    // In Windows ctrl-click works allows multiple independent row selection/deselection
    // In Mac the equivalent functionality occurs with the Apple key (meta key), since
    //  on that platform ctrl+click == right click

    var metaKeyDown = (isc.Browser.isMac ? isc.EventHandler.metaKeyDown()
                                         : isc.EventHandler.ctrlKeyDown()),
        shiftKeyDown = isc.EH.shiftKeyDown();

    // clear the shift-selection base record if we won't be doing shift-selection
    if (selectionType == isc.Selection.SINGLE || !shiftKeyDown) {
        this._shiftSelectBaseRecord = null;
    }

    // Case 1: SINGLE selection
    if (selectionType == isc.Selection.SINGLE) {
        // On ctrl+click allow deselection

        if (metaKeyDown && recordSelected) this.deselect(record);
        else if (!recordSelected) this.selectSingle(record);
        else return false;

        return true;

    // Case 2: Shift-selection (select contiguous range of records)

    } else if (shiftKeyDown) {
        selection = this._getSelection();

        // if nothing selected, simply select current record
        if (selection.length == 0 && this.shiftSelectFallbackMode != "top") {
            this._shiftSelectBaseRecord = record;
            this.select(record);

        // otherwise since something was selected
        } else {


            // if not already set, calculate base record around which shift-selection will occur
            if (!this._shiftSelectBaseRecord) {
                this._shiftSelectBaseRecord = lastRecordClicked =
                    this._calculateShiftSelectBaseRecord(recordNum, lastRecordClicked);
            }

            var data = this.data;

            // our approach requires knowing the base index and the last index, so compute them
            var lastIndex = data.fastIndexOf ? data.fastIndexOf(lastRecordClicked) :
                                                   data.indexOf(lastRecordClicked),
                baseIndex = data.fastIndexOf ? data.fastIndexOf(this._shiftSelectBaseRecord) :
                                                   data.indexOf(this._shiftSelectBaseRecord)
            ;

            // is current record above or below base, and what is step from last?
            var above = baseIndex >  recordNum,
                below = baseIndex <= recordNum,
                step  = recordNum - lastIndex
            ;

            // we clicked above the base record
            if (baseIndex > recordNum) {
                // select for upward movement, deselect for downward movement
                if (step < 0) {
                    // if we've crossed over base record, clear selection on other side
                    if (lastIndex > baseIndex) {
                        this.deselectRange(baseIndex + 1, lastIndex + 1);
                        lastIndex = baseIndex;
                    }
                    this.selectRange(recordNum, lastIndex);
                }
                else if (step > 0) this.deselectRange(lastIndex, recordNum);

            // we clicked below the base record
            } else if (baseIndex <= recordNum) {
                // select for downward movement, deselect for upward movement
                if (step > 0) {
                    // if we've crossed over base record, clear selection on other side
                    if (lastIndex < baseIndex) {
                        this.deselectRange(lastIndex, baseIndex);
                        lastIndex = baseIndex;
                    }
                    this.selectRange(lastIndex, recordNum + 1);
                }
                else if (step < 0) this.deselectRange(recordNum + 1, lastIndex + 1);
            }
        }
        return true;

    // Case 3: SIMPLE selection (toggle selection of this record, but defer deselection until
    // mouseUp)
    } else if (selectionType == isc.Selection.SIMPLE) {

        if (!recordSelected) {
            this.select(record);
            return true;
        } else {
            this.deselectRecordOnMouseUp = true;
            return false;
        }


    // Case 4: meta-key selection in a multiple selection range
    // (simply toggle selection of this record)
    } else if (metaKeyDown) {

        this.setSelected(record, !recordSelected);
        return true;

    // Case 5: normal selection (no modifier keys) in a multiple selection range
    } else {

        if (!recordSelected) {
            // if you click outside of the selection, select the new record and deselect
            // everything else
            this.selectSingle(record);
            return true;
        } else if (isc.EventHandler.rightButtonDown()) {
            // never deselect if you right click on the selection, unless you start drag
            // selecting
            this.deselectOnDragMove = true;
            return false;
        } else {
            // simpleDeselect mode: this mode is designed to make it easy to entirely get rid
            // of your selection, so you don't have to know about ctrl-clicking.  In a
            // nutshell, if you click on the existing selection, it will be entirely
            // deselected.

            if (this.dragSelection) {
                if (this.simpleDeselect) {
                    // if you click on the selection, deselect the entire selection including
                    // the clicked-on cell.  Later, if a drag begins, select the clicked-on
                    // cell.
                    this.deselectAll();
                    this.selectOriginOnDragMove = true;
                    return true;
                }
                // for a drag selection, deselect others immediately; otherwise we'll be
                // dragging out a new selection within/overlapping with an existing selection,
                // which we only want to do on a ctrl-click.  This matches Excel.
                this.selectSingle(record);
                return true;
            } else {
                if (this.simpleDeselect) {
                    // deselect everything on mouseUp, including the cell clicked on
                    this.deselectAllOnMouseUp = true;
                } else {
                    // if we click in a multiple selection, deselect everything but the
                    // clicked-on item, but don't do it until mouseUp in order to allow
                    // dragging the current selection.  This matches Windows Explorer.

                    selection = this._getSelection();
                    this.deselectOthersOnMouseUp = (selection.length > 1);
                }
                return false;
            }
        }
    }

},

// helper to calculate the shift-selection base record if it hasn't yet been set

_calculateShiftSelectBaseRecord : function (recordNum, lastRecordClicked) {

    // if the last click was on a record that's still selected, we're done
    if (lastRecordClicked && lastRecordClicked[this.selectionProperty]) {
        return lastRecordClicked;

    // otherwise, we'll have to calculate a good base record
    } else {
        var foundSelected,
            data = this.data;

        // check above the click position for a selected record
        for (var i = recordNum - 1; i >= 0; i--) {
            var currentRecord = data.getCachedRow(i);
            if (!currentRecord || Array.isLoading(currentRecord)) {
                // not loaded - bail out
                i++; break;
            }
            if (currentRecord[this.selectionProperty]) {
                foundSelected = true;
                break;
            }
        }

        // if nothing was found, then check below the click position as well
        if (!foundSelected && this.shiftSelectFallbackMode != "top") {
            for (var j = recordNum + 1; j < data.getLength(); j++) {
                var currentRecord = data.getCachedRow(j);
                if (!currentRecord || Array.isLoading(currentRecord)) {
                    // not loaded - bail out
                    j--; break;
                }
                if (currentRecord[this.selectionProperty]) {
                    i = j;
                    break;
                }
            }
        }

        return data.getCachedRow(Math.max(0, i)) || lastRecordClicked;
    }
},

//>    @method    selection.selectOnDragMove()    (A)
//            During drag selection, update the selection as a result of a dragMove event
//
//        @group    selection, mouseEvents
//
//        @param    target    (Canvas)    target object
//        @param    position (number)    position where mouse went down on
//
//        @return            (boolean)    true == selection was changed, false == no change
//
//<
selectOnDragMove : function (target, currRow) {
    var startRow = this.startRow,
        lastRow = this.lastRow;

    // If the mouse has moved further away from the start position since the last dragMove, select
    // more cells.  If it's moved closer to the start position, deselect cells.
    if (currRow < 0) {
        //>DEBUG
        this.logWarn("selectOnDragMove: got negative coordinate: " + currRow);
        //<DEBUG
        return;
    }

    if (currRow == lastRow) return; // no change



    if (this.selectOriginOnDragMove) {
        this.select(this.data.getItem(startRow));
        this.selectOriginOnDragMove = false;
    } else if (this.deselectOnDragMove || this.deselectAllOnMouseUp || this.deselectOthersOnMouseUp) {
        // deselect on dragMove is for right-dragging.  The others flags are failsafes in case you
        // use drag selection without setting the flag.
        this.selectSingle(this.data.getItem(startRow));
        this.deselectAllOnMouseUp = this.deselectOthersOnMouseUp = this.deselectOnDragMove = false;
    }

    if ((currRow > startRow && startRow > lastRow) ||
        (lastRow > startRow && startRow > currRow))
    {
        //this.logWarn("dragged from one side of start to the other");
        // dragged from one side of start to the other
        this.deselectAll();
        // select from start to current inclusive
        if (startRow > currRow) {
            this.selectRange(currRow, startRow+1);
        } else {
            this.selectRange(startRow, currRow+1);
        }
    } else if (startRow >= lastRow && lastRow > currRow) {
        //this.logWarn("increasing selection on the left of start");
        // increasing selection on the left of start
        this.selectRange(currRow, lastRow);
    } else if (startRow >= currRow && currRow > lastRow) {
        //this.logWarn("decreasing selection on the left of start");
        // decreasing selection on the left of start
        this.deselectRange(lastRow, currRow);
    } else if (startRow <= currRow && currRow < lastRow) {
        //this.logWarn("decreasing selection on the right of start");
        // decreasing selection on the right of start
        this.deselectRange(currRow+1, lastRow+1);
    } else if (startRow <= lastRow && lastRow < currRow) {
        //this.logWarn("increasing selection on the right of start");
        // increasing selection on the right of start
        this.selectRange(lastRow, currRow+1);
    //>DEBUG
    } else {
        this.logWarn("dragMove case not handled: lastRow: " + lastRow +
                     ", currRow: " + currRow + ", startRow " + startRow);
    //<DEBUG
    }

    this.lastRow = currRow;
},

//>    @method    selection.selectOnMouseUp()    (A)s
// Update the selection as the result of a mouseUp event.
// We currently use this to defer deselection for drag-and-drop of multiple records.
// Call this from a mouseUp handler.
//
// @param target (Canvas) target object
// @param recordNum (number) record number mouse went down on
//
// @return (boolean) true == selection was changed, false == no change
// @see ListGrid.mouseUp()
// @group selection, mouseEvents
//<
selectOnMouseUp : function (target, recordNum) {
    // if the target's selectionType is NONE, just bail
    if (target.selectionType == isc.Selection.NONE)    return false;

    //>DEBUG
    this.logDebug("selectOnMouseUp: recordNum: " + recordNum);
    //<DEBUG

    // JMD 020828:
    //        If multiselection is on and no modifier keys are down, we need to
    // deselect any rows other than the one that is clicked. BUT, we can't do this in
    // selectOnMouseDown() because the user might be clicking on a row in a multiple selection
    // to initiate a drag operation with all of the selected rows. So in selectOnMouseDown()
    // we set a deselectOthersOnMouseUp flag that we can check here and do the deselection
    // if necessary.
    //        Similarly, if SIMPLE selection is enabled we don't want to deselect the current
    // record if the user is initiating a drag. We set a deselectRecordOnMouseUp flag for in this case.
    //
    // We never deselect anything on rightMouseUp since you would right click to show a context menu
    // to operate on the current selection.
    var returnVal = false;
    if (this.deselectOthersOnMouseUp) {
        returnVal = this.selectSingle(this.data.getItem(recordNum));
        this.deselectOthersOnMouseUp = false;
    } else if (this.deselectRecordOnMouseUp) {
        returnVal = this.deselect(this.data.getItem(recordNum));
        this.deselectRecordOnMouseUp = false;
    } else if (this.deselectAllOnMouseUp) {
        returnVal = this.deselectAll();
        this.deselectAllOnMouseUp = false;
    }
    return returnVal;
},

// @param [onlyOpen] (Boolean) are only opened nodes required?
// @param [dontSort] (Boolean) optimization hint for whether the normalizer needs to
// be applied.
getItemList : function (onlyOpen, dontSort) {
    var data = this.data;
    if (isc.isA.Tree(data)) return data.getNodeList(onlyOpen, dontSort);
    return (data != null ? data : []);
},


_getItemListAsync : function (thisArg, timerEventProp, batchSize, callback) {
    if (this.data && isc.isA.Tree(this.data) && isc.isA.Function(this.data._getNodeListAsync)) {
        this.data._getNodeListAsync(thisArg, timerEventProp, batchSize, callback);
    } else {
        callback.call(thisArg, this.getItemList());
    }
}
});    // END isc.Selection.addMethods()









//>    @class    DetailViewer
//
//  Displays one or more records "horizontally" with one property per line.
//
//  @implements DataBoundComponent
//  @treeLocation Client Reference/Grids
//  @visibility external
//<

isc.ClassFactory.defineClass("DetailViewer", "Canvas", "DataBoundComponent");

// add default properties
isc.DetailViewer.addProperties({

    // Data
    // --------------------------------------------------------------------------------------------

    //>    @attr    detailViewer.data        (Array[] of DetailViewerRecord | Array[] of Record | RecordList : null : IRW)
    // A single record object or an array of them, specifying data. Note that DetailViewers do
    // not observe changes to the data array (in other words they will not automatically
    // re-draw when the data provided via this property is altered).
    //
    // @group basics
    // @visibility external
    //<

    //> @attr detailViewer.dataFetchMode (FetchMode : "basic" : IRW)
    // DetailViewers do not yet support paging, and will fetch and render all available
    // records.
    //
    // @group databinding
    // @visibility external
    //<
    dataFetchMode:"basic",

    // dataArity:"either" - DetailViewers support viewing single, or multiple records
    dataArity:"either",

    //> @attr detailViewer.dataSource (DataSource or ID : null : IRW)
    // @include dataBoundComponent.dataSource
    //<

    //> @attr detailViewer.rowHeight (int : 19 : IRW)
    // Height of rows rendered by the DetailViewer.  Acts as a minimum - the DetailViewer never
    // clips values. This attribute can be set as null.
    // @visibility external
    //<
    rowHeight:19,

    //> @object DetailViewerRecord
    //
    // A DetailViewerRecord is an object literal with properties that define the values for the
    // various fields of a +link{DetailViewer}.
    // <p>
    // For example a DetailViewer that defines the following fields:
    // <pre>
    // fields : [
    //     {name: "field1"},
    //     {name: "field2"}
    // ],
    // </pre>
    // Might have the following data:
    // <pre>
    // data : [
    //     {field1: "foo", field2: "bar"},
    //     {field1: "field1 value", field2: "field2 value"}
    // ]
    // </pre>
    // Each element in the data array above is an instance of DetailViewerRecord - notice that
    // these are specified simply as object literals with properties.
    //
    // @treeLocation Client Reference/Grids/DetailViewer
    // @visibility external
    //<

    //> @attr detailViewerRecord.linkText (string : null : IRW)
    // The HTML to display in this record for fields with type set to "link". This overrides
    // +link{attr:detailViewerField.linkText}.
    //
    // @see attr:detailViewerField.type
    // @see attr:detailViewerField.linkText
    // @see attr:detailViewer.linkTextProperty
    // @visibility external
    //<

    // Fields
    // ---------------------------------------------------------------------------------------

    //>    @attr    detailViewer.fields        (Array of DetailViewerField : null : IRW)
    //
    // An array of field objects, specifying the order and type of fields to display in this
    // DetailViewer.  In DetailViewers, the fields specify rows.
    //
    // @visibility external
    //<

    //> @object DetailViewerField
    //
    // An object literal with a particular set of properties used to configure the display of
    // and interaction with the rows of a +link{DetailViewer}.
    //
    // @treeLocation Client Reference/Grids/DetailViewer
    // @visibility external
    //<

    //> @attr DetailViewerField.name (String : null : IR)
    // Name property used to identify the field, and determines which attribute from
    // records will be displayed in this field.
    // <P>
    // Must be unique within the DetailViewer as well as a valid JavaScript identifier,
    // as specified by ECMA-262 Section 7.6 (the <smartclient>+link{String.isValidID()}</smartclient>
    // <smartgwt>StringUtil.isValidID()</smartgwt> function can be used to test whether
    // a name is a valid JavaScript identifier).
    // <P>
    // The attribute of the records to display in this field may also be set by
    // +link{displayField}.
    // @visibility external
    //<

    //> @attr DetailViewerField.displayField (String : null : IR)
    // If <code>displayField</code> is defined for the field then the DetailViewer will
    // display the <code>displayField</code> attribute of records instead of the attribute
    // given by the +link{name} of the field.
    // @visibility external
    //<

    //> @attr DetailViewerField.dataPath (String : null : IRA)
    // dataPath property allows this field to display detail from nested data structures
    // @visibility external
    //<

    //> @method DetailViewerField.formatCellValue()
    // Optional method to format the value to display for this field's cells. Takes precedence
    // over +link{DetailViewer.formatCellValue()} for cells in this field.
    // @param value (string) the raw value of the cell
    // @param record (detailViewerRecord) the record being displayed
    // @param field (detailViewerField) the field being displayed
    // @param viewer (detailViewer) the detailViewer containing this field
    // @visibility external
    //<

    //> @attr detailViewerField.dateFormatter (DateDisplayFormat : null : [IRW])
    // Display format to use for date type values within this field.
    // <P>
    // The +link{detailViewerField.timeFormatter} may also be used to format underlying Date values as
    // times (omitting the date part entirely). If both <code>dateFormatter</code> and
    // <code>timeFormatter</code> are specified on a field, for
    // fields specified as +link{detailViewerField.type,type "time"} the
    // <code>timeFormatter</code> will be used, otherwise the <code>dateFormatter</code>
    // <P>
    // If <code>field.dateFormatter</code> and <code>field.timeFormatter</code> is unspecified,
    // date display format may be defined at the component level via
    // +link{detailViewer.dateFormatter}, or for fields of type <code>"datetime"</code>
    // +link{detailViewer.datetimeFormatter}. Otherwise the
    // default is to use the system-wide default normal date format, configured via
    // +link{Date.setNormalDisplayFormat()}.  Specify any valid +link{type:DateDisplayFormat} to
    // change the format used by this item.
    //
    // @see listGrid.dateFormatter
    // @see listGrid.datetimeFormatter
    // @see listGridField.timeFormatter
    // @visibility external
    //<

    //>    @attr detailViewerField.timeFormatter (TimeDisplayFormat : null : [IRWA])
    // Time-format to apply to date type values within this field.  If specified, any
    // dates displayed in this field will be formatted as times using the appropriate format.
    // This is most commonly only applied to fields specified as type <code>"time"</code> though
    // if no explicit +link{detailViewerField.dateFormatter} is specified it will be respected for other
    // fields as well.
    // <P>
    // If unspecified, a timeFormatter may be defined
    // +link{detailViewer.timeFormatter,at the component level} and will be respected by fields
    // of type <code>"time"</code>.
    //
    // @group appearance
    // @visibility external
    //<
    //timeFormatter:null

    //> @attr detailViewerField.decimalPrecision (number : null : [IRW])
    // @include dataSourceField.decimalPrecision
    //
    // @group appearance
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr detailViewerField.decimalPad (number : null : [IRW])
    // @include dataSourceField.decimalPad
    //
    // @group appearance
    // @serverDS allowed
    // @visibility external
    //<

    //>    @attr    detailViewerField.imageSize (Integer | String : null : IRW)
    // Size of images shown for fieldTypes image in this field.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // height.  For example, if <code>field.imageSize</code> is "logoSize",
    // <code>record.logoSize</code> will control the size of the image.
    //
    // @see attr:detailViewerField.imageWidth
    // @see attr:detailViewerField.imageHeight
    //
    // @group imageColumns
    // @visibility external
    //<

      //>    @attr    detailViewerField.imageWidth (Integer | String : null : IRW)
    // Width of images shown for fieldTypes image in this field.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // width.  For example, if <code>field.imageWidth</code> is "logoWidth",
    // <code>record.logoWidth</code> will control the width of the image.
    //
    // @see attr:detailViewerField.imageSize
    // @see attr:detailViewerField.imageHeight
    //
    // @group imageColumns
    // @visibility external
    //<

      //>    @attr    detailViewerField.imageHeight (Integer | String : null : IRW)
    // Height of image shown for fieldTypes image in this field.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // height.  For example, if <code>field.imageHeight</code> is "logoHeight",
    // <code>record.logoHeight</code> will control the height of the image.
    //
    // @see attr:detailViewerField.imageSize
    // @see attr:detailViewerField.imageWidth
    //
    // @group imageColumns
    // @visibility external
    //<

    //> @attr   detailViewerField.imageURLPrefix (string : null : IRWA)
    // If this field has type set to <code>"image"</code>
    // and the URL for the image displayed is not absolute, the path of the URL will be relative
    // to this string<br>
    //
    // @group imageColumns
    // @visibility external
    //<

    //> @attr detailViewerField.linkText (String : null : IRW)
    // The HTML to display for values of this field if the field type is set to "link".
    // <P>
    // This property sets linkText that will be the same for all records.  You can set linkText
    // on a per-record basis via +link{attr:detailViewerRecord.linkText}.
    //
    // @see attr:detailViewerField.type
    // @see attr:detailViewerRecord.linkText
    // @see attr:detailViewer.linkTextProperty
    // @see attr:detailViewerField.linkTextProperty
    // @visibility external
    //<

    //> @attr detailViewerField.linkTextProperty (string : null : IRW)
    // Name of the property in a DetailViewerRecord that holds the HTML to display for values
    // of this field if the field type is set to "link".
    //
    // @see attr:detailViewerField.type
    // @see attr:detailViewerRecord.linkText
    // @see attr:detailViewerField.linkText
    // @see attr:detailViewer.linkTextProperty
    // @visibility external
    //<

    //> @attr detailViewerField.linkURLPrefix (string : null : IRWA)
    // If this field has type set to <code>"link"</code>, setting this property will apply a
    // standard prefix to the link URL when displaying values of this field.
    // @see attr:detailViewerField.type
    // @visibility external
    //<

    //> @attr detailViewerField.linkURLSuffix (string : null : IRWA)
    // If this field has type set to <code>"link"</code>, setting this property will apply a
    // standard suffix to the link URL when displaying values of this field.
    // @see attr:detailViewerField.type
    // @visibility external
    //<

    //> @attr detailViewerField.target (string : "_blank" : IRW)
    // By default, clicking a link rendered by this item opens it in a new browser window.  You
    // can alter this behavior by setting this property.  The value of this property will be
    // passed as the value to the <code>target</code> attribute of the anchor tag used to render
    // the link.  <code>target</code> is applicable only if the field type is set to "link".
    // @see detailViewerField.type
    // @visibility external
    //<

    //> @attr detailViewerField.format (FormatString : null : IR)
    // +link{FormatString} for numeric or date formatting.  See +link{dataSourceField.format}.
    // @group exportFormatting
    // @visibility external
    //<

    //> @attr detailViewerField.exportFormat (FormatString : null : IR)
    // +link{FormatString} used during exports for numeric or date formatting.  See
    // +link{dataSourceField.exportFormat}.
    // @group exportFormatting
    // @visibility external
    //<

    //> @attr detailViewerField.exportRawValues (Boolean : null : IR)
    //  Dictates whether the data in this field should be exported raw by
    // +link{detailViewer.exportClientData, exportClientData()}.  If set to true for a
    // field, the values in the field-formatters will not be executed for data in this field.
    // @visibility external
    //<

    // ------------
    // Hilite Icons
    // ------------

    //> @attr detailViewer.hiliteIcons (Array of String : ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"] : IR)
    // @include dataBoundComponent.hiliteIcons
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewer.hiliteIconPosition (HiliteIconPosition : "before" : IR)
    // @include dataBoundComponent.hiliteIconPosition
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewer.hiliteIconSize (number : 12 : IRW)
    // @include dataBoundComponent.hiliteIconSize
    // @see hiliteIconWidth
    // @see hiliteIconHeight
    // @see DetailViewerField.hiliteIconSize
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewer.hiliteIconWidth (number : null : IRW)
    // @include dataBoundComponent.hiliteIconWidth
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewer.hiliteIconHeight (number : null : IRW)
    // @include dataBoundComponent.hiliteIconHeight
    // @group hiliting
    // @visibility external
    //<

    //> @attr   detailViewer.hiliteIconLeftPadding (number : 2 : IRW)
    // @include dataBoundComponent.hiliteIconLeftPadding
    // @group hiliting
    // @visibility external
    //<

    //> @attr   detailViewer.hiliteIconRightPadding (number : 2 : IRW)
    // @include dataBoundComponent.hiliteIconRightPadding
    // Can be overridden at the field level
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewerField.canHilite (boolean : null : IRW)
    // @include listGridField.canHilite
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewerField.hiliteIconPosition (HiliteIconPosition : null : IR)
    // When +link{detailViewer.hiliteIcons} are present, where the hilite icon will be placed
    // relative to the field value.  See +link{type:HiliteIconPosition}.
    // Overrides +link{detailViewer.hiliteIconPosition}
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewerField.hiliteIconSize (number : null : IRW)
    // Default width and height of +link{detailViewer.hiliteIcons, hilite icons} in this field.
    // Takes precedence over hiliteIconWidth, hiliteIconHeight and hiliteIconSize specified at
    // the component level.
    // Can be overridden via +link{hiliteIconWidth,hiliteIconWidth} and +link{hiliteIconHeight,hiliteIconHeight}
    // @group hiliting
    // @see detailViewer.hiliteIconSize
    // @see detailViewerField.hiliteIconWidth
    // @see detailViewerField.hiliteIconHeight
    // @visibility external
    //<

    //> @attr detailViewerField.hiliteIconWidth (number : null : IRW)
    // Width for hilite icons for this field.
    // Overrides +link{detailViewer.hiliteIconSize}, +link{detailViewer.hiliteIconWidth}, and
    // +link{detailViewerField.hiliteIconSize}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr detailViewerField.hiliteIconHeight (number : null : IRW)
    // Height for hilite icons for this field.
    // Overrides +link{detailViewer.hiliteIconSize}, +link{detailViewer.hiliteIconHeight}, and
    // +link{DetailViewerField.hiliteIconSize}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr   detailViewerField.hiliteIconLeftPadding (number : null : IRW)
    // How much padding should there be on the left of +link{detailViewer.hiliteIcons, hilite icons}
    // for this field?
    // Overrides +link{detailViewer.hiliteIconLeftPadding}
    // @group hiliting
    // @visibility external
    //<

    //> @attr   detailViewerField.hiliteIconRightPadding (number : null : IRW)
    // How much padding should there be on the right of +link{DetailViewer.hiliteIcons, hilite icons}
    // for this field?
    // Overrides +link{detailViewer.hiliteIconRightPadding}
    // @group hiliting
    // @visibility external
    //<


    //> @method detailViewerField.showIf
    //
    // If specified on a field, this method is evaluated at draw time to determine whether or
    // not to show this particular field.
    // <p>
    // This method can be specified either as a function or a string that will be
    // auto-converted to a function.
    //
    // @param viewer (DetailViewer) The DetailViewer
    // @param valueList (List of DetailViewerRecord)
    //
    // @return (boolean) true to show the field, false to not show it.
    //
    // @visibility external
    //<

    //> @attr detailViewerField.type (String : null : IR)
    //
    // Specifies the type of this DetailViewerField.  By default (value is <code>null</code>)
    // the field shows a field title on the left and the field value on the right.  There are
    // four special values for this attribute:
    // <ul>
    // <li>"header" - If you specify type "header", the field spans both the field name and
    // field value columns and contains text defined in the +link{DetailViewerField.value}
    // attribute with the style specified by +link{DetailViewer.headerStyle}.  You can use this
    // field type as a titled separator.
    // <li>"separator" - If you specify type "separator", the field spans both the field name
    // and the field value columns with no text, and is styled using the style specified via
    // +link{DetailViewer.separatorStyle}.  The height of the separator field can be controlled
    // via +link{DetailViewerField.height}.
    // <li>"image" For viewing, a thumbnail image is rendered in the field.  The URL of the
    // image is the value of the field, and should be absolute. The size of the image is
    // controlled by +link{attr:DetailViewerField.imageSize},
    // +link{attr:DetailViewerField.imageWidth}, +link{attr:DetailViewerField.imageHeight}
    // <li><p>"link" For viewing, a clickable html link (using an HTML anchor tag: &lt;A&gt;)
    // is rendered in the field.  The target URL is the value of the field, which is also the
    // default display value.  You can override the display value by setting
    // +link{attr:detailViewerRecord.linkText} or +link{attr:detailViewerField.linkText}.</p>
    // <p>
    // Clicking the link opens the URL in a new window by default.  To change this behavior,
    // you can set <code>field.target</code>, which works identically to the "target"
    // attribute on an HTML anchor (&lt;A&gt;) tag.  See +link{detailViewerField.target} for
    // more information.</p></li>
    // </ul>
    //
    // @visibility external
    //<

    //> @attr detailViewerField.title (HTMLString : null : IR)
    //
    // The title of the field as displayed on the left-hand side.  If left unspecified, the
    // title of the field is derived by looking up the value of
    // +link{DetailViewer.fieldIdProperty} on this field.  So, by default, the title of a field
    // is the value of its "name" property.
    //
    // @see DetailViewer.fieldIdProperty
    // @visibility external
    //<

    //> @attr detailViewerField.valueMap (object : null : IR)
    //
    // A property list (or an expression that evaluates to a property list)
    // specifying a mapping of internal values to display values for the field (row).
    //
    // @visibility external
    //<

    //> @attr detailViewerField.escapeHTML (boolean : null : IR)
    // By default HTML values in DetailViewer cells will be interpreted by the browser.
    // Setting this flag to true will causes HTML characters to be escaped, meaning the
    // raw value of the field (for example <code>"&lt;b&gt;AAA&lt;/b&gt;"</code>) is displayed
    // to the user rather than the interpreted HTML (for example <code>"<b>AAA</b>"</code>)
    //
    // @visibility external
    //<

    //> @attr detailViewerField.value (HTMLString : "undefined" : IR)
    //
    // When a field specifies its +link{detailViewerField.type} to be "header", the value of
    // this attribute specifies the header text.
    //
    // @visibility external
    //<


    //> @attr detailViewerField.width (Number : null : IR)
    //
    // @visibility internal
    //<

    //> @attr detailViewerField.height (Number : null : IR)
    //
    // For +link{DetailViewerField.type}: <code>"separator"</code>, this attribute specifies
    // the height of the separator.
    //
    // @visibility external
    //<

    //>    @method    detailViewerField.getCellStyle()
    // Optional method to return the CSS class for cells in this field. If specified, this method
    // will be called from +link{detailViewer.getCellStyle()}, and should return a css class name.
    //
    //        @param    value        (string) actual value of this cell
    //        @param    field      (object)    field object for this cell
    //        @param    record      (object) record object for this cell
    //      @param  viewer      (DetailViewer) the viewer instance to which this cell belongs
    //
    //        @return    (CSSStyleName)    CSS style for this cell
    // @group    appearance
    // @visibility external
    //<


    //>    @attr    detailViewerField.cellStyle (CSSClassName : null : IRW)
    // If specified, cells in this field will be rendered using this css className rather than
    // +link{detailViewer.cellStyle}
    // @visibility external
    //<

    //>    @attr    detailViewerField.printCellStyle (CSSClassName : null : IRW)
    // If specified, when generating print HTML for this detailViewer,
    // cells in this field will be rendered using this css className rather than
    // +link{detailViewer.printCellStyle}
    // @visibility external
    //<


    //> @attr detailViewerField.showFileInline    (boolean : null : [IR])
    // For a field of type:"imageFile", indicates whether to stream the image and display it
    // inline or to display the View and Download icons.
    //
    // @visibility external
    //<

    //> @attr detailViewerField.canExport (Boolean : null : IR)
    //    Dictates whether the data in this field be exported.  Explicitly set this
    //  to false to prevent exporting.  Has no effect if the underlying
    //  +link{dataSourceField.canExport, dataSourceField} is explicitly set to
    //  canExport: false.
    //
    // @visibility external
    //<

    //>    @attr    detailViewer.fieldIdProperty (string : "name" : IRWA)
    // Name of the field in the DetailViewerRecord which specifies the data property for that record.
    // @visibility external
    //<
    fieldIdProperty:"name",

    //> @attr detailViewerField.includeFrom (string : null : [IR])
    // Indicates this field's values come from another, related DataSource.
    // The individual field will inherit settings such as +link{DetailViewerField.type,field.type}
    // and +link{DetailViewerField.title,field.title} from the related DataSource just like
    // fields from the primary DataSource.
    //
    // @visibility crossDS
    //<

    // Multi-record display
    // --------------------------------------------------------------------------------------------

    //>    @attr    detailViewer.recordsPerBlock        (number : 1 : [IRW])
    //          The number of records to display in a block. A block is a horizontal row on a page
    //          containing one or more records, as specified by the value of recordsPerBlock. The
    //          height of a block is equal to the height of a single record. The default setting of
    //          1 causes each record to appear by itself in a vertical row. Setting recordsPerBlock
    //          to 2 would cause records to appear side by side in groups of two.
    //          Use a value of "*" to indicate all records.
    // @group appearance
    // @visibility external
    //<
    recordsPerBlock:1,

    //>    @attr detailViewer.blockSeparator (HTMLString : "<br><br>" : [IRW])
    // A string (HTML acceptable) that will be written to a page to separate blocks.
    // @group appearance
    // @visibility external
    //<
    blockSeparator:"<br><br>",

    // Empty values
    // --------------------------------------------------------------------------------------------

    //>    @attr    detailViewer.showEmptyField        (Boolean : true : IRWA)
    // Whether to show the field when the value is null
    // @group appearance
    // @visibility external
    //<
    showEmptyField:true,

    //> @attr detailViewerField.emptyCellValue (HTMLString : null : IR)
    // The value to display for a cell whose value is null or the empty
    // string after applying formatCellValue and valueMap (if any).
    // <p>
    // This is the field-specific attribute.  You may also set the emptyCellValue at the viewer
    // level to define the emptyCellValue for all empty fields in the viewer.
    //
    // @group appearance
    // @see detailViewer.emptyCellValue
    // @visibility external
    //<

    //>    @attr    detailViewer.emptyCellValue        (HTMLString : "&nbsp;" : IRWA)
    // Text to show for an empty cell
    // @group appearance
    // @visibility external
    //<
    emptyCellValue:"&nbsp;",

    // Labels
    // --------------------------------------------------------------------------------------------
    //>    @attr detailViewer.labelPrefix (HTMLString : "" : IRW)
    // text to put before a label
    // @group labels
    // @visibility external
    //<
    labelPrefix:"",

    //>    @attr detailViewer.labelSuffix (HTMLString : ":" : IRW)
    // text to put after a label
    // @group labels
    // @visibility external
    //<
    labelSuffix:":",

    //> @attr detailViewer.labelAlign (Alignment : null : IRW)
    // Horizontal alignment of value-labels in this viewer.  If unspecified, defaults to
    // <code>"left"</code> when in RTL mode and <code>"right"</code> otherwise.
    // @group labels
    // @visibility external
    //<
    //labelAlign: null,

    //> @attr detailViewer.valueAlign (Alignment : null : IRW)
    // Horizontal alignment of values in this viewer.  If unspecified, defaults to
    // <code>"right"</code> when in RTL mode and <code>"left"</code> otherwise.
    // @group values
    // @visibility external
    //<
    //valueAlign: null,

    //> @attr detailViewer.wrapLabel (Boolean : false : IRW)
    // Should the label be allowed to wrap, or be fixed to one line no matter how long
    // @group labels
    // @visibility external
    //<

    //> @attr detailViewer.wrapValues (Boolean : true : IR)
    // Whether values should be allowed to wrap by default, or should be shown on one line
    // regardless of length.
    //
    // @group labels
    // @visibility external
    //<
    wrapValues: true,

    // internal property used by tileGrid to force table size to be width 100%
    useInnerWidth: true,
    // internal property to clip cell values
    clipValues: false,

    // CSS styles
    // --------------------------------------------------------------------------------------------

    //>    @attr detailViewer.styleName (CSSStyleName : "detailViewer" : IRW)
    // CSS style for the component as a whole.
    // @group appearance
    // @visibility external
    //<
    styleName:"detailViewer",

    //>    @attr detailViewer.blockStyle (CSSStyleName : "detailBlock" : IRW)
    // CSS style for each block (one record's worth of data).
    // @group appearance
    // @visibility external
    //<
    blockStyle:"detailBlock",

    //>    @attr    detailViewer.labelStyle        (CSSStyleName : "detailLabel" : IRW)
    //            CSS style for a normal detail label
    // @group appearance
    // @visibility external
    //<
    labelStyle:"detailLabel",

    //>    @attr    detailViewer.cellStyle        (CSSStyleName : "detail" : IRW)
    //            CSS style for a normal value
    // @group appearance
    // @visibility external
    //<
    cellStyle:"detail",

    //>    @attr    detailViewer.headerStyle        (CSSStyleName : "detailHeader" : IRW)
    //            CSS style for a header
    // @group appearance
    // @visibility external
    //<
    headerStyle:"detailHeader",

    //> @attr detailViewer.printCellStyle (CSSStyleName : null : IRW)
    // Optional CSS style for a cell in printable HTML for this component. If unset
    // +link{detailViewer.cellStyle} will be used for printing as well as normal presentation.
    // @group printing
    // @visibility external
    //<

    //> @attr detailViewer.printLabelStyle (CSSStyleName : null : IRW)
    // Optional CSS style for a label cell in printable HTML for this component. If unset
    // +link{detailViewer.labelStyle} will be used for printing as well as normal presentation.
    // @group printing
    // @visibility external
    //<

    //> @attr detailViewer.printHeaderStyle (CSSStyleName : null : IRW)
    // Optional CSS style for a header in printable HTML for this component. If unset
    // +link{detailViewer.headerStyle} will be used for printing as well as normal presentation.
    // @group printing
    // @visibility external
    //<

    //>    @attr    detailViewer.separatorStyle        (CSSStyleName : "detail" : IRW)
    //            CSS style for a separator
    // @group appearance
    // @visibility external
    //<
    separatorStyle:"detail",

    //>    @attr    detailViewer.cellPadding        (number : 3 : [IRW])
    //          The amount of empty space, in pixels, surrounding each detailViewer value in its
    //          cell.
    //<
    cellPadding:3,

    //> @attr detailViewer.dateFormatter (DateDisplayFormat : null : [IRW])
    // How should Date type values be displayed in this DetailViewer by default?
    // <P>
    // This property specifies the default DateDisplayFormat to apply to Date values
    // displayed in this grid for all fields except those of +link{detailViewerField.type,type "time"}
    // (See also +link{detailViewer.timeFormatter}).<br>
    // If +link{detailViewer.datetimeFormatter} is specified, that will be applied by default
    // to fields of type <code>"datetime"</code>.
    // <P>
    // Note that if +link{detailViewerField.dateFormatter} or +link{detailViewerField.timeFormatter} are
    // specified those properties will take precedence over the component level settings.
    // <P>
    // If unset, date values will be formatted according to the system wide
    // +link{Date.setNormalDisplayFormat(),normal display format}.
    //
    // @visibility external
    //<
    //dateFormatter:null,


    //> @attr detailViewer.datetimeFormatter (DateDisplayFormat : null : [IRW])
    // Display format to use for fields specified as type 'datetime'.  Default is to use the
    // system-wide default long ("normal") date time format, configured via
    // +link{Date.setNormalDatetimeDisplayFormat()}.  Specify any
    // valid +link{type:DateDisplayFormat} to change the display format for datetimes used by this
    // viewer.
    // <smartclient>
    // May be specified as a function. If specified as  a function, this function will
    // be executed in the scope of the Date
    // and should return the formatted string.
    // </smartclient>
    // <P>
    // May also be specified at the field level via
    // +link{detailViewerField.dateFormatter}
    //
    // @see listGridField.dateFormatter
    // @group appearance
    // @visibility external
    //<

    //>    @attr detailViewer.timeFormatter (TimeDisplayFormat : null : [IRW])
    // Display format to use for fields specified as type 'time'.  May also be specified at
    // the field level via +link{detailViewerField.timeFormatter}.<br>
    // If unset, time fields will be formatted based on the system wide
    // +link{Time.setNormalDisplayFormat()}
    // @group appearance
    // @visibility external
    //<

    //> @attr detailViewer.linkTextProperty (string : "linkText" : [IRW])
    // Property name on a record that will hold the link text for that record.
    // <p>
    // This property is configurable to avoid possible collision with data values in the
    // record.
    // <p>
    // Use +link{detailViewerField.linkTextProperty} if you have more than one link field and
    // the fields' records do not use the same property to store the linkText.
    // @see attr:detailViewerField.linkText
    // @see attr:detailViewerField.linkTextProperty
    // @visibility external
    //<
    linkTextProperty : "linkText",



    // Empty Message
    // --------------------------------------------------------------------------------------------

    //>    @attr    detailViewer.showEmptyMessage        (Boolean : true : IRWA)
    // Show +link{attr:detailViewer.emptyMessage} when there is no data to display?
    // @see emptyMessage
    // @group emptyMessage
    // @visibility external
    //<
    showEmptyMessage:true,

    //>    @attr detailViewer.emptyMessage (HTMLString : "No items to display." : IRW)
    //          The string to display in the body of a detailViewer with no records.
    // @group emptyMessage
    // @visibility external
    //<
    emptyMessage:"No items to display.",

    //>    @attr    detailViewer.emptyMessageStyle        (CSSStyleName : "normal" : IRWA)
    // CSS style to display this message in
    // @group emptyMessage
    // @visibility external
    //<
    emptyMessageStyle:"normal",

    //> @attr detailViewer.loadingMessage (HTMLString : "&nbsp;${loadingImage}" : IRW)
    // The string to display in the body of a detailViewer which is loading records.
    // Use <code>"&#36;{loadingImage}"</code> to include +link{Canvas.loadingImageSrc,a loading image}.
    // @group emptyMessage
    // @visibility external
    //<
    loadingMessage:"&nbsp;${loadingImage}",

    //>    @attr    detailViewer.loadingMessageStyle        (CSSStyleName : "normal" : IRWA)
    // CSS style to use for the +link{loadingMessage}.
    // @group emptyMessage
    // @visibility external
    //<
    loadingMessageStyle:"normal",

    // ---------------------------------------------------------------------------------------
    // About two values worth of data.   Keeps the DV from taking up the 100px default height
    // without being unexpectedly small when it has no data.
    defaultHeight:35 ,

    showLabel: true
});


// add methods
isc.DetailViewer.addMethods({


//>    @method    detailViewer.initWidget()    (A)
//            initializes the list of fields
//            sets up the data (if specified)
//
//        @param    [all arguments]    (object)    objects with properties to override from default
//<
initWidget : function () {
    // default alignments - non-RTL is labels to the right, values to the left
    if (this.labelAlign == null) this.labelAlign = this.isRTL() ? "left" : "right";
    if (this.valueAlign == null) this.valueAlign = this.isRTL() ? "right" : "left";
    // call the superclass function
    this.Super("initWidget",arguments);

    // set field state if necessary, call setFields() otherwise
    if (this.fieldState != null) this.setFieldState(this.fieldState);
    else this.setFields(this.fields);

    // create context menu for field picker
    if (this.canPickFields) {
        this.contextMenu = isc.Menu.create({
            data: [ this.createFieldPickerWindowMenuItem(this.configureFieldsText) ]
        });
    }
},

//>    @method    detailViewer.setData()  ([])
// Sets the data displayed by this detail viewer.
//
//      @visibility external
//        @param    newData        (object or array)    new data to be displayed
//<
setData : function (newData) {

    // clear old observation
    if (this.data) this.ignore(this.data, "dataChanged");

    this.invalidateUserCache();

    // remember the new data
    this.data = newData;

    if (this.data && this.data.dataChanged) {
        this.observe(this.data, "dataChanged", "observer.dataChanged()");
    }

    // and mark the viewer as dirty so it'll be redrawn
    this.markForRedraw("new data");
},

dataChanged : function () {
    // call setFields() on dataChanged - causes showIf to be re-evaluated
    this.setFields(this.completeFields);
    this.invalidateUserCache();
    this.applyHilites();
    this.markForRedraw();
},

//>    @method    detailViewer.getData()    (A)
//            return the data to be displayed
//
//        @return    (Object)    data for this widget - either Object or Array
//<
getData : function () { return this.data; },

//> @method detailViewer.fetchRelatedData()
// Based on the relationship between the DataSource this component is bound to and the
// DataSource specified as the "schema" argument, call fetchData() to retrieve records in this
// data set that are related to the passed-in record.
// <P>
// Relationships between DataSources are declared via +link{dataSourceField.foreignKey}.
// <P>
// For example, given two related DataSources "orders" and "orderItems", where we want to fetch
// the "orderItems" that belong to a given "order".  "orderItems" should declare a field that
// is a +link{dataSourceField.foreignKey,foreignKey} to the "orders" table (for example, it
// might be named "orderId" with foreignKey="orders.id").  Then, to load the records related to
// a given "order", call fetchRelatedData() on the component bound to "orderItems", pass the
// "orders" DataSource as the "schema" and pass a record from the "orders" DataSource as the
// "record" argument.
// <p>
// <b>Note:</b> When you expect a large number of records to be returned it is not recommended to
// display these in the DetailViewer as it doesn't have the same level of support for large
// datasets as the +link{ListGrid}.
//
// @param record              (ListGridRecord) DataSource record
// @param schema              (Canvas or DataSource or ID) schema of the DataSource record, or
//                            DataBoundComponent already bound to that schema
// @param [callback]          (DSCallback)  callback to invoke on completion
// @param [requestProperties] (DSRequest)   additional properties to set on the DSRequest
//                                            that will be issued
//
// @group dataBoundComponentMethods
// @visibility external
//<

//>    @method    detailViewer.getFields()    (A)
//            return the list of fields to display
//
//        @return    (List of DetailViewerField)    array of objects to display
//<
getFields : function () { return this.fields; },


//>    @method    detailViewer.getInnerHTML()    (A)
//            return the HTML for this widget
//        @return    (string)    HTML to display
//<
getInnerHTML : function () {
    // get the data to display
    var valueList = this.getData();

    //>DEBUG
    if (this.fields == null || this.fields.length == 0) {
        return "Note: you must define detailViewer.fields to specify what to display!";
    }
    //<DEBUG

    // If the data is a ResultSet, poke the ResultSet to fetch data and return the loading
    // message.  Note that if fetchData() is called, this isn't the codepath that causes the
    // initial fetch - see DataBoundComponent.requestVisibleRows.
    if (isc.ResultSet != null && isc.isA.ResultSet(valueList) && !valueList.lengthIsKnown()) {
        // request only the first row.  If this ResultSet is using fetchMode:"paged" (not the
        // default for DetailViewer) and has already issued a request for data, asking for
        // anything beyond the current rs.resultSize will initiate additional fetches, possibly
        // for rows that don't exist, but the ResultSet doesn't know that while
        // !lengthIsKnown().
        valueList.get(0);
        return this.loadingMessageHTML();
    }

    if (valueList == null || (valueList.getLength && valueList.getLength() == 0)) {
        return this.emptyMessageHTML();
    }

    // normalize the data into an array
    if (!isc.isA.List(valueList)) valueList = [valueList];

    // With DV, we have a situation where a failed load results in lengthIsKnown being true,
    // but the data actually consists of a single loading marker.  The upshot of this is that
    // the DetailViewer displays an empty record, which is probably fair enough (since the
    // load probably failed because the record doesn't exist).  However, if the load failed
    // because we're offline, we want to show that specifically, so treat it as a special case
    if (Array.isLoading(valueList.get(0)) && this.isOffline())  {
        return this.emptyMessageHTML();
    }

    // if there's only one item or we're supposed to show all columns together
    if (valueList.getLength() == 1 || this.recordsPerBlock == "*") {
        // call the blockHTML routine with all items
        return this.getBlockHTML(valueList);
    } else {
        // otherwise call it for each item separately
        var output = isc.StringBuffer.create();
        for (var startRow = 0; startRow < valueList.getLength(); startRow += this.recordsPerBlock) {
            output.append(this.getBlockHTML(valueList.getRange(startRow, startRow + this.recordsPerBlock)), this.blockSeparator);
        }
        return output.release(false);
    }
},

//>    @method    detailViewer.getBlockHTML()    (A)
// Return the HTML for either a single object or a set of objects where each object gets one
// column.
//        @return    (string)    HTML to display
//<
getBlockHTML : function (valueList) {

    if (valueList.getLength == null) {
        var newArray = [];
        for (var i = 0; i < valueList.length; i++) {
            newArray[i] = valueList[i];
        }
        valueList = newArray;
    }

    // how many separate value objects are we dealing with ?
    var numValues = valueList.getLength();
    // start the table to display the output
    var output = "<TABLE BORDER=0 CELLSPACING=0 CLASS='" + this.blockStyle +
            "' CELLPADDING='" + this.cellPadding +
            "' style='width:" + (this.useInnerWidth && !this.isPrinting
                                 ? this.getInnerWidth() + "px"
                                 : "100%") +
            (this.clipValues ? ";table-layout:fixed" : "") +
            "'>";


    // output the data

    // get the list of fields to output
    var fields = this.fields;

    // iterate through each of the keys in detailFields and output the info for each field
    for (var fieldNum = 0, fieldLength = fields.length; fieldNum < fieldLength; fieldNum++) {
        var field = fields[fieldNum];
        if (!field || field.hidden || field.visible == false) continue;

        // if the field has a showIf property
        if (field.showIf) {
            // CALLBACK API:  available variables:  "viewer,valueList"
            // Convert a string callback to a function

            if (!isc.isA.Function(field.showIf)) {
                isc.Func.replaceWithMethod(field, "showIf", "viewer,valueList");
            }

            // skip this if the showIf returns false
            if (field.showIf(this, valueList) == false) continue;
        }

        // MAE: if we don't want to show fields that have empty/null values
        // check the appropriate values and skip if they are all empty/null
        // This does not apply to headers and separators
        var type = field.type ? field.type : "";
        if (type != "separator" && type != "header" && !this.showEmptyField) {
            var valuesAreEmpty = true;
            for (var i = 0; i < valueList.getLength(); i++) {
                var value = valueList.get(i)[field[this.fieldIdProperty]]
                if (!(value == null || value == "")) {
                    valuesAreEmpty = false;
                    break;
                }
            }
            // if no values were found, continue to the next field
            if (valuesAreEmpty) continue;
        }

        // if there is a specific output function for this field, call that
        if (field.output) {
            // CALLBACK API:  available variables:  "fieldNum,field,valueList"
            // Convert a string callback to a function
            if (!isc.isA.Function(field.output)) {
                isc.Func.replaceWithMethod(field, "output", "fieldNum,field,valueList");
            }
            output += field.output(fieldNum, field, valueList);
        } else {
            // output this particular field
            output += this.outputItem(fieldNum, field, valueList);
        }
    }
    // end the table
    output += "</TABLE>";
    // and return the output
    return output;
},

//>    @method    detailViewer.fieldIsVisible()
// Check whether a field is currently visible
//
// @param    field  (String | DetailViewerField)    field to be checked
// @return (boolean) true if the field is currently visible, false otherwise.
// @visibility external
//<
fieldIsVisible : function (field) {
    var fieldObj = field;
    // If passed a field ID, look for it in the completeFields array rather than the fieldsArray
    // as it is may be defined, but not visible
    if (!isc.isAn.Object(fieldObj)) fieldObj = this.getSpecifiedField(field);

    return this.fields.contains(fieldObj);
},

//>    @method    detailViewer.outputItem()    (A)
// Output one row of the data as HTML
//        @param    fieldNum        (number)        number of the field to output
//        @param    field        (object)        pointer to the field to output
//        @param    valueList    (array)            list of values to output
//
//        @return    (string)    HTML output
//<
outputItem : function (fieldNum, field, valueList) {

    var type = (field.type ? field.type : "value"),
        // functionName == name of a function to call to output this particular type of object
        functionName = "output_"+type,
        output = ""
    ;
    // if a function by that name cannot be found, default to output_value
    if (!this[functionName]) functionName = "output_value";
    // start the table row
    output += "<TR " + (this.rowHeight != null ? "HEIGHT='" + this.rowHeight + "'" : "")
            + (this.rowClass != null ? " CLASS='" + this.rowClass + "'" : "")
            + ">";

    // output
    output += this[functionName](fieldNum, field, valueList);

    // end the row
    output += "</TR>\r";

    // return the output
    return output;
},


//
//    OUTPUT HTML FOR DIFFERENT TYPES OF OBJECTS
//


//>    @method    detailViewer.output_value()    (A)
//            output a normal value for each field in valueList
//        @param    fieldNum        (number)        number of the field to output
//        @param    field        (object)        pointer to the field to output
//        @param    valueList    (array)            list of values to output
//
//        @return    (string)    HTML output
//<
output_blob : function (fieldNum, field, valueList) {
    return this.output_binary(fieldNum, field, valueList);
},
output_upload : function (fieldNum, field, valueList) {
    return this.output_binary(fieldNum, field, valueList);
},
output_binary : function (fieldNum, field, valueList) {
    // output the label
    var output = "<TD WIDTH=10% CLASS='" +
            (this.isPrinting ? this.printLabelStyle || this.labelStyle : this.labelStyle)
            + "' style='text-align:" + this.labelAlign + ";'"
            + (this.wrapLabel ? ">" : " NOWRAP><NOBR>")
            + this.labelPrefix + (field.title ? field.title : field[this.fieldIdProperty]) + this.labelSuffix
            + (this.wrapLabel ? "" : "<\/NOBR>")
            + "<\/TD>"
    ;

    // iterate for each object in valueList, outputting the object[field[this.fieldIdProperty]]
    for (var i = 0; i < valueList.getLength(); i++) {

        var record = valueList.get(i),
            index = this.getData().indexOf(record),
            filenameField = this.dataSource ?
                                isc.DS.getDataSource(this.dataSource).getFilenameField(field.name) :
                                field.name + "_filename",
            name = record[filenameField],
            viewAction = "'" + this.getID() +".view",
            dlAction = "'" + this.getID() +".download",
            completion = "";
            if (field && field.name) {
                completion = "Cell(" + index + ", \"" + field.name + "\")'";
            } else {
                completion = "Row(" + index + ")'";
            }
            var viewIconHTML = isc.Canvas.imgHTML("[SKIN]actions/view.png", 16, 16, null,
                            "style='cursor:"+isc.Canvas.HAND+"' onclick="+viewAction+completion);
            var viewIconHTML = isc.Canvas.imgHTML("[SKIN]actions/view.png", 16, 16, null,
                        "style='cursor:"+isc.Canvas.HAND+"' onclick="+viewAction+completion),
            downloadIconHTML = isc.Canvas.imgHTML("[SKIN]actions/download.png", 16, 16, null,
                        "style='cursor:"+isc.Canvas.HAND+"' onclick="+dlAction+completion),
            value = viewIconHTML + "&nbsp;" + downloadIconHTML +
                (name ? "&nbsp;" + name : "");

        // output the value as a cell
        output += "<TD CLASS='" + this.getCellStyle(value, field, record, this) + "'>"
                  + value + "<\/TD>";
    }
    return output;

},

viewRow : function (index) {
    isc.DS.get(this.dataSource).viewFile(this.getData().get(index));
},

downloadRow : function (index) {
    isc.DS.get(this.dataSource).downloadFile(this.getData().get(index));
},

viewCell : function (index, fieldName) {
    isc.DS.get(this.dataSource).viewFile(this.getData().get(index), fieldName);
},

downloadCell : function (index, fieldName) {
    isc.DS.get(this.dataSource).downloadFile(this.getData().get(index), fieldName);
},

// given an Array of records (valueList) output one complete DetailViewer row, which will have
// multiple data columns if recordsPerBlock > 1
output_value : function (fieldNum, field, valueList) {

    // output the label
    var output;
    if (this.showLabel) {
        output = "<TD WIDTH="+(this.labelWidth != null ? this.labelWidth : "10%")+" CLASS='" +
                (this.isPrinting ? this.printLabelStyle || this.labelStyle : this.labelStyle)
                + "' style='text-align:" + this.labelAlign + ";'"
            + (this.wrapLabel ? ">" : " NOWRAP><NOBR>")
            + this.labelPrefix + (field.title ? field.title : field[this.fieldIdProperty]) + this.labelSuffix
            + (this.wrapLabel ? "" : "<\/NOBR>")
            + "<\/TD>"
        ;
    } else {
        output = "";
    }
    // resolve field level valueMap reference strings to objects before going into the for loop
    if (field.valueMap && isc.isA.String(field.valueMap))
        field.valueMap = this.getGlobalReference(field.valueMap);

    // iterate for each object in valueList, outputting the object[field.name]
    for (var i = 0; i < valueList.getLength(); i++) {
        var record = valueList.get(i),
            onclick = "",
            formattedValue;
        if (field.type == "image") {
            // if any of field.imageWidth/Height/Size are set as strings, assume they are property
            // names on the record
            var dimensions = isc.Canvas.getFieldImageDimensions(field, record);

            var src = this.getCellValue(record, field), prefix =
                field.imageURLPrefix || field.baseURL || field.imgDir;

            if (src == this._resolveEmptyDisplayValue(field)) {
                formattedValue = this._resolveEmptyDisplayValue(field);
            } else {
                formattedValue = this.imgHTML(src, dimensions.width, dimensions.height, null,
                    field.extraStuff, prefix, field.activeAreaHTML);
            }
        } else if (field.type == "link") {
            // The value of the field is the URL for a link.  The URL will also be used for
            // the text of the link, unless it is overridden by a linkText property on the
            // field or on the record.
            var target = field.target || "_blank",
                linkTextProperty = field.linkTextProperty || this.linkTextProperty,
                value = this.getCellValue(record, field),
                linkText = record[linkTextProperty] || field.linkText || value,
                href = value;

            if (href == this._resolveEmptyDisplayValue(field)) {
                formattedValue =  this._resolveEmptyDisplayValue(field);
            } else {
                // Each field may add a prefix and/or suffix onto the URL.
                if (field.linkURLPrefix) {
                    href = field.linkURLPrefix + href;
                }
                if (field.linkURLSuffix) {
                   href = href + field.linkURLSuffix;
                }
                if (target == "javascript") {
                    // target is "javascript" - make the link inert and have the field's click
                    // event fired instead
                    href = "javascript:void";
                    onclick = " onclick=\"if(window." + this.ID + ") return " +
                        this.ID + "._linkClicked(event,'" + field.name + "');\"";
                }

                formattedValue = this.linkHTML(href, linkText, target);
            }

        } else {
            // NOTE: calls formatCellValue()
            formattedValue = this.getCellValue(record, field);
        }

        // determine the cell style
        var rawValue = this.getRawValue(record,field);
        var cellStyle;
        if (field.getCellStyle) {
            cellStyle = field.getCellStyle(rawValue, field, record, this);
        } else {
            cellStyle = (this.getCellStyle(rawValue, field, record, this) || this.cellStyle);
        }

        // put together a STYLE attribute
        var styleStr = " style='";
        if (this.clipValues) styleStr += "overflow:hidden;";
        styleStr += "text-align:" + this.valueAlign;

        // allow custom CSS text per field
        if (this.getCellCSSText) {
            var cssText = this.getCellCSSText(rawValue, field, record, this);
            if (cssText != null) styleStr += isc.semi + cssText;
        }

        // output the value as a cell
        styleStr += "'";
        output += "<TD CLASS='" + cellStyle + "'" + styleStr +
            (field.height?"HEIGHT='"+field.height+"' ":"") +
            onclick +
            (this.wrapValues ? ">" : " NOWRAP><NOBR>") +
            formattedValue +
            (this.wrapValues ? "" : "<\/NOBR>") +
            "<\/TD>";
    }
    return output;
},

_linkClicked : function (event, fieldName) {
    var field = this.fields.find("name", fieldName) || {},
        mustCancel = false
    ;
    if (event.target == "javascript" || field.target == "javascript") {
        mustCancel=true;
        if (field.click) field.click();
    }

    if (mustCancel) {

        if (!isc.Browser.isIE) {
            event.preventDefault();
        }

        return false;
    }
    return true;
},

//>    @method    detailViewer.getCellCSSText()
// Return CSS text for styling this cell, which will be applied in addition to the CSS class
// for the cell, as overrides.
// <p>
// "CSS text" means semicolon-separated style settings, suitable for inclusion in a CSS
// stylesheet or in a STYLE attribute of an HTML element.
//
// @param value (any) actual value of this cell
// @param field (DetailViewerField)    field object for this cell
// @param record (Record) record object for this cell
// @param viewer (DetailViewer) the viewer instance to which this cell belongs
// @return (CSSText) CSS text to add to this cell
//
// @group appearance
// @visibility external
//<
getCellCSSText : function (value, field, record, viewer) {

    return this.getRecordHiliteCSSText(record, "", field, true);
},

//>    @method    detailViewer.getCellStyle()
// Return the CSS class for a cell. Default implementation calls
// +link{detailViewerField.getCellStyle(), getCellStyle()} on the field if defined, otherwise
// returns +link{detailViewer.cellStyle,this.cellStyle}
// @param value (any) actual value of this cell
// @param field (DetailViewerField)    field object for this cell
// @param record (Record) record object for this cell
// @param viewer (DetailViewer) the viewer instance to which this cell belongs
// @return (CSSStyleName) CSS style for this cell
// @group appearance
// @visibility external
//<
// <P>
// Note: if +link{detailViewer.printCellStyle} is specified this will be used as the default
// styling for cells instead of <code>this.cellStyle</code> when generating printable HTML for
// this component.
getCellStyle : function (value, field, record, viewer) {
    if (field) {
        if (field.getCellStyle) return field.getCellStyle(value,field,record,viewer);
        if (this.isPrinting && field.printCellStyle) {
            return field.printCellStyle;
        }
        if (field.cellStyle) {
            return field.cellStyle;
        }
    }
    return (this.isPrinting && this.printCellStyle != null) ? this.printCellStyle
                                                              : this.cellStyle;
},

//> @method DetailViewer.formatCellValue()
// Optional method to format the value to display for cells in this DetailViewer.
// Note that if +link{detailViewerField.formatCellValue()} is specified this method will not
// be called for cells within that field.
// @param value (string) the raw value of the cell (may be formatted by
//   +link{detailViewerField.formatCellValue()}
// @param record (detailViewerRecord) the record being displayed
// @param field (detailViewerField) the field being displayed
// @visibility external
//<

getSelectedRecord : function() {
    return this.data.get(0);
},

// getCellValue - method to actually get the value for a record.
// Called from 'output_value', which handles writing the <TD> tags around the value and
// outputting a whole block of records.
// Can be overridden by a user.
// Also if 'getCellValue()' is specified at a field level, will apply it to this cell.

getCellValue : function (record, field) {

    // get the value of this key for that field
    var value = this.getRawValue(record,field);
    if (isc.isA.String(field.formatCellValue)) {
        field.formatCellValue = isc.Func.expressionToFunction("value,record,field,viewer",
                                                              field.formatCellValue);
    }
    if (field.getCellValue != null) {
        if (isc.isA.String(field.getCellValue)) {
            field.getCellValue = isc.Func.expressionToFunction("value,record,field,viewer",
                                                                field.getCellValue);
        }
        // note the 'value' passed into field.getCellValue() is the raw value, not valueMapped, etc.
        // This matches the ListGrid's field-level getCellValue behavior.
        value = field.getCellValue(value, record, field, this);
        if (field.formatCellValue) value = field.formatCellValue(value, record, field, this);
    } else {

        // if the col has an 'valueMap' parameter, treat the value as a key in the valueMap
        if (field.valueMap != null) value = isc.getValueForKey(value, field.valueMap);

        if (field.formatCellValue) value = field.formatCellValue(value, record, field, this);
    }

    // Support formatCellValue if specified.
    // - to match ListGrid behavior, don't run both field.formatCellValue and DV.formatCellValue()
    if (field.formatCellValue == null && this.formatCellValue) {
        value = this.formatCellValue(value, record, field);
    } else {
        // if no value was specified, output the emptyCellValue
        if (value == null || isc.is.emptyString(value)) {
            value = this._resolveEmptyDisplayValue(field);
        } else {
            // _formatDataType ensures that non string values get formatted as strings as appropriately
            value = this._formatDataType(record, field, value);

            // field.escapeHTML is a boolean - if true, escape HTML chars in the value such as "<".
            var escapeHTML = field.escapeHTML;
            // asHTML was old name
            if (escapeHTML == null) escapeHTML = field.asHTML;
            if (escapeHTML) value = value.asHTML();
        }
    }

    // handle formula and summary fields
    if (field) {
        if (field.userFormula) value = this.getFormulaFieldValue(field, record);
        else if (field.userSummary) value = this.getSummaryFieldValue(field, record);
        else if (field.type=="imageFile") {
            var filenameField = this.dataSource ?
                        isc.DS.getDataSource(this.dataSource).getFilenameField(field.name) :
                        field.name + "_filename";
            if (record[filenameField] != null) {
                if (field.showFileInline != false) {
                    if (!record[field[this.fieldIdProperty] + "_imgURL"]) {
                        var dimensions = isc.Canvas.getFieldImageDimensions(field, record),
                            image = this.getDataSource().getFileURL(record,
                                                                field[this.fieldIdProperty]);
                        value = record[field[this.fieldIdProperty] + "_imgURL"] =
                            this.imgHTML(image, dimensions.width, dimensions.height,
                                         null, null, isc.Canvas._$allowRelativeSrc);
                    } else
                        value = record[field[this.fieldIdProperty] + "_imgURL"];
                } else {
                    value = this.getViewDownloadHTML(field, record);
                }
            }
        } else if (field.showFileInline == true) { // non-imageFile field
            this.logWarn("getCellValue(): Unsupported field-type for showFileInline: "+field.type);
        }
        if (isc.isA.Number(value)) {
            if (isc.SimpleType.inheritsFrom(field.type, "float") &&
                (field.decimalPrecision != null || field.decimalPad != null))
            {
                value = isc.Canvas.getFloatValueAsString(value, field.decimalPrecision,
                                                         field.decimalPad);
            } else if (field.precision != null) {
                value = isc.Canvas.getNumberValueAsString(value, field.precision, field.type);
            }
        }
    }

    // apply hilites to capture htmlBefore/after
    var hilites = this.getFieldHilites(record, field);
    if (hilites != null) {
        value = this.applyHiliteHTML(hilites, value);
        // Finally, apply the hiliteIcon if present
        value = this.applyHiliteIcon(hilites, field, value);
    }

    return value;
},

getViewDownloadHTML : function (field, record) {

    if (record == null) return null;

    var filenameField = this.dataSource ?
                isc.DS.getDataSource(this.dataSource).getFilenameField(field.name) :
                field.name + "_filename",
        name = record[filenameField];


    if (!field.filenameSuppressed && (name == null || isc.isA.emptyString(name))) {
        return "&nbsp;";
    }

    var viewIconHTML = isc.Canvas.imgHTML("[SKIN]actions/view.png", 16, 16, null,
            "style='cursor:"+isc.Canvas.HAND+
            "' onclick='"+this.getID()+".viewFile("+record+","+field+")'");
    var downloadIconHTML = isc.Canvas.imgHTML("[SKIN]actions/download.png", 16, 16, null,
            "style='cursor:"+isc.Canvas.HAND+
            "' onclick='alert('running');"+this.getID()+".downloadFile("+record+","+field+")'");

    return "<nobr>" + viewIconHTML + "&nbsp;" + downloadIconHTML + "&nbsp;" + name + "</nobr>";
},

viewFile : function (record, field) {
    isc.DS.get(this.dataSource).viewFile(record, field.name);
},

downloadFile : function (record, field) {
    isc.DS.get(this.dataSource).downloadFile(record, field.name);
},

// _formatDataType, format a cell value based on data type.
// At this point we've checked for field.formatValue etc. Current implementation:
// - if a formatter is defined on the SimpleType make use of it
// - otherwise format dates according to standard DBC rules:
//  - use field.dateFormatter or field.timeFormatter if specified
//  - otherwise use component.dataFormatter, component.timeFormatter, component.datetimeFormatter
//    depending on field type.
_$date:"date",
_formatDataType : function (record, field, value, isMultipleElement) {

    if (!isMultipleElement && field && field.multiple && isc.isA.Array(value)) {
        var values = [];
        for (var i = 0; i < value.length; i++) {
            values[i] = this._formatDataType(record, field, value[i], true);
        }
        return values.join(field.multipleValueSeparator || ", ");
    }

    // Apply declarative FormatString if present
    if (field && (isc.isA.Number(value) || isc.isA.Date(value)) && field.format) {
        return isc.isA.Number(value) ? isc.NumberUtil.format(value, field.format)
                                     : isc.DateUtil.format(value, field.format);
    }

    // Format date values, according to standard DBC rules
    // Respect field level dateFormatter/timeFormatter if specified
    // Otherwise respect component level dateFormatter/datetimeFormatter/timeFormatter depending
    // on specified field-type.
    if (isc.isA.Date(value)) {
        if (this._formatAsTime(field)) {
            var isLogicalTime = isc.SimpleType.inheritsFrom(field.type, "time");
            value = isc.Time.toTime(value, this._getTimeFormatter(field), isLogicalTime);
        } else {
            var formatter = this._getDateFormatter(field);
            // If the field is a logical date field
            //  use short formatter, since the "time" part of
            // the date has no real meaning (and no long formatters suppress time).
            // Otherwise use the long format by default for DetailViewers.
            if (isc.SimpleType.inheritsFrom(field.type, "date") &&
                !isc.SimpleType.inheritsFrom(field.type, "datetime"))
            {

                value = value.toShortDate(formatter, false);
            } else {
                value = value.toNormalDatetime(formatter);
            }
        }
    }

    // if the field has a valueMap, get the display value from it
    if (field.valueMap && field.valueMap[""+value+""] != null) {
        value = field.valueMap[""+value+""];
    }

    // If normalDisplayFormatter is specified on the simpleType make use of it
    if (field._simpleType != null && field._simpleType.normalDisplayFormatter != null) {
        value = field._simpleType.normalDisplayFormatter(value, field, this, record);
    }

    return isc.iscToLocaleString(value);
},

_formatAsTime : function (field) {
    if (field == null) return false;
    if (field.dateFormatter == null && field.timeFormatter != null) return true;
    if (field.timeFormatter == null && field.dateFormatter != null) return false;
    return isc.SimpleType.inheritsFrom(field.type, "time");
},

_getDateFormatter : function (field) {
    if (field.dateFormatter) return field.dateFormatter;
    if (field.displayFormat != null && isc.SimpleType.inheritsFrom(field.type, "date")) {
        return field.displayFormat;
    }
    if (this.datetimeFormatter != null && isc.SimpleType.inheritsFrom(field.type, "datetime")) {
        return this.datetimeFormatter;
    }
    return this.dateFormatter;
},

_getTimeFormatter : function (field) {
    if (field.timeFormatter) return field.timeFormatter;
    if (field.displayFormat != null && isc.SimpleType.inheritsFrom(field.type, "time")) {
        return field.displayFormat;
    }
    return this.timeFormatter;
},

//> @method detailViewer.getRecordIndex()
// @param record (Record) the record whose index is to be retrieved
// @return index (Number) index of the record, or -1 if not found
// @include dataBoundComponent.getRecordIndex
// @visibility external
//<
getRecordIndex : function (record) {
    var result = this.Super('getRecordIndex', arguments);
    if (result==-1) result = 0;
    return result;
},


//>    @method    detailViewer.output_header()    (A)
//            output a header field
//        @param    fieldNum        (number)        number of the field to output
//        @param    field        (object)        pointer to the field to output
//        @param    valueList    (array)            list of values to output
//
//        @return    (string)    HTML output
//<
output_header : function (fieldNum, field, valueList) {
    return "<TD COLSPAN=" + (valueList.getLength() + 1) + " CLASS='" +
    (this.isPrinting && this.printHeaderStyle ? this.printHeaderStyle : this.headerStyle) +
    "'>"+field.value+"</TD>";
},


//>    @method    detailViewer.output_separator()    (A)
//            output a separator field
//        @param    fieldNum        (number)        number of the field to output
//        @param    field        (object)        pointer to the field to output
//        @param    valueList    (array)            list of values to output
//
//        @return    (string)    HTML output
//<
output_separator : function (fieldNum, field, valueList) {
    var width = (field.width == null ? field.defaultSeparatorWidth : field.width),
        height = (field.height == null ? field.defaultSeparatorHeight : field.height)
    ;
    return "<TD COLSPAN=" + (valueList.getLength() + 1) + " CLASS='" + this.separatorStyle + "'>"
            + isc.Canvas.spacerHTML(width, height)
            + "</TD>";
},


//>    @method    detailViewer.getEmptyMessage()    (A)
//            return the empty message to display when no data was specified
//            this is a function so you can override it in complex cases
//            in simple cases, just returns this.emptyMessage
//
//        @return    (string)    HTML output
//<
getEmptyMessage : function () {
    return this.emptyMessage;
},
getLoadingMessage : function () {
    return this.loadingMessage == null ? "&nbsp;" : this.loadingMessage.evalDynamicString(this, {
        loadingImage: this.imgHTML(isc.Canvas.loadingImageSrc,
                                   isc.Canvas.loadingImageSize,
                                   isc.Canvas.loadingImageSize)
        });
},


//>    @method    detailViewer.emptyMessageHTML()    (A)
// Return the message to show if the component has no data. Default implementation returns a
// centered +link{detailViewer.emptyMessage} or "&amp;nbsp;" if showEmptyMessage is false.  If
// the component has no data because the browser is offline, we instead display the
// +link{dataBoundComponent.offlineMessage} or "&amp;nbsp;" if showOfflineMessage is false
// @return    (string)    HTML output
// @visibility external
//<
emptyMessageHTML : function () {

    if (this.isOffline()) {
        if (!this.showOfflineMessage) return "&nbsp;";
    } else {
        if (!this.showEmptyMessage) return "&nbsp;";
    }

    return "<TABLE WIDTH=100%>"
            + "<TR><TD CLASS='" + this.emptyMessageStyle + "' ALIGN=CENTER><BR><BR>"
            + (this.isOffline() ? this.offlineMessage : this.getEmptyMessage())
            + "<\/TD><\/TR><\/TABLE>";

},

//>    @method    detailViewer.loadingMessageHTML()    (A)
//            return the message to display while the data is loading
//
//        @return    (string)    HTML output
//<
loadingMessageHTML : function () {
    return "<TABLE WIDTH=100%>"
            + "<TR><TD CLASS='" + this.loadingMessageStyle + "' ALIGN=CENTER><BR><BR>"
            + this.getLoadingMessage()
            + "<\/TD><\/TR><\/TABLE>";
},

setFieldState : function (fieldState) {
    if (fieldState == null && this.fieldState != null) {
        if (isc.isA.String(this.fieldState)) {
            fieldState = this.evalViewState(this.fieldState, "fieldState")
        }
    } else fieldState = this.evalViewState(fieldState, "fieldState");

    this.completeFields = this._setFieldState(fieldState, true);
    this.setFields(this.completeFields);
    this.markForRedraw();
    this.fieldStateChanged();
},

// minimal implementation of setFields()
setFields : function (newFields) {
    if (this.completeFields == null || this.fields == null) this.fields = [];

    // bind the passed-in fields to the DataSource and store
    this.completeFields = this.bindToDataSource(newFields);

    if (this.completeFields == null) this.completeFields = [];

    this.deriveVisibleFields();
    this.updateFieldDependencies();
},

// determine which fields should be shown, and add them to the visible fields array.
// (Used as an internal helper - developers should call 'refreshFields' instead)
deriveVisibleFields : function () {
    // NOTE: we use setArray() so that this.fields remains the same array instance.
    this.fields.setArray(this.getVisibleFields(this.completeFields));
},

getVisibleFields : function (fields) {
    var valueList = this.getData(),
        returnFields = fields.duplicate();
    for (var i=0; i<fields.length; i++) {
        var field = fields.get(i);
        if (!this.fieldShouldBeVisible(field, valueList) ||
            field.visible==false) returnFields.remove(field);
    }
    return returnFields;
},

fieldShouldBeVisible : function (field, valueList) {
    // evaluate a showIf expression if present
    if (field.showIf != null) {
        // CALLBACK API:  available variables:  "viewer,valuesList"
        // Convert a string callback to a function

        if (field.showIf == this._$false || field.showIf == this._$falseSemi) return false;
        isc.Func.replaceWithMethod(field, "showIf", "viewer,valueList");
        if (!field.showIf(this, valueList)) return false;
    }
    return true;
},

// Formula/summary -related overrides from DBC
getTitleFieldValue : function (record) {
    var titleField = this.getDataSource().getTitleField(),
        title = this.getCellValue(record, this.getDataSource().getField(titleField));

    return title;
},

// DBC level override to call local getCellValue implementation - Formula/Summary builders
getStandaloneFieldValue : function (record, fieldName) {
    var field = this.getField(fieldName),
        value = this.getCellValue(record, field);
    // In DetailViewer we apply hilite CSS to the cell.
    // Therefore write a span with the appropriate cssText around the actual value
    // in order to pick up the hilite styling
    value = this.addHiliteSpan(record, field, value);
    return value;
},

// basic show and hide methods
hideField : function (fieldName) {
    this.toggleField(fieldName, false);
},
showField : function (fieldName) {
    this.toggleField(fieldName, true);
},
toggleField : function (fieldName, showNow) {
    var field = this.getField(fieldName);

    field.showIf = showNow ? "true" : "false";
    field.visible = showNow;
    this.setFields(this.getAllFields());
    this.markForRedraw();
    this.fieldStateChanged();
},

//>    @method    detailViewer.getField()    (A)
// Return a field by fieldName
//
//        @return    (DetailViewerField) requested field or null
//<
getField : function (fieldName) {
    var allFields = this.getAllFields(),
        fields = this.fields,
        field;

    if (isc.isAn.Object(fieldName) && fieldName[this.fieldIdProperty] != null) {
        // passed a field-object, check it's real by finding it by name
        field = allFields.find(this.fieldIdProperty, fieldName[this.fieldIdProperty]) ||
            fields.find(this.fieldIdProperty, fieldName[this.fieldIdProperty]);
    } else if (isc.isA.Number(fieldName)) {
        field = allFields[fieldName] || fields[fieldName];
    } else {
        field = allFields.find(this.fieldIdProperty, fieldName) ||
            fields.find(this.fieldIdProperty, fieldName)
    }

    return field;
},

// Overridden from DBC - use 'getCellValue' to return the "formatted" value
getFormattedValue : function (record, fieldName, value) {
    return this.getCellValue(record, this.getSpecifiedField(fieldName));
},
//> @method detailViewer.getPivotedExportData()
// Export visual description of DetailViewer data into a form suitable for external
// processing.
// @param settings (Object) contains configuration settings for the export, including:<br/>
//        includeHiddenFields (Boolean) - controls if hidden fields should be exported<br/>
//        allowedProperties (Array) optional array of CSS property names (camelCaps format)
//             constraining the allowed properties to be returned<br/>
//        propagateInputHilites - controls whether to propagate hilites defined on inputs
//             of user summaries to the summaries themselves (unset means don't propagate)
// @return value (String) exported data
//<
// * Data is exported as an array of objects, with one object per visual row of the
//   DetailViewer grid - meaning one row per field.
// * The title of each visible field is mapped to the property "title" for each object.
// * Each record's value for the corresponding field is mapped to the properties
//   "value1", "value2", ..., up to the number of records specified in this.recordsPerBlock.
//   Records extending beyond this.recordsPerBlock are not exported.
// * Additionally, if CSS highlighting styles are present on a record's field, the CSS text is
//   converted into an object mapping CSS properties in camelCaps format to CSS values, and the
//   object is stored in <property name>$style.
// * Null record values are converted to empty strings.
//
// Example object:
//  [
//  { title: "Foo Fighter", value1: "1", "value1$style": { backgroundColor: "#f00000" } },
//  { title: "bar", value1: "baz" },
//  { title: "xyzzy", value1: "" },
//  { title: "Summary Field", value1: "1 --- baz", "value1$style": { font-weight: "bold" } }
//  ]
getPivotedExportData : function (settings) {
    var exportOutput = [],
        fields = this.getAllFields(),
        data = this.data,
        allowedProperties,
        alwaysExportExpandedStyles
        ;

    if (settings == null) settings = {};
    var includeHiddenFields = settings.includeHiddenFields;

    if (isc.isA.ResultSet(data)) data = data.getAllLoadedRows();
    if (!isc.isA.Array(data)) data = [data];

    for (var fieldIndex = 0; fieldIndex < fields.length; fieldIndex++) {
        var field = fields[fieldIndex],
            exportObject = {},
            recordsPerBlock = this.recordsPerBlock;

        exportObject.title = field.title || field.name;
        if (isc.isA.String(exportObject.title)) {
            exportObject.title = this.htmlUnescapeExportFieldTitle(exportObject.title);
        }

        // Implement default value of 1 and "*" -> unbounded
        if (recordsPerBlock == null) recordsPerBlock = 1;
        if (recordsPerBlock == "*") recordsPerBlock = 100000;

        if ((!this.fields.contains(field)) && !includeHiddenFields) continue;

        for (var rowIndex = 0;
             rowIndex < recordsPerBlock && rowIndex < data.getLength();
             rowIndex++)
        {
            var record = data[rowIndex],
                fieldNum = this.getFieldNum(field.name),
                exportProp = "value" + (rowIndex+1),
                styleProp = exportProp + "$style";

            var value = this.getExportFieldValue(record, field.name, fieldNum);

            if (!(value == null || value == "&nbsp;")) exportObject[exportProp] = value;

            this.addDetailedExportFieldValue(exportObject, styleProp, record, field, fieldNum,
                                             settings);
            if (exportObject[styleProp] == null || exportObject[styleProp] == "&nbsp;")
                delete exportObject[styleProp];
        }
        exportOutput.push(exportObject);
    }
    return exportOutput;
},


//> @type DetailViewerViewState
// An object containing the stored grouping information for a detailViewer.
// Note that this object is not intended to be interrogated directly, but may be stored
// (for example) as a blob on the server for state persistence across sessions.
//
// @group viewState
// @visibility external
//<

//>    @method    detailViewer.getViewState()
// Returns a snapshot of the current view state of this DetailViewer.<br>
// This includes the field, sort and hilite state of the grid, returned as a
// +link{type:DetailViewerViewState} object.<br>
// This object can be passed to +link{detailViewer.setViewState()} to reset this detail
// viewer's view state to the current state (assuming the same data / fields are present in
// the detail viewer).
// @group viewState
// @see type:DetailViewerViewState
// @see detailViewer.setViewState();
// @visibility external
// @return (DetailViewerViewState) current view state for the detail viewer.
//<
getViewState : function (returnObject) {

    var state = {
        field:this.getFieldState(),
        sort:this.getSortState(),
        hilite:this.getHiliteState()
    };

    // Available so TG can call Super() and get an object back
    if (returnObject) return state;
    return "(" + isc.Comm.serialize(state,false) + ")";
},

//>    @method    detailViewer.setViewState()
// Reset this detail viewer's view state to match the +link{type:DetailViewerViewState} object passed in.<br>
// Used to restore previous state retrieved from the detail viewer by a call to
// +link{detailViewer.getViewState()}.
//
// @param viewState (DetailViewerViewState) Object describing the desired view state for the
// detail viewer
// @group viewState
// @see detailViewer.getViewState()
// @visibility external
//<
setViewState : function (state) {
    state = this.evalViewState(state, "viewState")
    if (!state) return;

    // Order is somewhat important - for example show fields before potentially sorting
    // by them, etc
    if (state.field) this.setFieldState(state.field);
    this.setSortState(state.sort);
    this.setHiliteState(state.hilite);
},


//>    @attr detailViewer.showDetailFields (Boolean : true : IR)
// @include dataBoundComponent.showDetailFields
//<

//> @attr detailViewer.fieldPickerWindow (AutoChild FieldPickerWindow : null : IR)
// Instance of +link{FieldPickerWindow} used if +link{canPickFields} is set.
// @visibility external
//<

fieldPickerWindowDefaults : {
    autoParent: "none",
    _constructor: "FieldPickerWindow"
},

//> @attr detailViewer.canPickFields (Boolean : false : IR)
// If set, right-clicking on the DetailViewer will show a context menu that offers to bring up a
// +link{FieldPicker} for configuring which fields are displayed and their order.
// @visibility external
//<
canPickFields: false,

//> @attr detailViewer.configureFieldsText (String : "Configure Fields..." : [IR])
// The title for the Configure Fields menu item.
// @group i18nMessages
// @visibility external
//<
configureFieldsText: "Configure Fields...",


//> @attr detailViewer.fieldPickerFieldProperties (Array of String : null : IR)
// Names of properties on +link{DetailViewerField} for which the +link{fieldPicker} should
// show an editing interface, for convenience.
// <P>
// For example, specify ["decimalPad", "decimalPrecision"] to allow end users to modify
// +link{detailViewerField.decimalPad} and +link{detailViewerField.decimalPrecision} respectively.
// @visibility external
//<
fieldPickerFieldProperties: null

});    // END isc.DetailViewer.addMethods()

// Register stringMethods for this class - instance methods that can be defined as strings using
// specified keywords (replaced by arguments in the function created)
isc.DetailViewer.registerStringMethods({

    getCellValue:"record,field",
    getCellStyle:"value,field,record,viewer",
    getCellCSSText:"value,field,record,viewer",
    formatCellValue:"value,record,field,viewer",
    fieldStateChanged:""
});




//>    @class    GridRenderer
//
// A flexible, high-speed table that offers consistent cross-platform sizing, clipping, and events.
//
//  @treeLocation Client Reference/Foundation
//  @visibility external
//<

isc.ClassFactory.defineClass("GridRenderer", "Canvas");

isc.GridRenderer.addClassProperties({

    //>    @type    CellState
    // Appearance of the cell -- used to set to different visual states.
    // Also used as a suffix to gridRenderer.baseStyle to set CSS styles.
    // @group appearance
    // @see    gridRenderer.getCellStyle()
    SELECTED:"Selected",        //    @value    isc.gridRenderer.SELECTED        Cell is selected.
    DISABLED:"Disabled",        //    @value    isc.gridRenderer.DISABLED        Cell is disabled.
    OVER:"Over",                //    @value    isc.gridRenderer.OVER            Mouse is over the cell.
    //<

    //>    @attr    gridRenderer.standardStyleSuffixes    (array : array of strings : IR)
    //        Array of the 12 standard cell style suffix strings ("Over", "SelectedOver", etc.)
    //      to allow quicker calculation of cell styles.
    //        @see    gridRenderer.getCellStyle()
    //<
    standardStyleSuffixes:[
                 "",
                 "Over",
                 "Selected",
                 "SelectedOver",
                 "Disabled",
                 "DisabledOver",
                 "DisabledSelected",
                 "DisabledSelectedOver",
                 "Dark",
                 "OverDark",
                 "SelectedDark",
                 "SelectedOverDark",
                 "DisabledDark"
     ]
});

isc.GridRenderer.addProperties({
showFocusOutline: false,

//>    @attr gridRenderer.totalRows (number : 0 : [IRW])
// Total number of rows in the grid.<br><br>
//
// NOTE: in order to create a valid grid, you must either provide a totalRows value or implement
// getTotalRows()
//
// @see method:getTotalRows
// @visibility external
//<
totalRows : 0,

//>    @attr gridRenderer.showAllRows (boolean : false : [IRA])
// Whether all rows should be drawn all at once, or only rows visible in the viewport.
// <P>
// Drawing all rows causes longer initial rendering time, but allows smoother vertical scrolling.
// With a very large number of rows, showAllRows will become too slow.
// <P>
// See also +link{drawAheadRatio} and +link{drawAllMaxCells}.
//
// @group performance
// @visibility external
//<
//showAllRows : false,

//>    @attr gridRenderer.virtualScrolling (boolean : null : [IRA])
// When incremental rendering is switched on and there are variable record heights, the virtual
// scrolling mechanism manages the differences in scroll height calculations due to the
// unknown sizes of unrendered rows to make the scrollbar and viewport appear correctly.
// <P>
// virtualScrolling is switched on automatically when fixedRowHeights is false but you should
// switch it on any time there are variable record heights.
// @visibility external
//<
//virtualScrolling:true,

//>    @attr gridRenderer.showAllColumns (boolean : false : [IRA])
// Whether all columns should be drawn all at once, or only columns visible in the viewport.
// <P>
// Drawing all columns causes longer initial rendering time, but allows smoother horizontal
// scrolling.  With a very large number of columns, showAllColumns will become too slow.
//
// @group performance
// @visibility external
//<
//showAllColumns : false,

//>@attr gridRenderer.drawAllMaxCells (integer : 250 : IRWA)
// If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered,
// the full dataset will instead be drawn even if +link{listGrid.showAllRecords,showAllRecords}
// is false and the viewport size and +link{drawAheadRatio} setting would normally have caused
// incremental rendering to be used.
// <P>
// The <code>drawAllMaxCells</code> setting prevents incremental rendering from being used in
// situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200
// cells) which happens to be in a grid with a viewport showing only 20 or so rows.
// Incremental rendering causes a brief "flash" during scrolling as the visible portion of the
// dataset is redrawn, and a better scrolling experience can be obtained in this situation by
// drawing the entire dataset up front, which in this example would have negligible effect on
// initial draw time.
// <P>
// <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature
// if performance is an issue and:
// <ul>
// <li> you are very frequently redraw a grid
// <li> you do a lot of computation when rendering each cell (eg formulas)
// <li> you are showing many grids on one screen and the user won't scroll most of them
// </ul>
//
// @group performance
// @visibility external
//<
drawAllMaxCells:250,


//> @attr gridRenderer.recordCanSelectProperty (string : "canSelect" : [IRA])
// If set to false on a record, selection of that record is disallowed.
//<
recordCanSelectProperty: "canSelect",

//> @attr gridRenderer.isSeparatorProperty (string : "isSeparator" : [IRA])
// If this property is defined on some record, render the record as a separator row.
//<
// Documented at the ListGrid level only. ListGrids will pass the isSeparatorProperty through
// to their body.
isSeparatorProperty:"isSeparator",

//> @attr gridRenderer.singleCellValueProperty (string : "singleCellValue" : [IRA])
// If this property is defined on some record, render the record as a single cell (spanning all
// columns).
//<
// Documented at the ListGrid level only. ListGrids also implement getCellValue() which
// will display record.singleCellValue as the value of the cell.
// ListGrids will pass the singleCellValueProperty through to their body.
singleCellValueProperty:"singleCellValue",

//> @attr gridRenderer.instantScrollTrackRedraw (boolean : true : IRW)
// If true, if the user clicks on the scroll buttons at the end of the track or clicks once on
// the scroll track, there will be an instant redraw of the grid content so that the user
// doesn't see any blank space.  For drag scrolling or other types of scrolling, the
// +link{scrollRedrawDelay} applies.
//
// @group performance
// @visibility external
//<
instantScrollTrackRedraw:true,

//> @attr gridRenderer.scrollRedrawDelay (int : 0 : IRW)
// While drag scrolling in an incrementally rendered grid, time in milliseconds to wait
// before redrawing, after the last mouse movement by the user. This delay may be
// separately customized for mouse-wheel scrolling via +link{scrollWheelRedrawDelay}.
// <P>
// See also
// +link{gridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
// <P>
// <strong>NOTE:</strong> In +link{Browser.isTouch,touch browsers},
// +link{GridRenderer.touchScrollRedrawDelay,touchScrollRedrawDelay} is used instead.
//
// @group performance
// @group scrolling
// @visibility external
//<
scrollRedrawDelay: isc.Browser.useHighPerformanceGridTimings ? 0: 75,


//> @attr gridRenderer.dragScrollRedrawDelay (int : 75 : IRW)
// Like +link{scrollRedrawDelay}, but applies when the component is being
// drag-scrolled (via a scrollbar).  This value is typically set higher than +link{scrollRedrawDelay}
// to avoid too many concurrent fetches to the server for +link{ResultSet}-backed components
// since it's quite easy to induce such a case with a scrollbar and a grid bound to a large databaset.
//
// @group performance
// @group scrolling
// @visibility external
//<
dragScrollRedrawDelay: 75,

//> @attr gridRenderer.touchScrollRedrawDelay (int : 0 : IRW)
// In +link{Browser.isTouch,touch browsers}, the time in milliseconds to wait after a scroll
// before redrawing. In non-touch browsers, the +link{GridRenderer.scrollRedrawDelay,scrollRedrawDelay}
// or +link{GridRenderer.scrollWheelRedrawDelay,scrollWheelRedrawDelay} is used instead.
// @group performance
// @group scrolling
// @visibility external
//<

touchScrollRedrawDelay: isc.Browser.useHighPerformanceGridTimings ? 0: 300,

//> @attr gridRenderer.scrollWheelRedrawDelay (Integer : null : IRW)
// While scrolling an incrementally rendered grid, using the mouseWheel, time in
// milliseconds to wait before redrawing, after the last mouseWheel movement by the user.
// If not specified +link{scrollRedrawDelay} will be used as a default for both
// drag scrolling and mouseWheel scrolling.
// <P>
// See also
// +link{gridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
//
// @group performance
// @visibility external
//<
//scrollWheelRedrawDelay:null,

//>    @attr gridRenderer.drawAheadRatio (float : 2.0 : [IRWA])
// How far should we render rows ahead of the currently visible area?  This is expressed as a
// ratio from viewport size to rendered area size.
// <P>
// Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
// initial render time and render time when scrolling by large amounts.
// <P>
// NOTE: Only applies when showAllRows is false.
//
// @group performance
// @visibility external
//<
drawAheadRatio : isc.Browser.useHighPerformanceGridTimings ? 2.0 : 1.3,

//>    @attr gridRenderer.quickDrawAheadRatio (float : 2.0 : [IRWA])
// Alternative to +link{drawAheadRatio}, to be used when the user
// is rapidly changing the grids viewport (for example drag scrolling through the grid).
// If unspecified +link{drawAheadRatio} will be used in all cases
// @group performance
// @visibility external
//<
quickDrawAheadRatio: isc.Browser.useHighPerformanceGridTimings ? 2.0 : 1.0,

//>    @attr gridRenderer.cellHeight        (number : 20 : [IRW])
// The default height of each row in pixels.
//
// @see gridRenderer.getRowHeight()
// @visibility external
// @group cellStyling
//<
cellHeight:20,

//>    @attr gridRenderer.fixedRowHeights (boolean : true : IRWA)
// Should we vertically clip cell contents, or allow rows to expand vertically to show all
// contents?
// <P>
// If we allow rows to expand, the row height as derived from
// +link{gridRenderer.getRowHeight(),getRowHeight()} or the
// default +link{cellHeight} is treated as a minimum.
//
// @group cellStyling
// @visibility external
//<

// Note: We can have variable height rows even with fixedRowHeights set to true, if we
// have embedded components (which cause rows to expand) for example.

fixedRowHeights:true,
//enforceVClipping:null,
shouldEnforceVClipping : function () {
    return this.fixedRowHeights && (this.enforceVClipping || this.wrapCells);
},



//>    @attr    gridRenderer.fixedColumnWidths        (boolean : true : IRWA)
// Should we horizontally clip cell contents, or allow columns to expand horizontally to
// show all contents?<br><br>
//
// If we allow columns to expand, the column width is treated as a minimum.
//
// @group    sizing
// @visibility external
//<

fixedColumnWidths:true,

//>    @attr    gridRenderer.autoFit              (boolean : false : IRWA)
// If true, make columns only wide enough to fit content, ignoring any widths specified.
// Overrides fixedFieldWidths.
//
// @group    sizing
// @visibility external
//<
//autoFit:false,

//>    @attr    gridRenderer.wrapCells        (boolean : false : IRWA)
// Should content within cells be allowed to wrap?
// @group cellStyling
// @visibility external
//<
//wrapCells:false,

//>    @attr    gridRenderer.cellSpacing        (number : 0 : [IRW])
// The amount of empty space, in pixels, between each cell.
// @group cellStyling
// @visibility internal
//<
cellSpacing:0,

//>    @attr    gridRenderer.cellPadding        (number : 2 : [IRW])
// The amount of empty space, in pixels, surrounding each value in its cell.
// @group cellStyling
// @visibility external
//<
cellPadding:2,

//>    @attr    gridRenderer.canSelectOnRightMouse  (boolean : true : [RW])
//  If true, rightMouseDown events will fire 'selectOnRightMouseDown()' for the appropriate cells.
// @group    events
// @visibility external
//<
canSelectOnRightMouse:true,

// Hover
// ---------------------------------------------------------------------------------------

//>    @attr gridRenderer.canHover (boolean : null : [RW])
// If true, cellHover and rowHover events will fire and then a hover will be shown (if not
// canceled) when the user leaves the mouse over a row / cell unless the corresponding field has
// +link{ListGridField.showHover,showHover} set to false. If unset or null, the hover will be
// shown if the corresponding field has showHover:true. If false, then hovers are disabled.
// <p>
// Note that standard hovers override +link{showClippedValuesOnHover,clipped value hovers}. Thus,
// to enable clipped value hovers, canHover must be unset or null and the corresponding field
// must have showHover unset or null as well.
// @group    events
// @visibility external
// @see cellHover()
// @see rowHover()
// @see showHover
// @see showClippedValuesOnHover
//<

//>    @attr gridRenderer.showHover (boolean : null : [RW])
// If true, and canHover is also true, when the user hovers over a cell, hover text will pop up
// next to the mouse.  The contents of the hover is determined by +link{cellHoverHTML()}.
// @group    events
// @visibility external
// @see canHover
// @see cellHoverHTML()
//<

//> @attr gridRenderer.showClippedValuesOnHover (Boolean : null : IRWA)
// If true and a cell's value is clipped, then a hover containing the full cell value is
// enabled.
// <p>
// Note that standard cell hovers override clipped value hovers. Thus, to enable clipped value
// hovers, +link{canHover,canHover} must be unset or null and the corresponding field must have
// +link{ListGridField.showHover,showHover} unset or null as well.
// @group events
// @see canHover
// @see cellValueHoverHTML()
// @visibility external
//<

// can be set to false to cause Hover to be per-row instead of per-cell
hoverByCell:true,

// CSS styles
// --------------------------------------------------------------------------------------------


backgroundColor:"white",

// style applied to the table element.  NOTE: don't expose: styling of a grid should be
// accomplish by styling the surrounding DIV, where we can use the standard methodology to
// detect borders, margins, etc (eg getInnerHeight())
tableStyle:"listTable",

//>    @attr    gridRenderer.baseStyle        (CSSStyleName : "cell" : [IR])
// The base name for the CSS class applied to cells. This style will have "Dark",
// "Over", "Selected", or "Disabled" appended to it according to the state of the cell.
// @visibility external
// @group cellStyling
// @see method:getCellStyle()
// @see method:getBaseStyle()
//<
baseStyle:"cell",

//> @attr gridRenderer.alternateRowStyles (boolean : false : [IRW])
// Whether alternating rows should be drawn in alternating styles, in order to create a "ledger"
// effect for easier reading.  If enabled, the cell style for alternate rows will have "Dark"
// appended to it.
// @visibility external
// @group cellStyling
//<
//alternateRowStyles:false,

//> @attr gridRenderer.alternateRowFrequency (number : 1 : [IRW])
// The number of consecutive rows to draw in the same style before alternating, when
// +link{gridRenderer.alternateRowStyles, alternateRowStyles} is true.
// @visibility external
// @group cellStyling
//<
alternateRowFrequency:1,

//> @attr gridRenderer.alternateColumnStyles (boolean : false : [IRW])
// Whether alternating columns should be drawn in alternating styles, in order to create a
// vertical "ledger" effect for easier reading.  If enabled, the cell style for alternate
// columns will have "Dark" appended to it.
// @visibility external
// @group cellStyling
//<
//alternateColumnStyles:false,

//> @attr gridRenderer.alternateColumnFrequency (number : 1 : [IRW])
// The number of consecutive columns to draw in the same style before alternating, when
// +link{gridRenderer.alternateColumnStyles, alternateColumnStyles} is true.
// @visibility external
// @group cellStyling
//<
alternateColumnFrequency:1,

//> @attr gridRenderer.emptyCellValue (string : "&nbsp;" : IRW)
// Value to show in empty cells (when getCellValue returns null).
// @group cellStyling
// @visibility external
//<
emptyCellValue:"&nbsp;",


// Empty messages (what to do if no data is present)
// --------------------------------------------------------------------------------------------
//>    @attr    gridRenderer.showEmptyMessage        (boolean : true : [IRW])
// Indicates whether the text of the emptyMessage property should be displayed if no data is
// available.
//      @visibility external
//      @group  emptyMessage
//      @see    emptyMessage
//<

//>    @attr    gridRenderer.emptyMessage        (string : "No data to display" : IRW)
// The string to display in the body of a listGrid with an empty data array, if
// showEmptyMessage is true.
// @group emptyMessage, i18nMessages
// @visibility external
//      @see    gridRenderer.showEmptyMessage
//      @see    gridRenderer.emptyMessageStyle
//<
emptyMessage: "No data to display",

//>    @attr gridRenderer.emptyMessageTableStyle (CSSStyleName : null : IRW)
// CSS styleName for the table as a whole if we're showing the empty message
// @group emptyMessage
// @visibility external
//<

//>    @attr gridRenderer.emptyMessageStyle (CSSStyleName : null : IRW)
// The CSS style name applied to the emptyMessage string if displayed.
// @group emptyMessage
// @visibility external
//<

//>    @attr gridRenderer.showOfflineMessage (boolean : true : [IRW])
// Indicates whether the text of the offlineMessage property should be displayed if no data
// is available because we are offline and there is no suitable cached response
// @visibility external
// @group emptyMessage, offlineGroup
// @see offlineMessage
//<

//>    @attr gridRenderer.offlineMessageStyle (CSSStyleName : null : IRW)
// The CSS style name applied to the offlineMessage string if displayed.
// @group emptyMessage, offlineGroup
// @visibility external
//<

//>    @attr gridRenderer.offlineMessage (string : "No data available while offline" : IRW)
// The string to display in the body of a listGrid with an empty data array, if
// showOfflineMessage is true and the data array is empty because we are offline and there
// is no suitable cached response
// @group offlineGroup, emptyMessage, i18nMessages
// @visibility external
// @see showOfflineMessage
// @see offlineMessageStyle
//<
offlineMessage: "No data available while offline",

//> @attr gridRenderer.fastCellUpdates (boolean: true : IRWA)
//
// <b>Note: This property only has an effect in Internet Explorer</b>
// <P>
// Advanced property to improve performance for dynamic styling of gridRenderer cells in
// Internet Explorer, at the expense of slightly slower initial drawing, and some
// limitations on supported styling options.
// <P>
// <code>fastCellUpdates</code> speeds up the dynamic styling system used by rollovers,
// selections, and custom styling that calls +link{gridRenderer.refreshCellStyle()}, at
// the cost of slightly slower draw() and redraw() times.
// <P>
// Notes:
// <ul>
// <li>When this property is set, ListGrid cells may be styled using the
//     +link{listGrid.tallBaseStyle}. See +link{listGrid.getBaseStyle()} for
//     more information.</li>
// <li>If any cell styles specify a a background image URL, the URL will be resolved relative
//     to the page location rather than the location of the CSS stylesheet. This means cell
//     styles with a background URL should either supply a fully qualified path, or the
//     background image media should be made available at a second location for IE.</li>
// <li>fastCellUpdates will not work if the styles involved are in an external stylesheet loaded
//     from a remote host. Either the stylesheet containing cell styles needs to be loaded
//     from the same host as the main page, or the cell styles need to be inlined in the html
//     of the bootstrap page.</li>
// <li>fastCellUpdates will not work if the css styles for cells are defined in
//     a <code>.css</code> file loaded via <code>@import</code>. Instead the <code>.css</code>
//     file should be loaded via a <code>&lt;link ...&gt;</code> tag.</li>
// </ul>
// @visibility external
//<

// This default is overridden in ListGrid
fastCellUpdates:true,

//> @method gridRenderer.setFastCellUpdates()
// Setter for +link{gridRenderer.fastCellUpdates}. Has no effect in browsers other than
// Internet Explorer.
// @param fastCellUpdates (boolean) whether to enable fastCellUpdates.
// @visibility external
//<
setFastCellUpdates : function (fcu) {
    if (fcu && !isc.Browser.isIE) {
        this.fastCellUpdates = false;
        //this.logInfo("fastCellUpdates was enabled - this has no effect " +
        //    "in browsers other than Internet Explorer. Disabling.");
        return;
    }
    if (fcu == this.fastCellUpdates) return;
    this.fastCellUpdates = fcu;
    this.markForRedraw();
},




// Standard Canvas settings
// --------------------------------------------------------------------------------------------
overflow:"auto",


_avoidRedrawFlash:true,

canFocus:true,

//>Animation
// If a px / second speed is specified for a row animation, cap it at a maximum
// (Inherited from LG / TG if specified there)
animateRowsMaxTime:1000,
//<Animation


//>    @attr gridRenderer.snapToCells (boolean : false : IRW)
// Should drag-and-drop operations snap the dragged object into line with the nearest cell?
//
// @group dragdrop
// @visibility external
//<
snapToCells: false,

//> @attr gridRenderer.snapInsideBorder (boolean : false : IRW)
// If true, snap-to-cell drops will snap the dropped object inside the selected cell's border.
// If false, snap-to-cell drops will snap the dropped object to the edge of the selected cell,
// regardless of borders
//
// @group dragdrop
// @see    GridRenderer.snapToCells
// @visibility external
//<
snapInsideBorder: false,


snapHDirection: isc.Canvas.BEFORE,
snapVDirection: isc.Canvas.BEFORE

});

isc.GridRenderer.addMethods({

initWidget : function () {
    // Make sure we have columnWidths set up - we rely on this for some methods
    if (!this._fieldWidths) this.setColumnWidths([]);

    if (this.selection) this.setSelection(this.selection);

    // If we're overflow visible, we have to write out our entire body content.
    if (this.overflow == isc.Canvas.VISIBLE) {
        this.showAllRows = true;
    }

    // turn virtualScrolling on if it's unset and we have variable-height rows
    if (!this.fixedRowHeights && this.virtualScrolling == null) this.virtualScrolling = true;
    // default for virtualScrolling is now null, so if it's been turned on, also turn
    // fixedRowHeights off so that virtualScrolling has an effect
    //if (this.fixedRowHeights && this.virtualScrolling) this.fixedRowHeights = false;


    if (this.virtualScrolling && !this.showAllRows) {

        //this._avoidRedrawFlash = true;

        if (this.showCustomScrollbars == false) {
            this.logInfo("Variable height records cannot be used with native scrollbars;" +
                         " setting showCustomScrollbars:true on this GridRenderer and using" +
                         " the special 'NativeScrollbar' class as a scrollbarConstructor.");
            this.showCustomScrollbars = true;
            this.useNativeTouchScrolling = false;
            this.scrollbarConstructor = "NativeScrollbar";
        }

    }

    // initialize fastCellUpdates via the setter.
    // Disables this attribute where not supported
    this.setFastCellUpdates(this.fastCellUpdates);
},


columnSizerDefaults: {
    // flag to simplify debugging!
    columnSizer: true,
    top: -1000,
    width: 1,
    height: 1,
    overflow: "hidden",

    ariaState: {
        hidden: true
    }
},

clearColumnSizerDelay: 100,
clearColumnSizer : function (clearCompletely) {
    var columnSizer = this._columnSizer;
    if (columnSizer != null) {
        if (clearCompletely) {
            columnSizer.clear();
        } else {
            columnSizer.setContents(isc.nbsp);
        }
    }
},

destroy : function () {
    this.clearSelection();
    this.Super("destroy", arguments);

    this._columnSizer = null;
},

shouldShowAllColumns : function () {

    if (this.showAllColumns) return true;

    // have to force rendering all columns, otherwise, row heights would vary with drawn
    // columns.

    if (!this.fixedRowHeights && !this.showAllRows) return true;
    if (this.overflow == isc.Canvas.VISIBLE) {
        return true;
    }
    return false;
},

// Empty Message handling
// --------------------------------------------------------------------------------------------

isEmpty : function () { return false; },

_showEmptyMessage : function (startCol,endCol) {
    return this.getEmptyMessageHTML(startCol,endCol, this.grid.isOffline());
},

//>    @method    gridRenderer.getEmptyMessageHTML()    ([A])
//            Return the HTML to show if there's nothing in the list
//        @group    drawing
//        @return    (HTMLString)    HTML for the empty message layer
//<
getEmptyMessageHTML : function (startCol,endCol,offline) {
    if (!offline) {
        if (!this.showEmptyMessage)    return "&nbsp;";
    } else {
        if (!this.showOfflineMessage) return "&nbsp;";
    }
    if (this.isPrinting) {
        if (startCol == null) startCol = 0;
        if (endCol == null) endCol = this.fields ? this.fields.getLength() -1 : 0;


        var showHeader = !(this._printingChunk && this.printChunkOnly);

        return "<TABLE role='presentation' cellspacing=0 style='width:100%'" +
                (this.emptyMessageTableStyle?(" class='" + this.emptyMessageTableStyle + "'"):"") +
                ">" +
                (showHeader ? this.getPrintHeaders(startCol, endCol+1) : "") +
                "<TR><TD  ALIGN=CENTER class='" +
                (offline ? this.offlineMessageStyle : this.emptyMessageStyle) +
                "' colspan='" + ((endCol-startCol)) + "'>" +
                (offline ? this.getOfflineMessage() : this.getEmptyMessage())
                + "</TD></TR>" +
                (showHeader ? this.getPrintFooters(startCol, endCol+1) : "") +
                "</TABLE>";
    }

    // Always ensure the empty message fills the viewport.
    // Respect flag to match the empty message size to the specified field widths -
    // if the specified field sizes exceed the viewport size, expand the empty message
    // to accommodate it.
    var width = this.getInnerWidth(),
        extraWidth = 0;
    if (this.expandEmptyMessageToMatchFields && this._fieldWidths) {
        extraWidth = this._fieldWidths.sum() - width;
        if (extraWidth < 0) extraWidth = 0;
    }
    if (this.applyHSpaceToEmptyMessage) {
        if (this.leftSpace != null) extraWidth += this.leftSpace;
        if (this.rightSpace != null) extraWidth += this.rightSpace;
    }

    // Note that if the GR is scrollable, we want the empty message to be visible /
    // centered when scrolled to 0/0 so table into 2 cells, centering the empty message
    // within the first cell which spans the viewport
    var splitTable = extraWidth && this.overflow != isc.Canvas.VISIBLE;

    var vPad = this._vPad;
    // this._vPad may be undefined (for example, when drawing the "[Empty menu]" submenu).
    if (vPad == null) {
        vPad = 0;

        if (this._shouldSubtractVBorderPadFromRowHeight()) {
            vPad = (this.fixedRowHeights ? 0 : this.cellPadding * 2);
            if (this.emptyMessageTableStyle) vPad += isc.Element._getVBorderSize(this.emptyMessageTableStyle);
        }
    }

    var sb = isc.StringBuffer.create();
    sb.append(
            "<TABLE role='presentation' BORDER=0 MARGIN=0 CELLSPACING='", this.cellSpacing,
                "' CELLPADDING='", this.cellPadding,
                (this.emptyMessageTableStyle?("' CLASS='" + this.emptyMessageTableStyle):null),
                "' style='width:",(width+extraWidth),"px;",

                (isc.Browser.isSafari ? "'"
                                      : "' HEIGHT=100%"),
            "><TR><TD ALIGN=CENTER CLASS='",
            (offline ? this.offlineMessageStyle : this.emptyMessageStyle),
            "' style='padding-left:0px;padding-right:0px;height:" + (this.cellHeight - vPad) + "px'>",
            // NOTE: empty message can't be too tall, or it will introduce vscrolling in
            // shorter grids
            (offline ? this.getOfflineMessage() : this.getEmptyMessage()),
            (extraWidth && splitTable ? "<br>" + isc.Canvas.spacerHTML(width,1) : null),
            "</TD>"
    );
    if (extraWidth && splitTable) {
        sb.append("<TD style='padding-left:0px;padding-right:0px;'>",
                  isc.Canvas.spacerHTML(extraWidth, 1), "</TD>");
    }
    sb.append("</TR></TABLE>");
    return sb.release(false);
},


//>    @method    gridRenderer.getEmptyMessage()    ([A])
//        @group    drawing
//            return the text for the empty message
//            you can ovveride this function if your data has additional semantics
//                (eg: initial conditions, loading, filtering, etc)
//        @return    (string)    empty message
//<
getEmptyMessage : function () {
    return this.emptyMessage;
},

//>    @method    gridRenderer.getOfflineMessage()    ([A])
//        @group    drawing
//            return the text for the offline message.  The default implementation returns the
//          value of the containing Grid's offlineMessage property;
//            you can ovveride this function if your data has additional semantics
//                (eg: initial conditions, loading, filtering, etc)
//        @return    (string)    offline message
//<
getOfflineMessage : function () {
    return this.grid.offlineMessage;
},

// Drawing
// --------------------------------------------------------------------------------------------



// use a rel-pos div to apply a z-index to the content.
// required for the ability to float embedded components above or below the table
_$zIndexDivTemplate:["<DIV id='",
                     ,  // 1 [_getZIndexDivID()]
                     "' style='" +

                        (isc.Browser.isMoz && isc.Browser.version == 18 ? "display:inline;" : "") +


                        "position:absolute;overflow:",
                     ,  // 3 [hidden, or visible]
                     ";z-index:",
                     ,  // 5 [getTableZIndex()]
                     ";width:",
                     ,  // 7 width
                     "px'>", // 8

                     null, // 9 [form start tag in IE]
                     ,  // 10 [table html]
                     ,  // 11 [optional filler div]
                     isc.Browser.isIE ? "</form>" : null,
                     "</DIV>"],
_$fillerDiv:"<table style='position:absolute;top:0px;font-size:1px;height:100%;width:100%;z-index:1;overflow:hidden;visibility:hidden;'><tr><td>&nbsp;</td></tr></table>",

_$formStartTag_hidden:"<form action='javascript:void(0)' style='overflow:hidden' onsubmit='return false;'>",
_$formStartTag_visible:"<form action='javascript:void(0)' onsubmit='return false;'>",

_getZIndexDivID : function () {
    return this._getDOMID("zIndexDiv");
},
_getZIndexDiv : function () {
    return this.getDocument().getElementById(this._getZIndexDivID());
},
_zIndexDivOverflowHidden : function () {
    return (this.fixedFieldWidths && this.overflow != isc.Canvas.VISIBLE);
},
getInnerHTML : function () {

    var tableHTML = this.getTableHTML(),
        template = this._$zIndexDivTemplate;

    template[1] = this._getZIndexDivID();

    var overflowHidden = this._zIndexDivOverflowHidden(),
        overflow = overflowHidden ? "hidden" : "visible";

    template[3] = overflow;
    if (isc.Browser.isIE) {
        template[9] = overflowHidden ? this._$formStartTag_hidden : this._$formStartTag_visible;
    }

    template[5] = this.getTableZIndex();
    // When the grid is (or will) show the sorter, but the grid body is not showing a
    // vertical scrollbar, we want to increase the scrollWidth of the grid body by the width
    // of the sorter button so that if the last field is wider than the viewport width, its
    // header button won't be partially occluded by the sorter.
    //
    // This requires innerSizeChanged() to be overridden to update the CSS width whenever the
    // grid body shows or hides a vertical scrollbar.
    //
    // Note: Only applies when we're showing custom scrollbars.

    var grid = this.grid,
        width = this._fieldWidths.sum();
    if (this.showCustomScrollbars && !this.frozen && grid != null && grid._showSortButton() &&
        !this.vscrollOn)
    {
        width += grid._getSorterWidth();
    }

    // If we have left/right space account for this in the width applied to the outer div so
    // we don't clip things too small
    if (this.leftSpace) width+= this.leftSpace;
    if (this.rightSpace) width += this.rightSpace;

    template[7] = width;
    template[10] = tableHTML;

    if (isc.Browser.isMoz) template[11] = this._$fillerDiv;
    return template.join(isc.emptyString);
},

innerSizeChanged : function (reason, b,c,d) {
    var returnVal = this.invokeSuper(isc.GridRenderer, "innerSizeChanged", reason, b,c,d);

    var zIndexDiv = this._getZIndexDiv();
    if (zIndexDiv != null) {
        var grid = this.grid,
            width = this._fieldWidths.sum();
        if (this.showCustomScrollbars && !this.frozen && grid != null && grid._showSortButton() &&
            !this.vscrollOn)
        {
            width += grid._getSorterWidth();
        }
        zIndexDiv.style.width = width + isc.px;
    }

    return returnVal;
},

isFastScrolling : function () {
    return this.isDragScrolling() || this.isRepeatTrackScrolling() || this.isMouseWheelScrolling();
},

shouldUseQuickDrawAheadRatio : function () {
    // NOTE: useQuickDrawAheadRatio is a flag you can flip on temporarily when there's some
    // reason other than fast scrolling that you want quick redraws (eg column drag resize)
    return this.useQuickDrawAheadRatio || this.isFastScrolling();
},


doneFastScrolling : function () {
    // if our last redraw was caused by fast scrolling we will have applied the quick
    // draw ahead ratio when determining which records to draw. In this case we now want
    // to redraw with the standard drawAhead ratio so short distance scrolls around this area
    // will requrie fewer redraws
    var redrawRequired = this._appliedQuickDrawAhead;
    if (redrawRequired) {
        // set the flag to suppress drawAhead direction calculation. This ensures that we
        // add draw-ahead rows in all directions on the theory that the user is done scrolling
        // large increments in  one direction.
        // We clear this flag when the delayed redraw() actually fires
        this._suppressDrawAheadDirection = true;
        this.markForRedraw("Done Fast scrolling.");
    }
},

// given a range elements (rows or cols) currently visible in the viewport, apply the
// drawAheadRatio to determine the range to draw.  The "drawAheadRatio" is a fraction (>1) of
// the viewport. "scrollForward" is the scrolling direction: true (forward), false (backward),
// or null (unknown)
addDrawAhead : function (startIndex, endIndex, maxIndex, scrollForward, vertical) {


    // figure out how many elements we intend to draw
    var useQuickDrawAhead = this.shouldUseQuickDrawAheadRatio(),
        ratio = useQuickDrawAhead && this.quickDrawAheadRatio != null ?
                                             this.quickDrawAheadRatio : this.drawAheadRatio,
        numToDraw = Math.ceil((endIndex - startIndex) * ratio);
    // respect the flag to suppress the drawAhead scrolling direction logic
    if (this._suppressDrawAheadDirection) scrollForward = null;

    if (scrollForward != null) {
        // we know the scroll direction; render extra elements in the current direction of
        // scrolling
        if (scrollForward) endIndex = startIndex + numToDraw;
        else startIndex = endIndex - numToDraw;
    } else {
        // we haven't been scrolled yet; if we're flush at the beginning (very common), render
        // ahead forward
        if (startIndex == 0) endIndex = numToDraw;
        else {
            // otherwise, render extra rows on either side
            var extraElements = Math.ceil((numToDraw - (endIndex - startIndex))/2);
            startIndex -= extraElements;
            endIndex += extraElements;
        }
    }

    // clamp ends of the range to 0 / maxIndex
    if (startIndex < 0) {   // shift both ends of the range forward so startIndex = 0
        endIndex -= startIndex;
        startIndex = 0;
    }

    if (endIndex >= maxIndex) { // shift both ends of the range back so endIndex < maxIndex
        var offset = endIndex - (maxIndex -1);
        startIndex = Math.max(0, (startIndex - offset));
        endIndex = Math.max(0, maxIndex - 1);
    }



    // store a flag indicating whether this redraw used the special 'quick draw ahead' code
    // this is checked in doneFastScrolling to determine whether a redraw is required.
    if (useQuickDrawAhead) this._appliedQuickDrawAhead = true;
    else delete this._appliedQuickDrawAhead;

    return [startIndex, endIndex];
},

// Helper - returns 1 if this is the frozen body of a ListGrid, zero otherwise.

_isFrozenBody:function() {
    if (this.grid && this.grid.frozenBody == this) return 1;
    return 0;
},

getExtraRowHeight : function (startRow, endRow) {
    var total = 0;
    for (var rowNum = startRow; rowNum < endRow; rowNum++) {
        var height = this.getRowHeight(this.getCellRecord(rowNum, 0), rowNum, this._isFrozenBody()),
            extraHeight = (height - this.cellHeight);
        if (extraHeight > 0) {
            //this.logWarn("rowNum: " + rowNum +
            //             " in range: " + [this._firstDrawnRow, this._lastDrawnRow] +
            //             " with extraHeight: " + extraHeight);
            total += extraHeight;
        }
    }
    return total;
},

getDrawArea : function (colNum) {
    // Figure out what rows should be drawn
    // --------------------------------------------------------------------------------------------
    var totalRows = this.getTotalRows(), startRow, endRow, vScrollForward;

    // figure out if we should show all cells in case the total displayable cells are less than
    // drawAllMaxCells
    var totalCells = totalRows * this.fields.length,
        showAllCells = totalCells <= this.drawAllMaxCells &&
                       !isc.EH.dragging && !this.isAnimating() &&
                       !(this.parentElement && this.parentElement.isAnimating());

    if (this.showAllRows || showAllCells) {
        // draw all rows
        startRow = 0;
        endRow = Math.max(totalRows - 1, 0);
    } else {
        // ordinary incremental rendering
        var rowArr = this._getDrawRows();
        startRow = rowArr[0];
        endRow = rowArr[1];
        // just for logging
        vScrollForward = rowArr[2]
    }

    // Figure out which columns to draw
    // --------------------------------------------------------------------------------------------
    var startCol, endCol, totalCols = this.fields.length, hScrollForward;
    if (colNum != null) {
        // a column number was specified, draw that column only (needed for legacy Nav4 support, and
        // for column auto-sizing)
        startCol = colNum;
        endCol = colNum + 1;
    } else if (showAllCells || this.shouldShowAllColumns()) {
        // draw all columns
        startCol = 0;
        endCol = totalCols - 1;
    } else {
        // incremental rendering
        var visibleColumns = this.getVisibleColumns();
        // detect scrolling direction: true (forward), false (backward), or null (unknown)
        hScrollForward = (this.lastScrollLeft == null ? null :
                          this.lastScrollLeft < this.getScrollLeft());

        var drawAheadRange = this.addDrawAhead(visibleColumns[0], visibleColumns[1],
                                               totalCols, hScrollForward);

        startCol = drawAheadRange[0];
        endCol = drawAheadRange[1];
    }

    // figure out the appropriate chunk size on first draw ever
    if (this.cacheDOM && !this._rowChunkSize) {
        this._rowChunkSize = endRow - startRow;
        this._colChunkSize = endCol - startCol;
    }



    return [startRow, endRow, startCol, endCol];
},

_getDrawRows : function () {

    // figure out which rows we need to draw to minimally fill the viewport
    var visibleRows = this._getViewportFillRows();

    // detect scrolling direction: true (forward), false (backward), or null (unknown)
    var vScrollForward = (this.lastScrollTop == null ? null :
                          this.lastScrollTop < this.getScrollTop());

    var totalRows = this.getTotalRows();

    // Note: addDrawAhead will add the draw-ahead rows (rows drawn offscreen for
    // scrolling), and clamp the ends of the drawn range to the ends of the data (ensuring
    // we don't end up with startRow < 0, or endRow > (totalRows-1)
    var drawAheadRange = this.addDrawAhead(visibleRows[0], visibleRows[1],
                                           totalRows, vScrollForward, true);


    if (this.virtualScrolling && this.grid) {
        var data = this.grid.data,
            topRow = drawAheadRange[0];
        if (topRow > 0 && topRow < this.getViewportHeight() / this.cellHeight) {
            // for ResultSet and ResultTree, don't try to draw unloaded records
            if (isc.ResultSet && isc.isA.ResultSet(data)) {
                var lastLoadedRow = data.findLastCached(topRow, true);
                if (lastLoadedRow != null) drawAheadRange[0] = lastLoadedRow;

            } else if (isc.ResultTree && isc.isA.ResultTree(data)) {
                var loadingMarker = isc.ResultTree.getLoadingMarker(),
                    firstPageRange = data.getRange(0, topRow, true),
                    lastLoadedRow = firstPageRange.lastIndexOf(loadingMarker);
                drawAheadRange[0] = lastLoadedRow + 1;

            // assume records always valid for non-databound case
            } else {
                drawAheadRange[0] = 0;
            }
        }
    }


    if (this.virtualScrolling && this.cellHeight < this.getAvgRowHeight()) {
        this._ensureDrawRangeFillsViewport(drawAheadRange, visibleRows);
    }

    //this.logWarn("draw range: " + this._getViewportFillRows() + " fwd:" + vScrollForward +
    //             ", after adding drawAhead:" + drawAheadRange);

    // just for logging - return whether we added the fwd scroll
    drawAheadRange[2] = vScrollForward;

    return drawAheadRange;
},

// extend end of drawAheadRange, potentially, to ensure viewport is filled with content

_ensureDrawRangeFillsViewport : function (drawAheadRange, visibleRows) {
    // beginning "draw ahead" - inclusive indices
    var firstOffsetRow = drawAheadRange[0],
        lastOffsetRow = visibleRows[0] - 1;

    // no beginning "draw ahead" - nothing to do
    if (firstOffsetRow > lastOffsetRow) return;


    var minHeight = 0,
        firstDrawnRow = this._firstDrawnRow,
        lastDrawnRow = this._lastDrawnRow
    ;

    // there are no drawn rows, or they don't intersect the beginning "draw ahead" region; just
    // compute the minimum height of the beginning "draw ahead" using (worst-case) GR.cellHeight
    if (firstDrawnRow == null || firstDrawnRow > lastOffsetRow || lastDrawnRow < firstOffsetRow)
    {
        minHeight = (lastOffsetRow - firstOffsetRow + 1) * this.cellHeight;

    // otherwise, use the actual heights of any drawn rows as the minimum height for those rows
    } else {

        var heights = this._getDrawnRowHeights();


        // use GR.cellHeight as min height for any undrawn rows before the drawn rows
        if (firstOffsetRow < firstDrawnRow) {
            minHeight = (firstDrawnRow - firstOffsetRow) * this.cellHeight;
        }
        // add heights contributed from the drawn rows in the beginning "draw ahead"
        for (var i = Math.max(firstOffsetRow - firstDrawnRow, 0);
                 i <=          lastOffsetRow - firstDrawnRow && i < heights.length;
                 i++)
        {
            minHeight += heights[i];
        }
        // use GR.cellHeight as min height for any undrawn rows after the drawn rows
        if (lastDrawnRow < lastOffsetRow) {
            minHeight += (lastOffsetRow - lastDrawnRow) * this.cellHeight;
        }
    }

    // compute the worst-case number of extra rows we must add at the end of the fill rows

    var avgHeight = this.getAvgRowHeight() * (lastOffsetRow - firstOffsetRow + 1),
        requiredRows = Math.ceil((avgHeight - minHeight) / this.cellHeight);
    if (requiredRows <= 0) return;

    // update drawAheadRange to extend visibleRows by requiredRows, if it hasn't already been,
    // making sure not to run off the end of the data (as reflected by the total row count).
    if (drawAheadRange[1] - visibleRows[1] < requiredRows &&
        drawAheadRange[1] < this.getTotalRows() - 1)
    {
        var newLastRow = Math.min(visibleRows[1] + requiredRows, this.getTotalRows() - 1);
        if (this.logIsDebugEnabled("virtualScrolling")) {
            this.logDebug("Extending ending 'draw ahead' region since beginning 'draw ahead' " +
                          "is present to ensure viewport is filled: " + drawAheadRange +
                          " => " + drawAheadRange[0] + ", " + newLastRow, "virtualScrolling");
        }
        drawAheadRange[1] = newLastRow;
    }
},





// get the row at the coordinate, as a floating point number representing a partial distance
// through the row
getRowCoordinate : function (coord) {
    var rowNum = this.getEventRow(coord),
        // get our offset into it
        rowTop = this.getRowTop(rowNum),
        offsetIntoRow = coord - rowTop,
        rowHeight = this.getRowSize(rowNum),
        percentIntoRow = offsetIntoRow / rowHeight;

    // detect inconsistency between getEventRow and getRowTop()
    //if (offsetIntoRow < 0 || offsetIntoRow > rowHeight) {
    //    this.logWarn("*******************************\n" +
    //                 ", coord: " + coord +
    //                 ", eventRow: " + rowNum +
    //                 ", rowTop: " + rowTop +
    //                 ", offsetIntoRow: " + offsetIntoRow +
    //                 ", rowSize: " + rowHeight +
    //                 ", firstDrawn: " + this._firstDrawnRow +
    //                 ", lastDrawn: " + this._lastDrawnRow +
    //                 ", heights: " + this._getDrawnRowHeights());
    //}

    return rowNum + percentIntoRow;
},


// override to interpret ratio in terms of rowNum instead of scrollTop vs scrollHeight
scrollToRatio : function (vertical, ratio, reason,a,b) {
    if (!vertical || !this._isVirtualScrolling) {
        return this.invokeSuper(isc.GridRenderer, "scrollToRatio", vertical,ratio,reason,a,b);
    }

    var maxRow = this.getTotalRows() - 1,
        exactRowNum = ratio * maxRow,
        rowNum = Math.floor(exactRowNum),
        rowOffset = Math.round((exactRowNum - rowNum) * this.getRowSize(rowNum));


    this._targetRow = rowNum;
    this._rowOffset = rowOffset;
    this._scrollToTargetRow(reason || "scrollToRatio");

    // if scrolling to that position makes us dirty, setup to scroll to the indicated target
    // row during redraw
    if (this.isDirty()) {
        this._scrollRatio = ratio;
        this._targetRow = rowNum;
        this._rowOffset = rowOffset;
    }
},

// override to return ratio in terms of rowNum instead of scrollTop vs scrollHeight
getScrollRatio : function (vertical,b,c,d) {

    if (!vertical || !this._isVirtualScrolling) {
        return this.invokeSuper(isc.GridRenderer, "getScrollRatio", vertical,b,c,d);
    }
    if (this.isDirty() && this._scrollRatio != null) return this._scrollRatio;

    // if there are 0 or 1 rows, we're at the top
    var maxRow = this.getTotalRows() - 1;

    if (maxRow <= 0) return 0;

    var scrollTop = this.getScrollTop(),
        topCoord = this.getRowCoordinate(scrollTop),
        ratio = topCoord / maxRow;

    //this.logWarn("getScrollRatio: " + ratio +
    //             ", maxRow: " + maxRow +
    //             ", topCoord: " + topCoord);

    return Math.min(1,ratio);
},

// show a fixed-size thumb in virtualScrolling mode.  Otherwise thumb size fluctuates
// meaninglessly.
getViewportRatio : function (vertical,b,c,d) {
    if (!vertical || !this._isVirtualScrolling) {
        return this.invokeSuper(isc.GridRenderer, "getViewportRatio", vertical,b,c,d);
    }
    var avgRowHeight = this._viewRatioRowHeight || this.getAvgRowHeight();

    return Math.min(1, (this.getViewportHeight() / avgRowHeight) / this.getTotalRows());
},

// take some drawn row that is likely to remain drawn, and store the position it should be in
// relative to the viewport, so that if we have to redraw, we can match user expectation by
// placing rows where the user expects.
_storeTargetRow : function (scrollTop, delta) {
    // don't pick up a target row during the special scroll that places us on the target row
    if (this._literalScroll) return;


    if (this.isEmpty()) {
        this._targetRow = this._rowOffset = 0;
        return;
    }

    // according to scrolling direction, pick the row at the top or bottom of the viewport as
    // the row most likely to remain onscreen
    var viewportEdge,
        targetRow,
        maxRow = this.getTotalRows()-1;
    if (delta > 0) {
        // scrolling down
        viewportEdge = scrollTop + this.getViewportHeight();
        targetRow = this.getEventRow(viewportEdge);
        // If there is no row at the end of the viewport (possible with the spacer we write out for
        // virtual scrolling to work), clamp to the last actual row in the data set.
        if (targetRow == -2 && maxRow >= 0) {
            targetRow = maxRow;
        }
    } else {
        viewportEdge = scrollTop;
        targetRow = this.getEventRow(viewportEdge);
    }


    if (targetRow < this._firstDrawnRow) targetRow = this._firstDrawnRow;
    if (targetRow > this._lastDrawnRow)  targetRow = this._lastDrawnRow;

    if (targetRow < 0 || targetRow > maxRow) {
        this._targetRow = maxRow;
        this._rowOffset = 0;
    } else {
        this._targetRow = targetRow;
        // how far into the target row the top of the viewport should be (positive means more
        // of row is scrolled offscreen)
        this._rowOffset = scrollTop - this.getRowTop(this._targetRow) + delta;


        if (-this._rowOffset > this.getViewportHeight() ||
             this._rowOffset > this.getRowSize(this._targetRow))
        {
            this.logInfo("storeTargetRow: targetRow: " + targetRow + " with offset: " +
                this._rowOffset + " would place the targetRow outside the viewport, clearing",
                         "virtualScrolling");
            this._rowOffset = this._targetRow = null;
        }
    }


},

// scroll the previously stored target row into the stored position
_scrollToTargetRow : function (reason) {
    var targetRow = this._targetRow,
        offset = this._rowOffset;

    // If the target row is off the end of our data-set, clamp to the
    // last row we actually have.
    // This can occur if the user scrolls to the end of a tall grid, then
    // filters such that there are fewer results
    var maxRow = this.getTotalRows()-1;
    if (targetRow > maxRow) {
        targetRow = this._targetRow = maxRow;
        offset = this._rowOffset = 0;
    }

    var scrollTop = this.getRowTop(targetRow) + offset;


    this._literalScroll = true;

    this._scrollHeight = null;
    this.scrollTo(null, scrollTop, reason || "targetRow");

    this._literalScroll = false;

    // stop reporting last requested scroll ratio since we've now scrolled to match the
    // requested ratio
    this._scrollRatio = null;
},

scrollIntoView : function (x,y, width, height, xPosition, yPosition, animated, callback, alwaysCenter, source) {
    if ((source != null) && (source != this)) {
        // This method call from a child widget
        return;
    }

    this.invokeSuper(isc.GridRenderer, "scrollIntoView", x,y, width, height, xPosition, yPosition, animated, callback, alwaysCenter, source);
},

// if we're rendering rows/cols incrementally, we may need to redraw on scroll
scrollTo : function (left, top, reason, animating) {
    if (isc._traceMarkers) arguments.__this = this;


    if (this._isVirtualScrolling && top != null && reason != "nativeScroll") {
        var oldScrollTop = this.getScrollTop(),
            delta = top - oldScrollTop;

        if (delta != 0) {
            this._storeTargetRow(oldScrollTop, delta);
            top = Math.min(top, this.getRowTop(this.getTotalRows()-1));
        }
    }


    this.invokeSuper(isc.GridRenderer, "scrollTo", left,top, reason, animating);

    // don't check for the need to redraw if we're already dirty.  Optimization: for
    // scroll-and-scroll-back situations, we could avoid a redraw by undirtying ourselves
    if (this.isDirty() || this._scrollFromRedraw) return;

    // if we're only drawing rows near the viewport..
    if (!this._delayedRedraw && this._needAxisRedraw()) {

        this.redrawOnScroll(!this.isFastScrolling() && this.instantScrollTrackRedraw &&
                            (reason !== this._$nativeScroll ||
                             isc.Browser.iOSVersion < 8 ||
                             !this._usingNativeTouchScrolling()));
    }
},

_getRedrawOnScrollCallback:function () {
    if (this._redrawOnScrollCallback == null) {
        var _this = this;
        this._redrawOnScrollCallback = function () {
            delete this._pendingScrollRedrawFromWheel;

            // fire a synthetic mouseMove - this will update the
            // mouseOver row, etc
            _this._fireSyntheticMouseMove();

            _this.redraw("scrolled")
        };
    }
    return this._redrawOnScrollCallback;
},

redrawOnScroll : function (immediate) {

    // Suppress redrawOnScroll during rowHeight animation.
    // If we're shrinking a row, and we're scrolled to the end we expect to see scrolls
    // occur natively during the animation - we don't want to cut it short and redraw

    if (this._rowHeightAnimation) {
        return;
    }
    if (immediate) {
        this.redraw("scrolled");
    } else {
        var isMouseWheelScrolling = this.isMouseWheelScrolling(),
            delay = this.getScrollRedrawDelay(isMouseWheelScrolling);
        if (delay == 0) {
            this.markForRedraw("scrolled");
        } else {
            this.fireOnPause("scrollRedraw", this._getRedrawOnScrollCallback(), delay);
            this._pendingScrollRedrawFromWheel = isMouseWheelScrolling;
        }
    }

    this._scrollRedraw = true;

    // used by isc.Browser.useHighPerformanceGridTimings code to disable modal prompt
    if (this.grid && this.grid.body) this.grid._redrawOnScrollInProgress = true;
},

getScrollRedrawDelay : function (isMouseWheelScrolling) {
    var delay = isc.Browser.isTouch ? this.touchScrollRedrawDelay : this.scrollRedrawDelay;
    // detect drag scroll and don't fire intervening redraws to avoid too many fetches to
    // server for ResultSet-backed GRs
    if (this.isDragScrolling()) return this.dragScrollRedrawDelay;

    if (this.scrollWheelRedrawDelay == null) return delay;

    if (isMouseWheelScrolling == null) {
        isMouseWheelScrolling = this.isMouseWheelScrolling();
    }
    if (isMouseWheelScrolling) {
        delay = this.scrollWheelRedrawDelay;
    }
    return delay;
},

_needRowRedraw : function () {
    if (this.showAllRows) return false;

    // we have a range of records that have been drawn, from grid._firstDrawnRow to
    // grid._lastDrawnRow (updated in getTableHTML).  See if the new viewport falls
    // completely into the drawn range.
    // NOTE: we use visible rows rather than viewport fill rows because by using
    // actual rendered row height we can avoid some redraws when we have several viewports
    // worth of drawn data due to tall rows.
    // Note also that visible rows is only an approximation if asked about an undrawn area,
    // which is fine, because all we care about is whether the new viewport falls
    // completely within the drawn range.
    var visibleRows = this.getVisibleRows(),
        firstVisible = visibleRows[0],
        lastVisible = visibleRows[1];

    // check that the last visible row doesn't exceed the total number of rows we will
    // draw.  NOTE: -1 because totalRows is a count and lastVisible is an index.
    var totalRows = this.getTotalRows();
    if (lastVisible > totalRows-1) lastVisible = totalRows-1;

    var needRedraw = (firstVisible < this._firstDrawnRow || lastVisible > this._lastDrawnRow);




    return needRedraw;
},

_needColumnRedraw : function () {
    // if we're only drawing columns near the viewport..
    if (this.shouldShowAllColumns()) return false;

    var visibleCols = this.getVisibleColumns(),
        firstVisible = visibleCols[0],
        lastVisible = visibleCols[1],
        needRedraw = (firstVisible < this._firstDrawnCol || lastVisible > this._lastDrawnCol);


    return needRedraw;
},

_needAxisRedraw : function () {
    return this._needRowRedraw() || this._needColumnRedraw();
},

// disable incremental rendering when overflow:visible is set on the fly
setOverflow : function (overflow) {
    if (overflow == isc.Canvas.VISIBLE) {
        this.showAllRows = true;
    }

    return this.Super("setOverflow", arguments);
},


// Cache DOM mode
// ---------------------------------------------------------------------------------------
// Mode that caches rendered chunks of the grid area to avoid redrawing as a user revisits the
// same area of the grid without having changed anything.  Currently incomplete.



// === cacheDOM mode limitations
// - can't have fixedRecordHeights:false
// - does not support row animation
// - doesn't work with rowSpans
// - shouldn't use with full-row inline edit and large number of columns
// - doesn't support startSpace / endSpace



getRowChunkNum : function (logicalRowNum) {
    return Math.round(logicalRowNum / this._rowChunkSize);
},

getColChunkNum : function (logicalColNum) {
    return Math.round(logicalColNum / this._colChunkSize);
},

getTableChunk : function (rowChunkNum, colChunkNum) {
    var tableCache = this._tableCache;
    if (!tableCache) return;

    // if row and col are unpassed, return the chunk at 0,0
    rowChunkNum = rowChunkNum || 0;
    colChunkNum = colChunkNum || 0;

    var colCache = tableCache[rowChunkNum];
    return colCache ? colCache[colChunkNum] : null;
},

getTableChunkAt : function (logicalRowNum, logicalColNum) {
    var rowChunkNum = this.getRowChunkNum(logicalRowNum),
        colChunkNum = this.getColChunkNum(logicalColNum),
        tableElem = this.getTableChunk(rowChunkNum, colChunkNum);

    if (tableElem != null) {
        // semi-hack: set the offsets used in getTableElement() to find physical cells from
        // logical cells
        this._firstDrawRow = rowChunkNum * this._rowChunkSize;
        this._firstDrawnCol = colChunkNum * this._colChunkSize;
        return tableElem;
    }
},

// We need to ensure the table cache is clear after we've reset our inner HTML
// - otherwise we'll be pointing to stale elements.
// Clear the cache before we update inner HTML and
// also set a flag so any inadvertant calls to code that would re-cache coming
// from getInnerHTML will not re-cache stale elements.
// note: _updateInnerHTML is called if we have no children, otherwise
// _updateParentHTML updates the innerHTML

_updateInnerHTML : function (a,b,c,d) {

    if (this.cacheDOM) {
        this.drawVisibleChunks();
    } else {
        this._clearTableCache();
        this._suppressTableCaching = true;
        this.invokeSuper(isc.GridRenderer, "_updateInnerHTML", a,b,c,d);
        delete this._suppressTableCaching;
    }
},

_updateParentHTML : function (a,b,c,d) {
    this._clearTableCache();
    this._suppressTableCaching = true;
    this.invokeSuper(isc.GridRenderer, "_updateParentHTML", a,b,c,d);
    delete this._suppressTableCaching;
},

// in cacheDOM mode, this is called in lieu of normal redraw
drawVisibleChunks : function () {
    // figure out what undrawn chunks are visible and draw them
    var visibleRows = this.getVisibleRows(),
        visibleCols = this.getVisibleColumns(),
        startRowChunk = this.getRowChunkNum(visibleRows[0]),
        startColChunk = this.getColChunkNum(visibleCols[0]),
        endRowChunk = this.getRowChunkNum(visibleRows[1]),
        endColChunk = this.getColChunkNum(visibleCols[1]);

    for (var rowChunk = startRowChunk; rowChunk < endRowChunk; rowChunk++) {
        for (var colChunk = startColChunk; colChunk < endColChunk; colChunk++) {
            if (this.getTableChunk(rowChunk, colChunk) == null) {
                this.logWarn("drawing chunk: " + [rowChunk, colChunk]);
                this.renderTableChunk(rowChunk, colChunk);
            }
        }
    }

    var newHTML = this.getTableHTML();
},

renderTableChunk : function (rowChunkNum, colChunkNum) {
    // figure out geometry of table to draw
    var startRow = rowChunkNum * this._rowChunkSize,
        endRow = startRow + this._rowChunkSize,
        startCol = colChunkNum * this._colChunkSize,
        endCol = startCol + this._colChunkSize;

    // draw new table chunk
    var html = this.getTableHTML([startCol, endCol], startRow, endRow),
        tableElem = isc.Element.insertAdjacentHTML(this.getHandle(), "beforeEnd", html, true);

    //this.logWarn("html form chunk: " + [rowChunkNum, colChunkNum] +
    //             "\n" + html +
    //             "\nelement: " + this.echo(tableElem));

    // cache the table element
    var tableCache = this._tableCache = this._tableCache || [],
        colCache = tableCache[rowChunkNum] = tableCache[rowChunkNum] || [];
    colCache[colChunkNum] = tableElem;
},

//>Animation Row Animation support
// ---------------------------------------------------------------------------------------
// Methods to animate a show / hide of multiple rows

//> @method gridRenderer.startRowAnimation()
// Animates a show / hide of rows by growing the rows into view.
// Note: the rows to be shown/hidden should already be in the data, and the calling function
// is responsible for any manipulation to the data / redraw at the end of this method.
// @param show (boolean) are we showing or hiding rows?
// @param startRow (number) first row in range to be shown/hidden
// @param endRow (number) last row in range to be shown/hidden
// @param [callback] (callback) callback to fire when animation completes
// @param [speed] (number) speed for the animation in pixels / second
// @param [duration] (number) if speed is not set, number of milliseconds for the animation to take
// @param [effect] (string) optional acceleration effect for the animation
// @param [slideIn] (boolean) if specified, the rows will appear to slide into view rather than
//                            being revealed
//<
// additional param indicates this was called from the listGrid - we use this to ensure
// we fire the callback in the listGrid's scope
startRowAnimation : function (show, startRow, endRow, callback, speed, duration, effect, slideIn,
                              fromListGrid, isDelayed) {
    // Always call finishRowAnimation - this will no op if there is no current/pending
    // row animation in progress
    this.finishRowAnimation();
    if (!this.isDrawn() || !this.isVisible()) {
        if (callback != null) {
            var target = fromListGrid ? this.parentElement : this;
            target.fireCallback(callback);
        }
        return;
    }
    if (show == null) show = true;
    if (startRow == null) startRow = 0;
    if (endRow == null) endRow = this.getTotalRows() - 1;

    if (startRow == endRow) {
        this.logWarn("startRowAnimation passed empty row range, aborting: " +
                     [startRow, endRow]);
        return;
    }


    var canRedraw = this.readyToRedraw("animating show / hide of rows", false);
    if (!canRedraw) {
        this._delayedRowAnimationArgs = [show, startRow, endRow, callback, speed,
                                         duration, effect, slideIn, fromListGrid];
        this._delayedRowAnimation = isc.Timer.setTimeout(
                                        {target:this, methodName:"_delayedStartRowAnimation"},
                                        0
                                    );
        return;
    }


    // redraw, placing an entire subtable with the rows to be animated inside a single row, and
    // measure the size of the rows we're going to reveal or hide


    // When doing a 'slide-in' animation, we have to write out every row to be revealed since
    // they'll all scroll past the user's nose.
    // Have a check for this being a huge number of rows so we don't hit performance issues
    // generating this initial HTML!
    if ((endRow-startRow) > this.maxAnimateSlideInRows) slideIn = false;
    // set up the this._slideInAnimationRows attribute - this allows us to determine
    // whether we need to write out every row in the fragment
    this._slideInAnimationRows = slideIn;
    var fragmentHeight = this._initializeShowHideRow(show, startRow, endRow, callback, fromListGrid);

    // Use animateRowHeight to grow or shrink the height
    this.animateRowHeight(this._animatedShowStartRow,
                         // NOTE: animate all the way down to zero, so there is no lurch
                         // between the final frame of the animation and the subsequent redraw
                         (show ? fragmentHeight : 0),
                         {target:this, methodName:"_rowShowComplete"},
                         speed, duration, effect, slideIn);
},

// maximum number of rows to be animated into view using a 'slide' animation
// this kind of animation requires every row be rendered so we limit this to ensure
// we don't hit a performance roadblock writing out thousands of records' HTML!
maxAnimateSlideInRows:100,


// Helper to start delayed row animation
_delayedStartRowAnimation : function () {

    if (this._delayedRowAnimationArgs == null) {
        this.logWarn("Unable to perform delayed row animation - bailing");
        return;
    }

    var argsArr = this._delayedRowAnimationArgs,
        show = argsArr[0],
        startRow=argsArr[1],
        endRow = argsArr[2],
        callback = argsArr[3],
        speed = argsArr[4],
        duration = argsArr[5],
        effect = argsArr[6],
        slideIn = argsArr[7],
        fromListGrid = argsArr[8];

    this._delayedRowAnimationArgs = null;
    this._delayedRowAnimation = null;
    // The additional param indicates that the row animation is delayed

    this.startRowAnimation(show, startRow, endRow, callback, speed, duration, effect, slideIn,
                           fromListGrid, true);
},


// helper method to redraw the GR in its state at the beginning of the show/hide row animation
// Returns the height of the table fragment to be written into the animation row.
_initializeShowHideRow : function (show, startRow, endRow, callback, fromListGrid) {

    // If we've already been called and performed a redraw to set up the animated row table,
    // just return the height of the rows to animate
    // This allows us to separate the initial redraw (rendering the animation rows in a clippable
    // div) from the row animation.

    var fragmentHeight = 0;
    if (this._animatedShowStartRow == startRow && this._animatedShowEndRow == endRow) {

        // check the animation cell only
        var animationCell = this.getTableElement(this._animatedShowStartRow, 0),
            clipDiv = this._getCellClipDiv(animationCell);

        if (!clipDiv) {
            fragmentHeight = (endRow - startRow) * this.cellHeight;
        } else fragmentHeight = clipDiv.scrollHeight;

    } else {

        // hang a flag onto this table so we know where the fragment gets written into the normal
        // table.
        this._animatedShowStartRow = startRow;
        this._animatedShowEndRow = endRow;

        // if we're hiding visible rows, we can look at their drawn heights now
        if (!show) {
            var heights = this._getDrawnRowHeights();
            for (var i = startRow; i < endRow; i++) {
                fragmentHeight += heights[i];
            }

            // used when writing out the row containing the fragment
            this._animatedShowRowHeight = fragmentHeight;
            // This redraw writes out the single animation row with an entire table inside it
            this.redraw("initializing animated hide row");

        // In this case we're going to show rows that are currently undrawn.
        } else {
            this._animatedShowRowHeight = 1;
            this.redraw("initializing animated show row");
            // At this point we have written out the fragment and it's clipped by the containing
            // cell / div
            var animationCell = this.getTableElement(this._animatedShowStartRow, 0),
                clipDiv = this._getCellClipDiv(animationCell);

            if (!clipDiv) {
                fragmentHeight = (endRow - startRow) * this.cellHeight;
            } else fragmentHeight = clipDiv.scrollHeight;

        }

        if (this.isDirty()) this.redraw("Initializing row animation requires second redraw");
    }

    this._animatedShowCallback = {callback:callback,
                                  target:(fromListGrid ? this.parentElement : this)};

    return fragmentHeight;
},

// finishRowAnimation - synchronously short-cut to the end of the current row show/hide
// animation, and fire the callback.
finishRowAnimation : function () {
    // a currently running rowAnimation (show/hide rows) implies a running rowHeightAnimation -
    // finishing that will jump to the appropriate size and fire the callback to finish the
    // show/hide animation
    if (this._animatedShowStartRow != null) {
        this.finishAnimateRowHeight();

    } else {
        // In this case we're not running a show/hide row animation - but we may have set up
        // a delayed one

        if (this._delayedRowAnimation != null) {

            // don't fire the delayed animation
            isc.Timer.clearTimeout(this._delayedRowAnimation);

            var args = this._delayedRowAnimationArgs,
                show = args[0], startRow = args[1], endRow = args[2],
                callback = args[3], duration = args[4], fromListGrid = args[5];

            delete this._delayedRowAnimationArgs;
            delete this._delayedRowAnimation;

            if (!this.readyToRedraw()) {
                this.logWarn("Finish row animation called while Grid is not ready to redraw. " +
                             "GridRenderer HTML will not be updated when callback fires.", "animation");
                var target = fromListGrid ? this.parentElement : this;
                if (callback) target.fireCallback(callback);

            } else {
                // redraw the GR with the single animation row containing the table fragment
                // at the start of the animation height
                var fragmentHeight = this._initializeShowHideRow(show, startRow, endRow, callback, fromListGrid);
                // set the height to the final height of that row and fire the 'complete' method
                // to fire callbacks / clean up vars (rather than ever performing an animation
                this.setRowHeight(startRow, (show ? fragmentHeight : 1));
                this._rowShowComplete();
            }
        }
    }
},

// Fired when animated show / hide of rows completes.
_rowShowComplete : function () {
    var callback = this._animatedShowCallback;
    delete this._animatedShowCallback;
    delete this._animatedShowStartRow;
    delete this._animatedShowEndRow;
    delete this._animatedShowRowHeight;
    // We stored the callback as an object {target:... callback:...}
    // This allows us to fire the callback on the ListGrid if that's where the method was
    // originally called from
    if (callback && callback.callback) callback.target.fireCallback(callback.callback);
},

//> @method gridRenderer.animateRowHeight()
// Will animate a resize of a row to the specified height, firing a callback when the resize
// is complete
// @param rowNum (number) Row to resize
// @param toHeight (number) new height for the row
// @param [callback] (callback) Callback to fire when animation completes
// @param [speed] (number) Speed for the animation (pixels / second)
// @param [duration] (number) duration of the resize in ms
// @param [effect] (string) Optionally an acceleration effect can be specified - if not specified
//                          default is to do a smooth animation (no acceleration)
// @param [slideIn] (boolean) if specified, rows will appear to slide into view rather than
//                            being revealed
//<
// Additional param 'fromListGrid' indicates this was fired from the ListGrid, so we should
// fire the callback in that scope
_$none:"none",
animateRowHeight : function (rowNum, toHeight, callback, speed, duration, effect,
                             slideIn, fromListGrid) {
    // If we're not drawn, no need to try to animate since this is a visual update only
    if (!this.isDrawn()) {
        if (callback) {
            var target = (fromListGrid ? this.parentElement : this);
            target.fireCallback(callback);
        }
        return;
    }

    // simultaneous row height animations not currently supported
    if (this._rowHeightAnimation != null) {
        this.logInfo("early finish of row animation, because new animation started",
                     "animation")
        this.finishAnimateRowHeight();
    }

    var fromHeight = this.getRowSize(rowNum);

    // If speed (pixels / second) is specified, it takes precedence over duration
    if (speed != null) {
        var change = (toHeight - fromHeight);
        if (change < 0) change = 0 - change;

        duration = Math.round((change / speed) * 1000);
        // Don't let the animation exceed a maximum
        if (duration > this.animateRowsMaxTime) duration = this.animateRowsMaxTime;
    }

    this._rowAnimationInfo = {
        _rowNum:rowNum,
        _fromHeight:fromHeight,
        _toHeight:toHeight,
        _callback:callback,
        _slideIn:slideIn,
        _fromList:fromListGrid
    }

    effect = (effect || this._$none);
    if (this.logIsInfoEnabled("animation")) {
        this.logInfo("starting row animation, row:" + rowNum  +
                    ", duration: " + duration + ", effect: " + effect,
                     "animation")
    }
    this._rowHeightAnimation = this.registerAnimation(
                                    {target:this, method:this._fireRowAnimation},
                                    duration, effect
                               );
    // suppress adjustOverflow until the row animation completes. This will avoid unnecessary
    // scrollbars from showing up
    if (this.overflow == isc.Canvas.AUTO || this.overflow == isc.Canvas.SCROLL)
        this._suppressAdjustOverflow = true;
},

_fireRowAnimation : function (ratio) {

    var info = this._rowAnimationInfo;

    if (info == null) return;

    var rowNum = info._rowNum,
        rowHeight = this._getRatioTargetValue(info._fromHeight, info._toHeight, ratio);

    if (isc.Browser.isSafari && info._fromHeight > info._toHeight)
        this._forceRowRefreshForAnimation = true;
    // pass in explict "" as className so we don't adjust sizing for the standard row styling
    // (which won't be applied to this row during animation)
    this.setRowHeight(rowNum, rowHeight, null, isc.emptyString, true, true, true);
    if (isc.Browser.isSafari) delete this._forceRowRefreshForAnimation;

    if (info._slideIn) {
        var clipDiv = this._getCellClipDiv(this.getTableElement(rowNum,0));
        if (clipDiv) {
            var scrollHeight = clipDiv.scrollHeight,
                offsetHeight = clipDiv.offsetHeight;
            if (scrollHeight > offsetHeight) clipDiv.scrollTop = scrollHeight - offsetHeight;
            else clipDiv.scrollTop = 0;
        }
    }

    // Fire the completion callback in a separate thread - this means if it does a lot of
    // processing we shouldn't see a visual pause before the native repaint at the full-size
    if (ratio == 1) {
        isc.Timer.setTimeout({target:this, methodName:"_rowAnimationComplete"}, 0);
    }
},

// Fired when we're done with a row resize animation
_rowAnimationComplete : function () {
    // In screen reader mode, after a row animation completes, we'll want to put the focus
    // back on the last focus row, unless some other widget was focused while the row animation
    // was running.
    if (isc.screenReader) {
        var focusCanvas = this.ns.EH.getFocusCanvas();
        this._putNativeFocusInRow(this.getNativeFocusRow(), focusCanvas != null && focusCanvas !== this);
    }

    // allow standard adjustOverflow to resume
    delete this._suppressAdjustOverflow;
    this.adjustOverflow("row animation complete");


    var info = this._rowAnimationInfo;

    delete this._rowHeightAnimation;
    delete this._rowAnimationInfo;

    if (info && info._callback) {
        var target = info._fromList ? this.parentElement : this;
        target.fireCallback(info._callback);
    }
},


//> @method gridRenderer.finishAnimatingRowHeight()
// Completes any row height animation currently in progress and fires the callback from that
// animation.<br>
// May be fired automatically to avoid (unsupported) overlapping animations, etc.
//<
// Leave this as unexposed for now
finishAnimateRowHeight : function () {

    if (!this._rowHeightAnimation) return;

    // cancel upcoming animation cycles
    this.cancelAnimation(this._rowHeightAnimation);

    // Simply firing the "last step" of the rowHeight animation will jump to the appropriate
    // height and fire the callback

    this._fireRowAnimation(1);
},

//<Animation

// When printing we need to write out embedded components' printHTML directly in our table HTML
_getPrintChildren : function () {
    return this._embeddedComponents;
},


// returns the tableHTML for printing.
// Used direclty by ListGrid.getPrintHTML()

getTablePrintHTML : function (colNum, startRow, endRow, discreteCols, asyncCallback) {
    return this.getTableHTML(colNum, startRow, endRow, discreteCols, asyncCallback);
},



// Should we suppress focus in the widget handle entirely in favor of focussing in rows when
// in screenReader mode?
screenReader_suppressHandleFocus:true,

draw : function () {

    this._clearCellValueCacheForDraw();

    // don't write tabIndex/ focus/blur handlers onto the handle if we're
    // going to write them onto a row element.
    if (isc.screenReader && this.screenReader_suppressHandleFocus) {
        this.clipHandleIsFocusHandle = this.isEmpty();
    }
    return this.Super("draw", arguments);
},

// Notification from draw() - clear our cellValueCache so we don't show stale values

_clearCellValueCacheForDraw : function () {
    this._clearCellValueCache();
},


handleKeyDown : function (event, eventInfo) {
    var rv = this.Super("handleKeyDown", arguments);
    if (rv != false && isc.screenReader && this.screenReader_suppressHandleFocus) {
        var mask = isc.EH.clickMaskUp(),
            hardMaskUp = false;
        if (mask) {
            var masks = isc.EH.clickMaskRegistry;
            for (var i = 0; i < masks.length; i++) {
                if (isc.EH.isHardMask(masks[i])) {
                    hardMaskUp = true;
                    break;
                }
            }
        }
        if (!hardMaskUp) {
            var keyName = event.keyName;
            if (keyName == "Tab") {
                this._focusInNextTabElement(!isc.EH.shiftKeyDown())
                return false;
            }
        }
    }
    delete this._setFocusRunning;

    return rv;
},


handleFocusIn : function (event,eventInfo) {

    if (isc.Browser.isIE && isc.EH.leftButtonDown()) {
        var nodeName = event && event.nativeTarget ? event.nativeTarget.nodeName : null;
        if (nodeName == "TD") {
            this.logDebug(
                "GridRenderer: Intercepting native focus from mouseDown on table cell and resetting to handle.",
                "nativeFocus");
            this.focus();
        }
    }
    return this.Super("handleFocusIn", arguments);

},

// allowRowSpanning: If set to false we never call getRowSpan even if the method is present.
// This is a grid passthrough attribute - defaulted to false at the ListGrid level.

allowRowSpanning:true,


closeNOBRs:false,

_getScreenReaderCellSeparatorID : function () {
    return this._getDOMID("screenReaderCellSeparator");
},
_getScreenReaderRowSeparatorID : function () {
    return this._getDOMID("screenReaderRowSeparator");
},


   _lockVirtualScrolling : function () {},
_canStopVirtualScrolling : function () {return false;},


_shouldSubtractVBorderPadFromRowHeight : function () {
    return isc.Browser.isStrict &&
           ((isc.Browser.isMoz && isc.Browser.version >= 17) ||
            (isc.Browser.isSafari || isc.Browser.isIE));
},

// returns the innerHTML for the table
// If passed a startRow / endRow, it will return just the HTML for that fragment of the table.
// asyncCallback / isAsync is required for printing only. This allows us to handle the
// embedded components generating their printHTML asynchronously
getTableHTML : function (colNum, startRow, endRow, discreteCols, asyncCallback, isAsync) {
    if (isc._traceMarkers) arguments.__this = this;
    //>DEBUG
    // timing
    var t0 = isc.timeStamp();
    //<DEBUG

    // show empty message
    if (this.isEmpty()) {
        // clear drawn area
        this._firstDrawnRow = this._lastDrawnRow =
                this._firstDrawnCol = this._lastDrawnCol = null;

        // note that if we're printing, showEmptyMessage handles embedding the
        // printHeaders / printFooters directly in the generated message text.
        return this._showEmptyMessage();
    }

    // If we're printing and we have embedded components we need to get their printHTML
    // and plug it into the cells directly
    if (this.isPrinting && (!this._printingChunk || startRow == 0)) {

        var printComponents = this._getPrintChildren();

        if (printComponents != null && printComponents.length > 0) {

            for (var i = 0; i < printComponents.length; i++) {
                var component = printComponents[i];
                if (component._gridBodyPrintHTML != null) continue;
                var printComponentContext = {
                        component:component,
                        colNum:colNum, startRow:startRow, endRow:endRow, descreteCols:discreteCols,
                        asyncCallback:asyncCallback
                    };
                // this.logWarn("calling getPrintHTML on embedded component:" + printComponents[i]);
                var printCHTML = printComponents[i].getPrintHTML(
                                    this.printProperties,
                                    asyncCallback == null ? null
                                        : {target:this, methodName:"gotComponentPrintHTML",
                                            context:printComponentContext}
                                 );
                if (printCHTML != null) {
                    component._gridBodyPrintHTML = printCHTML;
                } else {
                    // If the printComponent generates its printHTML asynchronously,
                    // we will be notified and fire the gotComponentPrintHTML() method
                    // when that returns, at which point we'll re-run this method, skipping
                    // the component(s) for which we already have HTML and ultimately firing
                    // the asyncCallback.
//                    this.logWarn("GR.getTableHTML() - getPrintHTML for component:" +
//                        component + " went asynchronous", "printing");
                    return null;
                }
            }
        }

        // at this point we've generated HTML for all our print components and stored it
        // We'll write it directly into the cells / rows below.
    }

    var fragment = (startRow != null && endRow != null),
        rangeStart = startRow != null ? startRow : 0,
        rangeEnd = endRow != null ? endRow : this.getTotalRows();

    // Figure out rows and columns to actually draw
    // ----------------------------------------------------------------------------------------

    var drawRect = this._getTableHTMLDrawArea(startRow, endRow, true),
        grid = this.grid;

    if (!fragment) {
        // If virtualScrolling is enabled, turn it on unless we're showing all rows.
        var showingAllRows = (drawRect[0] == 0 && drawRect[1] == this.getTotalRows());
        if (this.virtualScrolling) {
            var oldIsVirtualScrolling = this._isVirtualScrolling,
                newIsVirtualScrolling = !showingAllRows
            ;

            if (newIsVirtualScrolling != oldIsVirtualScrolling &&
                (newIsVirtualScrolling || this._canStopVirtualScrolling()))
            {
                this._isVirtualScrolling = newIsVirtualScrolling;
                if (this._isVirtualScrolling) {
                    // off => on transition
                    if (this.isDrawn()) {
                        // set up GR._targetRow/GR._rowOffset for a eeamless jump
                        var scrollTop = this.getScrollTop(),
                            targetRow = this.getEventRow(scrollTop),
                            targetTop = this.getRowTop(targetRow)
                        ;
                        // target the first row that's fully visible
                        if (targetTop < scrollTop) targetRow++;
                        this._targetRow = targetRow;
                        this._rowOffset = scrollTop - this.getRowTop(targetRow);

                        // we must now recompute the first and last drawn rows
                        drawRect = this._getTableHTMLDrawArea(startRow, endRow, true);
                    }
                } else {
                    // on => off transition; clean up virtual scrolling state
                    // _targetRow / _rowOffset maintains apparent scroll position in redraws
                    delete this._targetRow;
                    delete this._rowOffset;
                    // _scrollRatio is similarly used when doing a scrollToRatio
                    delete this._scrollRatio;
                    // _viewRatioHeight is used to determine scrollbar thumb size when virtual
                    // scrolling.  (We don't technically need to clear this - it's ignored if
                    // _isVirtualScrolling is false and would be reset when virtual scrolling
                    // was reintroduced.)
                    delete this._viewRatioHeight
                }
            }
            // Lock virtual scrolling on if it becomes active to avoid "jumps" as it switches
            // off and on due to the user scrolling or opening and closing nodes of a Treegrid.
            if (this._isVirtualScrolling) this._lockVirtualScrolling();
        }
    }

    startRow = drawRect[0];
    endRow   = drawRect[1];

    // always refresh _firstDrawnCol / _lastDrawnCol
    // This may be required even if we're rendering a fragment as  in some cases we
    // asynchronously
    // fetch fragments (EG printing HTML) and the rendered area may have changed (EG
    // shouldPrint:false fields)
    if (!this._gettingAutoSizeHTML) {
    this._firstDrawnCol = drawRect[2];
    this._lastDrawnCol = drawRect[3];
    }

    // colNum can be passed to render one column only - used for auto-sizing
    // or if passed an array can specify a specific set of columns - used for
    // rendering an entire row (without spacers), for (EG) showing row HTML as a drag-tracker
    // discreteCols parameter implies the colNum array passed in is a set of specific cols
    // to render (used when we're determining auto-size of a set of discontiguous columns) -
    // in this case startCol / endCol aren't actually going to be used
    var colsArray = colNum != null && isc.isAn.Array(colNum),
        startCol, endCol;
    if (!colsArray) discreteCols = false;

    if (colNum != null) {
        if (colsArray) {
            startCol = colNum[0];
            endCol = colNum[1] + 1;
         } else {
            startCol = colNum;
            endCol = colNum +1;
        }
    } else {
        startCol = this._firstDrawnCol;
        endCol = this._lastDrawnCol + 1;
    }

    var colNums;
    if (discreteCols) colNums = colNum;
    else {
        colNums = [];
        for (var i = startCol; i < endCol; i++) {
            colNums[colNums.length] = i;
        }
    }

    // total columns we'll be drawing, for colSpans
    var numCols = colNums.length;

    // if "colNum" has been passed such that we are returning the HTML for just one column, we
    // are essentially in showAllColumns mode in the sense that we don't want to adding
    // padding/margins to compensate for unrendered columns
    var showAllColumns = (this.shouldShowAllColumns() || colNum != null);

    // Draw
    // ---------------------------------------------------------------------------------------

    var output = isc.StringBuffer.create(),
        fields = this.fields,
        sizes = this._fieldWidths;

    // remember the specified width of the first column when we draw.  This helps us prevent
    // unnecessary redraw on resize; see setColumnWidths()
    this._colWidthAtDraw = colNums[0] != 0 ? null : this._fieldWidths[0];

    var leftColPad, rightColPad, totalHorizontalWidth, padType;
    if (!showAllColumns || this.leftSpace != null || this.rightSpace != null) {
        leftColPad = (this.leftSpace != null) ? this.leftSpace : 0;
        rightColPad = (this.rightSpace != null) ? this.rightSpace : 0;

        // figure out size of columns to left and right of visible area
        if (!showAllColumns) {
            leftColPad += this._fieldWidths.slice(0, startCol).sum();
            rightColPad += this._fieldWidths.slice(endCol, this._fieldWidths.length).sum();
        }
        totalHorizontalWidth = this._fieldWidths.sum()

        //this.logWarn("column pads: " + [leftColPad, rightColPad] + " type:" + padType);
        padType = (this.cacheDOM || (isc.Browser.isIE && !(isc.Browser.isIE8 || isc.Browser.isIE9))
            ? "margin" : "padding");
        //padType = "padding";
    }
    var autoFit = this.autoFit;

    var widthHTML = "";
    if (colNum != null) {
        if (!autoFit && this.fixedColumnWidths) {
            // if rendering just one column, size it to 100% of it's containing Canvas, since
            // the Canvas will be sized to the column width
            widthHTML = " WIDTH=100%";
        }
    } else if (this.isPrinting && this.autoFit) {
        // when printing, autoFit should mean full screen
        widthHTML = " WIDTH=100%";

    } else if ((isc.Browser.isIE8Strict || isc.Browser.isMoz || isc.Browser.isSafari)
                && !autoFit)
    {
        // total size of the table we're drawing (NOTE: may be larger or smaller than the body
        // Canvas, since the body Canvas is a viewport on to this table)
        var tableWidth = this._fieldWidths.slice(startCol, endCol).sum();

        widthHTML = " WIDTH=" + tableWidth;
    }

    // output a blank spacer in a DIV that is as tall as all the records before the table.
    // This causes the scrollable area to be as large as if we were drawing all records,
    // so the thumb is the correct size and scrolling works as expected.

    // In some cases we explicitly specify additional space to show above / below the
    // rows in a GridRenderer (this.startSpace / endSpace)
    // If this.startSpace is non null, add it to the calculated height of the undrawn
    // start rows.
    // Note that in this case the range of rows is shifted down - already handled by
    // _getViewportFillRows
    var startSpacerHeight = this.startSpace || 0;
    if (fragment) startSpacerHeight = 0;
    if (startRow != rangeStart) {
        var undrawnRowHeight = ((startRow - rangeStart) * this.getAvgRowHeight());
        this._startRowSpacerHeight = undrawnRowHeight;
        startSpacerHeight += undrawnRowHeight;
    } else {
        this._startRowSpacerHeight = 0;
    }




    var canResizeSpacerDivs = true;
    var totalHeight = (rangeEnd - rangeStart) * this.getAvgRowHeight();
    if (isc.Browser.isIE) {
        if (totalHeight > 1300000) canResizeSpacerDivs = false;
    }
    if (!fragment) this._canResizeSpacerDivs = canResizeSpacerDivs;



    if (totalHeight > 10000000) {
        this.logWarn("This grid is showing " + (rangeEnd - rangeStart).toLocalizedString()
            + " rows. Due to native rendering limitations, grids with this many rows"
            + " may not appear correctly on all browsers. Consider filtering the data"
            + " displayed to the user to reduce the total number of rows displayed at a time."
            + " This will improve usability as well as avoiding unpredictable behavior.");
    }

    if (!this.cacheDOM && !this.isPrinting) {
        // If the space is zero sized, we still want to write out the spacer div so we can handle
        // setStartSpace() etc without a redraw
        // In IE specifying the height as zero px won't work, so set display none instead to ensure
        // the spacer takes up no space
        // Give the spacer DIV an ID so we can look at it's height, etc. later.
        // When we resize this on the fly (in setStartSpace()) we'll set display back to the default
        // (inline) if necessary.

         output.append("<DIV style='width:1px;");
         if (canResizeSpacerDivs) {
             output.append("height:", startSpacerHeight, "px;overflow:hidden;");
         }
         if (startSpacerHeight == 0) output.append("display:none;");
         output.append("' ");

         if (fragment || this.isPrinting) {
             output.append(">");
         } else {
             output.append(" ID="+ this.getID()+ "_topSpacer>");
         }
         output.append(isc.Canvas.spacerHTML(1, startSpacerHeight), "</DIV>");
    }

    //
    //    output the start table tag
    //
    // XXX: If height of the list is screwy in IE5 until the cursor passes over it,
    //            we should set the height of the table explicitly
    // Note: We divide large tables into chunks so we can assemble the HTML in separate threads
    // (avoids script is running slowly message). Avoid writing out the outer table tags for every
    // chunk so the HTML ends up in a single table.
    if (!this._printingChunk || (startRow == 0 && !this.printChunkOnly)) {
        if (isc.screenReader) {

            output.append("<div id='", this._getScreenReaderCellSeparatorID(), "' style='display:none' aria-hidden='true'>",
                          this.screenReaderCellSeparator, "</div>",
                          "<div id='", this._getScreenReaderRowSeparatorID(), "' style='display:none' aria-hidden='true'>",
                          this.screenReaderRowSeparator, "</div>");
        }
        output.append(

            "<TABLE", (isc.Browser.isIE && (isc.screenReader || !this.canSelectText) ? " unselectable='on'" : null), " role='presentation' BORDER=0",
            widthHTML,
            ((!fragment && !this.isPrinting) ? " ID=" + this.getTableElementId() : null),
            (this.tableStyle && isc.Browser.isDOM ?
             " CLASS='" + this.tableStyle + this._$singleQuote : isc._emptyString),
            " CELLSPACING=" , this.cellSpacing,
            " CELLPADDING=" , this.cellPadding,
            " STYLE='",


            (isc.Browser.isDOM && !autoFit && this.fixedColumnWidths ?
             "table-layout:fixed;overflow:hidden;" : ""),

            (!showAllColumns ?
                padType + (this.isRTL() ? "-right: " : "-left:") + leftColPad + "px;" +
                padType + (this.isRTL() ? "-left:" : "-right:") + rightColPad + "px;"
            : ""),


            (this.cacheDOM && this._startRowSpacerHeight > 0
                ? "margin-top:" + this._startRowSpacerHeight + "px;" : ""),

            // if we plan to scroll immediately after draw, draw the table as hidden, so we don't
            // momentarily see it in the wrong scroll position
            (this._targetRow != null && !(isc.Browser.isIE && this._avoidRedrawFlash)
                && !this.isPrinting ? "visibility:hidden;" : ""),
            "'>",

            (isc.Browser.isMoz ? "<TBODY></TBODY>" : "")
        );


        var vPad = 0, hPad = 0,
            // get style we'll use on the first record, used for sizing calculations
            firstRecordStyle = this._getFirstRecordStyle();

        if (this._shouldSubtractVBorderPadFromRowHeight()) {

            if ((isc.Browser.isIE && isc.Browser.version < 8) ||
                (isc.Browser.isSafari && isc.Browser.safariVersion < 530))
            {
                hPad = this._getCellHBorderPad();
            }

            vPad = (this.fixedRowHeights ? 0 : this.cellPadding * 2);
            vPad += isc.Element._getVBorderSize(firstRecordStyle);
        }
        // store pad amounts since they are needed on cell refresh
        this._vPad = vPad;
        this._hPad = hPad;

        output.append("<colgroup>");


        if (!autoFit && isc.Browser.isDOM) {

            for (var i = 0; i < colNums.length; i++) {
                output.append("<COL WIDTH=" , (sizes[colNums[i]] - hPad), ">");
            }
        }

        output.append("</colgroup>");


        output.append("<TBODY>");
    }


    var cellHeight = this.cellHeight,
        // Do we need to write a DIV into the cell (See comments in _writeDiv())
        writeDiv = this._writeDiv(cellHeight),
        nowrap = !this.wrapCells && !isc.Browser.isIE8Strict,
        skipNOBR = !nowrap || writeDiv,
        cellWrapHTML = (skipNOBR ? "" : "<NOBR>"),
        cellWrapHTMLClose = (!this.closeNOBRs || skipNOBR ? "" : "</NOBR>")
    ;

    var singleCells = 0;

    // Draw rows
    // --------------------------------------------------------------------------------------------
    if (isc.Browser.isDOM) {





        // template of cell HTML
        var cellHTML = [],
            ariaSlot = 1, heightAttrSlot = 2, heightSlot = 3, alignAttrSlot = 4, alignSlot = 5,
            valignAttrSlot = 6, valignSlot = 7, widthSlot = 8,
            minHeightCSSSlot = 10, cssStartSlot = 11, styleSlot = 18,
            cellIDSlot, cellIDs, divStartSlot = 21, cellValueSlot = 24;
        cellHTML[0] = "<TD ";

        if (isc.Browser.isIE && (isc.screenReader || !this.canSelectText)) cellHTML[0] += " unselectable='on'";
        // [1] ARIA attributes if enabled
        // [2] height attribute, if set (per row)
        // [3] height value, if set (per row)
        cellHTML[4] = " ALIGN=";
        // [5] align (per col) and rowSpan (per cell) if necessary
        // [6] valign attribbute, if set (per cell)
        // [7] valign value, if set (per cell)
        // [8] width (per col) OR colspan when drawing a one-cell row (per row).
        //     Ends with an open STYLE='
        //cellHTML[9] = ";filter:Alpha(opacity=100);";
        // [gap]
        // [10] min-height css text - used for rows with shouldFixRowHeight() == false where
        //     this.fixedRowHeights as a whole is true
        // [11] cssText range start (per cell)
        // [12] used if this.fastCellUpdates is true!
        // [gap]
        cellHTML[16] = skipNOBR && !this.wrapCells ? ";white-space: nowrap;" : null;
        // [17] fastCellUpdates: close STYLE attribute; no CLASS attribute will be written
        // [17] normal: close STYLE attribute, start CLASS attribute
        cellHTML[17] = this.fastCellUpdates ? "' " : "' class=";
        // [18] cell style (when not using fastCellUpdates)
        // don't write out cell element id's for fragments - it's possible that we'd end up with
        // duplicate IDs that way.
        if (!fragment && !this.isPrinting && (isc.screenReader || this.getCellElementId)) {
            cellHTML[19] = " id=";
            cellIDSlot = 20;
        }
        // [20] cell ID (per cell, optional)
        // [21] DIV start to force correct cellHeight, if necessary (per table)
        // [22] rest of DIV to force column width if writeDiv (per column)
        cellHTML[23] = ">" + cellWrapHTML; // ">" + wrap (per table)
        // [24] value range start (per cell)
        // [gap]
        cellHTML[30] = cellWrapHTMLClose + (writeDiv ? "</DIV></TD>" : "</TD>");

        var rowStart = "<TR",
            rowEnd = "</TR>",
            gt = ">",
            heightAttr = " HEIGHT=",
            valignAttr = " VALIGN=";

        if (grid && grid.canDragRecordsOut && grid.useNativeDrag) {
            rowStart += " draggable='true'";
        }


        if (isc.Browser.isMobileWebkit) rowStart += " onmousedown='return true;' style='-webkit-tap-highlight-color: rgba(0,0,0,0)'";

        // make row elements programmatically focuseable

        var tabIndexString;
        if (isc.screenReader) {
            tabIndexString = " tabIndex=-1";
        }
        // whether to write ARIA attributes
        var ariaEnabled = isc.Canvas.ariaEnabled();

        // these are used only when cells have rowSpans (only possible if getRowSpan() has been
        // defined)

        // colNum -> number of remaining cells to skip (for columns where a cell spans into the
        // current row)
        var cellSkips = [],
            // number of cells that will be skipped in this row.  Increased when spans start,
            // decreased when they end
            skipCount = 0,
            // colNum -> start row of rowSpanning cell (for columns where a cell spans into the
            // current row)
            cellSkipSourceRows = [];

        // rowSpanning: outerSpanCount is a map of logical rowNum -> count of number of DOM cells that
        // have actually been written into the first column - the "visual" row number if
        // spanning cells in the leftmost column are taken to define "rows".
        var outerSpanCount = this._outerSpanCount = {};

        this._cacheColumnHTML(colNums, autoFit, hPad, writeDiv);

        if (this.isPrinting && (!this._printingChunk || (startRow == 0 && !this.printChunkOnly))) {

            output.append(this.getPrintHeaders(startCol, endCol));
        }

        var isFrozenBody = this._isFrozenBody();
        if (cellIDSlot != null) {
            cellIDs = new Array(colNums.length);
        }
        // output each record in turn
        for (var rowNum = startRow; rowNum < endRow; rowNum++) {
            //>Animation

            var isAnimationRow = (!fragment && this._animatedShowStartRow == rowNum);
            //<Animation

            if (cellIDSlot != null) {
                var physicalRowNum = rowNum - startRow;
                for (var i = 0; i < colNums.length; ++i) {
                    var colNum = colNums[i],
                        physicalColNum = colNum - startCol;
                    if (this.getCellElementId) {
                        cellIDs[physicalColNum] = this.getCellElementId(rowNum, physicalRowNum, colNum, physicalColNum);
                    } else {

                        cellIDs[physicalColNum] = this.ID + "_"+"cell" + rowNum + "_" + colNum;
                    }
                }
            }

            // get a pointer to the record for this row.
            // NOTE: record can be null.  The various routines below (eg getCellValue) are
            // expected to handle this.
            var record = this.getCellRecord(rowNum);

            // If this row is a separator or is not loaded yet, we draw a single cell with
            // COLSPAN set to extend across the entire table.
            var drawRecordAsSingleCell = //>Animation
                                         isAnimationRow ||   //<Animation
                                         this._drawRecordAsSingleCell(rowNum, record);
            // start the table row
            output.append(rowStart);
            if (tabIndexString != null) {
                // Assign the correct tabIndex plus focus/blur handlers to the single row
                // that should get native focus if we're not allowing native focus to go to the handle
                if (this.screenReader_suppressHandleFocus) {
                    if (this.getNativeFocusRow() == rowNum) {
                        output.append(" tabIndex=", this.getTabIndex(),
                                    isc.Canvas._onFocus, this._getNativeFocusHandlerString(),
                                    isc.Canvas._onBlur, this._getNativeBlurHandlerString());
                    } else {
                        output.append(tabIndexString);
                    }
                } else {
                    output.append(tabIndexString);
                }
            }
            if (!fragment && !this.isPrinting  && this.getRowElementId) {
                output.append(" ID=", this.getRowElementId(rowNum, rowNum-startRow));
            }
            if (ariaEnabled) {
                var rowRole = this.getRowRole && this.getRowRole(rowNum, record);
                if (rowRole) output.append(" role='", rowRole, "'");

                // output attributes such as "selected"
                var rowState;
                if (this.getRowAriaState != null) {
                    rowState = this.getRowAriaState(rowNum, record);
                } else if (cellIDSlot != null && isc.screenReader) {
                    rowState = { labelledby: null };
                }
                if (rowState != null) {
                    if (cellIDSlot != null && isc.screenReader && rowState.labelledby == null) {
                        var labelledByIDs = cellIDs;

                        if (isc.isA.TreeGrid && isc.isA.TreeGrid(grid)) {
                            var treeFieldNum = grid._treeFieldNum,
                                treeFieldBody = grid.getFieldBody(treeFieldNum);
                            if (treeFieldBody === this) {
                                var localTreeColNum = grid.getLocalFieldNum(treeFieldNum);
                                if (startCol <= localTreeColNum && localTreeColNum < endCol) {
                                    labelledByIDs = cellIDs.duplicate();
                                    labelledByIDs[localTreeColNum - startCol] = grid._getTreeCellValueID(rowNum);
                                }
                            }
                        }
                        rowState.labelledby = (labelledByIDs.join(" " + this._getScreenReaderCellSeparatorID() + " ") + " " +
                                               this._getScreenReaderRowSeparatorID());
                    }
                    output.append(isc.Canvas.getAriaStateAttributes(rowState));
                }
            }
            output.append(gt);

            // set per-row pieces of cell HTML

            // establish row height to clip content (fixedRecordHeights:true) or as a minimum
            // (fixedRowHeights:false)

            // use the getRowHeight function if it's defined, otherwise use the cellHeight
            // property
            var rowHeight = //>Animation
                            isAnimationRow ? this._animatedShowRowHeight :
                            //<Animation
                            (this.getRowHeight != null ?
                             this.getRowHeight(record, rowNum, isFrozenBody) :
                             cellHeight);

            // If this widget has a 'shouldFixRowHeight()' method, check whether that returns
            // false (enables override of 'fixedRowHeights' on a per-row basis - currently
            // only used internally, for row-level editing of ListGrids)
            var fixedRowHeight;
            if (isAnimationRow) {
                fixedRowHeight = true;
            } else {
                fixedRowHeight = this.fixedRowHeights;


                if (fixedRowHeight && this.shouldFixRowHeight != null) {
                    fixedRowHeight = (this.shouldFixRowHeight(record, rowNum) != false);
                }
            }

            //this.logWarn("rowNum: " + rowNum +
            //             ", rowHeight: " + rowHeight +
            //             ", this.fixedRowHeights: " + this.fixedRowHeights +
            //             ", this row isFixed: " + fixedRowHeight);

            // If this row is of fixed height, write the height out into the TD
            if (fixedRowHeight) {
                // write a height attribute to enforce height
                cellHTML[heightAttrSlot] = heightAttr;
                cellHTML[heightSlot] = rowHeight - vPad;
                cellHTML[minHeightCSSSlot] = null;

            // If the row can expand with content, avoid writing a height into the TD -
            // use the min-height CSSText instead
            } else {
                // don't write a height attribute at all
                cellHTML[heightAttrSlot] = null;
                cellHTML[heightSlot] = null;

                // Apply min css height to per-cell css...
                if (!drawRecordAsSingleCell &&
                    rowHeight == this.cellHeight && !this.fixedRowHeights)
                {
                    // null it out, already handled by CSS that establishes cell height as a
                    // minimum (in the "widthHTML" slot)
                    // Note that if we're drawing as single cell, the widthHTML slot contains
                    // colspan instead, so in this case we need min height CSSText
                    cellHTML[minHeightCSSSlot] = null;
                } else {
                    cellHTML[minHeightCSSSlot] = this._getMinHeightCSSText(record,rowNum);
                }
            }

            if (writeDiv) {
                // this method returns css text to set the height for the DIV

                cellHTML[divStartSlot] = ">" + this._$cellClipDivStart +
                       this._getCellDivCSSHeight(rowHeight, record, rowNum, isAnimationRow);
                if (nowrap) cellHTML[divStartSlot] += "white-space:nowrap;";
            }

            // If we're drawing the record as a single cell, figure out which cells it's spanning

            var singleCellSpan = drawRecordAsSingleCell ?
                                    this._getSingleCellSpan(record,rowNum,startCol,endCol) : null;
            //if (skipCount > 0) {
            //    this.logWarn("rowSpan start rows for row: " + rowNum +
            //                 ": " + cellSkipSourceRows);
            //}

            // output each cell
            for (var i = 0; i < colNums.length; i++) {
                colNum = colNums[i];

                if (this.useCellRecords) record = this.getCellRecord(rowNum, colNum);

                var field = fields[colNum],
                    cellRecord = record;
                if (cellRecord == null) cellRecord = this.getCellRecord(rowNum, colNum);

                if (cellSkips[colNum] > 0) {
                    // this cell will be skipped due to a rowSpanning cell in a previous row

                    // record the start row of the rowSpanning cell
                    field._rowSpans[rowNum] = cellSkipSourceRows[colNum];
                    //this.logWarn("recording start row: " + field._rowSpans[rowNum] +
                    //             " at " + rowNum);

                    // copy down the rowNum as determine by spanning
                    if (colNum == 0) {
                        outerSpanCount[rowNum] = rowNum > 0 ? outerSpanCount[rowNum-1] : 0
                    }

                    // reduce the count of cells remaining to be skipped due to this rowSpanning
                    // cell
                    cellSkips[colNum]--;

                    if (cellSkips[colNum] == 0) {
                        // we don't have to skip any more cells due to this rowSpanning cell
                        skipCount--;
                        // so clear the colNum -> rowNum with rowSpan cell mapping
                        cellSkipSourceRows[colNum] = null;
                    }
                    continue;
                } else if (colNum == 0) {
                    // no spanning in left column, increment row-span based count
                    outerSpanCount[rowNum] = rowNum > 0 ? outerSpanCount[rowNum-1]+1 : 0
                }

                // per column HTML (align)
                var align = this.getCellAlign(record, field, rowNum, colNum);
                if (align != null) {
                    cellHTML[alignSlot] = align;
                } else {
                    // Remove align attribute if there is no value
                    delete cellHTML[alignAttrSlot];
                }

                // per column valign
                var vAlign = this.getCellVAlign(record, field, rowNum, colNum);
                if (vAlign != null) {
                    cellHTML[valignAttrSlot] = valignAttr
                    cellHTML[valignSlot] = vAlign;
                }

                if (singleCellSpan != null && (colNum == singleCellSpan[0])) {
                    // note singleCells variable used for logging only
                    singleCells++;

                    // HTML to cause the cell to span several cells for
                    // drawRecordAsSingleCell case
                    cellHTML[widthSlot] = this._getTDSpanHTML(singleCellSpan[1]-singleCellSpan[0]);

                    // If we're writing out a DIV, we need to close the "'" around the style
                    if (writeDiv) {
                        cellHTML[divStartSlot + 1] = this._$singleQuote;
                    }

                    // We'll write out the rest of the HTML, then increment i to jump to the
                    // end of the span

                } else {
                    // per column HTML (width)
                    // XXX Actually a misnomer - this includes some height information too
                    cellHTML[widthSlot] = field._widthHTML;

                    // we have a row span function, write rowSpan into the table cell (after
                    // the specified width)
                    if (this.allowRowSpanning && this.getRowSpan) {
                        var rowSpan = this._getRowSpan(record, rowNum, colNum);
                        if (rowSpan > 1) {
                            var rowSpanText = " ROWSPAN=" + rowSpan;
                            // piggyback the rowSpan on the alignment slot
                            if (cellHTML[alignSlot] != null)
                                cellHTML[alignSlot] += rowSpanText;
                            else
                                cellHTML[alignSlot] = rowSpanText;
                            // set up to skip outputting cells in this column
                            cellSkips[colNum] = rowSpan - 1;
                            skipCount++;

                            // field._rowSpans:
                            // - is a map of rowNum -> starting rowNum of cell that spans into
                            //   that cell.
                            // - only contains rowSpanning cells; other slots have the value
                            //   undefined.
                            // - exists only on field objects where there are rowSpanning
                            //   cells
                            if (field._rowSpans == null) field._rowSpans = {};
                            field._rowSpans[rowNum] = rowNum;

                            // remember the start row of the rowSpanning cell
                            cellSkipSourceRows[colNum] = rowNum;

                            if (colNum == 0) {
                                outerSpanCount[rowNum] = rowNum > 0 ?
                                                outerSpanCount[rowNum-1]+1 : 0
                            }

                        }
                    }

                    cellHTML[ariaSlot] = null;
                    if (ariaEnabled) {
                        var cellRole = this.getCellRole && this.getCellRole(rowNum, colNum, record);
                        if (cellRole) {
                            cellHTML[ariaSlot] = " role='" + cellRole + "'";
                        }
                        var cellState = this.getCellAriaState && this.getCellAriaState(rowNum, colNum, record);
                        if (cellState != null) {
                            var cellStateAttributes = isc.Canvas.getAriaStateAttributes(cellState);
                            var currentAriaSlotValue = cellHTML[ariaSlot];
                            cellHTML[ariaSlot] = (currentAriaSlotValue == null
                                                  ? cellStateAttributes
                                                  : currentAriaSlotValue + cellStateAttributes);
                        }
                    }

                    if (writeDiv) {
                        // also closes the style= attribute
                        cellHTML[divStartSlot + 1] = field._divWidthHTML;
                    } else {
                        // Note - if we're not writing a DIV, we're not in the middle of a style
                        // attribute, so no need for "'"
                        cellHTML[divStartSlot + 1] = null;
                    }

                }

                // set per-cell pieces of cell HTML
                // -------------------------------------------------------------------------

                // cell style (CSS classname)
                var cellStyle = this.getCellStyle(record, rowNum, colNum),
                    // cell CSS text (direct value for STYLE attribute)
                    customCSSText = (this.getCellCSSText ?
                                     this.getCellCSSText(record, rowNum, colNum) :
                                     null);
                //>Animation
                // always have the animation row cell have no padding / border, since the
                // table written into it already has padding / border for each cell.
                if (isAnimationRow) {
                    var nopad = "padding:0px;border:0px;";
                    if (customCSSText) customCSSText += ";" + nopad
                    else customCSSText = nopad;
                }
                //<Animation



                // canonicalize the customCSSText to start and end with separators

                if (customCSSText) {
                    if (!customCSSText.endsWith(this._$semi)) {
                        customCSSText += this._$semi;
                    }
                    if (!customCSSText.startsWith(this._$semi)) {
                        customCSSText = this._$semi + customCSSText;
                    }
                }

                if (!this.fastCellUpdates) {
                    // in normal mode, write CLASS=[CSS className] and write custom CSS text into a
                    // STYLE attribute
                    cellHTML[cssStartSlot] = customCSSText == null ? null : String.asAttValue(customCSSText);


                    cellHTML[styleSlot] = isAnimationRow ? "''" : String.asAttValue(cellStyle, false, true);

                } else {

                    var styleText = this._getEscapedStyleText(cellStyle);
                    cellHTML[cssStartSlot] = styleText;
                    cellHTML[cssStartSlot + 1] = customCSSText == null ? null : String.asAttValue(customCSSText);


                }

                // cell value (HTML contents)
                //>Animation
                if (isAnimationRow) {
                    // Set a flag so getTableHTML() is aware that the fragment its returning
                    // is to be used in the animated show/hide row.
                    this._writingAnimatedShowRows = true;
                    var tableHTML = this.getTableHTML(null, this._animatedShowStartRow,
                                                                this._animatedShowEndRow);
                    delete this._writingAnimatedShowRows;


                    if (!writeDiv) {
                        cellHTML[cellValueSlot] = isc.SB.concat(this._$cellClipDivStart,
                                                                this._getCellDivCSSHeight(rowHeight, record, rowNum, isAnimationRow),
                                                                this._$singleQuote, this._$rightAngle, tableHTML,
                                                                "</DIV>");
                    } else {
                        cellHTML[cellValueSlot] = tableHTML;
                    }

                } else    //<Animation


                cellHTML[cellValueSlot] = this._getCellValue(record, rowNum, colNum);

                if (cellIDSlot != null) {
                    cellHTML[cellIDSlot] = cellIDs[colNum - startCol];
                }

                output.append(cellHTML);

                // if the record has an embedded component update its row/colNum now
                if (!fragment && cellRecord != null && this.grid._hasEmbeddedComponents(cellRecord)) {

                    // avoid calling this method multiple times if one record spans several
                    // cells (IE one record / row)
                    var ecs = this.grid._getEmbeddedComponents(cellRecord);
                    if (ecs[0] && ecs[0].rowNum == null) {
                        this.updateEmbeddedComponentCoords(ecs, cellRecord, rowNum, colNum);
                    }
                }

                // see the first cell's HTML, as a sample
                //if (!this._gotSample) {
                //    alert("cellHTML: " + cellHTML.join(""));
                //    this._gotSample = true;
                //}

                if (drawRecordAsSingleCell && (colNum == singleCellSpan[0])) {
                    // increase the counter - well skip the rest of the colNums in the
                    // array

                    i += singleCellSpan[1] - singleCellSpan[0];
                }
            }
            // end the table row
            output.append(rowEnd);

            // If we're printing and there are embedded components that span the entire row,
            // write them into a separate cell

            if (this.isPrinting && record && this.grid && this.grid._hasEmbeddedComponents(record)) {
                var ecs = this.grid._getEmbeddedComponents(record);
                for (var ecIndex = 0; ecIndex < ecs.length; ecIndex++) {
                    var ec = ecs[ecIndex];
                    if (ec._currentColNum == null && ec._gridBodyPrintHTML != null) {
                        output.append(rowStart, gt, '<td colspan="',numCols,'">',
                            ec._gridBodyPrintHTML, "</td>", rowEnd);
                        delete ec._gridBodyPrintHTML;
                    }
                }
            }

            //>Animation
            // Skip the rows between animationStartRow and animationEndRow, since they'll be
            // written into a single row
            if (isAnimationRow) {
                rowNum = this._animatedShowEndRow -1;
            }
            //<Animation
        }
    }

    // output the end table tag
    if (!this._printingChunk || (endRow == this.getTotalRows() && !this.printChunkOnly)) {
        if (this.grid && this.isPrinting) {
            output.append(this.getPrintFooters(startCol, endCol));
        }
        output.append("</TBODY></TABLE>");
    }



    var tailRecords = rangeEnd - endRow,
        virtualScrolling = (!fragment && this._isVirtualScrolling);

    // ignore endSpace if this.cacheDOM is true - not currently supported in that mode.
    var endSpacerHeight = this.cacheDOM ? 0 : (this.endSpace || 0);
    // Ignore endSpace if a fragment was requested.

    if (fragment) {
        endSpacerHeight = 0;
    }
    // reset this._endRowSpacerHeight
    if (!this._gettingAutoSizeHTML) this._endRowSpacerHeight = 0;
    if (!this.showAllRows && (tailRecords != 0 || virtualScrolling)) {
        var endRowSpacerHeight = tailRecords * this.getAvgRowHeight();

        if (virtualScrolling && tailRecords == 0 && !fragment) {
            var minHeight = this.getViewportHeight();
            if (endRowSpacerHeight < minHeight) {
                endRowSpacerHeight = minHeight;
            }
        }

        if (!this._gettingAutoSizeHTML) this._endRowSpacerHeight = endRowSpacerHeight;
        endSpacerHeight += endRowSpacerHeight;
    }
    // NOTE: setting overflow:hidden allows later code to shrink the spacer
    // without rewriting the spacer content
    if (!this.cacheDOM && !this.isPrinting) {

        output.append("<DIV style='width:1px;");
        if (canResizeSpacerDivs) {
            output.append("height:", endSpacerHeight, "px;overflow:hidden;");
        }
        if (endSpacerHeight == 0) output.append("display:none;");
        output.append("' ");

        if (fragment || this.isPrinting) {
            output.append(">");
        } else {
            output.append(" ID="+ this.getID()+ "_endSpacer>");
        }
        output.append(isc.Canvas.spacerHTML(1, endSpacerHeight), "</DIV>");

    }

    //>DEBUG timing
    if (this.logIsDebugEnabled("gridHTML")) {
        var totalTime = (isc.timeStamp() - t0),
            numCells = (numCols * (endRow - startRow)),
            perCell = (totalTime / numCells),
            perSecond = (1000 / perCell);

        // toFixed appears not to be supported in Safari
        if (perCell.toFixed != null) perCell = perCell.toFixed(2);
        if (perSecond.toFixed != null) perSecond = perSecond.toFixed(2);

        this.logDebug("getTableHTML: columns " + (discreteCols ? colNums
                                                    : startCol + "->" + (endCol-1)) +
                      ", rows " + startRow + "->" + (endRow-1) +
                      ", time: " + totalTime + "ms (" +
                      numCells + " cells at " +
                      perCell + "ms per cell, " +
                      perSecond + " cells per second), " +
                      "spacerHeights: [" + [startSpacerHeight, endSpacerHeight] + "], " +
                      "left/right pad: [" + [leftColPad, rightColPad] + "], " +
                      singleCells + " single cell rows",
                      "gridHTML");
    }
    //<DEBUG

    var result = output.release(false);

    if (isAsync) {
        if (asyncCallback != null) {
            this.fireCallback(asyncCallback, "HTML,callback", [result,asyncCallback]);
        }
        return null;
    }

    // now return the output
    return result;
},

_getTableHTMLDrawArea : function (startRow, endRow, setFirstAndLastDrawnRow) {
    var fragment = (startRow != null && endRow != null);

    // Figure out rows and columns to actually draw
    // ----------------------------------------------------------------------------------------

    var drawRect = this.getDrawArea(),
        grid = this.grid,
        scrollRowNum;

    if (grid) {
        if (grid._scrollCell) {
            scrollRowNum = (grid._scrollCell == null ? 0 :
                isc.isAn.Array(grid._scrollCell) ? grid._scrollCell[0] : grid._scrollCell);
        } else if (grid.data && grid.data.getFirstUsedIndex && drawRect[0] == 0) {
            scrollRowNum = grid.data.getFirstUsedIndex();
        }
        if (scrollRowNum) {
            var diff = drawRect[1] - drawRect[0],
                lastRow = scrollRowNum + diff,
                totalRows = this.getTotalRows();

            if (lastRow >= totalRows) {
                scrollRowNum -= (lastRow - (totalRows - 1))
                lastRow = totalRows - 1;
            }
            if (scrollRowNum < 0) scrollRowNum = 0;
            drawRect[0] = scrollRowNum;
            drawRect[1] = lastRow;
        }
    }

    if (!fragment) {
        var firstDrawnRow = drawRect[0],
            lastDrawnRow = drawRect[1];
        //>Animation
        // If we're doing an animated show/hide of some rows, we need to write out enough rows
        // to fill the viewport when the rows to be animated are sized at zero height (will
        // happen either initially or at the end of the draw).
        if (this._animatedShowStartRow != null) {
            lastDrawnRow += (this._animatedShowEndRow - this._animatedShowStartRow);
            var totalRows = this.getTotalRows();
            if (lastDrawnRow >= totalRows) lastDrawnRow = totalRows - 1;
        }
        //<Animation

        // NOTE: _lastDrawnRow/Col are the last row/col to
        // be drawn, logic below renders up to but not including endCol/endRow
        startRow = firstDrawnRow;
        endRow = lastDrawnRow + 1;

        if (setFirstAndLastDrawnRow) {
            this._firstDrawnRow = firstDrawnRow;
            this._lastDrawnRow = lastDrawnRow;
        }


    } else {
        var viewportTop = drawRect[0],
            viewportEnd = drawRect[1] + 1;

        //>Animation
        // A common use of table fragments is animating folder open/close, where we write out
        // a bunch of child rows and animate them into view.
        // In this case if we're scrolling the rows into view and we're inside the viewport,
        // each of the rows will be seen by the user so we can't skip writing any content
        // as we don't want to show blank spacers to the user.
        if (this._writingAnimatedShowRows) {
            // All off the bottom or the top - just draw a big spacer so the scrollbar adjusts
            if (viewportTop > endRow || viewportEnd < startRow) {
                startRow = endRow;
            } else {
                if (!this._slideInAnimationRows) {
                    startRow = Math.max(startRow,viewportTop);
                    endRow = Math.min(endRow,viewportEnd);
                }

            }
        }
        //<Animation
    }
    drawRect[0] = startRow;
    drawRect[1] = endRow;
    return drawRect;
},

// Arbitrary HTML to write out *inside the table* before the first row and after the
// last row, when printing.
// Used to render headers (and footers) by ListGrids - overridden in GridBody class.
getPrintHeaders : function (startCol, endCol) {
    return "";
},
getPrintFooters : function (startCol, endCol) {
    return "";
},

setFocus : function (focus, reason) {
    // If this method gets called recursively, simply call Super

    if (this._setFocusRunning) {
        return this.Super("setFocus", arguments);
    }
    this._setFocusRunning = true;

    // in screenreader mode, we put focus into the current focus row element of the grid when
    // focus is called.
    if (isc.screenReader) {
        // Remember the current scroll position - in some browsers (seen in IE11) the native
        // focus-in-row causes the grid body to scroll such that the rows's top/left coord is in the viewport.
        // We'll reset the scroll after focus
        this._preFocusScrollPosition = [this.getScrollLeft(), this.getScrollTop()];
        // on mousedown, we explicitly call widget.focus() -- ensure that in this case we put focus
        // into the mouse-down row, not into whatever the current focus row happens to be.
        if (reason == "focus on mousedown") {
            var eventRow = this.getEventRow();
            if (eventRow != null && !this.isEmpty()) {
                // Handle the user clicking on the end spacer in a scrolled grid (can come up if
                // virtual scrolling is enabled). In this case we want native focus to go to the
                // last real row, not to a row that's scrolled out of view.
                if (eventRow == -2) eventRow = this.getTotalRows()-1;
                if (eventRow >= 0) {
                    this._putNativeFocusInRow(eventRow, true);
                }
            }
        }
    }
    var rv = this.Super("setFocus", arguments);
    if (isc.screenReader) {
//        this.logWarn("before/after:" + this._preFocusScrollPosition + ", " +
//                     [this.getScrollLeft(), this.getScrollTop()])
        if (this.getScrollLeft() != this._preFocusScrollPosition[0] ||
            this.getScrollTop() !=  this._preFocusScrollPosition[1])
        {
            this.scrollTo(this._preFocusScrollPosition[0], this._preFocusScrollPosition[1],
                          "reset scroll after native row focus (via setFocus())");
        }
        delete this._preFocusScrollPosition;
    }

    return rv;
},

// Helper to put native focus into a row if we're in screenReader mode.

_putNativeFocusInRow : function (rowNum, suppressElementFocus) {

    var updateElement = this.screenReader_suppressHandleFocus;
    // if necessary, clear the tabIndex/focus and blur handlers from the current focus handle
    if (updateElement) {

        this._skipReturningNativeFocusRow = true;
        this._updateHandleForFocus(false);
        this._skipReturningNativeFocusRow = false;

        this._updateHandleForFocus(false);
    }
    this._nativeFocusRow = rowNum;
    // assign the tabIndex / focus/blur handlers to new focus handle
    if (updateElement) this._updateHandleForFocus(true);

    // update this.clipHandleIsFocusHandle

    if (updateElement) {
        this.clipHandleIsFocusHandle = this.isEmpty();
    }

    // Treat "suppressElementFocus:false" as saying explicitly force focus into
    // the row - otherwise only actually focus if we as a widget have logical focus.
    // That allows us to set up the row as a valid tabstop (without forcing focus into it)
    if (suppressElementFocus == null) suppressElementFocus = !this.hasFocus;
    if (suppressElementFocus) {
        return;
    }

    var visibleRows = this._getVisibleRows();
    if (!(visibleRows[0] <= rowNum && rowNum <= visibleRows[1])) {
        return;
    }

    // Remember the current scroll position - in some browsers (observed in IE11) the native
    // focus-in-row causes the grid body to scroll such that the rows's top/left coord is in the viewport.
    // We'll reset the scroll after focus
    var resetScroll;
    if (this._preRowFocusScrollPosition != null){
        resetScroll = false;
    } else {
        this._preRowFocusScrollPosition = [this.getScrollLeft(), this.getScrollTop()];
        resetScroll = true;
    }

    var element = this.getFocusHandle();
    if (element) {
        this.logDebug("_putNativeFocusInRow() about to call native focus()", "nativeFocus");
        element.focus();


        if (!updateElement) isc.EH._focusCanvas = null;
        this.logDebug("_putNativeFocusInRow() about to call native focus() again", "nativeFocus");
        element.focus();
        if (!updateElement) isc.EH._focusCanvas = this;
    }



    if (resetScroll) {
        if (this.getScrollLeft() != this._preRowFocusScrollPosition[0] ||
            this.getScrollTop() != this._preRowFocusScrollPosition[1])
        {
            this.scrollTo(this._preRowFocusScrollPosition[0], this._preRowFocusScrollPosition[1],
                              "reset scroll after native row focus (via putNativeFocusInRow())");

        }
        delete this._preRowFocusScrollPosition;
    }

},


getFocusHandle : function () {
    if (isc.screenReader && !this._skipReturningNativeFocusRow) {
        var rowNum = this.getNativeFocusRow();
        var row = this.getTableElement(rowNum);
        if (row != null) return row;
    }
    return this.Super("getFocusHandle", arguments);
},

// When printing, we call 'getPrintHTML()' on each embedded component.
// This method may run asynchronously.
// This callback is fired when this happens. It stores the print HTML on the component
// temporarily and calls 'getTableHTML()' passing in the callback we were passed.
gotComponentPrintHTML : function (HTML, callback) {

    var context = callback.context,
        component = context.component;

    if (context.asyncCallback == null) {
        return;
    }

    component._gridBodyPrintHTML = HTML;


    return this.getTableHTML(context.colNum, context.startRow, context.endRow,
        context.discreteCols, context.asyncCallback, true);
},


// When we write out the per cell HTML using templating, in fastCellUpdates:true mode,
// we write out style='<style text from css class definition>'
// This helper method will convert any single quotes to HTML entities so that they don't
// terminate the style attribute in the written-out HTML.

_escapedStyleText:{},
_getEscapedStyleText : function (styleName) {
    if (this._escapedStyleText[styleName] != null) return this._escapedStyleText[styleName];
    //this.logWarn("escaping:" + styleName);
    var styleText = isc.Element.getStyleText(styleName, true);

    this._escapedStyleText[styleName] = String.asAttValue(styleText);
    return this._escapedStyleText[styleName];
},


// Methods to return cell alignment
// Overridden on the gridbody class
getCellVAlign : function (record, field, rowNum, colNum) {
    return null;
},

getCellAlign : function (record, field, rowNum, colNum) {
    return field.cellAlign || field.align;
},


// draw record as single cell does not always span the entire row - in the ListGrid, if we have
// a checkbox field we want to show it on records even where singleCellValue is true
// startCol / endCol passed in are the start/end cols we're currently rendering
_getSingleCellSpan : function (record, rowNum, startCol, endCol) {
    return [startCol, endCol];
},

// This is some innerHTML written into the <TD for single cell values, to govern it's COLSPAN
// This is extremely time critical so only create a new string once for each 'span' we have
// requested
_getTDSpanHTML : function (span) {
    if (!isc.GridRenderer._tdSpanHTML) {
        isc.GridRenderer._tdSpanHTML = {_fixedRowHeights:{},
                                      _varRowHeights:{}};
    }
    var cache = this.fixedRowHeights ? isc.GridRenderer._tdSpanHTML._fixedRowHeights
                                      : isc.GridRenderer._tdSpanHTML._varRowHeights;
    if (cache[span]) return cache[span];
    else {
        return cache[span] = " COLSPAN=" + span  + " STYLE='" +
                           (this.fixedRowHeights ? "padding-top:0px;padding-bottom:0px" : "");
    }
},



// Returns the base style of the first record. Used to calculate sizing for cells based on
// the style's padding etc. [making the assumption that the padding etc is constant across potential
// cell styles]
_getFirstRecordStyle : function () {
    var grid = this.grid,
        rowNum = 0;

    if (grid) {
        if (grid._scrollCell) {
            rowNum = grid._scrollCell == null ? 0 :
                isc.isAn.Array(grid._scrollCell) ? grid._scrollCell[0] : grid._scrollCell;
        } else if (grid.data && grid.data.getFirstUsedIndex) {
            rowNum = grid.data.getFirstUsedIndex();
        }
    }

    return (this.getBaseStyle != null ?
            this.getBaseStyle(this.getCellRecord(rowNum,0), 0, 0) :
            this.baseStyle);
},

_cacheColumnHTML : function (colNums, autoFit, hPad, writeDiv) {
    var fields = this.fields,
        sizes = this._fieldWidths;


    // compute per-column HTML
    for (var i = 0; i < colNums.length; i++) {
        var colNum = colNums[i],
            field = fields[colNum];

        field._rowSpans = null; // clear old rowSpan info

        // NOTE: this slot must end in "STYLE='" so that the next slot can be arbitrary CSS text
        if (autoFit) {
            // don't write widths
            field._widthHTML = (isc.Browser.isIE && !isc.Browser.isIEStrict) ? " STYLE='" : " STYLE='OVERFLOW:hidden;";
            // have to reset this HTML in case settings change
            field._divWidthHTML = this._$singleQuote;
        } else {

            var styleStart = isc.Browser.isIE8Strict ? " STYLE='overflow:hidden;" :
                                                       " STYLE='";
            // NOTE: Moz and Win IE5 require that we set the widths of columns in their
            // cells as well as in the COL tags or things won't always display correctly.
            field._widthHTML = (isc.Browser.isIE ?
                                " WIDTH=" + (sizes[colNum] - hPad) + styleStart :
                                " STYLE='" + this._getCSSTextForColWidth(colNum));

            if (writeDiv) {
                field._divWidthHTML = (this._getFieldDivWidthCSSText(colNum) +
                                       this._$singleQuote);
            }


        }

        // when fixedRowHeights is false, we want the cellHeight to act as a minimum height.

        if (!this.fixedRowHeights) {
            field._widthHTML += this._getMinHeightCSSText();
        }


        if (this.fixedRowHeights) field._widthHTML += "padding-top:0px;padding-bottom:0px;";
    }
},

//> @method gridRenderer.cellValueIsClipped() ([A])
// Is the value in a given cell clipped?
// @param rowNum (number) row number of the cell
// @param colNum (number) column number of the cell
// @return (Boolean) null if there is no cell at the given row, column; otherwise, whether the
// value in the specified cell is clipped.
// @see cellValueHover()
// @visibility external
//<
cellValueIsClipped : function (rowNum, colNum) {
    var cellElem = this.getTableElement(rowNum, colNum);
    var clipDiv;
    if (!this._writeDiv(this.cellHeight)) clipDiv = cellElem;
    else clipDiv = this._getCellClipDiv(cellElem);
    return this._cellValueIsClipped(clipDiv);
},
_cellValueIsClipped : function (clipDiv) {
    if (clipDiv == null) return null;
    return isc.Element.getClientWidth(clipDiv) < clipDiv.scrollWidth;
},

// _writeDiv() : Do we need to write a DIV into the grid cells?

// this is re-used for every clipDiv
_$cellClipDivStart:"<DIV role='presentation' cellClipDiv=true style='overflow:hidden;" + isc.Browser._textOverflowPropertyName + ":ellipsis;",

// In some cases we need to write a DIV to clip cells either vertically or horizontally; writing
// overflow hidden and specifying a height or width simply doesn't cause clipping.
_writeDiv : function (cellHeight) {




    var printProps = this.grid && this.grid.currentPrintProperties;
    if (printProps && printProps.printForExport) return false;


    var result = (isc.Browser.isSafari ||

            (isc.Browser.isOpera && !this.autoFit &&
             (this.fixedColumnWidths || this.fixedRowHeights)) ||

           (isc.Browser.isMoz && isc.Browser.geckoVersion >= 20040113 &&
            this.fixedColumnWidths && !this.autoFit) ||


                (this.shouldEnforceVClipping() &&
                    // Moz or IE Strict (Safari covered above - always on)
                    (isc.Browser.isMoz ||
                        (isc.Browser.isIE && (isc.Browser.isStrict || isc.Browser.version >= 10))
                    )
                )
            );
    return result;
},

// Should the record be drawn as a single cell, spanning all the cols in the table?
_drawRecordAsSingleCell : function (rowNum, record) {
    //!DONTCOMBINE
    // If this row is a separator or is not loaded yet, we draw a single cell with COLSPAN
    // set to extend across the entire table.
    return (record &&
            (record[this.singleCellValueProperty] != null || record[this.isSeparatorProperty] ||

             (Array.isLoading(record) &&
                !(isc.Browser.isSafari && (rowNum == 0 || rowNum == this._firstDrawnRow)) )
            )
           );
},

// Method to return the CSS text to specify the height of the div written into a cell

_useMaxHeightForCellDivCSSHeight : function () {
    return (isc.Browser.isMoz || isc.Browser.isSafari || (isc.Browser.isIE &&
                                                          ((isc.Browser.version >= 7 && isc.Browser.isStrict) ||
                                                           isc.Browser.version >= 10)));
},
_getCellDivCSSHeight : function (rowHeight, record, rowNum, isAnimationRow) {
    // vertically clip if..
    var shouldWriteHeight =
                            //>Animation it's the animation row on a row reveal animation,
                            // where if we don't clip, we'll just reveal the new rows
                            // immediately
                            isAnimationRow ||  //<Animation
                            // we're in a situation where we normally enforce clipping on every
                            // row (see comments in _writeDiv)
                            (this.shouldEnforceVClipping() &&
                            // we don't have an implementation of shouldFixRowHeight() that is
                            // telling us not to clip this individual row.  Note this is
                            // currently only used internally in order to allow the edit row to
                            // expand.
                             (this.shouldFixRowHeight == null ||
                              this.shouldFixRowHeight(record, rowNum) != false));




    if (shouldWriteHeight) {

        // Note: since we override padding-top and padding-bottom, we should not need
        // to adjust for it in the height of the DIV if fixedRowHeights is true.
        var divHeight = rowHeight - 2*this.cellSpacing -

                (isAnimationRow ? 0 : 2);
        if (rowNum == this._editRowNum) {
            for (var i = 0; i < this._editRowForm.getItems().length; i ++) {
                divHeight = Math.max(this._editRowForm.getItems()[i].getHeight(), this._editRowForm.getItems()[i].iconHeight);
            }
        }



        // avoid writing out a negative height

        if (divHeight < 1) divHeight = 1;
        return (this._useMaxHeightForCellDivCSSHeight() ? "MAX-HEIGHT:" : "HEIGHT:") + divHeight + "px;";
    }

    return isc._emptyString;
},

// Method to return the CSS text for the width of the div written into a cell.
// NOTE: Assumed to be written in as part of a STYLE=... attribute.
_getFieldDivWidthCSSText : function (colNum) {

    // No need to set a width if we don't have fixed column widths - we already have a minimum
    // from the size written into the TD, and it breaks calculation of scroll width in Safari.
    if (!this.fixedColumnWidths || this.autoFit) return isc.emptyString;

    return "WIDTH:" + this.getInnerColumnWidth(colNum) + "px;";
},

_getMinHeightCSSText : function (record, rowNum) {


    var height = (rowNum != null ? this.getRowHeight(record, rowNum, this._isFrozenBody()) : this.cellHeight),
        IE = isc.Browser.isIE, strict = isc.Browser.isStrict;

    if (strict) height -= this._vPad;

    if (IE && !strict && !(this.autoFit || !this.fixedColumnWidths)) {
        return "MIN-HEIGHT:" + height + "px;"
    }
    return "HEIGHT:" + height + "px;"
},

_getCSSTextForColWidth : function (colNum) {
    if (isc.Browser.isIE || this.autoFit) return isc._emptyString;


    if (this._colWidthCSSText == null) {
        this._colWidthCSSText = [];
        for (var i = 0; i < this._fieldWidths.length; i++) {
            var width = this._fieldWidths[i];

            this._colWidthCSSText[i] = "WIDTH:" + width +
                (this.fixedColumnWidths ? "px;OVERFLOW:hidden;" : "px;");
        }
    }
    return this._colWidthCSSText[colNum];
},

// No default data model for GRs - this is implemented at the ListGrid level
getCellRecord : function (rowNum, colNum) {
    return null;
},

findRowNum : function (record) {
    return -1;
},

findColNum : function (record) {
    return -1;
},


_$divStart:"<div>", _$divEnd:"</div>",
_$spacerDivTemplate:[
    ,                                         // [0] value
    "<div style='height:",                    // [1]
    ,,,,,                                     // [2-6] requiredHeight
    "px;line-height:0px'>&nbsp;</div>"        // [7]
],
_getCellValue : function (record, rowNum, colNum) {
    //!DONTCOMBINE
    var isPrinting = this.isPrinting,
        // We may want to dynamically ignore the cached cell value in some cases

        useCache = !this.bypassCellValueCache(record,rowNum,colNum),

        cachedValue = useCache && this._cachedCellValues != null ?
                         this._getCachedCellValue(record, rowNum, colNum) : null,
        value = cachedValue ? cachedValue.value : this.getCellValue(record, rowNum, colNum, this);

    if (rowNum == 0 && colNum == 0 && this.logIsInfoEnabled("cellValueCache")) {
        var isDebugEnabled = this.logIsDebugEnabled("cellValueCache");
        this.logInfo("getCellValue(0,0): " +
            (cachedValue != null
              ? "Using cached cell value" + (isDebugEnabled ? " of:" + value  : "")
              : "Not using cached cell value"
            ) +
            (isDebugEnabled
              ?  "\nStack:\n" + this.getStackTrace()
              : "(enable debug logging for stacktrace)"),
            "cellValueCache");
    }
    // Cache the cell value for re-use
    if (useCache && !cachedValue) this._cacheCellValue(value, record, rowNum, colNum);

    // If a record has an associated component to display, add a spacer underneath the record
    // to force the contents to draw above the component.

    if (!isPrinting && this._writeEmbeddedComponentSpacer(record)) {
        var details = this.getMaxEmbeddedComponentHeight(record),
            spacerDivTemplate = this._$spacerDivTemplate;
        if (details.allWithin) {
            if (details.requiredHeight && (details.requiredHeight > this.cellHeight)) {
                spacerDivTemplate[0] = value;
                var protoCellHeight = isc.ListGrid.getInstanceProperty("cellHeight"),
                    maxCellHeight = Math.max(protoCellHeight, this.cellHeight),
                    // if getRowHeight() is implemented on this.grid, use it's result -
                    // othwerwise, use the maxCellHeight
                    h = this.grid && this.grid.getRowHeight ?
                            this.grid.getRowHeight(record, rowNum) : maxCellHeight
                ;
                isc._fillNumber(spacerDivTemplate, (details.requiredHeight - h), 2, 5, false);
                value = spacerDivTemplate.join(isc.emptyString);

                //isc.logWarn("In _getCellValue:  details are "+isc.echoAll(details));
            }
        } else if (details.requiredHeight > 0) {
            spacerDivTemplate[0] = value;
            isc._fillNumber(spacerDivTemplate, details.requiredHeight, 2, 5, false);
            value = spacerDivTemplate.join(isc.emptyString);

            //isc.logWarn("In _getCellValue:  details are "+isc.echoAll(details));
        }

    // write embedded components right into cells if printing...
    } else if (record && this.grid && this.grid._hasEmbeddedComponents(record)) {
        var colNumOffset = 0,
            frozenColNumOffset = 0;
        if (isPrinting) {
            colNumOffset = this.grid._embeddedComponentColNumOffset;
            frozenColNumOffset = this.grid._frozenEmbeddedComponentColNumOffset;
        }
        var components = this.grid._getEmbeddedComponents(record);
        for (var i = 0, len = (components ? components.length : 0); i < len; ++i) {
            var component = components[i];
            if (component == null) continue;
            var currentColNum = component._currentColNum;
            if (isPrinting && currentColNum != null) {
                currentColNum += (component._wasFrozen ? frozenColNumOffset : colNumOffset);
            }
            if (currentColNum != colNum) {
                continue;
            }

            var isWithin = (component.embeddedPosition == this._$within);

            var cPrintHTML = component._gridBodyPrintHTML;
            if (cPrintHTML != null) {
                var nonemptyCPrintHTML = (cPrintHTML != isc.emptyString);
                if (isWithin && nonemptyCPrintHTML) {
                    cPrintHTML = this._$divStart + cPrintHTML + this._$divEnd;
                }
                if (value == this.emptyCellValue && nonemptyCPrintHTML) {
                    value = cPrintHTML;
                } else {
                    value += cPrintHTML;
                }
                // clean that property up as we go
                delete component._gridBodyPrintHTML;
            }
        }
    }

    return value;
},
_writeEmbeddedComponentSpacer : function (record) {
    return (record && this.grid && this.grid._hasEmbeddedComponents(record));
},

// disable all cell-value cacheing logic for now
neverCacheCellValues:true,



_cacheCellValue : function (value, record, rowNum, colNum) {

    if (this.neverCacheCellValues) return;

    if (rowNum == 0 && this.logIsInfoEnabled("cellValueCache")) {
        this.logInfo(
            "Cacheing cell value (for first row) "
                + (this.logIsDebugEnabled("cellValueCache") ? this.getStackTrace() : ""),
            "cellValueCache");
    }

    var undef;
    if (value === undef) value = this._undefMarker;
    else if (value === null) value = this._nullMarker;

    if (this._cachedCellValues == null) {
        this._cachedCellValues = [];
    }
    if (this._cachedCellValues[rowNum] == null) {
        this._cachedCellValues[rowNum] = [];
    }
    this._cachedCellValues[rowNum][colNum] = {value:value, record:record};
},


bypassCellValueCache:function (record,rowNum,colNum) {
    return this.isPrinting;
},
_getCachedCellValue : function (record, rowNum, colNum) {

    var cachedObject = (this._cachedCellValues
                        && this._cachedCellValues[rowNum]
                        && this._cachedCellValues[rowNum][colNum]);

    // Return {value:<value>} - this allows upstream code to detect the case where
    // we have cached a meaningful null/undef value for a cell
    if (cachedObject && cachedObject.record == record) {
        return cachedObject;
    }
    return null;
},
_clearCachedCellValue : function (rowNum, colNum) {
    if (this.logIsInfoEnabled("cellValueCache")) {
            this.logInfo(
                "Dropping cached cell value (for " + [rowNum,colNum] + ") "
                + (this.logIsDebugEnabled("cellValueCache") ? this.getStackTrace() : ""),
                "cellValueCache");
    }

    if (this._cachedCellValues && this._cachedCellValues[rowNum]) {
        this._cachedCellValues[rowNum][colNum] = null;
    }
},
_clearCellValueCache : function () {
    if (this.logIsInfoEnabled("cellValueCache")) {
            this.logInfo(
                "Dropping all cached cell values "
                + (this.logIsDebugEnabled("cellValueCache") ? this.getStackTrace() : ""),
                "cellValueCache");
    }
    delete this._cachedCellValues;
},

getCellValue : function (record, rowNum, colNum) {
    return this.emptyCellValue;
},

// Specifying Table Geometry
// --------------------------------------------------------------------------------------------


//>    @method gridRenderer.getTotalRows()
// Return the total number of rows in the grid.<br><br>
//
// NOTE: in order to create a valid grid, you must either provide a totalRows value or implement
// getTotalRows()
//
// @return (number)
// @see attr:totalRows
// @visibility external
//<
getTotalRows : function () {
    return this.totalRows;
},

// NOTE: this.fields and the GridRenderer
// fields are currently used for the following config:
// - column width
// - column header alignment
// - column cell alignment
// It may be more appropriate to handle the above via a getColumnWidth()/getAlign interface.

//> @method gridRenderer.setColumnWidth()
// Sets the width of a single column.
//
// @param colNum (number) the number of the column to resize
// @param newWidth (number) the new width
//
// @visibility external
//<
setColumnWidth : function (colNum, newWidth) {
    this.fields[colNum].width = this._fieldWidths[colNum] = newWidth;
    this._colWidthCSSText = null;
    this.markForRedraw("setColumnWidth");
},

//> @method gridRenderer.setColumnWidths()
//
// Sets the width of all columns in the grid.
//
// @param newWidths (Array) array of new widths - one for each column.
//
// @visibility external
//<
setColumnWidths : function (columnWidths) {
    var oldWidths = this._fieldWidths;

    // copy the widths so we aren't affected if the caller subsequently changes the array
    this._fieldWidths = columnWidths.duplicate();
    this._colWidthCSSText = null;

    if (oldWidths != null && columnWidths != null && oldWidths.length == columnWidths.length) {
        // same number of columns

        // widths unchanged means no need to redraw
        if (oldWidths == columnWidths) return;
        var changed = false;
        for (var i = 0; i < oldWidths.length; i++) {
            if (oldWidths[i] != columnWidths[i]) changed = true;
        }
        if (!changed) return;


        if (!this.fixedColumnWidths && !this.wrapCells && this.isDrawn() &&
            columnWidths.length == 1) {

                // NOTE: for the oldMinimum, we want the specified size as of the last time we
                // drew; in the meantime, resizes that did not cause a redraw may have changed
                // the logical column width
                var oldMinimum = this._colWidthAtDraw || oldWidths[0],
                    newMinimum = columnWidths[0],
                    renderedSize = this.getColumnSize(0);

                // If the drawn size was the old minimum, a change in minimum requires a
                // redraw: a lower minimum means the content might draw smaller, and a higher
                // minimum means it must draw larger.
                // If the drawn size is less than the new minimum, the column will have to
                // expand to that new minimum.
                // Therefore the drawn size will change unless the rendered size exceeded the
                // old minimum and exceeds or is equal to the new minimum.
                //this.logWarn("oldMinimum: " + oldMinimum + ", newMinimum: " + newMinimum +
                //             ", renderedSize: " + renderedSize);
                if ((oldMinimum == newMinimum) ||
                    (renderedSize > oldMinimum && renderedSize >= newMinimum)) {
                    return;
                }
        }
    }

    this.markForRedraw("setColumnWidths");
},

shouldRedrawOnResize : function (deltaX, deltaY, animating) {
    if (this.redrawOnResize != null) return this.redrawOnResize;

    // quick hack: if we are being resized in a Layout because some other member is animating
    // don't redraw until the animation completes, otherwise our redraw will make the animation
    // lurch.
    if (isc.isA.ListGrid(this.parentElement) &&
        isc.isA.Layout(this.parentElement.parentElement))
    {
        var siblings = this.parentElement.parentElement.getMembers();
        if (siblings && siblings.map("isAnimating").or()) return false;
    }

    // redraw if our new size reveals more rows or columns
    if (this._needRowRedraw() || this._needColumnRedraw()) return true;

    // if we're showing the empty message we need to redraw since we write a static width / height
    // into the empty message
    if (this.isEmpty()) return true;


    return false;
},


// string methods: getRowSpan

getRowHeight : function (record, rowNum) {
    var height = this.updateHeightForEmbeddedComponents(record, rowNum, this.cellHeight);
    return height;
},

updateHeightForEmbeddedComponents : function (record, rowNum, height) {

    if (record && this.grid && this.grid._hasEmbeddedComponents(record)) {
        var details = this.getMaxEmbeddedComponentHeight(record, rowNum);
        if (details.allWithin) {
            // all components are "within", use the max of the row height and the max comp height
            height = Math.max(height, details.requiredHeight);
            //this.logWarn("in updateHeightForEmbeddedComponents ("+this.grid+"): details are "+isc.echoAll(details)+"\nheight is "+height);
        } else {
            // some components are NOT "within" - add the max comp height to the row height
            height += details.requiredHeight;
            //this.logWarn("in updateHeightForEmbeddedComponents ("+this.grid+"): details are "+isc.echoAll(details)+"\nheight is "+height);
        }
    }
    return height;
},

getMaxEmbeddedComponentHeight : function (record, rowNum) {
    var components = this.grid._getEmbeddedComponents(record) || [],
        maxComponentHeight = 0,
        allWithin = true,
        isPrinting = this.isPrinting
    ;



    for (var i = 0; i < components.length; i++) {
        var component = components[i];

        if (!component) continue;
        // when printing, we write colspanning components into a separate row

        if (isPrinting) continue;

        // mark the component with the row it currently appears in
        if (rowNum != null) component._currentRowNum = rowNum;

        // see if the component has an embeddedPosition of "within" - if not all components have
        // this position, an extra spacer is created to show components below the normal values
        var isWithin = (component.embeddedPosition == this._$within);
        if (!isWithin) allWithin = false;

        // get the component's current drawn height
        var tempHeight = component.getVisibleHeight(),
            componentHeight = 0
        ;
        // if the component does not have "within" position, use its drawn height for comparison
        // otherwise, use the drawn height only if its larger than the natural rowHeight
        if (!isWithin) componentHeight = tempHeight;
        else if (tempHeight > this.cellHeight) componentHeight = tempHeight;

        // expand the row so that the component appears under the normal cells
        if (component._percent_height != null) {
            // the component has a percent height - this is a percentage of the cellHeight
            component.height = component._percent_height;
            componentHeight = this.cellHeight;
        }
        var origHeight = component.specifiedHeight;
        if (isWithin && origHeight && isc.isA.String(origHeight) && origHeight.contains("%")) {
            // if there was a specified height, and it was a percentage, assume cellHeight (by
            // comparing against zero)
            componentHeight = 0;
        }
        if (componentHeight > maxComponentHeight) {
            maxComponentHeight = componentHeight;
        }
    }

    return { allWithin: allWithin, requiredHeight: maxComponentHeight };
},

_getRowSpan : function (record, rowNum, colNum) {
    if (!this.allowRowSpanning || !this.getRowSpan) return 1;
    var span = this.getRowSpan(record, rowNum, colNum);
    return Math.min(span, this.getTotalRows() - rowNum);
},

//> @method gridRenderer.getCellStartRow()
// When using +link{getRowSpan,row spanning}, returns the row number where a row-spanning cell
// starts.
// <P>
// For example, if row 2 col 0 spans 3 cells, <code>getCellStartRow()</code> for row 2 col 0,
// row 3 col 0, row 4 col 0 will all return 2, because that's the row when spanning starts.
//
// @param rowNum (int) row number of cell for which the start row should be returned
// @param colNum (int) column number of cell for which the start row should be returned
// @return (int) row number where spanning starts
// @visibility external
//<
getCellStartRow : function (rowNum, colNum) {
    var field = this.fields[colNum];
    if (field == null) return null;

    var spans = field._rowSpans;

    // no spanning at/above this cell
    if (spans == null || spans[rowNum] == null) return rowNum;

    //this.logWarn("span at row/col: " + [rowNum, colNum] + " start row: " + spans[rowNum]);

    return spans[rowNum];
},

//> @method gridRenderer.getCellRowSpan()
// When using +link{getRowSpan,row spanning}, returns the number of cells spanned by the cell
// at the given coordinates.
// <P>
// If the passed coordinates are in the middle of a series of spanned cells, the row span of
// the spanning cell is returned.  For example, if row 2 col 0 spans 3 cells, calls to
// <code>getCellRowSpan()</code> for row 2 col 0, row 3 col 0, row 4 col 0 will all return 3.
// <P>
// This method returns row span information for the current rendered cells.  In contrast, if
// the grid is about to be redrawn, a call to <code>getRowSpan()</code> may return row span
// values for how the grid is about to be drawn.  Also, user-provided getRowSpan() functions
// are not required to operate properly when called outside of the grid rendering loop.
// <P>
// <b>Note:</b> This method is a utility method for developers - it is not called
// directly by the grid rendering path and therefore is not intended for override. To
// set up custom row-spanning behavior, override +link{getRowSpan()} instead.
//
// @param rowNum (int) row number of cell to return the row span for
// @param colNum (int) column number of cell to return the row span for
// @return (int) number of cells spanned by the cell that spans through these coordinates
// @visibility external
//<
getCellRowSpan : function (rowNum, colNum) {
    var spans = this.fields[colNum]._rowSpans;
    if (spans == null) return 1; // no spanning on this field

    var startRow = this.getCellStartRow(rowNum, colNum);

    // iterate down rows until we hit a different span start row
    var currentRow = rowNum + 1,
        // span extends at least from startRow to rowNum
        spannedCells = rowNum - startRow + 1;
    // see how much further this span extends
    while (currentRow <= this._lastDrawnRow &&
           spans[currentRow] == startRow)
    {
        currentRow++;
        spannedCells++;
    }
    return spannedCells;
},

// Embedded Components
// --------------------------------------------------------------------------------------------

// You can call addEmbeddedComponent to associate a component with a given record and row or cell
// The "position" attribute specifies how the component should appear
// - "expand" (the default): After being added, the component will appear "embedded" in the
//   row, beneath the row's data.
// - "within": The component will appear aligned with the top left edge of the row or cell (may use
//   snapTo to specify different edge to attach to). If percentage sizing is specified, component
//   will size to percentage of record.
//
// NOTE: embedded components are currently only supported for uses of the gridRenderer that
// return some record for each row.  We could associate components with row numbers, but in
// most uses an embedded component changes row number (eg ListGrid sort, TreeGrid
// expand/collapse), so we'd need the caller to tell us about rowNum changes.
//


// Method to actually attach a component to a record
_$within:"within",
_$expand:"expand",
_$cell:"cell",
addEmbeddedComponent : function (component, record, rowNum, colNum, position) {
    if (position == null) position = this._$expand;
    // if position is "expand", or fixedRowHeights is false (and the
    // embedded component height > specified row height) we may expand records.
    var mayChangeRowHeight = ((position == this._$expand) || !this.fixedRowHeights);

    // instantiate the component if it's passed as just properties
    if (!isc.isA.Canvas(component)) {
        component.autoDraw = false;

        var cons = isc.ClassFactory.getClass(component._constructor);
        if (cons == null) cons = isc.Canvas;

        component = cons.create(component);
    }

    var moveOnly = false;
    // if addEmbeddedComponent is called twice on the same comp, remove before embedding!
    if (this._embeddedComponents && this._embeddedComponents.contains(component)) {
        // already embedded at the right spot = a no op
        // Note:
        if (this.grid._hasEmbeddedComponents(record) && this.grid._getEmbeddedComponents(record).contains(component) &&
            component.embeddedPosition == position &&
            component._currentRowNum == rowNum && component._currentColNum == colNum)
        {
            return;
        }
        // we can avoid a redraw if
        // position is within, this.fixedRowHeights is true,
        // and position is unchanged
        // (and we're not dirty already)
        if (position == component.embeddedPosition && !mayChangeRowHeight) {
            moveOnly = !this.isDirty();
        }
        // third param to suppress clear / redraw - we'll take care of that
        this.removeEmbeddedComponent(component.embeddedRecord, component, true);

    } else if (!mayChangeRowHeight) {
        moveOnly = !this.isDirty();
    }

    // Make the record hang onto the component
    this.grid._addEmbeddedComponent(record, component);

    // add the component to the list of embedded components.
    if (this._embeddedComponents == null) this._embeddedComponents = [];
    this._embeddedComponents.add(component);

    component.embeddedPosition = position;
    component.embeddedRecord = record;

    // set up the current row / colNum passed in
    // note that if we redraw to render the embedded component these will be recalculated
    // anyway, but by setting up an initial currentColNum we ensure the component is
    // embedded in a cell rather than a row!
    component._currentRowNum = rowNum;
    component._currentColNum = colNum;
    // for frozen columns, mark the component with the id of the GridBody it's being stored in
    component._embedBody = this.getID();

    // if position == "within" we'll handle percentage sizing and snapTo ourselves
    // unexposed flag to disable standard snapTo / percent sizing logic

    if (position == this._$within) component.percentBox = "custom";

    // add it as a child (which will force a draw, and give us a size) - hide it first so it
    // doesn't appear and then get moved into place
    // temporarily suppress adjustOverflow while we do this so we don't show huge
    // scrollbars if the thing is sized to 100% wide or tall
    if (component.parentElement != this) {
        var wasSuppressingAO = this._suppressAdjustOverflow;
        this._suppressAdjustOverflow = true;
        component.hide();
        this.addChild(component);
        if (wasSuppressingAO == null) delete this._suppressAdjustOverflow;
    }

    this.observe(component, "resized", function (deltaX, deltaY) {
        this._handleEmbeddedComponentResize(component, deltaX, deltaY);
    });

    // don't redraw the component when the grid redraws, otherwise we'll be redrawing embedded
    // components continually during scrolling.  NOTE: it may be that this should be the
    // default for parents that have a mixture of content and children.
    component.__oldRedrawWithParent = component._redrawWithParent;
    component._redrawWithParent = false;

    // prevent bubbling of most mouse events while the component is embedded.  We still want
    // mouseWheel events to bubble or it feels like scrolling is broken when embeddedComponents
    // scroll under the mouse.  We prevent other events because otherwise,
    // cellClick, recordClick et al will fire while the component is embedded, which is usually
    // wrong.
    component._origBubbleMouseEvents = component.bubbleMouseEvents;
    if (!component.bubbleMouseEvents) {
        // prevent most mouse events from bubbling
        component.bubbleMouseEvents = ["mouseDown", "mouseUp", "click", "doubleClick", "contextClick"];
    }

    // If the component is going to expand the row we'll need a redraw
    // Also, if we don't know the rowNum / colNum for the record, this will get picked up at redraw
    // time
    // Otherwise we just move the canvas into place.
    if (moveOnly && (rowNum == -1 || colNum == -1)) {
        moveOnly = false;
    }
    if (moveOnly) {
        this.placeEmbeddedComponent(component);
    } else {
        // redraw, which will draw the row at the new height and place the component
        this.markForRedraw("added embedded component");
    }
    return component;
},

_handleEmbeddedComponentResize : function (component, deltaX, deltaY) {
    var position = component.embeddedPosition;



    // if the embedded component resizes vertically, redraw so the row becomes the right size
    if (position != this._$within) {
        if (deltaY!=null && deltaY!=0) this.markForRedraw('embedded component resized');

    // If positioned within the cell, respond to resized (EG adjustOverlow) by
    // repositioning so snapTo continues to work...
    } else {
        this.placeEmbeddedComponent(component);
    }

},

// updateEmbeddedComponentCoords() called when we render out a record with an embedded component
// rowNum / colNum indicate the rowNum/colNum on which the record has been rendered
// (colNum is ambiguous on 1 record/row model)
// Default behavior leaves colNum untouched. Note that if we have one record per cell we might
// want to update colNum here, but we don't know that about our data model - rely on overrides
// to achieve this if required.
updateEmbeddedComponentCoords : function (components, record, rowNum, colNum) {
    components.setProperty("_currentRowNum", rowNum);
},

// place an embedded component over the correct row.
// Ideally this would only be called on sort, dataChanged, etc -- currently being called
// on every body redraw (may impact performance when incremental scrolling, for example)
placeEmbeddedComponent : function (component) {
    var rowNum = component._currentRowNum;
    if (rowNum == null || (this._firstDrawnRow == null || this._lastDrawnRow == null)
                    || (rowNum < this._firstDrawnRow || rowNum > this._lastDrawnRow))
    {
        // row is no longer drawn - clear component

        if (component.isDrawn()) component.clear();
        return;
    }

    if (!component.removeOnHideField &&
            component._currentFieldName && !this.grid.getField(component._currentFieldName))
    {
        // if we're trying to place a component that's attached to a field which is not visible,
        // eg. following a call to grid.hideField(), clear the component
        if (component.isDrawn()) component.clear();
        return;
    }

    // Note: If we're not fitting to a specific col, and we're showing
    // horizontal scrollbars,  we could fit to the viewport or
    // fit to the content (span the entire grid).
    // We'll fit to the viewport - standard usage in this case is a kind of
    // floating sub-component that we want to be visible for interactions.

    var record = component.embeddedRecord,
        position = component.embeddedPosition,
        colNum = component._currentColNum,
        topOrigin = this.getRowTop(rowNum),
        leftOrigin = (colNum != null && colNum >= 0) ? this.getColumnLeft(colNum) : null,
        // to make component snap to right of visible area, use getInnerWidth() to demarcate
        // the snap area, or the sum of all column widths, whichever is smaller
        width = (colNum != null && colNum >= 0) ? this.getColumnWidth(colNum) :
                            Math.min(this.getInnerWidth(), this._fieldWidths.sum()) ;
    if (leftOrigin == null) {
        if (!this.isRTL()) {
            leftOrigin = this.getScrollLeft();
        } else {
            // _shiftScrollLeftOrigin will give us back the scroll position adjusted
            // to the child abs-coord space - so hard left becomes a negative value and
            // hard right becomes zero.
            leftOrigin = this._shiftScrollLeftOrigin(this.getScrollLeft(), true);
        }
    }

//        this.logWarn("Placing embedded component " + component + ", row/col:" + [rowNum,colNum]
//                + ", top/left cell origin:" + [topOrigin,leftOrigin] + ", position:" + position,
//                "embeddedComponents");
    if (position == this._$within) {
        // Respect "snapTo" if specified
        // *Note: we are suppressing standard canvas percent sizing and snap-to behavior
        // so we can explicitly size / position based on cell coordinates
        var snapTo = this.getEmbeddedComponentSnapTo(component, record, rowNum, colNum),
            snapEdge = component.snapEdge || snapTo;

        // figure out sizes before placing!
        var height;
        if (this.allowRowSpanning && this.getRowSpan) {
            // Assume this method only runs for actual rendered rows (so if there's
            // a span, we're the first spanned cell.
            // If colNum is null we're looking at a per-row component - just size
            // to fit the left-most column
            var span = this.getRowSpan(record, rowNum, colNum==null ? 0 : colNum);
            if (span == null) span = 1;
            height = 0;
            for (var i = 0; i < span; i++) {
                height += this.getRowSize(rowNum + i);
            }
        } else {
            height = this.getRowSize(rowNum);
        }
        var cpw = component._percent_width,
            cph = component._percent_height,
            cw, ch;
        if (this.grid._hasEmbeddedComponents(record)) {
            // for "within" components we want the "bottom" to be the bottom of the row
            // content only -- IE we don't want to center over the row as expanded to
            // accomodate "expand" type components.
            // Adjust the size to account for this
            var expandedComponentDelta = 0,
                components = this.grid._getEmbeddedComponents(record);
            for (var i = 0; i< components.length; i++) {
                var expComponent = components[i];

                if (expComponent == null) continue;
                var isWithin = (expComponent.embeddedPosition == this._$within);
                if (isWithin) continue;
                var componentHeight = expComponent.getVisibleHeight();
                if (componentHeight > expandedComponentDelta) {
                    expandedComponentDelta = componentHeight;
                }
            }
            height -= expandedComponentDelta;
        }

        // If positioned offset from the left, shrink the target space
        if (component.snapOffsetLeft) width -= component.snapOffsetLeft;

        if (isc.isA.String(cpw) && cpw.endsWith("%")) {
            cw = Math.round((parseInt(cpw) * width) / 100);
        }
        if (isc.isA.String(cph) && cph.endsWith("%")) {
            ch = Math.round((parseInt(cph) * height) / 100);
        }
        if (ch || cw) {
            component.resizeTo(cw, ch);
             // retain percentages so we reflow correctly!
            component._percent_width = cpw;
            component._percent_height = cph;
        }
        // pass row/column dimensions to snapToEdge in lieu of a canvas
        isc.Canvas.snapToEdge([leftOrigin, topOrigin, width, height], snapTo, component, snapEdge);

    } else {
        // NOTE: if you need multiple "expand" components to expand a single row, generally
        // you're expected to use a Stack or Layout to manage them.

        // float at the bottom of the row, rather than the top

        //topOrigin += this.cellHeight;
        component.moveTo(leftOrigin, topOrigin);

        // Percent specified height on an "expand" component is unusual.
        // If encountered, treat as a percentage of standard cell-height
        var cw, ch,
            cph = component._percent_height;
        if (isc.isA.String(cph) && cph.endsWith("%")) {
            ch = Math.round((parseInt(cph) * this.cellHeight) / 100);
        }



        // Note that resizing horizontally (only) may still
        // adjust the visibleHeight of the component due to overflow
        cw = width;


        var cpw = component._percent_width,
            cph = component._percent_height
        ;
        component.resizeTo(cw, ch);
        component._percent_width  = cpw;
        component._percent_height = cph;
    }

    var showing = this.isDrawn();
    if (showing && !component.isDrawn()) component.draw();

    // at this point we can measure the component to see if it forces vertical expansion of the
    // row
    // Note that the row's height as written into the dom is set via getRowHeight() which already
    // checks the 'visibleHeight' of all embedded components, so the cases we're catching here are
    // if the visibleHeight was misreported before this method ran.
    // We've seen this happen when the component overflows its specified size, specifically:
    //  - if the setWidth() call above caused an already drawn component to reflow and overflow
    //    vertically in a different manner
    //  - if the component was scrolled out of view and clear()'d [cleared components return
    //    specified height from adjustOverflow], and scrolling back into view is draw()ing it again.
    //
    // Note: We observe the 'resized' method of the embedded component, so when resizing due
    // to the component size changing (such as adjustOverflow from the setWidth call above)
    // we get a markForRedrawCall() which in turn runs '_placeEmbeddedComponents()' and resizes/
    // repositions all embedded components.


    // If we're currently in the process of redrawing however, we'll be marked as dirty so this
    // if resized trips here in response to the above setWidth or draw(), markForRedraw will have
    // no effect - catch this case (via an isDirty() check) and explicitly size the
    // row to the new desired height.
    // NOTE: when we redraw we run through '_placeEmbeddedComponents' which positions/sizes
    // all embedded components. We do this in rowNum order, so if there are subsequent embedded
    // components rendered into the grid these should get shifted down automatically if a row
    // above them is expanded by this method.


//    if (position != this._$within) {
        var redrawing = this.isDirty(),
            expectedRowHeight = this.getRowHeight(record,rowNum,this._isFrozenBody()),
            // we need to size the row if
            // - the resized observation didn't trip and mark us as dirty
            // - we are already mid-redraw so being marked as dirty had no effect

            needsResize = !this.isDirty() || redrawing;

        if (needsResize && (expectedRowHeight != this.getRowSize(rowNum))) {
            this.setRowHeight(rowNum, expectedRowHeight, record);
            // refreshing the content ensures we re-write the spacer, which causes the
            // content to top-align properly
            this.refreshRow(rowNum);
        }
//    }

    if (showing) {
        if (position != this._$within) {
            var offset = this.getDrawnRowHeight(rowNum) - component.getVisibleHeight() - 1;
            component.moveTo(null, this.getRowTop(rowNum) + offset);
        }
        if (!component.isVisible()) {
            if (this.shouldAnimateEmbeddedComponent(component)) {
                component.animateShow();
            } else {
                component.show();
            }
        }
    }

    this.updateEmbeddedComponentZIndex(component);

},


alignSnapToMap:{
    left:{
        top:"TL",
        center:"L",
        bottom:"BL"
    },
    right:{
        top:"TR",
        center:"R",
        bottom:"BR"
    },
    center:{
        top:"T",
        center:"C",
        bottom:"B"
    }
},


getEmbeddedComponentSnapTo : function (component, record, rowNum, colNum) {
    if (component.snapTo != null) return component.snapTo;
    if (colNum == null) {
        return "TL"
    }

    var align = this.getCellAlign(record, this.fields[colNum], rowNum, colNum) || "center",
        valign = this.getCellVAlign(record, this.fields[colNum], rowNum, colNum) || "center";

    var result = this.alignSnapToMap[align][valign];
    //this.logWarn("result:"+ result);
    return result;
},

// should this embeddedComponent animate show?
shouldAnimateEmbeddedComponent : function (component) {
    return false;
},

// update the zindex of embedded components. Overridden at the LG level by default
updateEmbeddedComponentZIndex : function (component) {
},

getEmbeddedComponent : function (record, colNum) {
    // support specifying rowNum instead

    if (isc.isA.Number(record)) record = this.getCellRecord(record, 0);

    var components = this.grid._getEmbeddedComponents(record);
    if (components == null) return;

    var component = null;

    if (isc.isA.Number(colNum))
        component = components.find({_currentColNum: colNum, _embedBody: this.getID()});
    else
        component = components.find({_embedBody: this.getID()});

    return component;
},

removeEmbeddedComponent : function (record, component, suppressRedraw) {
    // support specifying rowNum instead

    if (isc.isA.Number(record)) record = this.getCellRecord(record, 0);

    var components = this.grid._getEmbeddedComponents(record);
    if (components == null) return;

    // support specifying component by colNum
    if (isc.isA.Number(component))
        component = components.find({_currentColNum: component, _embedBody: this.getID()});

    if (!component) // a single expansion component
        component = components.find({ _embedBody: this.getID() });

    if (!components.contains(component)) return;

    if (this.isObserving(component, "resized")) {
        this.ignore(component, "resized"); // stop watching for resizes
    }
    this.grid._removeEmbeddedComponent(record, component);
    //if (this.grid._getEmbeddedComponents(record).length == 0) this.grid._setEmbeddedComponents(record, null);
    if (this._embeddedComponents) this._embeddedComponents.remove(component);

    // reset redraw w/parent flag to original setting
    component._redrawWithParent = component.__oldRedrawWithParent;
    component.__oldRedrawWithParent = null;

    // reset bubbleMouseEvents setting
    component.bubbleMouseEvents = component._origBubbleMouseEvents;

    var expand = component.embeddedPosition == this._$expand;
    component.embeddedPosition = null;
    component._currentRowNum = null;
    component._currentColNum = null;
    component._embedBody = null;

    // suppress redraw - used when an embedded component is just being shifted to another record
    if (suppressRedraw) {
        // hide even if we don't clear/draw -- this ensures we re-animate if appropriate
        component.hide();
        return;
    }

    if (component.isExpansionComponent && this.grid.expansionComponentPoolingMode != "none") {
        // this is an expansionLayout - the first (only) member is an expansionComponent
        var exComp = component.members[0];
        if (this.grid.expansionComponentPoolingMode == "destroy") {
            // "destroy" pooling mode
            if (!exComp.isStockComponent) {
                // custom component - remove the custom component from the wrapper layout prior
                // to destroying the layout - don't destroy the custom component,
                // unless grid.destroyCustomExpansionComponents or comp.destroyOnUnembed
                // have been set to true
                if (!this.grid.destroyCustomExpansionComponents && !exComp.destroyOnUnembed) {
                    component.removeMember(exComp);
                    exComp.deparent();
                }
            }
            component.destroy();
        }
    } else {
        if (component.dontAutoDestroy) {
            this.removeChild(component);
        } else if (component.destroyOnUnEmbed) {
            component.destroy();
        } else {
            // clear it and clear up references to the record
            this.removeChild(component);
        }
    }

    // no need to redraw if the component didn't effect the size of any content
    if (expand) {
        this.markForRedraw("removed embedded component");
    }

},

// before each redraw, clear the property holding the rowNum where the component was found.  Hence
// we ensure that if a component isn't found during rendering it gets hidden.
// Leave the colNum intact -
_resetEmbeddedComponents : function () {
    var components = this._embeddedComponents;
    if (components == null) return;
    components.setProperty("_currentRowNum", null);
},

// ensure all embedded components are in the right place.  Called after every redraw.
_placeEmbeddedComponents : function () {
    var components = this._embeddedComponents;
    if (components == null) return;
    // sort by current row num. This means we place the components in the order in which they're
    // drawn within the table. If their heights change and they expand their containing rows, they
    // will therefore also change the top coords of subsequent rows
    components.sortByProperty("_currentRowNum", true);
    for (var i = 0; i < components.length; i++) {
        this.placeEmbeddedComponent(components[i]);
    }
},

// Apply a known z-index to the table so we can float embedded components below it if necessary
getTableZIndex : function () {
    // default Canvas range starts around 200000
    // Give the table a zindex of 1000 - widgets will still float above it by default (even when
    // sendToBack() is called), but we can explicitly force them to appear below it if necessary
    return 1000;
},

// Cell Styling
// --------------------------------------------------------------------------------------------



//> @attr   gridRenderer.recordCustomStyleProperty  ( "customStyle" : string : IRW)
// Denotes the name of a property that can be set on records to display a custom style.
// For example if this property is set to <code>"customStyle"</code>, setting
// <code>record.customStyle</code> to a css styleName will cause the record in question to
// render out with that styling applied to it.  Note that this will be a static
// style - it will not be modified as the state of the record (selected / over etc) changes.
// @see gridRenderer.getCellStyle()
// @visibility external
//<
recordCustomStyleProperty:"customStyle",

//> @attr gridRenderer.showSelectedStyle ( boolean : true : IRW )
// Should the "Selected" style be applied to selected records?
// @see gridRenderer.getCellStyle()
// @visibility external
//<
showSelectedStyle:true,

//> @groupDef cellStyleSuffixes
// As with +link{StatefulCanvas.getStateSuffix,stateful canvases}, grid cells support being
// styled to reflect the current state of the cell by generating a css styleName from the
// specified +link{listGrid.baseStyle,baseStyle}, plus stateful suffixes.
// <P>
//
// There are four independent boolean states, which are combined in the order given:
// <ol>
// <li>"Disabled" : whether the cell is disabled; enable by setting the "enabled" flag on record
//     returned by getCellRecord
// <li>"Selected" : whether cell is selected; enable by passing a Selection object as "selection"
// <li>"Over" : mouse is over this cell; enable with showRollovers
// <li>"Dark" : alternating color bands; enable with alternateRowStyles
// </ol>
// This leads to the following set of standard style names:
// <table border=1>
// <tr><td><b>CSS Class Applied</b></td><td><b>Description</b></td><td><b>Example</b></td></tr>
// <tr><td><code><i>baseStyle</i></code></td><td>Default css style for the cell</td>
//     <td><code>cell</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Dark</code></td>
//      <td>Suffix for alternating color bands when +link{gridRenderer.alternateRowStyles, alternateRowStyles} is true</td>
//     <td><code>cellDark</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Disabled</code></td>
//      <td>Whether the cell is disabled; enable by setting the "enabled" flag on record
//     returned by getCellRecord.</td>
//     <td><code>cellDisabled</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Selected</code></td>
//      <td>Whether the cell is +link{listGrid.getSelectedRecord(),selected}.
//      Only applies if +link{listGrid.showSelectedStyle} is true</td>
//     <td><code>cellSelected</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Over</code></td>
//      <td>Mouse is over this record. Only applies if +link{listGrid.showRollOver} is true</td>
//     <td><code>cellOver</code></td></tr>
// <tr><td colspan=2><i>Combined styles</i></td></tr>
// <tr><td><code><i>baseStyle</i>+Disabled+Dark</code></td>
//      <td>Disabled style applied to cells in alternate color bands.</td>
//     <td><code>cellDisabledDark</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Selected+Over</code></td>
//      <td>Style applied to selected cells as the mouse rolls over them.</td>
//     <td><code>cellSelectedOver</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Selected+Dark</code></td>
//      <td>Selected style applied to cells in alternate color bands.</td>
//     <td><code>cellSelectedDark</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Over+Dark</code></td>
//      <td>Style applied to alternate color band cells as the mouse rolls over them.</td>
//     <td><code>cellOverDark</code></td></tr>
// <tr><td><code><i>baseStyle</i>+Selected+Over+Dark</code></td>
//      <td>Style applied to selected, alternate color band cells as the mouse rolls over them.</td>
//     <td><code>cellSelectedOverDark</code></td></tr>
// </table>
//
// @visibility external
//<


//>    @method    gridRenderer.getCellStyle()
// Return the CSS class for a cell. By default this method has the following implementation:<br>
// - return any custom style for the record (+link{GridRenderer.recordCustomStyleProperty})
//   if defined.<br>
// - create a style name based on the result of +link{gridRenderer.getBaseStyle()} and the
//   state of the record using the rules described in +link{group:cellStyleSuffixes}.
// <p>
// Cell Styles are customizable by:
// <ul>
// <li>attaching a custom style to a record by setting
//    <code>record[this.recordCustomStyleProperty]</code> to some valid CSS style name.
// <li>modifying the base style returned by getBaseStyle() [see that method for further
//     documentation on this]
// <li>overriding this function
// </ul>
// <p>
// In addition to this, +link{gridRenderer.getCellCSSText,getCellCSSText()} may be overriden to
// provide custom cssText to apply on top of the styling attributes derived from the named
// style.
// <smartgwt><p>
// <b>Note: This is an override point.</b></smartgwt>
//
//        @param    record        (ListGridRecord)    record object for this row and column
//        @param    rowNum      (number)    number of the row
//        @param    colNum      (number)    number of the column
//
//        @return    (CSSStyleName)    CSS style for this cell
// @group    appearance
// @visibility external
//<
getCellStyle : function (record, rowNum, colNum) {
    // Allow a record to apply it's own style - ignoring our styling code
    if (record && record[this.recordCustomStyleProperty] != null) {
        return record[this.recordCustomStyleProperty];
    }

    // If not using an entirely custom style, determine the cell state and
    // get the appropriate suffix.
    var styleIndex = this.getCellStyleIndex(record, rowNum, colNum);

    return this.getCellStyleName(styleIndex, record, rowNum, colNum);
},


getCellStyleName : function (styleIndex, record, rowNum, colNum) {

    var standardSuffixes = isc.GridRenderer.standardStyleSuffixes;

    // Are we dynamically determining the baseStyle from this.getBaseStyle() ?
    // If so, concat baseStyle with the appropriate suffix
    if (this.getBaseStyle) {

        var baseStyle = this.getBaseStyle(record, rowNum, colNum);
        // check if the baseStyle returned is exactly the same String instance as
        // this.baseStyle, in which case we can use the precomputed style combinations.  This
        // would happen if someone defined a custom getBaseStyle that usually returns
        // this.baseStyle, infrequently returning special values.
        if (baseStyle !== this.baseStyle) {

            // append the appropriate suffix to the baseStyle
            if (styleIndex == 0) return baseStyle; // styleIndex 0 is the empty suffix
            return baseStyle + standardSuffixes[styleIndex];
        }
    }

    // In this case we're using the default baseStyle

    // Cache the entire set of cellStyles
    if (!this._cellStyles) {
        this._cellStyles = [];
        for (var i = 0; i < standardSuffixes.length; i++) {
            this._cellStyles[i] = this.baseStyle + standardSuffixes[i];
        }
    }
    // return the style
    return this._cellStyles[styleIndex];
},

// return the index of the current state.  The index is a bitfield containing flags for each of
// the mutually exclusive style states: Over, Selected, Disabled, and Dark (Ledger).  The
// purpose of computing an index rather than computing the string directly is for speed.
getCellStyleIndex : function (record, rowNum, colNum) {

    // Note - we have an array of the 12 applicable suffixes in gridRenderer.standardSuffixes
    //
    // 0 = baseStyle
    // 1 = Over(1)
    // 2 = Selected(2)
    // 3 = Selected(2) + Over(1)
    // 4 = Disabled(4)
    // 5 = Disabled(4) + Over(1)
    // 6 = Disabled(4) + Selected(2)
    // 7 = Disabled(4) + Selected(2) + Over(1)
    // 8 = Dark(8)
    // 9 = Dark(8) + Over(1)
    // 10 = Dark(8) + Selected(2)
    // 11 = Dark(8) + Selected(2) + Over(1)
    // 12 = Dark(8) + Disabled(4)
    //
    // NOTE: By default, disabled is actually mutually exclusive with Selected and Over states,
    // so states 5-7 never happen and no style declaration is required.

    var styleIndex = 0;     // base style

    var useAlternateStyle = true;
    if (this.grid != null) {
        var field = this.grid.getField(this.grid.getFieldNumFromLocal(colNum, this));
        useAlternateStyle = !field ? true : field.showAlternateStyle != false;
    }

    // if alternating record or column styles, see if the cell is in a dark band
    if (useAlternateStyle) {
        var isOdd = false;
        if (this.alternateRowStyles) {
            if (this.useRowSpanStyling) {
                // rowSpan-sensitive styling: style based on "rows" determined by spans of
                // left-most cell.  So if first two left-most DOM cells span 4 and 6 rows, first 4
                // rows will be normal, next 6 dark.
                var spanRowNum = this.getSpanningRowNum(rowNum);
                isOdd = (Math.floor(spanRowNum / this.alternateRowFrequency) % 2 == 1);
                if (isOdd) styleIndex += 8;
            } else {
                isOdd = (Math.floor(rowNum / this.alternateRowFrequency) % 2 == 1);
                if (isOdd) styleIndex += 8;
            }
        }
        // if alternating column styles, see if the cell is in a dark band
        if (this.alternateColumnStyles && !isOdd) {
            isOdd = (Math.floor(colNum / this.alternateColumnFrequency) % 2 == 1);
            if (isOdd) styleIndex += 8;
        }
    }

    // Disabled?
    if (!this.cellIsEnabled(rowNum, colNum, record)) {
        styleIndex += 4;

    // Not disabled - check for selected and/or over
    } else {

        // if we're over the row or cell - add 1 to get the Over style

        if (this.shouldShowRollOver(rowNum, colNum) && !this.isPrinting &&
            rowNum == this.lastOverRow &&
            (!this.useCellRollOvers || colNum == this.lastOverCol))
        {
            styleIndex += 1;
        }

        // if selection is enabled, see if the cell is selected
        if (this.showSelectedStyle && this.selectionEnabled()) {
            var isSelected;
            if (this.canSelectCells) {
                var startRow = rowNum;
                if (this.useRowSpanStyling) startRow = this.getCellStartRow(rowNum, colNum);
                isSelected = this.selection.cellIsSelected(startRow, colNum);
            } else {
                isSelected = this.selection.isSelected(record, true);
            }
            // if the cell is selected, add 2 to get the Selected style
            if (isSelected) styleIndex += 2;
        }
    }
    return styleIndex;
},

// when rowSpanning is being used, returns the visual rowNum: the rowNum if the left-most
// column's cells are treated as row boundaries
getSpanningRowNum : function (rowNum) {
    var outerSpanCount = this._outerSpanCount;
    // if we are part of a ListGrid with frozen columns, the first column is in the frozen
    // body
    if (this.grid && this.grid.frozenBody) {
        var outerSpanCount = this.grid.frozenBody._outerSpanCount;
    }
    // TODO: support incremental rendering: go back to last non-empty entry before the
    // requested rowNum, call getRowSpan() for all intervening rows and record results.

    return outerSpanCount != null ? outerSpanCount[rowNum] : rowNum;
},

//>    @method    gridRenderer.cellIsEnabled()    ([A])
// Whether this cell should be considered enabled.  Affects whether events will fire for the
// cell, and the default styling behavior in getCellStyle.
//
// @group    selection, appearance
//
// @param    rowNum    (number)    row number for the cell
// @param    colNum    (number)    column number of the cell
// @return    (boolean)    whether this record is enabled or not
// @visibility external
//<

cellIsEnabled : function (rowNum, colNum, record) { return true; },

// Element IDs
// --------------------------------------------------------------------------------------------

//> @method gridRenderer.getTableElementId()  ([A])
// Get the DOM ID that should be used for the table element.  For integration with legacy test
// scripts.
// @visibility testAutomation
//<
getTableElementId : function () {
    return this.getCanvasName() + "table";
},

//> @method gridRenderer.getRowElementId()  ([A])
// Get the DOM ID that should be used for a row element.  For integration with legacy test
// scripts.
//
// When using incremental rendering, the <code>rowNum</code> param represents the
// rowNum in virtual coordinates, and the <code>physicalRowNum</code> param represents the
// index that the row will ultimately have in table.rows.
//
// @param    rowNum  (number)          <b>virtual</b> row number
// @param    physicalRowNum (number)   <b>physical</b> row number
// @visibility testAutomation
//<


//> @method gridRenderer.getCellElementId()  ([A])
// Get the DOM ID that should be used for a cell element.  For integration with legacy test
// scripts.
//
// When using incremental rendering, the <code>rowNum</code> and <code>colNum</code> params
// represents virtual coordinates, and the <code>physicalRowNum</code> param represents the
// index that the row/cell will ultimately have in table.rows or row.cells.
//
// @param    rowNum         (number)   <b>virtual</b> row number
// @param    physicalRowNum (number)   <b>physical</b> row number
// @param    colNum         (number)   <b>virtual</b> col number
// @param    physicalColNum (number)   <b>physical</b> col number
// @visibility testAutomation
//<

// Table Manipulation
// --------------------------------------------------------------------------------------------

getDOMTable : function (logicalRowNum, logicalColNum) {
    if (this.cacheDOM) return this.getTableChunkAt(logicalRowNum, logicalColNum);

    // bail out fast if asked for a cell that isn't currently rendered
    // this method is called from 'getTableElement()', so rowNum / colNum may be null
    if ((logicalRowNum != null &&
         (logicalRowNum - this._firstDrawnRow < 0 ||
          logicalRowNum > this._lastDrawnRow))
        ||
        (logicalColNum != null &&
         (logicalColNum - this._firstDrawnCol < 0 ||
          logicalColNum > this._lastDrawnCol))
       )
         return null;

    var table = this._tableElement;
    if (table == null) {
        var tableName = this.getTableElementId();
        var table = isc.Element.get(tableName);

        if (table == null) return null;
        // If we're mid-redraw, don't re-cache the current table element
        if (this._suppressTableCaching) {

            this.logInfo("getTableElement() called while updating table HTML. " +
                "This call may be invalid as the table is being rewritten in the DOM. " +
                "Suppressing caching of the current element.", "redrawing");
            return table;
        }
    }
    // cache table element
    return this._tableElement = table;
},

//>    @method    gridRenderer.getTableElement()    ([A])
//        Get the element for the TD that holds a particular cell, specified as row/column indices.
//
//        If called with no parameters, returns the table itself.
//        If called with rowNum only, returns the row element
//        If called with colNum, returns a particular cell.
//
//        In all cases, returns null if the table, row, or cell cannot be found.
//
//        NOTE: calling this repeatedly is expensive as it makes multiple DOM lookups.
//
//        @param    [rowNum]    (number)    Record number to get cell for.
//                                        You DO NOT need subtract the startRow from this.
//        @param    [colNum]    (number)    Field number to get cell for.
//        @return    (DOMElement)            Table, row or cell of the list body table.
//                                        Returns null if the element can't be obtained.
//        @group    drawing
//<

getTableElement : function (logicalRowNum, logicalColNum) {
    var table = this.getDOMTable(logicalRowNum, logicalColNum);

    if (logicalRowNum == null) return table;

    if (!table) return null;

    // if we're using incremental rendering, the HTML we draw only contains _firstDrawnRow ->
    // _lastDrawnRow, so when asked for row X we subtract _firstDrawnRow to find the
    // corresponding DOM element.  "rowNum" is now the rendered row number in the DOM table
    var rowNum = logicalRowNum - (this._firstDrawnRow > 0 ? this._firstDrawnRow : 0);


    if (rowNum < 0) {
        //this.logWarn("bailing on negative rowNum");
        return null;
    }

    var row;
    // use cached row lookup
    if (this._rowElements != null) row = this._rowElements[rowNum];
    if (row == null) row = table.rows[rowNum];


    if (row == null) return null;

    // cache row lookup (invalidated on body redraw)
    // If we're mid-redraw, don't re-cache the current table element
    if (!this._suppressTableCaching) {
        if (this._rowElements == null) this._rowElements = [];
        this._rowElements[rowNum] = row;
    }

    if (logicalColNum == null) return row;

    // for incremental column rendering: if we're not drawing all columns, the DOM will contain
    // cells only for the columns we actually draw.
    var colNum = logicalColNum - this._firstDrawnCol;


    if (colNum < 0) {
        //this.logWarn("bailing on negative colNum");
        return null;
    }


    if (this.allowRowSpanning && this.getRowSpan) {

        var startRow = this.getCellStartRow(logicalRowNum, colNum);
        if (startRow != rowNum) {
            //this.logWarn("detected spanning cell extending from " + [startRow, colNum] +
            //             " to " + [logicalRowNum, colNum]);

            // cell starts in a previous row - switch to the row that contains this cell
            rowNum = startRow;
            row = this.getTableElement(startRow);
        }

        if (row.childNodes.length < (this._lastDrawnCol - this._firstDrawnCol + 1)) {
            // this row has less cells than the number of columns we drew, indicating cells from
            // previous rows spanned into this row (but not at this column, which we already
            // checked).

            // figure out many cells are missing up to the column we're interested in
            var skips = 0;
            for (var i = 0; i < colNum; i++) {
                if (this.fields[i]._rowSpans != null &&
                    this.fields[i]._rowSpans[rowNum] != null &&
                    this.fields[i]._rowSpans[rowNum] != rowNum) skips++;
            }
            //this.logWarn("in row: " + rowNum + " skipping " + skips + " cells");

            // and adjust the column number appropriately
            colNum -= skips;
        }
    }

    // actually got all the way to the cell level -- return the appropriate cell
    return row.childNodes[colNum];
},

// Cell Style and HTML Updates
// --------------------------------------------------------------------------------------------

//>    @method    gridRenderer._updateCellStyle()
// Update the CSS styling for a cell.  Will also update the row's height, and the cell's
// innerHTML if appropriate.
//
//        @group    appearance
//        @param    [record]        (object)    reference to the record object who's style is being set
//        @param    rowNum          (number)    row number of the cell
//      @param  colNum          (number)    col number of the cell
//        @param    cell            (DHTML object)    reference to the HTML table cell element
//      @param  [className]     (string)    name of the CSS class of the style to be used
//
//<
_updateCellStyle : function (record, rowNum, colNum, cell, className) {

    // get the DOM cell object if not provided
    if (cell == null) cell = this.getTableElement(rowNum, colNum);
    if (cell == null) return; // cell not currently drawn

    if (record == null) record = this.getCellRecord(rowNum, colNum);
    // determine the CSS style className if not provided
    if (className == null) className = this.getCellStyle(record, rowNum, colNum);

//this.logWarn("setting: " + [rowNum, colNum] + " to className:" + className);

    if (this.fastCellUpdates) {

        cell.style.cssText = this._getCompleteCellCSSText(record, rowNum, colNum, className);
    } else {
        // update the classname on the DOM cell object
        if (cell.className != className) cell.className = className;
        // If this.getCellCSSText has been defined, set cell.style.cssText

        if (this.getCellCSSText) {
            // Use this._getCompleteCellCSSText
            // This handles the overflow settings for Moz, converting the
            // getCellCSSText stringMethod to a method, etc.
            cell.style.cssText = this._getCompleteCellCSSText(record, rowNum, colNum, className)
        }
    }
    // if aspects of styling are incorporated into the cell's innerHTML, refresh the cell
    if (this.shouldRefreshCellHTML(record, rowNum, colNum)) {
        this.refreshCellValue(rowNum, colNum);
    }


    if (!this.isDrawn()) return;

    if (!this.suppressRowHeightUpdate) this._updateRowHeight(record, rowNum, className);
},

_updateRowHeight : function (record, rowNum, className) {

    var shouldClip = this.fixedRowHeights &&
                          (this.shouldFixRowHeight == null ||
                           this.shouldFixRowHeight(record, rowNum) != false),
        newHeight = (this.getRowHeight != null ? this.getRowHeight(record, rowNum, this._isFrozenBody())
                                                  : this.cellHeight);

    this.setRowHeight(rowNum, newHeight, record, className, shouldClip);

},

_$nobr:"NOBR",
_$cellClipDiv:"cellClipDiv",

_getCellClipDiv : function (cellElement) {
    if (cellElement == null) return null;

    var div = cellElement.firstChild;
    if (!div) return null;
    // In IE the first child of a cell is actually a NOBR element - we need to look inside that
    // to get the cell clip div
    if (div.tagName == this._$nobr) div = div.firstChild;
    if (div &&
        (div.cellClipDiv ||
         (div.getAttribute && div.getAttribute(this._$cellClipDiv)) ) )
    {
        return div;
    }
    return null;
},

//> @method gridRenderer.setRowHeight()
// Sets the height of some row to the height passed in.
// This is a styling effect only - a redraw will revert to the height as derived from
// this.cellHeight / this.getRowHeight()
// @param rowNum (number) rowNum to set height on
// @param newHeight (number) height for the row
//<
// Additional params are not required, but make the method more efficient
// Also used by showInlineEditor to make a row overflow:visible for tall editors
_$height:"height",
_$minHeight:"minHeight",
setRowHeight : function (rowNum, newHeight, record, className, shouldClip, instantOverflow) {
    var firstDrawnCol = this._firstDrawnCol,
        lastDrawnCol = this._lastDrawnCol;

    if (shouldClip == null) {
        if (record == null) record = this.getCellRecord(rowNum, firstDrawnCol);
        shouldClip = this.fixedRowHeights &&
                                          (this.shouldFixRowHeight == null ||
                                           this.shouldFixRowHeight(record, rowNum) != false);
    }


     var firstCell = this.getTableElement(rowNum, firstDrawnCol),
         currentSpecifiedHeight = firstCell ? parseInt(firstCell.height) : null,
         heightChanged
    ;

    if (!isc.isA.Number(currentSpecifiedHeight)) currentSpecifiedHeight = null;
    if (this._shouldSubtractVBorderPadFromRowHeight()) {
        if (record == null) record = this.getCellRecord(rowNum, firstDrawnCol);
        var cellStyle = className;
        if (cellStyle == null) cellStyle = this.getCellStyle(record, rowNum, firstDrawnCol)

        var vPad = isc.Element._getVBorderSize(cellStyle);

        if (!this.fixedRowHeights) vPad += this.cellPadding * 2;
        newHeight -= vPad;
    }

    // if we were previously clipping and will not any longer
    if ((!shouldClip && currentSpecifiedHeight != null) ||
        // or we're changing the specified height (clipped or not)
        (currentSpecifiedHeight != newHeight &&
        !(currentSpecifiedHeight == null && newHeight == isc.emptyString)))
    {
        // the height of the cell (therefore the row) has changed
        heightChanged = true;
    }
    // If the height of this row has changed, we need to update (or clear) the specified
    // heights of each cell in the row.

    if (!heightChanged) return;


    var numericHeight = isc.isA.Number(newHeight);
    if (numericHeight && newHeight <=0) newHeight = shouldClip ? 0 : 1;

//    this.logWarn("height changed for cell in row: " + rowNum +
//                 ", currentSpecifiedHeight: " + currentSpecifiedHeight +
//                 ", shouldClip?:" + shouldClip +
//                 " (derived from firstCell.height: " + firstCell.height + ")" +
//                 ", newHeight: " + newHeight);

    var currentRow = this.getTableElement(rowNum);
    // Don't crash if passed a bad row num

    if (currentRow == null) return;

    if (newHeight == 0 && shouldClip) {
        currentRow.style.display = "none";
        //var firstCell = this.getTableElement(rowNum, firstDrawnCol);
        //this.logWarn("first row height is: " + firstCell.offsetHeight);
    } else {
//TODO: when printing sub-grids, we can get crashes here because currentRow is null - needs a looksee
//   } else if (currentRow != null) {
        // should theoretically be "table-row", but IE doesn't currently support that value,
        // and they all seem to accept ""
        currentRow.style.display = isc.emptyString;

        var cssProp = (!isc.Browser.isIE || isc.Browser.isStrict) ? this._$height
                                                                  : this._$minHeight,
            cellHeight = numericHeight ? newHeight + isc.px : newHeight,
            clipDivHeight = shouldClip ? cellHeight : isc.emptyString;

        for (var i = firstDrawnCol; i <= lastDrawnCol; i++) {
            var currentCell = this.getTableElement(rowNum, i);
            if (currentCell) {
                if (shouldClip) {
                    currentCell.height = cellHeight;
                    currentCell.style[cssProp] = isc.emptyString;
                } else {
                    currentCell.height = isc.emptyString;
                    currentCell.style[cssProp] = cellHeight;
                }

                var clipDiv = this._getCellClipDiv(currentCell);
                if (clipDiv) {
                    if (this._useMaxHeightForCellDivCSSHeight()) {
                        clipDiv.style.maxHeight = clipDivHeight;
                    } else {
                        clipDiv.style.height = clipDivHeight ;
                    }
                }
            }
        }

    }


    if (isc.Browser.isSafari && this._forceRowRefreshForAnimation) {
        var row = this.getTableElement(rowNum);
        if (row != null) {
            row.innerHTML = row.innerHTML;
        }
    }

    // clear the cache of rowHeights since at least this one has changed, and mark for
    // adjustOverflow as the overall height of the body will have changed too.
    this._clearTableCache();

    if (instantOverflow) {
        this.adjustOverflow("cell height changed");
    } else {
        this._markForAdjustOverflow("cell height changed");
    }

},

//> @method gridRenderer._getCompleteCellCSSText() (I)
//
//  Returns complete CSS text for a cell.
//
//  If this.fastCellUpdates is true, this method will return both the raw CSS text associated
//  with the style, and any custom CSS text set up by the public getCellCSSText() method
//  If false, this method returns no style CSS text, and just falls through to getCellCSSText()
//
//        @param    record        (ListGridRecord)    record for this row or cell
//        @param    rowNum      (number)    row number
//        @param    colNum      (number)    column number
//      @param  [style]     (string)    CSS class style name to apply
//
//        @return    (CSSText)    CSS text to style this cell
//  @group    appearance
//<
_$semi:";",
_$zeroVPadding:"padding-top:0px;padding-bottom:0px;",
_$overflowHidden:"overflow:hidden;",
_getCompleteCellCSSText : function (record, rowNum, colNum, className) {
    var cssText = null;
    // Make sure top and bottom padding are set to zero if fixedRowHeights is true

    if (this.fixedRowHeights) cssText = this._$zeroVPadding;
    else {
        cssText = this._getMinHeightCSSText(record,rowNum);
    }

    if (isc.Browser.isIE8Strict) {
        if (cssText == null) cssText = this._$overflowHidden;
        else cssText += this._$overflowHidden;
    }

    // For Moz, pre-pend the width and overflow cssText

    if (isc.Browser.isMoz || isc.Browser.isSafari) {
        if (cssText == null) cssText = this._getCSSTextForColWidth(colNum);
        else cssText += this._getCSSTextForColWidth(colNum);
    }

    if (this.fastCellUpdates) {
        // figure out the style for this cell if not provided
        if (className == null) className = this.getCellStyle(record, rowNum, colNum);
        //this.logWarn("_getCompleteCellCSSText style: " + className);

        // get CSS text for this style
        var styleText = isc.Element.getStyleText(className, true);

        if (styleText == null && isc.Page._remoteStyling) {
            this.logInfo("fastCellUpdates set to true but this page loads styles from a " +
                "remote stylesheet. This is unsupported - disabling fastCellUpdates.");
            this.fastCellUpdates = false;
            this.redraw();
        }
        if (cssText != null) cssText += styleText;
        else cssText = styleText;
    }

    // Get any custom CSSText derived from this.getCellCSSText
    if (this.getCellCSSText) {
        var customCSSText = this.getCellCSSText(record, rowNum, colNum)

        if (customCSSText != null) {
            // Ensure the custom css text ends with a semi

            if (!customCSSText.endsWith(this._$semi)) {
                customCSSText += this._$semi;
            }
            if (cssText != null) cssText += customCSSText
            else cssText = customCSSText
        }
    }

    // If we skipped NOBR tags, write out the css equivalent.
    if (isc.Browser.isIE8Strict && !this.wrapCells) {
        cssText += ";white-space: nowrap;"
    }
    return cssText;
},

// does this cell need to update its HTML in order to show hiliting/styling
shouldRefreshCellHTML : function (record, rowNum, colNum) {
    return this.showHiliteInCells;
},


// Helper method to check that we can safely refresh a cell (or row) without delaying
_readyToRefreshCell : function (rowNum, colNum) {

    if ((isc.EH._handlingMouseUp || isc.EH._handlingMouseDown) && isc.EH.lastEvent.target == this) {

        var eventRow = this.getEventRow();
        if (eventRow != rowNum) return true;

        if (colNum != null) {
            var eventCol = this.getEventColumn();
            if (colNum != eventCol) return true;
        }
        // If the event occurred on the same row (and col for a cell), we can't redraw in
        // the same thread
        return false;
    }


    var EH = this.ns.EH;
    if (EH._handlingTouchEventSequence()) {
        var cellElem = this.getTableElement(rowNum, colNum);
        if (cellElem != null) {
            if (isc.Browser.isMobileWebkit || isc.Browser.isChrome) {
                var mouseDownEvent = EH.mouseDownEvent;
                if (mouseDownEvent != null &&
                    mouseDownEvent.DOMevent.target != null &&
                    cellElem.contains(mouseDownEvent.DOMevent.target))
                {
                    return false;
                }
            }
        }
    }

    return true;
},

//> @method gridRenderer.refreshCellValue() ([A])
// Update just cell value without updating cell styling.
// @param rowNum (number) Row number of the cell to refresh
// @param colNum (number) Column number of the cell to refresh
//<
refreshCellValue : function (rowNum, colNum) {
    // get a pointer to the cell, if possible
    var cell = this.getTableElement(rowNum, colNum);
    if (!cell) return; // cell not currently drawn

    // If we need to delay the refresh, fire again after a delay
    if (!this._readyToRefreshCell(rowNum, colNum)) {
        this.delayCall("refreshCellValue", [rowNum, colNum]);
        return;
    }

    var record = this.getCellRecord(rowNum, colNum),
        field = this.fields[colNum]
    ;

    // Allow refreshing of null records - this may occur with separator rows, loading rows,
    // etc.
    if (!field) {
        //>DEBUG
        this.logDebug("refreshCell called for invalid field " + colNum); //<DEBUG
        return;
    }

    // update the cell's innerHTML: Use the helper methods we made use of in getTableHTML() to
    // write in any additional innerHTML such as DIV tags in the cell, etc.

    // use a StringBuffer rather than normal concatenation
    var sb = isc.StringBuffer.create();

    // determine whether we need to write a DIV for this cell
    var writeDiv = this._writeDiv(rowHeight),
        nowrap = !this.wrapCells && !isc.Browser.isIE8Strict;
    if (writeDiv) {
        // cellclipdivstart includes an open style=' attr
        sb.append(this._$cellClipDivStart);

        // height enforcement
        var rowHeight = (this.getRowHeight != null ? this.getRowHeight(record, rowNum, this._isFrozenBody())
                                                   : this.cellHeight);
        sb.append(this._getCellDivCSSHeight(rowHeight, record, rowNum));

        // width enforcement (unless colspan *)
        var drawRecordAsSingleCell = this._drawRecordAsSingleCell(rowNum, record);
        if (!drawRecordAsSingleCell) {
            sb.append(this._getFieldDivWidthCSSText(colNum));
        }

        if (nowrap) sb.append("white-space:nowrap;");

        sb.append("'>");
    }

    // NOBR tags if we're not wrapping cells and we're not writing out `white-space:nowrap' on
    // a cell div.
    var writeNOBR = nowrap && !writeDiv;
    if (writeNOBR) {
        sb.append("<NOBR>");
    }
    // Get the actual value for the cell
    sb.append(this._getCellValue(record, rowNum, colNum));
    // close the NOBR tag if necessary
    if (writeNOBR && this.closeNOBRs) {
        sb.append("</NOBR>");
    }
    // close the DIV if necessary
    if (writeDiv) {
        sb.append("</DIV>");
    }

    // Actually apply the innerHTML to the innerHTML of the cell.
    cell.innerHTML = sb.release(false);
},

//>    @method    gridRenderer.setCellStyle()
// Set the CSS class of a record
//        @group    appearance
//
//        @param    rowNum (number)    row number to set class of
//        @param    colNum    (number) column number to set class of
//        @param    [className]    (CSSStyleName)    name of the CSS class to set to; if not specified,
//                                          will use getCellStyle()
//<
setCellStyle : function (rowNum, colNum, className) {
    // Just fall through to setRowStyle
    return this.setRowStyle(rowNum, className, colNum);
},


//>    @method    gridRenderer.setRowStyle()
// Set the CSS class of a record
//        @group    appearance
//
//        @param    rowNum (number)    record number to set class of.  This takes this._firstDrawnRow into account
//        @param    [className]    (CSSStyleName)    name of the CSS class to set to; if not specified, will
//                                          use getCellStyle()
//        @param    [colNum]    (number)        column number to set class of.  If not specified, will
//                                          set all columns in that row.
//<
setRowStyle : function (rowNum, className, colNum) {
    if (isc._traceMarkers) arguments.__this = this;
    // navigate into the DOM and change the contents of the native table cells

    // if the rowNum is null, use this.selection.lastSelectionItem
    if (rowNum == null || rowNum < 0) {
        this.logWarn("setRowStyle: bad rowNum: " + rowNum);
        return false;
    }

    // verify that we've drawn the table
    var cell = this.getTableElement(rowNum, colNum);

    if (cell == null) {
        // when incremental rendering is on, this is a normal condition indicating that we are
        // trying to update some row/cell that has been scrolled out of view, hence no longer
        // exists.  NOTE: don't log, we might be calling this for thousands of unrendered cells.
        //this.logDebug("setRowStyle(): cell (" + rowNum + "," + colNum + ") not present");
        return false;
    }

    var record = this.getCellRecord(rowNum, colNum);

    // for eg, rows that are about to be completely refreshed anyway
    if (record && record._ignoreStyleUpdates) {
        return;
    }


    // if a colNum was specified, update just the individual cell (we got a pointer to it
    // above)
    if (colNum != null) {
        this._updateCellStyle(record, rowNum, colNum, cell, className);
    } else {

        var row = this.getTableElement(rowNum);
        if (row != null) {
            var td = "TD",
                firstCol = (!this.shouldShowAllColumns() ? this._firstDrawnCol : 0),
                lastCol = (!this.shouldShowAllColumns() ? this._lastDrawnCol : this.fields.length-1),
                // If incremental rendering is enabled, the indices of the cells in the DOM
                // will not match the colNum of the cell being updated.
                renderedCellNum = 0;

            var recursive = this.suppressRowHeightUpdate;
            this.suppressRowHeightUpdate = true;

            for (var fieldNum = firstCol; fieldNum <= lastCol; fieldNum++, renderedCellNum++) {

                var cell;
                // If we're showing columns separately, we'll style the whole table for the
                // column (Nav case)
                if (this.showColumnsSeparately || this.cacheDOM) {
                    cell = this.getTableElement(rowNum, fieldNum);


                // Otherwise we'll style the individual cells in the row.
                } else {
                    cell = row.childNodes[renderedCellNum];

                }
                if (cell == null) continue;

                // Pass in the optional record object, className and cell objects to avoid them
                // being re-calculated.
                this._updateCellStyle(record, rowNum, fieldNum, cell, className);
            }

            if (!recursive) {
                delete this.suppressRowHeightUpdate;
                this._updateRowHeight(record, rowNum, className);

            }
        }
    }

    // return true to indicate that we were able to update the cell(s)
    return true;
},

//>    @method    gridRenderer.refreshCellStyle()
// Refresh the styling of an individual cell without redrawing the grid.
// <P>
// The cell's CSS class and CSS text will be refreshed, to the current values returned by
// getCellStyle() and getCellCSSText() respectively.
// <P>
// The cell's contents (as returned by getCellValue()) will <b>not</b> be refreshed.  To
// refresh both styling and contents, call refreshCell() instead.
//
//        @group    appearance
//        @param    rowNum (number)    row number of cell to refresh
//        @param    colNum    (number) column number of cell to refresh
//
// @see refreshCell() to update cell contents too
// @visibility external
//<
// NOTE:
// - className param not public because we don't persist the change
//        @param    [className]    (CSSStyleName)    name of the CSS class to set to; if not specified,
//                                          will use getCellStyle()
refreshCellStyle : function (row, col, className) {
    // this is a synonym for setCellStyle();
    // We could also fall through to refreshCellStyles() but this would force us to create an
    // array object to pass in.
    return this.setCellStyle(row, col, className);
},

//>    @method        gridRenderer.refreshCell()    ([A])
// Refresh an individual cell without redrawing the grid.
// <P>
// The cell's value, CSS class, and CSS text will be refreshed, to the current values returned
// by getCellValue(), getCellStyle() and getCellCSSText() respectively.
//
//        @group    appearance
//        @param    rowNum (number)    row number of cell to refresh
//        @param    colNum    (number) column number of cell to refresh
//
// @see refreshCellStyle() to update just styling
// @visibility external
//<
refreshCell : function (rowNum, colNum) {
    this._clearCachedCellValueForRefreshCell(rowNum,colNum);
    this.refreshCellStyle(rowNum, colNum);
    // refresh the value too unless it's already been refreshed as part of styling
    if (!this.shouldRefreshCellHTML()) this.refreshCellValue(rowNum, colNum);
},

// Notification from refreshCell() - clear our cachedCellValue so we don't show stale values

_clearCachedCellValueForRefreshCell : function (rowNum,colNum) {
    this._clearCachedCellValue(rowNum, colNum);
},

//>    @method        gridRenderer.refreshRow()    ([A])
// Refresh an entire row of cells without redrawing the grid.
// <P>
// The cells' values, CSS classes, and CSS text will be refreshed, to the current values
// returned by getCellValue(), getCellStyle() and getCellCSSText() respectively.
//
//        @group    appearance
//        @param    rowNum (number)    row number of cell to refresh
//
// @see refreshCellStyle() to update just styling
// @see refreshCell()
// @visibility external
//<
refreshRow : function (rowNum) {
    if (!this._readyToRefreshCell(rowNum)) {
        this.delayCall("refreshRow", [rowNum]);
    }
    for (var i = 0; i < this.fields.length; i++) {
        this.refreshCell(rowNum, i);
    }
},

//>    @method    gridRenderer.refreshCellStyles()    ([A])
//  @group    selection, appearance
//
//  Update the style of a list of cells. (Used to show selection changes when cell selection is
//  enabled)
//
//        @param    cellList    (Array)
//              Array of [rowNum, colNum] array pairs.
//        @param    [className] (CSSStyleName)
//              Name of the CSS class to set to; if not specified, will use getCellStyle()
//
//        @return    (boolean)    true == actually updated now, false == will update later
//
//<
refreshCellStyles : function (cellList, className) {
    //>DEBUG
    this.logDebug("refreshing cell styles: " + cellList.length + " cells");
    //<DEBUG

    //this.logWarn("refresh cells: " + this.echoAll(cellList));

    // NOTE: this is a very time critical method, as it is called every mouseMove during drag
    // selection.

    for (var i = 0; i < cellList.length; i++) {
        var rowNum = cellList[i][0],
            colNum = cellList[i][1];



        var cell = this.getTableElement(rowNum, colNum);
        if (cell == null) {
            // when incremental rendering is on, this is a normal condition indicating that we
            // are trying to update some row/cell that has been scrolled out of view, hence no
            // longer exists.  NOTE: don't log, we might be calling this for thousands of
            // unrendered cells.
            //this.logDebug("setRowStyle(): cell (" + rowNum + "," + colNum + ") not present");
            continue;
        } else {
            // no need to pass in the record object, this will be calculated in _updateCellStyle()
            this._updateCellStyle(null, rowNum, colNum, cell, className);
        }
    }
    // return true to indicate that we were able to update the cell(s)
    return true;
},

// Size Detection
// --------------------------------------------------------------------------------------------

//> @method gridRenderer.getCellPageRect() ([A])
// Returns the page offsets and size of the cell at the passed row and column.  If auto-sizing
// is enabled, sizes are not definitive until the grid has finished drawing, so calling this
// method before drawing completes will return the configured column sizes.
// @param rowNum (number) row index of the cell
// @param colNum (number) column index of the cell
// @return (Array of Integer) the page rect of the passed cell
// @group sizing, positioning
// @visibility external
//<
getCellPageRect : function (rowNum, colNum) {
    return [
        this.getColumnPageLeft(colNum),
        this.getRowPageTop(rowNum),
        this.getColumnSize(colNum),
        this.getRowSize(rowNum)];
},

//> @method gridRenderer.getColumnLeft() ([A])
// Return the left coordinate (in local coordinate space) of a particular column.
// @param colNum (Integer) number of the column
// @return (Integer) left coordinate of the passed colNum
// @group sizing, positioning
// @visibility external
//<
getColumnLeft : function (colNum) {
    // Note: we don't have to worry about undrawn columns because this._fieldWidths has all
    // column widths, not just the drawn ones.

    // textDirection: we calculate field sizes from right to left in RTL mode

    if (this.isRTL()) {
        return this.getViewportWidth() - this._fieldWidths.sum(0, colNum+1);
    } else {
        // otherwise return the width of fields 0-colNum
        return this._fieldWidths.sum(0, colNum);
    }
},


//> @method gridRenderer.getColumnPageLeft() ([A])
// Return the left coordinate for a given column number as a GLOBAL coordinate
// @param colNum (Integer) number of the column
// @return (Integer) page left offset of the passed colNum, or null if undrawn or no such column
// @group sizing, positioning
// @visibility external
//<
getColumnPageLeft : function (colNum) {
    var columnLeft = this.getColumnLeft(colNum);
    if (columnLeft == null) return null;
    var left = this.getPageLeft() - this.getScrollLeft() + columnLeft;
    if (this.isRTL()) {
        if (this.vscrollOn) left += this.getScrollbarSize();
        left += this.getScrollWidth() - this.getViewportWidth();
    }
    return left;
},


getScrollWidth : function (calculateNewValue) {
    if (isc._traceMarkers) arguments.__this = this;

    var isCached = this._scrollWidth != null && !calculateNewValue,
        scrollWidth = this.invokeSuper(isc.GridRenderer, "getScrollWidth", calculateNewValue);

    if (this.isDrawn && !isCached &&
        (isc.Browser.isIE || isc.Browser.isEdge) &&
        (!this.autoFit && this.fixedColumnWidths && this._fieldWidths))
    {
        var tableWidth = this._fieldWidths.sum();
        if (tableWidth == scrollWidth-1) {
            scrollWidth = tableWidth;
        }
    }
    return scrollWidth;
},

//> @method gridRenderer.getColumnWidth() ([A])
// Return the width of a particular column.
// @param colNum (number) number of the column.
// @return (number) width
// @group sizing, positioning
// @visibility external
//<
getColumnWidth : function (colNum) {
    // return the width of the column from the _fieldWidths property
    return this._fieldWidths[colNum];
},

//>    @method    gridRenderer.getInnerColumnWidth()    ([A])
//        Return the width of a particular column adjusted for this.cellPadding / cellSpacing.
//        @group    sizing, positioning
//        @param    colNum    (number)    number of the column.
//        @return    (number)    inner width
//<
getInnerColumnWidth : function (colNum) {
    var width = this.getColumnWidth(colNum);
    if (width == null) return null;

    // Note: cell spacing still breaks alignment with ListGrid headers in both firefox and IE.
    // However this is a non-exposed feature for now
    return (width - (2* this.cellSpacing + this._getCellHBorderPad()));
},

// method to get, and cache horizontal cell padding size (based on this.cellPadding and styling)
// Used for sizing the cell-level clipping div, etc.

_getCellHBorderPad : function (recalc) {
    if (!recalc && this._cellHBorderPad != null) return this._cellHBorderPad;

    var firstStyle = this._getFirstRecordStyle(),
        padLeft = isc.Element._getLeftPadding(firstStyle, true),
        padRight = isc.Element._getRightPadding(firstStyle, true),
        border = isc.Element._getHBorderSize(firstStyle);

    if (padLeft == null) padLeft = this.cellPadding;
    if (padRight == null) padRight = this.cellPadding;

    this._cellHBorderPad = (padLeft + padRight + border);
    return this._cellHBorderPad;
},

//>    @method    gridRenderer.getRowTop()    ([A])
// Returns the top coordinate for a given row number, relative to the top of body content.  Use
// +link{getRowPageTop()} for a page-relative coordinate.
// <P>
// This method is reliable only for rows that are currently drawn, which is generally only rows
// that are visible in the viewport.  If row heights vary (see <code>fixedRowHeights</code>),
// coordinates for rows that are not currently shown are rough approximations.
//
// @param rowNum (int)
// @return (int) Y-coordinate
// @group positioning
// @visibility external
//<
getRowTop : function (rowNum) {
    // undrawn rows before or after the drawn area are treated as having fixed height
    if (rowNum < this._firstDrawnRow) return this.getAvgRowHeight() * rowNum;

    var undrawnHeight = this._getUndrawnHeight(),
        drawnHeights = this._getDrawnRowHeights();

    if (rowNum > this._lastDrawnRow) {
        // undrawn rows after the drawn area are treated as having fixed height
        return undrawnHeight + drawnHeights.sum() +
                    (((rowNum-1) - this._lastDrawnRow) * this.getAvgRowHeight());
    }
    // otherwise return the sum of heights of records 0-rowNum
    return undrawnHeight + drawnHeights.sum(0, rowNum - this._firstDrawnRow);
},

//>    @method    gridRenderer.getRowPageTop()    ([A])
// Returns the Y-coordinate for a given row number as a page-relative coordinate.  See
// +link{getRowTop()}.
//
// @param rowNum (int)
// @return (int) Y-coordinate
// @group positioning
// @visibility external
//<
getRowPageTop : function (rowNum) {
    return this.getPageTop() + this.getTopBorderSize() +
                (this.getRowTop(rowNum)- this.getScrollTop());
},

//>    @method    gridRenderer.getRowSize()    ([A])
// Get the drawn height of a row.
//
// @param rowNum (number)
//
// @return (number) height
// @group sizing, positioning
// @deprecated As of SmartClient 8.0, use +link{gridRenderer.getDrawnRowHeight}.
//<
getRowSize : function (rowNum) {
    return this.getDrawnRowHeight(rowNum);
},

//>    @method    gridRenderer.getDrawnRowHeight() ([A])
// Get the drawn height of a row.
//
// @param rowNum (number)
//
// @return (number) height
// @group sizing, positioning
//<
getDrawnRowHeight : function (rowNum) {

    // treat all undrawn rows as though they were cellHeight tall
    if (this._firstDrawnRow == null || this._lastDrawnRow == null
        || rowNum < this._firstDrawnRow || rowNum > this._lastDrawnRow)
    {
        return this.getAvgRowHeight();
    }

    var visibleRowNum = rowNum - this._firstDrawnRow,
        heights = this._getDrawnRowHeights();
    return heights[visibleRowNum];
},

//>    @method    gridRenderer.getColumnSize()    ([A])
// Get the drawn width of a column.
//
// @param colNum (number)
//
// @return (number) width in pixels
// @group sizing, positioning
//<
// NOTE: this function must be named getColumnSize because getColumnWidth refers to specified
// width.
getColumnSize : function (colNum) {
    if ((this.fixedFieldWidths && !this.autoSize) ||
        (colNum < this._firstDrawnCol || colNum > this._lastDrawnCol))
    {
        // fixed sizes, or not rendered; return specified size
        return this.getColumnWidth(colNum);
    }
    var visibleColNum = colNum - this._firstDrawnCol,
        widths = this.getColumnSizes();
    return widths[visibleColNum];
},


// get the total height of all rows that are not currently drawn because they are above the
// viewport (and out of drawAhead range)
_getUndrawnHeight : function () {
    return this._firstDrawnRow * this.getAvgRowHeight();
},

// get the heights of all drawn rows
_getDrawnRowHeights : function () {
    //!DONTCOMBINE
    var rowRange = this.getDrawnRows(),
        drawnRows = rowRange[1] - rowRange[0] + 1;
    if (this._rowHeights != null) {
        return this._rowHeights;
    }

    var heights = [];
    if (!this._suppressTableCaching) this._rowHeights = heights;

    // make sure that the table is defined by checking to make sure it exists
    //    -- if it isn't defined, return an empty list
    var table = this.getTableElement();
    if (!table || !table.rows) {
        // otherwise delete the recordHeights so we'll calculate them again
        // since this is being called prematurely (???)
        delete this._rowHeights;
        return heights;
    }




    var oldSafari = isc.Browser.isSafari && isc.Browser.safariVersion < 500;

    var nonZeroHeight = false,
        firstRowBCR = null,
        prevHeightsSum = 0,
        isRTL = this.isRTL();
    for (var rowNum = 0; rowNum <= drawnRows; rowNum++) {
        var row = this.cacheDOM ? this.getTableElement(rowNum + this._firstDrawnRow) : table.rows[rowNum];

        if (row == null) {
            /*empty*/


        } else if (isc.Browser._hasGetBCR) {
            var rowBCR = isc.Element.getBoundingClientRect(row);
            if (firstRowBCR == null) firstRowBCR = rowBCR;
            heights[rowNum] = Math.round((rowBCR.bottom - firstRowBCR.top) - prevHeightsSum);


        } else if (this.allowRowSpanning && this.getRowSpan) {
            heights[rowNum] = row.offsetHeight;

        } else {

            var checkAllCellHeights =
                (oldSafari &&
                    (this.fixedRowHeights == false ||
                        (this.shouldFixRowHeight != null &&
                         this.shouldFixRowHeight(this.getCellRecord(rowNum), rowNum) == false )
                     )
                 ),
                cell, safariCellArray = [];

            if (!oldSafari || !checkAllCellHeights) {

                cell = row.lastChild;
            } else {
                for (var k = 0; k < row.childNodes.length; k++) {
                    safariCellArray[k] = row.childNodes[k]
                }
            }


            if (checkAllCellHeights) {
                heights[rowNum] = 0;
                for (var cellNum = 0; cellNum < safariCellArray.length; cellNum ++) {
                    var currentCell = safariCellArray[cellNum],
                        height = currentCell.offsetHeight;


                    var specifiedHeight = parseInt(currentCell.style ? currentCell.style.height
                                                                     : null);
                    if (isc.Browser.isStrict) {

                        if (this.cellPadding) specifiedHeight += this.cellPadding;
                        specifiedHeight += isc.Element._getVBorderPad(currentCell.className);
                    }

                    if (isc.isA.Number(specifiedHeight) && specifiedHeight > height)
                        height = specifiedHeight;

                    if (height > heights[rowNum]) heights[rowNum] = height;
                }
                heights[rowNum] += this.cellSpacing;

            } else if (cell) {

                if (!oldSafari) {
                    heights[rowNum] = cell.offsetHeight;
                } else {
                    // In Safari the offsetHeight is often misreported, and can't exceed
                    // the specified height for the cell, so use the specified height
                    // directly

                    var cellHeight = parseInt(cell.height);
                    if (cellHeight != null && isc.isA.Number(cellHeight)) {
                        if (isc.Browser.isStrict) {

                            cellHeight += isc.Element._getVBorderSize(cell.className);
                        }
                    } else {
                        cellHeight = cell.offsetHeight || 0;
                    }

                    heights[rowNum] = cellHeight;
                }

                heights[rowNum] += this.cellSpacing;
            }
        }

        var height = heights[rowNum];
        if (height > 0) {
            nonZeroHeight = true;
            prevHeightsSum += height;
        }
    }

    // add the cellSpacing to the first record.  This makes it so when the cursor is in the
    // spacing region, it actually goes to the lower record, which looks better than it
    // going to the upper record
    heights[0] += this.cellSpacing;


    if (!nonZeroHeight) {
        this.logWarn("row heights not yet available; returning all zeroes");
        this._rowHeights = null;
    }


    if (isc.Browser.isSafari && !isc.Page.isLoaded()) this._rowHeights = null;

    return heights;
},


//>    @method    gridRenderer.getColumnSizes()    ([A])
//    Get rendered column widths
//        @group    sizing, positioning
//        @return    (boolean)    null | false
//<
// NOTE: sets sets gridRenderer._renderedColumnWidths
getColumnSizes : function () {
     if (this._renderedColumnWidths != null) return this._renderedColumnWidths;

    // If undrawn, don't cache potentially incorrect values.
    if (!this.isDrawn()) return this._fieldWidths.duplicate() || [];

    var widths;
    if (this.fixedColumnWidths && isc.Browser.version >= 5) {
        widths = this._fieldWidths.duplicate();
        if (!this._suppressTableCaching) this._renderedColumnWidths = widths;
        return widths;
    } else {
        // inspect the DOM to determine rendered widths


        widths = [];
        if (!this._suppressTableCaching) this._renderedColumnWidths = widths;

        // get the first row in the table to test to see if it's drawn
        var row = this.getTableElement(this._firstDrawnRow);
        // if the row isn't defined,
        if (row == null) {
            // use the fieldWidths as specified in the settings
            widths = widths.concat(this._fieldWidths);
            if (!this._suppressTableCaching) this._renderedColumnWidths = widths;
            return widths;
        }


        var    sizeDelta = (isc.Browser.isMac ? this.cellSpacing : 0);

        // iterate for all of the fields of the table that have been drawn, getting the sizes
        for (var colNum = 0; colNum < this.fields.length; colNum++) {
            var cell;
            if (this.showColumnsSeparately) {
                cell = this.getTableElement(this._firstDrawnRow,colNum);
            // Note leading not - This code will fire for safari 1.2, and other browsers
            } else if (!(isc.Browser.isSafari && isc.Browser.safariVersion < 125)) {
                cell = row.childNodes[colNum];
            }

            if (cell) {
                widths[colNum] = cell.offsetWidth + sizeDelta;
            } else {
                widths[colNum] = this._fieldWidths[colNum];
            }
        }
        // NOTE: we do this only in the case where we're not setting fixed widths
        this.innerWidth = this.getTableElement().offsetWidth;

        return widths;
    }
},

// Event Row/Col
// --------------------------------------------------------------------------------------------

_differentEventCharacteristics : function (eventA, eventB) {
    var rowA = this.getEventRow(this.getOffsetY(eventA)),
        rowB = this.getEventRow(this.getOffsetY(eventB));
    if (rowA != rowB) return true;
    var colA = this.getEventColumn(this.getOffsetX(eventA)),
        colB = this.getEventColumn(this.getOffsetX(eventB));
    if (colA != colB) return true;
    return false;
},

//>    @method    gridRenderer.getEventRow()
// Returns the row number of the most recent mouse event.
//        @group    events, selection
//
//        @param [y] (Integer) optional y-coordinate to obtain row number, in lieu of the y
//                        coordinate of the last mouse event
//
//        @return    (int)    row number, or -2 if beyond last drawn row
//      @visibility external
//<
getEventRow : function (y) {
    // if we're empty always return rowNum -2 (beyond the end of any valid data)

    if (this.isEmpty()) return -2;

    // If a y-coordinate was not passed, get it from the offset of the last event
    if (y == null) y = this.getOffsetY();

    // if we're showing a start spacer, knock that off from the event coordinate so we can figure
    // out which row we hit
    if (this.startSpace) y -= this.startSpace;

    var undrawnHeight = this._getUndrawnHeight();
    // if it's a coordinate before the drawn area, treat all offscreen rows as fixed height
    if (y <= undrawnHeight) return Math.floor(y / this.getAvgRowHeight());

    var remainder = y - undrawnHeight,
        heights = this._getDrawnRowHeights();

    // check visible rows.  Note that if it's past the end of the visible rows, inWhichPosition
    // returns -2, and so do we
    var drawnRowNum = this.inWhichPosition(heights, remainder),
        pos;
    if (drawnRowNum >= 0) {
        pos = this._firstDrawnRow + drawnRowNum;
    } else {
        // assume the rest of the rows are fixed height
        var pastDrawnRows = remainder - heights.sum();
        pos = this._lastDrawnRow + 1 + Math.floor(pastDrawnRows / this.getAvgRowHeight());
        // Avoid returning a number higher than our total number of rows
        if (pos >= this.getTotalRows()) pos = -2;
    }

    //this.logWarn("getEventRow(" + (y == null ? this.getOffsetY() : y) + "): " +
    //             " rowHeights:" + heights +
    //             " drawn range: " + [this._firstDrawnRow, this._lastDrawnRow] +
    //             ", undrawnHeight: " + undrawnHeight +
    //             ", eventRow:" + pos);

    //this.logWarn("getEventRow(" + (y == null ? this.getOffsetY() : y) + "): " + pos);

    return pos;
},

//>    @method    gridRenderer.getEventColumn()
// Returns the column number of the most recent mouse event.
//        @group    events, selection
//
//        @param [x] (Integer) optional x-coordinate to obtain column number for, in lieu of the x
//                        coordinate of the last mouse event
//
//        @return    (int)    column number, or -2 if beyond last drawn column
//      @visibility external
//<
getEventColumn : function (x) {

    var widths = this.getColumnSizes();

    // If a x-coordinate was not passed, get it from the offset of the last event
    if (x == null) x = this.getOffsetX();

    // In RTL mode, if the grid is leaving a scrollbar gap but the vertical scroll bar is not
    // showing on the body, we need to make an adjustment by the scrollbar size because the
    // left coordinate of the body is not offset by the scrollbar size.
    var textDirection = this.getTextDirection(),
        grid;

    if (!this.frozen &&
        textDirection == isc.Page.RTL &&
        !this.vscrollOn &&
        (grid = this.grid) != null &&
        grid._shouldLeaveScrollbarGap())
    {

        x -= this.getScrollbarSize();
    }

    return this.inWhichPosition(widths, x, textDirection);
},

// getFocusRow / col for keypress events. Overridden at the ListGrid gridBody level.

getFocusRow : function () {
    return 0;
},
getFocusCol : function () {
    return 0;
},

// Helper to return the row that should get native focus in screenReader mode
// will basically match the focusRow- but could differ from it if (EG) the focus row isn't actually
// drawn.
getNativeFocusRow : function () {

    var rowNum = this._nativeFocusRow;
    if (rowNum == null) rowNum = this.getFocusRow();

    // default to top of viewport if we don't have a row already, or it is undrawn.

    var rows = this.getDrawnRows();
    if (rows != null && rows.length > 0 &&
        (rowNum == null || rowNum < rows[0] || rowNum > rows[1])) {
        rowNum = this._getViewportFillRows()[0];
        // if first row is partially offscreen jump to next row to avoid auto-scroll
        if (this.getRowTop(rowNum) < this.getScrollTop()) rowNum += 1;
    }
    return rowNum;

},

//>    @method    gridRenderer.getNearestRowToEvent()
//            Returns the nearest row to the event coordinates
//        @group    events, selection
//      @visibility external
//<
getNearestRowToEvent : function () {
    var rowNum = this.getEventRow();
    if (rowNum < 0) {
        var visibleRows = this.getVisibleRows();
        if (rowNum == -1) return visibleRows[0];
        if (rowNum == -2) return visibleRows[1];
    }
    return rowNum;
},

//>    @method    gridRenderer.getNearestColToEvent()
//            Returns the nearest column to the event coordinates
//        @group    events, selection
//      @visibility external
//<
getNearestColToEvent : function () {
    var colNum = this.getEventColumn();
    if (colNum < 0) {
        var visibleColumns = this.getVisibleColumns();
        if (colNum == -1) return visibleColumns[0];
        if (colNum == -2) return visibleColumns[1];
    }
    return colNum;
},

// Note: viewport rows / visible rows / drawn rows
// =================
// There is a distinction here between:
// - "rows we need to draw to fill the viewport" (getViewportFillRows)
// - "drawn rows that are currently visible in the viewport" (getVisibleRows)
// - "rows we've actually drawn" (this._firstDrawnRow -> this._lastDrawnRow)
//
// With drawAheadRatio > 1, rows we've drawn clearly differ from the other two.  With variable
// height cells, viewportFillRows differ from visible rows since we don't know how tall the
// cells will be before we draw them; the last viewportFillRow may actually be rendered below
// the viewport.  With fixedRowHeights:false and a drawAheadRatio > 1, the first viewport fill
// row may be below the top of the viewport.
//
// Generally:
// - we use the viewportFillRows only to determine how many rows to draw / whether to redraw
// - we use _firstDrawnRow/_lastDrawnRow to do DOM manipulation
// - event handling code that cares about the viewport (particularly D&D) uses visible rows

_getViewportFillRows : function () {

    var viewportHeight = this.getViewportHeight(),
        avgRowHeight = this.getAvgRowHeight()
    ;


    var firstVisible = Math.floor(this.getScrollTop() / avgRowHeight);
    if (firstVisible > this.getTotalRows()) {
        firstVisible = this.getTotalRows() - Math.ceil(viewportHeight / this.cellHeight);
    }



    var nRecords;
    if (this.autoFitData == "both" || this.autoFitData == "vertical") {
        nRecords = this.getTotalRows() - firstVisible;

        var maxRecords = this.autoFitMaxRecords;
        if (maxRecords != null && maxRecords < nRecords) nRecords = maxRecords;

        var totalHeight = this.getAutoFitMaxHeight();
        if (totalHeight != null) {
            var maxRecordsByHeight = Math.ceil(totalHeight / this.cellHeight);
            if (maxRecordsByHeight < nRecords) nRecords = maxRecordsByHeight;
        }
    } else {
        nRecords = Math.ceil(viewportHeight / this.cellHeight);
    }
    // [firstVisible, lastVisible] is an *inclusive* range, so subtract one here
    var lastVisible = firstVisible + nRecords - 1;
    // if we're showing an explicit spacer at the top, it'll shift the rows down
    // take that into account now
    if (this.startSpace) {
        var spaceRows = Math.floor(this.startSpace / avgRowHeight);
        firstVisible = Math.max(0, firstVisible - spaceRows);
        lastVisible = Math.max(0, lastVisible - spaceRows);
    }

    // Are we virtual scrolling? Don't rely on this._isVirtualScrolling in case data or
    // fixedRowHeights, etc has changed
    var vscrolling = this.virtualScrolling && this._targetRow != null;
    if (vscrolling) {
        if (firstVisible == 0 && lastVisible >= (this.getTotalRows()-1)) vscrolling = false;
    }

    if (!vscrolling) return [firstVisible, lastVisible];

    // when using virtual scrolling, calculate the rows that need to be drawn to fill the
    // viewport based on the target row that needs to be scrolled into view (scrollTop is
    // irrelevant)

    //this.logWarn("calculating viewport based on targetRow: " + this._targetRow +
    //             ", row offset: " + this._rowOffset);

    var startCoord = this._targetRow;
    // if we have a large negative offset (targetRow will be well below viewport), ensure
    // enough rows are rendered above the targetRow
    if (this._rowOffset < 0) startCoord += Math.floor(this._rowOffset / this.cellHeight);
    if (startCoord < 0) startCoord = 0;
    var endCoord = startCoord + Math.ceil(viewportHeight / this.cellHeight);
    return [startCoord, endCoord];

},

// Arbitrary average row height for incremental rendering and variable row heights
// default to a typical row height given a few lines of wrapping text
// Used whenever we need to know / estimate how tall undrawn rows will render


avgRowHeight:60,
getAvgRowHeight : function () {
    return this.fixedRowHeights ? this.cellHeight : Math.max(this.cellHeight,this.avgRowHeight);
},

//>    @method    gridRenderer.getVisibleRows()
// Get the rows that are currently visible in the viewport, as an array of
// [firstRowNum, lastRowNum].
// <p>
// If the grid contains no records, will return [-1,-1].  Will also return [-1,-1] if called at
// an invalid time (for example, data is in the process of being fetched - see
// +link{ResultSet.lengthIsKnown()}).
//
// @return (Array of int)
// @visibility external
//<
// NOTE: the viewport can extend beyond the last row or column, in which case the last row or
// column is reported as the last visible.
getVisibleRows : function () {
    if (isc.ResultSet && isc.isA.ResultSet(this.data) && !this.data.lengthIsKnown()) {
        return [-1,-1];
    }
    return this._getVisibleRows();
},
_getVisibleRows : function () {
    var scrollTop = this.getScrollTop();
    var rows = [
        this.getEventRow(scrollTop),
        this.getEventRow(scrollTop + this.getInnerHeight())
    ];
    // viewport extends beyond last row
    if (rows[1] == -2) {
        var totalRows = this.getTotalRows();
        if (totalRows == 0 || rows[0] < 0) {
            // empty data, or some other condition that caused getEventRow() to return
            // something invalid
            rows[0] = -1;
            rows[1] = -1;
        } else {
            // return the *index of* the last row
            rows[1] = this.getTotalRows() - 1;
        }
    }
    return rows;
},

//>    @method    gridRenderer.getVisibleColumns()
// Get the currently visible columns, as an array of [leftColumnNum, rightColumnNum]
//<
getVisibleColumns : function () {

    var widths = this._fieldWidths;
    if (this.overflow == isc.Canvas.VISIBLE) return [0, widths.length-1];

    var scrollPos = this.getScrollLeft();

    if (this.isRTL()) {

        var maxScroll = this.getScrollWidth() - this.getInnerWidth(),
            scrollPos = maxScroll - scrollPos;
    }

    var firstCol = this.inWhichPosition(widths, scrollPos),
        lastCol = this.inWhichPosition(widths, scrollPos + this.getInnerWidth());

    //this.logWarn("scrollLeft: " + scrollPos +
    //             ", firstCol: " + firstCol +
    //             ", lastCol: " + lastCol);

    if (lastCol == -2) lastCol = this._fieldWidths.length - 1;
    return [firstCol, lastCol];

    // maxScroll - scrollLeft
    // 0 - 0: 0, works with non-reversed traversal
    // max - max: 0, works
    // max - 0:


},

//>    @method    gridRenderer.getDrawnRows()
// Get the rows that are currently drawn (exist in the DOM), as an array of [firstRowNum,
// lastRowNum].
// <P>
// The drawn rows differ from the +link{getVisibleRows,visibleRows} because of
// +link{drawAheadRatio,drawAhead}.  The drawn rows are the appropriate range to consider if
// you need to, eg, using +link{refreshCell()} to update all the cells in a column.
// <P>
// If the grid is undrawn or the +link{emptyMessage} is currently shown, returns
// [null,null];
//
// @return (Array)
// @visibility external
//<
getDrawnRows : function () {
    if (this.cacheDOM) return this.getVisibleRows();
    return [this._firstDrawnRow, this._lastDrawnRow]
},

// Synthetic Row/Cell Events (over/out/hover/contextClick)
// --------------------------------------------------------------------------------------------

// shouldShowRollOver
// Should we show the "over" styling for this row when the mouse goes over it?
// By default this is always true if this.showRollOver is true.
shouldShowRollOver : function (rowNum, colNum) {
    // NOTE: colNum may be null.

    return (this.showRollOver && !this._rowAnimationInfo);
},

// called whenever the current row needs to be updated to reflect a change in the rollOver
// state.  This includes both the rollover *leaving* a row (rollover appearance needs to be
// cleared) and entering the row.
updateRollOver : function (rowNum, colNum) {
    this.setRowStyle(rowNum, null, (this.useCellRollOvers ? colNum : null));
},

// We fire synthetic events such as 'cellMouseOver' or 'rowMouseOver' on mouseOver of a cell.
// The handling for this is very similar for each event type -
//  on X event, if cellX is defined fire it.  If rowX is defined fire that.
// (If both are defined, we fire both).

// NOTE: checking for valid (>=0) row and col coordinates is necessary because the table can be
// drawn smaller than the area of the containing GridRenderer Canvas (eg in the LV, with a small
// number of records), so the mouse can be within the GridRenderer Canvas without being over the
// table as such.

// NOTE: most of the pseudo events do not have default handlers - meaning they can be defined
// without the developer having to call "Super".  The only case where we currently would
// require an override to call Super is if the developer overrides
// 'selectOnMouseDown(record,rowNum,colNum)' or 'selectOnMouseUp(record,rowNum,colNum)'.



// Override the (unexposed) startHover() method to be a no-op
// This is called by the EH directly to show hover on mouseOver - we're handling our hovers on
// mouseOver of specific cells etc.
startHover : function () { },

//>    @method    gridRenderer.mouseMove()    ([A])
//        @group    events
//            Generate cell/row over/out events
//        @return    (boolean)    false if same cell/row as before
//<
mouseMove : function (arg1, arg2) {

    if (this._suppressEventHandling(isc.EH.lastEvent)) return;

    // check for keyboard-navigation-induced scrolls
    if (this._suppressNextMouseMove) {
        this._suppressNextMouseMove = false;
        return;
    }

    var rowNum = this.getEventRow(),
        colNum = this.getEventColumn();

    // If we're pending a redraw from scroll, and the mouse is currently over an
    // undrawn part of the table, suppress standard mouseMove handling.
    // We don't want to fetch data which is just being scrolled through, or attempt to
    // redraw to refresh styling, etc.
    // (This is most relevant to mouseWheel scrolling where the mouse is over the body
    // of the grid).

    var pendingScrollRedraw = this.pendingActionOnPause("scrollRedraw"),
        drawnRows = this.getDrawnRows();
    if (pendingScrollRedraw && drawnRows &&
        (rowNum < drawnRows[0] || rowNum > drawnRows[1]))
    {
        return;
    }


    // On rollOver of cells we do a couple of things:
    // - highlight the cell by applying "Over" styling
    // - fire cell level events ("rowOver", "rowOut", and also hover events if appropriate).
    // The "Over" styling subsystem is also coopted at the ListGrid level for visual feedback with
    // keyboard navigation.
    // Track the current "Over" styled cell separately from the last "cellOver" event cell - this
    // is required to avoid an obscure bug where if a cell is highlighted with the "Over" style
    // by keyboard navigation or focus, and then the user rolls over it, the appropriate
    // rowOver event never fires.

    var lastStyleRow = this.lastOverRow,
        lastMouseRow = this.lastMouseOverRow,
        lastStyleCol = this.lastOverCol,
        lastMouseCol = this.lastMouseOverCol;

    //this.logWarn("row: " + rowNum + ", col: " + colNum);
    var validRowCol = (rowNum >= 0 && colNum >= 0),
        notSameStyleRowCol = !(rowNum == lastStyleRow && colNum == lastStyleCol),
        notSameMouseRowCol = !(rowNum == lastMouseRow && colNum == lastMouseCol),


        requireRecord = validRowCol && (
            notSameStyleRowCol || notSameMouseRowCol || this.cellMove || this.rowMove),
        record = requireRecord && this.getCellRecord(rowNum, colNum),

        hasNewCell = (validRowCol && requireRecord && this.cellIsEnabled(rowNum, colNum, record));

    // Styling:
    if (notSameStyleRowCol) {

        // If we were showing "over" styling for another row/cell, clear it.

        if (lastStyleRow != null && lastStyleCol != null) {
            this.lastOverRow = null;
            this.lastOverCol = null;

            // If we're not over a valid column (we're too far to the right of the listGrid)
            // consider this a row change, for the purposes of restyling correctly
            if (rowNum != lastStyleRow || colNum < 0 || this.useCellRollOvers) {


                this.updateRollOver(lastStyleRow, lastStyleCol, hasNewCell);
            }
        }

        // And show the over style for the new cell:
        if (hasNewCell) {

            this.lastOverRow = rowNum;
            this.lastOverCol = colNum;

            if (lastStyleRow != rowNum || this.useCellRollOvers) {
                // show rollover hiliting
                if (this.shouldShowRollOver(rowNum, colNum)) {
                    this.updateRollOver(rowNum, colNum);
                }
            }
        }
    }

    // handle situations when we return cursor from inner components to a cell of current grid
    var returnedBackToCurrentGrid = this._lastTarget != arg1.target && (arg1.target == this);
    this._lastTarget = arg1.target;

    // Events (including hovers):
    if (notSameMouseRowCol || returnedBackToCurrentGrid) {

        if (lastMouseRow != null && lastMouseCol != null) {

            this.lastMouseOverRow = null;
            this.lastMouseOverCol = null;

            // Once again - if new colNum < 0, we are to the right of the rightmost column, so
            // call stopHover even if we're hovering by row.
            if ((rowNum != lastMouseRow || colNum < 0 || this.hoverByCell) &&
                this.getCanHover() && !this.keepHoverActive)
            {
                this.stopHover();
            }

            var lastMouseRecord = this.getCellRecord(lastMouseRow, lastMouseCol);

            // support field.cellOut, cell.cellOut?
            if (this.cellOut) {
                this.cellOut(lastMouseRecord, lastMouseRow, lastMouseCol);
            }
            if (rowNum != lastMouseRow && this.rowOut) {
                this.rowOut(lastMouseRecord, lastMouseRow, lastMouseCol);
            }
        }

        if (hasNewCell) {

            this.lastMouseOverRow = rowNum;
            this.lastMouseOverCol = colNum;

            if (rowNum != lastMouseRow || this.hoverByCell) {
                // set hover action
                if (validRowCol && this.getCanHover()) {
                    var hoverDelay = this.getCellHoverDelay(rowNum, colNum);
                    isc.Hover.setAction(this, this._cellHover, [rowNum, colNum], hoverDelay);

                }
            }

            // support field.cellOver, cell.cellOver?
            if (this.cellOver) {
                this.cellOver(record, rowNum, colNum);
            }

            if (rowNum != lastMouseRow && this.rowOver) {
                this.rowOver(record, rowNum, colNum);
            }
        }
    }

    if (validRowCol) {
        // cellMove / rowMove
        // Not currently exposed - used internally to update hovers for validation error icons
        // in ListGrid.
        if (this.cellMove) {
            this.cellMove(record, rowNum, colNum);
        }
        if (this.rowMove) {
            this.rowMove(record, rowNum, colNum);
        }
    }

    // If this mouseMove was tripped by the user scrolling (see Canvas.scrolled),
    // and we're pending a scroll-redraw, reset the scroll redraw timer now

    if (pendingScrollRedraw && this._firingSyntheticMouseMove) {
        var delay = this.getScrollRedrawDelay(this._pendingScrollRedrawFromWheel);
        this.fireOnPause("scrollRedraw",
            this._getRedrawOnScrollCallback(),
            delay);
    }
},

// Support suppressing mouse/keyboard event handling at certain times.
_suppressEventHandling : function (mouseEvent) {
    // mouseEvent parameter can be used to refer to a specific event
    // used in ListGrid/gridBody
    //>Animation
    // If we're in the process of animate-resizing a row just suppress all event handling!
    if (this._rowAnimationInfo != null) return true;
    //<Animation
    return false;
},

//>    @method    gridRenderer.mouseOut()    ([A])
//        @group    events
//            call _cellOut or _rowOut if appropriate
//        @return    (boolean)    false if no hiliting
//<
mouseOut : function () {
    // Don't suppress mouseOut handling even if this._suppressEventHandling returns true
    // - we don't want the list stuck in an "over" state

    // if the mouseOut occurred by the mouse going over a child of an embedded component, don't
    // hide rollover / fire mouseOut methods.
    var target = isc.EH.getTarget();
    if (this._embeddedComponents) {
        var components = this._embeddedComponents;
        for (var i = 0; i < components.length; i++) {
            if (!components[i]) continue;
            if (components[i].contains(target, true)) {
                return;
            }
        }
    }
    // Note that we'll still get a bubbled mouseout when the user rolls out of the embedded
    // component so we won't get stuck in an 'over' state.

    // If the target == this, we're still over this widget.
    // This can happen if we're starting to drag - in this case continue as with any other
    // mouseOut (killing the hover is technically unnecessary as in this case as
    // EH.handleDragStart() always calls Hover.clear(), but we also want to clear up over-styling
    // etc.)
    // It can also happen if we're in the process of being masked by the clickMask
    // which explicitly calls 'mouseOut' on the target, allowing us to clean up state.
    //
    // Otherwise this event was bubbled from the user rolling off an embedded component back
    // into the body and we can ignore it.
    if (target == this && !isc.EH.getDragTarget() && !isc.EH._showingClickMask) {
        return;
    }

    // clear any hover timer/window
    if (this.getCanHover()) this.stopHover();
    // if we were previously over a valid cell, reset the style for that cell and fire
    // cellOut / rowOut

    if (this.lastOverRow != null && this.lastOverCol != null) {

        var lastOverRow = this.lastOverRow,
            lastOverCol = this.lastOverCol;

        this.lastOverRow = null;
        this.lastOverCol = null;

        // clear rollover hiliting
        if (this.shouldShowRollOver(lastOverRow, lastOverCol)) {
            this.updateRollOver(lastOverRow, lastOverCol);
        }
    }

    if (this.lastMouseOverRow != null && this.lastMouseOverCol != null) {

        var lastOverRow = this.lastMouseOverRow,
            lastOverCol = this.lastMouseOverCol,
            lastOverRecord = this.getCellRecord(lastOverRow, lastOverCol);

        this.lastMouseOverRow = null;
        this.lastMouseOverCol = null;

        // support field.cellOut, cell.cellOut?
        if (this.cellOut) {
            this.cellOut(lastOverRecord, lastOverRow, lastOverCol);
        }
        if (this.rowOut) {
            this.rowOut(lastOverRecord, lastOverRow, lastOverCol);
        }
    }

},


_getShowClippedValuesOnHover : function () {
    return this.showClippedValuesOnHover;
},

getCellHoverDelay : function (rowNum, colNum) {
    return this.hoverDelay;
},

// support field.cellHover, cell.cellHover, field.showHover, cell.showHover?
_cellHover : function (rowNum, colNum) {
    //!DONTCOMBINE
    var record = this.getCellRecord(rowNum, colNum);

    if (!this.shouldFireCellHover(record, rowNum, colNum)) return;

    // call user-defined handler and bail (don't show hover window) if it returns false
    var returnVal,
        cellValueIsClipped = this.cellValueIsClipped(rowNum, colNum);
    if (this._getShowClippedValuesOnHover() && cellValueIsClipped &&
        this.cellValueHover && this.cellValueHover(record, rowNum, colNum) == false)
    {
        returnVal = false;
    }
    if (this.cellHover && this.cellHover(record, rowNum, colNum) == false) returnVal = false;
    if (this.rowHover && this.rowHover(record, rowNum, colNum) == false) returnVal = false;

    if (returnVal == false) return;

    // show hover window if enabled
    if (this.showHover) this._showHover(record, rowNum, colNum, cellValueIsClipped);
},

// If we get a cellHover timer event over what appears to be an invalid cell (no record),
// don't fire the notification methods.

shouldFireCellHover : function (record, rowNum, colNum) {
    return record != null;
},

defaultCellValueHoverHTML : function (record, rowNum, colNum) {
    return this._getCellValue(record, rowNum, colNum);
},

_getHoverProperties : function (record, rowNum, colNum) {
    if (this.grid) {
        var isFrozenBody = this.grid.frozenBody && this == this.grid.frozenBody,
            frozenLength = !isFrozenBody && this.grid.frozenBody ? this.grid.frozenFields.length : 0,
            field = colNum != null ? this.grid.fields[colNum + frozenLength] : null
        ;
        if (field) {
            // Use same hover properties from canvas on field
            var result = {};
            for (var hoverProp in this._hoverPropertyMap) {
                var widgetProp = this._hoverPropertyMap[hoverProp];
                result[hoverProp] = field[widgetProp] != null
                                        ? field[widgetProp]
                                        : this.grid[widgetProp] || this[widgetProp];
            }
            return result;
        }
    }
    return this.Super("_getHoverProperties");
},

_showHover : function (record, rowNum, colNum, cellValueIsClipped) {
    var content = this._getCellHoverComponent(record, rowNum, colNum);
    var properties = this._getHoverProperties(record, rowNum, colNum);
    if (!content) {
        // Prefer the standard cell hover if customized.
        var useStandardCellHover = false,
            isCellHoverSuppressed = false;
        if (this.cellHoverHTML._isPassthroughMethod && this.grid) {
            var grid = this.grid,
                gridCol = grid.getFieldNumFromLocal(colNum, this),
                field = grid.getField(gridCol);
            useStandardCellHover = field && (grid.canHover ||
                                    (field.showHover && grid.canHover != false) ||
                                    grid.cellHoverHTML != grid.getClass().getInstanceProperty("cellHoverHTML") ||
                (grid.canHover == null && field.showHover)) && field.showHover != false;
            isCellHoverSuppressed = grid._isCellHoverSuppressed(rowNum, gridCol);
        }

        if (!isCellHoverSuppressed) {
            if (!useStandardCellHover) {
                if (this._getShowClippedValuesOnHover() && cellValueIsClipped) {
                    content = this.cellValueHoverHTML(record, rowNum, colNum,
                        this.defaultCellValueHoverHTML(record, rowNum, colNum));
                }
            } else {
                content = this.cellHoverHTML(record, rowNum, colNum);
            }
        }
    }
    isc.Hover.show(content,
                   properties,
                   this.cellHoverBoundary(rowNum, colNum),
                   this.getHoverTarget());
},

_getCellHoverComponent : function (record, rowNum, colNum) {
},

// getHoverTarget() - returns the 'targetCanvas' passed to Hover.show() in _showHover()
// This allows the developer to call 'updateHover()' on that canvas to change the hover content HTML
// override in LG bodies to point to the ListGrid
getHoverTarget : function () {
    return this;
},

cellHoverHTML : function (record, rowNum, colNum) {
    return null;
},

cellValueHoverHTML : function (record, rowNum, colNum, defaultHTML) {
    return null;
},

getCellHoverComponent : function (record, rowNum, colNum) {
    return null;
},


cellHoverBoundary : function (rowNum, colNum) {

    return null;

},

// generate cell/row contextClick events
showContextMenu : function () {
    if (this._suppressEventHandling(isc.EH.lastEvent)) return false;

    var rowNum = this.getEventRow(),
        colNum = this.getEventColumn();

    // If this came from a keyboard event, use the keyboard focus row / col
    var keyboardEvent = isc.EH.isKeyEvent();
    if (keyboardEvent) {
        rowNum = this.getFocusRow(),
        colNum = this.getFocusCol();
    }

    var validRowCol = (rowNum >= 0 && colNum >= 0),
        record = validRowCol && this.getCellRecord(rowNum, colNum);
    if (validRowCol && this.cellIsEnabled(rowNum, colNum, record)) {
        var returnVal;
        if (this.cellContextClick)
            if (this.cellContextClick(record, rowNum, colNum) == false) returnVal = false;

        if (this.rowContextClick)
            if (this.rowContextClick(record, rowNum, colNum) == false) returnVal = false;

        // Legacy:
        if (this.recordContextClick)
            if (this.recordContextClick(record, rowNum, colNum) == false) returnVal = false;

        if (returnVal == false) return false;
    }

    return this.Super("showContextMenu");
},




// Selection
// --------------------------------------------------------------------------------------------

setSelection : function (selection) {
    this.selection = selection;

    // update cell/row styling on selection change
    if (this.selection.isA("CellSelection")) {
        this.observe(this.selection, "selectionChanged", function () {
            this._cellSelectionChanged(this.selection.changedCells);
        });
    } else {
        this.observe(this.selection, "setSelected", function () {
            this._setSelectedObservation(this.selection);
        });
    }
},

clearSelection : function () {
    if (this.selection) {
        if (this.isObserving(this.selection, "selectionChanged"))
            this.ignore(this.selection, "selectionChanged");
        if (this.isObserving(this.selection, "setSelected"))
            this.ignore(this.selection, "setSelected");

        delete this.selection;
    }
},

_cellSelectionChanged : function (cellList) {
    //this.logWarn("cellSelectionChanged with list: " + this.echoFull(cellList));
    // call user-defined handler and bail (don't hilite cells) if it returns false
    if (this.cellSelectionChanged) {
        if (this.cellSelectionChanged(cellList) == false) return false;
    }
    // refresh the affected cells to visually indicate selection
    this.refreshCellStyles(cellList);
},

// setSelected was fired on the selection object.
// If the selection actually changed call _rowSelectionChanged to fire notification methods and
// refresh the row in question.
// setSelected may be called without changing selection. This is actually done internally
// to manage cascading selection sync.
_setSelectedObservation : function (selection) {
    var changed = false;


    // If the state changed, we need to refresh
    if (!!selection.lastSelectionPreviousState != !!selection.lastSelectionState) {
        changed = true;
    // We show partial selection in some cases in tree-grids.
    // If the partial selected state changed, we also need to refresh
    } else if (selection.lastSelectionState &&
                (!!selection.lastSelectionPartialValue != !!selection.lastSelectionPreviousPartialValue))
    {
        changed = true;
    }


    if (changed) {
        this._rowSelectionChanged(
            selection.lastSelectionItem,
            !!selection.lastSelectionState,
            selection.cascadeSyncOnly
        );
    }
},

_rowSelectionChanged : function (record, state, cascadeSyncOnly) {
    if (!cascadeSyncOnly) {
        // call user-defined handler and bail (don't hilite rows) if it returns false.

        if (this.handleSelectionChanged(record, state) == false) {
            return false;
        }
    }

    if (this.selection._selectingList) {
        this.markForRowSelectionRefresh();
        return;
    }

    // refresh the affected records to visually indicate selection

    var selection = this.selection,
        lastItem = selection.lastSelectionItem,
        rowNum = selection.data.indexOf(lastItem,
                                        this._firstDrawnRow,
                                        this._lastDrawnRow);
    if (rowNum == -1) rowNum = selection.data.indexOf(lastItem);

    if (rowNum == -1) return;
    this.updateRowSelection(rowNum);
},


markForRowSelectionRefresh : function () {
    this.markForRedraw("Selection changed");
},

handleSelectionChanged : function (record,state) {
    if (this.selectionChanged) return this.selectionChanged(record,state);
},

updateRowSelection : function (rowNum) {
    this.setRowStyle(rowNum);
},

// Catch-all redraw to indicate selection has updated

redrawForSelectionChanged : function () {
    this.markForRedraw("selection changed");
},

selectionEnabled : function () {
    return this.selection != null;
},

canSelectRecord : function (record) {
    return (record != null && record[this.recordCanSelectProperty] !== false);
},

//>    @method    gridRenderer.mouseDown()    ([A])
//        @group    events, selection
//            handle a mouseDown event
//        @return    (boolean)    false if record is disabled
//<
_getMouseDownCell : function () {
    return [this.getEventRow(), this.getEventColumn()];
},
mouseDown : function () {

    if (this._suppressEventHandling(isc.EH.lastEvent)) {
        return;
    }

    var cell = this._getMouseDownCell(),
        rowNum = cell[0],
        colNum = cell[1];
    // not over a cell - just bail
    if (!(rowNum >= 0 && colNum >= 0)) return;

    var record = this.getCellRecord(rowNum, colNum);

    // if the record is explicitly disabled, kill the event
    if (!this.cellIsEnabled(rowNum, colNum, record)) {
        return false;
    }

    // hang onto the rowNum / colNum to see if we get a click over the same cell
    this._mouseDownRow = rowNum;
    this._mouseDownCol = colNum;
    this._scrolledSinceMouseDown = false;

    // remember the location of the click too.

    this._mouseDownX = isc.EH.getX();
    this._mouseDownY = isc.EH.getY();

    // call user-defined synthetic mouseDown event handler
    if (!isc.EH.rightButtonDown()) {
        return this._cellMouseDown(record, rowNum, colNum);
    } else {
        return this._cellRightMouseDown(record, rowNum, colNum);
    }

},


rightMouseDown : function () {
    // required to handle remembering which record the mouse went down over. Also fires
    // _cellRightMouseDown()
    return this.mouseDown();
},

_cellMouseDown : function (record, rowNum, colNum) {
    var returnVal;

    if (this.cellMouseDown && (this.cellMouseDown(record, rowNum, colNum) == false)) returnVal = false;
    if (this.rowMouseDown && (this.rowMouseDown(record, rowNum, colNum) == false)) returnVal = false;
    // legacy
    if (this.recordMouseDown && this.recordMouseDown(rowNum, colNum) == false) returnVal = false;
    if (returnVal == false) return false;
    // perform selection
    this.selectOnMouseDown(record, rowNum, colNum);
},


selectOnMouseDown : function (record, rowNum, colNum, keyboardGenerated) {
    if (!this.selectionEnabled()) {
        return true;
    }

    //this.logWarn("mouseDown at: " + [rowNum, colNum]);

    if (rowNum >= 0 && colNum >= 0 && this.canSelectRecord(record) &&
        !this._shouldSelectOnMouseUp())
    {
        this._updateSelectionOnMouseUp = true;
        var selectionChanged = this.selection.selectOnMouseDown(this, rowNum, colNum);
        if (selectionChanged && this.fireSelectionUpdated && isc.isA.Function(this.fireSelectionUpdated)) {
            this.fireSelectionUpdated();
        }
    }

},

_shouldSelectOnMouseUp : function () {
    var EH = this.ns.EH;
    if (EH.dragTarget != null && EH.dragOperation == EH.DRAG_SCROLL ||
        this._usingNativeTouchScrolling())
    {
        return true;
    }
    return false;
},

_cellRightMouseDown : function (record, rowNum, colNum) {
    // currently there are no cell / row level rightMouseDown handlers, but this is where we would
    // call them if there were.

    // perform right-mouse style selection
    if (this.canSelectOnRightMouse) this.selectOnRightMouseDown(record, rowNum, colNum);
},

// If the user clicks on the GridRenderer, causing it to receive focus, and the
// browser natively scrolls a parent to bring the top/left of the GR into view -
// reset this scroll as it'll interfere with the intended user interaction

disableNativeScrollOnMouseDownFocus:true,

// We override Canvas._scrolled() here to prevent keyboard-navigation-triggered scrolling from
// firing a synthetic mouse event which can corrupt the tracking of the navigation location.
// If navigation is not in progress, we simply call the parent (Canvas) method.
_scrolled : function (deltaX, deltaY) {

    if (!this._iosScrollFixInProgress) {
        this._scrolledSinceMouseDown = true;
    }
    if (this.grid && this.grid._handlingKeyboardNavigation) {
        // some browsers trigger extra native mouse move events; suppress them
        if (isc.Browser.nativeMouseMoveOnCanvasScroll) {
            this._suppressNextMouseMove = true;
            isc.Page.setEvent(isc.EH.MOUSE_MOVE, this, "once", "_suppressMouseMove");
        }
        this._fireParentScrolled(this, deltaX, deltaY);
        if (this.scrolled) this.scrolled(deltaX, deltaY);
    } else {
        this.Super("_scrolled", arguments);
    }
},

// Do nothing unless the mouse move event is not the one that we expect to suppress;
// in that case, clear the flag so it gets handled normally like any other event
_suppressMouseMove : function () {
    var target = isc.EH.lastEvent.target;
    if (target != this) this._suppressNextMouseMove = false;
},

// Default implementation is just to do 'selectOnMouseDown' - override if you want something else.
selectOnRightMouseDown : function (record, rowNum, colNum) {
    this.selectOnMouseDown(record, rowNum, colNum);
},

//>    @method    gridRenderer.mouseUp()    ([A])
//        @group    events,    selection
//            handle a mouseUp event
//        @return    (boolean)    false if no hiliting; true otherwise
//<
mouseUp : function () {
    if (this._suppressEventHandling(isc.EH.lastEvent)) return;

    var rowNum = this.getEventRow(),
        colNum = this.getEventColumn();

    // not over a cell - just bail
    if (!(rowNum >=0 && colNum >=0)) return;

    var record = this.getCellRecord(rowNum, colNum);

    // if the record is explicitly disabled, just return
    if (!this.cellIsEnabled(rowNum, colNum, record)) return;

    // call user-defined cell / row level mouseUp handler
    var returnVal;

    if (this.cellMouseUp && (this.cellMouseUp(record, rowNum, colNum) == false)) returnVal = false;
    if (this.rowMouseUp && (this.rowMouseUp(record, rowNum, colNum) == false)) returnVal = false;
    // legacy
    if (this.recordMouseUp && this.recordMouseUp(rowNum, colNum) == false) returnVal = false;
    if (returnVal == false) return returnVal;

    this.selectOnMouseUp(record, rowNum, colNum);
},

selectOnMouseUp : function (record, rowNum, colNum, keyboardGenerated) {
    if (!this.selectionEnabled()) {
        return true;
    }

    if (rowNum >= 0 && colNum >= 0 && this.canSelectRecord(record) &&
        (keyboardGenerated ||
         (this._mouseDownRow == rowNum && this._mouseDownCol == colNum && !this._scrolledSinceMouseDown)))
    {
        var selectionChanged = false;
        // If we didn't select on mouseDown, fire both 'selectOnMouseDown' and 'selectOnMouseUp'
        // to update the selection

        if (this._shouldSelectOnMouseUp()) {
            this._updateSelectionOnMouseUp = true;
            selectionChanged = this.selection.selectOnMouseDown(this, rowNum, colNum);
        }

        if (this.grid) this.grid._dontRefreshSelection = true;
        if (this.selection.selectOnMouseUp(this, rowNum, colNum)) selectionChanged = true;
        if (this.grid) this.grid._dontRefreshSelection = null;

        // only refresh if the selection actually changed - otherwise we'll end up redrawing
        // on every click on a selected row, etc.
        if (selectionChanged) {
            this.redrawForSelectionChanged();
            if (this._updateSelectionOnMouseUp) {
                if (this.fireSelectionUpdated && isc.isA.Function(this.fireSelectionUpdated)) {
                    this.fireSelectionUpdated();
                }
                if (this.grid.getCurrentCheckboxField() != null) {
                    this.grid.updateCheckboxHeaderState();
                }
                this._updateSelectionOnMouseUp = null;
            }
        }
    }

},

//>    @method    gridRenderer.click()  ([A])
//        @group    events
//            handle a click event
//          fires cell or row level click handler
//
//        @return    (boolean)    false if the event was cancelled by some handler
//<
click : function () {

    if (this._suppressEventHandling(isc.EH.lastEvent)) return;

    var rowNum = this.getEventRow(),
        colNum = this.getEventColumn();
    return this._rowClick(rowNum, colNum);
},

// _rowClick - fire rowClick and cellClick handlers
_rowClick : function (rowNum, colNum) {
    // Clear out old _clickRow/ _clickCol, which are now out of date.
    // [These will be set to meaningful values if the event occurred over a valid cell].
    this._clickRow = this._clickCol = null;

    var mdR = this._mouseDownRow;

    // if the click occurred over a different record from the previous mousedown, just bail

    if (mdR != null && rowNum != mdR) {
        if (isc.EH.getX() == this._mouseDownX) {
            rowNum = this._mouseDownRow;
        } else {
            // Don't return false - we don't want to suppress click from bubbling.
            return;
        }
    }
    if (isc.EH.getY() == this._mouseDownY && this._mouseDownCol != null) {
        colNum = this._mouseDownCol;
    }

    // no record - just bail
    if (!(rowNum >=0 && colNum >=0)) return;

    var record = this.getCellRecord(rowNum, colNum);

    // if the record is explicitly disabled, return false to kill doubleClick etc
    if (!this.cellIsEnabled(rowNum, colNum, record)) return false;

    // record the click cell details for double-click events to check
    this._clickRow = rowNum;

    var returnVal;
    // only fire cellClick if it was on the same column as well as the same row
    if (!this._cellClick(record, rowNum, colNum)) returnVal = false;
    if (this.rowClick && (this.rowClick(record, rowNum, colNum) == false))
        returnVal = false;

    // clear out the old mouseDown row
    // Note - this method is fired _after_ mouseUp, so we can't clear these values out there.
    this._mouseDownRow = null;

    return returnVal;

},

// _cellClick - fire cellClick handlers on the specified row/col
_cellClick : function (record, rowNum, colNum) {


    // Assertion - this method is only called when we have already verified that the click
    // occurred over the same row as the last mousedown
    if (this._mouseDownCol != colNum) {
        // Clearing out this._clickCol avoids the possibility of the doubleClick handler firing
        // over this cell which never received a first click.
        this._clickCol = null;
        return;
    }
    // update _clickCol so double clicks can determine whether they occurred over the
    // same column as the previous click.
    this._clickCol = colNum;

    this._mouseDowncol = null;
    return !(this.cellClick && (this.cellClick(record, rowNum, colNum) == false));
},

//>    @method    gridRenderer.doubleClick()  ([A])
//        @group    events
//            handle a doubleClick event
//          fires cell or row level doubleClick handler
//
//        @return    (boolean)    false if the event was cancelled by some handler
//<
doubleClick : function () {
    if (this._suppressEventHandling(isc.EH.lastEvent)) return;

    var rowNum = this.getEventRow(),
        colNum = this.getEventColumn();

    // no record - just bail
    if (!(rowNum >= 0 && colNum >= 0)) return;

    var record = this.getCellRecord(rowNum, colNum);

    // if the record is explicitly disabled, kill the event
    if (!this.cellIsEnabled(rowNum, colNum, record)) return false;

    // If the double click occurred over a different row from the previous click, fire
    // rowClick / cellClick over the new row.
    if (rowNum != this._clickRow) {
        return this._rowClick(rowNum, colNum);
    }

    // call user-defined cell / row level click and mouseUp handler
    var handlerReturn;

    // the click occurred over a different col from the last click, fire a single click on
    // that cell (but not that row)
    // NOTE: this means if the user double clicks within a row, but the clicks land on different
    // columns we'll get a single click on each cell, and a double click on the row.
    if (colNum != this._clickCol) {
        handlerReturn = this._cellClick(record, rowNum, colNum);

    // otherwise fire a double click handler on the cell
    } else if (this.cellDoubleClick && (this.cellDoubleClick(record, rowNum, colNum) == false))
    {
       handlerReturn = false;
    }

    if (this.rowDoubleClick  && (this.rowDoubleClick(record, rowNum, colNum) == false))
        handlerReturn = false;

    // clear out the temp vars -- we don't want to fire a click on mouseUp after this doubleclick
    // (this is fired before mouseUp) and no need to hang onto the clickRow / col.
    this._mouseDownRow = this._mouseDownCol = null;
    this._clickRow = this._clickCol = null;

    if (handlerReturn == false) return false;

},

dragStart : function () {
    var EH = isc.EH,
        event = EH.lastEvent;
    // Try to normalize the appearance of the default native drag tracker image. In browsers
    // that support the EH.setDragTrackerImage() API, this will set the native drag tracker
    // image to the table row wherever the user starts the drag (e.g. if the user starts
    // the drag on an icon, then the browser will use the icon as the drag tracker image).

    if (event.target == this &&
        event.eventType == "dragStart")
    {
        var dt;
        try {
            dt = event.DOMevent.dataTransfer;
        } catch (e) {

            dt = null;
        }

        if (dt != null && dt.setDragImage != null) {
            var rowNum = this.getNearestRowToEvent(),
                rowElement = this.getTableElement(rowNum);
            if (rowElement != null) {
                var offsets = isc.Element.getOffsets(rowElement),
                    x = EH.getX(),
                    y = EH.getY();
                dt.setDragImage(rowElement, x - offsets.left, y - offsets.top);
            }
        }
    }
},

//>    @method    gridRenderer.dragMove()    ([A])
//        @group    events, dragging
//            drag move event
//        @return    (boolean)
//<
// XXX
// We may want to add handling for row and cell level rowDragMove() and cellDragMove() handlers.
// If we do this we would also add row and cell level dragStart / dragStop / dropMove / drop, etc.
// - Default (internal) implementation would handle dragSelection if this.canDragSelect
//   Not worrying about this for now.
dragMove : function () {

    if (this._suppressEventHandling(isc.EH.lastEvent) || !this.selectionEnabled() || !this.canDragSelect)
        return true;

    var rowNum = this.getNearestRowToEvent(),
        colNum = this.getNearestColToEvent();

    //this.logWarn("selectOnDragMove: " + [rowNum, colNum]);
    this.selection.selectOnDragMove(this, rowNum, colNum);
},

dragStop : function () {
    this.fireSelectionUpdated();
},

// Override Drag/drop snap-to-grid functionality from Canvas

// suppress drag offset when snap dragging to cells.
noSnapDragOffset : function (dragTarget) {
    return this.snapToCells;
},
getHSnapPosition : function (localCoordinate, dir) {
    if ( ! this.snapToCells) {
        return this.Super("getHSnapPosition", arguments);
    }
    var EH = this.ns.EH,
        direction = dir || this.snapHDirection,
        col = this.snapHGap ? Math.floor(localCoordinate / this.snapHGap) : this.getEventColumn(localCoordinate),
        beforeLeft = this.snapHGap ? (col * this.snapHGap) : this.getColumnLeft(col),
        beforeRight = this.snapHGap ? beforeLeft + this.snapHGap : this.getColumnLeft(col) + this.getColumnSize(col),
        afterCol = this.snapHGap ? col + 1 : this.getEventColumn(beforeRight + 1),
        afterLeft;

    if (afterCol >= 0 ) {
        afterLeft = this.snapHGap ? afterCol * this.snapHGap : this.getColumnLeft(afterCol);
    } else {
        afterLeft = beforeLeft;
    }
    var halfway = beforeLeft + (this.snapHGap ? this.snapHGap : this.getColumnSize(col)) / 2;

    // Fix up for cell borders if necessary
    if (this.snapInsideBorder) {
        var lb = isc.Element._getLeftBorderSize(this.baseStyle)
        var rb = isc.Element._getRightBorderSize(this.baseStyle)
        beforeLeft += lb;
        beforeRight -= rb;
        afterLeft += lb;
    }

    // For resize, always extend the drag-target to cover the current "over" cell
    if (EH.dragOperation == EH.DRAG_RESIZE) {
        var goingLeft = isc.EH.resizeEdge.contains("L");
        return goingLeft ? beforeLeft : beforeRight;
    } else {
        if (direction == isc.Canvas.BEFORE) {
            return beforeLeft;
        } else if (direction == isc.Canvas.AFTER) {
            return afterLeft;
        } else {
            // If we're exactly inbetween, go left
            if (localCoordinate <= halfway) {
                return beforeLeft;
            } else {
                return afterLeft;
            }
        }
    }

},

getVSnapPosition : function (localCoordinate, dir) {

    if ( ! this.snapToCells) {
        return this.Super("getVSnapPosition", arguments);
    }

    // this almost works...repositioning gets thrown off when moving up. May be worth exploring
    // at some point
    //if (this.snapVGap) {
    //    return this.Super("getVSnapPosition", localCoordinate, dir) + gridInnerPageTop;
    //}
    var EH = this.ns.EH,
        direction = dir || this.snapVDirection,
        // for snapVGap, row is just a snapVGap sized chunk of space
        row = this.snapVGap ? Math.floor(localCoordinate / this.snapVGap) : this.getEventRow(localCoordinate),
        // top coordinate of row
        beforeTop = this.snapVGap ? (row * this.snapVGap) : this.getRowTop(row),
        // bottom coordinate of row
        beforeBot = this.snapVGap ? beforeTop + this.snapVGap : this.getRowTop(row) + this.getRowSize(row),
        afterRow = this.snapVGap ? row + 1 : this.getEventRow(beforeBot + 1),
        afterTop;
    if (afterRow >= 0 ) {
        afterTop = this.snapVGap ? afterRow * this.snapVGap : this.getRowTop(afterRow);
    } else {
        afterTop = beforeTop;
    }
    var halfway = beforeTop + (this.snapVGap ? this.snapVGap : this.getRowSize(row)) / 2;


    // Fix up for borders if necessary
    if (this.snapInsideBorder) {
        var tb = isc.Element._getTopBorderSize(this.baseStyle)
        var bb = isc.Element._getBottomBorderSize(this.baseStyle)
        //this.logWarn("tb: " + tb + ", bb: " + bb);
        beforeTop += tb;
        beforeBot -= bb;
        afterTop += tb;
    }


    if (EH.dragOperation == EH.DRAG_RESIZE) {
       var goingUp = isc.EH.resizeEdge.contains("T");
       return goingUp ? beforeTop : beforeBot;
    } else {
        if (direction == isc.Canvas.BEFORE) {
            return beforeTop;
        } else if (direction == isc.Canvas.AFTER) {
            return afterTop;
        } else {
            // If we're exactly inbetween, go up
            if (localCoordinate <= halfway) return beforeTop;
            else return afterTop;
        }
    }
},

// AutoSizing
// --------------------------------------------------------------------------------------------

//>    @method    gridRenderer.getColumnAutoSize()    ([A])
//        @group    sizing, positioning
//      Get the size this column needs to be in order to accommodate it's contents.
//
//      Can only be called after draw()
//
//      NOTE: if using partial table rendering (showAllRows:false), this is the size for the
//      currently visible contents of the column
//<
getColumnAutoSize : function (columnNum, startRow, endRow) {
    if (this.isEmpty()) {
        return null;
    }
    // create an offscreen Canvas to do sizing in
    var columnSizer = this._columnSizer;
    if (columnSizer == null) {
        columnSizer = this._columnSizer = this.createAutoChild("columnSizer");
    }

    // get HTML for a table containing only this column, written without column widths and
    // with no text wrapping
    var autoFit = this.autoFit,
        wrapCells = this.wrapCells;

    this.autoFit = true;
    this.wrapCells = false;

    // pass in startRow / endRow
    // If not explicitly specified, just use the current draw area
    // Passing this parameter in avoids us writing a (unnecessary in this case) spacer
    // above / below the cell values and will turn on the "fragment" logic in getTableHTML()
    // which avoids writing out DOM IDs on the various parts.
    if (startRow == null || endRow == null) {
        var drawRect = this.getDrawArea();
        startRow = drawRect[0];
        // remember drawRect is inclusive, we want exclusive
        endRow = drawRect[1]+1;
    }

//    this.logWarn("Logic to get col autoSize running:" + [columnNum, startRow, endRow]);
    // set a flag so we can write out different HTML for the sizer if necessary - such
    // as using inactive HTML for edit items in a listGrid
    this._gettingAutoSizeHTML = true;
    columnSizer.setContents(this.getTableHTML(columnNum,startRow,endRow, true));

    delete this._gettingAutoSizeHTML;

    this.autoFit = autoFit;
    this.wrapCells = wrapCells;

    // draw the table and figure out how large it is
    if (!columnSizer.isDrawn()) {
        columnSizer.draw();
    } else {
        if (columnSizer.isDirty()) columnSizer.redraw();
        if (columnSizer._delayedAdjustOverflow) columnSizer.adjustOverflow("Check autoFit column sizing");
    }

    var returnVal;
    if (isc.isA.Array(columnNum)) {
        // We're going to have to reach into the table.
        var table,
            nodes = columnSizer.getHandle().childNodes;
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].tagName.toLowerCase() == "table") {
                table = nodes[i];
                break;
            }
        }
        var rowNum = this._getValidAutoFitRowNum();
        if (table && table.rows[rowNum]) {
            var firstRow = table.rows[rowNum],
                cells = firstRow.childNodes,
                numCells = cells.length;
            returnVal = [];


            if (isc.Browser.isMoz && isc.Browser.hasTextOverflowEllipsis) {
                for (var i = 0; i < numCells; ++i) {
                    returnVal[i] = Math.ceil(cells[i].getBoundingClientRect().width);
                }

            } else if (isc.Browser.isIE10) {
                var doc = firstRow.ownerDocument;

                var origMsCSSOMElementFloatMetrics = doc.msCSSOMElementFloatMetrics;
                doc.msCSSOMElementFloatMetrics = true;
                for (var i = 0; i < numCells; ++i) {
                    returnVal[i] = Math.ceil(cells[i].offsetWidth);
                }
                doc.msCSSOMElementFloatMetrics = origMsCSSOMElementFloatMetrics;

            } else {
                for (var i = 0; i < numCells; ++i) {
                    returnVal[i] = cells[i].offsetWidth;

                    if (isc.Browser.hasTextOverflowEllipsis &&
                        this.adjustForSubPixelSizing(columnNum[i]))
                    {
                        var c = Math.ceil(returnVal[i]);

                        returnVal[i] = (returnVal[i] == c ? c + 1 : c);
                    }
                }
            }
        }

    } else {
        returnVal = columnSizer.getScrollWidth();
    }

    // No need to immediately clear the columnSizer: It's drawn offscreen already and if we clear we'll have
    // to re-draw next time we size a column which can end up with a huge number of expensive
    // clear-draw's for a grid with lots of columns. Set up a timer to remove it after a period of time to
    // allow for other columns to make use of it in the meantime.

    var _this = this;
    this.fireOnPause("clearColumnSizer",
            function () { _this.clearColumnSizer(); },
            this.clearColumnSizerDelay);

    return returnVal;
},


adjustForSubPixelSizing : function (colNum) {
    return true;
},

// Overridden in ListGrid to handle the case where we're grouped and so have some
// col-spanning cells in group header rows (which need to be skipped)
_getValidAutoFitRowNum : function () {
    return 0;
},


// Table Cache Clearing
// --------------------------------------------------------------------------------------------

// clear anything we've cached about the HTML table we draw
redraw : function (a,b,c,d) {
    this._resetEmbeddedComponents();
    this._clearCellValueCacheForRedraw();
    this.invokeSuper(isc.GridRenderer, "redraw", a,b,c,d);
    // if we're redrawing in response to the end of 'fast scrolling', the suppresDrawAhead flag
    // will have been set in markForRedraw()
    // clear this now
    delete this._suppressDrawAheadDirection;

},
// Notification from redraw() - clear our cellValueCache so we don't show stale values

_clearCellValueCacheForRedraw : function () {
    this._clearCellValueCache();
},

modifyContent : function () {
    // resize / place embedded components before
    // - restoring virtual scrolling
    // - adjusting overflow
    // Both of these need to know the drawn heights of rows (including E.C's)
    // If we're performing an animated show/hide of row, don't attempt to place embedded
    // components until it completes
    if (!this._animatedShowStartRow) this._placeEmbeddedComponents();

    if (this._targetRow != null) {

        this._scrollFromRedraw = true;
        this._scrollToTargetRow("scrollToRow in modifyContent");
        this._scrollFromRedraw = null;

        // show the table element, which is drawn as hidden so we can scroll before we make it
        // visible, to prevent it showing the wrong scroll position briefly
        var tableElement = this.getTableElement();
        if (tableElement) tableElement.style.visibility = "inherit";


    }

    if (this._isVirtualScrolling) {
        // shrink the endSpacer, if any, to avoid scrolling when unnecessary.
        var totalRowHeight = this._getDrawnRowHeights().sum();
        if (totalRowHeight < this.getViewportHeight()) {
            this._endRowSpacerHeight = 0;
            var spacer = isc.Element.get(this.getID() + "_endSpacer"),
                height = this._endRowSpacerHeight + (this.endSpace || 0);
            if (spacer) {

                if (height == 0) spacer.style.display = "none"
                else spacer.style.display = "";
                spacer.style.height = height + "px";
            }
            // overflow:hidden, so no need to rewrite div content
            //this.logWarn("shrank spacer: " + totalRowHeight);
        }


        var visibleRows = this.getVisibleRows(),
            numVisibleRows = Math.max(1, visibleRows[1] - visibleRows[0]),
            trueRatio = numVisibleRows/this.getTotalRows(),
            approxRatio = this.getViewportRatio(true);
        //this.logWarn("viewportHeight: " + this.getViewportHeight() +
        //             ", visibleRows: " + visibleRows +
        //             ", approxRatio: " + approxRatio +
        //             ", trueRatio: " + trueRatio);

        var scrollBottom = this.getScrollTop() + this.getViewportHeight(),
            viewportGap = scrollBottom - this.getRowTop(visibleRows[1] + 1);

        if (isc.isA.Number(trueRatio) && (viewportGap <= 0 || visibleRows[0] == 0) &&
            ((approxRatio == 1 && trueRatio < 1) || approxRatio/trueRatio > 1.25))
        {
            this._viewRatioRowHeight = Math.max(this.cellHeight,
                                         Math.round(this.getViewportHeight() / numVisibleRows));
            //this.logWarn("set average row height to: " + this._viewRatioRowHeight);
        }
    }

    /*
    // resize the bottom spacer to keep the scrollHeight constant
    var totalRows = this.getTotalRows(),
        oldScrollHeight = this._oldScrollHeight;
    // if we've got the same size dataset as before, and we're not drawing all the way to the
    // end
    if (this._lastTotalRows == totalRows && this._lastDrawnRow < totalRows-1) {
        var newScrollHeight = this.getScrollHeight(true),
            spacer = isc.Element.get(this.getID() + "_endSpacer"),
            spacerHeight = parseInt(spacer.offsetHeight),
            newSpacerHeight = spacerHeight + (oldScrollHeight-newScrollHeight);

        this.logWarn("adding extraHeight.  oldScrollHeight: " + oldScrollHeight +
                     ", lastDrawnRow: " + this._lastDrawnRow +
                     ", newScrollHeight: " + newScrollHeight +
                     ", spacerHeight: " + spacerHeight +
                     ", newSpacerHeight: " + newSpacerHeight);

        if (newSpacerHeight < 0) {
            this.logWarn("************** NOT ENOUGH ROOM to adjust spacer");
            newSpacerHeight = this.cellHeight;
        }
        spacer.style.height = newSpacerHeight + "px";
    }
    this._lastTotalRows = totalRows;
    */


},


// Helper to update the explicit space above / below the rows in the grid
setStartSpace : function (value) {
    if (!isc.isA.Number(value) || value == this.startSpace) return;
    var reduction = this.startSpace && this.startSpace > value;
    this.startSpace = value;
    if (!this.isDrawn()) return;
    var height = value + this._startRowSpacerHeight,
        spacer = isc.Element.get(this.getID() + "_topSpacer");
    if (spacer) {
        if (height == 0) spacer.style.display = "none";
        else spacer.style.display = ""; // default (== "inline")


        if (this._canResizeSpacerDivs) {
            spacer.style.height = height + "px";
        }
        // overflow:hidden so don't have to rewrite contents if we're shrinking
        if (!reduction || !this._canResizeSpacerDivs) {
            spacer.innerHTML = isc.Canvas.spacerHTML(1,height);
        }
        this._markForAdjustOverflow();
    }
    // If there was no spacer we must be in cacheDOM mode where we don't currently
    // support startSpace / endSpace

},

setEndSpace : function (value) {
    if (!isc.isA.Number(value) || value == this.endSpace) return;
    var reduction = this.endSpace && this.endSpace > value;
    this.endSpace = value;
    if (!this.isDrawn()) return;
    var height = value + this._endRowSpacerHeight,
        spacer = isc.Element.get(this.getID() + "_endSpacer");
    if (spacer) {
        if (height == 0) spacer.style.display = "none";
        else spacer.style.display = ""; // default (== "inline")
        if (this._canResizeSpacerDivs) spacer.style.height = height + "px";
        if (!reduction || !this._canResizeSpacerDivs) {
            spacer.innerHTML = isc.Canvas.spacerHTML(1,height);
        }
        this._markForAdjustOverflow();
    }
    // If there was no spacer we must be in cacheDOM mode where we don't currently
    // support startSpace / endSpace
},

setLeftSpace : function (value) {
    if (this.leftSpace == value) return;
    this.leftSpace = value;
    this.redraw();
},

setRightSpace : function (value) {
    if (this.rightSpace == value) return;
    this.rightSpace = value;
    this.redraw();
},

clear : function () {
    this.Super("clear", arguments);
    this.clearColumnSizer(true);
    this._clearTableCache();
    // if we're cleared before the delayed redraw from the end of fast scrolling fires,
    // clear the suppressDrawAheadDirection flag
    delete this._suppressDrawAheadDirection;
},

// clear anything we've cached about the HTML table we draw
_clearTableCache : function () {
    // drop our cache of HTML row elements
    this._rowElements = null;
    this._tableElement = null;

    // clear the cached table geometry information so it'll be recalculated the next time it's
    // asked for
    delete this._renderedColumnWidths;
    delete this._rowHeights;

    this._scrollRedraw = false;
}

});
isc.GridRenderer._gridAPIs = {
    // customizing cell values
    // --------------------------------------------------------------------------------------------
    //>    @method    gridRenderer.getCellRecord()
    // Return the record that holds the value for this cell.
    // <P>
    // Implementing <code>getCellRecord</code> is optional: the actual HTML placed into each
    // grid cell comes from <code>getCellValue</code>, and a valid grid can be created without any
    // notion of "records" at all.
    // <p>
    // If you do implement <code>getCellRecord</code>, the value you return is passed to you as the
    // "record" parameter in other methods.
    //
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (object)    record for this cell
    // @visibility external
    //<
    getCellRecord : "rowNum,colNum",

    //>    @method    gridRenderer.getCellValue()
    // Return the HTML to display in this cell.  Implementing this is required to get a non-empty
    // grid.
    //
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (string)    HTML to display in this cell
    // @visibility external
    //<
    getCellValue : "record,rowNum,colNum,gridBody",

    //>    @method    gridRenderer.findRowNum()
    // Given a record displayed in this grid, find and return the rowNum in which the record
    // appears.
    // <P>
    // As with +link{gridRenderer.getCellRecord()} implementing this method is optional as a valid
    // grid may be created without any notion of records.
    //
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @return    (number) index of the row containing the record or -1 if not found
    // @visibility external
    //<
    findRowNum : "record",
    //>    @method    gridRenderer.findColNum()
    // Given a record displayed in this grid, find and return the colNum in which the record
    // appears.
    // <P>
    // As with +link{gridRenderer.getCellRecord()} implementing this method is optional as a valid
    // grid may be created without any notion of records, or records may not be displayed in a
    // single column (as with the +link{class:ListGrid,ListGrid} class where each record is
    // displayed in an entire row.
    //
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @return    (number) index of the column containing the record or -1 if not found
    // @visibility external
    //<
    findColNum : "record",

    // customizing cell styling
    // --------------------------------------------------------------------------------------------
    //>    @method    gridRenderer.getBaseStyle() ([A])
    // Return the base stylename for this cell.  Default implementation just returns this.baseStyle.
    // See +link{listGrid.getCellStyle,getCellStyle()} for a general discussion of how to style cells.
    //
    // @see getCellStyle()
    //
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (CSSStyleName)    CSS class for this cell
    // @visibility external
    //<
    getBaseStyle : "record,rowNum,colNum",

    // getCellStyle doc'd above
    getCellStyle : "record,rowNum,colNum",

    //>    @method    gridRenderer.getCellCSSText() ([A])
    // Return CSS text for styling this cell, which will be applied in addition to the CSS class
    // for the cell, as overrides.
    // <p>
    // "CSS text" means semicolon-separated style settings, suitable for inclusion in a CSS
    // stylesheet or in a STYLE attribute of an HTML element.
    // <smartgwt><p>
    // <b>Note: This is an override point.</b></smartgwt>
    //
    // @see getCellStyle()
    //
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (string)    CSS text for this cell
    // @visibility external
    //<
    getCellCSSText : "record,rowNum,colNum",

    // doc'd above
    cellIsEnabled : "rowNum,colNum",

    // customizing table geometry
    // --------------------------------------------------------------------------------------------
    //>    @method    gridRenderer.getRowHeight()
    // Return the height this row should be.  Default is this.cellHeight. If
    // +link{GridRenderer.fixedRowHeights} is false, the row may be rendered taller than this
    // specified size.
    // <P>
    // If records will be variable height,
    // you should switch on +link{gridRenderer.virtualScrolling, virtualScrolling}.
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number
    // @return    (number)    height in pixels
    // @visibility external
    //<
    // Undocumented 'isFrozenBody' param used by the ListGrid
    getRowHeight : "record,rowNum,isFrozenBody",

    //>    @method    gridRenderer.getRowSpan() ([A])
    // Return how many rows this cell should span.  Default is 1.
    // <P>
    // NOTE: if using horizontal incremental rendering, <code>getRowSpan()</code> may be called for
    // a rowNum <b>in the middle of a spanning cell</b>, and should return the remaining span from
    // that rowNum onward.
    // <P>
    // NOTE: if a cell spans multiple rows, getCellRecord/Style/etc will be called with the topmost
    // row coordinates only.
    //
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (number)    number of cells to span
    // @visibility external
    //<
    getRowSpan : "record,rowNum,colNum",

    // synthetic row/cell events
    // --------------------------------------------------------------------------------------------

    //>    @method    gridRenderer.cellOut() ([A])
    // Called when the mouse pointer leaves a cell
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellOut : "record,rowNum,colNum",

    //>    @method    gridRenderer.cellOver() ([A])
    // Called when the mouse pointer enters a cell
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellOver : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowOut() ([A])
    // Called when the mouse pointer leaves a row
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    rowOut : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowOver() ([A])
    // Called when the mouse pointer enters a row
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    rowOver : "record,rowNum,colNum",

    //>    @method    gridRenderer.cellMove() ([A])
    // Called when the mouse pointer moves within a cell
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility internal
    //<
    cellMove : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowMove() ([A])
    // Called when the mouse pointer moves within a row
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility internal
    //<
    rowMove : "record,rowNum,colNum",


    //>    @method    gridRenderer.cellContextClick() ([A])
    // Called when a cell receives a contextclick event.
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellContextClick : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowContextClick() ([A])
    // Called when a row receives a contextclick event.
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    rowContextClick : "record,rowNum,colNum",
    // legacy support
    recordContextClick : "record,recordNum,fieldNum",

    //>    @method    gridRenderer.cellMouseDown() ([A])
    // Called when a cell receives a mousedown event.
    //
    // @group   events
    // @param   record  (ListGridRecord)    cell record as returned by getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellMouseDown : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowMouseDown() ([A])
    // Called when a row receives a mousedown event.
    //
    // @group   events
    // @param  record   (ListGridRecord)    record object returned from 'getCellRecord()'
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    rowMouseDown : "record,rowNum,colNum",

    // legacy
    recordMouseDown : "recordNum,fieldNum",

    //>    @method    gridRenderer.cellMouseUp() ([A])
    // Called when a cell receives a mouseup event.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object (retrieved from getCellRecord(rowNum, colNum))
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellMouseUp : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowMouseUp() ([A])
    // Called when a row receives a mouseup event.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    rowMouseUp : "record,rowNum,colNum",
    recordMouseUp : "recordNum,fieldNum",

    //>    @method    gridRenderer.selectOnMouseDown() ([A])
    // Called when a cell / record receives a mouseDown event, if no cell / row level mouseDown
    // handlers return false.
    // Default implementation handles selection by calling this.selection.selectOnMouseDown()
    //
    // @group   selection
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    //<
    selectOnMouseDown : "record,rowNum,colNum",

    //>    @method    gridRenderer.selectOnRightMouseDown() ([A])
    // Called when a cell / record receives a right mouseDown event, if this.canSelectOnRightMouse
    // is true.
    // Default implementation handles selection by calling this.selectOnMouseDown()
    //
    // @group   selection
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @see selectOnMouseDown()
    //<
    selectOnRightMouseDown : "record,rowNum,colNum",

    //>    @method    gridRenderer.selectOnMouseUp() ([A])
    // Called when a cell / record receives a mouseUp event, if no cell / row level mouseUp
    // handlers return false.
    // Default implementation handles selection by calling this.selection.selectOnMouseUp()
    //
    // @group   selection
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    //<
    selectOnMouseUp : "record,rowNum,colNum",

    //>    @method    gridRenderer.cellClick() ([A])
    // Called when a cell receives a click event.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellClick : "record,rowNum,colNum",

    //>    @method    gridRenderer.cellDoubleClick() ([A])
    // Called when a cell receives a double click event.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellDoubleClick : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowClick() ([A])
    // Called when a row receives a click event.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    rowClick : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowDoubleClick() ([A])
    // Called when a row receives a double click event.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    rowDoubleClick : "record,rowNum,colNum",

    // Hover events
    // --------------------------------------------------------------------------------------------
    //>    @method    gridRenderer.cellHover() ([A])
    // Called when the mouse hovers over a cell if this.canHover is true.
    //  Returning false will suppress the hover text from being shown if this.showHover is true.
    //
    // @group   events
    // @see     canHover
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event
    // @visibility external
    //<
    cellHover : "record,rowNum,colNum",

    //> @method gridRenderer.cellValueHover() ([A])
    // Optional stringMethod to fire when the user hovers over a cell and the value is clipped.
    // If this.showClippedValuesOnHover is true, the default behavior is to show a hover canvas
    // containing the HTML returned by cellValueHoverHTML(). Return false to suppress this default
    // behavior.
    //
    // @group events
    // @param record (ListGridRecord) cell record as returned by getCellRecord()
    // @param rowNum (number) row number for the cell
    // @param colNum (number) column number of the cell
    // @return (boolean) false to suppress the standard hover
    // @see showClippedValuesOnHover
    // @see cellValueIsClipped()
    // @see cellValueHoverHTML()
    // @visibility external
    //<
    cellValueHover : "record,rowNum,colNum",

    //>    @method    gridRenderer.rowHover() ([A])
    // Called when the mouse hovers over a row if this.canHover is true.
    //  Returning false will suppress the hover text from being shown if this.showHover is true.
    //
    // @group   events
    // @see     canHover
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (boolean)    whether to cancel the event (default behavior of showing the hover)
    // @visibility external
    //<
    rowHover : "record,rowNum,colNum",

    //>    @method    gridRenderer.cellHoverHTML() ([A])
    // StringMethod to dynamically assemble an HTML string to show in a hover window over the
    // appropriate cell/record when this.canHover and this.showHover are both true.
    // Called when the mouse hovers over a cell.
    //
    // @group events
    // @param record (ListGridRecord) cell record as returned by getCellRecord
    // @param rowNum (number) row number for the cell
    // @param colNum (number) column number of the cell
    // @return (HTMLString) the html to be shown inside the hover for this cell
    // @see canHover
    // @see showHover
    // @visibility external
    //<
    cellHoverHTML : "record,rowNum,colNum",

    //> @method gridRenderer.cellValueHoverHTML() ([A])
    // Returns the HTML that is displayed by the default cellValueHover handler. Return null or
    // an empty string to cancel the hover.
    // <smartgwt><p>Use <code>setCellValueHoverFormatter()</code> to provide a custom
    // implementation.</smartgwt>
    //
    // @group events
    // @param record (ListGridRecord) cell record as returned by getCellRecord()
    // @param rowNum (number) row number for the cell
    // @param colNum (number) column number of the cell
    // @param defaultHTML (HTMLString) the HTML that would have been displayed by default
    // @return (HTMLString) HTML to be displayed in the hover. If null or an empty string, then the hover
    // is canceled.
    // @see cellValueHover()
    // @visibility external
    //<
    cellValueHoverHTML : "record,rowNum,colNum,defaultHTML",

    //>    @method    gridRenderer.getCellHoverComponent() ([A])
    // StringMethod to dynamically create a Canvas-based component to show as a hover window
    // over the appropriate cell/record when this.canHover and this.showHover are both true and
    // when an override of getCellHoverComponent() is present.
    // Called when the mouse hovers over a cell.
    //
    // @group   events
    // @param    record  (ListGridRecord)    cell record as returned by getCellRecord
    // @param    rowNum    (number)    row number for the cell
    // @param    colNum    (number)    column number of the cell
    // @return    (Canvas)    a Canvas to be shown as the hover for this cell
    // @see canHover
    // @see showHover
    // @visibility external
    //<
    getCellHoverComponent : "record,rowNum,colNum",

    // selection notification
    // --------------------------------------------------------------------------------------------

    //>    @method    gridRenderer.selectionChanged() ([A])
    // Called when (row-based) selection changes within this grid. Note this method fires for
    // each record for which selection is modified - so when a user clicks inside a grid this
    // method will typically fire twice (once for the old record being deselected, and once for
    // the new record being selected).
    // <P>
    // NOTE: For updating other components based on selections or triggering selection-oriented
    // events within an application, see the
    // +link{dataBoundComponent.selectionUpdated(),selectionUpdated()} event
    // which is likely more suitable.  Calls to +link{selection.getSelection(),getSelection()}
    // from within this event may not return a valid set of selected records if the event has
    // been triggered by a call to +link{selection.selectAll(),selectAll()} or
    // +link{selection.deselectAll(),deselectAll()} - in this case use the
    // +link{dataBoundComponent.selectionUpdated(),selectionUpdated()} event instead.
    //
    // @param    record  (ListGridRecord)    record for which selection changed
    // @param    state   (boolean)    New selection state (true for selected, false for unselected)
    // @group selection
    // @visibility external
    //<
    selectionChanged : "record,state",

    //>    @method    gridRenderer.cellSelectionChanged() ([A])
    // Called when (cell-based) selection changes within this grid.
    //
    // @param    cellList    (array) Array of cells whos selected state was modified.
    // @return    (boolean)   Returning false will prevent the GridRenderer styling from being updated
    //                      to reflect the selection change.
    // @group selection
    // @visibility external
    //<
    cellSelectionChanged : "cellList",


    // IDs for legacy test tools; JSDoc above
    getRowElementId : "rowNum,physicalRowNum",
    getCellElementId : "rowNum,physicalRowNum,colNum,physicalColNum",

    // Row Heights and Embedded Components
    // ---------------------------------------------------------------------------------------
    shouldFixRowHeight : "record,rowNum",

    updateEmbeddedComponentZIndex : "component",
    updateEmbeddedComponentCoords : "component,record,rowNum,colNum",

    // WAI ARIA
    // ---------------------------------------------------------------------------------------
    getRowRole : "rowNum,record",
    getRowAriaState : "rowNum,record",
    getCellRole : "rowNum,colNum,record",
    getCellAriaState : "rowNum,colNum,record"
};
isc.GridRenderer.registerStringMethods(isc.GridRenderer._gridAPIs);





isc.defineClass("SelectionOrRollOverCanvas", "Canvas").addProperties({
    cssPointerEvents: "none"
});

//> @class  ListGrid
// A ListGrid is a +link{DataBoundComponent} that displays a list of objects in a grid, where
// each row represents one object and each cell in the row represents one property.
//
//  @implements DataBoundComponent
//  @treeLocation Client Reference/Grids
//  @visibility external
//<
// Make ListGrid a subclass of VLayout. This allows us to change the order of the sub-components
// - show summary row between header and body, etc.

isc.ClassFactory.defineClass("ListGrid", "VLayout", "DataBoundComponent");

isc.defer("isc.ListGrid.addProperties({ showRollOver: !isc.Browser.isTouch });");

// Synonym for backCompat.  NOTE: define an alias rather than make a subclass, otherwise, attempts
// to skin the class using the old name would only affect the subclass!
isc.addGlobal("ListViewer", isc.ListGrid);
// define groups for documentation purposes

    //> @groupDef data
    //<

    //> @groupDef databinding
    // DataBinding means the automatic, highly customizable process of 'binding' a UI component
    // to a DataSource, so that a UI component displays, edits and saves DataSource records
    // using appropriate formatters, editors, validation rules, and persistence logic.
    //
    // @see interface:DataBoundComponent
    // @title DataBinding
    //<

    //> @groupDef sorting
    //<

    //> @groupDef editing
    // Data being displayed by a grid may be edited within the grid, by showing editing
    // interfaces embedded inside the cells of the grid.
    // <P>
    // <b>Enabling editing</b>
    // <P>
    // Editing is enabled when +link{listGrid.canEdit,canEdit} is <code>true</code>.  When enabled,
    // the user can begin editing via the
    // +link{listGrid.editEvent,editEvent}, typically click or double-click.  Editing can also be triggered
    // programmatically by a call to +link{listGrid.startEditing,startEditing()} or
    // +link{listGrid.startEditingNew,startEditingNew()}.
    // <P>
    // <b>New record creation</b>
    // <P>
    // By default, editing is restricted to existing records.  Setting +link{listGrid.listEndEditAction} to
    // "next" allows the user to create new records by simply navigating off the end of the dataset
    // with the keyboard.  Editing of new records can also be initiated with
    // +link{listGrid.startEditingNew()}, for example, from a button outside the grid.  See the
    // +link{group:unsavedRecords,Unsaved Records Overview} for special concerns when dealing
    // with unsaved records.
    // <P>
    // <b>Saving changes</b>
    // <P>
    // Saving of changes is triggered automatically when the user navigates out of the row or cell
    // being edited (based on +link{listGrid.saveByCell}) or when the user ends editing.   For
    // a "mass update" interface, automatic saving of changes can be disabled entirely via
    // +link{listGrid.autoSaveEdits,autoSaveEdits:false}, in which case a manual call to
    // +link{listGrid.saveEdits,saveEdits()} or +link{listGrid.saveAllEdits,saveAllEdits()} is required
    // to trigger saving.
    // <P>
    // If a grid has no DataSource, saving means that the properties of the +link{ListGridRecord}s
    // in +link{listGrid.data,grid.data} are directly changed.
    // <P>
    // For a grid with a DataSource, saving will be accomplished by using DataSource "update"
    // operations for existing records, and DataSource "add" operations for new records.  If multiple
    // records have been edited and +link{listGrid.saveAllEdits,saveAllEdits()} is called,
    // +link{rpcManager.startQueue,request queuing} will be automatically used to enable all
    // edits to be saved in one HTTP turnaround (if using the SmartClient Server).
    // <P>
    // By default, a grid will send only updated fields and primaryKey fields as part of
    // +link{dsRequest.data} so that the server can discern which fields the user actually changed.
    // However, the grid always includes the original field values in the
    // dsRequest as +link{dsRequest.oldValues}.
    // <P>
    // Note that although it is possible to load DataSource data without actually declaring a
    // +link{dataSourceField.primaryKey,primaryKey field}, a primaryKey must be declared for
    // editing and saving.  The values of primaryKey fields is how SmartClient identifies the
    // changed record to the server.
    // <P>
    // <b>Validation</b>
    // <P>
    // Any time saving is attempted, validation is automatically triggered.  Values entered by the
    // user will be checked against the +link{listGridField.validators} and the
    // +link{dataSourceField.validators}. Any invalid values abort an attempted save.
    // <P>
    // Similar to editing and saving, validation can be done on row transitions or on cell
    // transitions by setting +link{listGrid.validateByCell,validateByCell}, or can be disabled entirely
    // via +link{listGrid.neverValidate,neverValidate:true}.
    // <P>
    // <b>Editability of cells</b>
    // <P>
    // Editors will either be shown for the complete row or for a single cell based on
    // +link{listGrid,editByCell,editByCell}.  Whether a cell can be edited can be controlled on a
    // per field basis by setting +link{listGridField.canEdit,field.canEdit}, or on a per-record basis
    // by setting +link{listGrid.recordEditProperty,recordEditProperty} on a
    // +link{ListGridRecord,record}, or can be controlled on an arbitrary, programmatic basis via
    // an override of +link{listGrid.canEditCell()}.
    // <P>
    // Cells which are not editable just display the cell's current value.
    // <P>
    // <b>Keyboard Navigation</b>
    // <P>
    // Full keyboard navigation is supported by default, including Tab and Shift-Tab to navigate
    // between cells in a row, and Up Arrow and Down Arrow to traverse rows.  Several properties
    // on both grids and fields, all named *EditAction, control navigation behavior of certain keys
    // (eg Enter).
    // <P>
    // You can use +link{listGrid.startEditing,startEditing(<i>rowNum</i>, <i>colNum</i>)} to
    // programmatically move editing to a particular cell, for example, during a
    // +link{listGridField.changed,field.changed()} event.
    // <P>
    // <b>editValues (unsaved changes)</b>
    // <P>
    // The term "editValues" means changes that the user has made to the dataset which have not
    // been saved.  The grid manages and stores editValues separately from the data itself in order
    // to allow the user to revert to original values, and in order to enable to grid to send only
    // updated fields to the server.
    // <P>
    // Because editValues are stored separately, if you directly access the dataset (eg via
    // <code>grid.getData().get()</code>) you will see the records without the user's unsaved changes.
    // Many APIs exist for retrieving and managing editValues (search for editValue).
    // For the common case of needing to access the record-as-edited, you can call
    // +link{listGrid.getEditedRecord,grid.getEditedRecord(rowNum)}.
    // <P>
    // When accessing and manipulating edited data, you should think carefully about whether
    // you want to be working with the original data or with the edited version.  Values entered
    // by the user may not have been validated yet, or may have failed validation, hence you may
    // find a String value in a field of type "date" or "int", which could cause naive formatters or
    // totaling functions to crash.
    // <P>
    // Setting editValues via APIs such as +link{listGrid.setEditValue()} is fully equivalent
    // to the user making changes to data via the editing UI.  If you <i>also</i> allow editing
    // external to the grid, setting editValues is one way to combine changes from external
    // editors into the grid's edits, so that you can do a single save.
    // <P>
    // <b>Customizing Cell Editors</b>
    // <P>
    // When a cell is being edited, the editor displayed in the cell will be a +link{class:FormItem}.
    // The editor type for the cell will be determined by +link{listGrid.getEditorType()} based on the
    // specified +link{ListGridField.editorType} or +link{ListGridField.type, data type} for the field in
    // question.
    // <P>
    // You can customize the editor by setting +link{listGridField.editorProperties} to a set of
    // properties that is valid for that FormItem type.  Custom FormItem classes are also allowed,
    // for example, you may use +link{formItem.icons} to create an icon that launches a separate
    // +link{Dialog} in order to provide an arbitrary interface that allows the user to select the
    // value for a field.
    // <P>
    // <b>Events</b>
    // <P>
    // Editing triggers several events which you can provide handlers for in order to customize
    // editing behavior.  Some of the most popular are +link{listGridField.change,field.change()},
    // +link{listGridField.changed,field.changed()} for detecting changes made by the user,
    // +link{listGrid.cellChanged()} for detecting changes that have been successfully saved,
    // and +link{listGrid.editorEnter,editorEnter} and +link{listGrid.editorExit,editorExit()}
    // for detecting user navigation during editing.
    // <P>
    // <smartclient>
    // You can also install event handlers directly on the FormItem-based editors used in the grid
    // via +link{listGridField.editorProperties,editorProperties} as mentioned above.  When handling
    // events on items, or which involve items, be aware that in addition to standard
    // +link{FormItem} APIs, editors have the following properties:
    // <P>
    // - <code>rowNum</code>: The rowNum of the record being edited.<br>
    // - <code>colNum</code>: The colNum of the cell being edited.<br>
    // - <code>grid</code>: A pointer back to the listGrid containing the record.
    // </smartclient>
    // <smartgwt>
    // <code>ListGridField.setEditorType()</code> can be used to customize the editors shown
    // for each field, including providing FormItem-specific event handlers.  However,
    // ListGrid-provided event APIs should be used wherever possible (for example, use
    // <code>EditorEnterEvent</code> rather than <code>FocusEvent</code>).  If, in a FormItem
    // event handler, you need access to the ListGrid, you can either declare the event handler
    // as a Java "inner class" in a scope where the ListGrid is available as a final variable,
    // or you can use <code>event.getItem().getContainerWidget()</code>.  Note the ListGrid APIs
    // +link{listGrid.getEditRow,getEditRow()} and +link{listGrid.getEditCol,getEditCol()}
    // indicate what cell is being edited.
    // <P>
    // For more dynamic editor customization, include changing the type of editor used on a
    // per-row basis, use +sgwtLink{listGrid.setEditorCustomizer()}.
    // <P>
    // <b>NOTE:</b> with both APIs, in effect several FormItems are generated from the
    // customized FormItem you provide - see the docs for
    // +link{DataSourceField.editorType()} for special coding patterns that apply in this
    // case.
    // </smartgwt>
    // <P>
    // <b>Binary Fields</b>
    // <P>
    // The ListGrid will automatically show "view" and "download" icon buttons for binary field
    // types (see +link{type:ListGridFieldType}).  However, you cannot use an upload control
    // embedded within a ListGrid row to upload files (regardless of whether you use FileItem or
    // UploadItem).  This is because, in the browser's security model, native HTML upload
    // controls cannot be re-created and populated with a chosen file, and the ListGrid needs
    // to be able to re-create editors at any time in order to handle loading data on scroll,
    // scrolling editors in and out of view, adding new rows, changing sort direction, and
    // other use cases.
    // <P>
    // However you <i>can</i> create an editor with a +link{formItem.icons,FormItem icon} that
    // pops up a separate Window containing a FileItem in a DynamicForm, so long as the form in
    // the Window saves the uploaded file immediately rather than trying to have the grid
    // perform the save.
    //
    // @title Grid Editing
    // @treeLocation Client Reference/Grids/ListGrid
    // @visibility external
    //<



    //> @groupDef unsavedRecords
    // APIs such as +link{listGrid.startEditingNew(),startEditingNew()} or
    // +link{listGrid.listEndEditAction,listEndEditAction:"next"} allow editing records that have not
    // been saved to the server.  These unsaved records are special in several ways:
    // <ul>
    // <li> there is no actual Record object in the dataset for them: <code>getRecord(rowNum)</code>
    // will return null, instead, <code>getEditValues(rowNum)</code> allows access to field values for
    // the unsaved record
    // <li> rows for editing these records always appear at the end of the grid and do not sort with
    // other rows
    // <li> because unsaved records lack an actual Record object and lack a
    // +link{dataSourceField.primaryKey} value, they have limited functionality: they cannot be
    // selected, and do not support +link{listGrid.showRecordComponents} and certain other features.
    // </ul>
    // <P>
    // If you need to work with unsaved records and have all ListGrid features apply to them, this is
    // usually a sign that you should re-think your UI for adding new records.  Consider the following
    // approaches - which works best will depend on the application:
    // <ul>
    // <li> actually save a new record to persistent storage, then start editing it.  This has the
    // advantage that the user will never lose data by exiting the application with unsaved
    // records, which can be important if there is a lot of data entry before the record is ready to
    // save (for example, a new issue report in an issue-tracking applications, or a new blog entry).
    // This is also a good approach if the user may want to get a unique ID for the new record
    // right away (again useful for a new issue report or blog entry).
    // <P>
    // If values for several fields are required before the record should be visible on other screens
    // or to other users, you can add a field to the record to flag it as incomplete so that it is not
    // shown on other screens.  Alternatively, require certain fields to be entered via an external
    // form or dialog before the record is added to the grid.
    // <P>
    // Saving a new record and editing it can be done via +link{DataSource.addData()} followed by a call to
    // +link{listGrid.startEditing()} once the record has been saved.
    // <li> edit new records via a separate +link{DynamicForm,form} instead, possibly in a modal
    // +link{Window} - then unsaved records never need to be shown in the grid.  Similar to the
    // approach above, this modal form might have only certain minimum fields to make a valid
    // new record, then further editing could continue in the grid.
    // <li> use a +link{dataSource.clientOnly,clientOnly DataSource} so that records can be saved
    // immediately without contacting the server.  This is a good approach if several unsaved records
    // need to be manipulated by multiple components before they are finally saved.
    // <li> use +link{DataSource.updateCaches()} with an "add" DSResponse to cause a new record to be
    // added to the grid due to +link{ResultSet,automatic cache synchronization}.  At this point the
    // grid will believe the record exists on the server and it will be treated like any other saved
    // record.  This means your server code will need to handle the fact that the ListGrid will submit
    // "update" DSRequests for any subsequent edits.
    // </ul>
    // <b>NOTE about validation:</b> by design, SmartClient assumes that any record that has been
    // saved is valid and does not validate field values that appear in records loaded from the
    // server.  This includes records added to a clientOnly DataSource via
    // +link{DataSource.setCacheData()} as well as records added due to a call to
    // +link{DataSource.updateCaches()}.
    // <P>
    // Usually the best approach is to avoid this situation by editing such records in a form or other
    // control until they are valid rather than showing invalid records in a grid.  However, if such
    // records need to be considered invalid, one approach is to take field values and add them as
    // editValues via +link{listGrid.setEditValues()}.  At this point the ListGrid will consider the
    // values as user edits and will validate them.
    //
    // @title Handling Unsaved Records
    // @visibility external
    //<

    //> @groupDef imageColumns
    // Columns that show images either as their only appearance or in addition to text.
    //<

    //> @groupDef formulaFields
    // Fields with values calculated from other fields in the grid.
    //<

isc.defineClass("GridBody", isc.GridRenderer).addProperties({
    // suppress adjustOverflow while pending a redraw so we can resize smaller without seeing
    // a scrollbar flash in and out of existence
    adjustOverflowWhileDirty:false,


    _redrawToFixIEFocusScrollArtifacts:isc.Browser.isIE && isc.Browser.version > 9,

    initWidget : function () {
        this.Super("initWidget", arguments);


        if (isc.screenReader) this._redrawToFixIEFocusScrollArtifacts = false;
    },

    fireSelectionUpdated : function () {
        this.grid.fireSelectionUpdated();
    },

    canSelectRecord : function(record) {
        return this.grid.canSelectRecord(record);
    },

    redrawForSelectionChanged : function () {
        this.grid._markBodyForRedraw("selection changed");
    },

    // adjustOverflow() - overridden to support 'autoFitData' behavior
    adjustOverflow : function (reason, a,b,c,d) {
        // If we get naively called while undrawn just call Super which will bail.
        if (!this.isDrawn()) return this.Super("adjustOverflow", arguments);
        // we call 'getDelta' from this method which can fall back through to 'adjustOverflow'
        // Avoid infinite looping if we hit this case.
        if (this._calculatingDelta) return;

        if (this.grid._updatingRecordComponents) {
            return this.Super("adjustOverflow", arguments);
        }


        var grid = this.grid;


        if (grid == null) return this.Super("adjustOverflow", arguments);

        // Invalidate cached scrollHeight / scrollWidth so any calls to getScrollWidth/Height will
        // pick up values reflecting the current rendered HTML
        if (this._scrollWidth != null) delete this._scrollWidth;
        if (this._scrollHeight != null) delete this._scrollHeight;


        var data = grid.data, isLoading = false;;

        if (isc.isA.ResultSet(data) && !data.lengthIsKnown()) {
            if (grid.emptyMessageHeight == null) {
                return this.invokeSuper(isc.GridBody, "adjustOverflow", reason,a,b,c,d);
            }
            isLoading = true;
        }

        var initialWidth = this.getWidth(), initialHeight = this.getHeight();
        var fitVertical = (this.autoFitData == "both"),
            fitHorizontal = fitVertical,
            frozen = grid && grid.frozenFields != null,
            isFrozenBody = frozen && grid && (grid.frozenBody == this);

        if (!fitVertical) fitVertical = (this.autoFitData == "vertical");
        if (!fitHorizontal) fitHorizontal = (this.autoFitData == "horizontal");
        // If we have frozen fields, the frozen body never shows scrollbars and always
        // gets sized to match the widths of the fields it contains (done as part of
        // setBodyFieldWidths). Don't worry about trying to run special auto-fit logic
        // on the frozen body.
        // - We do run auto-fit logic on the unfrozen body and take the size of the frozen
        //   body into account when doing so.
        // - We do still need to ensure the header layout is sized correctly when the frozen
        //   body is resized

        if (fitHorizontal || fitVertical) {
            var height, width, rowHeights, hscrollOn, vscrollOn, dX, dY;

            if (fitVertical) {
                var minHeight = this.grid.getAutoFitMinBodyHeight();
                height = minHeight;
                var totalRows = isLoading ? 0 : this.getTotalRows(),
                    rows = totalRows;

                rowHeights = 0;
                // ignore autoFitMaxRecords if set to zero - this means fit to all records!
                if (this.autoFitMaxRecords) {
                    rows = Math.min(rows, this.autoFitMaxRecords);
                }
                if (rows > 0) {
                    // We need to handle variable rowHeights so we're going to have to look at
                    // the table element to determine the heights - we already have a method to
                    // do that
                    var drawnRowHeights = this._getDrawnRowHeights();
                    // If we have any undrawn rows assume calculated sizes

                    var firstDrawnRow = this._firstDrawnRow,
                        lastDrawnRow = this._lastDrawnRow;



                    // fdr / ldr unset implies no drawn rows - set such that we calculate
                    // theoretical heights only
                    if (this._firstDrawnRow == null) {
                        firstDrawnRow = rows;
                        lastDrawnRow = rows;
                    }
                    // _isFrozenBody defined in GridRenderer
                    var isFrozenBody = this._isFrozenBody();

                    if (firstDrawnRow > 0) {
                        firstDrawnRow = Math.min(firstDrawnRow, rows);
                        for (var i = 0; i < firstDrawnRow; i++) {
                            rowHeights += this.getRowHeight ?
                                            this.getRowHeight(this.grid.getRecord(i), i, isFrozenBody)
                                            : this.cellHeight;
                        }
                    }
                    var lastLogicalRow = rows-1;
                    if (lastDrawnRow < lastLogicalRow) {
                        for (var i = lastDrawnRow+1; i < lastLogicalRow+1; i++) {
                            rowHeights += this.getRowHeight ?
                                            this.getRowHeight(this.grid.getRecord(i), i, isFrozenBody)
                                            : this.cellHeight;
                        }
                    }
                    // Measure the rendered rows and add up the heights.
                    // Note that getDrawnRowHeights() just returns an array of the heights of
                    // rendered rows so the first drawn row is the first entry in the array, not
                    // the _firstDrawnRow'th entry
                    lastDrawnRow = Math.min(lastDrawnRow, lastLogicalRow);
                    for (var i = 0; i <= lastDrawnRow-firstDrawnRow; i++) {
                        rowHeights += drawnRowHeights[i];
                    }
                    // If we are clipping off any rows we know we have a v-scrollbar
                    vscrollOn = totalRows > rows;

                    // Treat autoFitMaxHeight:0 as unspecified - resize as large as necessary
                    var autoFitMaxHeight = this.getAutoFitMaxHeight();
                    if (autoFitMaxHeight && rowHeights > autoFitMaxHeight) {
                        rowHeights = autoFitMaxHeight;
                        vscrollOn = true;
                    }
//                     this.logWarn("total rows to show:"+ rows +
//                      ", rendered:" + [this._firstDrawnRow,this._lastDrawnRow] +
//                      ", rowHeights total up to:"+ rowHeights +
//                      ", current height:" + this.getHeight() +
//                      ", body height based on ListGrid specified height:" + height);

                } else {
                    // The emptyMessage renders in the available space. If emptyMessageHeight
                    // is explicitly set, leave that much space for it.

                    if (this.grid.emptyMessageHeight != null) {
                        rowHeights = this.grid.emptyMessageHeight;
                    }
                }


                // add some extra height if autoFitExtraRecords is set

                if (this.autoFitExtraRecords && this.autoFitExtraRecords > 0) {
                    var extraHeight = Math.round(this.autoFitExtraRecords * this.cellHeight);
                    rowHeights += extraHeight;
                }

            } else {
                vscrollOn = this.getScrollHeight() > this.getHeight();
            }

            if (fitHorizontal && !isFrozenBody) {
                var width = this.grid.getInnerWidth(),
                    frozenBodyWidth;
                if (frozen) {
                    var frozenWidths = this.grid.getFrozenSlots(this.grid._fieldWidths);
                    frozenBodyWidth = frozenWidths.sum();
                    width -= frozenBodyWidth;

                    // if the frozenWidths exceed the specified width for the grid as a whole,
                    // apply an arbitrary small positive min width for the unfrozen body
                }


                // Note that we're calling getColumnSizes on the GridRenderer
                // So if we the LG is frozen body this gives us the cols within the
                // appropriate body, not the total set of cols in the grid.
                var colSizes = this.getColumnSizes(),
                    contentWidth = colSizes.sum();
                if (this.autoFitMaxColumns) {
                    var maxCols = this.autoFitMaxColumns;
                    // bit of a hack - how to deal with maxCols specified as a number <= the
                    // number of frozen fields.
                    // For now we just enforce at least one unfrozen field
                    if (frozen) {
                        maxCols = Math.max(1, maxCols-this.grid.frozenFields.length);
                    }

                    if (maxCols < colSizes.length) {
                        colSizes = colSizes.slice(0, maxCols);
                    }
                }

                var colWidths = colSizes.sum();
                if (this.autoFitMaxWidth) {
                    var maxWidth = this.autoFitMaxWidth;
                    if (frozen) maxWidth = Math.max(20, maxWidth - frozenBodyWidth);
                    colWidths = Math.min(maxWidth, colWidths);
                }
                hscrollOn = (this.overflow == isc.Canvas.SCROLL) ? true :
                            (this.overflow == isc.Canvas.AUTO) ? (contentWidth > Math.max(width, colWidths)) :
                            false;

            } else {
                hscrollOn = this.overflow == isc.Canvas.SCROLL ? true :
                            this.overflow == isc.Canvas.AUTO  ? this.getScrollWidth() > this.getWidth() :
                            false;
            }
            // Now we know if we have an h-scrollbar, adjust height and width for scrollbars /
            // borders / margin if appropriate
            if (fitVertical && rowHeights != null) {
                rowHeights += this.getVBorderPad() + this.getVMarginSize();
                if (hscrollOn) {
                    rowHeights += this.getScrollbarSize();
                    var autoFitMaxHeight = this.getAutoFitMaxHeight()
                    if (autoFitMaxHeight && rowHeights > autoFitMaxHeight) {
                        rowHeights = autoFitMaxHeight;
                    }
                }
                // Resize vertically if rowHeights (+ border etc) > the auto fit min height
                // (which is derived from the ListGrid's specified height)
                if (rowHeights > height) {
                    height = rowHeights;
                    this._vAutoFit = true;
                } else {
                    if (this._vAutoFit) delete this._vAutoFit;
                }
            }
            if (fitHorizontal && !isFrozenBody && colWidths != null) {

                colWidths += this.getHBorderPad() + this.getHMarginSize();
                // If we're showing a vertical scrollbar
                // or we're leaving a scrollbar gap, ensure we autoFit wide enough to
                // accomodate that scrollbar/gap
                if (vscrollOn || this.alwaysShowVScrollbar || this.grid._shouldLeaveScrollbarGap(!!vscrollOn)) {
                    colWidths += this.getScrollbarSize();
                    if (this.autoFitMaxWidth) {
                        var maxWidth = this.autoFitMaxWidth;
                        if (frozen) maxWidth = Math.max(20, maxWidth - frozenBodyWidth);
                        colWidths = Math.min(maxWidth, colWidths);
                    }
                }
                // Resize horizontally if colWidths > width
                if (colWidths > width) {
                    width = colWidths;
                    this._hAutoFit = true;
                } else {
                    if (this._hAutoFit) delete this._hAutoFit;
                }
            }

            // Calculate the delta with our current size.
            this._calculatingDelta = true;
            dY = this.getDelta(this._$height, height, this.getHeight());

            dX = this.getDelta(this._$width, width, this.getWidth());
            delete this._calculatingDelta;
            // If necessary resize to accommodate content!
            if (dY != null || dX != null) {
                this.resizeBy(dX, dY, null, null, true);
            }

            // if width change != null, resize header to match body
            // Note that if isFrozenBody is true we skipped the dX calculation so
            // always resize the headerLayout to match

            if (dX != null || (isFrozenBody && fitHorizontal)) {
                var lg = this.grid,
                    scrollbarSize = lg._shouldLeaveScrollbarGap() ? lg.body.getScrollbarSize() : 0,
                    headerWidth = width - scrollbarSize,
                    totalHeaderWidth = headerWidth;
                if (frozen && lg.headerLayout) {

                    if (isFrozenBody) {
                        totalHeaderWidth = this.getWidth() + lg.body.getWidth();
                        // If we go past the autoFitMaxWidth limit, run adjustOverflow on the body
                        // to force it to shrink/start scrolling
                        if (lg.autoFitMaxWidth != null &&
                            (totalHeaderWidth + lg.getHBorderPad() +
                                lg.getHMarginSize() > lg.autoFitMaxWidth))
                        {
                            // don't bother to go on and resize the header - we'll do that
                            // when the body adjust overflow method runs
                            return lg.body.adjustOverflow();
                        }
                        totalHeaderWidth -= scrollbarSize;

                    } else {
                        totalHeaderWidth = headerWidth + lg.frozenBody.getWidth();
                    }
                    lg.headerLayout.setWidth(totalHeaderWidth);
                }

                // We can skip resizing the frozen header - this is handled in setBodyFieldWidths
                if (!isFrozenBody) {
                    var header = lg.header;

                    if (header && header.isDrawn()) {
                        header.setWidth(headerWidth);
                    }
                }
            }

        // if autoFitData is null but we don't match our 'specified size', assume the property
        // has been modified and reset to specified size
        }

        // catch the case where autoFitData has been cleared in either direction and
        // reset to specified size.
        var verticalChanged = (!fitVertical && this._vAutoFit),
            horizontalChanged = (!fitHorizontal && this._hAutoFit);
        if (verticalChanged || horizontalChanged) {
            delete this._vAutoFit;
            delete this._hAutoFit;

            var standardHeight = verticalChanged ? this.grid.getAutoFitMinBodyHeight() : null,
                standardWidth = horizontalChanged ?
                                (!frozen ? this.grid.getInnerWidth() :
                                    (this.grid.getInnerWidth() - this.grid.frozenBody.getWidth()) )
                                                  : null;
            this.resizeTo(standardWidth,standardHeight);
            // reset userHeight / userWidth to 100%, so future resizes to the LG cause the
            // body to also resize.
            if (!fitVertical) this._userHeight = "100%";
            if (!fitHorizontal) this._userWidth = "100%";
            // reset field widths on the grid to resize the header to match the body
            this.grid._updateFieldWidths("autoFitData mode changed");
        }
        var returnVal = this.invokeSuper(isc.GridBody, "adjustOverflow", reason, a,b,c,d);
        // if size changed, refresh recordComponents to account for new draw area
        if ((fitVertical || fitHorizontal) &&
            (this.getWidth() != initialWidth || this.getHeight() != initialHeight))
        {
            this.grid.updateRecordComponents(true);
        }

        // Fire the "bodyOverflowed" observation. This updates frozen body end space and
        // summary row body right space to so these can keep in sync with body scrolling
        // even though the viewport sizes are different.
        if (!isFrozenBody) this.grid.bodyOverflowed();
        return returnVal;
    },

    getAutoFitMaxHeight : function () {
        return this.grid ? this.grid.getAutoFitMaxBodyHeight() : null;
    },

    // When determining auto-fit-field-widths (drawn size of columns) we render out an
    // offscreen tester containing tableHTML and look at the various cells' widths in a row.
    // If the grid is grouped, we need to choose a row which isn't the group header
    // since that contains col-spanning cells
    _getValidAutoFitRowNum : function () {
        var grid = this.grid;
        if (this.grid && this.grid.isGrouped) {
            var rowNum = 0;
            while (rowNum < this.grid.getTotalRows()) {
                var record = this.grid.getRecord(rowNum);
                if (record == null || !this.grid.isGroupNode(record)) {
                    return rowNum;
                }
                rowNum++;
            }
        }
        return 0;
    },

    // When determining auto-fit-field-widths, avoid adding a pixel to account for
    // rounding errors due to sub-pixel sized rendering coupled with pixel-resolution
    // reported sizes for cells whose content is actually sized to fill the available
    // space

    adjustForSubPixelSizing : function (colNum) {
        var grid = this.grid;
        if (grid._editorShowing || grid.alwaysShowEditors) {
            var fieldNum = grid.getFieldNumFromLocal(colNum, this),
                field = grid.getField(fieldNum),
                nonEditableField = (!field || field.disabled || field.canEdit == false ||
                                    field.type == "summary" ||
                                    (field.canEdit == null &&
                                        (field.userFormula || field.userSummary)));
            if (!nonEditableField && (!grid.editByCell || grid.getEditCol() == fieldNum)) {
                return false;
            }
        }
        return true;
    },

    // Override 'getSizeMayChangeOnRedraw' to return true when autoFitData is set.
    getSizeMayChangeOnRedraw : function () {

        var fitVertical = (this.autoFitData == "both"),
            fitHorizontal = fitVertical;

        if (!fitVertical) fitVertical = (this.autoFitData == "vertical");
        if (!fitHorizontal) fitHorizontal = (this.autoFitData == "horizontal");
        if (fitHorizontal || fitVertical) return true;
        return this.Super("getSizeMayChangeOnRedraw", arguments);
    },

    resizeBy : function (deltaX, deltaY, animating, suppressHandleUpdate, autoFitSize) {

        // autoFitSize parameter: When autoFitData is true for this grid, we resize the
        // body to fit the data, and pass in the autoFitSize parameter to this method.
        // In the case of an explicit resize outside the autoFitData system, hang onto the
        // specified size so we can reset to it if the data shrinks, etc
        if (!autoFitSize) {
            this._specifiedWidth = this.getWidth() + (deltaX != null ? deltaX : 0);
        }

        // Note that return value of resizeBy indicates whether the size actually changed
        var returnVal = this.invokeSuper(isc.GridBody, "resizeBy",
                                deltaX, deltaY, animating, suppressHandleUpdate, autoFitSize);
        // we usually update _userWidth/_userHeight as part of layout.childResized to
        // store the explicit width, which then stops the member reacting to the layout's
        // subsequent resizes.
        // However, if we're autoFitting the (unfrozen) body to content, we want a
        // subsequent resize of the grid as a whole to still cause the body to expand
        // further.
        // Therefore yank out this _userSize flag in this case.
        if (autoFitSize && deltaX != null && !this.frozen) {
            delete this._userWidth;
        }
        return returnVal;
    },

    // context menus (NOTE: ListGrid-level handling is identical for cell vs row context click)
    cellContextClick : function (record, rowNum, colNum) {
        var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
        return this.grid._cellContextClick(record, rowNum, gridColNum);
    },

    // Override _rowClick: If a record is marked as disabled this suppresses all events, but
    // if the user clicks in the "remove" field of an already removed record we actually want
    // to react to this and unmarkAsRemoved()
    _rowClick : function (rowNum, colNum) {
        if (!this.grid) return;
        var returnVal;
        var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);

        var rec = rowNum >= 0 ? this.grid.getRecord(rowNum) : null,
            field = gridColNum >= 0 ? this.grid.getField(gridColNum) : null,
            isRemoveClick = false
        ;

        if (!isc.isA.RecordEditor(this.grid) && field && field.isRemoveField) {
            // If the user clicks inside the remove field on a group or summary row, don't fire
            // the remove-click!
            isRemoveClick = !rec || !(rec._isGroup || rec.isGroupSummary || rec.isGridSummary);
        }

        if (isRemoveClick) {
            if (rowNum >= 0) {
                this.grid.removeRecordClick(rowNum,colNum);
                returnVal = false;
            }
        } else {
            returnVal = this.Super("_rowClick", arguments);
        }
        return returnVal;
    },

    getCellHoverDelay : function (rowNum, colNum) {
        if (!this.grid) return;
        var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
        return this.grid.getCellHoverDelay(this.grid.getCellRecord(rowNum, gridColNum), rowNum,
                                           gridColNum);
    },


    _getCellHoverComponent : function (record, rowNum, colNum) {
        if (this.grid && isc.isA.ListGrid(this.grid)) {
            var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
            return this.grid._getCellHoverComponent(record, rowNum, gridColNum);
        }
    },


    // this ensures that if we're not showing any records we can still scroll the header fields
    // into view.
    expandEmptyMessageToMatchFields:true,
    applyHSpaceToEmptyMessage:true,

    getInnerHTML : function () {
        // call bodyDrawing on the LG if we are the primary body
        this.grid.bodyDrawing(this);
        return this.Super("getInnerHTML", arguments);
    },

    // Override _canFocus to check for whether we have any data.
    _canFocus : function () {
        var canFocus = this.Super("_canFocus", arguments);
        if (canFocus && this.grid && !this.grid.canFocusInEmptyGrid && this.isEmpty()) {
            return false;
        }
        return canFocus;
    },

    // ------------------------------------------------------
    //
    // PrintHTML
    // This needs some tweaking to handle the following:
    // - printHTML can be generated asynchronously in 2 ways:
    //  - if number of rows exceeds printMaxRows we use timers to break up the HTML generation
    //  - if we have embeddedComponents fetching their printHTML may also be asynchronous
    //
    // In either case, 'getTableHTML()' will be fired more than once, asynchronously.
    // In the case of async embedded component printHTML generation, this is the standard
    // mechanism - see 'gotComponentPrintHTML' in GridRenderer.
    // In the case of splitting the printing into chunks, the _printingChunk
    // flag will be set and startRow/endRow will be shifted, then getTableHTML will be called
    // on a timer, repeatedly until all the rows' HTML is generated.
    //
    // We need to fire the 'prepareBodyForPrinting' and 'bodyDonePrinting' methods on the ListGrid
    // around each of these blocks - this is required as the ListGrid relies on the body to
    // handle generating header HTML and if there are frozen fields, HTML from the frozen
    // body, and does so by setting various flags on the GR body which'll be read by
    // getTableHTML()
    //


    getTablePrintHTML : function (context) {
        // context contains startRow, endRow, callback, printProperties, printWidths
        var startRow = context.startRow,
            endRow = context.endRow,
            totalRows = endRow != null ? (endRow - startRow) : this.getTotalRows(),
            maxRows = this.printMaxRows,
            printWidths = context.printWidths,
            printProps = context.printProps;

        var asyncPrintCallback = {
            target:this,
            methodName:"gotTablePrintHTML",
            printContext:context,
            printCallback:context.callback
        }

        context.callback = asyncPrintCallback;

        if (maxRows < totalRows) {
            this.logDebug("get table print html - breaking HTML into chunks", "printing");
            if (startRow == null) startRow = context.startRow = 0;
            if (endRow == null) endRow = context.endRow = this.getTotalRows();
            this.getPrintHTMLChunk(context);

            return null;
        }

        // No chunks - can only be asynchronous due to getTableHTML directly going async
        // to get embeddedComponentHTML
        var suspendPrintingContext = this.grid._prepareBodyForPrinting(printWidths, printProps);
        var printHTML = this.getTableHTML(null, startRow, endRow, null, asyncPrintCallback);

        // restore settings
        this.grid._bodyDonePrinting(suspendPrintingContext);
        return printHTML;
    },

    gotTablePrintHTML : function (HTML, asyncCallback) {
        var callback = asyncCallback.printCallback;
        if (callback) {
            this.fireCallback(callback, "HTML,callback", [HTML,callback]);
        }
    },

    // This is called repeatedly, asynchronously for each "chunk"
    // The first chunk may include fetches for component tableHTML so can also be asynchronous
    // itself.

    getPrintHTMLChunk : function (context, returnSynchronous) {

        var suspendPrintingContext = this.grid._prepareBodyForPrinting(context.printWidths);
        // printing chunk flag - used by the GR to avoid writing out the outer table tags for each
        // chunk.
        this._printingChunk = true;

        // Second flag to indicate we are printing chunks. This is used only by
        // gotComponentPrintHTML() to reset the _printingChunk flag before calling
        // getTableHTML
        this._gettingPrintChunkHTML = true;

        var startRow = context.startRow,
            endRow = context.endRow,
            maxRows = this.printMaxRows,
            callback = context.callback;

        this.currentPrintProperties = context.printProps;

        if (!context.html) context.html = [];

        var chunkEndRow = context.chunkEndRow = Math.min(endRow, (startRow + maxRows)),
            chunkHTML = this.getTableHTML(null, startRow, chunkEndRow, null,
                {target:this, methodName:"gotPrintChunkHTML",
                    printContext:context, printCallback:context.callback
                });

        // restore settings
        this.grid._bodyDonePrinting(suspendPrintingContext);
        this._printingChunk = false;

        // chunkHTML will only be null if getTableHTML went asynchronous - can happen on the
        // first chunk while retrieving embedded componentHTML
        if (chunkHTML != null) {
            delete this._gettingPrintChunkHTML;
            this.gotPrintChunkHTML(chunkHTML, {printContext:context});
            if (returnSynchronous) {
                return chunkHTML;
            }
        }
    },
    gotPrintChunkHTML : function (HTML, callback) {
        var context = callback.printContext,
            startRow = context.startRow,
            endRow = context.endRow,
            chunkEndRow = context.chunkEndRow,
            maxRows = this.printMaxRows,
            gotHTMLCallback = context.callback;

        context.html.add(HTML);

        if (chunkEndRow < endRow) {
            context.startRow = chunkEndRow;
            return this.delayCall("getPrintHTMLChunk", [context], 0);
        }

        if (gotHTMLCallback != null) {
            var html = context.html.join(isc.emptyString);
            this.fireCallback(gotHTMLCallback, "HTML,callback", [html,gotHTMLCallback]);
        }
    },

    // In GridRenderer.getTableHTML(), when printing, we generate all embedded components'
    // print HTML up front, then slot it into the actual HTML for the table.
    // component printHTML may be asynchronously generated in which case this callback is
    // fired when we have the component HTML - default implementation re-runs getTableHTML
    // which now recognizes it's got component HTML and continues to get the actual table
    // HTML then fire the async callback.
    // Overridden to call 'prepareBodyForPrinting()' on the grid and reset the '_printingChunk'
    // flag if necessary
    gotComponentPrintHTML : function (HTML, callback) {

        var asyncCallback = callback.context.asyncCallback,
            context = asyncCallback.printContext;

        var printWidths = context.printWidths;

        var suspendPrintingContext = this.grid._prepareBodyForPrinting(printWidths);
        if (this._gettingPrintChunkHTML) {
            this._printingChunk = true;
        }

        var HTML = this.Super("gotComponentPrintHTML", arguments);
        if (this._printingChunk) delete this._printingChunk;

        if (HTML != null) {
            delete this._gettingPrintChunkHTML;
        } else {
            this.grid._bodyDonePrinting(suspendPrintingContext);
        }

    },

    // override getPrintHeaders / getPrintFooters to return the
    // already calculated HTML set up by the calling grid.

    getPrintHeaders : function (startCol, endCol) {
        var HTML = this._printHeadersHTML;
        // Lazily clean up this attribute.

        delete this._printHeadersHTML;
        return HTML == null ? "" : HTML;
    },

    getPrintFooters : function (startCol, endCol) {
        var HTML = this._printFootersHTML;
        delete this._printFootersHTML;
        return HTML == null ? "" : HTML;
    },

    // Row Spanning Cells
    // ----------------------------




    refreshCellValue : function (rowNum, colNum) {
        var lg = this.grid;
        if (rowNum >= 0 && colNum >= 0 && lg && lg.allowRowSpanning && lg.useRowSpanStyling)
        {
            // If we're asked to refresh a logical cell that's not rendered
            // (actually spanned by another cell) we could either refuse or refresh the
            // spanning cell. Refresh the spanning cell in case its value is calculated
            // from the cell in question.
            var startRow = this.getCellStartRow(rowNum, colNum);
            if (startRow != rowNum) {
                rowNum = startRow;
            }
        }
        isc.GridRenderer._instancePrototype.refreshCellValue.call(this, rowNum, colNum);
    },


    // Cell Alignment
    // ---------------------------------------------------------------------------------------

    // cellAlignment - override to account for the fact that with frozen fields, body
    // colNum may be offset from ListGrid colNum
    getCellVAlign : function (record, field, rowNum, colNum) {
        if (this.grid && this.grid.getCellVAlign) {
            var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
            return this.grid.getCellVAlign(record, rowNum, gridColNum);
        }
    },
    getCellAlign : function (record, field, rowNum, colNum) {

        if (this.grid && this.grid.getCellAlign != null) {
            var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
            return this.grid.getCellAlign(record, rowNum, gridColNum);

        } else return field.cellAlign || field.align;
    },

    // Single Cell rows
    // ---------------------------------------------------------------------------------------

    // if this is removed, DONTCOMBINE directive no longer needed in GridRenderer.js
    _drawRecordAsSingleCell : function (rowNum, record,c) {
        var lg = this.grid;
        if (lg.showNewRecordRow && lg._isNewRecordRow(rowNum)) return true;

        return isc.GridRenderer._instancePrototype.
            _drawRecordAsSingleCell.call(this, rowNum,record,c);
        //return this.Super("_drawRecordAsSingleCell", arguments);
    },

    // showSingleCellCheckboxField()
    // If this record is showing a single cell value, should a checkbox field also show up next
    // to the record?
    showSingleCellCheckboxField : function (record) {
        var lg = this.grid;
        return lg && lg.showSingleCellCheckboxField(record);
    },

    // This method is called on records where _drawRecordAsSingleCell is true
    // returns the start/end col the single cell value should span.
    // Typically just spans all the cells we render out but if we're showing the
    // checkbox field we may want to NOT span over that field
    _getSingleCellSpan : function (record, rowNum, startCol, endCol) {
        // Span all columns if we're not showing a checkbox field

        if (rowNum == this._animatedShowStartRow ||
            !this.showSingleCellCheckboxField(record) ||
            (this.grid && this.grid.frozenBody != null && this.grid.frozenBody != this))
        {
            return [startCol,endCol];
        }


        return [Math.max(startCol, 1), endCol];
    },

    // Scrolling / Scroll Sync
    // ---------------------------------------------------------------------------------------

    // Have v-scrolling occur on the frozen body on mouseWheel
    // This essentially duplicates the mouseWheel handler at the Canvas level for
    // widgets with visible scrollbars.
    mouseWheel : function () {
        if (this.frozen && this.grid != null) {
            var wheelDelta = this.ns.EH.lastEvent.wheelDelta;
            var scrollTo = this.scrollTop + Math.round(wheelDelta * isc.Canvas.scrollWheelDelta);
            // Scroll the main body (we'll scroll in response to that) rather than
            // scrolling the frozen body directly.
            this.grid.body.scrollTo(null, scrollTo, "frozenMouseWheel");
            return false;
        }
        return this.Super("mouseWheel", arguments);
    },

    // Override _getDrawRows()
    // Have the frozen body rely on the unfrozen body to handle drawAhead / quickDrawAhead
    // etc and keep set of drawn rows in sync

    _getDrawRows : function () {
        if (this.frozen && this.grid) {
            var grid = this.grid;
            return grid.body._getDrawRows();
        }
        return this.Super("_getDrawRows", arguments);
    },

    // doneFastScrolling: ensure *both* bodies redraw without draw-ahead direction
    doneFastScrolling : function () {
        // we only expect to see this fire on the unfrozen body - the frozen body doesn't
        // show a scrollbar so won't get the thumb drag which initializes this method
        if (!this.frozen && this.grid != null && this.grid.frozenBody != null) {

            var redrawFrozenBody = this._appliedQuickDrawAhead;
            this.Super("doneFastScrolling", arguments);
            if (redrawFrozenBody) {
                this.grid.frozenBody._suppressDrawAheadDirection = true;
                this.grid.frozenBody.markForRedraw("Done fast scrolling on unfrozen body");
            }
        }
    },

    // observe the scroll routine of the body so we can sync up
    scrollTo : function (left, top, reason, animating) {
        if (isc._traceMarkers) arguments.__this = this;
        // Clamp the positions passed in to the edges of the viewport
        // (avoids the header from getting out of sync with the body.)

        if (left != null) {

            var maxScrollLeft = this.getScrollWidth() - this.getViewportWidth();
            left = Math.max(0, Math.min(maxScrollLeft, left));
        }
        if (top != null) {

            var maxScrollTop = this.getScrollHeight() - this.getViewportHeight();
            top = Math.max(0, Math.min(maxScrollTop, top));
        }
        var lg = this.grid;


        this.invokeSuper(isc.GridBody, "scrollTo", left,top,reason,animating);

        //this.logWarn("body.scrollTo: " + this.getStackTrace());
        // dontReport when we're being called in response to bodyScrolled
        // observation!
        var dontReport = this._noScrollObservation;
        if (!dontReport) lg.bodyScrolled(left, top, this.frozen);

        // If the body scrolled without forcing a redraw, ensure any visible edit form
        // items are notified that they have moved.

        if (!this.isDirty() && lg._editorShowing) {
            var form = lg._editRowForm,
                allItems = form.getItems(),
                items = [];
            for (var i = 0; i < allItems.length; i++) {
                if (allItems[i].isDrawn()) items.add(allItems[i]);
            }
            form.itemsMoved(items);
        }

    },

    // helper to scroll to top without redrawing
    _resetScrollTopBeforeFetch : function () {
        var delayedRedraw = this._delayedRedraw;
        this._delayedRedraw = true;
        this.scrollTo(null, 0);
        this._delayedRedraw = delayedRedraw;
    },

    // Embedded Components
    // ---------------------------------------------------------------------------------------

    // embedded components can be per row or per cell.
    // When per-cell the GR APIs act by colNum only, not by field name.
    // However for us to handle field reorder, show/hide, etc it's useful to hang fieldName
    // onto the embeddedComponents as well
    addEmbeddedComponent : function (component, record, rowNum, colNum, position) {
        var comp = this.invokeSuper(isc.GridBody, "addEmbeddedComponent", component, record,
                                    rowNum, colNum, position);
        if (component._currentColNum != null && component._currentColNum != -1 && this.grid) {
            var grid = this.grid,
                colNum = component._currentColNum,
                gridColNum = grid.getFieldNumFromLocal(colNum, this),
                fieldName = grid.getFieldName(gridColNum);

            component._currentFieldName = fieldName;

            // set up a map of embedded components per column (fieldName)
            // This will make lookup quicker.
            if (grid._columnComponentsMap == null) {
                grid._columnComponentsMap = {};
            }
            if (grid._columnComponentsMap[fieldName] == null) {
                grid._columnComponentsMap[fieldName] = {};
            }
            grid._columnComponentsMap[fieldName][component.getID()] = true;
            // skip "%" sized components since they should never expand a field.
            if (component._percent_width == null) {
                grid._fieldComponentWidthsChanged(fieldName);
            }
        }

        return component;
    },
    removeEmbeddedComponent : function (record, component, suppressRedraw) {
        var grid = this.grid;
        if (grid) {
            var fieldName = component._currentFieldName;
            if (fieldName != null) {
                if (grid._columnComponentsMap && grid._columnComponentsMap[fieldName]) {
                    delete grid._columnComponentsMap[fieldName][component.getID()];
                }
                if (component._percent_width == null) {
                    grid._fieldComponentWidthsChanged(fieldName);
                }
            }
            // Clear out the stored field name which is basically stale at this point.
            component._currentFieldName = null;
        }
        this.invokeSuper(isc.GridBody, "removeEmbeddedComponent", record, component, suppressRedraw);
    },

    // Override bypassCellValueCache - avoid caching edit item cell values
    // This is appropriate for the case where we are writing out inactive
    // element HTML - for example to measure the width of an auto-fit column.

    bypassCellValueCache:function (record,rowNum,colNum) {
        if (this.grid && this.grid._editorShowing) {
            var grid = this.grid,
                editRowNum = grid._editRowNum,
                editStartRow = editRowNum;
            if (editStartRow != null && grid.allowRowSpanning) {
                editStartRow = grid.getCellStartRow(editStartRow, fieldNum);
            }

            var isEditRow = editStartRow == rowNum;
            if (isEditRow) {
                var fieldNum = grid.getFieldNumFromLocal(colNum, this);
                var isEditCell = (!grid.editByCell || grid._editColNum == fieldNum) &&

                              grid.canEditCell(editRowNum, fieldNum);

                if (isEditCell) return true;
            }
        }
        // Default from GridRenderer simply avoids caching the print version
        return this.isPrinting;
    },

    // Override getMaxEmbeddedComponentHeight() / upateHeightForEmbeddedComponents to
    // respect listGrid.recordComponentHeight if specified, even if there are no
    // embedded components for this record.

    updateHeightForEmbeddedComponents : function (record, rowNum, height) {

        if (record && !this.grid._hasEmbeddedComponents(record) && this.grid.showRecordComponents
            && this.grid.recordComponentHeight != null)
        {
            // Reimplementing the superClass version, except that this logic is running even
            // when there are no embeddedComponents on the row.
            var details = this.getMaxEmbeddedComponentHeight(record, rowNum);
            if (details.allWithin) {
                height = Math.max(height,details.requiredHeight);
                //this.logWarn("in updateHeightForEmbeddedComponents ("+this.grid+"): details are "+isc.echoAll(details)+"\nheight is "+height);
            } else {
                height += details.requiredHeight;
                //this.logWarn("in updateHeightForEmbeddedComponents ("+this.grid+"): details are "+isc.echoAll(details)+"\nheight is "+height);
            }

            return height;
        }

        return this.invokeSuper(isc.GridBody, "updateHeightForEmbeddedComponents", record, rowNum, height);
    },

    getMaxEmbeddedComponentHeight : function (record, rowNum) {
        var heightConfig = this.invokeSuper(isc.GridBody, "getMaxEmbeddedComponentHeight",
                                        record, rowNum);
        if (this.grid.showRecordComponents && this.grid.recordComponentHeight != null) {
            heightConfig.requiredHeight = Math.max(heightConfig.requiredHeight,
                                            this.grid.recordComponentHeight);
        }
        return heightConfig;
    },
    _writeEmbeddedComponentSpacer : function (record) {
        if (record && this.grid && this.grid.showRecordComponents
            && this.grid.recordComponentHeight != null)
        {
            return true;
        }
        return this.invokeSuper(isc.GridBody, "_writeEmbeddedComponentSpacer", record);
    },

    _placeEmbeddedComponents : function () {

        if (this.grid && this.grid._autoFittingFields) {
            return;
        }
        return this.Super("_placeEmbeddedComponents", arguments);
    },

    getAvgRowHeight : function () {
        if (this.grid) return this.grid.getAvgRowHeight(this);
        return this.Super("getAvgRowHeight", arguments);
    },

    // override shouldShowAllColumns() - we can avoid showing all columns if row height
    // is variable *only* because of an expansion component expanding the entire row since
    // the heights won't vary per-cell.
    shouldShowAllColumns : function () {
        if (this.showAllColumns) {
            return true;
        }
        if (!this.fixedRowHeights && !this.showAllRows) {
            if (this.grid.canExpandRecords && this.grid._specifiedFixedRecordHeights) {
                return false;
            }
            return true;
        }
        if (this.overflow == isc.Canvas.VISIBLE) {
            return true;
        }
        return false;

    },

    // Editing
    // ---------------------------------------------------------------------------------------

    //> @method listGrid.markForRedraw()
    // @include canvas.markForRedraw
    // @visibility external
    //<

    // Redraw overridden:
    // - Update the editRow form items (we don't create more items than we need when
    //   rendering incrementally)
    // - Update the values in the edit row form.
    redraw : function (reason,b,c,d) {

        // since we're doing a full redraw, cancel pending refreshCell() calls
        if (this._pendingCellRefreshTimer) this.cancelPendingCellRefresh();

        // flag to note we're redrawing - this is used by getDrawnFields()
        this._redrawing = true;

        // Ensure we pick up and size to a fresh value
        // and set the flag so clearCellValueCacheOnRedraw() doesn't
        // clear the cache again.
        // This flag cleared below after Super() call.
        this._clearCellValueCacheForRedraw();
        this._clearedCellValueCacheInRedrawThread = true;

        // If alwaysShowEditors is marked as true, but editorShowing is false it implies our
        // attempt to start editing on draw() failed - presumably there were no
        // editable cells in view.
        // See if we can start editing now in this case
        var lg = this.grid;
        if (lg.alwaysShowEditors && !lg._editorShowing) {
            // pull stashed value for target edit cell if provided
            // by scrollCellIntoView
            var rowNum, colNum;
            if (lg._editCellAfterRedraw) {
                rowNum = lg._editCellAfterRedraw[0];
                colNum = lg._editCellAfterRedraw[1];
                delete lg._editCellAfterRedraw;
            }
            lg.startEditing(rowNum,colNum,true,null,true);
        }


        var editForm = lg._editRowForm,
            editing = lg._editorShowing,
            editColNum, editRowNum, editRecord,
            completeWidths,
            fieldsToRemove;

        // If the grid is showing inactive Editor HTML for any cells, we'll clear it
        // (and potentially regenerate it) as part of redraw(). Notify the grid so it can clear
        // up inactive contexts stored on the edit form items

        lg._clearingInactiveEditorHTML();

        // if body redraw came from data change, folder opening, or resizing of content,
        // it's likely to introduce a v-scrollbar.
        // If leaveScrollbarGap is false, call '_updateFieldWidths()' before the redraw occurs so
        // we leave a gap for the v-scrollbar, rather than redrawing with both V and H scrollbar,
        // then resizing the fields and redrawing without an H-scrollbar.
        if (!lg.leaveScrollbarGap && lg.predictScrollbarGap && (this.overflow == isc.Canvas.AUTO)) {
            var vScrollOn = this.vscrollOn,

                vScrollWillBeOn = !lg.isEmpty() &&
                                  (lg.getTotalRows() * lg.cellHeight)  > this.getInnerHeight();

            if (vScrollOn != vScrollWillBeOn) {
                // ensure we don't try to recalculate field widths a second time by clearing
                // the _fieldWidthsDirty flag
                delete this._fieldWidthsDirty;
                lg._updateFieldWidths("body redrawing with changed vertical scroll-state");

            }
        }

        var suppressRowElementFocus = false;

        if (editing) {
            this.logInfo("redraw with editors showing, editForm.hasFocus: " +
                         editForm.hasFocus, "gridEdit");
            editColNum = lg.getEditCol();

            // See comments near _storeFocusForRedraw() for how edit form item focus is handled
            // on redraw
            this._storeFocusForRedraw();

            // This will add the new edit items corresponding to the newly displayed fields
            // and return the items that need to be removed (after the body is actually redrawn,
            // which will hide them)
            // It also fires the "drawing()", "redrawing()", "clearing()" notifications so items
            // know they're about to be updated in the DOM
            fieldsToRemove = this._updateEditItems();

        // If we're not editing, but we have an editForm with drawn items, fire the 'clearing()' notification.
        // We fire the cleared notification below (after the DOM has been updated)
        } else if (editForm != null) {
            var items = editForm.getItems();
            for (var i = 0; i < items.length; i++) {
                if (items[i].isDrawn()) items[i].clearing(true);
            }

        } else if (isc.screenReader) {
            var focusCanvas = this.ns.EH.getFocusCanvas();
            // Suppress focusing the row element if some other widget is focused.
            suppressRowElementFocus = focusCanvas != null && focusCanvas !== this;

        }
        // refresh field widths if necessary
        if (this._fieldWidthsDirty != null) {

            var fwReason = this._fieldWidthsDirty;
            delete this._fieldWidthsDirty;

            lg._updateFieldWidths(fwReason);
        }
        // store the new drawArea
        var newDrawArea = this.getDrawArea();


        var grid = this.grid,
            drawArea = this._oldDrawArea;

        if (!drawArea) drawArea = this._oldDrawArea = [0,0,0,0];

        var grid = this.grid,
            firstRecord = grid._getCachedCellRecord(newDrawArea[0]),
            lastRecord = grid._getCachedCellRecord(newDrawArea[1]),
            dataPresent = (firstRecord != null && lastRecord != null);

        if (dataPresent && !drawArea.equals(newDrawArea)) {
            // the old and new drawAreas differ and the extents of the new data are present -
            // fire the notification method and update the stored _oldDrawArea

            if (!this.frozen) {
                grid._drawAreaChanged(drawArea[0], drawArea[1], drawArea[2], drawArea[3], this);
                this._oldDrawArea = newDrawArea;
            }
        }


        delete this._drawnEditItems;

        this.invokeSuper(isc.GridBody, "redraw", reason,b,c,d);

        // clear the "redrawing" flag since the HTML is now up to date
        delete this._redrawing;
        // clear the flag indicating we already dropped our body cell-value-cache
        // so we drop cache again (as we should) on future redraws
        delete this._clearedCellValueCacheInRedrawThread;

        // Always update all recordComponents on redraw().
        // don't rely on the draw area changing since we may be showing the same set of
        // rowNum/colNums but having underlying data or field meaning changes.
        // Note: updateRecordComponents() updates components in frozen and unfrozen bodies.
        // If this is a redraw of the frozen body, don't call updateRecordComponents() if
        // the redraw was tripped by scrolling or data change as in this case we'll also
        // get a redraw of the unfrozen body which can handle updating the RC's.
        // (DO still call the method in other cases as it may imply the fields in the frozen
        // body have changed, etc).
        // NOTE 2014: do this *after* calling Super() so that the drawn rows match the
        // data
        if (!(this.frozen && this._suppressRecordComponentsUpdate)) {
            grid.updateRecordComponents();
        }
        this._suppressRecordComponentsUpdate = false;

        if (editing) {
            // Remove the items that correspond to fields that are no longer rendered in the DOM
            if (fieldsToRemove != null && fieldsToRemove.length > 0) {
                editForm.removeItems(fieldsToRemove);
            }

            // Fire the method to notify form items that they have been drawn() / redrawn()
            // or cleared()

            lg._editItemsDrawingNotification(null, true, this);

            /*
            var itemColArray = [],
                items = lg._editRowForm.getItems();
            for (var i =0; i < items.length; i++) {
                itemColArray.add(items[i].colNum + " - " + items[i].name);
            }
            this.logWarn("After redraw - edit form covers these cols:" + itemColArray);
            */


            lg.updateEditRow(lg.getEditRow());

            // If the editRowForm is currently marked as having focus, or we took focus from it
            // before a redraw and no other widget has subsequently picked up focus, restore focus
            // to it
            // This catches both a simple redraw and the case where the user scrolls the edit item
            // out of view, it is cleared due to incremental rendering, then scrolls back into view
            // and it gets redrawn

            if (editForm.hasFocus ||
                (this._editorSelection && isc.EH.getFocusCanvas() == null))
            {
                this._restoreFocusAfterRedraw(editColNum);
            } else {
                delete this._editorSelection;
            }

        } else {
            if (editForm != null) {
                // notify the form that it's items have been cleared() (will no-op if they're
                // not currently drawn)
                lg._editItemsDrawingNotification(null, null, this);
            }

            // _nativeFocusRow was remembered last time putNativeFocusInRow was called

            if (isc.screenReader) {
                this._putNativeFocusInRow(this.getNativeFocusRow(), suppressRowElementFocus);
            }
        }


        if (lg._scrollCell != null) lg._delayedScrollToCell();
    },


    _clearCellValueCacheForRedraw : function () {
        // If we already cleared the cellValueCache in this thread due to our override
        // return

        if (this._clearedCellValueCacheInRedrawThread) return;

        // Also bail if we're doing a redraw thanks to explicit auto-fit rather than
        // data changed
        var grid = this.grid;
        if (grid && (grid._autoFittingField || grid._autoFittingFields)) {
            return;
        }
        return this.Super("_clearCellValueCacheForRedraw", arguments);
    },
    redrawOnScroll : function (immediate) {
        if (this.frozen) this._suppressRecordComponentsUpdate = true;
        return this.Super("redrawOnScroll", arguments);
    },


    _lockVirtualScrolling : function () {
        this.grid._virtualScrollingLocked = true;
    },
    _canStopVirtualScrolling : function () {
        return !this.grid._virtualScrollingLocked;
    },

    // force redraw on setDisabled() if we're showing an edit form to ensure we
    // redraw the items in enabled/disabled state
    setHandleDisabled : function (disabled) {
        var lg = this.grid;
        // need to force redraw generally, so that cell-styles get updated
        if (this.isDrawn()) {
            this.markForRedraw("Grid body disabled");
        }
        return this.Super("setHandleDisabled", arguments);
    },

    // Add edit items corresponding to newly displayed fields (displayed due to incremental
    // rendering)
    // If any fields are to be hidden, do not remove these here, but return them in an array so
    // they can be removed from the form after the redraw completes
    // Note that the order of items in the form will not match the order of fields necessarily -
    // acceptable since developers will be interacting with the items' colNum attribute rather than
    // index in the edit form fields array.

    _updateEditItems : function () {

        // We keep the set of items in the editForm in sync with the set of
        // visible columns for performance.
        // Determine which items need to be created or removed here.
        var lg = this.grid, editForm = lg.getEditForm(),
            fieldsToRemove = [],
            editItems = editForm.getItems();
        if (!lg.editByCell) {

            // set up the vars used in creating form items
            var editRowNum = lg.getEditRow(),
                editRecord = lg.getRecord(editRowNum),

                completeWidths = lg.getEditFormItemFieldWidths(editRecord);

            // Determine what fields are rendered into the body
            // If we have frozen columns, we will always be showing them, in addition to whatever
            // fields are visible
            var editItems = editForm.getItems(),
                itemNames = editItems.getProperty(this.fieldIdProperty),
                fields = lg.getDrawnFields(),
                fieldNames = fields.getProperty(this.fieldIdProperty);

            // minor optimization - if possible, avoid iterating through both arrays
            var lengthsMatch = editItems.length == fields.length,
                changed = false;

            // fields that are no longer drawn should be removed
            for (var i = 0; i < editItems.length; i++) {

                // don't actually remove the items until they have been removed from the DOM via
                // redraw
                var index = fieldNames.indexOf(itemNames[i]),
                    itemDrawn = editItems[i].isDrawn();

                if (index == -1) {
                    changed = true;
                    fieldsToRemove.add(editItems[i]);
                    if (itemDrawn){
                        editItems[i].clearing(true);
                    }
                } else {
                    var fieldName = itemNames[i],
                        // Check canEdit for each field - if it's canEdit:false we don't want to fire
                        // drawing notifications!
                        canEdit = lg.canEditCell(editRowNum, index);

                    if (canEdit) {

                        // If we're keeping the item, just update width, and notify the item we're
                        // about to redraw
                        editItems[i].width = completeWidths[editItems[i].colNum];
                        editItems[i]._size = null;

                        if (!itemDrawn) editItems[i].drawing(true);
                        else editItems[i].redrawing();
                    } else {
                        if (itemDrawn) editItems[i].clearing(true);
                    }
                }
            }

            // newly rendered fields should be added
            if (!lengthsMatch || changed) {
                var editedVals = lg.getEditedRecord(editRowNum, 0);
                for (var i = 0; i < fields.length; i++) {
                    if (!itemNames.contains(fieldNames[i])) {

                        var colNum = lg.fields.indexOf(fields[i]);
                        var item = lg.getEditItem(
                                        fields[i],
                                        editRecord, editedVals, editRowNum,
                                        colNum, completeWidths[colNum]
                                   );
                        editForm.addItem(item);
                        if (editForm._fieldCriteriaCache) {

                            delete editForm._fieldCriteriaCache[fieldNames[i]];
                        }

                        // Notify the item we're about to draw (if the field is editable)
                        var canEdit = lg.canEditCell(editRowNum, colNum);
                        if (canEdit) {
                            editForm.getItem(fieldNames[i]).drawing(true);
                        }
                    }
                }
                // Keep the edit form items in the same order in the items array as
                // they are in the ListGrid.

                editForm.items.sortByProperty("colNum", Array.ASCENDING);
            }
        }
        // if editByCell is true this is not necessary - we consistently have the editForm contain
        // only the necessary cell
        return fieldsToRemove;
    },

    // _storeFocusForRedraw()
    // called when the edit form is showing and the body is being redrawn.
    // remember the current focus state / selection of the edit form so we can reset it after
    // redrawing the item in the DOM
    // blur the item (suppressing the handler if the item will be refocused after redraw)





    _storeFocusForRedraw : function () {

        var lg = this.grid,
            editForm = lg.getEditForm(),
            editColNum = lg.getEditCol();
        if (editForm.hasFocus) {
            var focusItem = editForm.getFocusSubItem();
            if (focusItem) {
                focusItem.updateValue();
                var origFocusItem = focusItem;

                // We may be focused in a sub item, in which case we need to use the
                // parentItem to get the field name wrt our fields array
                while (focusItem.parentItem != null) {
                    focusItem = focusItem.parentItem;
                }

                // blur the focus item before removing it from the DOM.
                // If canEditCell for the current focus item returns false, we will
                // not redisplay it at the end of this method, so allow it to fire the
                // standard blur-handler

                if (!lg.canEditCell(focusItem.rowNum, focusItem.colNum) ||
                    editColNum != focusItem.colNum) {

                    editForm.blur();
                } else {

                    if (focusItem.hasFocus) {
                        // remember the current selection, so we can reset it after the redraw
                        // and refocus. [will have no effect if the item is not a text-item]
                        focusItem.rememberSelection();
                        this._editorSelection =
                            [focusItem._lastSelectionStart, focusItem._lastSelectionEnd];
                    }
                    editForm._blurFocusItemWithoutHandler();

                }

            }
        }

        editForm._setValuesPending = true;
    },

    // If the editForm is visible during a body redraw() this method ensures that after the
    // redraw completes, and the form items are present in the DOM, focus / selection is restored
    // to whatever it was before the redraw
    _restoreFocusAfterRedraw : function (editColNum) {
        var lg = this.grid,
            editForm = lg.getEditForm(),
            editItem = editForm.getItem(lg.getEditorName(lg.getEditRow(), editColNum));
        if (editItem != null && editItem.isDrawn()) {
            var scrollLeft = lg.body.getScrollLeft(),
                scrollTop = lg.body.getScrollTop(),
                viewportWidth = lg.body.getViewportWidth(),
                viewportHeight = lg.body.getViewportHeight(),
                rect = editItem.getRect(),
                // If we are partially out of the viewport, don't put focus into item -
                // forces a native scroll which can interfere with user scrolling.
                // Note: partially out of viewport actually could be ok for text items
                // where focus will only cause a scroll if the actual text is offscreen.

                outOfViewport = rect[0] < scrollLeft ||
                                rect[1] < scrollTop ||
                                rect[0] + rect[2] > (scrollLeft + viewportWidth) ||
                                rect[1] + rect[3] > (scrollTop + viewportHeight);

            if (!outOfViewport) {
                // Avoid selecting the focused value - we don't want rapid keypresses
                // to kill what was previously entered
                editForm._focusInItemWithoutHandler(editItem);
                // Reset the selection / text insertion point to whatever was
                // remembered before the redraw.

                if (this._editorSelection && this._editorSelection[0] != null) {
                    editItem.setSelectionRange(this._editorSelection[0], this._editorSelection[1]);
                }
                // clear up the _editorSelection flag so we don't try to restore focus again on
                // scroll
                delete this._editorSelection;
            }
        }
    },
    // If programmatic 'focus' from "syntheticTabIndex" (IE - tab keypress when the clickMask is up)
    // is called on the ListGrid body and the editor is showing, it
    // makes sense to focus in the edit form.
    focusAtEnd : function (start) {
        var grid = this.grid,
            editForm = grid ? grid.getEditForm() : null;
        if (editForm) {
            editForm.focusAtEnd(start);
        } else {
            return this.Super("focusAtEnd", arguments);
        }
    },

    _suppressEventHandling : function (lastMouseEvent) {
        if (this.Super("_suppressEventHandling", arguments)) return true;
        // If an event occurred over an expansion component, don't react to it at the GridRenderer level

        if (lastMouseEvent) {
            var target = lastMouseEvent.target;
            while (target && target != this) {
                if (target.isExpansionComponent) return true;
                target = target.parentElement;
            }
        }
        return false;
    },

    // Override mouseOut to avoid clearing rollover styling when the user interacts with a
    // child of a CanvasItem editor

    mouseOut : function (a,b,c,d,e) {
        var grid = this.grid;
        if (grid.getEditRow() != null) {
            var editForm = grid.getEditForm();
            var target = isc.EH.getTarget();
            while (target && target.parentElement) {
                if (target.canvasItem != null && editForm.items.contains(target.canvasItem)) {
                    return;
                }
                if (target == this) break;
                target = target.parentElement;
            }
        }
        return this.invokeSuper(isc.GridBody, "mouseOut", a,b,c,d,e);
    },


    // Override cellMove: We need to be able to show validation error HTML
    cellMove : function (record,rowNum,colNum) {
        // If the event is bubbled from an embedded child widget no need to check for
        // icons
        if (isc.EH.lastEvent.target == this) {

            var nativeTarget = isc.EH.lastEvent ? isc.EH.lastEvent.nativeTarget : null;
            if (nativeTarget && nativeTarget.getAttribute != null &&
                (nativeTarget.getAttribute("isErrorIcon") == "true"))
            {
                // adjust for frozen fields
                colNum = this.grid.getFieldNumFromLocal(colNum, this);
                if (this.grid._overErrorIcon != null) {
                    var lastRow = this.grid._overErrorIcon[0],
                        lastCol = this.grid._overErrorIcon[1];
                    if (lastRow != rowNum || lastCol != colNum) {
                        this.grid._handleErrorIconOut(rowNum, colNum);
                    }
                }

                if (this.grid._overErrorIcon == null) {
                    this.grid._handleErrorIconOver(rowNum,colNum);
                }
            } else {
                if (this.grid._overErrorIcon != null) {
                    this.grid._handleErrorIconOut(rowNum, colNum);
                }
            }
        }
    },

    cellOut : function (record, rowNum, colNum) {
        if (this.grid._overErrorIcon != null) {
            this.grid._handleErrorIconOut(rowNum, colNum);
        }
    },

    // Override shouldShowRollOver to avoid styling the current edit cell with the over
    // style.
    // This avoids the issue where if you roll over the edit form items, the rollover style
    // would flash off as the body receives a mouseout (looks very weird).
    // Also - support showing the rollOver styling for the current focus row even if
    // showRollOver is false.
    // We'll still use the rollOver style name in this case, but it improves keyboard accessibility
    // without requiring the normal rollOver effects.
    shouldShowRollOver : function (rowNum, colNum,a,b) {

        //if (!this.invokeSuper(isc.GridBody, "shouldShowRollOver", rowNum,colNum,a,b)) return false;

        var hiliteOnFocus = this.grid.hiliteRowOnFocus;
        if (hiliteOnFocus == null) {
            hiliteOnFocus = this.grid.showRollOver;
        }

        var lg = this.grid;

        if ((!lg.showRollOver &&
             (!hiliteOnFocus || (this._lastHiliteRow != rowNum)))
            || this._rowAnimationInfo)
        {
            return false;
        }

        var record = lg.getRecord(rowNum);

        // Don't show roll over if the record in question doesn't want it.
        if (record && record[lg.recordShowRollOverProperty] === false) {
            return false;
        }

        // don't show rollover for the edit row if editing the whole row
        if (lg._editorShowing && !lg.editByCell && rowNum == lg._editRowNum) {
            return false;
        }

        return true;
    },

    updateRollOver : function (rowNum, colNum, movingToNewCell) {
        var lg = this.grid;

        if (lg.showRollOverCanvas || lg.showRollUnderCanvas) {
            // movingToNewCell param passed when the user rolled off one cell and over another
            // and this method is being called to clear the first cell hilight.
            // we can no-op in this case since we'll update the rollOverCanvas on the subsequent
            // call to this method, and that will avoid a clear/draw cycle (and flash)

            if (!movingToNewCell) {
                var leaving = !(this.lastOverRow == rowNum && this.lastOverCol == colNum);
                var gridColNum = lg.getFieldNumFromLocal(colNum, this);
                lg.updateRollOverCanvas(rowNum, gridColNum, leaving);
            }
            // no support for frozen body / rollOverCanvas yet

        }

        this.setRowStyle(rowNum, null, this.canSelectCells || this.useCellRollOvers ?
                         colNum : null);

        // frozen fields: if there is another body, force its rollover row to match and
        // update it
        var otherBody = (this == lg.body ? lg.frozenBody : lg.body);
        if (otherBody && !this.useCellRollOvers) {
            otherBody.lastOverRow = this.lastOverRow;
            otherBody.lastOverCol = this.lastOverCol;
            otherBody.setRowStyle(rowNum, null, (this.useCellRollOvers ? colNum : null));
        }
    },

    _selectCellOnMouseDown : function (record, rowNum, colNum) {

        this.grid.clearLastHilite();

        // remember the last cell clicked (used for keyboard navigation)
        // (Note: we use the same cell used for selection rather than the actual position
        // of the event as that's where the user will see the visual indication)
        this._lastSelectedRow = rowNum;
        this._lastSelectedCol = colNum;

        this.grid._lastSelectedBody = this;

        //this.logWarn("mouseDown at: " + [rowNum, colNum]);

        if (this.useRowSpanStyling) {
            // rowSpan-sensitive selection
            var gridSelection = this.grid.selection;

            // selected cells are designed by the coordinates where spanning starts.
            // NOTE: this means that calling isSelected() with return false for any cell
            // coordinates where no cell exists in the DOM (because it was spanned over by a
            // rowSpanning cell in a previous row).  This is true even when the spanning cell
            // that eliminated that DOM cell is in facet selected.
            var startRow = this.getCellStartRow(rowNum, colNum);

            // for ctrl-click just select/deselect the clicked cell
            if (isc.EH.modifierKeyDown()) {
                var gridColumn = this.grid.getFieldNumFromLocal(colNum, this);
                gridSelection.selectOnMouseDown(this, startRow, gridColumn);
                return;
            }

            // deselect everything - shift modifiers, dragging or other cases not supported in
            // this mode
            gridSelection.deselectAll();

            // select all cells to the right that are partially or wholly spanned by the
            // clicked cell

            var gridBody, startCol, span,
                mode = this.rowSpanSelectionMode;

            if (mode == "forward" || mode == null) {
                // field num where the click landed, in terms of listGrid.fields
                startCol = this.grid.getFieldNumFromLocal(colNum, this);
                // cells spanned by the clicked cell
                span = this.getCellRowSpan(startRow, colNum);
            } else if (mode == "outerSpan") {
                // optionally, start the selection from the span of the first column, which
                // creates a selection behavior similar to the default row-level selection
                // behavior, based on the concept of the span in the first column defining the
                // "row"
                startCol = 0;
                gridBody = this.grid.getFieldBody(0);
                startRow = gridBody.getCellStartRow(rowNum, 0);
                span = gridBody.getCellRowSpan(startRow, 0);
            } else if (mode == "both") {
                // use the span of the clicked cell
                span = this.getCellRowSpan(startRow, colNum);
                // but go through all columns
                startCol = 0;
            } else {
                this.logWarn("unrecognized rowSpanSelectionMode: '" + mode + "'");
                return;
            }

            //this.logWarn("start cell: " + [startRow, startCol] +
            //             " spans: " + span);
            // for each column to the right of the starting column
            for (var column = startCol; column < this.grid.fields.length; column++) {
                // get the body that contains the field and the field's index within that body
                var bodyToSelect = this.grid.getFieldBody(column),
                    localFieldNum = this.grid.getLocalFieldNum(column);

                // for each row spanned by the starting cell
                for (var i = startRow; i < startRow+span; i++) {
                    // when selecting, select the coordinates of the beginning of the span
                    var cellStartRow = bodyToSelect.getCellStartRow(i, localFieldNum);
                    gridSelection.selectCell(cellStartRow, column);
                    // and skip past cells that were spanned over
                    i += (bodyToSelect.getCellRowSpan(cellStartRow, localFieldNum) - 1);
                }
            }
            return;
        }

        // if we're in the body, select rows or cells
        this.selection.selectOnMouseDown(this, rowNum, colNum);
    },

    // override selectOnMouseDown/Up to disable selection when a row is clicked anywhere
    // besides the checkbox when selectionAppearance is checkbox.
    selectOnMouseDown : function (record, rowNum, colNum, d,e,f) {

        var shouldSelect = true,
            selApp = this.grid.selectionAppearance,
            cbSel = (selApp == "checkbox");
        if (cbSel) {
            // if frozen fields are showing, the cb field will show up in the frozen body!
            if ((this.grid.frozenFields != null && this.grid.frozenBody != this) ||
                (this.grid.getCheckboxFieldPosition() != colNum))
            {
                shouldSelect = false;
            }
        }

        if (shouldSelect) {
            if (this.canSelectCells) this._selectCellOnMouseDown(record, rowNum, colNum);
            else this.invokeSuper(isc.GridBody, "selectOnMouseDown", record, rowNum, colNum, d,e,f);
        }

        if (isc.screenReader) {
            // In screen reader mode, if canSelectCells is enabled, we want to hilite the cell;
            // otherwise, we will want to hilite the entire row.
            // _putNativeFocusInRow() calls _hiliteRecord(), so we will need to clear this hilite.
            this._putNativeFocusInRow(rowNum);
            if (this.canSelectCells) {
                var lastRow = this.lastOverRow,
                    lastCol = this.lastOverCol;
                this.lastOverRow = null;
                this.lastOverCol = null;
                this.updateRollOver(lastRow, lastCol);
                this.grid._lastKeyboardHiliteBody = this;
                this.grid._hiliteCell(rowNum, colNum);
            }
        }
    },

    // When showing the edit clickMask, a mouseDown will clear the mask and end editing
    // before normal mouse-down processing.
    // Override _getMouseDownCell to ensure, even if this caused the row-height to change,
    // we return the cell coords before the change of row-height.
    _getMouseDownCell : function () {
        if (this._maskedMouseDownCell != null) {
            var cell = this._maskedMouseDownCell;
            // clear the property so it doesn't impact future mouseDowns
            this._maskedMouseDownCell = null;
            return cell;
        }
        return this.Super("_getMouseDownCell", arguments);
    },

    // Override mouseUp.
    // If the mouseUp occurred over a CanvasItem, ignore it.

    mouseUp : function () {
        var target = isc.EH.getTarget();

        if (this.grid && target != null && target != this && this.grid._editorShowing) {
            var editForm = this.grid.getEditForm();
            while (target != this && target != null && target != editForm) {
                if (target.canvasItem && editForm.items.contains(target.canvasItem)) {
                    return;
                }
                target = isc.isA.FormItem(target) ? target.containerWidget : target.parentElement;
            }
        }
        return this.Super("mouseUp", arguments);
    },

    selectOnMouseUp : function (record, rowNum, colNum, d,e,f) {
        var cbColNum = this.grid.getCheckboxFieldPosition(),
            selApp = this.grid.selectionAppearance;
        if (selApp != "checkbox" || (selApp == "checkbox" && cbColNum == colNum)) {
            this.invokeSuper(isc.GridBody, "selectOnMouseUp", record, rowNum, colNum, d,e,f);
        }
    },

    // Override handleSelectionChanged() to fire our viewStateChanged method
    handleSelectionChanged : function (record,state) {
        if (this.grid.suppressSelectionChanged) return;
        var returnVal = this.Super("handleSelectionChanged", arguments);
        this.grid.handleViewStateChanged();
        return returnVal;
    },

    setSelection : function (selection) {
        this.clearSelection();
        this.Super("setSelection", arguments);
    },

    clearSelection : function () {
        var selection = this.selection;
        this.Super("clearSelection", arguments);
        // if selection not inherited from ListGrid, destroy it
        if (selection && selection.isA("DependentCellSelection")) {
            selection.destroy();
        }
    },

    _setSeparateCellSelection : function (selection, firstCol) {
        this.clearSelection();
        if (selection) {
            this.selection = selection.getDependentCellSelection(this.fields.length);
            this.selection._updateDependency(firstCol);
            this.observe(this.selection, "selectionChanged", function () {
                this._cellSelectionChanged(this.selection.changedCells);
            });
        }
    },

    // When refreshing cellStyle, notify our edit items that the underlying cell style changed
    // so they can update if necessary
    _updateCellStyle : function (record, rowNum, colNum, cell, className, a,b,c) {
        this.invokeSuper(isc.GridBody, "_updateCellStyle", record, rowNum,colNum,cell,className,a,b,c);
        var lg = this.grid;
        if (lg && lg.getEditRow() == rowNum) {
            var fieldName = lg.getFieldName(lg.getFieldNumFromLocal(colNum, this)),
                form = lg.getEditForm(),
                item = form ? form.getItem(fieldName) : null;
            if (item && item.gridCellStyleChanged) {
                if (className == null) className = this.getCellStyle(record,rowNum,colNum);
                item.gridCellStyleChanged(record, rowNum, colNum, className);
            }
        }

    },

    // hovers: override getHoverTarget to return a pointer to our grid - this allows
    // the developer to call 'updateHover' directly on the grid.
    getHoverTarget : function () {
        return this.grid;
    },

    // direct keyPresses to the ListGrid as a whole to implement arrow navigation,
    // selection, etc

    keyPress : function (event, eventInfo) {
        return this.grid.bodyKeyPress(event, eventInfo);
    },

    // getters for the current keyboard focus row for key-events.

    getFocusRow : function () {
        return this.grid.getFocusRow();
    },
    getFocusCol : function () {
        var colNum = this.grid._getKeyboardClickNum();
        return this.grid.getLocalFieldNum(colNum);
    },


    _restoreFocusForClickMaskHide : function () {
        this._suppressKeyboardNavHiliting = true;
        this.focus();
        delete this._suppressKeyboardNavHiliting;
    },

    // Override _focusChanged to implement 'editOnFocus' - start editing the first
    // editable cell if appropriate.
    // See comments in 'editOnFocus' jsdoc comment for details of how this should work.
    _focusChanged : function (hasFocus) {
        // use the Super implementation to set up this.hasFocus BEFORE we further
        // manipulate focus due to editing.
        var returnVal = this.Super("_focusChanged", arguments);

        var lastEvent = isc.EH.lastEvent;

        // if we're acquiring focus because we're in the middle of a click sequence on the body,
        // the mouse handlers will correctly start editing or place focus on whatever row was hit, and we
        // should do nothing
        if (lastEvent.target == this &&
              (lastEvent.eventType == isc.EH.MOUSE_DOWN ||
               lastEvent.eventType == isc.EH.MOUSE_UP ||
               lastEvent.eventType == isc.EH.CLICK ||
               lastEvent.eventType == isc.EH.DOUBLE_CLICK)) return returnVal;

        // otherwise, entering focus due to a key event (tab, shift-tab) or something else (programmatic
        // including re-focus due to clickMask blur).
        var editCell,
            parent = this.grid;
        if (hasFocus && parent.isEditable()) {

            // editOnFocus enabled, but not currently editing
            if (parent.editOnFocus && parent.isEditable() &&
                parent.getEditRow() == null)
            {
                if (this.logIsInfoEnabled("gridEdit")) {
                    this.logInfo("Editing on focus: eventType: " + lastEvent.eventType +
                                 ", lastTarget " + lastEvent.target, "gridEdit");
                }

                // If we're explicitly suppressing edit on focus, don't start editing.
                if (parent._suppressEditOnFocus) {
                    delete parent._suppressEditOnFocus;
                } else {
                    // this'll run through every cell in every record until it finds one that's
                    // editable
                    var editCell = parent.getFocusCell();

                    var editCellValid = isc.isAn.Array(editCell) && editCell[0] != null &&
                            editCell[0] >= 0 && editCell[1] != null && editCell[1] >= 0 &&
                            parent.canEditCell(editCell[0], editCell[1]);
                    if (!editCellValid) {
                        editCell = parent.findNextEditCell(0,0,true,true);
                    }

                    if (editCell != null) {
                        parent.handleEditCellEvent(editCell[0], editCell[1], isc.ListGrid.FOCUS);
                    }
                }
            }
        }

        // In screenReader mode, if focus is moving into the grid but we're not going into editing mode,
        // put focus onto the row element rather than onto the GR body.

        var hiliteOnFocus = parent.hiliteRowOnFocus;
        if (hiliteOnFocus == null) hiliteOnFocus = parent.showRollOver;
        if (isc.screenReader) {
            if (hasFocus) {
                if (editCell == null) {
                    // find the last hilited row if there is one
                    var rowNum = this.getNativeFocusRow();

                    //this.logWarn("focus entering body - focusing in native row: " + rowNum +
                    //             ", focus row was: " + parent.getFocusRow());
                    this._putNativeFocusInRow(rowNum);
                }
            } else {
                parent.clearLastHilite();
            }
        // Even if we don't have screenReader mode enabled, hilite the current keyboard
        // target row on focus (but don't trigger a click or select it).
        // Also call clearLastHilite() on blur, so we don't show orphaned "over"
        // styling when the user takes focus from the grid
        } else if (hiliteOnFocus) {
            if (hasFocus) {
                // keyboard nav hiliting will be suppressed for focus due to hideClickMask()
                if (editCell == null && !this._suppressKeyboardNavHiliting) {
                    if (parent.canSelectCells) {
                        parent._navigateToNextCell(0, 1, true, true, "focus");
                    } else {
                        parent._navigateToNextRecord(1, true, "focus", true);
                    }
                }
            } else {
                // If the user mouseDowned on an embedded widget, such as a rollOverCanvas,
                // don't clear the hilight or we'll lose the roll-over canvas altogether.
                var mouseDownTarget = isc.EH.mouseDownTarget(),
                    eventType = isc.EH.lastEvent.eventType;
                if (eventType != isc.EH.MOUSE_DOWN || !this.contains(mouseDownTarget)) {
                    parent.clearLastHilite();
                }
            }

        }
        return returnVal;
    },

    // override putNativeFocusInRow to ensure we hilight the focus row
    _putNativeFocusInRow : function (rowNum, suppressFocus) {
        var parent = this.grid;
        // if suppressFocus is passed, we're not actually focusing into the row so don't
        // hilite the row.
        if (parent && parent.hiliteOnNativeRowFocus && !suppressFocus) parent._hiliteRecord(rowNum);
        return this.Super("_putNativeFocusInRow", arguments);
    },

    // override updateRowSelection to update selectionCanvas if necessary
    updateRowSelection : function (rowNum) {
        var lg = this.grid;
        if (!lg) return;



        if (lg.showSelectionCanvas || lg.showSelectionUnderCanvas) lg.updateSelectionCanvas();
        if (lg._dontRefreshSelection) {
            return;
        }

        this.invokeSuper(isc.GridBody, "updateRowSelection", rowNum);

        if (isc.Canvas.ariaEnabled() && lg.selection) {
            this.setRowAriaState(rowNum, "selected", lg.selection.isSelected(lg.getRecord(rowNum), true));
        }

        // with selectionAppearance:"checkbox", detect all rows selected and update checkbox in
        // header
        if (lg.getCurrentCheckboxField() != null) {
            var cellNum = lg.getCheckboxFieldPosition();
            if (lg) {
                lg.refreshCell(rowNum, cellNum);
                lg.updateCheckboxHeaderState();
            }

        } else if (lg.getTreeFieldNum && lg.selectionAppearance == "checkbox") {
            // in the TreeGrid, refresh the tree cell because that's where the checkbox is shown
            var treeCellNum = lg.getTreeFieldNum();
            lg.refreshCell(rowNum, treeCellNum);
        }
    },

    // Fired when selecting a list of entries (for every row)
    // Default implementation marks for redraw
    // Also set up to update SelectionCanvas when the thread completes.
    markForRowSelectionRefresh : function () {
        var lg = this.grid;
        if (!lg) return;
        if (lg.showSelectionCanvas || lg.showSelectionUnderCanvas) {
            lg.fireOnPause("updateSelectionCanvasFromRowRefresh", "updateSelectionCanvas");
        }
        if (lg.getCurrentCheckboxField() != null) {
            lg.fireOnPause("updateCheckboxHeaderFromRowRefresh", "updateCheckboxHeaderState");
        }

        if (lg._dontRefreshSelection) {
            return;
        }
        // This will mark the body for redraw (refreshing the actual styling / checkboxes)
        this.invokeSuper(isc.GridBody, "markForRowSelectionRefresh");
    },

    // ditto with _cellSelectionChanged
    _cellSelectionChanged : function (cellList,b,c,d) {
        var lg = this.grid;
        if (lg != null &&
            (lg.showSelectionCanvas || lg.showSelectionUnderCanvas))
        {
            lg.updateSelectionCanvas();
        }
        return this.invokeSuper(isc.GridBody, "_cellSelectionChanged", cellList, b,c,d);
    },

    // remove any dynamic references that point to us if we're being destroyed
    destroy : function () {
        var grid = this.grid;
        if (this == grid._lastSelectedBody)       grid._lastSelectedBody       = null;
        if (this == grid._lastKeyboardHiliteBody) grid._lastKeyboardHiliteBody = null;
        this.Super("destroy", arguments);
    },

    // Embedded components
    // -----------------------

    // animateShow selectionCanvas / rollOverCanvas if appropriate
    shouldAnimateEmbeddedComponent : function (component) {
        var grid = this.grid;
        if (component == grid.selectionCanvas) return grid.animateSelection;
        if (component == grid.selectionUnderCanvas) return grid.animateSelectionUnder;
        if (component == grid.rollOverCanvas) return grid.animateRollOver;
        if (component == grid.rollUnderCanvas) return grid.animateRollUnder;

        return false;
    },


    _handleEmbeddedComponentResize : function (component, deltaX, deltaY) {
        this.Super("_handleEmbeddedComponentResize", arguments);

        // Notify the grid - allows us to update the other body if we're showing
        // both a frozen and an unfrozen body
        this.grid._handleEmbeddedComponentResize(this, component, deltaX, deltaY);
    },

    // Override draw() to scroll to the appropriate cell if 'scrollCellIntoView' was called
    // before the body was drawn/created
    // Also update the edit form item rows if we're already editing.
    draw : function (a,b,c,d) {
        var lg = this.grid;

        if (lg.getEditRow() != null) {

            var rowNum = lg.getEditRow(),
                record = lg.getRecord(rowNum),
                fieldNum = lg.getEditCol(),
                form = lg._editRowForm,
                items = lg.getEditRowItems(record, rowNum, fieldNum, lg.editByCell),
                liveItems = form.getItems();

            var setItems = liveItems == null || items.length != liveItems.length;
            if (!setItems) {
                var liveItemNames = liveItems.getProperty("name");
                for (var i = 0; i < items.length; i++) {
                    if (!liveItemNames.contains(items[i].name)) {
                        setItems = true;
                        break;
                    }
                }
            }
            if (setItems) {
                this.logDebug("calling setItems on form from body draw","gridEdit");
                form.setItems(items);
            } else {
                this.logDebug("Skipping setItems() on form from body draw", "gridEdit");
            }


            form._setValuesPending = true;

        }


        delete this._drawnEditItems;

        this.invokeSuper(isc.GridBody, "draw", a,b,c,d);

        // If we are showing any edit form items, notify them that they have been written
        // into the DOM.

        if (lg._editRowForm) {
            lg._editItemsDrawingNotification(null, null, this);
        }
        // Tell the form to update its values (setItemValues())
        // (do this after the items have been notified that they're drawn to ensure items'
        // element values are set)
        lg.updateEditRow(lg.getEditRow());

        if (lg._scrollCell != null) lg._delayedScrollToCell();

        // Call 'updateRecordComponents()' on initial draw to set up recordComponents
        // If this is a ResultSet rather than an array, the updateRecordComponents method
        // will be able to skip all records and we'll render out the components on redraw.
        this.grid.updateRecordComponents();

        if (!this._updatingExpansionComponents) this.grid.updateExpansionComponents();
    },

    // rerun ListGrid-level layout if the body's scrolling state changes, to allow sizing
    // the header appropriately
    layoutChildren : function (reason,a,b,c) {
        this.invokeSuper(isc.GridBody, "layoutChildren", reason,a,b,c);
        // This method may be called with "scrolling state change" when a bodyLayout is
        // currently undrawn but drawing out its children - we've seen this in FF 3
        // In this case bail now since if _updateFieldWidths() is fired on an undrawn body it
        // bails, leaving the body mis sized

        if (!this.isDrawn() || (this.grid.frozenFields && !this.grid.bodyLayout.isDrawn())) {
            return;
        }
        var isScrollStateChanged = isc.startsWith(reason, "scrolling state changed"),
            isNewScrollbars = (reason == "introducing scrolling");
        if (isScrollStateChanged || isNewScrollbars) {

            if (this.isRTL() && !this._animatedShowStartRow) {
                this._placeEmbeddedComponents();
            }
        }

        if (isScrollStateChanged) {

            if (this._rowHeightAnimation == null) {
                this.grid.layoutChildren("body scroll changed");
                delete this._scrollbarChangeDuringAnimation;



            } else {
                this._scrollbarChangeDuringAnimation = true;
            }
        }
    },

    // Override rowAnimationComplete to call layoutChildren on the ListGrid if
    // scrollbars were introduced or cleared during animation.
    _rowAnimationComplete : function () {
        this.Super("_rowAnimationComplete", arguments);
        if (this._scrollbarChangeDuringAnimation) {
            this.grid.layoutChildren("body scroll changed during animation");
            delete this._scrollbarChangeDuringAnimation;
        }
    },


    // Override moved to notify any edit form items that they have moved.
    handleMoved : function (a,b,c,d) {
        this.invokeSuper(isc.GridBody, "handleMoved", a,b,c,d);
        this._notifyEditItemsOnMoved();
    },

    handleParentMoved : function (a,b,c,d) {
        this.invokeSuper(isc.GridBody, "handleParentMoved", a,b,c,d);
        this._notifyEditItemsOnMoved();
    },
    _notifyEditItemsOnMoved : function () {

        var lg = this.grid;
        if (lg._editorShowing) {
            var form = lg._editRowForm,
                allItems = form.getItems(),
                items = [];
            for (var i = 0; i < allItems.length; i++) {
                if (allItems[i].isDrawn()) items.add(allItems[i]);
            }
            form.itemsMoved(items);
        }
    },

    // Override show() / hide() / parentVisibilityChanged() / clear() to notify the Edit
    // form items that they have been shown / hidden.
    setVisibility : function (newVisibility,b,c,d) {
        this.invokeSuper(isc.GridBody, "setVisibility", newVisibility,b,c,d);
        var lg = this.grid;
        if (lg._editorShowing) lg._editRowForm.itemsVisibilityChanged();
        if (lg.fieldPickerWindow && newVisibility == "hidden") lg.fieldPickerWindow.hide();
    },

    parentVisibilityChanged : function (newVisibility,b,c,d) {
        this.invokeSuper(isc.GridBody, "parentVisibilityChanged", newVisibility,b,c,d);
        var lg = this.grid;
        if (lg._editorShowing) lg._editRowForm.itemsVisibilityChanged();
    },

    clear : function () {
        var lg = this.grid;
        lg._clearingInactiveEditorHTML();


        delete this._drawnEditItems;
        this.Super("clear", arguments);
        if (lg._editorShowing) {
            // If we're showing the editRow form, notify the items that they have
            // been removed from the DOM.
            lg._editItemsDrawingNotification(null, null, this);

            // Separate mechanism to notify the form that items are no longer visible.

            lg._editRowForm.itemsVisibilityChanged();
        }
    },

    // also notify the edit form items of z index change
    zIndexChanged : function () {
        this.Super("zIndexChanged", arguments);
        var lg = this.grid;
        // Note: setZIndex can be called at init time to convert "auto" to a numeric
        // zIndex - we therefore can't assume that we've been added to the ListGrid as
        // a child yet.
        if (lg && lg._editorShowing) lg._editRowForm.itemsZIndexChanged();

    },
    parentZIndexChanged : function (a,b,c,d) {
        this.invokeSuper(isc.GridBody, "zIndexChanged", a,b,c,d);
        var lg = this.grid;
        if (lg._editorShowing) lg._editRowForm.itemsZIndexChanged();
    },

    // Implement 'redrawFormItem()' - if one of the edit form items asks to redraw
    // we can simply refresh the cell rather than having the entire body redraw
    redrawFormItem : function (item, reason) {
        var lg = this.grid;
        if (lg && (item.form == lg._editRowForm)) {
            // determine which cell
            var row = lg.getEditRow(), col = lg.getColNum(item.getFieldName());

            // If the user has edited the cell, or setValue() has been called on the item
            // we don't want a call to redraw() on the item to drop that value
            if (lg.getEditCol() == col) {
                lg.storeUpdatedEditorValue();
            }

            if (row >= 0 && col >= 0) lg.refreshCell(row, col, false, true);

        } else
            return this.markForRedraw("Form Item Redraw " + (reason ? reason : isc.emptyString));
    },


    sizeFormItem : function (item) {
        var lg = this.grid;
        var width = item.width,
            finalWidth;

        if (isc.isA.String(width)) {
            var fieldWidths = lg.getEditFormItemFieldWidths(item.record),
                fieldWidth = fieldWidths[lg.getFieldNum(item.getFieldName())];
             if (width == "*") {
                finalWidth = fieldWidth;
             } else if (width.charAt(width.length - 1) == "%") {
                var percentWidth = parseInt(width);
                if (isc.isA.Number(percentWidth)) {
                    finalWidth = Math.floor(fieldWidth * (percentWidth / 100));
                }
            }
        }

        var height = item.height,
            finalHeight;
        if (isc.isA.String(height)) {
            var cellHeight = lg.cellHeight;
            if (width == "*") {
                finalHeight = cellHeight;
            } else if (height.charAt(height.length - 1) == "%") {
               var percentHeight = parseInt(height);
               if (isc.isA.Number(percentHeight)) {
                   finalHeight = Math.floor(cellHeight * (percentHeight / 100));
               }
            }
        }
        // Hang the calculated values on the _size attribute as we do when running
        // normal stretch-resize policy in form items.

        if (finalHeight != null || finalWidth != null) {
            item._size = [finalWidth == null ? item.width : finalWidth,
                          finalHeight == null ? item.height : finalHeight];
        }

    },

    //>Animation
    // Override startRowAnimation - if doing a delayed redraw to kick off a row animation
    // to close an open folder, we need to temporarily open the folder again to get the
    // appropriate HTML for the animation rows.
    startRowAnimation : function (show, startRow, endRow, callback, speed, duration,
                                  effect, slideIn, delayed)
    {
        this.finishRowAnimation();

        var shouldOpenFolder = (delayed && (this._openFolder != null)),
            tg = this.grid;

        if (shouldOpenFolder) {
            var wasSuppressed = tg._suppressFolderToggleRedraw;
            tg._suppressFolderToggleRedraw = true;
            tg.data.openFolder(this._openFolder);
            tg._suppressFolderToggleRedraw = wasSuppressed;
        }
        this.Super("startRowAnimation", arguments);
        if (shouldOpenFolder) {
            var wasSuppressed = tg._suppressFolderToggleRedraw;
            tg._suppressFolderToggleRedraw = true;
            tg.data.closeFolder(this._openFolder);
            tg._suppressFolderToggleRedraw = wasSuppressed;
        }
        delete this._openFolder;
    }
    //<Animation
});


isc.ListGrid.addClassProperties({


    //> @type SortArrow
    //          Do we display an arrow for the sorted field ?
    //          @group  sorting, appearance
    //  @value  "none"   Don't show a sort arrow at all.
    //  @value  "corner" Display sort arrow in the upper-right corner (above the scrollbar) only.
    CORNER:"corner",
    //  @value  "field"  Display sort arrow above each field header only.
    FIELD:"field",
    //  @value  "both"   Display sort arrow above each field header AND in corner above scrollbar.
    //BOTH:"both", // NOTE: Canvas establishes this constant
    // @visibility external
    //<
    // NOTE: Canvas established the constant NONE ( == "none")

    //> @type ReorderPosition
    //  Controls where a drag-item should be dropped in relation to the target row
    //  @group dragdrop
    //  @value  ListGrid.BEFORE  Drop the drag-item before the target-row
    BEFORE:"before",
    //  @value  ListGrid.AFTER   Drop the drag-item after the target-row
    AFTER:"after",
    //  @value  ListGrid.OVER    Drop the drag-item over (onto) the target-row
    OVER:"over",
    // @visibility external
    //<

        //> @type RecordDropAppearance
        // Controls how ListGrid record drop events report their
        // +link{listGrid.getRecordDropPosition(),dropPosition}, and where the drop indicator will be displayed
        // if appropriate.
        //
        // @value ListGrid.OVER When the user drops onto a record, dropPosition will always be "over"
        // @value ListGrid.BETWEEN When the user drops onto a record, dropPosition will be either
        //   "before" or "after" depending on whether the mouse was over the top or bottom of
        //   the target record
        BETWEEN: "between",
        // @value ListGrid.BOTH When the user drops onto a record, if the drop occurs centered over the
        //   record, the dropPosition will be reported as "over", otherwise it will be
        //   "before" or "after" depending on whether the mouse was over the top or bottom of the
        //   target record.
        // @value ListGrid.BODY No dropPosition will be reported
        BODY:"body",
        //
        // @visibility external
        //<

        //> @type RecordDropPosition
        // Position of a +link{listGrid.recordDrop} operation with respect to the target record.
        // @value ListGrid.OVER User dropped directly onto the record
        // @value ListGrid.BEFORE User dropped before the record
        // @value ListGrid.AFTER User dropped after the record
        // @value ListGrid.NONE Drop position is not over a record
        //
        // @visibility external
        //<

    //> @type RowEndEditAction
    //  While editing a ListGrid, what cell should we edit when the user attempts to navigate
    //  into a cell past the end of an editable row, via a Tab keypress, or a programmatic
    //  saveAndEditNextCell() call?
    //
    // @value   "same"   navigate to the first editable cell in the same record
    // @value   "next"   navigate to the first editable cell in the next record
    // @value   "done"   complete the edit.
    // @value   "stop"   Leave focus in the cell being edited (take no action)
    // @value   "none"   take no action
    //
    // @visibility external
    // @group editing
    // @see ListGrid.rowEndEditAction
    //
    //<

    //> @type EnterKeyEditAction
    // What to do when a user hits enter while editing a cell
    // @value "done" end editing (will save edit values if +link{listGrid.autoSaveEdits}
    //  is true).
    // @value "nextCell" edit the next editable cell in the record
    // @value "nextRow" edit the same field in the next editable record
    // @value "nextRowStart" edit the first editable cell in next editable record
    //
    // @group editing
    // @visibility external
    //<

    //> @type EscapeKeyEditAction
    // What to do if the user hits escape while editing a cell.
    // @value "cancel" cancels the current edit and discards edit values
    // @value "done" end editing (will save edit values if +link{listGrid.autoSaveEdits}
    //  is true).
    // @value "exit" exit the editor (edit values will be left intact but not saved).
    // @value "ignore" do nothing special when the Escape key is pressed (ie, just ignore it)
    //
    // @group editing
    // @visibility external
    //<

    //> @type EditCompletionEvent
    //          What event / user interaction type caused cell editing to complete.
    //          @visibility external
    //          @group  editing
    //
    //          @value  isc.ListGrid.CLICK_OUTSIDE  User clicked outside editor during edit.
    //          @value  isc.ListGrid.CLICK  User started editing another row by clicking on it
    //          @value  isc.ListGrid.DOUBLE_CLICK  User started editing another row by double
    //                               clicking
    //          @value  isc.ListGrid.ENTER_KEYPRESS Enter pressed.
    //          @value  isc.ListGrid.ESCAPE_KEYPRESS    User pressed Escape.
    //          @value  isc.ListGrid.UP_ARROW_KEYPRESS  Up arrow key pressed.
    //          @value  isc.ListGrid.DOWN_ARROW_KEYPRESS    down arrow key.
    //          @value  isc.ListGrid.TAB_KEYPRESS   User pressed Tab.
    //          @value  isc.ListGrid.SHIFT_TAB_KEYPRESS   User pressed Shift+Tab.
    //          @value  isc.ListGrid.EDIT_FIELD_CHANGE      Edit moved to a different field (same row)
    //          @value  isc.ListGrid.PROGRAMMATIC   Edit completed via explicit function call
    // @visibility external
    //<
    CLICK_OUTSIDE:"click_outside",
    CLICK:"click",
    DOUBLE_CLICK:"doubleClick",
    ENTER_KEYPRESS:"enter",
    ESCAPE_KEYPRESS:"escape",
    UP_ARROW_KEYPRESS:"arrow_up",
    DOWN_ARROW_KEYPRESS:"arrow_down",
    // left/right only used in conjunction with moveEditorOnArrow
    LEFT_ARROW_KEYPRESS:"arrow_left",
    RIGHT_ARROW_KEYPRESS:"arrow_right",
    TAB_KEYPRESS:"tab",
    SHIFT_TAB_KEYPRESS:"shift_tab",
    EDIT_FIELD_CHANGE:"field_change",
    EDIT_ROW_CHANGE:"row_change",
    PROGRAMMATIC:"programmatic",
    // Focus is not a valid edit completion event - focusing in the grid can start an edit
    // if editOnFocus is true but this should not kill an existing edit.
    FOCUS:"focus",

    // GridRenderer passthrough
    // --------------------------------------------------------------------------------------------

    // the following properties, when set on the ListGrid, are applied to the GridBody
    _gridPassthroughProperties : [
        // pass it a selection object (this enables selection behaviors)
        "selection",
        "selectionType",
        "canSelectCells",
        "canDragSelect",
        "canSelectOnRightMouse",
        "recordCanSelectProperty",
        "useNativeTouchScrolling",

        // D&D
        "canDrag",
        "canAcceptDrop",
        "canDrop",

        // table geometry
        "autoFit",
        "wrapCells",
        "cellSpacing",
        "cellPadding",
        "cellHeight",
        "enforceVClipping",
        // autoFitData behavior implemented on GridBody class, not GR class
        "autoFitData",
        "autoFitMaxRecords",
        "autoFitMaxWidth",
        "autoFitMaxColumns",
        "autoFitMaxHeight",
        "autoFitExtraRecords",

        "allowRowSpanning",

        // incremental rendering
        // "showAllRecords" -> showAllRows done elsewhere
        "showAllColumns",
        "drawAllMaxCells",
        "drawAheadRatio",
        "quickDrawAheadRatio",
        "instantScrollTrackRedraw",
        "scrollRedrawDelay",
        "dragScrollRedrawDelay",
        "scrollWheelRedrawDelay",
        "touchScrollRedrawDelay",

        // printing
        "printMaxRows",

        //>Animation
        // If we're doing a speed rather than duration based row animation allow the cap to
        // be specified on the ListGrid / TreeGrid
        // (Note that this is documented in the TreeGrid class).
        "animateRowsMaxTime",
        //<Animation

        // documented by default setting
        "fastCellUpdates",

        // rollover
        "showRollOver",
        "useCellRollOvers",

        // hover
        "canHover",
        "showHover",
        "showClippedValuesOnHover",
        "hoverDelay",
        "hoverWidth",
        "hoverHeight",
        "hoverAlign",
        "hoverVAlign",
        "hoverStyle",
        "hoverOpacity",
        "hoverMoveWithMouse",

        "hoverByCell",
        "keepHoverActive",
        "cellHoverOutset",

        // empty message
        "showEmptyMessage",
        "emptyMessageStyle",
        "emptyMessageTableStyle",

        // offline message
        "showOfflineMessage",
        "offlineMessageStyle",

        // special presentation of records
        "useCellRecords",
        "singleCellValueProperty",
        "isSeparatorProperty",

        // Focus things -- note no need to pass tabIndex through - layouts should auto-manage
        // their members' tab-orders correctly
        "accessKey",
        "canFocus",
        "_useNativeTabIndex",
        "tableStyle",
        "baseStyle",
        "recordCustomStyleProperty",
        "showSelectedStyle",

        // whether to use rowSpan-oriented cell styling behaviors
        "useRowSpanStyling",
        // selection mode when rowSpanning is active
        "rowSpanSelectionMode",

        "showFocusOutline"
    ],

    // the following methods, when called on the LV, will call the same-named method on the
    // GridRenderer (this.body).
    _lv2GridMethods : [
        // this makes it easier to override getCellStyle at the LV level, since you can call
        // these helpers as this.getCellStyleName()
        "getCellStyleName",
        "getCellStyleIndex",

        "_getShowClippedValuesOnHover",

        // setFastCellUpdates explicitly handled
        // in a method which keeps lg.fcu in sync with the
        // body property value
        //"setFastCellUpdates",

        // checking table geometry
        "getRowTop",
        "getRowPageTop",
        "getRowSize",
        "getDrawnRowHeight",

        // row span information
        "getCellStartRow",
        "getCellRowSpan",

        //> @method listGrid.getVisibleRows
        // @include gridRenderer.getVisibleRows()
        // @return (Array of Integer)
        // @visibility external
        //<
        "getVisibleRows",

        //> @method listGrid.getDrawnRows
        // @include gridRenderer.getDrawnRows()
        // @visibility external
        //<
        "getDrawnRows"
    ],

    // styling

    //> @method listGrid.getCellStyle()
    // @include gridRenderer.getCellStyle()
    // @see listGrid.getBaseStyle()
    //<

    // refresh
    //> @method listGrid.refreshCellStyle()
    //  @include    gridRenderer.refreshCellStyle()
    //<

    // events
    //> @method listGrid.cellOver()
    // @include gridRenderer.cellOver()
    //<
    //> @method listGrid.rowOver()
    // @include gridRenderer.rowOver()
    //<

    //> @method listGrid.cellOut()
    // @include gridRenderer.cellOut()
    //<
    //> @method listGrid.rowOut()
    // @include gridRenderer.rowOut()
    //<

    //> @method listGrid.cellHover()
    // @include gridRenderer.cellHover()
    //<
    //> @method listGrid.cellValueHover() ([A])
    // @include gridRenderer.cellValueHover()
    //<
    //> @method listGrid.rowHover()
    // @include gridRenderer.rowHover()
    //<
    //> @method listGrid.cellHoverHTML()
    // @include gridRenderer.cellHoverHTML()
    //<
    //> @method listGrid.cellValueHoverHTML()
    // @include gridRenderer.cellValueHoverHTML()
    //<

    //> @method listGrid.cellContextClick()
    // @include gridRenderer.cellContextClick()
    // @example cellClicks
    //<
    //> @method listGrid.rowContextClick()
    // @include gridRenderer.rowContextClick()
    // @example recordClicks
    //<

    //> @method listGrid.cellMouseDown()
    // @include gridRenderer.cellMouseDown()
    //<
    //> @method listGrid.rowMouseDown()
    // @include gridRenderer.rowMouseDown()
    //<

    //> @method listGrid.cellMouseUp()
    // @include gridRenderer.cellMouseUp()
    //<
    //> @method listGrid.rowMouseUp()
    // @include gridRenderer.rowMouseUp()
    //<

    //> @method listGrid.cellClick()
    // Called when a cell receives a click event.
    // <P>
    // Note that returning false from this method will not prevent any
    // specified +link{listGrid.rowClick} handler from firing.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param   rowNum  (number)    row number for the cell
    // @param   colNum  (number)    column number of the cell
    // @return  (boolean)   whether to cancel the event
    // @visibility external
    // @example cellClicks
    //<

    //> @method listGrid.cellDoubleClick()
    // @include gridRenderer.cellDoubleClick()
    // @example cellClicks
    //<

    // Geometry
    //> @method listGrid.getRowTop()
    // @include gridRenderer.getRowTop()
    // @visibility external
    //<

    //> @method listGrid.getRowPageTop()
    // @include gridRenderer.getRowPageTop()
    // @visibility external
    //<

    // ListGrid / GridBody passthroughs
    // ---------------------------------------------------------------------------------------

    // the following methods, when called on the GridRenderer used as LV.body, call the same-named
    // method on the ListGrid instance itself
    _grid2LVMethods : [

        "getTotalRows",
        "isEmpty",
        "cellIsEnabled",
        "willAcceptDrop",

        // passed scroll change notification through
        "scrolled",

        // native element naming
        "getTableElementId",
        "getRowElementId",
        "getCellElementId",

        // shouldFixRowHeight - enables us to override the ListGrid level 'fixedRecordHeights'
        // for individual rows
        "shouldFixRowHeight",

        "getEmptyMessage",
        "getCanHover",
        // bubble stopHover on the GR up to stopHover here.
        "stopHover",

        "updateEmbeddedComponentZIndex"

        // NOTE: These methods pick up their parameters from the stringMethodRegistry on the
        // GridRenderer class. If expanding this list ensure that any methods that take parameters
        // are registered as stringMethods on that class
    ],

    // used by _invokeKeyboardCopyPasteShortcut for copy/paste between ListGrids
    _cellClipboard : null
});

isc.ListGrid.addClassMethods({
    makeBodyMethods : function (methodNames) {
        var funcTemplate = this._funcTemplate;
        if (funcTemplate == null) {
            funcTemplate = this._funcTemplate = [
                ,


                "this.grid._passthroughBody = this;" +
                "var returnVal = this.grid.",,"(",,");" +
                "this.grid._passthroughBody=null;" +
                "return returnVal;"];
        }

        var methods = {};

        for (var i = 0; i < methodNames.length; i++) {
            var methodName = methodNames[i],
                argString = isc.GridRenderer.getArgString(methodName),


                isCellIsEnabled = (methodName == "cellIsEnabled");

            funcTemplate[0] = "var methodName = '" + methodName + "';\n";

            if (isc.contains(argString, "colNum")) {
                // if there's a colNum argument, map it to the field index in the master
                funcTemplate[0] += "if (this.fields[colNum]) colNum = this.fields[colNum].masterIndex;"

            } else if (isc.isAn.emptyString(argString)) {
                // if there are no arguments, pass the body itself as a means of identifying
                // the calling body
                argString = "body";
                funcTemplate[0] += "body = this;";
            }
            if (isCellIsEnabled) {
                var checkRecord = "if (record === undefined) record = this.grid.getCellRecord(" + argString + ");";
                funcTemplate[0] += checkRecord;
            }

            // create a function that routes a function call to the target object
            funcTemplate[2] = methodName;
            funcTemplate[4] = (isCellIsEnabled ? "record," + argString : argString);
            var functionText = funcTemplate.join(isc.emptyString);

            //this.logWarn("for method: " + methodName + " with argString :"  + argString +
            //             " function text is: " + functionText);

            var method = methods[methodName] = isc._makeFunction(
                (isCellIsEnabled ? argString + ",record" : argString), functionText);
            method._isPassthroughMethod = true;
        }

        return methods;
    },


    classInit : function () {
        // create functions to have methods on the ListGrid's body call methods on the ListGrid
        // itself.  This is partly legacy support: the way to customize body rendering used to
        // be to install functions that controlled body rendering directly on the ListGrid
        // itself.

        // make certain grid methods appear on the LV for convenience, so you don't have to go
        // this.body.someGridMethod()


        this.addMethods(isc.ClassFactory.makePassthroughMethods(
            this._lv2GridMethods, "body"));

        // ----------------------------------------------------------------------------------------
        // create methods that can be installed on the body to call methods on the LV itself, for:
        var passthroughMethods = {};

        // - handlers (like cellOver) and overrides (like getCellCSSText) that we allow to be
        //   defined on the LV but are really grid APIs
        var gridAPIs = isc.getKeys(isc.GridRenderer._gridAPIs),
            passthroughMethods = isc.ListGrid.makeBodyMethods(gridAPIs);

        // - methods the grid needs to fulfill as the drag/drop target, which are really implemented
        //   on the LV
        isc.addProperties(passthroughMethods,
                          isc.ListGrid.makeBodyMethods(this._grid2LVMethods));

        this._passthroughMethods = passthroughMethods;



        // create methods on the ListGrid to act as Super implementations for per-instance
        // overrides of methods where we want to call the original GridRenderer implementation
        // as Super.
        var passBackMethods = {},
            funcTemplate = [
                ,
                // _passthroughBody is set up by the body function that called back up the
                // the grid method - if present, we use it to ensure we call the original
                // implementation on the correct body.
                "var _passthroughBody = this._passthroughBody || this.body;" +
                " if (_passthroughBody == null) {" +
                    "return;" +
                "}" +
                "if(_passthroughBody.__orig_",,")return _passthroughBody.__orig_",,"(",,")"],
            origPrefix  = "__orig_",
            gridProto = isc.GridRenderer.getPrototype();
        for (var i = 0; i < gridAPIs.length; i++) {
            var methodName = gridAPIs[i],
                argString = isc.GridRenderer.getArgString(methodName);
            if (isc.ListGrid.getInstanceProperty(methodName) == null) {

                if (isc.contains(argString, "colNum")) {
                    // if there's a colNum argument, map it to the field index in the body

                    funcTemplate[0] = "if (colNum != null && colNum >= 0) colNum = this.getLocalFieldNum(colNum);"
                } else {
                    funcTemplate[0] = null;
                }
                funcTemplate[2] = funcTemplate[4] = methodName;
                funcTemplate[6] = argString

                passBackMethods[methodName] = isc._makeFunction(argString,
                    funcTemplate.join(isc.emptyString));
                // XXX this would also work, but imposes another Super call penalty, and is
                // odd (call to Super from outside of the object)
                //"return this.body.Super('" + methodName + "', arguments);");
            }

            gridProto[origPrefix + methodName] = gridProto[methodName];
        }
        this._passBackMethods = passBackMethods;
        this.addMethods(passBackMethods);

    },

    // retrieve possibly sorted list of coordinates from a coordinate record
    _getCoordinateList : function (coordinateRecord, sortByCoordinate) {
        var list = [];
        for (var coordinate in coordinateRecord) {
            if (coordinateRecord.hasOwnProperty(coordinate)){
                list.add(parseInt(coordinate));
            }
        }
        if (sortByCoordinate) {
            list.sort(function (a, b) { return a - b; });
        }
        return list;
    }
});

// add default properties to the class
isc.ListGrid.addProperties( {

    //> @attr listGrid.styleName (CSSStyleName : "listGrid" : IRW)
    // Default CSS class for the ListGrid as a whole.
    // @group appearance
    // @visibility external
    //<
    styleName:"listGrid",

    //> @attr listGrid.data (List of ListGridRecord : null : IRW)
    // A list of ListGridRecord objects, specifying the data to be used to populate the
    // ListGrid.  In ListGrids, the data array specifies rows.
    // <p>
    // When using a +link{DataSource}, rather than directly providing <code>data</code>, you will
    // typically call +link{fetchData()} instead, which will automatically establish
    // <code>data</code> as a +link{class:ResultSet,ResultSet} (see the +link{fetchData()} docs for details).
    // <p>
    // If you call <code>fetchData</code>, any previously supplied <code>data</code> is
    // discarded.  Also, it is not necessary to call <code>setData()</code> after calling
    // +link{ListGrid.fetchData()}.
    // <p>
    // When calling <code>setData()</code><smartgwt>,
    // if <code>data</code> is provided as a RecordList or ResultSet</smartgwt>, direct changes
    // to the list using Framework APIs such as <smartclient>+link{list.add()} or
    // +link{list.remove()}</smartclient><smartgwt>+link{RecordList.add()} or
    // +link{RecordList.remove()}</smartgwt> will be automatically observed and the
    // ListGrid will redraw in response.  However, direct changes to individual Records will not
    // be automatically observed and require calls to +link{refreshCell()} or
    // +link{refreshRow()} to cause the ListGrid to visually update.  Calling methods such as
    // +link{ListGrid.updateData()}, +link{removeData()} or +link{addData()} always causes
    // automatic visual refresh.
    // <smartclient><p>
    // Note that direct manipulation of the data object without using the +link{List} APIs (for
    // example by directly assigning a new Record object to some index or calling non-Framework
    // APIs such as pop(), shift(), etc.) will not be reflected in the grid automatically, but
    // developers can call +link{list.dataChanged()} directly to notify the grid of changes.
    // </smartclient>
    //
    // @group data
    // @see ListGridRecord
    // @setter setData()
    // @visibility external
    // @example inlineData
    // @example localData
    //<

    // useCellRecords - Is our data model going to be one record per cell or one record per row?
    useCellRecords:false,

    //> @object ListGridRecord
    // A ListGridRecord is a JavaScript Object whose properties contain values for each
    // +link{ListGridField}.  A ListGridRecord may have additional properties which affect the
    // record's appearance or behavior, or which hold data for use by custom logic or other,
    // related components.
    // <p>
    // For example a ListGrid that defines the following fields:
    // <pre>
    // fields : [
    //     {name: "field1"},
    //     {name: "field2"}
    // ],
    // </pre>
    // Might have the following data:
    // <pre>
    // data : [
    //     {field1: "foo", field2: "bar", customProperty:5},
    //     {field1: "field1 value", field2: "field2 value", enabled:false}
    // ]
    // </pre>
    // Each line of code in the <code>data</code> array above creates one JavaScript Object via
    // JavaScript {type:ObjectLiteral,object literal} notation.  These JavaScript Objects are
    // used as ListGridRecords.
    // <P>
    // Both records shown above have properties whose names match the name property of a
    // ListGridField, as well as additional properties.  The second record will be disabled due to
    // <code>enabled:false</code>; the first record has a property "customProperty" which will
    // have no effect by default but which may be accessed by custom logic.
    // <P>
    // After a ListGrid is created and has loaded data, records may be accessed via
    // +link{listGrid.data}, for example, listGrid.data.get(0) retrieves the first record.
    // ListGridRecords are also passed to many events, such as
    // +link{ListGrid.cellClick,cellClick()}.
    // <P>
    // A ListGridRecord is always an ordinary JavaScript Object regardless of how the grid's
    // dataset is loaded (static data, java server, XML web service, etc), and so supports the
    // normal behaviors of JavaScript Objects, including accessing and assigning to properties
    // via dot notation:
    // <pre>
    //     var fieldValue = record.<i>fieldName</i>;
    //     record.<i>fieldName</i> = newValue;
    // </pre>
    // <P>
    // Note however that simply assigning a value to a record won't cause the display to be
    // automatically refreshed - +link{listGrid.refreshCell()} needs to be called.  Also,
    // consider +link{group:editing,editValues vs saved values} when directly modifying
    // ListGridRecords.
    // <P>
    // See the attributes in the API tab for the full list of special properties on
    // ListGridRecords that will affect the grid's behavior.
    //
    // @treeLocation Client Reference/Grids/ListGrid
    // @see ListGrid.data
    // @inheritsFrom Record
    // @visibility external
    //<



    //> @attr listGrid.recordEnabledProperty (string : "enabled" : IR)
    // Property name on a record that will be checked to determine whether a record is enabled.
    // <P>
    // Setting this property on a record will effect the visual style and interactivity of
    // the record.  If set to <code>false</code> the record (row in a +link{ListGrid} or
    // +link{TreeGrid}) will not highlight when the mouse moves over it, nor will it respond to
    // mouse clicks.
    //
    // @see listGridRecord.enabled
    // @example disabledRows
    // @visibility external
    //<

    recordEnabledProperty: "enabled",

    //> @attr listGridRecord.enabled (boolean : null : IR)
    //
    // Default property name denoting whether this record is enabled. Property name may be
    // modified for some grid via +link{listGrid.recordEnabledProperty}.
    //
    // @visibility external
    // @example disabledRows
    //<

    //> @attr listGrid.canExpandRecordProperty (string : "canExpand" : IR)
    // Property name on a record that will be checked to determine whether a record can be
    // expanded.
    //
    // @see listGridRecord.canExpand
    // @group expansionField
    // @visibility external
    //<
    canExpandRecordProperty: "canExpand",

    //> @attr listGridRecord.canExpand (boolean : null : IR)
    //
    // Default property name denoting whether this record can be expanded. Property name may be
    // modified for the grid via +link{listGrid.canExpandRecordProperty}.
    //
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.recordCanRemoveProperty (String : "_canRemove" : IRA)
    // If set to false on a record and +link{ListGrid.canRemoveRecords,canRemoveRecords} is
    // true, removal of that record is disallowed in the UI. The icon in the remove field
    // is not shown.
    // @group  editing
    // @visibility external
    //<
    recordCanRemoveProperty:"_canRemove",

    //> @attr listGridRecord._canRemove (boolean : null : IRW)
    //
    // Default property name denoting whether this record can be removed. Property name may be
    // modified for the grid via +link{listGrid.recordCanRemoveProperty}.
    //
    // @group  editing
    // @visibility external
    //<

    //> @attr listGridRecord.isSeparator (boolean : null : IR)
    //
    // Default property name denoting a separator row.<br>
    // When set to <code>true</code>, defines a horizontal separator in the listGrid
    // object. Typically this is specified as the only property of a record object, since a
    // record with <code>isSeparator:true</code> will not display any values.<br>
    // Note: this attribute name is governed by +link{ListGrid.isSeparatorProperty}.
    // @visibility external
    //<

    //> @attr listGridRecord.customStyle (CSSStyleName : null : IRW)
    // Name of a CSS style to use for all cells for this particular record.
    // <P>
    // Note that using this property assigns a single, fixed style to the record, so rollover
    // and selection styling are disabled.  To provide a series of stateful styles for a record
    // use +link{listGridRecord._baseStyle} instead.
    // <P>
    // See +link{listGrid.getCellStyle()} for an overview of various ways to customize styling,
    // both declarative and programmatic.
    // <P>
    // If this property is changed after draw(), to refresh the grid call
    // +link{listGrid.refreshRow()} (or +link{listGrid.markForRedraw()} if several rows are
    // being refreshed).
    // <P>
    // If your application's data uses the "customStyle" attribute for something else, the
    // property name can be changed via +link{listGrid.recordCustomStyleProperty}.
    //
    // @visibility external
    //<

    //> @attr listGridRecord._baseStyle (CSSStyleName : null : IRW)
    // Name of a CSS style to use as the +link{listGrid.baseStyle} for all cells for this
    // particular record.
    // <P>
    // The styleName specified with have suffixes appended to it as the record changes state
    // ("Over", "Selected" and so forth) as described by +link{listGrid.getCellStyle()}.  For a
    // single, fixed style for a record, use +link{listGridRecord.customStyle} instead.
    // <P>
    // See +link{listGrid.getCellStyle()} for an overview of various ways to customize styling,
    // both declarative and programmatic.
    // <P>
    // If this property is changed after draw(), to refresh the grid call
    // +link{listGrid.refreshRow()} (or +link{listGrid.markForRedraw()} if several rows are
    // being refreshed).
    // <P>
    // If your application's data uses the "_baseStyle" attribute for something else, the
    // property name can be changed via +link{listGrid.recordBaseStyleProperty}.
    //
    // @visibility external
    //<

    //> @attr listGridRecord.singleCellValue (HTML : null : IRW)
    // Default property name denoting the single value to display for all fields of this row.
    // If this property is set for some record, the record will be displayed as a single
    // cell spanning every column in the grid, with contents set to the value of this
    // property.<br>
    // Note: this attribute name is governed by +link{ListGrid.singleCellValueProperty}.
    // @visibility external
    //<


    //> @attr listGridRecord.canDrag (boolean : null : IR)
    //
    // When set to <code>false</code>, this record cannot be dragged. If canDrag is false for
    // any record in the current selection, none of the records will be draggable.
    //
    // @visibility external
    //<

    //> @attr listGridRecord.canAcceptDrop (boolean : null : IR)
    //
    // When set to <code>false</code>, other records cannot be dropped on (i.e., inserted
    // via drag and drop) immediately before this record.
    //
    // @visibility external
    //<

    //> @attr listGridRecord.linkText (string : null : IRW)
    //
    //  The HTML to display in this row for fields with fieldType set to link. This overrides
    //  +link{attr:listGridField.linkText}.
    //
    //  @see type:ListGridFieldType
    //  @see type:FieldType
    //  @see attr:listGridField.linkText
    //  @see attr:listGrid.linkTextProperty
    //  @group  display_values
    //  @visibility external
    //<

    // Animation
    // ---------------------------------------------------------------------------------------
    // These apply to ListGrid grouping, which basically makes the data model into a Tree where animation
    // is applied for folder open/close.

    //> @attr listGrid.animateFolders (Boolean : true : IRW)
    // If true, when folders are opened / closed children will be animated into view.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    //<
    animateFolders:true,

    //> @attr listGrid.animateFolderMaxRows (integer : null : IRW)
    // If +link{animateFolders} is true for this grid, this number can be set to designate
    // the maximum number of rows to animate at a time when opening / closing a folder.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @see treeGrid.getAnimateFolderMaxRows()
    // @group animation
    // @visibility external
    //<

    //> @attr listGrid.animateFolderTime (number : 100 : IRW)
    // When animating folder opening / closing, if +link{treeGrid.animateFolderSpeed} is not
    // set, this property designates the duration of the animation in ms.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    // @see listGrid.animateFolderSpeed
    //<
    animateFolderTime:100,

    //> @attr listGrid.animateFolderSpeed (number : 3000 : IRW)
    // When animating folder opening / closing, this property designates the speed of the
    // animation in pixels shown (or hidden) per second. Takes precedence over the
    // +link{treeGrid.animateFolderTime} property, which allows the developer to specify a
    // duration for the animation rather than a speed.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    // @see listGrid.animateFolderTime
    //<
    animateFolderSpeed:3000,

    //> @attr listGrid.animateFolderEffect (AnimationAcceleration : null : IRW)
    // When animating folder opening / closing, this property can be set to apply an
    // animated acceleration effect. This allows the animation speed to be "weighted", for
    // example expanding or collapsing at a faster rate toward the beginning of the animation
    // than at the end.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    //<

    //> @attr listGrid.animateRowsMaxTime (number : 1000 : IRW)
    // If animateFolderSpeed is specified as a pixels / second value, this property will cap
    // the duration of the animation.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation_advanced
    //<
    animateRowsMaxTime:1000,

    // external: doc'd on TreeGrid
    shouldAnimateFolder : function (folder) {
        if (!this.animateFolders || !this.isDrawn()) return false;

        if (this.autoFitData == "vertical" || this.autoFitData== "both") return false;

        var children;
        if (this.data.isFolder(folder)) {
            // Since we are only checking whether there are opened children, don't apply sorting
            // (the dontUseNormalizer parameter is true).
            children = this.data.getOpenList(folder, null, null, null, null, null, null, true);
        }

        // No children - bit arbitrary whether we "animate" or not!

        if (children == null || children.length <= 1) return false;
        return (children.length <= this.getAnimateFolderMaxRows());
    },

    // external: doc'd on TreeGrid
    getAnimateFolderMaxRows : function () {
        var maxRows = this.animateFolderMaxRows;
        if (maxRows == null) {
            var vfRs = this.body ? this.body._getViewportFillRows() : [0,0];
            maxRows = Math.min(75, (vfRs[1]-vfRs[0]) * 3);
        }
        return maxRows
    },


    // DataBinding
    // ----------------------------------------------------------------------------------------

    //> @attr listGrid.fields (Array of ListGridField : null : [IRW])
    // An array of field objects, specifying the order, layout, formatting, and
    // sorting behavior of each field in the listGrid object.  In ListGrids, the fields
    // array specifies columns.  Each field in the fields array is a ListGridField object.
    // Any listGrid that will display data should have at least one visible field.
    // <p>
    // If +link{ListGrid.dataSource} is also set, this value acts as a set of overrides as
    // explained in +link{attr:DataBoundComponent.fields}.
    //
    // @see    ListGridField
    // @see    setFields()
    // @group databinding
    // @visibility external
    // @example listGridFields
    // @example mergedFields
    //<

    //> @attr listGrid.defaultFields (Array of ListGridField Properties : null : IRA)
    // An array of listGrid field configuration objects.  When a listGrid is initialized, if this
    // property is set and there is no value for the <code>fields</code> attribute, this.fields will
    // be defaulted to a generated array of field objects duplicated from this array.
    // <P>
    // This property is useful for cases where a standard set of fields will be displayed
    // in multiple listGrids - for example a subclass of ListGrid intended to display a particular
    // type of data:<br>
    // In this example we would not assign a single +link{listGrid.fields} array directly to the
    // class via <code>addProperties()</code> as every generated instance of this class would
    // then point to the same fields array object. This would cause unexpected behavior such as
    // changes to the field order in one grid effecting other grids on the page.<br>
    // Instead we could use <code>addProperties()</code> on our new subclass to set
    // <code>defaultFields</code> to a standard array of fields to display. Each generated instance
    // of the subclass would then show up with default fields duplicated from this array.
    // @visibility external
    //<

    //> @attr   listGrid.dataSource     (DataSource or ID : null : IRW)
    // @include dataBoundComponent.dataSource
    //<

    //> @attr listGrid.autoFetchDisplayMap (Boolean : true : [IRW])
    // If true, for fields where +link{listGridField.optionDataSource} is specified,
    // a valueMap will be automatically created by making a +link{dataSource.fetchData()} call
    // against the specified dataSource and extracting a valueMap from the returned records
    // based on the displayField and valueField.
    // <P>
    // If set to false, valueMaps will not be automatically fetched.  In this case, setting
    // field.optionDataSource is effectively a shortcut for setting optionDataSource on
    // the editor via +link{listGridField.editorProperties}.
    // <P>
    // Can also be disabled on a per-field basis with +link{listGridField.autoFetchDisplayMap}.
    //
    // @group display_values
    // @see listGridField.autoFetchDisplayMap
    // @see listGridField.optionDataSource
    // @visibility external
    //<
    autoFetchDisplayMap:true,

    //> @attr listGrid.warnOnUnmappedValueFieldChange (Boolean : true : IRWA)
    // If a field has +link{listGridField.displayField} specified and has no
    // +link{listGridField.optionDataSource}, this field will display the value from the
    // <code>displayField</code> of each record by default (for more on this behavior
    // see +link{listGridField.optionDataSource}).
    // <P>
    // If such a field is editable, changing the edit value for the field on some record,
    // without updating the edit value for the associated display field on the same record
    // would mean the user would continue to see the unchanged display field value.
    // Developers can resolve this situation by programmatically setting an edit value for
    // the display field as well as the data field, or avoid it by specifying an optionDataSource
    // and ensuring +link{listGrid.autoFetchDisplayMap} is true, or setting an explicit valueMap
    // for the field.
    // <P>
    // By default, when the edit value on a field with a specified displayField and
    // no optionDataSource is set, we log a warning to notify the developer. This warning may
    // be disabled by setting <code>warnOnUnmappedValueFieldChange</code> to <code>false</code>.
    // <P>
    // Note: There are actually a couple of cases in which the system will automatically
    // derive a new display-field value and apply it to the record:
    // <ol><li>If the edit value was changed by a user actually editing the record
    // (rather than a programmatic call to setEditValue()), and the edit-item had
    // a valueMap or optionDataSource set, we automatically pick up the display value from
    // that item and store it as an edit-value for the displayField of the record</li>
    //     <li>If the listGrid has a loaded record in its data set whose valueField value matches
    // the edit value for the valueField, we automatically apply the displayField value from that
    // record as an edit value for the displayField on the newly edited record.</li></ol>
    // In either case, the display value for the record is updated automatically
    // (and the warning would not be logged).
    // @visibility external
    //<
    warnOnUnmappedValueFieldChange:true,

    //or <code>autoFetchDisplayMap</code> is false at
    // the +link{listGrid.autoFetchDisplayMap,listGrid}
    // or +link{listGridField.autoFetchDisplayMap,field} level, the field will display the
    // record value from the +link{

    //> @attr listGrid.saveLocally (boolean : null : IRA)
    // For grids with a specified +link{ListGrid.dataSource}, this property can be set to
    // <code>true</code> to cause the grid directly update its local data set instead of
    // performing an operation against it's configured DataSource.
    // <p>
    // When using this mode, data must be provided to the grid via +link{listGrid.setData()},
    // and must be provided as
    // <smartclient>a simple Array of Records</smartclient>
    // <smartgwt>a RecordList</smartgwt>.  Setting <code>saveLocally</code> is invalid if
    // either +link{fetchData()} is called or if a +link{ResultSet} is provided as the data
    // model.
    // <p>
    // <code>saveLocally</code> mode includes changes made via
    // +link{listGrid.canEdit,inline editing}, record removal via +link{canRemoveRecords}, as
    // well as programmatic calls to +link{listGrid.updateData()},
    // +link{listGrid.addData,addData()} and +link{listGrid.removeData,removeData()}.  This
    // also causes saves to be performed synchronously (unlike normal DataSource operations).
    // <p>
    // Note that using this mode also disables the automatic cache synchronization provided by
    // the DataSource system - changes made to this grid are saved only to this grid's data
    // set.
    // <P>
    // See also +link{listGrid.filterLocalData} to allow filtering, such as filtering performed
    // by the +link{filterEditor}, to also work only with the local data set.
    // <P>
    // If saveLocally is unset, and +link{listGrid.filterLocalData} is true, the saveLocally behavior is
    // enabled by default
    //
    // @see useRemoteValidators
    // @visibility external
    // @group databinding
    //<


    //> @attr ListGrid.saveRequestProperties (DSRequest Properties : null : IRWA)
    // For editable grids with a specified +link{listGrid.dataSource}, where
    // +link{listGrid.saveLocally} is false, this attribute may be used to specify standard
    // DSRequest properties to apply to all save operations performed by this grid (whether
    // triggered by user interaction, or explicit saveEdits or saveAllEdits call).
    // <P>
    // An example usage would be to customize the prompt displayed while saving is in progress
    // if +link{listGrid.waitForSave} is true.
    // <P>
    // Note that for more advanced customization of save operations,
    // +link{dataBoundComponent.addOperation} and +link{dataBoundComponent.updateOperation}
    // are available to developers, allowing specification of an explicit +link{operationBinding}
    // for the add / update operation performed on save.
    //
    // @visibility external
    // @group dataBinding
    // @group editing
    //<

    //> @attr ListGrid.useRemoteValidators (boolean : null : IRWA)
    // If +link{listGrid.saveLocally} is specified, but this grid is bound to a DataSource which
    // includes remote field validators, by default edits will be saved synchronously and
    // these validators will not be executed.<br>
    // Set this property to <code>true</code> to ensure these remote validators are called when
    // saving edits in saveLocally mode. Note that since these remote validators need to run on
    // the server, saving with this property set is asynchronous, even though the data that
    // ultimately gets updated is already present on the client.
    // @visibility external
    // @group databinding
    //<

    //> @attr listGrid.useAllDataSourceFields (boolean : null : IRW)
    // @include dataBoundComponent.useAllDataSourceFields
    // @group databinding
    //<

    //> @attr listGrid.showDetailFields (Boolean : true : IR)
    // Whether to include fields marked <code>detail:true</code> from this component's
    // <code>DataSource</code>.
    // <P>
    // When this property is <code>true</code>, the <code>ListGrid</code> will include all
    // detail fields unless fields have been specifically declared using the
    // +link{listGrid.fields} array.
    // <P>
    // Any field which has been included directly in the <code>fields</code> array will be
    // included regardless of the fields <code>detail</code> attribute.
    // <p>
    // Detail fields included will initially be hidden but the user may show these fields via
    // the default header context menu (+link{listGrid.showHeaderContextMenu}).
    // <P>
    // The field's visibility can also be overridden programatically using the standard
    // +link{listGrid.showField()}, +link{listGrid.hideField()} and +link{listGridField.showIf}
    // APIs, for example, set showIf:"true" to show a detail field initially.
    // <P>
    // Setting this property to false will completely exclude all detail fields from the list
    // grid's fields array, such that they cannot be shown by the user or programmatically.
    //
    // @group databinding
    // @visibility external
    //<
    showDetailFields:true,

    //> @attr ListGrid.titleField (string : see below : IRW)
    // Best field to use for a user-visible title for an individual record from this grid.
    // If +link{ListGrid.dataSource} is non null, this property may be specified on the
    // dataSource instead.
    // <p>
    // If not explicitly set, titleField looks for fields named "title", "name", and "id"
    // in that order.  If a field exists with one of those names, it becomes the titleField.
    // If not, then the first field is designated as the titleField.
    //  @visibility external
    //<

    //> @attr listGrid.dataProperties (ResultSet : null :IRWA)
    // For databound ListGrids, this attribute can be used to customize the +link{ResultSet}
    // object created for this grid when data is fetched
    // @group databinding
    // @visibility external
    //<

    // Grouping
    // ---------------------------------------------------------------------------------------

    //> @object groupNode
    //
    // An auto-generated subclass of +link{TreeNode} representing the group nodes
    // in a grouped +link{ListGrid}.
    //
    // @see listGrid.groupBy()
    // @treeLocation Client Reference/Grids/ListGrid
    // @group grouping
    // @visibility external
    //<

    //> @attr groupNode.groupMembers (Array of ListGridRecord or GroupNode : see below : R)
    // Array of ListGridRecord that belong to this group, or, for multi-field grouping, array
    // of groupNodes of subgroups under this groupNode.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr groupNode.groupTitle (HTML : see below : R)
    // The computed title for the group, which results from +link{listGridField.getGroupTitle()}
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr groupNode.groupValue (any : see below : R)
    // The value from which groups are computed for a field,
    // which results from +link{listGridField.getGroupValue()}
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr listGrid.originalData (object : null : R)
    // When grouped, a copy of the original ungrouped data.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr listGrid.groupTree (AutoChild Tree : null : R)
    // The data tree that results from a call to  +link{listGrid.groupBy()}.
    // This will be a +link{ResultTree} if +link{listGrid.dataSource} is
    // present, otherwise it will be a +link{Tree}.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @type GroupStartOpen
    // Possible values for the state of ListGrid groups when groupBy is called
    //
    // @value "all" open all groups
    // @value "first" open the first group
    // @value "none" start with all groups closed
    // @visibility external
    //<

    //> @attr listGrid.groupStartOpen (GroupStartOpen | Array : "first" : IRW)
    // Describes the default state of ListGrid groups when groupBy is called.
    //
    // Possible values are:
    // <ul>
    // <li>"all": open all groups
    // <li>"first": open the first group
    // <li>"none": start with all groups closed
    // <li>Array of group values that should be opened
    // </ul>
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    groupStartOpen:"first",

    //> @attr listGrid.canCollapseGroup (Boolean : true : IR)
    // Can a group be collapsed/expanded? When true a collapse/expand icon is shown
    // (+link{groupIcon,groupIcon}) and the user can collapse or expand the group by
    // clicking either the row as a whole or the opener icon (see +link{collapseGroupOnRowClick});
    //
    // When false the group icon is not shown and clicking on the row does
    // not change group state. Additionally +link{groupStartOpen,groupStartOpen} is
    // initialized to "all".
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    canCollapseGroup:true,

    //> @attr listGrid.collapseGroupOnRowClick (boolean : true : IR)
    // If +link{canCollapseGroup} is true, will a click anywhere on the group row
    // toggle the group's expanded state? If false, the user must click the
    // +link{groupIcon} directly to toggle the group.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    collapseGroupOnRowClick:true,

    //> @attr listGrid.groupTitleField (String : null : IR)
    // When a list grid is +link{listGrid.groupBy(),grouped}, each group shows
    // under an auto generated header node. By default the title of the group will be
    // shown, with a hanging indent in this node, and will span all columns in the grid.
    // Setting this property causes the titles of auto-generated group nodes to appear as
    // though they were values of the designated field instead of spanning all columns
    // and record values in the designated groupTitleField will appear indented under
    // the group title in a manner similar to how a TreeGrid shows a Tree.
    // <P>
    // Note if +link{listGrid.showGroupSummaryInHeader} is true, the header nodes will not show
    // a single spanning title value by default - instead they will show the summary values for
    // each field. In this case, if groupTitleField is unset, a
    // +link{listGrid.showGroupTitleColumn,groupTitleColumn} can be automatically generated to
    // show the title for each group.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    getGroupTitleField : function () {
        return this.groupTitleField;
    },

    //> @attr listGrid.showGroupTitleColumn (Boolean : true : IR)
    // If this grid is +link{listGrid.groupBy(),grouped} and +link{listGrid.showGroupSummaryInHeader}
    // is true, instead of group header nodes showing up with a single cell value spanning the full
    // set of columns, summaries for each field will show up in the appropriate columns of the
    // header node.
    // <P>
    // In this case there are 2 options for where the group title will show up. Developers may
    // specify an existing field to put the title values into via +link{listGrid.groupTitleField}.
    // If no groupTitleField is specified, this property may be set to <code>true</code>
    // which causes a <code>groupTitleColumn</code> to be automatically generated.
    // Each group header will show the group title in this column (records within the group will
    // not show a value for this column). The column appears in the leftmost position within the
    // grid (unless +link{listGrid.showRowNumbers} is true, in which case this column shows up
    // in the second-leftmost position), and by default will auto-fit to its data.
    // <P>
    // To customize this field, developers may modify
    // +link{listGrid.groupTitleColumnProperties}
    // <smartclient>or
    // +link{listGrid.groupTitleColumnDefaults} at the class level.</smartclient>
    // @visibility external
    //<
    showGroupTitleColumn:true,

    //> @attr listGrid.groupTitleColumnProperties (ListGridField properties : null : IR)
    // Custom properties for the automatically generated <code>groupTitleColumn</code>.
    // <P>
    // See +link{listGrid.showGroupTitleColumn} for an overview of the groupTitleColumn.
    // @visibility external
    //<
    //groupTitleColumnProperties:null,

    //> @attr listGrid.groupTitleColumnDefaults (ListGridField properties : object : IR)
    // Default properties for the automatically generated <code>groupTitleColumn</code>.
    // Default object includes properties to enable autoFitWidth to group title values.
    // <P>
    // To modify the behavior or appearance of this column, developers may set
    // +link{listGrid.groupTitleColumnProperties} at the instance level, or override this
    // object at the class level. If overriding this object, we recommend using
    // +link{class.changeDefaults()} rather than replacing this object entirely.
    // <P>
    // See +link{listGrid.showGroupTitleColumn} for an overview of the groupTitleColumn.
    // @visibility external
    //<
    groupTitleColumnDefaults:{
        canEdit:false,
        canFilter:false,
        canHide:false,
        canReorder:false,
        showDefaultContextMenu:false,
        autoFreeze:true,

        sortNormalizer:function (recordObject,fieldName,context) {
            return recordObject.groupTitle;
        },

        autoFitWidth:true,
        autoFitWidthApproach:"value",
        title:"&nbsp;"
    },

    // We actually show the special group title column if
    // - we're showing the group summary in the header
    // - we have no explicitly specified group title field
    // - the showGroupTitleColumn flag is true
    showingGroupTitleColumn : function () {
        return (this.isGrouped && this.showGroupSummary && this.showGroupSummaryInHeader
                && this.showGroupTitleColumn && this.getGroupTitleField() == null);
    },

    // groupTitleColumnName: This could be modified to display an actual field within the
    // grid data, but the developer might as well use groupTitleField instead.
    // Leaving unexposed for now.
    groupTitleColumnName:"groupTitle",

    getGroupTitleColumn : function () {
        var grid = this;
        var groupTitleColumn = isc.addProperties(
            {   _isGroupTitleColumn:true,
                // 'grid' available through closure
                getAutoFreezePosition: function () { return grid.getGroupTitleColumnPosition() }
            },
            this.groupTitleColumnDefaults,
            this.groupTitleColumnProperties
        );

        if (groupTitleColumn.name == null) {
            groupTitleColumn.name = this.groupTitleColumnName;
        }
        return groupTitleColumn;
    },

    getGroupTitleColumnPosition : function () {
        // This is really just a sanity check - we don't expect to be calling this method when
        // we're not showing the special groupTitleColumn
        if (!this.showingGroupTitleColumn()) return -1;


        var pos = 0;
        if (this.shouldShowRowNumberField()) pos++;
        if (this.shouldShowCheckboxField()) pos++;
        if (this.shouldShowExpansionField()) pos++;
        return pos;
    },

    singleCellGroupHeaders : function () {
        return this._singleCellGroupHeaders(this.showGroupSummary, this.showGroupSummaryInHeader);
    },
    _singleCellGroupHeaders : function (showGroupSummary, showGroupSummaryInHeader) {
        if (this.getGroupTitleField() != null) return false;
        if (showGroupSummary && showGroupSummaryInHeader) return false;
        return true
    },

    //> @attr listGrid.showGroupSummaryInHeader (Boolean : false : IRW)
    // If this grid is +link{listGrid.groupBy(),grouped}, and +link{listGrid.showGroupSummary}
    // is true, setting this property causes field summary values for each group to be displayed
    // directly in the group header node, rather than showing up at the bottom of each
    // expanded group.
    // <P>
    // Note that this means the group header node will be showing multiple field values
    // rather than the default display of a single cell spanning all columns containing the
    // group title. Developers may specify an explicit +link{listGrid.groupTitleField}, or
    // rely on the automatically generated +link{listGrid.showGroupTitleColumn,groupTitleColumn}
    // to have group titles be visible as well as the summary values.
    // <P>
    // Also note that multi-line group summaries are not supported when showing
    // the group summary in the group header. If multiple
    // +link{listGridField.summaryFunction,field summary functions} are defined for some field
    // only the first will be displayed when this property is set to true.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    showGroupSummaryInHeader:false,

    //> @attr listGrid.showCollapsedGroupSummary (Boolean : false : IRW)
    // Should group summaries be visible when the group is collapsed?
    // <P>
    // This property only applies to +link{listGrid.groupBy(),grouped} grids showing
    // +link{listGrid.showGroupSummary,group summary rows}. When set to true, the
    // group summary row(s) for each group will show up under the group header nodes when
    // the group is collapsed, or at then end of the grouped set of data if the group
    // is expanded.
    // <P>
    // This property has no effect if +link{showGroupSummaryInHeader} is true.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    showCollapsedGroupSummary:false,

    //> @method listGridField.getGroupValue()
    // Return the value which records should be grouped by.
    // <P>
    // All records for which getGroupValue() returns the same value appear in the same
    // group.  Default is the result of +link{listGrid.getCellValue}.
    // <P>
    // While any type of value may be returned, avoiding the use of string values may
    // result in improved performance. In this case, +link{listGridField.getGroupTitle()}
    // may be implemented to map a numeric group value into a legible string.
    //
    // @param   value (any)   raw value for the cell, from the record for the row
    // @param   record (ListGridRecord)
    //   Record object for the cell. Note: If this is a new row that has not been saved, in an
    //   editable grid, it has no associated record object. In this case the edit values will
    //   be passed in as this parameter (see +link{listGrid.getEditValues()})
    // @param   field (Object)    Field object for which to get group value
    // @param   fieldName (String)    The name of the field
    // @param   grid (ListGrid) the ListGrid displaying the cell
    // @return (any) Group value to which this record belongs
    //
    // @see listGrid.groupBy()
    // @see listGridField.getGroupTitle()
    // @group grouping
    // @visibility external
    // @example customGrouping
    //<

    //> @method listGridField.getGroupTitle()
    // Return the title that should be shown to the user for the group with the
    // <code>groupValue</code> passed as a parameter.
    // <P>
    // Default title is the groupValue itself.
    //
    // @group grouping
    //
    // @param   groupValue (any)   the value from the group is created, the result of
    //  +link{listGridField.getGroupValue()}
    // @param   groupNode (groupNode) the node in the grid containing the group.
    // @param   field (Object)    Field object for which to get group value
    // @param   fieldName (String)    The name of the field
    // @param   grid (ListGrid) the ListGrid displaying the cell
    // @return (any) Group value to which this record belongs
    //
    // @see listGrid.groupBy()
    // @see listGridField.getGroupValue()
    // @visibility external
    // @example customGrouping
    //<

    //> @attr listGridField.groupingModes (ValueMap : null : IR)
    // If this field can be grouped, this attribute represents the set of grouping styles that
    // are available.  For example, a "date" field might be able to be
    // grouped by week or month, as well as by the date itself.
    // <P>
    // If <code>groupingModes</code> are present and
    // +link{listGrid.canGroupBy,grouping is enabled}, the menu for this field includes a
    // submenu of possible grouping modes generated from the <code>groupingModes</code> valueMap.
    // When the user selects a particular grouping mode,
    // +link{listGridField.groupingMode,field.groupingMode} is set to the user's chosen mode,
    // and this choice can be detected via the <code>field</code> parameter to
    // +link{listGridField.getGroupValue()} in order to provide different modes of grouping.
    // <P>
    // The user may also choose to group records without specifying a grouping mode, in this case,
    // the +link{listGridField.defaultGroupingMode} is used.
    // <P>
    // Note that <code>getGroupValue</code>, <code>groupingModes</code> et al can be specified on
    // +link{SimpleType} declarations.  See this list of
    // +link{group:builtinGroupingModes, builtin grouping modes} for more information.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.groupingMode (identifier : null : IR)
    // For a field that allows multiple +link{listGridField.groupingModes,grouping modes},
    // the current grouping mode.
    // <P>
    // This property is set when a user chooses a particular grouping mode, and may be set on
    // ListGrid creation to affect the initial grouping.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.defaultGroupingMode (identifier : null : IR)
    // Default groupingMode used when the user does not specify a mode or grouping is triggered
    // programmatically and +link{listGridField.groupingMode,field.groupingMode} is unset.
    // See +link{listGridField.groupingModes,field.groupingModes}.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.groupPrecision (integer : null : IR)
    // For fields of type:"float" or derived from float, number of digits after the decimal point
    // to consider when grouping.
    // <P>
    // For example, <code>groupPrecision:2</code> indicates that 45.238 and 45.231 group together,
    // but 45.22 and 45.27 are separate.
    // <P>
    // See also +link{listGridField.groupGranularity,groupGranularity} for grouping by broader
    // ranges.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.groupGranularity (integer : null : IR)
    // Granularity of grouping for numeric fields.
    // <P>
    // Groups will be formed based on ranges of values of size <code>groupGranularity</code>.  For
    // example, if groupGranularity were 1000, groups would be 0-1000, 1000-2000, etc.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.canHilite (boolean : null : IRW)
    // Determines whether this field can be hilited.  Set to false to prevent this
    // field from appearing in HiliteEditor.
    //
    // @visibility external
    //<

    //> @attr listGridField.showHilitesInGroupSummary (Boolean : null : IRW)
    // Determines whether hiliting for this field is shown in a group summary.
    // Set to false to prevent this field from showing hilite in a group summary.
    // <P>
    // All hilites in group summary rows can be controlled with the
    // +link{listGrid.showHilitesInGroupSummary} property.
    //
    // @visibility external
    //<

    //> @attr listGridField.canGroupBy (Boolean : true : IRW)
    // Determines whether this field will be groupable in the header context menu.
    //
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr listGridField.canSortClientOnly (Boolean : false : IRW)
    // When true, this field can only be used for sorting if the data is entirely client-side.
    //
    // @visibility external
    //<

    //> @attr listGridField.showDefaultContextMenu (Boolean : true : IRW)
    // When set to false, this field will not show a context menu in its header.
    //
    // @visibility external
    //<

    //> @attr listGridField.canExport (Boolean : null : IR)
    //  Dictates whether the data in this field be exported.  Explicitly set this
    //  to false to prevent exporting.  Has no effect if the underlying
    //  +link{dataSourceField.canExport, dataSourceField} is explicitly set to
    //  canExport: false.
    //
    // @visibility external
    //<

    //> @attr listGridField.exportRawValues (Boolean : null : IR)
    //  Dictates whether the data in this field should be exported raw by
    // +link{listGrid.exportClientData, exportClientData()}.  If set to true for a
    // field, the values in the field-formatters will not be executed for data in this field.
    // Decreases the time taken for large exports.
    //
    // @visibility external
    //<

    //> @attr listGridField.summaryValue (HTMLString : null : IRW)
    // The value to display for a ListGridField when it appears in the +link{listGrid.summaryRow,summaryRow}.  The
    // default for normal fields is null and for special fields, like the +link{listGrid.checkboxField,checkboxField},
    // the default is to show a blank value (a non-breaking space).
    // @visibility external
    //<

    //> @attr listGrid.groupNodeStyle (String : "groupNode" : IRW)
    // The CSS style that +link{listGrid.groupBy,group} rows will have.
    // <P>
    // Note that this is not a +link{listGrid.getBaseStyle(),base style}, so, if this
    // property is set, group nodes will not show stateful styling
    // (different styles for +link{listGrid.showRollOver},
    // +link{listGrid.alternateRecordStyles}, etc). To enable stateful styling for
    // groupNodes, set this property to <code>null</code> and specify a
    // +link{groupNodeBaseStyle}
    //
    // @group grouping
    // @see group:grouping
    // @visibility external
    //<
    groupNodeStyle: "groupNode",

    //> @attr listGrid.groupNodeBaseStyle (String : null : IRW)
    // +link{listGrid.getBaseStyle(),Base style} for +link{listGrid.groupBy,group} rows.
    // <P>
    // Note that this property has no effect if +link{listGrid.groupNodeStyle} is
    // non null.
    //
    // @group grouping
    // @see group:grouping
    // @visibility external
    //<
    groupNodeBaseStyle: null,

    //> @attr listGrid.groupIcon (SCImgURL : "[SKINIMG]/TreeGrid/opener.gif" : IRW)
    // The URL of the base icon for the group icons in this listGrid. Default value may
    // be overridden by the +link{group:skinning,current skin}.
    //
    // @group grouping
    // @see group:grouping
    // @visibility external
    //<
    groupIcon: "[SKINIMG]/TreeGrid/opener.gif",

    //> @attr listGrid.groupIconSize (Number : 16 : IRW)
    // Default width and height of group icons for this ListGrid.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    groupIconSize: 16,

    //> @attr listGrid.groupIndentSize (Number : 20 : IRW)
    // Default number of pixels by which to indent subgroups relative to parent group.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @see listGrid.getGroupNodeHTML
    // @visibility external
    //<
    groupIndentSize: 20,

    //> @attr listGrid.groupLeadingIndent (Number : 10 : IRW)
    // Default number of pixels by which to indent all groups.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @see listGrid.getGroupNodeHTML
    // @visibility external
    //<
    groupLeadingIndent: 10,

    //> @attr listGrid.canGroupBy (Boolean : true : IRW)
    // If false, grouping via context menu will be disabled.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    canGroupBy: true,

    //> @attr listGrid.groupByMaxRecords (int : 1000 : IRW)
    // Maximum number of records to which a groupBy can be applied. If there are more records,
    // grouping will not be available via the default header context menu, and calls to
    // +link{listGrid.groupBy()} will be ignored.
    // <P>
    // The maximum exists because ListGrid grouping is performed in-browser, hence requires loading of
    // all records that match the current filter criteria before records can be grouped.  The default
    // maximum represents a number of records which are safe to load in legacy browsers such as Internet
    // Explorer 8 (modern browsers can handle far more), and is also a good upper limit from the
    // perspective of loading data from a database.
    // <P>
    // Going beyond this limit can cause "script running slowly" errors from legacy browsers (as well as
    // high database load).  To build an interface for grouping that handles arbitrary data volume, use
    // a TreeGrid with +link{treeGrid.loadDataOnDemand} with server-side grouping code.
    //
    // @group grouping
    // @see groupBy
    // @visibility external
    //<
    groupByMaxRecords: 1000,

    //> @attr listGrid.groupByAsyncThreshold (int : 50 : IRW)
    // When grouping is requested with this number of records or more, an asynchronous approach is
    // used to avoid the browser showing a "script is running slowly.." message prompting the
    // user to stop execution of JavaScript.
    // <p>
    // Note that +link{groupByMaxRecords} must be set at least as high as +link{groupByAsyncThreshold}
    // or asynchronous grouping will never be used.
    // <p>
    // During async grouping, interactivity is blocked and the +link{asynchGroupingPrompt} is shown
    // to the user, then hidden when grouping completes; +link{groupByComplete} then fires.
    // <p>
    // Note that this async processing covers grouping <b>only</b> - it does not cover whole grid or
    // per-group summaries, client-side sort or filter, or other operations that may cause the browser
    // to show the "script is running slowly" prompt when working with very large sets of records in a
    // grid.
    // <p>
    // At this time, there is no generally effective way to avoid this warning dialog appearing with very
    // large datasets in Microsoft's Internet Explorer (IE).  IE's severely flawed detection algorithm for
    // runaway scripts has been shown to interrupt computations after only 0.2 seconds elapsed time
    // even if the computation would have finished in 0.3 seconds.  Optimizations that reduce
    // execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
    // every operation can reasonably be made asynchronous, the current recommendation is to avoid
    // working with overly large datasets until the affected versions of IE are obsoleted.
    // @visibility external
    //<
    groupByAsyncThreshold: 50,

    //> @attr listGrid.showAsynchGroupingPrompt (Boolean : null : IR)
    // If set to false, do not show the +link{asynchGroupingPrompt} dialog during
    // +link{groupByAsyncThreshold,asynchronous grouping}.
    // @visibility external
    //<

    //> @attr listGrid.asynchGroupingPrompt (HTMLString : "${loadingImage}&nbsp;Grouping data..." : IR)
    // The prompt to display while interactivity is blocked during +link{groupByAsyncThreshold,asynchronous grouping}.
    // @group i18nMessages
    // @visibility external
    //<
    asynchGroupingPrompt: "${loadingImage}&nbsp;Grouping data...",

    //> @attr listGrid.isGrouped (boolean : false : R)
    // True if this listGrid is grouped, false otherwise
    //
    // @group grouping
    // @visibility external
    // @see     groupBy
    //<

    //> @attr listGrid.nullGroupTitle (String : '-none-' : IRW)
    // Default alias to use for groups with no value
    //
    // @group grouping
    // @visibility external
    // @see     groupBy
    //<
    nullGroupTitle: "-none-",

    //> @attr listGrid.groupByField (String | Array of String : see below : IR)
    // List of fields to group grid records. If only a single field is used, that field
    // may be specified as a string. After initialization, use +link{listGrid.groupBy()}
    // to update the grouping field list, instead of modifying groupByField directly.
    // @group grouping
    // @visibility external
    // @see groupBy
    // @example dynamicGrouping
    //<


    // ----------------------
    // Value icons
    // The valueIcons object is a mapping between values and image URLs - when specified
    // we show the valueIcon image either next to, or instead of the normal cell value.

    //> @attr listGridField.valueIcons (Map<String,String> : null : IRW)
    // This property is a mapping from data values for this field to +link{SCImgURL,urls} for
    // icons to display for those data values.
    // <p>
    // For example, given a field named "status" with possible values
    // "Normal", "Slow", "Offline", the follow definition would show various icons for that
    // field:
    // <P>
    // <smartclient>
    // <pre>
    // fields : [
    //     { name:"status",
    //       valueIcons: {
    //           Normal : "greenIcon.png",
    //           Slow : "yellowIcon.png",
    //           Offline : "redIcon.png"
    //       }
    //     },
    //     ... other fields ...
    // ]
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    // ListGridField statusField = new ListGridField("status");
    // statusField.setValueIcons(new HashMap&lt;String, String>() {{
    //    put("Normal", "greenIcon.png");
    //    put("Slow", "yellowIcon.png");
    //    put("Offline", "redIcon.png");
    // }});
    // </pre>
    // </smartgwt>
    // <p>
    // If a simple value-to-URL mapping is not enough, you can override +link{ListGrid.getValueIcon()}
    // to customize the behavior.  You can even specify an empty <code>valueIcons</code> map
    // and use +link{ListGrid.getValueIcon()} to return arbitrary icons with no fixed mapping.
    // <p>
    // <code>valueIcons</code> can either be displayed alongside the normal value or can
    // replace the normal field value so that only the icon is shown.  See
    // +link{listGridField.showValueIconOnly}.  When placed alongside the value, use
    // +link{valueIconOrientation} to control left- vs right-side placement.
    // <P>
    // If inline editing is enabled for this field, editors displayed for this field will also
    // show valueIcons.  This may be overridden by explicitly setting
    // +link{listGridField.editorValueIcons}.
    // <P>
    // Note that the following attributes related to valueIcon styling will also be picked up
    // by the editor from the ListGridField object unless explicitly specified via the
    // equivalent <code>editor_</code> attributes:<br>
    // +link{listGridField.valueIconWidth}<br>
    // +link{listGridField.valueIconHeight}<br>
    // +link{listGridField.valueIconSize}<br>
    // +link{listGridField.valueIconLeftPadding}<br>
    // +link{listGridField.valueIconRightPadding}<br>
    // +link{listGridField.imageURLPrefix}<br>
    // +link{listGridField.imageURLSuffix}
    // <P>
    // If +link{listGridField.valueIconClick()} is defined for the field, a pointer
    // cursor will be shown when the user rolls over the valueIcon, and the valueIconClick
    // method will execute when the user clicks the icon.
    //
    // @group imageColumns
    // @visibility external
    //<

    //> @method listGridField.valueIconClick()
    //
    // Executed when the user clicks on a +link{listGridField.valueIcons,value icon} within
    // this field. Return false to suppress default behavior of firing +link{recordClick}
    // handlers, etc.
    //
    // @param   viewer      (ListGrid)  the listGrid that contains the click event
    // @param   record      (ListGridRecord)    the record that was clicked on
    // @param   recordNum   (number)    number of the record clicked on in the current set of
    //                                  displayed records (starts with 0)
    // @param   field       (ListGridField) the field that was clicked on (field definition)
    // @param   rawValue    (any)   raw value of the cell (before valueMap, etc applied)
    // @param   editor      (FormItem) If this cell is being +link{listGrid.canEdit,edited},
    //  this method will fire when the user clicks the valueIcon on the edit item for the
    //  cell, passing in the editor item as the <code>editor</code> parameter. If the cell
    //  is not being edited, this value will be null.
    // @return  (boolean)   false to stop event bubbling
    //
    // @group   events
    //
    // @see attr:listGridField.valueIcons
    // @visibility external
    //<


    //> @attr listGrid.valueIconSize (number : 16 : IRW)
    // Default width and height of value icons for this ListGrid.
    // Can be overridden at the listGrid level via explicit +link{ListGrid.valueIconWidth} and
    // +link{ListGrid.valueIconHeight}, or at the field level via +link{ListGridField.valueIconSize},
    // +link{ListGridField.valueIconWidth} and {ListGridField.valueIconHeight}
    // @visibility external
    // @group imageColumns
    // @see ListGrid.valueIconWidth
    // @see ListGrid.valueIconHeight
    // @see ListGridField.valueIconSize
    //<
    valueIconSize:16,


    //> @attr listGrid.valueIconWidth (number : null : IRW)
    // Width for value icons for this listGrid.
    // Overrides +link{ListGrid.valueIconSize}.
    // Can be overridden at the field level
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGrid.valueIconHeight (number : null : IRW)
    // Height for value icons for this listGrid.
    // Overrides +link{ListGrid.valueIconSize}.
    // Can be overridden at the field level
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.valueIconSize (number : null : IRW)
    // Default width and height of value icons in this field.
    // Takes precedence over valueIconWidth, valueIconHeight and valueIconSize specified at
    // the ListGrid level.
    // Can be overridden via +link{ListGridField.valueIconWidth} and {ListGridField.valueIconHeight}
    // @visibility external
    // @group imageColumns
    // @see ListGrid.valueIconSize
    // @see ListGridField.valueIconWidth
    // @see ListGridField.valueIconHeight
    //<

    //> @attr listGridField.valueIconWidth (number : null : IRW)
    // Width for value icons for this listGrid field.
    // Overrides +link{ListGrid.valueIconSize}, +link{ListGrid.valueIconWidth}, and
    // +link{ListGridField.valueIconSize}.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.valueIconHeight (number : null : IRW)
    // Height for value icons for this listGrid field.
    // Overrides +link{ListGrid.valueIconSize}, +link{ListGrid.valueIconHeight}, and
    // +link{ListGridField.valueIconSize}.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr   listGridField.valueIconLeftPadding (number : null : IRW)
    // How much padding should there be on the left of valueIcons for this field
    // Overrides +link{listGrid.valueIconLeftPadding}
    // @group imageColumns
    // @see ListGridField.valueIcons
    // @visibility external
    //<

    //> @attr   listGridField.valueIconRightPadding (number : null : IRW)
    // How much padding should there be on the right of valueIcons for this field
    // Overrides +link{listGrid.valueIconRightPadding}
    // @group imageColumns
    // @see ListGridField.valueIcons
    // @visibility external
    //<

    //> @attr listGridField.editorValueIcons (Map<String,String> : null : IRW)
    // When some cell in this field is being edited, setting this property will specify the
    // value icons to display in the cell's editor. If unset, the editor's valueIcons
    // will be determined in the same way as it would be for a static cell.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.editorValueIconWidth (number : null : IRW)
    // When some cell in this field is being edited, setting this property will specify the
    // width for value icons in the cell's editor. If unset, the editor's valueIcon width and
    // height will be determined in the same way as it would be for a static cell.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.editorValueIconHeight (number : null : IRW)
    // When some cell in this field is being edited, setting this property will specify the
    // height for value icons in the cell's editor. If unset, the editor's valueIcon width and
    // height will be determined in the same way as it would be for a static cell.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.showValueIconOnly (boolean : null : IRW)
    // If this field has a valueIcons property specified, setting this property causes
    // the valueIcon for each value to be displayed in the cell without also showing the
    // record's value for the field.
    // <P>
    // If unset the default behavior is to show the icon only if an explicit valueMap is
    // specified as well in addition to a valueIcons map, otherwise show both the valueIcon and
    // value for the cell.
    // <P>
    // Note that if this field is editable +link{FormItem.showValueIconOnly} will be passed
    // through to editors displayed in this field.
    //
    // @group imageColumns
    // @see listGridField.valueIcons
    // @see listGridField.suppressValueIcon
    // @visibility external
    //<

    // NOTE: showValueIconOnly: the use cases are:
    // - represent a value as an icon only to minimize space
    // - show text, but add an icon as decoration, either to all values, or to emphasize some
    //   values for quicker scanning
    // The property 'showValueIconOnly' allows the developer to explicitly show the valueIcon
    // with or without text.  If showValueIconOnly is unset, we make the assumption that:
    // - if the field is *not* constrained to a fixed set of values (has no valueMap), there's
    //   no way to have icons for all the values, so the purpose of the icons is to add
    //   emphasis to certain values [so we show both text and images]
    // - otherwise the developer has an icon for every possible value, so there is no need for
    //   the value to also be displayed - we size the field large enough to accommodate the icon
    //   only, and suppress the text.

    //> @attr   listGridField.suppressValueIcon (boolean : null : IRW)
    // If this field has a valueIcons property specified, setting this property to true will
    // prevent the valueIcon being written out into this field's cells.
    // <P>
    // Note this property may also be set to false to avoid showing the standard
    // +link{listGrid.booleanTrueImage} and +link{listGrid.booleanFalseImage} for fields of type
    // <code>boolean</code>.
    //
    // @group imageColumns
    // @see listGridField.valueIcons
    // @see listGridField.showValueIconOnly
    // @visibility external
    //<

    //> @attr   listGridField.valueIconOrientation (string : null : IRW)
    // If we're showing a valueIcon for this field should it appear to the left or the right
    // of the text?  By default the icon will appear to the left of the textual value -
    // set this to "right" to show the icon on the right of the text.
    // Has no effect if +link{listGridField.showValueIconOnly} is true
    // @visibility external
    // @group imageColumns
    //<


    //> @attr   listGrid.valueIconLeftPadding (number : 2 : IRW)
    // How much padding should there be on the left of valueIcons by default
    // Can be overridden at the field level
    // @group imageColumns
    // @see ListGridField.valueIcons
    // @visibility external
    //<
    valueIconLeftPadding:2,

    //> @attr   listGrid.valueIconRightPadding (number : 2 : IRW)
    // How much padding should there be on the right of valueIcons by default
    // @group imageColumns
    // Can be overridden at the field level
    // @see ListGridField.valueIcons
    // @visibility external
    //<
    valueIconRightPadding:2,

    // ------------
    // Hilite Icons
    // ------------

    //> @attr listGrid.hiliteIcons (Array of String : ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"] : IR)
    // @include dataBoundComponent.hiliteIcons
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconPosition (HiliteIconPosition : "before" : IR)
    // @include dataBoundComponent.hiliteIconPosition
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconSize (number : 12 : IRW)
    // @include dataBoundComponent.hiliteIconSize
    // @group hiliting
    // @see hiliteIconWidth
    // @see hiliteIconHeight
    // @see ListGridField.hiliteIconSize
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconWidth (number : null : IRW)
    // @include dataBoundComponent.hiliteIconWidth
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconHeight (number : null : IRW)
    // @include dataBoundComponent.hiliteIconHeight
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGrid.hiliteIconLeftPadding (number : 2 : IRW)
    // @include dataBoundComponent.hiliteIconLeftPadding
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGrid.hiliteIconRightPadding (number : 2 : IRW)
    // @include dataBoundComponent.hiliteIconRightPadding
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconPosition (HiliteIconPosition : null : IR)
    // When +link{listGrid.hiliteIcons} are present, where the hilite icon will be placed
    // relative to the field value.  See +link{type:HiliteIconPosition}.
    // Overrides +link{listGrid.hiliteIconPosition}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconSize (number : null : IRW)
    // Default width and height of +link{listGrid.hiliteIcons, hilite icons} in this field.
    // Takes precedence over hiliteIconWidth, hiliteIconHeight and hiliteIconSize specified at
    // the component level.
    // Can be overridden via +link{ListGridField.hiliteIconWidth} and
    // +link{ListGridField.hiliteIconHeight}
    // @group hiliting
    // @see ListGrid.hiliteIconSize
    // @see ListGridField.hiliteIconWidth
    // @see ListGridField.hiliteIconHeight
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconWidth (number : null : IRW)
    // Width for hilite icons for this field.
    // Overrides +link{listGrid.hiliteIconSize}, +link{listGrid.hiliteIconWidth}, and
    // +link{ListGridField.hiliteIconSize}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconHeight (number : null : IRW)
    // Height for hilite icons for this field.
    // Overrides +link{listGrid.hiliteIconSize}, +link{listGrid.hiliteIconHeight}, and
    // +link{ListGridField.hiliteIconSize}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGridField.hiliteIconLeftPadding (number : null : IRW)
    // How much padding should there be on the left of +link{DataBoundComponent.hiliteIcons, hilite icons}
    // for this field?
    // Overrides +link{listGrid.hiliteIconLeftPadding}
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGridField.hiliteIconRightPadding (number : null : IRW)
    // How much padding should there be on the right of +link{DataBoundComponent.hiliteIcons, hilite icons}
    // for this field?
    // Overrides +link{listGrid.hiliteIconRightPadding}
    // @group hiliting
    // @visibility external
    //<




    //> @attr   ListGridField.imageURLPrefix (string : null : IRWA)
    // If this field has type [+link{type:ListGridFieldType}] set to <code>"image"</code>
    // and the URL for the image displayed is not absolute, the path of the URL will be relative
    // to this string<br>
    // Alternatively, if this field displays any valueIcons, this prefix will be applied to
    // the beginning of any +link{ListGridField.valueIcons} when determining the
    // URL for the image.
    // @group imageColumns
    // @visibility external
    // @example imageType
    //<

    //> @attr   ListGridField.imageURLSuffix (string : null : IRWA)
    // If any cells in this field are showing a value icon (see: +link{ListGridField.valueIcons})
    // or this is has +link{type:ListGridFieldType} set to <code>"image"</code>, this the value
    // of this property will be appended to the end of the URL for the icon displayed.<br>
    // Typical usage might be to append a file type such as <code>".gif"</code> to the
    // filename of the image.<br>
    // For editable fields, this property will also be passed through to any editors as
    // +link{FormItem.imageURLSuffix}.
    // @group imageColumns
    // @visibility external
    // @example imageType
    //<

    //> @attr   ListGridField.editorImageURLPrefix (string : null : IRWA)
    // When some cell in this field is being edited, this property can be used to apply
    // an explicit +link{FormItem.imageURLPrefix} to the editor in question.
    // This can be used to modify the valueIcons within the editor.<br>
    // If unset, but +link{ListGridField.imageURLPrefix} is specified, that will be used
    // instead.
    // @group editing
    // @visibility external
    //<

    //> @attr   ListGridField.editorImageURLSuffix (string : null : IRWA)
    // When some cell in this field is being edited, this property can be used to apply
    // an explicit +link{FormItem.imageURLSuffix} to the editor in question.
    // This can be used to modify the valueIcons within the editor.<br>
    // If unset, but +link{ListGridField.imageURLPrefix} is specified, that will be used
    // instead.
    // @group editing
    // @visibility external
    //<

    //> @attr   listGrid.imageSize (number : 16 : IRW)
    // Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a
    // per-field basis via +link{attr:ListGridField.imageSize} or
    // +link{attr:ListGridField.imageWidth}/+link{attr:ListGridField.imageHeight}
    //
    // @group imageColumns
    // @visibility external
    //<
    imageSize: 16,

    //> @attr   listGridField.imageSize (number : 16 : IRW)
    // Size of images shown for fieldTypes image and imageFile in this field.
    // This setting overrides the global ListGrid default +link{attr:ListGrid.imageSize}.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // height.  For example, if <code>field.imageSize</code> is "logoSize",
    // <code>record.logoSize</code> will control the size of the image.
    //
    // @see attr:ListGridField.imageWidth
    // @see attr:ListGridField.imageHeight
    //
    // @group imageColumns
    // @visibility external
    //<

    //> @attr   listGridField.imageWidth (number : 16 : IRW)
    // Width of images shown for fieldTypes image and imageFile in this field.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // width.  For example, if <code>field.imageWidth</code> is "logoWidth",
    // <code>record.logoWidth</code> will control the width of the image.
    //
    // @see attr:ListGrid.imageSize
    // @see attr:ListGridField.imageSize
    // @see attr:ListGridField.imageHeight
    //
    // @group imageColumns
    // @visibility external
    //<

    //> @attr   listGridField.imageHeight (number : 16 : IRW)
    // Height of image shown for fieldTypes image and imageFile in this field.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // height.  For example, if <code>field.imageHeight</code> is "logoHeight",
    // <code>record.logoHeight</code> will control the height of the image.
    //
    // @see attr:ListGrid.imageSize
    // @see attr:ListGridField.imageSize
    // @see attr:ListGridField.imageWidth
    //
    // @group imageColumns
    // @visibility external
    //<

    // ListGridField
    // ---------------------------------------------------------------------------------------

    //  -- Define the 'listGridField' pseudo class for doc

    //> @object ListGridField
    // An ordinary JavaScript object containing properties that configures the display of
    // and interaction with the columns of a +link{ListGrid}.
    //
    // @see ListGrid.fields
    // @see ListGrid.setFields
    // @treeLocation Client Reference/Grids/ListGrid
    // @visibility external
    //<

    //> @type ListGridFieldType
    // ListGrids format data for viewing and editing based on the <i>type</i> attribute of the
    // field.  This table describes how the ListGrid deals with the various built-in types.
    //
    // @value "text"    Simple text rendering for view.  For editing a text entry field is shown.
    // If the length of the field (as specified by the +link{attr:dataSourceField.length}
    // attribute) is larger than the value specified by +link{attr:listGrid.longTextEditorThreshold}, a
    // text input icon is shown that, when clicked on (or field is focused in) opens a larger
    // editor that expands outside the boundaries of the cell (textarea by default, but
    // overrideable via +link{ListGrid.longTextEditorType}).
    //
    // @value "boolean" For viewing and editing a checkbox is shown with a check mark for the
    // <code>true</code> value and no check mark for the <code>false</code> value. This behavior
    // may be suppressed by setting +link{listGridField.suppressValueIcon} for the field. See
    // +link{ListGrid.booleanTrueImage} for customization.
    //
    // @value "integer" A whole number, e.g. <code>123</code>. Consider setting
    // +link{listGridField.editorType,editorType} to use a +link{SpinnerItem}.
    //
    // @value "float" A floating point (decimal) number, e.g. <code>1.23</code>.
    // Consider setting +link{listGridField.editorType,editorType} to use a +link{SpinnerItem}.
    //
    // @value "date" Field value should be a <code>Date</code> instance representing a logical
    // date, with no time of day information.  See +link{group:dateFormatAndStorage} for
    // details of the logical date type and how it is represented and manipulated.
    // <P>
    // Dates will be formatted using +link{listGridField.dateFormatter,ListGridField.dateFormatter}
    // if specified, otherwise
    // +link{ListGrid.dateFormatter,ListGrid.dateFormatter}.
    // If both these attributes are unset, dates are formatted
    // using the standard +link{Date.setShortDisplayFormat(),short display format} for dates.
    // <P>
    // For editing, by default a +link{DateItem} is used with +link{DateItem.useTextField} set
    // to true, providing textual date entry plus a pop-up date picker. The
    // +link{DateItem.dateFormatter, dateFormatter} and +link{DateItem.inputFormat, inputFormat}
    // for the editor will be picked up from the ListGridField, if specified.
    //
    // @value "time" Field value should be a <code>Date</code> instance representing a logical
    // time, meaning time value that does not have a specific day and also has no timezone.  See
    // +link{group:dateFormatAndStorage} for details of the logical time type and how it is
    // represented and manipulated.
    // <P>
    // Times will be formatted using +link{listGridField.timeFormatter,ListGridField.timeFormatter}
    // if specified,
    // otherwise +link{ListGrid.timeFormatter,ListGrid.timeFormatter}.
    // <P>
    // If both these attributes are unset, times are formatted using the standard
    // +link{Time.shortDisplayFormat,short display format} for times.
    // <P>
    // For editing, by default a +link{TimeItem} is used. The
    // +link{TimeItem.timeFormatter, timeFormatter} for the editor will be picked up from
    // the ListGridField, if specified.
    //
    // @value "datetime" Field value should be a <code>Date</code> instance representing a
    // specific date and time value.  See +link{group:dateFormatAndStorage} for details of the
    // datetime type and how it is represented and manipulated.
    // <P>
    // Dates will be formatted using +link{listGridField.dateFormatter,ListGridField.dateFormatter}
    // if specified, otherwise
    // +link{ListGrid.datetimeFormatter,ListGrid.datetimeFormatter}.
    // If both these attributes are unset, dates are formatted
    // using the standard +link{Date.setShortDatetimeDisplayFormat(),short display format} for
    // datetime values.
    // <P>
    // For editing, by default a +link{DateTimeItem} is used, providing textual date entry plus
    // a pop-up date picker.  The +link{DateItem.dateFormatter, dateFormatter} and
    // +link{DateItem.inputFormat, inputFormat} for the editor will be picked up from the
    // ListGridField, if specified.
    //
    // @value "sequence" Same as <code>text</code>
    //
    // @value "link"     Renders a clickable html link (using an HTML anchor tag: &lt;A&gt;).
    // The target URL is the value of the field, which is also the default display value.  You
    // can override the display value by setting +link{attr:listGridRecord.linkText} or
    // +link{attr:listGridField.linkText}.
    // <P>
    // Clicking the link opens the URL in a new window by default.  To change this behavior,
    // you can set <code>field.target</code>, which works identically to the "target"
    // attribute on an HTML anchor (&lt;A&gt;) tag.  See +link{listGridField.target} for more
    // information.
    // <P>
    // In inline edit mode, this type works like a text field.
    // <P>
    // To create a link not covered by this feature, consider using
    // +link{listGridField.formatCellValue()} along with +link{Canvas.linkHTML()}, or simply
    // +link{listGrid.getCellStyle,styling the field} to look like a link, and providing
    // interactivity via +link{listGridField.recordClick,field.recordClick()}.
    //
    // @value "image"   Renders a different image in each row based on the value of the field.  If
    // this URL is not absolute, it is assumed to be relative to
    // +link{ListGridField.imageURLPrefix} if specified. The size of the image is controlled by
    // +link{attr:listGridField.imageSize}, +link{attr:listGridField.imageWidth},
    // +link{attr:listGridField.imageHeight} (and by the similarly-named global default
    // attributes on the ListGrid itself).
    // <P>
    // You can also specify the following attributes on the field: <code>activeAreaHTML</code>, and
    // <code>extraStuff</code> - these are passed to +link{method:canvas.imgHTML} to generate the
    // final URL.
    // <P>
    // Note if you want to display icons <b>in addition to</b> the normal cell value, you
    // can use +link{listGridField.valueIcons,valueIcons} instead.
    //
    // @value "icon" Shows +link{listGridField.icon,field.icon} in every cell, and also in the
    // header.  Useful for a field that is used as a button, for example, launches a detail
    // window or removes a row.  Implement a +link{listGridField.recordClick,field.recordClick}
    // to define a behavior for the button.
    // <P>
    // NOTE: for a field that shows different icons depending on the field value, see
    // +link{listGridField.valueIcons}.
    // <P>
    // <code>type:"icon"</code> also defaults to a small field width, accommodating just the icon
    // with padding, and to a blank header title, so that the header shows the icon only.
    // <P>
    // +link{listGridField.iconWidth,field.iconWidth} and related properties configure
    // the size of the icon both in the header and in body cells.
    // <P>
    // If you want the icon to appear only in body cells and not in the header, set
    // +link{listGridField.cellIcon,field.cellIcon} instead, leaving field.icon null.
    //
    // @value "binary"  For viewing, the grid renders a 'view' icon (looking glass) followed by a
    // 'download' icon and then the name of the file is displayed in text.  If the user clicks the
    // 'view' icon, a new browser window is opened and the file is streamed to that browser
    // instance, using +link{dataSource.viewFile()}.  For images and other file types with
    // known handlers, the content is typically displayed inline - otherwise the browser will
    // ask the user how to handle the content.  If the download icon is clicked,
    // +link{dataSource.downloadFile()} is used to cause the browser to show a "save" dialog.
    // There is no inline editing mode for this field type.
    //
    // @value "imageFile"   Same as <code>binary</code>
    //
    // @value "summary" Show a calculated summary based on other field values within the
    //  current record. See +link{listGridField.recordSummaryFunction} for more information
    //
    // @value "any"       Fields of this type can contain any data value and have no default
    // formatting or validation behavior. This is useful as the
    // +link{SimpleType.inheritsFrom,parent type} for SimpleTypes
    // where you do not want any of the standard validation or formatting logic
    // to be inherited from the standard built-in types.
    //
    // @value "localeInt" An integer number with locale-based formatting, e.g. <code>12,345,678</code>.
    // See +link{group:localizedNumberFormatting,Localized Number Formatting}
    // for more info.
    //
    // @value "localeFloat" A float number with locale-based formatting, e.g. <code>12,345.67</code>.
    // See +link{group:localizedNumberFormatting,Localized Number Formatting}
    // for more info.
    //
    // @value "localeCurrency" A float number with locale-based formatting and using currency
    // symbol, e.g. <code>$12,345.67</code>.
    // See +link{group:localizedNumberFormatting,Localized Number Formatting}
    // for more info.
    //
    // @value "phoneNumber" A telephone number.  Uses +link{formItem.browserInputType} "tel" to
    // hint to the device to restrict input.  On most mobile devices that have
    // software keyboards, this cause a specialized keyboard to appear which
    // only allows entry of normal phone numbers.  When displayed read-only,
    // a "phoneNumber" renders as an HTML link with the "tel:" URL scheme,
    // which will invoke the native phone dialing interface on most mobile
    // devices.  In addition, the CSS style "sc_phoneNumber" is applied.
    // <p>
    // By default, "phoneNumber" fields do not include validators, however the
    // following validator definition would limit to digits, dashes and the
    // "+" character:
    // xml:
    // <p>
    //     &lt;validator type="regexp" expression="^(\(?\+?[0-9]*\)?)?[0-9_\- \(\)]*$"
    //         errorMessage="Phone number should be in the correct format e.g. +#(###)###-##-##" /&gt;
    //     <smartclient>
    // <p>
    // or directly in JavaScript:
    // <p>
    // <pre>
    // {type:"regexp", expression:"^(\\(?\\+?[0-9]*\\)?)?[0-9_\\- \\(\\)]*$",
    //     errorMessage:"Phone number should be in the correct format e.g. +#(###)###-##-##"}
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <p>
    // or directly in Java:
    // <p>
    // <pre>
    // RegExpValidator v = new RegExpValidator();
    // v.setType(ValidatorType.REGEXP);
    // v.setErrorMessage("Phone number should be in the correct format e.g. +#(###)###-##-##");
    // v.setExpression("^(\\(?\\+?[0-9]*\\)?)?[0-9_\\- \\(\\)]*$");
    // </pre>
    // </smartgwt>
    // and adding "#" and "*" to the regular expressions above would allow for
    // users to enter special keys sometimes used for extension numbers or
    // pauses
    //
    // @see attr:listGridField.type
    // @see type:FieldType
    // @visibility external
    // @example gridsDataTypes
    //<

    //> @attr listGridField.type (ListGridFieldType : "text" : [IR])
    //  ListGrids picks a renderer for the view and edit mode of a field based on this attribute.
    //  See +link{ListGridFieldType} for a summary of how types are rendered.
    //
    //  @see type:ListGridFieldType
    //  @see type:FieldType
    //  @group  appearance
    //  @visibility external
    //<

    //> @attr listGridField.name (identifier : null : [IR])
    // Name of this field.  Must be unique within this ListGrid as well as a valid JavaScript identifier,
    // as specified by ECMA-262 Section 7.6 (the <smartclient>+link{String.isValidID()}</smartclient>
    // <smartgwt>StringUtil.isValidID()</smartgwt> function can be used to test whether
    // a name is a valid JavaScript identifier).
    // <P>
    // The name of field is also the property in each record which holds the value for that
    // field.
    // <P>
    // If a +link{listGrid.dataSource} is specified and the DataSource has a field with the
    // same name, the ListGridField and DataSourceField are merged so that properties on the
    // ListGridField
    //
    // @group data
    // @visibility external
    //<

    //> @attr listGridField.dataPath (string : null : [IRA])
    // dataPath for this field. This property allows the grid to display details of nested data
    // structures in a flat list of columns.
    // @group data
    // @visibility external
    //<

    //> @attr listGridField.title (string : null : [IRW])
    // A title for this field, to display in the header for the field and in other
    // contexts such as the +link{listGrid.canPickFields,menu for picking visible fields}.
    // <P>
    // Note: if you want to use HTML tags to affect the display of the header, you should do so
    // via +link{listGridField.headerTitle} instead so that other places where the title
    // appears in the UI are not affected.  For example, you might set <code>headerTitle</code>
    // to an empty string to suppress the header title on a narrow column, but you would retain
    // the normal title in the <code>title</code> property to avoid a blank menu item in the
    // field picker menu, +link{databoundComponent.editHilites,hilite editor} and other contexts.
    // <P>
    // Alternately you can specify a +link{getFieldTitle()} method on the field to return the
    // HTML for the field title.
    //
    // @group  appearance
    // @see method:listGridField.getFieldTitle()
    // @visibility external
    //<

    //> @attr listGridField.showTitle (boolean : null : [IRW])
    // This property may be set to <code>false</code> to explicitly suppress display of
    // the field title in the column header button for the field.
    // @visibility external
    //<

    //> @method listGridField.getFieldTitle()
    // If your derivation of the field title is more complex than specifying a static string,
    // you can specify a getFieldTitle() method on your field to return the title string.
    // Otherwise you can use the +link{title} attribute on the field to specify the title.
    // <P>
    // You can use +link{listGrid.setFieldProperties,setFieldProperties()} to dynamically
    // update the title.
    //
    // @param viewer (ListGrid) pointer back to the ListGrid
    // @param fieldNum (number) index of this field in the grid's fields array.
    // @return  (string) Field title.
    // @group appearance
    // @see attr:listGridField.title
    // @visibility external
    //<

    //> @attr listGridField.wrap (Boolean : null : [IRW])
    // Should the field title wrap if there is not enough space horizontally to accommodate it.
    // If unset, default behavior is derived from +link{listGrid.wrapHeaderTitles}.  (This is a
    // soft-wrap - if set the title will wrap at word boundaries.)
    // <P>
    // <b>Notes:</b><ul>
    // <li>If autofitting is active, +link{width} and +link{minWidth} can be set to control the
    // minimum field width - see the links for details.
    // <li>This feature is incompatible with +link{listGrid.clipHeaderTitles}, and
    // <code>clipHeaderTitles</code> will be disabled for wrapping fields.</ul>
    //
    // @see attr:listGrid.minFieldWidth
    // @visibility external
    //<

    //> @attr listGridField.hoverWrap (Boolean : null : IRW)
    // This property may be set to customize the <code>wrap</code> attribute for the
    // canvas shown when the mouse hovers over cells in this field. Note that this causes a
    // soft-wrap - if set, the hover text will wrap at word boundaries.
    // <P>
    // If unset, default behavior is derived from +link{listGrid.headerHoverWrap}.
    // @visibility external
    //<

    //> @attr listGridField.hoverWidth (Integer : null : IRW)
    // Specifies the width of the canvas shown when the mouse hovers over cells in this field.
    // <P>
    // If unset, default behavior is derived from +link{listGrid.headerHoverWidth}.
    // @visibility external
    //<

    //> @attr listGridField.target (string : "_blank" : IRW)
    // By default, clicking a link rendered by this item opens it in a new browser window.  You
    // can alter this behavior by setting this property.  The value of this property will be
    // passed as the value to the <code>target</code> attribute of the anchor tag used to render
    // the link.
    // <P>
    // If you set listGridField.target to "javascript", the default behavior is to catch and
    // consume mouse-clicks that would result in the link being followed.  Instead, the
    // +link{listGrid.cellClick()} event is fired for the containing cell.
    //
    // @visibility external
    //<

    //> @method listGridField.showIf()
    // An optional +link{group:stringMethods,stringMethod} which if provided, is evaluated to
    // conditionally determine whether this field should be displayed.
    // Evaluated on initial draw, then reevaluated on explicit
    // calls to <code>listGrid.refreshFields()</code> or <code>listGrid.setFields()</code>.
    // <P>
    // Use <code>+link{listGridField.hidden,hidden}:true</code> or <code>showIf:"false"</code>
    // to set a ListGrid field to initially hidden.<br>
    // The user will still be able to show the field via a context menu.
    // This may be suppressed by setting +link{listGridField.canHide} to false, or by
    // setting +link{listGrid.canPickFields} to false to suppress the
    // field-picker entirely.
    // <P>
    // Note that explicit calls to +link{listGrid.showField,grid.showField()} or hideField()
    // will wipe out the <code>showIf</code> expression, as will the end user showing and
    // hiding columns via the +link{listGrid.showHeaderContextMenu,header contextMenu}.
    // <P>
    // Also note that fields marked as +link{DataSourceField.detail,detail:true} will be hidden by
    // default even if +link{ListGrid.showDetailFields} is <code>true</code>. To show detail fields
    // inherited from a DataSource, include an explicit field definition for the field and
    // set this property to return <code>true</code>.
    //
    // @param list (ListGrid) A pointer to the listGrid containing the field
    // @param field (ListGridField) the ListGridField object
    // @param fieldNum (integer) the index of the field
    // @return (boolean) whether the field should be shown
    //
    // @group appearance
    // @see method:ListGrid.refreshFields
    // @visibility external
    //<

    //> @attr listGridField.hidden  (Boolean : null : IR)
    // Marks field as initially hidden.<br>
    // The user will still be able to show the field via a context menu.
    // This may be suppressed by setting +link{listGridField.canHide} to false, or by
    // setting +link{listGrid.canPickFields} to false to suppress the
    // field-picker entirely.
    // <p>
    // To mark a field as completely hidden (not shown to a user at all, in any component), set
    // +link{DataSourceField.hidden} instead.
    //
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridField.frozen (boolean : null : IR)
    // Whether this field should be "frozen" for the purposes of horizontal scrolling.  See
    // +link{group:frozenFields}.
    // @group frozenFields
    // @visibility external
    //<

    //> @attr listGridField.canFreeze (boolean : null : IR)
    // Whether this field should display freezing/unfreezing options in its header context menu.
    // See +link{group:frozenFields}.
    // @see method:listGrid.getHeaderContextMenuItems()
    // @group frozenFields
    // @visibility external
    //<

    //> @attr listGridField.autoFreeze (boolean : null : IR)
    // Whether this field should be automatically frozen when other fields are frozen.  When
    // true, the field will be automatically frozen to the extreme of the grid.  The
    // automatically generated +link{listGrid.checkboxField, checkbox},
    // +link{listGrid.expansionField, expansion} and
    // +link{listGrid.rowNumberField, rowNumber} fields are examples of fields that specify
    // <code>autoFreeze: true</code>.
    // <P>
    // You can control the position of this field in the array of frozen fields by providing a
    // +link{listGridField.getAutoFreezePosition} implementation.
    // @group frozenFields
    // @visibility external
    //<

    //> @method listGridField.getAutoFreezePosition()
    // When a field has +link{listGridField.autoFreeze,autoFreeze} set to true, developers can
    // implement this method to indicate where in the frozen-fields array this field should
    // appear.
    // <P>
    // Some automatically generated fields, such as
    // +link{listGrid.rowNumberField, rowNumberField},
    // +link{listGrid.expansionField, expansionField} and
    // +link{listGrid.checkboxField, checkboxField}, provide default implementations of this
    // method.
    // @return (number) the index at which this autoFreeze field should appear in the frozen body
    // @group frozenFields
    // @visibility external
    //<

    //> @attr listGridField.canHide (boolean : null : IR)
    // If set to false, this field will be omitted from the column picker that appears in the
    // header context menu when +link{listGrid.canPickFields} is enabled.  This means that the
    // end user will not be able to hide it if it's currently shown, or show it if it's
    // currently hidden.
    // <P>
    // If this property is set to <code>false</code>, and the
    // +link{listGrid.useAdvancedFieldPicker,advanced field picker} is shown, if the field
    // is +link{hidden}, the field will not show in the list of available fields. If the
    // field is visible, it will be displayed in the list of currently visible fields, but
    // the advanced field picker user interface will disallow hiding it.
    //
    // @see method:listGrid.getHeaderContextMenuItems()
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridField.canDragResize (boolean : null : IR)
    // Whether this field can be dragResized using the mouse.  If unset, the default behavior
    // is governed by +link{listGrid.canResizeFields}.
    // @visibility external
    //<

    //> @attr listGridField.canReorder (boolean : null : IR)
    // Whether this field can be reordered using the mouse.  If unset, the default behavior is
    // governed by +link{listGrid.canReorderFields}.  Note that setting this property to
    // <code>false</code> will lock this field from being moved - that is, the user is
    // prevented from moving this field directly by dragging with the mouse, or by dropping
    // another field onto this field.
    // <P>
    // Note that setting <code>canReorder:false</code> on a field in the middle of a grid is
    // mostly useless, since it's possible that such a "locked" field may still be reordered
    // automatically, as a result of the user dragging one unlocked field onto another unlocked
    // field.
    // @group dragging
    // @visibility external
    //<

    //> @attr listGridField.ignoreKeyboardClicks (boolean : null : IRW)
    // If the user is navigating through the grid using the keyboard, record click or double click
    // events may be generated via keyboard interactions (see +link{listGrid.generateClickOnSpace},
    // +link{listGrid.generateClickOnEnter}, +link{listGrid.generateDoubleClickOnSpace},
    // +link{listGrid.generateDoubleClickOnEnter} and +link{listGrid.arrowKeyAction}).
    // <P>
    // These synthetic events have both a target row and column.
    // Setting this flag to true ensures that this field will never be considered the target for
    // a keyboard click event.
    // @group events
    // @visibility external
    //<



    //> @attr listGridField.excludeFromState
    // @include dataSourceField.excludeFromState
    // @see ListGrid.getViewState()
    //<


    //> @attr listGridField.excludeFromFieldPicker
    // @include dataSourceField.excludeFromFieldPicker
    //<

    // Grid, Group and Record-level summaries
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.showGridSummary (Boolean : null : IR)
    // If +link{listGrid.showGridSummary} is true, should this field show a summary value.
    // If unset, this field will show a summary value in the summary row if an
    // explicit +link{listGridField.summaryFunction} is specified or if a
    // +link{SimpleType.getDefaultSummaryFunction(),default summary function} is defined
    // for the specified field type.
    // @visibility external
    //<

    //> @attr listGridField.showGroupSummary (boolean : null : IR)
    // If +link{listGrid.showGroupSummary} is true, should this field show a summary value
    // in a summary row when the grid is grouped?
    // If unset, this field will show a summary value in the summary row if an
    // explicit +link{listGridField.summaryFunction} is specified or if a
    // +link{SimpleType.getDefaultSummaryFunction(),default summary function} is defined
    // for the specified field type.
    // @visibility external
    //<

    //> @attr listGridField.summaryFunction (SummaryFunction  or Array of SummaryFunction : null : IR)
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true,
    // this attribute can be used to specify
    // an explicit +link{type:SummaryFunction} for calculating the summary value to
    // display.
    // <P>
    // If an array of summaryFunctions is specified, they will be executed in turn and the
    // grid will show multiple summary rows at the grid or group level (or both)
    // containing the resulting values.
    // @visibility external
    //<

    //> @attr listGridField.summaryValueTitle (String : null : IR)
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true and the
    // +link{listGridField.summaryFunction} is set to <code>"title"</code>, this attribute may be
    // set to a string to display in the group and/or grid summary. If unspecified the
    // +link{listGridField.title} will show up in the summary.
    // @visibility external
    //<

    //> @method listGridField.getGridSummary() [A]
    // If +link{listGrid.showGridSummary} is true, and this method is specified it will be
    // called to generate the summary value to be displayed in the grid summary row. Note that
    // this is called instead of making use of the +link{listGridField.summaryFunction}.
    // <P>
    // As with +link{listGrid.getGridSummary()} this method may return an array of results -
    // in this case each result will show up in a separate row in the +link{listGrid.summaryRow}
    // grid.
    // <P>
    // If this grid is grouped, and +link{listGrid.showGroupSummary} is true, this method
    // will be passed a third parameter - an array of group-level summaries.
    // @param records (Array of ListGridRecord) records for which a summary is being generated
    // @param field (ListGridField) pointer to the field for which summary value is being generated
    // @param [groupSummaries] (Array of objects) If this grid is grouped and
    //  +link{listGrid.showGridSummary} is specified, this parameter contains an array of already-
    //  calculated summary values for each group in the grid. Each element in this array will
    //  be an object containing calculated summary values for each field in the grid, as well as
    //  a specified groupValue and groupName, allowing the developer to determine which group this
    //  summary value comes from
    // @return (any) summary value to display.
    // @visibility external
    //<

    //> @attr listGridField.formatGridSummary (stringMethod : null : IR)
    // Optional stringMethod to format the summary value displayed
    // in the +link{listGrid.showGridSummary,grid summary}.
    // Takes a single parameter <code>value</code> and should return the formatted version
    // of that value. If specified this will be applied instead of any formatting logic applied
    // via +link{listGridField.formatCellValue()}, +link{listGrid.formatCellValue()}, etc.
    // <P>
    // Note that for fields with a specified summary function of "count", if no custom formatting
    // is applied, we default to formatting the count value by appending
    // <code>field.pluralTitle</code> if defined, otherwise <code>field.title</code> to the
    // numeric count value returned by the standard count function. To change this behavior for
    // such fields, specify an explicit 'formatGridSummary' and/or 'formatGroupSummary' method
    // @visibility external
    //<

    //> @method listGridField.getGroupSummary() [A]
    // If +link{listGrid.showGroupSummary} is true, and this method is specified it will be
    // called to generate the field summary value to be displayed for each group level summary row.
    // Note that this is called instead of making use of the +link{listGridField.summaryFunction}.
    // <P>
    // This method may return an array of results - in this case the group will show multiple summary
    // rows, with each entry in the array showing up in a different record.
    //
    // @param records (Array of ListGridRecord) records for which a summary is being generated
    //  (so all records in the group).
    // @param field (ListGridField) pointer to the field for which summary value is being generated
    // @param [groupNode] (object) object with specified groupValue and groupName for this group
    // @return (any) summary value to display
    // @visibility external
    //<

    //> @attr listGridField.formatGroupSummary (stringMethod : null : IR)
    // Optional stringMethod to format the group level summary values for this field displayed via
    // +link{listGrid.showGroupSummary}.
    // Takes a single parameter <code>value</code> and should return the formatted version
    // of that value.  If specified this will be applied instead of any formatting logic applied
    // via +link{listGridField.formatCellValue()}, +link{listGrid.formatCellValue()}, etc.
    // <P>
    // Note that for fields with a specified summary function of "count", if no custom formatting
    // is applied, we default to formatting the count value by appending
    // <code>field.pluralTitle</code> if defined, otherwise <code>field.title</code> to the
    // numeric count value returned by the standard count function. To change this behavior for
    // such fields, specify an explicit 'formatGridSummary' and/or 'formatGroupSummary' method
    // @visibility external
    //<

    //> @method listGridField.getRecordSummary() [A]
    // Only applies to +link{listGridFieldType,summary-type} fields. If specified, this
    // method will be called to generate the record summary value to be displayed for each row
    // in this field.  When this method is called, current values for other
    // +link{listGridFieldType,summary-type} fields have not yet been stored on the record, but
    // are accessible via +link{listGrid.getRecordSummary()}.
    // <P>
    // Note that if specified, this is called instead of making use of the
    // +link{listGridField.recordSummaryFunction}.
    // <P>
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true, this
    // field's value in the summary row[s] will still be calculated by calling this method.
    // In this case, the record object passed in will contain summary values for each field.
    // If custom handling is required for this case, it may be detected by checking the
    // record object's +link{listGridRecord.isGroupSummary} and +link{listGridRecord.isGridSummary}
    // attributes.
    // @param record (ListGridRecord) record for which a summary is being generated
    // @param field (ListGridField) this field
    // @param grid (ListGrid) the grid
    // @return (any) summary value to display
    // @visibility external
    //<

    //> @attr listGridField.recordSummaryFunction (RecordSummaryFunction : null : IR)
    // Only applies to fields of type <code>"summary"</code>.
    // Fields of this type will display a calculated value based on the other field values
    // within the current record.
    // <P>
    // This attribute specifies how the summary field value will be calculated. See
    // +link{type:RecordSummaryFunction} for valid options.
    // <P>
    // A subset of the ListGrid's fields will be passed to the RecordSummaryFunction.
    // Which fields to include is determined based on +link{listGridField.includeInRecordSummary}
    // <P>
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true, this
    // field's value in the summary row[s] will still be calculated by calling this method.
    // In this case, the record object passed in will contain summary values for each field.
    // If custom handling is required for this case, it may be detected by checking the
    // record object's +link{listGridRecord.isGroupSummary} and +link{listGridRecord.isGridSummary}
    // attributes.
    // @visibility external
    //<

    //> @attr listGridField.partialSummary (boolean : null : IR)
    // Only applies to fields of type <code>"summary"</code>.
    // This attribute is set on a summary field, when calculating the summary value from
    // some record, the summary function will only be passed the fields before this summary field.
    // This may be useful for displaying running totals across a record.
    // <P>
    // Note that this feature would typically be used with
    // +link{listGrid.canReorderFields,canReorderFields:false}
    // @visibility external
    //<

    //> @attr listGridField.includeInRecordSummary (boolean : null : IR)
    // If a listGrid is showing a field of type summary, should this field be passed to the
    // recordSummaryFunction when calculating the summary value to display.
    // If unset, fields are included if they are of type "integer" or "float" only (since most
    // summary functions perform numeric calculations). See also
    // +link{listGridField.includeInRecordSummaryFields}.
    // @visibility external
    //<

    //> @attr listGridField.includeInRecordSummaryFields (array of fieldNames : null : IR)
    // If this listGrid has any fields of type <code>"summary"</code> and
    // this field will be +link{listGridField.includeInRecordSummary,included} in summary calculations
    // by default, this attribute provides an opportunity to explicitly specify which summary fields
    // the record should be displayed in.
    // <P>
    // Specified as an array of fieldNames. If set, this field value will only be included for
    // record summary value calculations for summary fields who's name is included in this array.
    // @visibility external
    //<

    //> @attr listGridField.applyAfterSummary (Boolean : null : IRW)
    // If +link{listGridField.userFormula} is set for this field, and this grid is showing
    // +link{listGrid.showGroupSummary,group summaries} or a
    // +link{listGrid.showGridSummary,grid summary}, this property determines what field value
    // should be present in those summary rows. Should the field apply the user-formula to the
    // calculated summary row, or should it apply a standard grid or group summary to the
    // user-formula values displayed in the grid?
    // <P>
    // Default behavior may be specified at the grid level via +link{listGrid.applyFormulaAfterSummary}
    // @visibility external
    //<

    // Header button icons
    // ---------------------------------------------------------------------------------------
    // Include all relevant docs from StatefulCanvas

    //> @attr listGridField.icon (SCImgURL: null : [IR])
    // Optional icon to show next to the title for this field.
    // Should be set to a URL to an image. Relative paths will be evaluated starting at
    // the imgDir of this component. This URL is partial - it may be updated to indicate
    // the current disabled (etc) state of the field.
    // <p>
    // If +link{listGridField.type,field.type} is set to "icon", this icon will also be shown
    // in every cell of this field - see also +link{listGridField.cellIcon,field.cellIcon}.
    // <p>
    // To change this property after fields have been passed to +link{listGrid.setFields()},
    // use +link{listGrid.setFieldIcon()}.
    //
    // @visibility external
    //<

    //> @attr listGridField.iconSize (integer : null : [IR])
    // If +link{listGridField.icon} is specified, this property can be used to specify the
    // size of the icon to be displayed in the ListGrid header button.
    // (See +link{StatefulCanvas.iconSize})
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.iconWidth (integer : null : [IR])
    // If +link{listGridField.icon} is specified, this property can be used to specify the
    // width of the icon to be displayed in the ListGrid header button.
    // (See +link{StatefulCanvas.iconWidth})<br>
    // If this field is editable, and +link{ListGridField.editorIconWidth} is unset, this
    // property will be passed onto the editors for this field as +link{FormItem.iconWidth},
    // which will effect the default size for +link{ListGridField.icons, icons} displayed
    // in the editor.
    // @see listGridField.icon
    // @see listGridField.icons
    // @visibility external
    //<

    //> @attr listGridField.iconHeight (integer : null : [IR])
    // If +link{listGridField.icon} is specified, this property can be used to specify the
    // height of the icon to be displayed in the ListGrid header button.
    // (See +link{StatefulCanvas.iconHeight})<br>
    // If this field is editable, and +link{ListGridField.editorIconHeight} is unset, this
    // property will be passed onto the editors for this field as +link{FormItem.iconWidth},
    // which will effect the default size for +link{ListGridField.icons, icons} displayed
    // in the editor.
    // @see listGridField.icon
    // @see listGridField.icons
    // @visibility external
    //<

    //> @attr listGridField.iconOrientation (string : "left" : [IR])
    // If this field is showing an icon, should it appear to the left or right of the title?<br>
    // Valid options are <code>"left"</code> or <code>"right"</code>
    // @see listGridField.icon
    // @visibility external
    //<
    // iconOrientation JS doc not included from statefulCanvas as that refers to
    // setIconOrientation(), and we don't have an exposed way to get at the ListGrid field
    // header button at runtime.

    //> @attr listGridField.iconSpacing (int : 6 : [IR])
    // @include statefulCanvas.iconSpacing
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showDisabledIcon (Boolean : true : [IR])
    // @include statefulCanvas.showDisabledIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showRollOverIcon (Boolean : false : [IR])
    // @include statefulCanvas.showRollOverIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showFocusedIcon (Boolean : false : [IR])
    // @include statefulCanvas.showFocusedIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showDownIcon (Boolean : false : [IR])
    // @include statefulCanvas.showDownIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showSelectedIcon (Boolean : false : [IR])
    // @include statefulCanvas.showSelectedIcon
    // @see listGridField.icon
    //  @visibility external
    //<

    //> @attr listGridField.cellIcon (SCImgURL : null : [IR])
    // For a field of type:"icon" only, set the icon that appears in body cells.  Unless
    // setting +link{listGridField.icon,field.icon}, setting field.cellIcon will not show an
    // icon in the header.
    // <p>
    // To change this property after fields have been passed to +link{listGrid.setFields()},
    // use +link{listGrid.setFieldCellIcon()}.
    //
    // @visibility external
    //<

    //> @attr listGridField.showFileInline (boolean : null : [IR])
    // For a field of type:"imageFile", indicates whether to stream the image and display it
    // inline or to display the View and Download icons.
    //
    // @visibility external
    //<

    //> @attr listGridField.format (FormatString : null : IR)
    // +link{FormatString} for numeric or date formatting.  See +link{dataSourceField.format}.
    // @group exportFormatting
    // @visibility external
    //<

    //> @attr listGridField.exportFormat (FormatString : null : IR)
    // +link{FormatString} used during exports for numeric or date formatting.  See
    // +link{dataSourceField.exportFormat}.
    // @group exportFormatting
    // @visibility external
    //<

    // FormItem icons
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.icons (Array of FormItemIcon Properties: null : [IRA])
    // If this field is editable, this property can be used to specify
    // +link{FormItem.icons, icons} to be displayed in the editors displayed for this field
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.editorIconWidth (number : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconWidth}.<br>
    // If this property unset, the iconWidth property from the editor can be picked up from
    // +link{listGridField.iconWidth} instead.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.editorIconHeight (number : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconHeight}.<br>
    // If this property unset, the iconHeight property from the editor can be picked up from
    // +link{listGridField.iconHeight} instead.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.defaultIconSrc (string : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.defaultIconSrc}.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.iconPrompt (string : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconPrompt}.
    // @see listGridField.icons
    // @group editing
    // @visibility internal
    //<

    //> @attr listGridField.iconHSpace (string : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconHSpace}.
    // @see listGridField.icons
    // @group editing
    // @visibility internal
    //<

    //> @attr listGridField.iconVAlign (string : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconVAlign}.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    // editor picker icon

    //> @attr listGridField.showPickerIcon (boolean : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.showPickerIcon}.
    // @group editing
    // @visibility pickerIcon
    //<

    //> @attr listGridField.pickerIconSrc (string : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.pickerIconSrc}.
    // @group editing
    // @visibility pickerIcon
    //<

    //> @attr listGridField.pickerIconWidth (integer : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.pickerIconWidth}.
    // @group editing
    // @visibility pickerIcon
    //<

    //> @attr listGridField.pickerIconHeight (integer : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.pickerIconHeight}.
    // @group editing
    // @visibility pickerIcon
    //<

    // Summary Title
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.summaryTitle (string : null : [IRWA])
    // Optional long summary title for this field, provided in addition to
    // +link{listGridField.title}. This gives the developer an option to use a very short,
    // or empty title for the ListGrid column (where space may be a factor), but have a longer
    // value available to be used elsewhere.
    // <p>
    // By default this value will be used for the title of the context-menu item
    // for showing/hiding the listGrid field when the user right-clicks on the ListGrid header.
    //
    // @group appearance
    // @see attr:listGridField.title
    // @deprecated Rather than customizing the summaryTitle developers should typically use
    //  the +link{listGridField.headerTitle} attribute to show a different
    //  title in the column header button than the title used elsewhere.
    // @visibility external
    //<

    //> @method listGridField.getSummaryTitle() [A]
    // Optional string method to return a long summary title for this field, if a dynamic
    // summary title is required for this field.
    //
    // @param viewer (listGrid) pointer back to the ListGrid
    // @param field (listGridField) pointer to the field object
    // @group appearance
    // @see attr:listGridField.summaryTitle
    // @see attr:listGridField.title
    // @deprecated Rather than customizing the summaryTitle developers should typically use
    //  the +link{listGridField.headerTitle} attribute to show a different
    //  title in the column header button than the title used elsewhere.
    // @visibility external
    //<

    // Header Appearance
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.width (Number or String : "*" : [IRW])
    // The width of this field, specified as either an absolute number of pixels,
    // a percentage of the remaining space like "25%", or "*" to split remaining space among
    // all fields which have "*". <P>
    // Caution: stretch sizes are currently ignored if the field is being autofitted
    // (see +link{listGrid.autoFitFieldWidths}), unless +link{listGrid.showHeader} is false.
    // <P>
    // Note: if autofitting is active for a field, the width will default to the numerical
    // autofit width for that field (so it will not be stretched larger to fill available
    // space).  Otherwise, if not autofitting, the width will default to "*" causing it to be
    // automatically stretched.
    // <P>
    // The width may be defaulted to a numerical value based on +link{dataSourceField.length}
    // if no +link{listGridField.valueMap} is set, subject to the initial values of
    // +link{minWidth} and +link{listGrid.minFieldWidth}.  If you'd rather have the field
    // stretched-sized to fit the available space, set its initial width to "*".
    // <P>
    // See also +link{listGrid.minFieldWidth} to ensure no field goes below a minimum size.
    // <P>
    // Use +link{listGrid.resizeField} to programmatically change field width after creation.
    // <P>
    // Use +link{listGrid.getFieldWidth} to access the rendered field width after
    // the ListGrid is drawn.
    //
    // @see ListGrid.autoFitFieldWidths
    // @see listGridField.minWidth
    // @see listGridField.maxWidth
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridField.minWidth (Number : null : [IR])
    // When a field is subject to autofitting (see +link{listGrid.autoFitFieldWidths}), sets the
    // minimum width of the field.  The actual allowed minimum will be the maximum of:<ul>
    // <li> this property,
    // <li> +link{width} (if a number),
    // <li> the aufofit value determined by the widest value content in this field's column
    // <li> +link{listGrid.minFieldWidth}
    // </ul>
    // @group appearance
    // @see listGridField.width
    // @visibility external
    //<

    //> @attr listGridField.maxWidth (Number : null : [IR])
    // When +link{listGrid.showHeader} is false and a field is subject to autofitting (see
    // +link{listGrid.autoFitFieldWidths}), sets the maximum width of the field.  The actual
    // effective maximum will be the largest of this property, +link{minWidth}, and
    // +link{listGrid.minFieldWidth}.  That is, +link{minWidth} and
    // +link{listGrid.minFieldWidth} dominate this property.
    // @group appearance
    // @see listGridField.width
    // @visibility external
    //<

    //> @attr   listGridField.align (Alignment : null : [IRW])
    // Horizontal alignment for field's column header: "left", "right"
    // or "center". Applied to the column header title and cells by default. A separate
    // alignment for cells can be specified via +link{listGridField.cellAlign}.<br>
    // If null, values are left-aligned. If this field is editable, the
    // alignment of cells in the body will also be reflected in any editors for the field.
    //  @group  appearance
    //  @visibility external
    //<

    //> @attr listGridField.headerBaseStyle (CSSClass : null : [IRW])
    // Custom base style to apply to this field's header button instead of
    // +link{listGrid.headerBaseStyle}.<br>
    // Note that depending on the header button constructor, you may have to override
    // +link{listGridField.headerTitleStyle} as well.
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridField.headerTitleStyle (CSSClass : null : [IRW])
    // Custom titleStyle to apply to this field's header button instead of
    // +link{listGrid.headerTitleStyle}.<br>
    // Note that this will typically only have an effect if
    // +link{listGrid.headerButtonConstructor} is set to +link{class:StretchImgButton} or a subclass
    // thereof.
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridField.headerTitle (string : null : IR)
    // Optional title for the header button for this field. If specified this will be
    // displayed in the header button instead of +link{listGridField.title} or
    // +link{listGridField.name}. Set to an empty string to suppress the title in the
    // header button entirely.
    // @group appearance
    // @see listGridField.title
    // @visibility external
    //<



    // Header Spans
    // ---------------------------------------------------------------------------------------
    // - known limitations
    //   - can't reorder a column to before or after a spanned set of columns, if the spanned
    //   columns are at the start or end of the visible fields.
    //   - several uses of this.Super(), instead of the faster this.invokeSuper() approach.
    //   Attempt to use invokeSuper() failed, likely because the header is not a discrete
    //   class, but an instance of Toolbar, and my guess (Alex) is that Class.invokeSuper()
    //   doesn't handle this particular case.


    //> @attr listGrid.headerSpans (Array of HeaderSpan : null : IRW)
    // Header spans are a second level of headers that appear above the normal ListGrid headers,
    // spanning one or more listGrid fields in a manner similar to a column-spanning cell in an
    // HTML table.
    // <P>
    // A header span can be created by simply naming the fields the header should span.  The
    // example below creates a headerSpan that spans the first two fields of the ListGrid.
    // <smartclient>
    // <pre>
    //    isc.ListGrid.create({
    //        headerHeight:40,
    //        fields : [
    //            { name:"field1" },
    //            { name:"field2" },
    //            { name:"field3" }
    //        ],
    //        headerSpans : [
    //            {
    //                fields: ["field1", "field2"],
    //                title: "Field 1 and 2"
    //            }
    //        ]
    //    });
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //      ListGrid grid = new ListGrid();
    //      grid.setHeaderHeight(40);
    //      grid.setFields(new ListGridField[] {
    //          new ListGridField("field1"),
    //          new ListGridField("field2"),
    //          new ListGridField("field3")
    //      });
    //      grid.setHeaderSpans(new HeaderSpan[] {
    //          new HeaderSpan("Field 1 and 2", new String[] {"field1", "field2"})
    //      });
    // </pre>
    // </smartgwt>
    // Header spans can be nested, allowing fields to be grouped by multiple levels of
    // granularity. See +link{headerSpan.spans} for further information on nesting spans.
    // <P>
    // Header spans will automatically react to resizing of the headers they span, and will be
    // hidden automatically when all of the spanned fields are hidden.
    // <P>
    // Header spans appear in the +link{listGrid.header,header} area of the ListGrid, sharing space
    // with the existing headers, so it's typical to set +link{listGrid.headerHeight} to
    // approximately double its normal height when using headerSpans, or if using nested header
    // spans, the default header height multiplied by the number of levels of header spans to be
    // shown.
    // <P>
    // See +link{headerSpan} for many properties that allow the control of the appearance of
    // headerSpans.
    // <smartclient>
    // Note that headerSpans are created via the +link{AutoChild} pattern, hence
    // you can change the SmartClient component being used, or any of its properties.
    // </smartclient>
    // <P>
    // Neither headerSpans themselves nor the fields within them may be drag reordered, but other
    // unspanned headers may be.
    // <P>
    // A span can only span adjacent fields - if a span is defined and the spanned fields don't
    // sit next to each other in the specified fields array, the fields array will be automatically
    // reordered to match the order specified in the span's +link{headerSpan.fields} array.
    // <P>
    // Note that headerSpans primarily provide a visual cue for grouping multiple headers
    // together.  If you have an OLAP, data "cube" or multi-dimensional data model, the
    // +link{CubeGrid} component is the right choice.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpanHeight (integer : null : IR)
    // Default height for a +link{listGrid.headerSpans,headerSpan} with no height specified.
    // <P>
    // If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2
    // of +link{listGrid.headerHeight}.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpanVAlign (vAlign : "center" : IR)
    // Default alignment for +link{listGrid.headerSpans,headerSpans} with no
    // +link{headerSpan.valign} specified.
    //
    // @group headerSpan
    // @visibility external
    //<
    headerSpanVAlign: "center",

    //> @attr listGrid.unspannedHeaderVAlign (vAlign : null : IR)
    // When +link{listGrid.headerSpans,headerSpans} are in use, this property sets the default
    // vertical alignment for for fields which do <b>not</b> have a headerSpan.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpanConstructor (SCClassName : null : IR)
    // +link{SCClassName,SmartClient Class} to use for headerSpans.  Typically a +link{Button} or
    // +link{StretchImgButton} subclass.
    // <P>
    // If unset, headerSpans will be created using the +link{listGrid.headerButtonConstructor}.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpan (MultiAutoChild StatefulCanvas : null : IR)
    // +link{listGrid.headerSpans,headerSpans} are created via the +link{AutoChild} pattern, hence
    // <code>headerSpanConstructor</code>, <code>headerSpanDefaults</code> and
    // <code>headerSpanProperties</code> are valid.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @object HeaderSpan
    // A header span appears as a second level of headers in a ListGrid, spanning one or more
    // ListGrid columns and their associated headers.
    // <P>
    // See +link{listGrid.headerSpans}.
    // <P>
    // In addition to the properties documented here, all other properties specified on the
    // headerSpan object will be passed to the +link{Class.create,create()} method of the
    // +link{listGrid.headerSpanConstructor}.  This allows you to set properties such as
    // +link{button.baseStyle} or +link{stretchImgButton.src} directly in a
    // <code>headerSpan</code>.
    //
    // @group headerSpan
    // @treeLocation Client Reference/Grids/ListGrid
    // @visibility external
    //<

    //> @attr headerSpan.name (identifier : null : IR)
    // Name for this headerSpan, for use in APIs like +link{listGrid.setHeaderSpanTitle()}.
    // <P>
    // Name is optional, but if specified, must be unique for this ListGrid (but not globally
    // unique) as well as a valid JavaScript identifier, as specified by ECMA-262 Section 7.6
    // (the <smartclient>+link{String.isValidID()}</smartclient><smartgwt>StringUtil.isValidID()</smartgwt>
    // function can be used to test whether a name is a valid JavaScript identifier).
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.fields (Array of String : null : IR)
    // List of fields that this header spans.  Fields should be identified by their value for
    // +link{listGridField.name}.
    // <P>
    // Developers may define multiple levels of header-spans by specifying +link{headerSpan.spans}
    // however a span cannot be specified with both <code>fields</code> and <code>spans</code>.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.spans (Array of HeaderSpan : null : IR)
    // This property allows developer to "nest" header spans, grouping fields together by
    // multiple layers of granularity.
    // <P>
    // For example a group of fields could be nested within two layers of header spans as follows:
    // <smartclient>
    // <pre>
    // { title:"Europe", spans:[
    //      {title:"France", fields:["Paris", "Lyon"]},
    //      {title:"UK", fields:["London", "Glasgow"]},
    //      {title:"Spain", fields:["Barcelona"]}
    //  ]
    // }
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //      HeaderSpan france = new HeaderSpan("France", new String[] {"Paris", "Lyon"});
    //      HeaderSpan uk = new HeaderSpan("UK", new String[] {"London", "Glasgow"});
    //      HeaderSpan spain = new HeaderSpan("Spain", new String[] {"Barcelona"});
    //
    //      HeaderSpan europe = new HeaderSpan();
    //      europe.setTitle("Europe");
    //      europe.setSpans(france, uk, spain);
    // </pre>
    // </smartgwt>
    // Note that a span definition can not include both <code>spans</code>
    // and +link{headerSpan.fields,fields}.
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.title (String : null : IR)
    // A title for this headerSpan, to display in the headerSpan button for this headerSpan
    // and in other contexts such as the +link{listGrid.canPickFields,menu for picking visible fields}.
    //
    // Note: if you want to use HTML tags to affect the display of the header, you should do so
    // via +link{headerSpan.headerTitle} instead so that other places where the title
    // appears in the UI are not affected.  Refer to discussion at +link{listGridField.title}.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.headerTitle (String : null : IR)
    // Optional title for the headerSpan button for this headerSpan. If specified this will be
    // displayed in the headerSpan button instead of +link{headerSpan.title}. Set to an empty
    // string to suppress the title in the header button entirely.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.headerBaseStyle (CSSClass : null : [IRW])
    // Custom base style to apply to the header button created for this span instead
    // of +link{listGrid.headerBaseStyle}.
    // <P>
    // Note that depending on the header button constructor, you may have to specify
    // +link{headerSpan.headerTitleStyle} as well.
    // @group appearance
    // @visibility external
    //<

    //> @attr headerSpan.headerTitleStyle (CSSClass : null : [IRW])
    // Custom titleStyle to apply to the header button created for this span instead of
    // +link{listGrid.headerTitleStyle}.
    // <p>
    // Note that this will typically only have an effect if
    // +link{listGrid.headerButtonConstructor} is set to +link{class:StretchImgButton} or a subc