/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.Authentication;
import com.isomorphic.auth.ConfigAuthenticator;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.RegexRule;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
extends URIRegexFilter {
    public String loginPage = "/isomorphic/login/iscAuth/login.html";
    public String logoutPage = "/isomorphic/login/iscAuth/logout.html";
    public String maxLoginAttemptsExceededPage = "/isomorphic/login/iscAuth/maxLoginAttemptsExceeded.html";
    public String defaultLoginRedirect = "/";
    public String initialTargetParam = "initialTarget";
    public int maxTries = -1;
    public String realm;
    public String username;
    public String password;
    protected IAuthenticator authenticator = null;
    protected Logger log;
    protected boolean enabled = Authentication.enabled;
    protected String filterName;

    public void setLoginPage(String value) {
        this.loginPage = value;
    }

    public void setLogoutPage(String value) {
        this.logoutPage = value;
    }

    public void setMaxLoginAttemptsExceededPage(String value) {
        this.maxLoginAttemptsExceededPage = value;
    }

    public void setDefaultLoginRedirect(String value) {
        this.defaultLoginRedirect = value;
    }

    public void setInitialTargetParam(String value) {
        this.initialTargetParam = value;
    }

    public void setMaxTries(String value) {
        this.maxTries = Integer.valueOf(value);
    }

    public void setRealm(String value) {
        this.realm = value;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setAuthenticator(String value) throws Exception {
        String name = value;
        String authenticatorImpl = config.getString("authenticator." + name);
        if (authenticatorImpl == null) {
            throw new Exception("Can't find config block for authenticator: " + name + " - looking for authenticator." + name + " block in server.properties");
        }
        try {
            Reflection.classForName(authenticatorImpl);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("authenticator." + name + " defines: " + authenticatorImpl + " as its implementor, but no such class exists in the runtime (class.forName())");
        }
        this.authenticator = (IAuthenticator)config.getClassInstance("authenticator." + name);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.username != null && this.password != null && ServletTools.servletOrFilterParametersToMap(filterConfig).get("authenticator") == null) {
            try {
                this.setAuthenticator("simpleConfig");
            }
            catch (Exception e) {
                this.log.error((Object)"can't auto-initialize simpleConfig authenticator - check your configuration", e);
                throw new ServletException(e.toString());
            }
        }
        if (this.authenticator instanceof ConfigAuthenticator) {
            if (this.username != null) {
                ((ConfigAuthenticator)this.authenticator).username = this.username;
            }
            if (this.password != null) {
                ((ConfigAuthenticator)this.authenticator).password = this.password;
            }
        }
        if (this.realm == null) {
            this.realm = filterConfig.getFilterName();
        }
        this.log = new Logger(this.getClass().getName(), filterConfig.getFilterName() + " (realm: " + this.realm + ")");
        try {
            if (!this.enabled) {
                this.log.warn("AuthenticationFilter present in web.xml, but authentication globally disabled in config via authentication.enabled: false.  Not initializing, will allow all requests without any checks.");
                return;
            }
            this.setDefaultAction("match");
            if (this.rules == null) {
                this.log.info("No rules file defined, treating all intercepted resources as private");
            } else {
                try {
                    this.rules.add(0, new RegexRule("match:#^/isomorphic/login/loginSuccessMarker.html#", "authFilter default"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Error initializing known good regex rule", e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize AuthenticationFilter.", e);
            throw new ServletException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        block100: {
            block87: {
                block99: {
                    block86: {
                        block98: {
                            block85: {
                                block97: {
                                    block84: {
                                        block96: {
                                            block83: {
                                                block95: {
                                                    block82: {
                                                        block94: {
                                                            block81: {
                                                                block93: {
                                                                    block80: {
                                                                        block92: {
                                                                            block79: {
                                                                                block91: {
                                                                                    block78: {
                                                                                        block90: {
                                                                                            block76: {
                                                                                                block77: {
                                                                                                    request = (HttpServletRequest)req;
                                                                                                    response = (HttpServletResponse)res;
                                                                                                    context = null;
                                                                                                    pushedLogContext = false;
                                                                                                    try {
                                                                                                        try {
                                                                                                            if (!this.enabled) {
                                                                                                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                                                                                                var19_8 = null;
                                                                                                                if (!pushedLogContext) break block76;
                                                                                                                break block77;
                                                                                                            }
                                                                                                            request.setAttribute("_isc_authenticationEnabled", (Object)new Boolean(true));
                                                                                                            context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
                                                                                                            context.session = request.getSession(true);
                                                                                                            context.request.setAttribute(Authentication.authenticatorKey, this.authenticator);
                                                                                                            this.authenticator.setRealm(context, this.realm);
                                                                                                            comparePath = ServletTools.getInitialRequestURI(request);
                                                                                                            initialTarget = context.request.getQueryParameter(this.initialTargetParam);
                                                                                                            if (comparePath.equals(this.loginPage) && initialTarget != null) {
                                                                                                                this.authenticator.setInitialTarget(context, initialTarget);
                                                                                                            }
                                                                                                            if (initialTarget == null) {
                                                                                                                initialTarget = this.authenticator.getInitialTarget(context);
                                                                                                            }
                                                                                                            if (this.authenticator.containsCredentials(context)) {
                                                                                                                loginCounter = this.authenticator.getLoginCounter(context);
                                                                                                                if (this.maxTries > 0 && loginCounter < this.maxTries || this.maxTries < 0) {
                                                                                                                    user = this.authenticator.authenticate(context);
                                                                                                                    if (user != null) {
                                                                                                                        this.authenticator.setUser(context, user);
                                                                                                                        this.log.info("Authentication attempt succeeded");
                                                                                                                        this.authenticator.setLoginCounter(context, 0);
                                                                                                                        this.authenticator.setInitialTarget(context, null);
                                                                                                                        ServletTools.clearCookie("loginRedirect", context, this.loginPage, null);
                                                                                                                        if (comparePath.equals(this.loginPage)) {
                                                                                                                            if (initialTarget == null) {
                                                                                                                                initialTarget = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                                                                                                                            }
                                                                                                                            this.log.debug("Sending to initial target: " + initialTarget);
                                                                                                                            response.sendRedirect(initialTarget);
                                                                                                                            break block78;
                                                                                                                        }
                                                                                                                    } else {
                                                                                                                        if (this.maxTries > 0) {
                                                                                                                            this.authenticator.setLoginCounter(context, ++loginCounter);
                                                                                                                        }
                                                                                                                        this.log.info("Authentication failed, try # " + loginCounter);
                                                                                                                    }
                                                                                                                }
                                                                                                                if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                                                                                                                    this.log.debug("Attempt to authenticate, but maxTries (" + this.maxTries + ") has been reached");
                                                                                                                    this.maxLoginsExceeded(context, comparePath);
                                                                                                                    break block79;
                                                                                                                }
                                                                                                            }
                                                                                                            if (comparePath.equals("/favicon.ico")) {
                                                                                                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                                                                                                break block80;
                                                                                                            }
                                                                                                            if (comparePath.equals(this.maxLoginAttemptsExceededPage)) {
                                                                                                                context.setNoCacheHeaders();
                                                                                                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                                                                                                break block81;
                                                                                                            }
                                                                                                            if (comparePath.equals(this.logoutPage)) {
                                                                                                                user = this.authenticator.getUser(context);
                                                                                                                if (user != null) {
                                                                                                                    this.log.debug("Logging out (uid: " + user.getName() + ")");
                                                                                                                    this.authenticator.logout(context);
                                                                                                                }
                                                                                                                context.setNoCacheHeaders();
                                                                                                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                                                                                                break block82;
                                                                                                            }
                                                                                                            if (comparePath.equals(this.loginPage)) {
                                                                                                                loginRedirect = this.authenticator.getInitialTarget(context);
                                                                                                                if (loginRedirect == null) {
                                                                                                                    loginRedirect = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                                                                                                                }
                                                                                                                if ((currentRedirect = ServletTools.getCookieValue("loginRedirect", (HttpServletRequest)context.request)) == null) {
                                                                                                                    ServletTools.setCookie(context, "loginRedirect", loginRedirect, this.loginPage);
                                                                                                                }
                                                                                                                if (this.authenticator.getInitialTargetJsCallback(context) != null) {
                                                                                                                    RPCManager.writeIframePrefix(response.getWriter(), null, context, this.authenticator.getInitialTargetJsCallback(context));
                                                                                                                }
                                                                                                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                                                                                                if (this.authenticator.getInitialTargetJsCallback(context) != null) {
                                                                                                                    RPCManager.writeIframePostfix(response.getWriter());
                                                                                                                    this.authenticator.setInitialTargetJsCallback(context, null);
                                                                                                                }
                                                                                                                break block83;
                                                                                                            }
                                                                                                            matchedRule = this.applyRules(comparePath);
                                                                                                            action = matchedRule.getAction();
                                                                                                            if ("block".equals(action)) {
                                                                                                                context.response.sendError(404);
                                                                                                                this.log.warn("DENIED to access blocked resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
                                                                                                                break block84;
                                                                                                            }
                                                                                                            if ("match".equals(action)) {
                                                                                                                userId = this.authenticator.getUserId(context);
                                                                                                                if (userId == null) {
                                                                                                                    context.setNoCacheHeaders();
                                                                                                                    loginCounter = this.authenticator.getLoginCounter(context);
                                                                                                                    if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                                                                                                                        this.maxLoginsExceeded(context, comparePath);
                                                                                                                        break block85;
                                                                                                                    }
                                                                                                                    this.authenticator.setInitialTarget(context, this.getInitialTarget(context));
                                                                                                                    if (context.request.isMultipart() && (t = (String)(reqProps = context.request.getStringParams()).get("_transaction")) != null) {
                                                                                                                        vc = new ValidationContext();
                                                                                                                        vc.setRestrictedXMLMode(true);
                                                                                                                        to = XML.toDSRecords(new StringReader(t), vc);
                                                                                                                        vc.freeResources();
                                                                                                                        this.authenticator.setInitialTargetJsCallback(context, (String)((Map)to).get("jscallback"));
                                                                                                                    }
                                                                                                                    response.sendRedirect(ServletTools.adjustForContextPath(this.loginPage, request));
                                                                                                                    why = "not authenticated for realm: " + this.realm;
                                                                                                                    this.log.debug("REDIRECTING user to login page: " + this.loginPage + " for access to private resource: " + comparePath + " (" + why + ")");
                                                                                                                    break block86;
                                                                                                                }
                                                                                                                if (request.getAttribute("isc_auth_uid") == null) {
                                                                                                                    Logger.pushContext("uid: " + userId.toString());
                                                                                                                    pushedLogContext = true;
                                                                                                                    request.setAttribute("isc_auth_uid", userId);
                                                                                                                }
                                                                                                                if (this.log.isDebugEnabled()) {
                                                                                                                    this.log.debug("ALLOWED authenticated access (uid: " + userId.toString() + ") to private resource: " + comparePath);
                                                                                                                }
                                                                                                            } else if (this.log.isDebugEnabled()) {
                                                                                                                this.log.debug("ALLOWED access to public resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
                                                                                                            }
                                                                                                            wrappedRequest = new ISCHttpServletRequest(request);
                                                                                                            wrappedRequest.setPrincipalContext(context, this.authenticator);
                                                                                                            this.authenticator.track(context);
                                                                                                            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
                                                                                                            break block87;
                                                                                                        }
                                                                                                        catch (ServletException se) {
                                                                                                            throw se;
                                                                                                        }
                                                                                                        catch (IOException ioe) {
                                                                                                            throw ioe;
                                                                                                        }
                                                                                                        catch (Exception e) {
                                                                                                            this.log.error("Caught exception in doFilter() - for URI: " + request.getRequestURI() + "\n" + DataTools.getStackTrace(e));
                                                                                                            var19_19 = null;
                                                                                                            if (pushedLogContext) {
                                                                                                                Logger.popContext();
                                                                                                            }
                                                                                                            if (context == null) return;
                                                                                                            try {
                                                                                                                context.completeResponse();
                                                                                                            }
                                                                                                            catch (Exception var20_32) {
                                                                                                                // empty catch block
                                                                                                            }
                                                                                                            try {
                                                                                                                response.flushBuffer();
                                                                                                                return;
                                                                                                            }
                                                                                                            catch (Exception var20_32) {
                                                                                                                return;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    catch (Throwable var18_50) {
                                                                                                        block89: {
                                                                                                            var19_20 = null;
                                                                                                            if (pushedLogContext) {
                                                                                                                Logger.popContext();
                                                                                                            }
                                                                                                            if (context == null) throw var18_50;
                                                                                                            ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl154:
                                                                                                            // 1 sources

                                                                                                            context.completeResponse();
                                                                                                            break block89;
lbl156:
                                                                                                            // 1 sources

                                                                                                            catch (Exception var20_33) {
                                                                                                                // empty catch block
                                                                                                            }
                                                                                                        }
                                                                                                        ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl160:
                                                                                                        // 1 sources

                                                                                                        response.flushBuffer();
                                                                                                        throw var18_50;
lbl162:
                                                                                                        // 1 sources

                                                                                                        catch (Exception var20_33) {
                                                                                                            // empty catch block
                                                                                                        }
                                                                                                        throw var18_50;
                                                                                                    }
                                                                                                }
                                                                                                Logger.popContext();
                                                                                            }
                                                                                            if (context == null) return;
                                                                                            ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl170:
                                                                                            // 1 sources

                                                                                            context.completeResponse();
                                                                                            break block90;
lbl172:
                                                                                            // 1 sources

                                                                                            catch (Exception var20_21) {
                                                                                                // empty catch block
                                                                                            }
                                                                                        }
                                                                                        ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl176:
                                                                                        // 1 sources

                                                                                        response.flushBuffer();
                                                                                        return;
lbl178:
                                                                                        // 1 sources

                                                                                        catch (Exception var20_21) {
                                                                                            // empty catch block
                                                                                        }
                                                                                        return;
                                                                                    }
                                                                                    var19_9 = null;
                                                                                    if (pushedLogContext) {
                                                                                        Logger.popContext();
                                                                                    }
                                                                                    if (context == null) return;
                                                                                    ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl187:
                                                                                    // 1 sources

                                                                                    context.completeResponse();
                                                                                    break block91;
lbl189:
                                                                                    // 1 sources

                                                                                    catch (Exception var20_22) {
                                                                                        // empty catch block
                                                                                    }
                                                                                }
                                                                                ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl193:
                                                                                // 1 sources

                                                                                response.flushBuffer();
                                                                                return;
lbl195:
                                                                                // 1 sources

                                                                                catch (Exception var20_22) {
                                                                                    // empty catch block
                                                                                }
                                                                                return;
                                                                            }
                                                                            var19_10 = null;
                                                                            if (pushedLogContext) {
                                                                                Logger.popContext();
                                                                            }
                                                                            if (context == null) return;
                                                                            ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl204:
                                                                            // 1 sources

                                                                            context.completeResponse();
                                                                            break block92;
lbl206:
                                                                            // 1 sources

                                                                            catch (Exception var20_23) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl210:
                                                                        // 1 sources

                                                                        response.flushBuffer();
                                                                        return;
lbl212:
                                                                        // 1 sources

                                                                        catch (Exception var20_23) {
                                                                            // empty catch block
                                                                        }
                                                                        return;
                                                                    }
                                                                    var19_11 = null;
                                                                    if (pushedLogContext) {
                                                                        Logger.popContext();
                                                                    }
                                                                    if (context == null) return;
                                                                    ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl221:
                                                                    // 1 sources

                                                                    context.completeResponse();
                                                                    break block93;
lbl223:
                                                                    // 1 sources

                                                                    catch (Exception var20_24) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl227:
                                                                // 1 sources

                                                                response.flushBuffer();
                                                                return;
lbl229:
                                                                // 1 sources

                                                                catch (Exception var20_24) {
                                                                    // empty catch block
                                                                }
                                                                return;
                                                            }
                                                            var19_12 = null;
                                                            if (pushedLogContext) {
                                                                Logger.popContext();
                                                            }
                                                            if (context == null) return;
                                                            ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl238:
                                                            // 1 sources

                                                            context.completeResponse();
                                                            break block94;
lbl240:
                                                            // 1 sources

                                                            catch (Exception var20_25) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl244:
                                                        // 1 sources

                                                        response.flushBuffer();
                                                        return;
lbl246:
                                                        // 1 sources

                                                        catch (Exception var20_25) {
                                                            // empty catch block
                                                        }
                                                        return;
                                                    }
                                                    var19_13 = null;
                                                    if (pushedLogContext) {
                                                        Logger.popContext();
                                                    }
                                                    if (context == null) return;
                                                    ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl255:
                                                    // 1 sources

                                                    context.completeResponse();
                                                    break block95;
lbl257:
                                                    // 1 sources

                                                    catch (Exception var20_26) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl261:
                                                // 1 sources

                                                response.flushBuffer();
                                                return;
lbl263:
                                                // 1 sources

                                                catch (Exception var20_26) {
                                                    // empty catch block
                                                }
                                                return;
                                            }
                                            var19_14 = null;
                                            if (pushedLogContext) {
                                                Logger.popContext();
                                            }
                                            if (context == null) return;
                                            ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl272:
                                            // 1 sources

                                            context.completeResponse();
                                            break block96;
lbl274:
                                            // 1 sources

                                            catch (Exception var20_27) {
                                                // empty catch block
                                            }
                                        }
                                        ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl278:
                                        // 1 sources

                                        response.flushBuffer();
                                        return;
lbl280:
                                        // 1 sources

                                        catch (Exception var20_27) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                    var19_15 = null;
                                    if (pushedLogContext) {
                                        Logger.popContext();
                                    }
                                    if (context == null) return;
                                    ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl289:
                                    // 1 sources

                                    context.completeResponse();
                                    break block97;
lbl291:
                                    // 1 sources

                                    catch (Exception var20_28) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl295:
                                // 1 sources

                                response.flushBuffer();
                                return;
lbl297:
                                // 1 sources

                                catch (Exception var20_28) {
                                    // empty catch block
                                }
                                return;
                            }
                            var19_16 = null;
                            if (pushedLogContext) {
                                Logger.popContext();
                            }
                            if (context == null) return;
                            ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl306:
                            // 1 sources

                            context.completeResponse();
                            break block98;
lbl308:
                            // 1 sources

                            catch (Exception var20_29) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl312:
                        // 1 sources

                        response.flushBuffer();
                        return;
lbl314:
                        // 1 sources

                        catch (Exception var20_29) {
                            // empty catch block
                        }
                        return;
                    }
                    var19_17 = null;
                    if (pushedLogContext) {
                        Logger.popContext();
                    }
                    if (context == null) return;
                    ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl323:
                    // 1 sources

                    context.completeResponse();
                    break block99;
lbl325:
                    // 1 sources

                    catch (Exception var20_30) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [47 : 1482->1492)] { 
lbl329:
                // 1 sources

                response.flushBuffer();
                return;
lbl331:
                // 1 sources

                catch (Exception var20_30) {
                    // empty catch block
                }
                return;
            }
            var19_18 = null;
            if (pushedLogContext) {
                Logger.popContext();
            }
            if (context == null) return;
            ** try [egrp 2[TRYBLOCK] [46 : 1472->1480)] { 
lbl340:
            // 1 sources

            context.completeResponse();
            break block100;
lbl342:
            // 1 sources

            catch (Exception var20_31) {
                // empty catch block
            }
        }
        try {}
        catch (Exception var20_31) {}
        response.flushBuffer();
        return;
    }

    private String getInitialTarget(RequestContext context) {
        String queryString = context.request.getQueryString();
        String initialTarget = context.requestPath;
        if (queryString != null && queryString.length() > 0) {
            if (!queryString.startsWith("?")) {
                initialTarget = initialTarget + "?";
            }
            initialTarget = initialTarget + queryString;
        }
        return initialTarget;
    }

    private void maxLoginsExceeded(RequestContext context, String comparePath) throws Exception {
        context.request.setAttribute("isc.TOO_MANY_LOGIN_ATTEMPTS", new Integer(this.maxTries));
        String maxTriesURL = this.maxLoginAttemptsExceededPage;
        if (maxTriesURL == null) {
            this.log.warn("maxTries is set, but maxLoginAttemptsExceededPage is not defined, defaulting to loginPage");
            maxTriesURL = this.loginPage;
        }
        this.log.debug("REDIRECTING user to: " + maxTriesURL + " for access to private resource: " + comparePath + " (user exceeded maximum login attempts limit of " + this.maxTries + ")");
        context.response.sendRedirect(ServletTools.adjustForContextPath(maxTriesURL, (HttpServletRequest)context.request));
    }
}

