/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.annotations.DataSourceAnnotations;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.MultipleFieldCriteriaTransformer;
import com.isomorphic.datasource.AuditDSGenerator;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.JSExpressionType;
import com.isomorphic.datasource.ProjectFileDataSource;
import com.isomorphic.datasource.RelationFieldInfo;
import com.isomorphic.datasource.SimpleType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.ICDIBeanManager;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.CanvasRefExpression;
import com.isomorphic.js.JSExpression;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.GmailAttachmentDataSource;
import com.isomorphic.mail.GmailMessageDataSource;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.PreCache;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.DefaultValidators;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections4.map.LinkedMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicDataSource
extends DataSource {
    private static Logger log = new Logger(BasicDataSource.class.getName());
    public static String DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY = "autoCreateAuditTable";
    public static String GLOBAL_AUTO_CREATE_AUDIT_TABLE_KEY = "audit.autoCreateTables";
    protected Map ds2NativeFieldMap;
    protected Map native2DSFieldMap;
    protected Map derivedClientToServerFieldMap;
    protected Map derivedServerToClientFieldMap;
    protected Map dsFields = null;
    protected List<DSField> dsMultipleFields = null;
    protected List<String> primaryKeys;
    protected String superDSName = null;
    protected BasicDataSource superDS = null;
    public DataSource autoDeriveDS = null;
    protected Map<String, Set<String>> validatorsDependentFields;
    protected DSRequest downloadDsRequest;
    private final MultipleFieldCriteriaTransformer multipleFieldCriteriaTransformer = new MultipleFieldCriteriaTransformer(this);
    public static AuditDSGenerator auditGenerator;
    public static int numRecords;
    List needsRefQuotedForGradient = Arrays.asList("DrawBlockConnector", "DrawCurve", "DrawGroup", "DrawImage", "DrawItem", "DrawLabel", "DrawLine", "DrawLinePath", "DrawOval", "DrawPane", "DrawPath", "DrawPolygon", "DrawRect", "DrawSector", "DrawShape", "DrawTriangle", "DrawDiamond");
    private boolean _inLogAttributeNotDeclaredMessage = false;
    public static int numFields;
    public static final String CACHED_TYPE = "__cachedType";

    public static DataSource fromConfig(Map theConfig, DSRequest dsRequest) throws Exception {
        DataSource ds;
        String dsType;
        block25: {
            String ID = (String)theConfig.get("ID");
            dsType = BasicDataSource.getType(theConfig);
            if (dsType == null) {
                dsType = theConfig.get("tableName") != null ? "sql" : "basic";
            }
            String serverClass = (String)theConfig.get("serverConstructor");
            ds = null;
            if (serverClass != null) {
                String springIndicator = "spring:";
                String cdiIndicator = "cdi:";
                if (serverClass.indexOf(springIndicator) == 0) {
                    String beanId = serverClass.substring(springIndicator.length());
                    log.debug("Looking up Spring bean '" + beanId + "' as implementer for DataSource " + ID);
                    try {
                        ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                        Object dataSourceInstance = beanFactory.getBean(ISCFile.servletContext, beanId);
                        if (dataSourceInstance instanceof DataSource) {
                            ds = (DataSource)dataSourceInstance;
                            break block25;
                        }
                        log.warning("Couldn't create DataSource " + ID + " by looking up Spring bean '" + beanId + "', creating as a normal DataSource.  The object returned by the Spring lookup was " + (dataSourceInstance == null ? "null" : "of type " + dataSourceInstance.getClass().getName()));
                    }
                    catch (Exception e) {
                        log.warning("Couldn't create DataSource " + ID + " by looking up Spring bean '" + beanId + "', creating as a normal DataSource.  The Spring lookup failed as follows: " + DataTools.getStackTrace(e));
                    }
                } else if (serverClass.indexOf(cdiIndicator) == 0) {
                    String beanId = serverClass.substring(cdiIndicator.length());
                    log.debug("Looking up CDI bean '" + beanId + "' as implementer for DataSource " + ID);
                    try {
                        ICDIBeanManager beanManager = (ICDIBeanManager)InterfaceProvider.load("ICDIBeanManager");
                        Object dataSourceInstance = beanManager.getBean(beanId);
                        if (dataSourceInstance instanceof DataSource) {
                            ds = (DataSource)dataSourceInstance;
                            break block25;
                        }
                        log.warning("Couldn't create DataSource " + ID + " by looking up CDI bean '" + beanId + "', creating as a normal DataSource.  The object returned by the CDI lookup was " + (dataSourceInstance == null ? "null" : "of type " + dataSourceInstance.getClass().getName()));
                    }
                    catch (Exception e) {
                        log.warning("Couldn't create DataSource " + ID + " by looking up CDI bean '" + beanId + "', creating as a normal DataSource.  The CDI lookup failed as follows: " + DataTools.getStackTrace(e));
                    }
                } else {
                    try {
                        log.debug("Using class " + serverClass + " as implementer for DataSource " + ID);
                        ds = (DataSource)Reflection.newInstance(serverClass, new Object[0]);
                    }
                    catch (Exception e) {
                        log.warning("Couldn't create DataSource " + ID + " as an instance of class '" + serverClass + "', creating as a normal DataSource.  Problem was:\n" + DataTools.getStackTrace(e));
                    }
                }
            }
        }
        if (ds == null) {
            if (dsType.equals("table") || dsType.equals("sql")) {
                ds = (DataSource)InterfaceProvider.load("SQLDataSource");
            } else if (dsType.equals("hibernate")) {
                ds = (DataSource)InterfaceProvider.load("HibernateDataSource");
            } else if (dsType.equals("jpa1")) {
                ds = (DataSource)InterfaceProvider.load("JPADataSource");
            } else if (dsType.equals("jpa")) {
                ds = (DataSource)InterfaceProvider.load("JPA2DataSource");
            } else if (dsType.equals("LDAP")) {
                ds = (DataSource)InterfaceProvider.load("LDAPDataSource");
                ds = (DataSource)InterfaceProvider.load("HibernateDataSource");
            } else {
                ds = dsType.equals("session") ? (DataSource)InterfaceProvider.load("SessionDataSource") : (dsType.equals("projectFile") ? new ProjectFileDataSource() : (dsType.equals("gmailMessage") ? new GmailMessageDataSource() : (dsType.equals("gmailAttachment") ? new GmailAttachmentDataSource() : new BasicDataSource())));
            }
        }
        ds.initialize(theConfig, dsRequest);
        return ds;
    }

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
        if (!this.dsConfig.containsKey("progressiveLoadingThreshold")) {
            this.dsConfig.put("progressiveLoadingThreshold", 200000);
        }
        if (!this.dsConfig.containsKey("lookAhead")) {
            this.dsConfig.put("lookAhead", 1);
        }
        if (!this.dsConfig.containsKey("endGap")) {
            this.dsConfig.put("endGap", 20);
        }
        this.ds2NativeFieldMap = new LinkedHashMap();
        this.native2DSFieldMap = new HashMap();
        this.derivedServerToClientFieldMap = new HashMap();
        this.derivedClientToServerFieldMap = new HashMap();
        this.primaryKeys = new ArrayList<String>();
        this.validatorsDependentFields = new HashMap<String, Set<String>>();
        if (this.dsConfig.get("fields") == null) {
            this.dsConfig.put("fields", new HashMap());
        }
        this.superDSName = this.dsConfig.getString("inheritsFrom");
        this.superDS = this.getSuper(dsRequest);
        if (this.dsConfig.get("schemaBean") != null && this.autoDeriveDS == null) {
            this.createAutoDeriveDS();
        }
        if (this.autoDeriveDS instanceof BasicDataSource) {
            this.superDS = (BasicDataSource)this.autoDeriveDS;
            this.superDSName = this.superDS.dsName;
        }
        if (this.superDS != null) {
            DataTools.addAsList(this.fieldList, this.superDS.getFieldNames());
        }
        if (this.dsConfig.get("allowAdvancedCriteria") == null && this.dsConfig.get("willHandleAdvancedCriteria") == null) {
            this.dsConfig.put("allowAdvancedCriteria", this.allowAdvancedCriteria());
        }
        this.buildFieldData();
        inInitState.put(this.getName(), this);
        if (this.handlesRelations()) {
            this.relationFields = new HashMap();
            for (Object object : this.getFieldNames()) {
                String relatedFieldName;
                String relatedDSName;
                DataSource relatedDS;
                String type;
                String foreignKey;
                String fieldName = (String)object;
                DSField field = this.getField(fieldName);
                if (field.isMultiple()) {
                    foreignKey = field.getForeignKey();
                    type = field.getType();
                    if (foreignKey != null) {
                        relatedDS = this;
                        relatedDSName = this.getName();
                        relatedFieldName = foreignKey;
                        if (foreignKey.contains(".")) {
                            relatedDSName = foreignKey.substring(0, foreignKey.lastIndexOf("."));
                            relatedFieldName = foreignKey.substring(foreignKey.lastIndexOf(".") + 1);
                            relatedDS = (DataSource)inInitState.get(relatedDSName);
                            if (relatedDS == null) {
                                relatedDS = DataSourceManager.getDataSource(relatedDSName);
                            }
                            if (relatedDS != null) {
                                if (this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) {
                                    if (this.getConfigName().equals(relatedDS.getConfigName())) {
                                        if (relatedDS.getField(relatedFieldName) == null) {
                                            log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                                            relatedDSName = null;
                                            relatedFieldName = null;
                                        }
                                    } else {
                                        log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                                        relatedDSName = null;
                                        relatedFieldName = null;
                                    }
                                } else {
                                    log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                                    relatedDSName = null;
                                    relatedFieldName = null;
                                }
                            } else {
                                log.warn("Can not load related data source '" + relatedDSName + "' for field '" + fieldName + "'. Treating as simple field.");
                                relatedDSName = null;
                                relatedFieldName = null;
                            }
                        } else if (this.getField(relatedFieldName) == null) {
                            log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                            relatedDSName = null;
                            relatedFieldName = null;
                        }
                        if (relatedFieldName == null) continue;
                        if (BasicDataSource.getBuiltinType(type) == null) {
                            if (relatedDSName.equals(type)) {
                                this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, true, true));
                                this.getField(fieldName).put("type", type);
                                continue;
                            }
                            log.warn("Related data source '" + relatedDSName + "' does not match declared field type  '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
                            relatedDSName = null;
                            relatedFieldName = null;
                            continue;
                        }
                        type = relatedDS.getField(relatedFieldName).getType();
                        if ("sequence".equals(type)) {
                            type = "integer";
                        }
                        this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, false, true));
                        this.getField(fieldName).put("type", type);
                        continue;
                    }
                    if (BasicDataSource.getBuiltinType(type) != null) continue;
                    relatedDS = (DataSource)inInitState.get(type);
                    if (relatedDS == null) {
                        relatedDS = DataSourceManager.getDataSource(type);
                    }
                    if (relatedDS != null) {
                        if (this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) {
                            if (this.getConfigName().equals(relatedDS.getConfigName())) {
                                this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDS.getName(), relatedDS.getPrimaryKey(), true, true));
                                continue;
                            }
                            log.warn("Related data source '" + type + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                            continue;
                        }
                        log.warn("Related data source '" + type + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                        continue;
                    }
                    log.warn("Can not load related data source '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
                    continue;
                }
                foreignKey = field.getForeignKey();
                type = field.getType();
                if (foreignKey != null) {
                    relatedDS = this;
                    relatedDSName = this.getName();
                    relatedFieldName = foreignKey;
                    if (foreignKey.contains(".")) {
                        relatedDSName = foreignKey.substring(0, foreignKey.lastIndexOf("."));
                        relatedFieldName = foreignKey.substring(foreignKey.lastIndexOf(".") + 1);
                        relatedDS = (DataSource)inInitState.get(relatedDSName);
                        if (relatedDS == null) {
                            relatedDS = DataSourceManager.getDataSource(relatedDSName);
                        }
                        if (relatedDS != null) {
                            if (this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) {
                                if (this.getConfigName().equals(relatedDS.getConfigName())) {
                                    if (relatedDS.getField(relatedFieldName) == null) {
                                        log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                                        relatedDSName = null;
                                        relatedFieldName = null;
                                    }
                                } else {
                                    log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                                    relatedDSName = null;
                                    relatedFieldName = null;
                                }
                            } else {
                                log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                                relatedDSName = null;
                                relatedFieldName = null;
                            }
                        } else {
                            log.warn("Can not load related data source '" + relatedDSName + "' for field '" + fieldName + "'. Treating as simple field.");
                            relatedDSName = null;
                            relatedFieldName = null;
                        }
                    } else if (this.getField(relatedFieldName) == null) {
                        log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                        relatedDSName = null;
                        relatedFieldName = null;
                    }
                    if (relatedFieldName == null) continue;
                    if (BasicDataSource.getBuiltinType(type) == null) {
                        if (relatedDSName.equals(type)) {
                            this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, true, false));
                            this.getField(fieldName).put("type", type);
                            continue;
                        }
                        log.warn("Related data source '" + relatedDSName + "' does not match declared field type  '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
                        relatedDSName = null;
                        relatedFieldName = null;
                        continue;
                    }
                    type = relatedDS.getField(relatedFieldName).getType();
                    if ("sequence".equals(type)) {
                        type = "integer";
                    }
                    this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, false, false));
                    this.getField(fieldName).put("type", type);
                    this.getField(fieldName).put("valueXPath", fieldName + "/" + relatedFieldName);
                    continue;
                }
                if (BasicDataSource.getBuiltinType(type) != null) continue;
                relatedDS = (DataSource)inInitState.get(type);
                if (relatedDS == null) {
                    relatedDS = DataSourceManager.getDataSource(type);
                }
                if (relatedDS != null) {
                    if ((this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) && relatedDS.handlesRelations()) {
                        if (this.getConfigName().equals(relatedDS.getConfigName())) {
                            this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDS.getName(), relatedDS.getPrimaryKey(), true, false));
                            continue;
                        }
                        log.warn("Related data source '" + type + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                        continue;
                    }
                    log.warn("Related data source '" + type + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                    continue;
                }
                log.warn("Can not load related data source '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
            }
        }
        this.includeFromFields = new HashMap();
        for (Object object : this.getFields()) {
            DSField field = (DSField)object;
            IncludeFromInfo includeFromInfo = this.getIncludeFromInfo(field, dsRequest);
            if (includeFromInfo == null) continue;
            this.includeFromFields.put(field.getName(), includeFromInfo);
        }
        if (this.dsConfig.getBoolean((Object)"audit", false)) {
            String auditId = this.dsConfig.getString("auditDataSourceID", "audit_" + this.getID());
            if (auditGenerator == null) {
                auditGenerator = new AuditDSGenerator();
                log.debug("Adding AuditDSGenerator");
                DataSource.addDynamicDSGenerator((DynamicDSGenerator)auditGenerator, "audit_");
            }
            if (!auditGenerator.hasMappingFor(auditId)) {
                auditGenerator.addMapping(auditId, this.getID());
            }
        }
        this.dsMultipleFields = new LinkedList<DSField>();
        ValidationContext vc = new ValidationContext();
        for (String fieldNameObj : this.getFieldNames()) {
            String fieldName = fieldNameObj;
            DSField field = this.getField(fieldName);
            if (!field.isMultiple()) continue;
            this.dsMultipleFields.add(field);
            if (field.getMultipleStorage() != null || field.getForeignKey() != null) continue;
            if (BasicDataSource.getBuiltinType(field.getType()) != null) {
                log.debug("undefined multipleStorage was set to 'simpleString' for field " + field.getName());
                field.put("multipleStorage", "simpleString");
                continue;
            }
            try {
                IType t = this.getSimpleType(field.getType(), vc);
                if (t != null || !(t instanceof SimpleType)) continue;
                log.debug("undefined multipleStorage was set to 'simpleString' for field " + field.getName());
                field.put("multipleStorage", "simpleString");
            }
            catch (Exception e) {
                log.warning("Error getting field type for field '" + field.getName() + "'. The exception was " + DataTools.getStackTrace(e));
            }
        }
        vc.freeResources();
        inInitState.remove(this.getName());
    }

    public Map ds2NativeFieldMap() {
        return this.ds2NativeFieldMap;
    }

    public Map native2DSFieldMap() {
        return this.native2DSFieldMap;
    }

    public String getSuperDSName() {
        return this.superDSName;
    }

    protected void createAutoDeriveDS() throws Exception {
        this.createAutoDeriveDS((Map)((Object)this.dsConfig));
    }

    protected void createAutoDeriveDS(Map theConfig) throws Exception {
        String ID = (String)theConfig.get("ID") + "_inheritsFrom";
        Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile(ID);
        if (dsObject instanceof DataSource) {
            this.autoDeriveDS = (DataSource)dsObject;
            return;
        }
        String beanName = (String)theConfig.get("schemaBean");
        if (beanName == null) {
            beanName = (String)theConfig.get("beanClassName");
        }
        if (beanName == null) {
            return;
        }
        HashMap<String, String> soConfig = new HashMap<String, String>();
        ServerObject serverObject = null;
        RequestContext context = new RequestContext();
        context.servletContext = ISCFile.servletContext;
        if (beanName.indexOf(46) == -1) {
            soConfig.put("bean", beanName);
            soConfig.put("lookupStyle", "spring");
            try {
                serverObject = new ServerObject(soConfig, context, "Looking up schemaBean as Spring bean for datasource: " + this.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serverObject == null) {
            soConfig.put("className", beanName);
            soConfig.put("lookupStyle", "new");
            serverObject = new ServerObject(soConfig, context, "Looking up schemaBean as direct Java object for datasource: " + this.getName());
        }
        if (serverObject == null) {
            log.warn("DataSource " + this.getName() + ": Failed to look up schemaBean '" + beanName + "' as either a Spring bean or a direct Java object");
            return;
        }
        Object soInstance = serverObject.getInstance();
        if (soInstance == null) {
            log.warn("DataSource " + this.getName() + ": Failed to instantiate schemaBean '" + beanName + "'");
            return;
        }
        try {
            Map parentConfig = null;
            try {
                parentConfig = DataSourceAnnotations.getDataSourceConfigFromAnnotatedClass(soInstance.getClass(), false, false, (String)theConfig.get("serverType"), (String)theConfig.get("serverConstructor"));
            }
            catch (NoClassDefFoundError ncdfe) {
                log.debug("NoClassDefFoundError when trying annotations, almost certainly because we have no javax.persistence on the classpath. Annotations are not available.");
            }
            if (parentConfig == null) {
                Object[] params = new Object[]{soInstance.getClass().getName()};
                parentConfig = (Map)Reflection.invokeNonVisibleStaticMethod("com.isomorphic.tools.DataSourceTools", "_getDataSourceConfigFromJavaClass", params);
            }
            if (parentConfig != null) {
                parentConfig.put("ID", ID);
                parentConfig.put((String)"serverType", theConfig.get("serverType"));
                if (theConfig.get("tableName") != null) {
                    parentConfig.put("tableName", theConfig.get("tableName"));
                }
                if (theConfig.get("quoteTableName") != null) {
                    parentConfig.put("quoteTableName", theConfig.get("quoteTableName"));
                }
                parentConfig.put("__autoConstruct", "DataSource");
                this.autoDeriveDS = BasicDataSource.fromConfig(parentConfig, null);
                DataStructCache.addCachedObjectWithNoConfigFile(ID, this.autoDeriveDS);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception trying to invoke DataSourceTools method", e);
        }
    }

    @Override
    public DataSource getAutoDeriveDS() {
        return this.autoDeriveDS;
    }

    @Override
    protected BasicDataSource getSuper() {
        return this.getSuper(null);
    }

    protected BasicDataSource getSuper(DSRequest dsRequest) {
        if (this.autoDeriveDS instanceof BasicDataSource) {
            this.superDS = (BasicDataSource)this.autoDeriveDS;
            this.superDSName = this.superDS.dsName;
        }
        if (this.superDS == null && this.superDSName != null) {
            log.debug("Looking up superDS of DataSource " + this.getName() + ": '" + this.superDSName + "'");
            try {
                this.superDS = (BasicDataSource)DataSourceManager.getDataSource(this.superDSName, dsRequest);
            }
            catch (Exception e) {
                log.warning("Exception loading DataSource " + this.superDSName + ": " + DataTools.getStackTrace(e));
            }
            if (this.superDS == null) {
                log.warning("DataSource " + this.getName() + " declared to inherit from DataSource " + this.superDSName + " which could not be loaded");
                this.superDSName = null;
            }
        }
        return this.superDS;
    }

    @Override
    public void clearState() {
        if (this.superDS != null) {
            DataSourceManager.freeDataSource(this.superDS);
        }
        this.superDS = null;
        super.clearState();
    }

    public String getProperty(String key) {
        return this.dsConfig.getString(key, null);
    }

    public Object getObjectProperty(String key) {
        return this.dsConfig.get(key);
    }

    public List getListProperty(String key) {
        return (List)this.dsConfig.get(key);
    }

    public DataTypeMap getMapProperty(String key) {
        return this.dsConfig.getMap(key);
    }

    public List<String> getPatternMultiWildcards() {
        LinkedList<String> multiWildcards = new LinkedList<String>();
        Object patternMultiWildcard = this.dsConfig.get("patternMultiWildcard");
        if (patternMultiWildcard == null) {
            multiWildcards.add("*");
        } else if (patternMultiWildcard instanceof String) {
            multiWildcards.add(patternMultiWildcard.toString());
        } else if (patternMultiWildcard instanceof List) {
            multiWildcards.addAll((List)patternMultiWildcard);
        }
        return multiWildcards;
    }

    public List<String> getPatternSingleWildcards() {
        LinkedList<String> singleWildcards = new LinkedList<String>();
        Object patternSingleWildcard = this.dsConfig.get("patternSingleWildcard");
        if (patternSingleWildcard == null) {
            singleWildcards.add("%");
            singleWildcards.add("?");
        } else if (patternSingleWildcard instanceof String) {
            singleWildcards.add(patternSingleWildcard.toString());
        } else if (patternSingleWildcard instanceof List) {
            singleWildcards.addAll((List)patternSingleWildcard);
        }
        return singleWildcards;
    }

    protected void buildFieldData() throws Exception {
        Object origRawFields = this.dsConfig.get("fields");
        if (origRawFields instanceof List) {
            for (Object fieldObject : (List)origRawFields) {
                String includeFrom;
                Map field;
                if (!(fieldObject instanceof Map) || (field = (Map)fieldObject).containsKey("name") || (includeFrom = (String)field.get("includeFrom")) == null) continue;
                if (includeFrom.contains(".")) {
                    includeFrom = includeFrom.substring(includeFrom.lastIndexOf(".") + 1);
                }
                field.put("name", includeFrom);
            }
            this.dsConfig.put("fields", DataTools.indexOnProperty((List)origRawFields, "name"));
        }
        this.dsFields = DataTools.mapMerge(this.getRawFields(), (Map)new LinkedMap());
        ArrayList<String> allFields = new ArrayList<String>(this.fieldList);
        allFields.addAll(this.dsFields.keySet());
        LinkedHashMap newFields = new LinkedHashMap();
        for (String fieldName : this.dsFields.keySet()) {
            Object validatorsObj;
            String type;
            Object fd = this.dsFields.get(fieldName);
            newFields.put(fieldName, fd);
            if (!(fd instanceof Map)) {
                log.warn(this.dsName + ": specification of field '" + fieldName + "' invalid: " + DataTools.prettyPrint(fd));
                continue;
            }
            Map fieldData = (Map)fd;
            String typeId = type = (String)fieldData.get("type");
            ArrayList<String> seenTypes = new ArrayList<String>();
            Map typeDef = this.getSimpleTypeDef(typeId);
            while (typeDef != null) {
                typeId = (String)typeDef.get("inheritsFrom");
                if (typeId != null) {
                    if (seenTypes.contains(typeId)) {
                        throw new Exception("Simple type '" + typeId + "' or one of the types it inherits from is inherited from one of its children which creates an infinite loop.");
                    }
                    seenTypes.add(typeId);
                }
                typeDef = this.getSimpleTypeDef(typeId);
            }
            if (this.simpleTypeInheritsFrom(type, "binary")) {
                Map<String, Boolean> map;
                String nativeName = (String)fieldData.get("nativeName");
                String metadataName = DataTools.getListEntry(allFields, fieldName + "_filename");
                if (metadataName == null) {
                    HashMap<String, Object> filename = new HashMap<String, Object>();
                    filename.put("name", fieldName + "_filename");
                    filename.put("type", "text");
                    filename.put("length", new Long(255L));
                    filename.put("title", "Name");
                    filename.put("hidden", new Boolean(true));
                    filename.put("canEdit", new Boolean(false));
                    filename.put("customSQL", fieldData.get("customSQL"));
                    if (nativeName != null) {
                        filename.put("nativeName", nativeName + "_filename");
                    }
                    newFields.put(fieldName + "_filename", filename);
                } else {
                    map = (HashMap<String, Boolean>)this.dsFields.get(metadataName);
                    if (map == null) {
                        map = new HashMap<String, Boolean>();
                    }
                    if (!map.containsKey("hidden")) {
                        map.put("hidden", new Boolean(true));
                    }
                    if (!map.containsKey("canEdit")) {
                        map.put("canEdit", new Boolean(false));
                    }
                    if (!map.containsKey("customSQL")) {
                        map.put("customSQL", (Boolean)fieldData.get("customSQL"));
                    }
                    newFields.put(metadataName, map);
                }
                metadataName = DataTools.getListEntry(allFields, fieldName + "_filesize");
                if (metadataName == null) {
                    HashMap<String, Object> filesize = new HashMap<String, Object>();
                    filesize.put("name", fieldName + "_filesize");
                    filesize.put("type", "number");
                    filesize.put("title", "Size");
                    filesize.put("hidden", new Boolean(true));
                    filesize.put("canEdit", new Boolean(false));
                    filesize.put("customSQL", fieldData.get("customSQL"));
                    if (nativeName != null) {
                        filesize.put("nativeName", nativeName + "_filesize");
                    }
                    newFields.put(fieldName + "_filesize", filesize);
                } else {
                    map = (Map)this.dsFields.get(metadataName);
                    if (map == null) {
                        map = new HashMap();
                    }
                    if (!map.containsKey("hidden")) {
                        map.put("hidden", new Boolean(true));
                    }
                    if (!map.containsKey("canEdit")) {
                        map.put("canEdit", new Boolean(false));
                    }
                    if (!map.containsKey("customSQL")) {
                        map.put("customSQL", (Boolean)fieldData.get("customSQL"));
                    }
                    newFields.put(metadataName, map);
                }
                metadataName = DataTools.getListEntry(allFields, fieldName + "_date_created");
                if (metadataName == null) {
                    HashMap<String, Object> date_created = new HashMap<String, Object>();
                    date_created.put("name", fieldName + "_date_created");
                    date_created.put("type", "datetime");
                    date_created.put("title", "Date Created");
                    date_created.put("hidden", new Boolean(true));
                    date_created.put("canEdit", new Boolean(false));
                    date_created.put("customSQL", fieldData.get("customSQL"));
                    if (nativeName != null) {
                        date_created.put("nativeName", nativeName + "_date_created");
                    }
                    newFields.put(fieldName + "_date_created", date_created);
                } else {
                    map = (Map)this.dsFields.get(metadataName);
                    if (map == null) {
                        map = new HashMap();
                    }
                    if (!map.containsKey("hidden")) {
                        map.put("hidden", new Boolean(true));
                    }
                    if (!map.containsKey("canEdit")) {
                        map.put("canEdit", new Boolean(false));
                    }
                    if (!map.containsKey("customSQL")) {
                        map.put("customSQL", (Boolean)fieldData.get("customSQL"));
                    }
                    newFields.put(metadataName, map);
                }
            }
            if ((validatorsObj = fieldData.get("validators")) == null) continue;
            List validators = DataTools.makeListIfSingle(validatorsObj);
            for (Object validatorObj : validators) {
                String validatorType = null;
                Object errorMessage = null;
                Object applyWhen = null;
                if (validatorObj instanceof String) {
                    validatorType = (String)validatorObj;
                } else if (validatorObj instanceof Map) {
                    validatorType = (String)((Map)validatorObj).get("type");
                    errorMessage = ((Map)validatorObj).get("errorMessage");
                    applyWhen = ((Map)validatorObj).get("applyWhen");
                }
                this.updateFieldValidatorsMap(fieldName, (Map)validatorObj);
                if (!"required".equals(validatorType)) continue;
                fieldData.put("required", true);
                if (errorMessage != null) {
                    fieldData.put("requiredMessage", errorMessage);
                } else {
                    errorMessage = fieldData.get("requiredMessage");
                    if (errorMessage == null || "".equals(errorMessage)) {
                        errorMessage = this.getConfig().get("requiredMessage");
                        fieldData.put("requiredMessage", errorMessage);
                    }
                }
                if (applyWhen == null) continue;
                fieldData.put("conditionallyRequired", true);
            }
        }
        this.dsFields = newFields;
        for (String fieldName : new ArrayList(this.dsFields.keySet())) {
            Object valueMapEnum;
            Map fieldData = null;
            if (this.dsFields.get(fieldName) instanceof ArrayList) {
                String errorMessage = "Corrupt DataSource detected - required files under {isomorphicDir}/system/schema may be missing or unreadable.  This typically results from skipping installation steps.  If using SmartGWT, verify your <inherits> and run a GWT compile.  If using SmartClient, verify you have copied the correct folders from Pro or better smartclientSDK.  Installation instructions are linked from the QuickStart Guide.";
                log.warn(errorMessage);
                throw new Exception(errorMessage);
            }
            fieldData = (Map)this.dsFields.get(fieldName);
            DSField field = null;
            if (!(fieldData instanceof DSField)) {
                field = new DSField(fieldData, this);
                this.dsFields.put(fieldName, field);
            } else {
                field = (DSField)((Object)fieldData);
            }
            if (!field.containsKey("name")) {
                field.put("name", fieldName);
            }
            if (field.getType() == null) {
                field.put("type", "text");
            }
            if (!this.fieldList.contains(fieldName)) {
                this.fieldList.add(fieldName);
            }
            if (field.isDerived()) {
                if (field.getNativeName() == null) {
                    this.derivedClientToServerFieldMap.put(fieldName, fieldName);
                } else {
                    this.derivedClientToServerFieldMap.put(fieldName, field.getNativeName());
                }
            } else {
                if (!field.ignore() && field.getIncludeFrom() == null) {
                    if (field.getNativeName() == null) {
                        this.ds2NativeFieldMap.put(fieldName, fieldName);
                    } else {
                        String fieldTableName = field.getProperty("tableName");
                        String dsTableName = (String)this.dsConfig.get("tableName");
                        if (fieldTableName != null && dsTableName != null && !fieldTableName.equals(dsTableName)) {
                            String nativeName = fieldTableName + "." + field.getNativeName();
                            if (!this.ds2NativeFieldMap.containsValue(nativeName)) {
                                this.ds2NativeFieldMap.put(fieldName, nativeName);
                            } else {
                                log.warn("Datasource '" + this.getID() + "' has multiple fields with the same nativeName and tableName combination - '" + nativeName + "'. This is not allowed.");
                            }
                        } else if (!this.ds2NativeFieldMap.containsValue(field.getNativeName())) {
                            this.ds2NativeFieldMap.put(fieldName, field.getNativeName());
                        } else {
                            log.warn("Datasource '" + this.getID() + "' has multiple fields with the same nativeName='" + field.getNativeName() + "'. This is not allowed.");
                        }
                    }
                }
                if (field.isPrimaryKey()) {
                    this.primaryKeys.add(fieldName);
                }
            }
            if (field.containsKey("valueMapEnum") && (valueMapEnum = field.get("valueMapEnum")) != null) {
                Class valueEnumClass = null;
                try {
                    valueEnumClass = Reflection.classForName(valueMapEnum.toString());
                }
                catch (Exception ex) {
                    log.warn("Failed to instantiate enumeration " + valueMapEnum.toString() + " specified in \"valueMapEnum\" property.");
                }
                if (valueEnumClass != null) {
                    if (valueEnumClass.isEnum()) {
                        if (this.dsConfig.get("enumTranslateStrategy") == null) {
                            Map<Object, String> enumValues = Reflection.getEnumValues(valueEnumClass, "intEnum".equals(field.getType()));
                            field.put("valueMap", enumValues);
                            fieldData.put("valueMap", enumValues);
                        } else {
                            String enumTranslateStrategy = this.getEnumTranslateStrategy();
                            if (!"bean".equals(enumTranslateStrategy)) {
                                Map<Object, String> enumValues = Reflection.getEnumValues(valueEnumClass, enumTranslateStrategy);
                                field.put("valueMap", enumValues);
                                fieldData.put("valueMap", enumValues);
                            }
                        }
                    } else {
                        log.warn("Class " + valueMapEnum.toString() + " specified in \"valueMapEnum\" property is not enumeration.");
                    }
                }
            }
            if (field.get("canFilter") != null || !field.getBoolean("stringInBrowser", false)) continue;
            field.put("canFilter", Boolean.FALSE);
            ((Map)this.getRawFields().get(field.getName())).put("canFilter", Boolean.FALSE);
        }
        this.native2DSFieldMap = DataTools.reverseMap(this.ds2NativeFieldMap);
        this.derivedServerToClientFieldMap = DataTools.reverseMap(this.derivedClientToServerFieldMap);
        Object rawTypes = this.dsConfig.get("types");
        if (rawTypes instanceof List) {
            this.dsConfig.put("types", DataTools.indexOnProperty((List)rawTypes, "ID"));
        }
    }

    private void updateFieldValidatorsMap(String fieldName, Map validatorObj) {
        Object dependentFieldsObj = validatorObj.get("dependentFields");
        if (dependentFieldsObj == null) {
            return;
        }
        List dependentFields = DataTools.makeListIfSingle(dependentFieldsObj);
        for (String dependentField : dependentFields) {
            Set<String> fieldsToValidate = this.validatorsDependentFields.get(dependentField);
            if (fieldsToValidate == null) {
                fieldsToValidate = new HashSet<String>();
                this.validatorsDependentFields.put(dependentField, fieldsToValidate);
            }
            fieldsToValidate.add(fieldName);
        }
    }

    public Map getExpandedDs2NativeFieldMap() {
        Map fieldMap = new LinkedHashMap();
        if (this.getSuper() != null) {
            fieldMap = this.getSuper().getExpandedDs2NativeFieldMap();
        }
        DataTools.mapMerge(this.ds2NativeFieldMap, fieldMap);
        return fieldMap;
    }

    @Override
    public DSField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        DSField field = (DSField)this.dsFields.get(fieldName);
        if (field == null && this.getSuper() != null) {
            field = this.getSuper().getField(fieldName);
        }
        return field;
    }

    public String getClientConstructor() {
        String constructor = (String)this.dsConfig.get("instanceConstructor");
        if (constructor == null) {
            constructor = (String)this.dsConfig.get("Constructor");
        }
        return constructor;
    }

    @Override
    public List<String> getPrimaryKeys() {
        ArrayList<String> pks = new ArrayList();
        if (this.getSuper() != null) {
            pks = this.getSuper().getPrimaryKeys();
        }
        DataTools.addAll(pks, this.primaryKeys);
        return pks;
    }

    public Map getDerivedNativeToDSFieldMap() {
        return this.derivedServerToClientFieldMap;
    }

    public Map getDerivedDSToNativeFieldMap() {
        return this.derivedClientToServerFieldMap;
    }

    @Override
    public boolean inheritsFrom(String dsName) {
        return this.getName().equals(dsName) || this.getSuper() != null && this.getSuper().inheritsFrom(dsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toRecords(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = this.toRecords(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    @Override
    public Object toRecords(Object data, ValidationContext context) throws Exception {
        if (data instanceof List) {
            List recordList = (List)data;
            long start = System.currentTimeMillis();
            Object result = this.toRecords(recordList, context);
            long end = System.currentTimeMillis();
            if (log != null && log.isDebugEnabled()) {
                log.debug("Done validating " + recordList.size() + " '" + this.getName() + "'s at path '" + context.getPath() + "': " + (end - start) + "ms" + (recordList.size() == 0 ? "" : " (avg " + (end - start) / (long)recordList.size() + ")"));
            }
            return result;
        }
        long start = System.currentTimeMillis();
        Object result = this.toRecord(data, context);
        long end = System.currentTimeMillis();
        if (log != null && log.isDebugEnabled()) {
            log.debug("Done validating a '" + this.getName() + "' at path '" + context.getPath() + "': " + (end - start) + "ms");
        }
        return result;
    }

    public Object toRecords(List data, ValidationContext context) throws Exception {
        if (data == null) {
            return null;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("Validating " + data.size() + " '" + this.getName() + "'s at path '" + context.getPath() + "'");
        }
        ArrayList<Object> records = new ArrayList<Object>();
        boolean addIndex = !"".equals(context.getPath());
        for (int i = 0; i < data.size(); ++i) {
            if (addIndex) {
                context.addPath("" + i);
            }
            records.add(this.toRecord(data.get(i), context));
            if (!addIndex) continue;
            context.removePathSegment();
        }
        return records;
    }

    @Override
    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data == null) {
            return null;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("Validating a '" + this.getName() + "' at path '" + context.getPath() + "'");
        }
        ++numRecords;
        if (data instanceof Element) {
            return this.elementAsRecord((Element)data, context);
        }
        if (!(data instanceof Map)) {
            if (!context.idAllowed() || !(data instanceof String)) {
                Logger.validation.warn("Unexpected Java type '" + data.getClass() + "' passed to DataSource '" + this.getName() + "' at path '" + context.getPath() + "'");
            }
            return data;
        }
        Map record = (Map)data;
        if (record.keySet().size() == 1 && record.get("ref") instanceof String) {
            return new CanvasRefExpression((String)record.get("ref"));
        }
        context.addPath(this.getName());
        context.addToTemplateContext("dataSource", this);
        DSRequest request = context.getDSRequest();
        record = new LinkedMap(record);
        HashSet<String> addedNullValuesForValidators = new HashSet<String>();
        context.put("addedNullValuesForValidators", addedNullValuesForValidators);
        if (request != null && "update".equals(request.getOperationType()) && this.validatorsDependentFields.size() > 0) {
            HashSet keys = new HashSet(record.keySet());
            for (String fieldName : keys) {
                Set<String> fieldsToValidate;
                DSField field = (DSField)this.dsFields.get(fieldName);
                if (field != null && field.isPrimaryKey() || (fieldsToValidate = this.validatorsDependentFields.get(fieldName)) == null) continue;
                for (String fieldToValidate : fieldsToValidate) {
                    if (record.containsKey(fieldToValidate)) continue;
                    record.put(fieldToValidate, null);
                    addedNullValuesForValidators.add(fieldToValidate);
                }
            }
        }
        HashSet<String> addedNullValues = new HashSet<String>();
        context.put("addedNullValues", addedNullValues);
        HashSet<String> addedPKValues = new HashSet<String>();
        if (request != null && ("update".equals(request.getOperationType()) || "validate".equals(request.getOperationType()))) {
            for (DSField field : this.getFields()) {
                if (field.isConditionallyRequired() && !record.containsKey(field.getName())) {
                    record.put(field.getName(), null);
                    addedNullValues.add(field.getName());
                }
                if (request.getAllowMultiUpdate() || !field.isPrimaryKey() || record.containsKey(field.getName())) continue;
                record.put(field.getName(), request.getCriteriaValue(field.getName()));
                addedPKValues.add(field.getName());
            }
        }
        HashSet keys = new HashSet(record.keySet());
        for (String fieldName : keys) {
            DSField field = this.getField(fieldName);
            Object value = record.get(fieldName);
            if (field == null) {
                this.handleExtraValue(record, fieldName, value, context);
                continue;
            }
            if (value instanceof JSExpression) continue;
            record.put(fieldName, this.validateFieldValue(record, field, value, context));
        }
        this.checkStructure(record, context);
        this.checkAutoConstruct(record, context);
        this.validateRecord(record, context);
        Iterator i = addedNullValues.iterator();
        while (i.hasNext()) {
            record.remove(i.next());
        }
        context.remove("addedNullValues");
        i = addedPKValues.iterator();
        while (i.hasNext()) {
            record.remove(i.next());
        }
        i = addedNullValuesForValidators.iterator();
        while (i.hasNext()) {
            record.remove(i.next());
        }
        context.removePathSegment();
        return record;
    }

    protected void validateRecord(Map record, ValidationContext context) throws Exception {
        if (record == null) {
            return;
        }
        ErrorReport currentErrors = context.getCurrentErrorReport();
        ErrorReport errors = this.validateRecord(record, currentErrors, context);
        if (errors != null && currentErrors == null) {
            for (Object fieldName : errors.keySet()) {
                Object error = errors.get(fieldName);
                if (error == null) continue;
                context.addError((String)fieldName, error);
            }
        }
    }

    protected void handleExtraValue(Map record, String fieldName, Object value, ValidationContext context) throws Exception {
        Map vMap;
        if (value == null) {
            return;
        }
        if ("strictValidation".equals(fieldName)) {
            return;
        }
        if (value instanceof Map && (vMap = (Map)value).size() == 2 && vMap.containsKey("strictValidation") && vMap.containsKey("#text")) {
            return;
        }
        Logger.validation.debug("Value provided for unknown field: " + this.getName() + "." + fieldName + ": value is: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object elementAsRecord(Element element, ValidationContext context) throws Exception {
        Boolean strictValidation = (Boolean)context.get("strictValidation");
        if (strictValidation == null) {
            strictValidation = config.getBoolean("schema.strict.all");
        }
        Boolean strictValidationToRestore = strictValidation;
        context.addStrictModePath(this.getName());
        String elementFullName = context.getStrictModePath();
        Boolean elementStrictValidation = config.getBoolean("schema.strict." + elementFullName);
        if (elementStrictValidation != null) {
            strictValidation = elementStrictValidation;
        }
        if ("false".equals(this.getProperty("strictValidation"))) {
            strictValidation = Boolean.FALSE;
        }
        if (!PreCache.isCachingFinished()) {
            strictValidation = Boolean.FALSE;
        }
        try {
            String elementExplicitStrict;
            DataSource dsType;
            String declaredType;
            IType elementType = this.getExplicitType(element, context);
            if (elementType != null && elementType instanceof SimpleType) {
                log.debug("elementAsRecord using explicitly declared simple type: " + elementType.getName() + " at: " + context.getPath());
                Object object = ((SimpleType)elementType).create(element, context);
                return object;
            }
            if (elementType == null) {
                elementType = this.findElementType(element, context);
            }
            if (elementType != null && elementType instanceof DataSource && !(declaredType = (dsType = (DataSource)elementType).getName()).equals(this.getName())) {
                Object result;
                if (!(dsType.inheritsFrom(this.getName()) || declaredType.equals("JSExpression") || declaredType.equals("JS") || this.getName().equals("Object"))) {
                    Logger.validation.warn("Element is an instance of type " + dsType.getName() + ", which does not inherit from declared field type " + this.getName() + " at " + context.getPath());
                }
                Logger.validation.debug(this.getName() + " delegating validation to type: " + dsType.getName() + " at " + context.getPath());
                context.removeStrictModePathSegment();
                Object object = result = dsType.toRecords(element, context);
                return object;
            }
            if (element.hasAttributes() && element.hasAttribute("ref") && element.getAttribute("ref").length() > 0 && element.getAttributes().getLength() == 1 && XML.getElementChildren(element).size() == 0) {
                Object eparent;
                if ("fillGradient".equals(element.getNodeName())) {
                    String type;
                    eparent = (Element)element.getParentNode();
                    IType parentType = this.getExplicitType((Element)eparent, context);
                    if (parentType == null) {
                        parentType = this.findElementType((Element)eparent, context);
                    }
                    if (this.needsRefQuotedForGradient.contains(type = parentType.getName()) && JSTranslater.isValidJSIdentifier(element.getAttribute("ref"))) {
                        log.debug("ref is for a fillGradient item inside a DrawItem. Returning as string, to make sure gets quoted correctly");
                        String string = element.getAttribute("ref");
                        return string;
                    }
                }
                context.removeStrictModePathSegment();
                eparent = new CanvasRefExpression(element.getAttribute("ref"));
                return eparent;
            }
            context.addPath(XML.getXPathSegment(element));
            LinkedMap record = new LinkedMap();
            String oldBundleName = null;
            String oldBundleEncoding = null;
            if ("DataSource".equals(this.getName()) || "SimpleType".equals(this.getName())) {
                oldBundleName = context.getBundleName();
                oldBundleEncoding = context.getBundleEncoding();
                context.setBundleName(null);
                context.setBundleEncoding(null);
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    String name = child.getNodeName();
                    if (!name.equals("fmt:bundle") || !(child instanceof Element)) continue;
                    Map childAttrs = XML.attributesToMap((Element)child);
                    String basename = (String)childAttrs.get("basename");
                    context.setBundleName(basename);
                    context.setBundleEncoding((String)childAttrs.get("encoding"));
                    break;
                }
                if (context.getBundleName() == null) {
                    String fieldName = context.getFieldName();
                    int index = fieldName.indexOf("@ID=");
                    if (index == -1) {
                        index = fieldName.indexOf("@loadID=");
                    }
                    if (index == -1) {
                        log.warn("Attempting to set default i18n resource bundle name, encountered an unexpected context fieldName property: " + fieldName);
                    } else {
                        int index2 = fieldName.indexOf("]", index);
                        int index3 = fieldName.indexOf(",", index);
                        if (index2 > 0 && (index2 < index3 || index3 == -1)) {
                            context.setBundleName(fieldName.substring(index + 4, index2));
                        } else if (index3 > 0) {
                            context.setBundleName(fieldName.substring(index + 4, index3));
                        } else {
                            log.warn("Attempting to set default i18n resource bundle name, did not find delimiting ']' or comma in the context fieldName property: " + fieldName);
                        }
                    }
                }
                if (context.getBundleName() == null) {
                    context.setBundleName(oldBundleName);
                }
                if (context.getBundleEncoding() == null) {
                    context.setBundleEncoding(oldBundleEncoding);
                }
            }
            if (!Boolean.FALSE.equals(strictValidation) && "false".equalsIgnoreCase(elementExplicitStrict = element.getAttribute("strictValidation"))) {
                strictValidation = Boolean.FALSE;
            }
            Map attributes = XML.attributesToMap(element);
            for (String attrName : attributes.keySet()) {
                boolean schemaExplicitStrict;
                DSField field = this.getField(attrName);
                Object attrValue = attributes.get(attrName);
                if (field == null) {
                    if (Boolean.TRUE.equals(strictValidation) && !this.isMethodExists(this, attrName)) {
                        this.logAttributeNotDeclaredMessage(context, this.getName(), attrName, elementFullName + " " + context.getPath());
                    }
                    record.put(attrName, attrValue);
                    this.handleExtraValue((Map)record, attrName, attrValue, context);
                    continue;
                }
                if (!Boolean.FALSE.equals(strictValidation) && !(schemaExplicitStrict = field.getBoolean("strictValidation", true))) {
                    strictValidation = Boolean.FALSE;
                }
                context.put("strictValidation", strictValidation);
                record.put(attrName, this.validateFieldValue((Map)record, field, attrValue, context));
            }
            List children = XML.getElementChildren(element);
            for (Element child : children) {
                Element indirectChild;
                DSField field;
                String elementExplicitStrict2;
                if (!Boolean.FALSE.equals(strictValidation) && "false".equalsIgnoreCase(elementExplicitStrict2 = child.getAttribute("strictValidation"))) {
                    strictValidation = Boolean.FALSE;
                }
                String fieldName = child.getTagName();
                elementStrictValidation = config.getBoolean("schema.strict." + elementFullName + "." + fieldName);
                if (elementStrictValidation != null) {
                    strictValidation = elementStrictValidation;
                }
                if ((field = this.getField(fieldName)) == null) {
                    if (Boolean.TRUE.equals(strictValidation) && !this.isMethodExists(this, fieldName)) {
                        this.logAttributeNotDeclaredMessage(context, this.getName(), fieldName, elementFullName + " " + context.getPath());
                    }
                } else {
                    boolean schemaExplicitStrict;
                    if (!Boolean.FALSE.equals(strictValidation) && !(schemaExplicitStrict = field.getBoolean("strictValidation", true))) {
                        strictValidation = Boolean.FALSE;
                    }
                    context.put("strictValidation", strictValidation);
                }
                if (child.hasAttribute("_isc_name")) {
                    fieldName = child.getAttributeNS(null, "_isc_name");
                    child.removeAttribute("_isc_name");
                }
                if ((elementType = this.getExplicitType(child, context)) != null) {
                    try {
                        DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, fieldName, elementType, child, context));
                        continue;
                    }
                    finally {
                        if (elementType instanceof DataSource) {
                            // empty if block
                        }
                        continue;
                    }
                }
                List indirectChildren = XML.getElementChildren(child);
                boolean haveSingleJSExpression = false;
                if (field != null && field.isMultiple() && indirectChildren.size() == 1) {
                    Element onlyChild = (Element)indirectChildren.get(0);
                    IType type = this.getExplicitType(onlyChild, context);
                    if (type == null) {
                        type = this.findElementType(onlyChild, context);
                    }
                    if (type instanceof JSExpressionType) {
                        haveSingleJSExpression = true;
                    }
                }
                if (field != null && field.isMultiple() && !haveSingleJSExpression) {
                    Object value;
                    context.addStrictModePath(fieldName);
                    if (!indirectChildren.isEmpty()) {
                        value = indirectChildren;
                        DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, field, value, context));
                    } else if (!"true".equals(child.getAttribute("xsi:nil"))) {
                        if (child.hasAttributes()) {
                            DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, field, child, context));
                        } else {
                            value = XML.toSimpleValue(child);
                            if (value != null && !"".equals(((String)value).trim())) {
                                if (field.canFallbackToSingle()) {
                                    DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, field, child, context));
                                } else if (context.idAllowed()) {
                                    if (!record.containsKey(fieldName)) {
                                        record.put(fieldName, value);
                                    }
                                } else if (!record.containsKey(fieldName)) {
                                    record.put(fieldName, new JSExpression((String)value));
                                }
                            } else if (!record.containsKey(fieldName)) {
                                record.put(fieldName, new ArrayList());
                            }
                        }
                    }
                    context.removeStrictModePathSegment();
                    continue;
                }
                if (indirectChildren.size() == 1 && (elementType = this.findElementType(indirectChild = (Element)indirectChildren.get(0), context)) != null && !Boolean.TRUE.equals(context.get("skipSpecialTreatmentOfSingleIndirectChild"))) {
                    try {
                        String moveToField;
                        if (field != null && (moveToField = field.getProperty("moveTo")) != null) {
                            fieldName = moveToField;
                        }
                        DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, fieldName, elementType, indirectChild, context));
                        continue;
                    }
                    finally {
                        if (elementType instanceof DataSource) {
                            // empty if block
                        }
                        continue;
                    }
                }
                if (field != null) {
                    String moveToField = field.getProperty("moveTo");
                    if (moveToField != null) {
                        fieldName = moveToField;
                    }
                    DataTools.putCombinedList((Map)record, fieldName, this.validateFieldValue((Map)record, field, child, context));
                    continue;
                }
                this.handleExtraElementValue((Map)record, fieldName, child, indirectChildren, context);
            }
            context.put("strictValidation", strictValidation);
            context.put("elementFullName", elementFullName);
            if (children.isEmpty()) {
                String value = XML.toSimpleValue(element);
                if (value == null || "".equals(value.trim())) {
                    value = XML.getElementText(element);
                }
                if (value != null && !"".equals(value.trim())) {
                    if (attributes.isEmpty()) {
                        Object object;
                        if (context.idAllowed()) {
                            object = value;
                            return object;
                        }
                        object = new JSExpression(value);
                        return object;
                    }
                    record.put("#text", value);
                }
            }
            this.checkStructure((Map)record, context);
            this.checkAutoConstruct((Map)record, context);
            if ("DataSource".equals(this.getName())) {
                context.setBundleName(oldBundleName);
                context.setBundleEncoding(oldBundleEncoding);
            }
            this.validateRecord((Map)record, context);
            context.removePathSegment();
            context.removeStrictModePathSegment();
            LinkedMap linkedMap = record;
            return linkedMap;
        }
        finally {
            context.put("strictValidation", strictValidationToRestore);
        }
    }

    private void logAttributeNotDeclaredMessage(ValidationContext context, String name, String attrName, String additionalInfo) throws Exception {
        if (this._inLogAttributeNotDeclaredMessage) {
            return;
        }
        this._inLogAttributeNotDeclaredMessage = true;
        if ("Object".equals(name)) {
            return;
        }
        if ("DataSource".equals(name) && "Constructor".equals(attrName)) {
            return;
        }
        if ("DataSourceField".equals(name) && "propertiesOnly".equals(attrName)) {
            return;
        }
        if ("DataSourceField".equals(name)) {
            DSField field;
            this._inLogAttributeNotDeclaredMessage = true;
            DataSource formItemType = (DataSource)this.getType("FormItem", context);
            this._inLogAttributeNotDeclaredMessage = false;
            DSField dSField = field = formItemType == null ? null : formItemType.getField(attrName);
            if (field != null || this.isMethodExists(formItemType, attrName)) {
                return;
            }
        }
        Logger.validation.warning("attribute '" + attrName + "' is not declared in Component Schema '{" + name + ".ds.xml}' and strict mode is enabled.  See 'Strict Mode' overview in the documentation for details." + additionalInfo);
    }

    private boolean isMethodExists(DataSource ds, String methodName) {
        List methods = (List)ds.dsConfig.get("methods");
        if (methods != null) {
            for (Object methodObject : methods) {
                Map methodData = (Map)methodObject;
                if (!methodName.equals(methodData.get("name"))) continue;
                return true;
            }
        }
        return false;
    }

    protected void handleExtraElementValue(Map record, String fieldName, Element child, List indirectChildren, ValidationContext context) throws Exception {
        Object value = null;
        if (indirectChildren.size() == 0 && !child.hasAttributes()) {
            value = XML.toSimpleValue(child);
        } else if ("true".equals(child.getAttribute("xsi:nil"))) {
            value = null;
        } else {
            Map mapValue;
            BasicDataSource objectDS = context.getType("Object");
            value = ((DataSource)objectDS).toRecord(child, context);
            if (value instanceof Map && (mapValue = (Map)value).size() == 1 && mapValue.containsKey("Action")) {
                value = mapValue.get("Action");
            }
        }
        if (!record.containsKey(fieldName)) {
            record.put(fieldName, value);
        } else {
            DataTools.putCombinedList(record, fieldName, value);
        }
        this.handleExtraValue(record, fieldName, value, context);
    }

    protected Object validateFieldValue(Map record, DSField field, Object value, ValidationContext context) throws Exception {
        return this.validateFieldValue(record, field.getName(), null, value, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object validateFieldValue(Map record, String fieldName, IType declaredType, Object value, ValidationContext context) throws Exception {
        ++numFields;
        context.addPath(fieldName);
        context.addToTemplateContext("field", this.getField(fieldName));
        context.addToTemplateContext("record", record);
        try {
            Object object;
            IType fieldType;
            block22: {
                DataSource ds;
                Object strictValidationS;
                IType type;
                DSField field = this.getField(fieldName);
                fieldType = this.getFieldType(fieldName, context);
                IType iType = type = declaredType != null ? declaredType : fieldType;
                if (type == null && field != null) {
                    Logger.validation.warning("No such type '" + field.getType() + "', not processing field value at " + context.getPath());
                    Object object2 = value;
                    return object2;
                }
                Boolean strictValidation = Boolean.TRUE.equals(context.get("strictValidation"));
                if (fieldType instanceof DataSource && "false".equals(strictValidationS = (ds = (DataSource)fieldType).getConfig().getString("strictValidation"))) {
                    strictValidation = Boolean.FALSE;
                }
                if (strictValidation.booleanValue()) {
                    if (type == null && field == null) {
                        this.logAttributeNotDeclaredMessage(context, this.getName(), fieldName, context.getPath());
                    }
                    if (value instanceof Element) {
                        Map attributes = XML.attributesToMap((Element)value);
                        for (Object attributeNameObject : attributes.keySet()) {
                            String attributeName = (String)attributeNameObject;
                            String prop = field != null ? field.getProperty(attributeName) : null;
                            String name = this.getName();
                            DSField attributeField = null;
                            if (fieldType instanceof DataSource) {
                                DataSource attributeFieldDataSource = (DataSource)fieldType;
                                attributeField = attributeFieldDataSource.getField(attributeName);
                                name = attributeFieldDataSource.getName();
                            }
                            if (prop != null || attributeField != null) continue;
                            this.logAttributeNotDeclaredMessage(context, name, attributeName, context.getPath());
                        }
                    }
                }
                if (Logger.validation.isDebugEnabled()) {
                    Logger.validation.debug("Validating field:\n" + context.getPath() + " as " + this.getName() + "." + fieldName + " type: " + type.getName());
                }
                boolean enabledIdAllowed = false;
                boolean enabledPropertiesOnly = false;
                try {
                    if (field != null && field.isPropertiesOnly() && !context.isPropertiesOnly()) {
                        context.setPropertiesOnly();
                        enabledPropertiesOnly = true;
                    }
                    if (field != null && field.getBoolean("idAllowed") && !context.idAllowed()) {
                        context.setIdAllowed();
                        enabledIdAllowed = true;
                    }
                    context.setCurrentRecord(record);
                    context.setCurrentDataSource(this);
                    object = type.create(value, context);
                    if (enabledPropertiesOnly) {
                        context.setPropertiesOnly(false);
                    }
                    if (!enabledIdAllowed) break block22;
                    context.setIdAllowed(false);
                }
                catch (Throwable throwable) {
                    if (enabledPropertiesOnly) {
                        context.setPropertiesOnly(false);
                    }
                    if (enabledIdAllowed) {
                        context.setIdAllowed(false);
                    }
                    if (fieldType instanceof DataSource) {
                        // empty if block
                    }
                    throw throwable;
                }
            }
            if (!(fieldType instanceof DataSource)) {
                // empty if block
            }
            return object;
        }
        finally {
            context.removePathSegment();
        }
    }

    public void checkStructure(Map record, ValidationContext context) {
        for (String fieldName : this.getFieldNames()) {
            Object value;
            DSField field = this.getField(fieldName);
            if (!this.checkRequired(record, field, value = record.get(fieldName), context) || value == null && !record.containsKey(fieldName) && !field.isConditionallyRequired()) continue;
            if (value instanceof JSExpression) {
                return;
            }
            if (field.isMultiple() && !field.canFallbackToSingle() && value != null) {
                value = DataTools.makeListIfSingle(value);
            }
            record.put(fieldName, value);
            if (field.getUniqueProperty() == null) continue;
            value = DataTools.indexOnProperty(DataTools.makeListIfSingle(value), field.getUniqueProperty());
            record.put(fieldName, value);
        }
    }

    public boolean checkRequired(Map record, DSField field, Object value, ValidationContext context) {
        try {
            DefaultValidators.ValidatorFunc required2;
            ErrorMessage error;
            if (field.isRequiredForRecord(record, this, context) && (error = (required2 = DefaultValidators.getBuiltinValidator("required")).validate(new HashMap(), value, field.getName(), record, context)) != null) {
                context.addError(field.getName(), error);
                return false;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception thrown during isRequiredForRecord() call; falling back to the \"required\" setting", e);
            return field.isRequired();
        }
        return true;
    }

    public void checkAutoConstruct(Map record, ValidationContext context) {
        String scClassName;
        boolean propertiesOnly = context.isPropertiesOnly() || DataTools.getBoolean(record, "propertiesOnly");
        String constructor = (String)record.get("constructor");
        if (constructor == null) {
            constructor = this.getClientConstructor();
        }
        if (constructor != null) {
            if (!propertiesOnly) {
                record.put("__autoConstruct", constructor);
            } else {
                record.put("_constructor", constructor);
            }
            if (record.containsKey("constructor")) {
                record.remove("constructor");
            }
        }
        if (!record.containsKey("scClassName") && (scClassName = this.dsConfig.getString("scClassName")) != null) {
            record.put("scClassName", scClassName);
        }
    }

    public IType findElementType(Element element, ValidationContext context) throws Exception {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        IType type = this.getType(tagName, context);
        return type;
    }

    public IType getExplicitType(Element element, ValidationContext context) throws Exception {
        IType type = null;
        String xsType = element.getAttribute("xsi:type");
        if (xsType != null) {
            if (xsType.startsWith("xsd:")) {
                xsType = xsType.substring(4);
            }
            if ((type = this.getType(xsType, context)) != null) {
                return type;
            }
        }
        String constructor = element.getAttribute("constructor");
        type = this.getType(constructor, context);
        return type;
    }

    protected IType getFieldType(String fieldName, ValidationContext context) throws Exception {
        SimpleType type;
        HashMap<String, String> relatedRecordValidator;
        boolean isEnumType;
        Object fieldValidators;
        IType baseType;
        String typeId;
        DSField field;
        block29: {
            boolean explicitExists;
            block30: {
                block32: {
                    block31: {
                        field = this.getField(fieldName);
                        if (field == null) {
                            return null;
                        }
                        typeId = field.getType();
                        baseType = this.getType(typeId, context);
                        if (baseType instanceof DataSource) {
                            return baseType;
                        }
                        if (field.get("fields") != null) {
                            HashMap aConfig = new HashMap();
                            aConfig.put("fields", field.get("fields"));
                            return DataSource.fromConfig(aConfig, context.getDSRequest());
                        }
                        fieldValidators = field.get("validators");
                        isEnumType = this.simpleTypeInheritsFrom(typeId, "enum") || this.simpleTypeInheritsFrom(typeId, "intEnum");
                        relatedRecordValidator = null;
                        if (!this.dsConfig.getBoolean((Object)"validateRelatedRecords", false) || field.getForeignKey() == null) break block29;
                        explicitExists = false;
                        if (fieldValidators == null) break block30;
                        if (!(fieldValidators instanceof String)) break block31;
                        if (!"hasRelatedRecord".equals(fieldValidators)) break block30;
                        explicitExists = true;
                        break block30;
                    }
                    if (!(fieldValidators instanceof Map)) break block32;
                    String type2 = (String)((Map)fieldValidators).get("type");
                    if (!"hasRelatedRecord".equals(type2)) break block30;
                    explicitExists = true;
                    break block30;
                }
                if (fieldValidators instanceof List) {
                    for (Object val : (List)fieldValidators) {
                        Map map;
                        if (val instanceof String) {
                            if (!"hasRelatedRecord".equals(val)) continue;
                            explicitExists = true;
                            continue;
                        }
                        if (!(val instanceof Map) || !"hasRelatedRecord".equals((map = (Map)val).get("type"))) continue;
                        explicitExists = true;
                        break;
                    }
                }
            }
            if (!explicitExists) {
                relatedRecordValidator = new HashMap<String, String>();
                relatedRecordValidator.put("type", "hasRelatedRecord");
            }
        }
        if (fieldValidators == null && relatedRecordValidator == null) {
            if (isEnumType || field.getLength() != null) {
                fieldValidators = new ArrayList();
            } else {
                return baseType;
            }
        }
        if ((type = (SimpleType)field.get(CACHED_TYPE)) != null) {
            return type;
        }
        Object typeValidators = null;
        if (baseType != null) {
            typeValidators = ((SimpleType)baseType).getValidators();
        }
        int fieldValidatorsIndex = typeValidators != null ? ((List)typeValidators).size() : 0;
        ArrayList<DataTypeMap> allValidators = DataTools.makeListIfSingle(DataTools.combineAsLists(typeValidators, fieldValidators));
        if ((allValidators = DataTools.makeListIfSingle(DataTools.combineAsLists(allValidators, relatedRecordValidator))) == null) {
            allValidators = new ArrayList<DataTypeMap>();
        }
        boolean enumValidatorFound = false;
        Long length = field.getLength();
        boolean lengthValidatorFound = false;
        Collection list = null;
        for (Object e : allValidators) {
            if (!(e instanceof Map)) continue;
            Map validator = (Map)e;
            if ("isOneOf".equals(validator.get("type"))) {
                enumValidatorFound = true;
                if (!validator.containsKey("list")) {
                    if (list == null) {
                        list = this.getLegalValues(field);
                    }
                    if (list == null || list.size() == 0) {
                        log.warn("invalid isOneOf validator with no validator.list and no field.valueMap at field: " + fieldName + " of type: " + typeId);
                        continue;
                    }
                    validator.put("list", list);
                }
            }
            if (length == null || !"lengthRange".equals(validator.get("type")) || !validator.containsKey("max")) continue;
            Long max = null;
            try {
                String stringParam = validator.get("max").toString();
                stringParam = stringParam.trim();
                int decimalIndex = stringParam.indexOf(".");
                if (decimalIndex != -1 && Integer.parseInt(stringParam.substring(decimalIndex + 1)) == 0) {
                    stringParam = stringParam.substring(0, decimalIndex);
                }
                max = new Long(stringParam);
            }
            catch (NumberFormatException e2) {
                max = null;
            }
            if (max == null || max > length) continue;
            lengthValidatorFound = true;
        }
        if (isEnumType && !enumValidatorFound) {
            if (list == null) {
                list = this.getLegalValues(field);
            }
            if (list == null || list.size() == 0) {
                log.warn("invalid field of enum type has no field.valueMap at field: " + fieldName + " of type: " + typeId);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("for field: " + fieldName + " adding automatically generated isOneOf validator with values: " + DataTools.prettyPrint(list));
                }
                allValidators.add(fieldValidatorsIndex++, DataTools.buildMap("type", "isOneOf", "list", list));
            }
        }
        if (length != null && !lengthValidatorFound) {
            if (log.isDebugEnabled()) {
                log.debug("for field: " + fieldName + "adding automatically generated lengthRange validator for length:" + length);
            }
            allValidators.add(fieldValidatorsIndex++, DataTools.buildMap("type", "lengthRange", "max", length));
        }
        if (Logger.validation.isDebugEnabled()) {
            Logger.validation.debug("Creating field validator for field " + this.getName() + "." + field.getName() + ", of simple type: " + field.getType() + ", with inline validators: " + fieldValidators + ", and type validators: " + typeValidators);
        }
        type = new SimpleType(typeId, allValidators);
        field.put(CACHED_TYPE, type);
        return type;
    }

    protected Collection getLegalValues(DSField field) throws Exception {
        Map typeDef;
        Map localType;
        String typeId = field.getType();
        Object valueMap = field.get("valueMap");
        if (valueMap == null && (localType = this.getLocalType(typeId)) != null) {
            valueMap = localType.get("valueMap");
        }
        if (valueMap == null && (typeDef = BasicDataSource.getBuiltinType(typeId)) != null) {
            valueMap = typeDef.get("valueMap");
        }
        Collection<Object> list = null;
        if (valueMap instanceof Map) {
            list = ((Map)valueMap).keySet();
        } else if (valueMap instanceof Collection) {
            list = (Collection)valueMap;
        }
        return list;
    }

    protected IType makeType(String typeId, Map typeDef) throws Exception {
        if (typeDef == null) {
            return null;
        }
        SimpleType type = (SimpleType)typeDef.get(CACHED_TYPE);
        if (type != null) {
            return type;
        }
        if (Logger.validation.isDebugEnabled()) {
            Logger.validation.debug("Creating simple type validator for simple type: " + typeId);
        }
        type = new SimpleType(typeId, this.getSimpleTypeValidators(typeDef), typeDef);
        typeDef.put(CACHED_TYPE, type);
        return type;
    }

    protected IType getType(String typeId, ValidationContext context) throws Exception {
        Map typeDef = BasicDataSource.getBuiltinType(typeId);
        if (typeDef != null) {
            return this.makeType(typeId, typeDef);
        }
        typeDef = this.getLocalType(typeId);
        if (typeDef != null) {
            log.debug("Using local type " + typeId);
            if (typeDef.get("fields") != null) {
                DataSource ds = context.getType(typeId);
                if (ds == null) {
                    ds = DataSource.fromConfig(typeDef, context.getDSRequest());
                }
                return ds;
            }
            return this.makeType(typeId, typeDef);
        }
        DataSource ds = this.findDataSource(typeId, context);
        if (ds != null) {
            return ds;
        }
        return this.getSimpleType(typeId, context);
    }

    @Override
    protected Map getSimpleTypeDef(String typeId) {
        if (typeId == null) {
            return null;
        }
        Map typeDef = super.getSimpleTypeDef(typeId);
        if (typeDef != null) {
            return typeDef;
        }
        try {
            String typeConfigFile = DataStructCache.getInstanceFile(typeId, "datasources", "type");
            if (typeConfigFile == null) {
                return null;
            }
            typeDef = (Map)DataStructCache.loadInstance(typeConfigFile, typeId, "type");
            if (typeDef != null && typeDef.get("fields") == null) {
                return typeDef;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public IType getSimpleType(String typeId, ValidationContext context) throws Exception {
        if (this.dsConfig == null) {
            this.dsConfig = new DataTypeMap();
        }
        return context.getCustomSimpleType(typeId, this);
    }

    public Object getSimpleTypeValidators(Map type) throws Exception {
        Object validators = type.get("validators");
        String parentTypeID = (String)type.get("inheritsFrom");
        while (parentTypeID != null) {
            Map parentType = this.getSimpleTypeDef(parentTypeID);
            Object parentValidators = parentType.get("validators");
            validators = DataTools.combineAsLists(parentValidators, validators);
            parentTypeID = (String)parentType.get("inheritsFrom");
        }
        return validators;
    }

    protected DataSource findDataSource(String dsName, ValidationContext context) throws Exception {
        if (dsName == null) {
            return null;
        }
        Map type = this.getLocalType(dsName);
        if (type != null && type.get("fields") != null) {
            log.debug("Getting DataSource " + dsName + " as a locally defined type");
            DataSource ds = context.getType(dsName);
            if (ds == null) {
                ds = DataSource.fromConfig(type, context.getDSRequest());
            }
            return ds;
        }
        boolean schemaless = "Object".equals(this.dsName);
        return context.getType(dsName, schemaless);
    }

    @Override
    public Map selectUnique(Map constraints) throws Exception {
        return this.fetchSingle(DataTools.subsetMap(constraints, this.primaryKeys));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean shouldAutoStartTransaction(DSRequest req, boolean ignoreExistingTransaction) throws Exception {
        if (req == null) return false;
        if (req.getDsTransaction() == null) {
            return false;
        }
        if (!ignoreExistingTransaction && this.getTransactionObject(req) != null) {
            return false;
        }
        if (!this.shouldAutoJoinTransaction(req)) {
            return false;
        }
        DSTransaction dsTransaction = req.getDsTransaction();
        if (this.isModificationRequest(req)) {
            if (!this.policyShouldOverrideConfig(req)) return true;
            if (dsTransaction.getTransactionPolicy() != 4) return true;
            return false;
        }
        if (this.policyShouldOverrideConfig(req)) {
            int policy = dsTransaction.getTransactionPolicy();
            if (policy == 4) {
                return false;
            }
            if (policy == 3) {
                return true;
            }
            if (policy == 2) {
                return dsTransaction.requestQueueIncludesUpdates();
            }
            if (policy != 1) return false;
            return false;
        }
        int policy = this.inferConfigTransactionPolicy(req);
        if (policy == 3) {
            return true;
        }
        if (policy != 2) return false;
        return dsTransaction.requestQueueIncludesUpdates();
    }

    private int inferConfigTransactionPolicy(DSRequest req) throws Exception {
        Boolean reqOverride;
        if (req != null && req.getDsTransaction() != null && (reqOverride = req.shouldJoinTransaction()) != null) {
            return reqOverride != false ? 3 : 4;
        }
        Boolean work = this.autoJoinAtOperationLevel(req);
        if (work != null) {
            return work != false ? 3 : 4;
        }
        work = this.autoJoinAtDataSourceLevel();
        if (work != null) {
            return work != false ? 3 : 4;
        }
        int tp = this.getProviderLevelTransactionPolicy(req);
        if (tp != 0) {
            return tp;
        }
        tp = this.getGlobalLevelTransactionPolicy(req);
        return 4;
    }

    public boolean shouldAutoJoinTransaction(DSRequest dsRequest) throws Exception {
        Boolean work;
        if (dsRequest != null && dsRequest.getDsTransaction() != null) {
            Boolean reqOverride = dsRequest.shouldJoinTransaction();
            if (reqOverride != null) {
                return reqOverride;
            }
            if (dsRequest.isCacheSyncRequest()) {
                return this.shouldAutoStartTransaction(dsRequest.getPrimaryDSRequest(), true);
            }
        }
        if ((work = this.autoJoinAtOperationLevel(dsRequest)) == null && (work = this.autoJoinAtDataSourceLevel()) == null) {
            if (dsRequest != null && dsRequest.getDsTransaction() != null) {
                DSTransaction dsTransaction = dsRequest.getDsTransaction();
                int policy = dsTransaction.getTransactionPolicy();
                if (policy == 4) {
                    return false;
                }
                if (policy == 3) {
                    return true;
                }
                if (policy == 2) {
                    return dsTransaction.requestQueueIncludesUpdates();
                }
                if (policy == 1) {
                    return dsTransaction.requestQueueIncludesPriorUpdate(dsRequest);
                }
            }
            if ((work = this.autoJoinAtProviderLevel(dsRequest)) == null) {
                work = this.autoJoinAtGlobalLevel(dsRequest);
            }
        }
        return work != null && work != false;
    }

    protected boolean policyShouldOverrideConfig(DSRequest req) throws Exception {
        Boolean work;
        if (req != null && req.getDsTransaction() != null) {
            Boolean reqOverride = req.shouldJoinTransaction();
            if (reqOverride != null) {
                return reqOverride;
            }
            if (req.getDsTransaction().getTransactionPolicy() == 0) {
                return false;
            }
        }
        if ((work = this.autoJoinAtOperationLevel(req)) == null) {
            work = this.autoJoinAtDataSourceLevel();
        }
        return work == null;
    }

    protected Boolean autoJoinAtOperationLevel(DSRequest req) throws Exception {
        DataTypeMap operationBinding = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        if (operationBinding == null) {
            return null;
        }
        return operationBinding.getBoolean("autoJoinTransactions");
    }

    protected Boolean autoJoinAtDataSourceLevel() {
        return this.dsConfig.getBoolean("autoJoinTransactions");
    }

    protected Boolean autoJoinAtProviderLevel(DSRequest req) throws Exception {
        return null;
    }

    public int getProviderLevelTransactionPolicy(DSRequest req) throws Exception {
        return 0;
    }

    protected Boolean autoJoinAtGlobalLevel(DSRequest req) {
        String autoJoin = config.getString("autoJoinTransactions");
        if (autoJoin == null) {
            return null;
        }
        if (autoJoin.equalsIgnoreCase("true") || autoJoin.equalsIgnoreCase("ALL")) {
            return Boolean.TRUE;
        }
        if (autoJoin.equalsIgnoreCase("false") || autoJoin.equalsIgnoreCase("NONE")) {
            return Boolean.FALSE;
        }
        if (req != null && req.getDsTransaction() != null) {
            if (autoJoin.equalsIgnoreCase("FROM_FIRST_CHANGE")) {
                return req.getDsTransaction().requestQueueIncludesUpdates();
            }
            if (autoJoin.equalsIgnoreCase("ANY_CHANGE")) {
                return req.getDsTransaction().requestQueueIncludesUpdates();
            }
        }
        return null;
    }

    protected int getGlobalLevelTransactionPolicy(DSRequest req) {
        String autoJoin = config.getString("autoJoinTransactions");
        if (autoJoin == null) {
            return 0;
        }
        if (autoJoin.equalsIgnoreCase("true") || autoJoin.equalsIgnoreCase("ALL")) {
            return 3;
        }
        if (autoJoin.equalsIgnoreCase("false") || autoJoin.equalsIgnoreCase("NONE")) {
            return 4;
        }
        if (autoJoin.equalsIgnoreCase("FROM_FIRST_CHANGE")) {
            return 1;
        }
        if (autoJoin.equalsIgnoreCase("ANY_CHANGE")) {
            return 2;
        }
        return 0;
    }

    public boolean getReturnToTop() {
        return DataTools.asBoolean(this.dsConfig.get("returnToTop"), true);
    }

    public DataSource getAuditDataSource() {
        if (Boolean.TRUE.equals(this.dsConfig.get("audit"))) {
            String auditId = "audit_" + this.getID();
            if (this.dsConfig.containsKey("auditDataSourceID")) {
                auditId = (String)this.dsConfig.get("auditDataSourceID");
            }
            try {
                return DataSourceManager.getDataSource(auditId);
            }
            catch (Exception e) {
                log.warn("There was an error retrieving audit DataSource:" + DataTools.getStackTrace(e));
            }
        }
        return null;
    }

    @Override
    public DSResponse executeClientExport(DSRequest req) throws Exception {
        req.setExportResults(true);
        DSResponse resp = new DSResponse(this);
        resp.setData(req.getRawValues());
        return resp;
    }

    @Override
    public DSResponse executeStoreTestData(DSRequest req) throws Exception {
        Object values = req.getRawValues();
        String fileName = (String)req.getParameter("fileName");
        if (fileName != null) {
            fileName = config.getPath("webRoot") + "/" + fileName;
            fileName = ISCFile.canonicalizePath(fileName);
        }
        String tagName = "item";
        DataSource ds = req.getDataSource();
        if (ds != null) {
            DataSource testDs;
            if (fileName == null) {
                fileName = ds.getTestFileName();
            }
            if (fileName == null && ds.getConfig().containsKey("sourceDataSourceID") && (testDs = DataSourceManager.getDataSource(ds.getConfig().get("sourceDataSourceID") + "_testData", null)) != null) {
                fileName = "ds://" + ds.getConfig().get("sourceDataSourceID") + "_testData/" + ds.getName() + ".data.xml";
            }
            if (fileName == null && !ISCFile.newInstance(fileName = "ds://" + ds.getConfig().get("sourceDataSourceID") + "/test_data/" + ds.getName() + ".data.xml").exists()) {
                fileName = null;
            }
            if (fileName == null) {
                fileName = config.getPath("webRoot") + "/test_data/" + ds.getName() + ".data.xml";
                fileName = ISCFile.canonicalizePath(fileName);
            }
            tagName = ds.getName();
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<List>\n");
        List data = (List)values;
        for (Object record : data) {
            XML.recordToXML(tagName, (Map)record, stringWriter, true, false, ds, req);
        }
        stringWriter.write("</List>");
        String testDataContent = stringWriter.toString();
        if (fileName.startsWith("ds://")) {
            DSFileSpec dsFileSpec = new DSFileSpec(fileName);
            DataSource testDs = DataSourceManager.getDataSource(dsFileSpec.getDataSourceName(), null);
            testDs.saveFile(dsFileSpec, testDataContent);
        } else {
            boolean saveFileBuiltinIsEnabled;
            List enabledBuiltinMethods = config.getList("RPCManager.enabledBuiltinMethods");
            boolean bl = saveFileBuiltinIsEnabled = enabledBuiltinMethods != null && (enabledBuiltinMethods.contains("saveFile") || enabledBuiltinMethods.contains("*"));
            if (!saveFileBuiltinIsEnabled) {
                throw new Exception("\"storeTestData\" operation cannot be used unless \"saveFile\" Builtin-RPC is enabled");
            }
            File f = new File(fileName);
            File dir = f.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            IOUtil.atomicWrite(testDataContent, fileName);
        }
        return new DSResponse(this);
    }

    @Override
    public DSResponse executeGetTestData(DSRequest req) throws Exception {
        String testFileName;
        BasicDataSource ds = this;
        Reader testDataReader = null;
        if (ds != null && (testFileName = ds.getTestFileName()) != null) {
            if (testFileName.startsWith("ds:/")) {
                DSFileSpec dsFileSpec = new DSFileSpec(testFileName);
                DataSource testDs = DataSourceManager.getDataSource(dsFileSpec.getDataSourceName(), null);
                testDataReader = testDs.getFile(dsFileSpec);
            } else {
                InputStream is = null;
                try {
                    is = DataTools.inputStreamForFilename(testFileName);
                    testDataReader = new InputStreamReader(is);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to Load test data.", e);
                }
            }
        }
        DSResponse dsResponse = new DSResponse((DataSource)this, 0);
        dsResponse.setData((Object)DataTools.buildMap("testData", testDataReader));
        return dsResponse;
    }

    @Override
    public void freeQueueResources(DSRequest req) {
        if (this.downloadDsRequest != null) {
            try {
                DataSourceManager.free(this.downloadDsRequest.getDataSource());
                this.downloadDsRequest = null;
            }
            catch (Exception e) {
                log.warn((Object)"Exception while freeing download DSRequest", e);
            }
        }
        this.clearState();
        super.freeQueueResources(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoCreateAuditTableActive() {
        String auditAutoCreate = (String)Config.getProperty(GLOBAL_AUTO_CREATE_AUDIT_TABLE_KEY);
        if (auditAutoCreate != null && "true".equals(auditAutoCreate)) {
            return true;
        }
        if (this.dsConfig.getBoolean((Object)"audit", false) && this.dsConfig.getBoolean((Object)DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY, false)) {
            return true;
        }
        if (auditGenerator != null && auditGenerator.hasMappingFor(this.getID())) {
            DataSource auditedDS = null;
            try {
                auditedDS = DataSourceManager.getDataSource(auditGenerator.getMappingFor(this.getID()));
                if (auditedDS.getConfig().getBoolean((Object)"audit", false) && auditedDS.getConfig().getBoolean((Object)DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY, false)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (auditedDS != null) {
                    DataSourceManager.freeDataSource(auditedDS);
                }
            }
        }
        return false;
    }

    @Override
    protected boolean isValidSubclass() {
        return true;
    }

    @Override
    public void transformMultipleFields(DSRequest req) {
        if ("false".equals(this.dsConfig.get("transformMultipleFields"))) {
            log.warn("transformMultipleFields is set to false for DataSource " + this.getName());
            return;
        }
        DataTypeMap binding = this.getOperationBinding(req);
        if (binding != null && "false".equals(binding.get("transformMultipleFields"))) {
            log.warn("transformMultipleFields is set to false for operationBinding on DataSource " + this.getName());
            return;
        }
        if (BasicDataSource.isFetch(req.getOperationType()) && !this.getMultipleFields().isEmpty()) {
            req.setCriteria(this.multipleFieldCriteriaTransformer.transform(req.getCriteria()));
        } else if (!BasicDataSource.isFetch(req.getOperationType())) {
            for (DSField dsField : this.getMultipleFields()) {
                StringBuffer result;
                String sep;
                ArrayList values;
                String multipleStorage;
                Object value = req.getFieldValue(dsField.getName());
                if (value == null) continue;
                String multipleSeparator = dsField.getMultipleStorageSeparator();
                if (multipleSeparator == null) {
                    multipleSeparator = dsField.getMultipleValueSeparator();
                }
                if ("simpleString".equals(multipleStorage = dsField.getMultipleStorage())) {
                    values = (ArrayList)value;
                    sep = "";
                    result = new StringBuffer();
                    for (Object arrayValue : values) {
                        result.append(sep);
                        result.append(this.convertToSchemaValue(dsField, arrayValue));
                        sep = multipleSeparator;
                    }
                    req.setFieldValue(dsField.getName(), result.toString());
                }
                if (!"json".equals(multipleStorage)) continue;
                values = (ArrayList)value;
                sep = "";
                result = new StringBuffer();
                result.append("[");
                for (Object arrayValue : values) {
                    result.append(sep);
                    result.append(this.convertToSchemaValue(dsField, arrayValue));
                    sep = ",";
                }
                result.append("]");
                req.setFieldValue(dsField.getName(), result.toString());
            }
        }
    }

    private String convertToSchemaValue(DSField field, Object value) {
        if (value == null) {
            log.warn("Value is null, skipping transform");
            return null;
        }
        String type = field.getType();
        if ("date".equals(type) || "time".equals(type) || "datetime".equals(type)) {
            Date date = (Date)value;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String res = sdf.format(date);
            if ("json".equals(field.getMultipleStorage())) {
                res = "new Date(\"" + res + "\")";
            }
            return res;
        }
        if ("int".equals(type) || "integer".equals(type) || "intEnum".equals(type)) {
            return value.toString();
        }
        if ("float".equals(type) || "decimal".equals(type) || "double".equals(type)) {
            return value.toString();
        }
        if ("text".equals(type)) {
            if ("json".equals(field.getMultipleStorage())) {
                String res = "\"" + this.textToJson(value.toString()) + "\"";
                return res;
            }
            return value.toString();
        }
        log.warn("Field " + field.getName() + " has value type " + field.getType() + " which is unhandled. Returning toString()");
        return value.toString();
    }

    private String textToJson(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\"", "\\\"");
    }

    private String textFromJson(String text) {
        if (text == null) {
            return null;
        }
        String res = text.replace("\\\"", "\"");
        return res;
    }

    private Object convertFromSchemaValue(DSField field, String value) {
        if (value == null) {
            return null;
        }
        if ("null".equals(value)) {
            return null;
        }
        String fieldName = field.getName();
        String type = field.getType();
        if ("date".equals(type) || "datetime".equals(type) || "time".equals(type)) {
            if ("json".equals(field.getMultipleStorage())) {
                value = value.substring(1, value.length() - 1);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                return sdf.parse(value);
            }
            catch (ParseException e) {
                log.warn("Error converting back " + value + " to UTC date");
                e.printStackTrace();
                return null;
            }
        }
        if ("int".equals(type) || "integer".equals(type) || "intEnum".equals(type)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                log.warn("Error converting back " + value + " to Long");
                ex.printStackTrace();
                return null;
            }
        }
        if ("float".equals(type) || "decimal".equals(type) || "double".equals(type)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                log.warn("Error converting back " + value + " to Double");
                ex.printStackTrace();
                return null;
            }
        }
        if ("text".equals(type)) {
            if ("json".equals(field.getMultipleStorage())) {
                String res = value.substring(1, value.length() - 1);
                return this.textFromJson(res);
            }
            return value;
        }
        return value;
    }

    @Override
    public void transformMultipleFields(DSResponse res) {
        boolean hadDS;
        String ot = res.getOperationType();
        if ("false".equals(this.dsConfig.get("transformMultipleFields"))) {
            log.warn("response:transformMultipleFields is set to false for DataSource " + this.getName());
            return;
        }
        boolean wasContainer = res.getData() != null && res.getData() instanceof List;
        boolean bl = hadDS = res.getDataSource() != null;
        if (!hadDS) {
            res.setDataSource(this);
        }
        List<DSField> fields = this.getMultipleFields();
        List records = res.getRecords();
        if (!hadDS) {
            res.setDataSource(null);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        if (records == null) {
            log.warn("There are no records to be transformed by transformMultipleFields!");
            return;
        }
        boolean workWasDone = false;
        for (Object record : records) {
            if (!(record instanceof Map)) continue;
            Map mrecord = (Map)record;
            for (DSField f : fields) {
                String multipleStorage;
                DSField dsField = f;
                Object value = mrecord.get(dsField.getName());
                if (value == null) continue;
                String multipleSeparator = dsField.getMultipleStorageSeparator();
                if (multipleSeparator == null) {
                    multipleSeparator = dsField.getMultipleValueSeparator();
                }
                if ("none".equals(multipleStorage = dsField.getMultipleStorage())) {
                    log.debug("Field " + dsField.getName() + " is multiple, but multipleStorage 'none'. Skipping processing.");
                    continue;
                }
                if ("simpleString".equals(multipleStorage)) {
                    if (!(value instanceof String)) continue;
                    if (((String)value).length() == 0) {
                        mrecord.put(dsField.getName(), new ArrayList());
                        workWasDone = true;
                        continue;
                    }
                    String[] castedValue = DataTools.split((String)value, multipleSeparator);
                    ArrayList<Object> convertedValue = new ArrayList<Object>();
                    for (String val : castedValue) {
                        convertedValue.add(this.convertFromSchemaValue(dsField, val));
                    }
                    mrecord.put(dsField.getName(), convertedValue);
                    workWasDone = true;
                    continue;
                }
                if (!"json".equals(multipleStorage)) continue;
                String jsonValue = "";
                if (value instanceof String) {
                    jsonValue = (String)value;
                } else {
                    if (value instanceof ArrayList) {
                        ArrayList v = (ArrayList)value;
                        log.warn("Value is already ArrayList, skipping conversion");
                        continue;
                    }
                    jsonValue = value.toString();
                }
                jsonValue = jsonValue.replace("[", "");
                jsonValue = jsonValue.replace("]", "");
                jsonValue = jsonValue.replace("new Date(", "");
                jsonValue = jsonValue.replace(")", "");
                if (jsonValue.length() == 0) {
                    mrecord.put(dsField.getName(), new ArrayList());
                    workWasDone = true;
                    continue;
                }
                String[] castedValue = DataTools.split(jsonValue, ",");
                ArrayList<Object> convertedValue = new ArrayList<Object>();
                for (String val : castedValue) {
                    val = val.trim();
                    convertedValue.add(this.convertFromSchemaValue(dsField, val));
                }
                mrecord.put(dsField.getName(), convertedValue);
                workWasDone = true;
            }
            result.add(mrecord);
        }
        if (workWasDone) {
            log.debug("response:Records were changed, updating dsResponse data, operation is " + ot);
            if (wasContainer) {
                res.setData(result);
            } else if (result.size() != 1) {
                log.error("Transformation error: When starting, dsResponse.data was record, and at the end there are more than 1 items in the list, returning first one");
                res.setData(result.get(0));
            } else {
                log.debug("When starting, dsResponse.data was record, storing record to dsResponse.data.");
                res.setData(result.get(0));
            }
        }
    }

    protected List<DSField> getMultipleFields() {
        return this.dsMultipleFields;
    }

    static {
        numRecords = 0;
        numFields = 0;
    }
}

