/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.Authenticator;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataSourceAuthenticator
extends Authenticator {
    public String datasource = "users";
    public String usernameField = "username";
    public String passwordField = "password";
    public String rolesField = "roles";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Principal authenticate(RequestContext context) throws Exception {
        String submittedUsername = this.getSubmittedUsername(context);
        String submittedPassword = this.getSubmittedPassword(context);
        if (submittedUsername == null) {
            this.log.debug("attempt to authenticate with a null username");
            return null;
        }
        if (submittedPassword == null) {
            this.log.debug("attempt to authenticate with a null password with username: " + submittedUsername);
            return null;
        }
        DataSource ds = DataSourceManager.getDataSource(this.datasource, null);
        if (ds == null) {
            throw new Exception("Unable to load datasource: " + this.datasource + " for authentication");
        }
        try {
            Map userRow = ds.selectSingle(this.usernameField, submittedUsername);
            if (userRow == null || userRow.size() == 0) {
                this.log.debug("no user record for username: " + submittedUsername);
                Principal principal = null;
                return principal;
            }
            String dsPassword = (String)userRow.get(this.passwordField);
            if (dsPassword.equals(submittedPassword)) {
                this.log.debug("datasource auth succeded for username: " + submittedUsername);
                userRow.remove(this.passwordField);
                AuthenticatedUser authenticatedUser = new AuthenticatedUser((String)userRow.get(this.usernameField), userRow, this);
                return authenticatedUser;
            }
            this.log.info("password incorrect for username: " + submittedUsername);
            Principal principal = null;
            return principal;
        }
        finally {
            try {
                DataSourceManager.freeDataSource(ds);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<String> getUserRoles(RequestContext context) throws Exception {
        Object storedRoles;
        List<String> userRoles = new ArrayList<String>();
        AuthenticatedUser user = (AuthenticatedUser)this.getUser(context);
        if (user != null && this.rolesField != null && (storedRoles = user.get(this.rolesField)) != null) {
            if (storedRoles instanceof String) {
                String storedRolesString = (String)storedRoles;
                userRoles = storedRolesString.indexOf("[") != -1 ? (List)JSTranslater.instance().fromJS(storedRolesString) : DataTools.simpleSplit(storedRolesString, "|");
            } else {
                if (storedRoles instanceof List) {
                    return userRoles;
                }
                throw new Exception("Expected a List or String for rolesField '" + this.rolesField + "', but got: " + storedRoles.getClass().getName());
            }
        }
        return userRoles;
    }
}

