/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.ISCKeyedPoolableObjectFactory;
import java.util.HashSet;
import java.util.Set;

public class PoolableDataSourceFactory
extends ISCKeyedPoolableObjectFactory {
    private static Logger log = new Logger(PoolableDataSourceFactory.class.getName());
    private static Config config = Config.getGlobal();
    private boolean enableUpToDateCheck = false;
    private ThreadLocal<DSRequest> dsRequest = new ThreadLocal();
    private ThreadLocal<Boolean> isSchemaless = new ThreadLocal();
    private Set unknownDataSources = new HashSet();

    public void setDSRequest(DSRequest value) {
        this.dsRequest.set(value);
    }

    public void removeDSRequest() {
        this.dsRequest.remove();
    }

    public void setIsSchemaless(boolean value) {
        this.isSchemaless.set(value);
    }

    public void removeIsSchemaless() {
        this.isSchemaless.remove();
    }

    @Override
    public IPoolableObjectFactory newInstance(Object key) throws Exception {
        return new PoolableDataSourceFactory();
    }

    PoolableDataSourceFactory() {
        boolean globalCheckEnabled = config.getBoolean((Object)"datasources.enableUpToDateCheck", false);
        Boolean thisCheckEnabled = config.getBoolean((Object)"datasources.enableUpToDateCheck", null);
        this.enableUpToDateCheck = thisCheckEnabled != null && thisCheckEnabled != false || thisCheckEnabled == null && globalCheckEnabled;
    }

    public void activateObject(Object key, Object obj) throws Exception {
        ++this.numActivateObjectCalls;
        if (obj != null) {
            DataSource ds = (DataSource)obj;
            ds.activateOnThread(Thread.currentThread());
            log.debug("Activated DataSource " + (ds == null ? "null" : Long.valueOf(ds.getInstanceId())) + " of type '" + key + "'");
        }
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        ++this.numDestroyObjectCalls;
        ((DataSource)obj).clearState();
    }

    @Override
    public synchronized Object makeUnpooledObject(Object key) throws Exception {
        if (this.unknownDataSources.contains(key)) {
            log.debug("makeUnpooledObject was asked for DataSource '" + key + "', which we have already looked for and not found - bailing");
        }
        Boolean isSchemaless = this.isSchemaless.get();
        DataSource ds = DataSource.forName(key.toString(), this.dsRequest.get(), isSchemaless == null ? false : isSchemaless);
        if (ds != null) {
            ds.activateOnThread(Thread.currentThread());
            log.debug("Created DataSource " + (ds == null ? "null" : Long.valueOf(ds.getInstanceId())) + " of type '" + key + "' and assigned it to thread " + Thread.currentThread().getName());
        } else {
            log.debug("Tried to create DataSource  of type '" + key + "' but null was returned");
            if (config.getBoolean((Object)"datasource.cacheFailedLookups", false)) {
                this.unknownDataSources.add(key);
            }
        }
        return ds;
    }

    public Object makeObject(Object key) throws Exception {
        ++this.numMakeObjectCalls;
        DataSource ds = (DataSource)this.makeUnpooledObject(key);
        log.debug("Created DataSource " + (ds == null ? "null" : Long.valueOf(ds.getInstanceId())) + " of type '" + key + "' in the pooling flow");
        return ds;
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        ++this.numPassivateObjectCalls;
        DataSource ds = (DataSource)obj;
        ds.clearState();
        ds.passivate();
        log.debug("Cleared and passivated DataSource " + (ds == null ? "null" : Long.valueOf(ds.getInstanceId())) + " of type '" + key + "'");
    }

    public boolean validateObject(Object key, Object obj) {
        ++this.numValidateObjectCalls;
        if (obj == null) {
            return true;
        }
        DataSource ds = (DataSource)obj;
        if (this.enableUpToDateCheck) {
            boolean isStale = ds.isStale();
            if (isStale) {
                log.debug("Discarding stale DataSource of type '" + key.toString() + "'");
            }
            return !isStale;
        }
        return true;
    }
}

