/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.RelationInfo;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Relation {
    public static final int JOIN_TYPE_INNER = 0;
    public static final int JOIN_TYPE_OUTER = 1;
    private static Logger log = new Logger(Relation.class.getName());
    private DataSource fromDataSource;
    private DataSource toDataSource;
    private List<DSField> fromFields;
    private List<DSField> toFields;
    private String fromAlias;
    private String toAlias;
    private int joinType;
    private Relation nextRelation;

    public static Relation create(RelationInfo relationInfo, Map<String, DataSource> dsObjectsMap, DSRequest dsRequest) {
        String toDSName;
        if (relationInfo == null) {
            return null;
        }
        Relation relation = new Relation();
        String fromDSName = relationInfo.getFromDataSource();
        if (fromDSName != null && !"".equals(fromDSName.trim())) {
            DataSource fromDS = dsObjectsMap.get(fromDSName);
            if (fromDS == null) {
                try {
                    fromDS = DataSourceManager.get(fromDSName, dsRequest);
                    log.debug("Caching instance of fromDS '" + fromDSName + "' in the DSRequest map");
                    dsObjectsMap.put(fromDSName, fromDS);
                }
                catch (Exception ex) {
                    log.warn((Object)("Failed to create data source '" + fromDSName + "'."), ex);
                }
            }
            relation.setFromDataSource(fromDS);
            List<String> fromFieldNames = relationInfo.getFromFields();
            if (fromDS != null && fromFieldNames != null) {
                ArrayList<DSField> fromFields = new ArrayList<DSField>();
                for (String fieldName : fromFieldNames) {
                    fromFields.add(fromDS.getField(fieldName));
                }
                relation.setFromFields(fromFields);
            }
            relation.setFromAlias(relationInfo.getFromAlias());
        }
        if ((toDSName = relationInfo.getToDataSource()) != null && !"".equals(toDSName.trim())) {
            DataSource toDS = dsObjectsMap.get(toDSName);
            if (toDS == null) {
                try {
                    toDS = DataSourceManager.get(toDSName, dsRequest);
                    log.debug("Caching instance of toDS '" + toDSName + "' in the DSRequest map");
                    dsObjectsMap.put(toDSName, toDS);
                }
                catch (Exception ex) {
                    log.warn((Object)("Failed to create data source '" + toDSName + "'."), ex);
                }
            }
            relation.setToDataSource(toDS);
            List<String> toFieldNames = relationInfo.getToFields();
            if (toDS != null && toFieldNames != null) {
                ArrayList<DSField> toFields = new ArrayList<DSField>();
                for (String fieldName : toFieldNames) {
                    toFields.add(toDS.getField(fieldName));
                }
                relation.setToFields(toFields);
            }
            relation.setToAlias(relationInfo.getToAlias());
        }
        relation.setJoinType(relationInfo.getJoinType());
        relation.setNextRelation(Relation.create(relationInfo.getNextRelation(), dsObjectsMap, dsRequest));
        return relation;
    }

    public DataSource getFromDataSource() {
        return this.fromDataSource;
    }

    public void setFromDataSource(DataSource fromDataSource) {
        this.fromDataSource = fromDataSource;
    }

    public List<DSField> getFromFields() {
        return this.fromFields;
    }

    public void setFromFields(List<DSField> fromFields) {
        this.fromFields = fromFields;
    }

    public void addFromField(DSField field) {
        if (this.fromFields == null) {
            this.fromFields = new ArrayList<DSField>();
        }
        this.fromFields.add(field);
    }

    public void removeFromField(DSField field) {
        if (this.fromFields == null) {
            return;
        }
        this.fromFields.remove(field);
    }

    public DataSource getToDataSource() {
        return this.toDataSource;
    }

    public void setToDataSource(DataSource toDataSource) {
        this.toDataSource = toDataSource;
    }

    public List<DSField> getToFields() {
        return this.toFields;
    }

    public void setToFields(List<DSField> toFields) {
        this.toFields = toFields;
    }

    public void addToField(DSField field) {
        if (this.toFields == null) {
            this.toFields = new ArrayList<DSField>();
        }
        this.toFields.add(field);
    }

    public void removeToField(DSField field) {
        if (this.toFields == null) {
            return;
        }
        this.toFields.remove(field);
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public boolean isValid() {
        return this.fromDataSource != null && this.toDataSource != null && this.fromFields != null && this.fromFields.size() > 0 && this.toFields != null && this.toFields.size() == this.fromFields.size();
    }

    public boolean isComposite() {
        return this.isValid() && this.fromFields.size() > 1;
    }

    public String getFromFieldIndexValue(Map record) {
        return this.buildIndexValue(record, this.fromFields);
    }

    public String getToFieldIndexValue(Map record) {
        return this.buildIndexValue(record, this.toFields);
    }

    private String buildIndexValue(Map record, List<DSField> fields) {
        StringBuffer sb = new StringBuffer();
        for (DSField fld : fields) {
            String name = fld.getName();
            Object value = record.get(name);
            sb.append(value == null ? "null" : value.toString());
        }
        return sb.toString();
    }

    public boolean isAToField(String fieldName) {
        return this.isARelationField(fieldName, this.toFields);
    }

    public boolean isAFromField(String fieldName) {
        return this.isARelationField(fieldName, this.fromFields);
    }

    private boolean isARelationField(String fieldName, List<DSField> fields) {
        if (fieldName == null) {
            return false;
        }
        Iterator<DSField> i = fields.iterator();
        while (i.hasNext()) {
            if (!fieldName.equals(i.next().getName())) continue;
            return true;
        }
        return false;
    }

    public String getFromAlias() {
        return this.fromAlias;
    }

    public void setFromAlias(String fromAlias) {
        this.fromAlias = fromAlias;
    }

    public String getToAlias() {
        return this.toAlias;
    }

    public void setToAlias(String toAlias) {
        this.toAlias = toAlias;
    }

    public Relation getNextRelation() {
        return this.nextRelation;
    }

    public void setNextRelation(Relation nextRelation) {
        this.nextRelation = nextRelation;
    }

    public String toString() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("From: " + (this.fromDataSource == null ? "null" : this.fromDataSource.getName()));
        rtn.append(" To: " + (this.toDataSource == null ? "null" : this.toDataSource.getName()));
        rtn.append("\n");
        rtn.append("From keys: " + (this.fromFields == null ? "null" : this.fromFields.toString()));
        rtn.append("\n");
        rtn.append("To keys: " + (this.toFields == null ? "null" : this.toFields.toString()));
        rtn.append("\n");
        rtn.append("From alias: " + (this.fromAlias == null ? "null" : this.fromAlias));
        rtn.append("\n");
        rtn.append("To alias: " + (this.toAlias == null ? "null" : this.toAlias));
        rtn.append("\n");
        rtn.append("Join type: " + (this.joinType == 0 ? "inner" : "outer"));
        rtn.append("\n");
        rtn.append("Next relation: " + (this.nextRelation == null ? "null" : this.nextRelation.toString()));
        return rtn.toString();
    }
}

