/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.taglib.LoadSystemSchemaTag;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class DataSourceLoader
extends BaseServlet {
    public static final String OUTPUT_SC_DETECTION_CODE = "outputSCDetectionCode";
    public static final String SYSTEM_SCHEMA = "$systemSchema";
    private boolean outputSCDetectionCode;
    public boolean enablePrettyPrinting = false;

    public void setEnablePrettyPrinting(String value) {
        this.enablePrettyPrinting = Boolean.valueOf(value);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String lastProcessedDS = null;
        try {
            String mimeType;
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            String encoding = this.getServletConfig().getInitParameter("encoding");
            if (encoding == null) {
                encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
            }
            if ((mimeType = this.getServletConfig().getInitParameter("mimeType")) == null) {
                mimeType = config.getString("DataSourceLoader.mimeType", "application/javascript");
            }
            if (!encoding.toLowerCase().equals("none")) {
                request.setCharacterEncoding(encoding);
                context.setContentType(mimeType + ";charset=" + encoding);
            } else {
                context.setContentType(mimeType);
            }
            StringWriter writer = new StringWriter();
            HashMap<String, DataSource> processed = new HashMap<String, DataSource>();
            context._compressIfPossibleLocal();
            String ids = request.getParameter("dataSource");
            if (ids == null) {
                throw new Exception("No 'dataSource' parameter provided");
            }
            String mockMode = request.getParameter("mockMode");
            boolean useMockMode = mockMode != null && "true".equals(mockMode.toLowerCase());
            boolean stubWritten = false;
            LinkedList<String> multipleIDs = new LinkedList<String>(Arrays.asList(ids.split(",")));
            boolean foundSystemSchema = false;
            ListIterator iter = multipleIDs.listIterator();
            while (iter.hasNext()) {
                String id = ((String)iter.next()).trim();
                if (!SYSTEM_SCHEMA.equals(id)) continue;
                iter.remove();
                foundSystemSchema = true;
            }
            if (foundSystemSchema) {
                LoadSystemSchemaTag.staticInit();
                List<String> systemSchema = LoadSystemSchemaTag.getFrameworkDataSources();
                multipleIDs.addAll(systemSchema);
            }
            for (String id : multipleIDs) {
                DataSource ds;
                lastProcessedDS = id = id.trim();
                if (processed.containsKey(id) || (ds = DataSourceManager.getDataSource(id, null)) != null && ds.isServerOnly()) continue;
                if (ds == null) {
                    BasicDataSource bds = new BasicDataSource();
                    ValidationContext vc = new ValidationContext();
                    IType cst = bds.getSimpleType(id, vc);
                    vc.freeResources();
                    if (cst != null) {
                        JSTranslater jstran = JSTranslater.get().enablePrettyPrinting(this.enablePrettyPrinting);
                        jstran.setObfuscation(false);
                        Locale locale = null;
                        String localeName = request.getParameter("locale");
                        if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
                            this.log.warn("Locale name " + localeName + " is not valid - ignoring");
                        }
                        if (locale == null) {
                            locale = request.getLocale();
                        }
                        jstran.setLocale(locale);
                        if (this.outputSCDetectionCode && !stubWritten) {
                            writer.write("if (window.isc == undefined || window.isc.DataSource == undefined){");
                            writer.write("  alert(\"Can't load DataSources - SmartClient runtime not loaded\");");
                            writer.write("}");
                            stubWritten = true;
                        }
                        jstran.toJS(cst, writer);
                        continue;
                    }
                    throw new JspException("Unable to load DataSource for ID: " + DataTools.escapeHTML(id));
                }
                this.log.debug("For DataSource '" + id + "', got instanceId " + ds.getInstanceId());
                ds._cloneConfigForSecurityAnnotations();
                DeclarativeSecurity.annotateDataSourceFields(ds, (ServletRequest)request);
                JSTranslater jstran = JSTranslater.get().enablePrettyPrinting(this.enablePrettyPrinting);
                jstran.setObfuscation(false);
                Locale locale = null;
                String localeName = request.getParameter("locale");
                if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
                    this.log.warn("Locale name " + localeName + " is not valid - ignoring");
                }
                if (locale == null) {
                    locale = request.getLocale();
                }
                jstran.setLocale(locale);
                if (this.outputSCDetectionCode && !stubWritten) {
                    writer.write("if (window.isc == undefined || window.isc.DataSource == undefined){");
                    writer.write("  alert(\"Can't load DataSources - SmartClient runtime not loaded\");");
                    writer.write("}");
                    stubWritten = true;
                }
                if (useMockMode) {
                    ds.getAnnotatedConfig().put("mockMode", true);
                }
                jstran.toJS(ds, writer);
                processed.put(id, ds);
                if ("true".equals(request.getParameter("loadParents"))) {
                    String inheritsFrom = (String)ds.getConfig().get("inheritsFrom");
                    while (inheritsFrom != null) {
                        if (!processed.containsKey(inheritsFrom)) {
                            ds = DataSourceManager.getDataSource(inheritsFrom, null);
                            if (ds == null) {
                                throw new JspException("Unable to load DataSource for ID '" + DataTools.escapeHTML(inheritsFrom) + "' when loading parent DataSources for DataSource '" + DataTools.escapeHTML(id) + "'");
                            }
                            ds._cloneConfigForSecurityAnnotations();
                            DeclarativeSecurity.annotateDataSourceFields(ds, (ServletRequest)request);
                            jstran = JSTranslater.get().enablePrettyPrinting(this.enablePrettyPrinting);
                            jstran.setObfuscation(false);
                            jstran.setLocale(locale);
                            jstran.toJS(ds, writer);
                            processed.put(inheritsFrom, ds);
                        } else {
                            ds = (DataSource)processed.get(inheritsFrom);
                        }
                        inheritsFrom = (String)ds.getConfig().get("inheritsFrom");
                    }
                }
                Iterator dsIter = processed.keySet().iterator();
                while (dsIter.hasNext()) {
                    DataSourceManager.free((DataSource)processed.get(dsIter.next()));
                }
            }
            context.out().write(writer.toString());
            context.out().flush();
            context.completeResponse();
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to load a DataSource", e);
            throw new ServletException("DataSource '" + lastProcessedDS + "' failed to load due to an exception on the server:\n" + e.getMessage() + "\nSee the server-side log for additional details.");
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (IOException context) {}
        }
    }

    public void init() throws ServletException {
        super.init();
        this.outputSCDetectionCode = true;
        String parameterOutputSCDetectionCode = this.getInitParameter(OUTPUT_SC_DETECTION_CODE);
        if (parameterOutputSCDetectionCode != null) {
            this.outputSCDetectionCode = new Boolean(parameterOutputSCDetectionCode);
        }
    }
}

