/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions.internal;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.IsInteraction;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.internal.BaseAction;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.interactions.internal.Locatable;

public abstract class MouseAction
extends BaseAction
implements IsInteraction {
    protected final Mouse mouse;

    protected MouseAction(Mouse mouse, Locatable locationProvider) {
        super(locationProvider);
        this.mouse = mouse;
    }

    protected Coordinates getActionLocation() {
        if (this.where == null) {
            return null;
        }
        return this.where.getCoordinates();
    }

    protected void moveToLocation() {
        if (this.getActionLocation() != null) {
            this.mouse.mouseMove(this.getActionLocation());
        }
    }

    protected List<Interaction> moveToLocation(PointerInput mouse) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        Optional<WebElement> target = this.getTargetElement();
        interactions.add(mouse.createPointerMove(Duration.ofMillis(500L), target.map(PointerInput.Origin::fromElement).orElse(PointerInput.Origin.pointer()), 0, 0));
        return Collections.unmodifiableList(interactions);
    }

    public static enum Button {
        LEFT(0),
        MIDDLE(1),
        RIGHT(2);

        private final int button;

        private Button(int button) {
            this.button = button;
        }

        public int asArg() {
            return this.button;
        }
    }
}

