/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.log.Logger;
import com.isomorphic.openapi.SpecificationContextEditor;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RestRequestParser;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;

public class RESTHandler
extends BaseServlet {
    public static final String WRAP_JSON_RESPONSES = "wrapJSONResponses";
    public static final String JSON_PREFIX_PARAM_NAME = "jsonPrefix";
    public static final String JSON_SUFFIX_PARAM_NAME = "jsonSuffix";
    public static final String DEFAULT_DATA_FORMAT = "defaultDataFormat";
    public static final String DYNAMIC_DATA_FORMAT_PARAM_NAME = "dynamicDataFormatParamName";
    public static final String HYBRID_MODE = "hybridMode";
    private final Logger log = new Logger(((Object)((Object)this)).getClass().getCanonicalName());
    private Boolean wrapJSONResponses;
    private Boolean rawRestHybridMode;
    private String jsonPrefix;
    private String jsonSuffix;
    private String defaultDataFormat;
    private String dynamicDataFormatParamName;
    private Configuration freemarkerConfig = null;

    public void init() throws ServletException {
        super.init();
        this.wrapJSONResponses = Boolean.TRUE;
        String parameterWrapJSON = this.getInitParameter(WRAP_JSON_RESPONSES);
        if (parameterWrapJSON != null) {
            this.wrapJSONResponses = Boolean.valueOf(parameterWrapJSON);
        } else {
            parameterWrapJSON = this.getServletContext().getInitParameter(WRAP_JSON_RESPONSES);
            if (parameterWrapJSON != null) {
                this.wrapJSONResponses = Boolean.valueOf(parameterWrapJSON);
            }
        }
        this.log.debug("Wrapping json responses:" + this.wrapJSONResponses.toString());
        String parameterJSONPrefix = this.getInitParameter(JSON_PREFIX_PARAM_NAME);
        if (parameterJSONPrefix != null) {
            this.jsonPrefix = parameterJSONPrefix;
        } else {
            parameterJSONPrefix = this.getServletContext().getInitParameter(JSON_PREFIX_PARAM_NAME);
            if (parameterJSONPrefix != null) {
                this.jsonPrefix = parameterJSONPrefix;
            }
        }
        this.log.debug("json prefix:" + this.jsonPrefix);
        String parameterJSONSuffix = this.getInitParameter(JSON_SUFFIX_PARAM_NAME);
        if (parameterJSONSuffix != null) {
            this.jsonSuffix = parameterJSONSuffix;
        } else {
            parameterJSONSuffix = this.getServletContext().getInitParameter(JSON_SUFFIX_PARAM_NAME);
            if (parameterJSONSuffix != null) {
                this.jsonSuffix = parameterJSONSuffix;
            }
        }
        this.log.debug("json suffix:" + this.jsonSuffix);
        String parameterDefaultDataFormat = this.getInitParameter(DEFAULT_DATA_FORMAT);
        if (parameterDefaultDataFormat == null) {
            parameterDefaultDataFormat = this.getServletContext().getInitParameter(DEFAULT_DATA_FORMAT);
        }
        if (parameterDefaultDataFormat != null) {
            if ("xml".equalsIgnoreCase(parameterDefaultDataFormat) || "json".equalsIgnoreCase(parameterDefaultDataFormat)) {
                this.defaultDataFormat = parameterDefaultDataFormat.toLowerCase();
            } else {
                this.defaultDataFormat = "xml";
                this.log.warn("Specified incorrect 'defaultDataFormat':" + parameterDefaultDataFormat + ". Using default - xml");
            }
        }
        this.log.debug("Default response data format:" + this.defaultDataFormat);
        String dynamicDataFormatParamName = this.getInitParameter(DYNAMIC_DATA_FORMAT_PARAM_NAME);
        if (dynamicDataFormatParamName == null) {
            dynamicDataFormatParamName = this.getServletContext().getInitParameter(DYNAMIC_DATA_FORMAT_PARAM_NAME);
        }
        this.dynamicDataFormatParamName = dynamicDataFormatParamName != null ? dynamicDataFormatParamName : "isc_dataFormat";
        this.rawRestHybridMode = Boolean.FALSE;
        String hybridMode = this.getInitParameter(HYBRID_MODE);
        if (hybridMode != null) {
            this.rawRestHybridMode = Boolean.valueOf(hybridMode);
        } else {
            hybridMode = this.getServletContext().getInitParameter(HYBRID_MODE);
            if (hybridMode != null) {
                this.rawRestHybridMode = Boolean.valueOf(hybridMode);
            }
        }
        this.log.debug("Raw REST hybridMode default:" + this.rawRestHybridMode);
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_28);
        String userTemplates = this.getInitParameter("openapiTemplateDirectory");
        if (userTemplates == null) {
            userTemplates = "WEB-INF/openapi";
        }
        WebappTemplateLoader wtl = new WebappTemplateLoader(this.getServletContext(), userTemplates);
        ClassTemplateLoader ctl = new ClassTemplateLoader(((Object)((Object)this)).getClass(), "/com/isomorphic/openapi");
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{wtl, ctl});
        this.freemarkerConfig.setTemplateLoader((TemplateLoader)mtl);
        this.freemarkerConfig.setDefaultEncoding("UTF-8");
        this.freemarkerConfig.setLogTemplateExceptions(false);
        this.freemarkerConfig.setWrapUncheckedExceptions(true);
        this.freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().endsWith(".yaml")) {
            this.processDocumentationRequest(request, response);
        } else {
            this.processRequest(request, response);
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (RESTHandler.isRawREST(request)) {
            this.processRequest(request, response);
        } else {
            response.sendError(405);
        }
    }

    @Override
    public void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (RESTHandler.isRawREST(request)) {
            this.processRequest(request, response);
        } else {
            response.sendError(405);
        }
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (RESTHandler.isRawREST(request)) {
            this.processRequest(request, response);
        } else {
            response.sendError(405);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String defaultDataFormat;
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/json;charset=" + encoding);
        }
        if ((defaultDataFormat = this.defaultDataFormat) == null) {
            defaultDataFormat = RESTHandler.isRawREST(request) ? "json" : "xml";
            this.log.debug("Defaulting response data format to " + defaultDataFormat);
        }
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            RPCManager rpcManager;
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            try {
                RestRequestParser parser = new RestRequestParser(defaultDataFormat, this.dynamicDataFormatParamName);
                parser.setWrapJSONResponses(this.wrapJSONResponses);
                parser.setHybridModeDefault(this.rawRestHybridMode);
                parser.setJSONPrefix(this.jsonPrefix);
                parser.setJSONSuffix(this.jsonSuffix);
                rpcManager = new RPCManager((Servlet)this, request, response, parser);
                DSResponse errorResponse = parser.getErrorResponse();
                if (errorResponse != null) {
                    this.sendRawRestErrorResponse(rpcManager, errorResponse);
                    return;
                }
            }
            catch (ClientMustResubmitException cmre) {
                return;
            }
            this.processRestTransaction(rpcManager, context);
        }
        catch (Throwable e) {
            this.handleError(request, response, e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
        }
    }

    protected SpecificationContextEditor getSpecificationContextEditor() {
        return new SpecificationContextEditor();
    }

    private void processDocumentationRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            String spec = FilenameUtils.getBaseName((String)request.getRequestURI());
            LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
            URI servletUrl = URI.create(request.getRequestURL().toString()).resolve(request.getServletPath());
            context.put("servletUrl", servletUrl);
            StringWriter servers = new StringWriter();
            this.freemarkerConfig.getTemplate("_servers.ftl").process(context, (Writer)servers);
            StringWriter info = new StringWriter();
            this.freemarkerConfig.getTemplate("_info.yaml").dump((Writer)info);
            context.put("oasVersion", "3.0.2");
            context.put("infoFragment", info.toString());
            context.put("serversFragment", servers.toString());
            context.put(WRAP_JSON_RESPONSES, this.wrapJSONResponses);
            if (this.wrapJSONResponses.booleanValue()) {
                context.put(JSON_PREFIX_PARAM_NAME, this.jsonPrefix != null ? this.jsonPrefix : "<SCRIPT>//'\"]]>>isc_JSONResponseStart>>");
                context.put(JSON_SUFFIX_PARAM_NAME, this.jsonSuffix != null ? this.jsonSuffix : "//isc_JSONResponseEnd");
            }
            context.put(DYNAMIC_DATA_FORMAT_PARAM_NAME, this.dynamicDataFormatParamName);
            SpecificationContextEditor editor = this.getSpecificationContextEditor();
            if ("isomorphic".equals(spec)) {
                editor.editFrameworkContext(context);
            } else if ("openapi".equals(spec)) {
                context.put(DEFAULT_DATA_FORMAT, this.defaultDataFormat != null ? this.defaultDataFormat : "xml");
                editor.editOpenAPIContext(context);
                StringWriter tags = new StringWriter();
                this.freemarkerConfig.getTemplate("_tags.ftl").process(context, (Writer)tags);
                context.put("tagsFragment", "");
            } else {
                context.put(DEFAULT_DATA_FORMAT, this.defaultDataFormat != null ? this.defaultDataFormat : "json");
                context.put(HYBRID_MODE, this.rawRestHybridMode);
                editor.editDataSourceContext(spec, context);
            }
            String filename = spec;
            try {
                this.freemarkerConfig.getTemplate(spec + ".ftl");
            }
            catch (TemplateNotFoundException e) {
                filename = "datasource";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Template template = this.freemarkerConfig.getTemplate(filename + ".ftl");
            StringWriter writer = new StringWriter();
            template.process(context, (Writer)writer);
            String content = writer.toString();
            response.setContentType("text/yaml;charset=UTF-8");
            response.setContentLength(content.getBytes().length);
            response.getWriter().write(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processRestTransaction(RPCManager rpcManager, RequestContext context) throws Exception {
        this.log.info("Performing " + rpcManager.requestCount() + " operation(s)");
        for (BaseRequest requestObject : rpcManager.getRequests()) {
            if (!(requestObject instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)requestObject;
            if ("true".equals(context.request.getParameter("singularResponse"))) {
                dsRequest.setParameter("singularResponse", Boolean.TRUE);
            }
            try {
                rpcManager.send(dsRequest, this.handleDSRequest(dsRequest, rpcManager, context));
            }
            catch (Exception e) {
                this.log.forceError((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                rpcManager.sendFailure((Object)dsRequest, e);
            }
        }
    }

    public static Map getErrorReport(DSResponse dsResponse, StringWriter sw) {
        if (sw != null) {
            sw.write("<error>\n");
        }
        LinkedHashMap<String, Serializable> report = new LinkedHashMap<String, Serializable>();
        int status = dsResponse.getStatus();
        report.put("errorCode", Integer.valueOf(status));
        if (sw != null) {
            sw.write("<code>" + status + "</code>\n");
        }
        ArrayList<String> messages = new ArrayList<String>();
        Object data = dsResponse.getData();
        if (data instanceof JSONFilter) {
            data = ((JSONFilter)data).getObj();
        }
        if (data instanceof String) {
            messages.add((String)data);
        } else {
            Map errorMap = dsResponse.getDataMap();
            if (errorMap == null) {
                errorMap = dsResponse.getErrorReport();
            }
            if (errorMap != null) {
                for (String columnName : errorMap.keySet()) {
                    Object columnErrors = errorMap.get(columnName);
                    if (!(columnErrors instanceof List)) {
                        columnErrors = Arrays.asList(columnErrors);
                    }
                    for (Object columnError : (List)columnErrors) {
                        String message = columnError instanceof ErrorReport ? ((ErrorMessage)columnError).getErrorString() : columnError.toString();
                        messages.add(columnName + ": " + message);
                    }
                }
            }
        }
        report.put("errorMessages", messages);
        if (sw != null) {
            sw.write("<messages>\n");
            for (String message : messages) {
                sw.write("<message>" + message + "</message>\n");
            }
            sw.write("</messages>\n</error>\n");
        }
        return report;
    }

    public void handleError(HttpServletRequest request, HttpServletResponse response, Throwable t) {
        String hybridParam;
        if (RESTHandler.isRawREST(request) && !((hybridParam = request.getParameter(HYBRID_MODE)) != null ? Boolean.valueOf(hybridParam) : this.rawRestHybridMode).booleanValue()) {
            response.setStatus(500);
        }
        super.handleError(response, t);
    }

    private void sendRawRestErrorResponse(RPCManager rpc, DSResponse dsResponse) throws Exception {
        DSRequest dsRequest = rpc.getDSRequest();
        try {
            rpc.send(dsRequest, dsResponse);
        }
        catch (Exception e) {
            this.log.forceError((Object)"Error sending raw REST mode error response", e);
            rpc.sendFailure((Object)dsRequest, e);
        }
    }

    public DSResponse handleDSRequest(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            return dsRequest.execute();
        }
        catch (UpdateWithoutPKException updateWithoutPKException) {
            return this.generateFailureResponse(dsRequest, updateWithoutPKException, -9);
        }
        catch (SecurityException securityException) {
            return this.generateFailureResponse(dsRequest, securityException, -3);
        }
        catch (Exception exception) {
            return this.generateFailureResponse(dsRequest, exception, -1);
        }
    }

    private DSResponse generateFailureResponse(DSRequest dsRequest, Exception exception, int status) throws Exception {
        RequestContext.staticLog.warn((Object)"dsRequest.execute() failed: ", exception);
        DataSource dataSource = dsRequest.getDataSource();
        DSResponse dsResponse = new DSResponse(dataSource);
        dsResponse.setData(exception.getMessage());
        dsResponse.setStatus(status);
        return dsResponse;
    }

    public static String getExtraPath(HttpServletRequest request) {
        String extraPath = request.getPathInfo();
        return extraPath != null && extraPath.length() > 1 ? extraPath : null;
    }

    public static boolean isRawREST(HttpServletRequest request) {
        return RESTHandler.getExtraPath(request) != null;
    }
}

