/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.impl.AbstractQueryImpl;

public class QueryImpl
extends AbstractQueryImpl {
    private LockOptions lockOptions = new LockOptions();

    public QueryImpl(String queryString, FlushMode flushMode, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(queryString, flushMode, session, parameterMetadata);
    }

    public QueryImpl(String queryString, SessionImplementor session, ParameterMetadata parameterMetadata) {
        this(queryString, null, session, parameterMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate() throws HibernateException {
        Iterator iterator;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            iterator = this.getSession().iterate(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return iterator;
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        ScrollableResults scrollableResults;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        QueryParameters qp = this.getQueryParameters(namedParams);
        qp.setScrollMode(scrollMode);
        try {
            scrollableResults = this.getSession().scroll(this.expandParameterLists(namedParams), qp);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return scrollableResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() throws HibernateException {
        List list;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            list = this.getSession().list(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws HibernateException {
        int n;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            n = this.getSession().executeUpdate(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return n;
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        this.lockOptions.setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    public Query setLockOptions(LockOptions lockOption) {
        this.lockOptions.setLockMode(lockOption.getLockMode());
        this.lockOptions.setScope(lockOption.getScope());
        this.lockOptions.setTimeOut(lockOption.getTimeOut());
        return this;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }
}

