/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.base.Config;
import com.isomorphic.jpa.EMFProviderInterface;
import com.isomorphic.log.Logger;
import com.isomorphic.spring.SpringApplicationContextProvider;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class EMFProviderSpring
implements EMFProviderInterface {
    private static final String CLASS_NAME = EMFProviderSpring.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    protected EntityManagerFactory emf;
    protected JpaTransactionManager txm;

    public EMFProviderSpring() {
        this(Config.getGlobal().getString((Object)"jpa.entityManagerFactory", null), Config.getGlobal().getString((Object)"jpa.transaction", null));
    }

    public EMFProviderSpring(Properties config) {
        this(config.getProperty("entityManagerFactory"), config.getProperty("transaction"));
    }

    public EMFProviderSpring(String entityManagerFactory, String transaction) {
        ApplicationContext ac = SpringApplicationContextProvider.getInstance();
        if (ac == null) {
            throw new PersistenceException("Failed to acquire Spring Application Context.");
        }
        this.emf = (EntityManagerFactory)ac.getBean(entityManagerFactory, EntityManagerFactory.class);
        this.txm = (JpaTransactionManager)ac.getBean(transaction, JpaTransactionManager.class);
    }

    @Override
    public EntityManagerFactory get() {
        return this.emf;
    }

    @Override
    public EntityManager getEntityManager() throws PersistenceException {
        return this.emf.createEntityManager();
    }

    @Override
    public void returnEntityManager(EntityManager em) {
        if (em != null) {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (PersistenceException ex) {
                log.warn((Object)"Failed to close EntityManager.", (Throwable)ex);
            }
        }
    }

    @Override
    public Object getTransaction(EntityManager em) throws Exception {
        TransactionStatus tx = null;
        try {
            tx = this.txm.getTransaction(null);
            if (em != null) {
                em.joinTransaction();
            }
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to acquire transaction.", (Throwable)ex);
        }
        if (tx == null) {
            throw new PersistenceException("Unable to acquire transaction.");
        }
        return tx;
    }

    @Override
    public void commitTransaction(Object tx) throws Exception {
        if (tx != null) {
            this.txm.commit((TransactionStatus)tx);
        }
    }

    @Override
    public void rollbackTransaction(Object tx) {
        if (tx != null) {
            try {
                this.txm.rollback((TransactionStatus)tx);
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }
}

