/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.annotations.DataSourceAnnotations;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.RelationFieldInfo;
import com.isomorphic.datasource.TextMatchStyle;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.jpa.EMF;
import com.isomorphic.jpa.JPAConnectionHolder;
import com.isomorphic.jpa.JPADSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCManagerCompletionCallback;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.IdClass;
import javax.persistence.Query;
import org.apache.commons.collections.map.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPADataSource
extends BasicDataSource
implements RPCManagerCompletionCallback {
    private static final String CLASS_NAME = JPADataSource.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String BEAN_CLASS_PROPERTY = "beanClassName";
    public static final String AUTO_DERIVE_PROPERTY = "autoDeriveSchema";
    public static final String SCHEMA_BEAN_PROPERTY = "schemaBean";
    public static final String ID_CLASS_PROPERTY = "idClassName";
    public static final Character ESCAPE_CHARACTER = Character.valueOf('~');
    public static final String JPA_CONFIG_PROPERTY = "jpaConfig";
    private static long count = 0L;
    private static List<Map> createTrace;
    protected String configName;
    protected Class beanClass;
    protected String beanName;
    protected Map<String, String> fromBeans;
    protected Class idClass;
    protected boolean strictSQLFiltering = false;
    public static final String USE_QUALIFIED_CLASS_NAME_PROPERTY = "jpa.useQualifiedClassName";
    protected Boolean useQualifiedClassName = new Boolean(Config.getGlobal().getBoolean((Object)"jpa.useQualifiedClassName", Boolean.FALSE));
    protected EntityManager em;
    protected Object tx;
    protected boolean shouldRollBackTransaction;
    protected JPAConnectionHolder connectionHolder;
    protected Map<String, Object> extendedConfig;
    protected List<Map<String, Object>> extendedConfigFields;
    protected Map<String, DSField> additionalFields;
    protected List<DSResponse> relatedUpdates;
    protected Boolean generateRelatedUpdates;
    private static final List supportedAggregationFunctions;

    public static long getCreationCount() {
        return count;
    }

    public static void dumpCreateTrace(String dsName, String filename, boolean dumpStack, boolean dumpConfig) throws Exception {
        if (!config.getBoolean((Object)"datasources.jpa.trace.creation", false)) {
            return;
        }
        JPADataSource.dumpCreateTrace(createTrace, (String)dsName, (String)filename, (boolean)dumpStack, (boolean)dumpConfig);
    }

    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        Object idClassProperty;
        ++count;
        if (config.getBoolean((Object)"datasources.jpa.trace.creation", false)) {
            LinkedMap map = new LinkedMap();
            map.put("time", System.currentTimeMillis());
            map.put("ID", theConfig.get("ID"));
            map.put("config", theConfig);
            map.put("stack", new Exception().getStackTrace());
        }
        this.configName = (String)theConfig.get(JPA_CONFIG_PROPERTY);
        if (this.configName == null) {
            this.configName = "";
        }
        Object autoDerive = theConfig.get(AUTO_DERIVE_PROPERTY);
        Object schemaBean = theConfig.get(SCHEMA_BEAN_PROPERTY);
        if (autoDerive != null && autoDerive.toString().equalsIgnoreCase("true") || schemaBean != null) {
            String id = (String)theConfig.get("ID") + "_inheritsFrom";
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile((String)id);
            if (dsObject instanceof DataSource) {
                this.autoDeriveDS = (DataSource)dsObject;
            } else {
                Map<String, Object> schemaDSConfig;
                if (schemaBean != null && (schemaDSConfig = this.deriveDS(schemaBean.toString(), id, false)) != null) {
                    this.autoDeriveDS = DataSource.fromConfig(schemaDSConfig, null);
                    DataStructCache.addCachedObjectWithNoConfigFile((String)id, (Object)this.autoDeriveDS);
                }
                if (this.autoDeriveDS == null) {
                    throw new Exception("Unable to create autoDerive datasource for DataSource " + theConfig.get("ID") + ". 'schemaBean' did not refer to a valid mapped JPA bean");
                }
            }
            if (theConfig.get(BEAN_CLASS_PROPERTY) == null) {
                theConfig.put(BEAN_CLASS_PROPERTY, this.autoDeriveDS.getConfig().get(BEAN_CLASS_PROPERTY));
            }
            if (theConfig.get(ID_CLASS_PROPERTY) == null) {
                theConfig.put(ID_CLASS_PROPERTY, this.autoDeriveDS.getConfig().get(ID_CLASS_PROPERTY));
            }
        }
        this.beanClass = Reflection.classForName((String)((String)theConfig.get(BEAN_CLASS_PROPERTY)));
        this.extendedConfig = this.deriveDS(this.beanClass.getName(), (String)theConfig.get("ID"), true);
        this.extendedConfigFields = (List)this.extendedConfig.get("fields");
        if (this.extendedConfigFields == null) {
            this.extendedConfigFields = new ArrayList<Map<String, Object>>();
        }
        this.beanName = "_" + this.beanClass.getSimpleName();
        if ("_".equals(this.beanName)) {
            this.beanName = "_bean";
        }
        this.idClass = (idClassProperty = theConfig.get(ID_CLASS_PROPERTY)) != null ? Reflection.classForName((String)idClassProperty.toString()) : null;
        super.init(theConfig, dsRequest);
    }

    public String getConfigName() {
        return this.configName;
    }

    public Map<String, Object> deriveDS(String schemaBean, String id, boolean extended) {
        try {
            Map<String, Object> schemaDSConfig = JPADSGenerator.getDataSourceConfigFromJPAClass(schemaBean, extended);
            schemaDSConfig.put("__autoConstruct", "DataSource");
            schemaDSConfig.put("ID", id);
            return schemaDSConfig;
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to derive data source '" + id + "' for class " + schemaBean), (Throwable)ex);
            return null;
        }
    }

    public List getFieldNames(boolean dropIgnored) {
        ArrayList<String> fieldNames = new ArrayList<String>(super.getFieldNames(dropIgnored));
        if (this.additionalFields != null) {
            fieldNames.addAll(this.additionalFields.keySet());
        }
        return fieldNames;
    }

    public DSField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        DSField field = super.getField(fieldName);
        if (field == null && this.additionalFields != null) {
            field = this.additionalFields.get(fieldName);
        }
        return field;
    }

    public String getAliasedPropertyName(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        String beanPropertyName = field.getBeanPropertyName();
        if (beanPropertyName.indexOf(46) > 0) {
            String pathPart = beanPropertyName.substring(0, beanPropertyName.lastIndexOf(46));
            if (this.fromBeans.containsKey(this.beanName + "." + pathPart)) {
                return this.fromBeans.get(this.beanName + "." + pathPart) + beanPropertyName.substring(beanPropertyName.lastIndexOf(46));
            }
        }
        return this.beanName + "." + beanPropertyName;
    }

    protected boolean isFieldPersistent(String fieldName) {
        String xPath;
        if (fieldName == null) {
            return false;
        }
        for (Map<String, Object> field : this.extendedConfigFields) {
            if (!fieldName.equals(field.get("name"))) continue;
            return !Boolean.TRUE.equals(field.get("extIsFinal")) && !Boolean.TRUE.equals(field.get("extIsStatic")) && !Boolean.TRUE.equals(field.get("extIsTransient"));
        }
        if (this.relationFields.get(fieldName) != null) {
            return true;
        }
        DSField field = this.getField(fieldName);
        return field != null && (xPath = field.getValueXPath()) != null;
    }

    public DSResponse execute(DSRequest req) throws Exception {
        this.fromBeans = new HashMap<String, String>();
        this.shouldRollBackTransaction = false;
        this.connectionHolder = null;
        req.registerFreeResourcesHandler((FreeResourcesHandler)this);
        if (req.rpc != null) {
            if (!req.isFreeOnExecuteSet()) {
                req.setFreeOnExecute(false);
            }
            if (this.shouldAutoJoinTransaction(req)) {
                log.debug((Object)"Auto-joining transactions.");
                Object holder = this.getTransactionObject(req);
                if (holder == null) {
                    if (this.shouldAutoStartTransaction(req, false)) {
                        log.debug((Object)"Creating EntityManager, starting transaction and setting it to RPCManager.");
                        this.em = EMF.getEntityManager(this.configName);
                        this.tx = EMF.getTransaction(this.configName, this.em);
                        this.connectionHolder = new JPAConnectionHolder(this.em, this.tx);
                        req.rpc.setAttribute(this.getTransactionObjectKey(), (Object)this.connectionHolder);
                        if (!req.getFreeOnExecute()) {
                            req.rpc.registerCallback((RPCManagerCompletionCallback)this);
                        }
                        req.setPartOfTransaction(true);
                    } else {
                        log.debug((Object)"Creating EntityManager and starting transaction. Separate DB transaction for this request.");
                        this.em = EMF.getEntityManager(this.configName);
                        this.tx = EMF.getTransaction(this.configName, this.em);
                        if (!req.getFreeOnExecute()) {
                            req.rpc.registerCallback((RPCManagerCompletionCallback)this);
                        }
                        req.setPartOfTransaction(false);
                    }
                } else {
                    log.debug((Object)"Acquiring EntityManager and current transaction from RPCManager.");
                    if (!(holder instanceof JPAConnectionHolder)) {
                        throw new Exception("RPCManager does not hold instance of JPAConnectionHolder.");
                    }
                    this.connectionHolder = (JPAConnectionHolder)holder;
                    this.em = this.connectionHolder.getEntityManager();
                    this.tx = this.connectionHolder.getTransaction();
                    req.setPartOfTransaction(true);
                }
            } else {
                log.debug((Object)"Creating EntityManager and starting transaction.");
                this.em = EMF.getEntityManager(this.configName);
                this.tx = EMF.getTransaction(this.configName, this.em);
                if (!req.getFreeOnExecute()) {
                    req.rpc.registerCallback((RPCManagerCompletionCallback)this);
                }
                req.setPartOfTransaction(false);
            }
        } else {
            log.debug((Object)"Creating EntityManager and starting transaction.");
            this.em = EMF.getEntityManager(this.configName);
            this.tx = EMF.getTransaction(this.configName, this.em);
        }
        if (req != null && req.getIncludeFrom() != null && this.getName().equals(req.getDataSourceName())) {
            for (IncludeFromDefinition incFrom : req.getIncludeFrom()) {
                if (!incFrom.isDynamic() || this.getField(incFrom.getThisFieldName()) != null) continue;
                if (this.additionalFields == null) {
                    this.additionalFields = new HashMap<String, DSField>();
                }
                this.additionalFields.put(incFrom.getThisFieldName(), incFrom.getThisField());
            }
        }
        this.generateRelatedUpdates = req.getGenerateRelatedUpdates();
        DSResponse resp = null;
        try {
            resp = super.execute(req);
            if (req.rpc == null || req.getFreeOnExecute()) {
                if (this.shouldRollBackTransaction) {
                    this.onFailure(false);
                } else {
                    this.onSuccess();
                }
            }
            return resp;
        }
        catch (Exception ex) {
            this.markTransactionForRollBack(resp);
            if (req.rpc == null || req.getFreeOnExecute()) {
                this.onFailure(resp != null);
            }
            log.debug((Object)"Got exception while executing. Transaction will be rolled back.", (Throwable)ex);
            throw ex;
        }
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        log.debug((Object)"Executing fetch.");
        DSResponse dsResponse = new DSResponse((DataSource)this);
        dsResponse.setSuccess();
        Query[] queries = this.createQuery(req);
        Query q = queries[0];
        Query qCount = queries[1];
        long totalRows = -1L;
        if (req.isPaged()) {
            if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                req.setBatchSize(req.getEndRow() - req.getStartRow());
            }
            if (qCount != null) {
                Long rowCount = Long.parseLong(qCount.getSingleResult().toString());
                totalRows = rowCount == null ? 0L : rowCount;
                q.setFirstResult((int)req.getStartRow());
                q.setMaxResults((int)req.getBatchSize());
            }
        }
        List results = null;
        if (totalRows == 0L) {
            results = new ArrayList();
        } else {
            results = q.getResultList();
            if (results != null && !results.isEmpty()) {
                List outputs = null;
                outputs = req.isGroupBy() ? req.getGroupByFields() : this.computeOutputColumns(req);
                if (outputs != null) {
                    results = this.transformQueryResult(results, outputs);
                } else if (results.get(0).getClass().isArray()) {
                    ArrayList<Object> resultObjects;
                    if (req.getGroupFunctionFields() == null) {
                        resultObjects = new ArrayList<Object>();
                        for (Object singleResult : results) {
                            resultObjects.add(((Object[])singleResult)[0]);
                        }
                        results = resultObjects;
                    } else {
                        resultObjects = new ArrayList();
                        ArrayList<Object> beanList = new ArrayList<Object>();
                        for (Object[] singleResult : results) {
                            beanList.add(singleResult[0]);
                            Map record = this.getProperties(singleResult[0], null, true, true, null, null, req.getGroupFunctionFields());
                            int counter = 1;
                            for (int i = req.getGroupFunctionFields().size() - 1; i >= 0; --i) {
                                record.put(req.getGroupFunctionFields().get(i), singleResult[singleResult.length - counter]);
                                ++counter;
                            }
                            resultObjects.add(record);
                        }
                        results = resultObjects;
                        dsResponse.setBeanList(beanList);
                    }
                }
                if (qCount == null && req.isPaged()) {
                    int start = (int)req.getStartRow();
                    int end = Math.min(results.size() + 1, (int)req.getStartRow() + (int)req.getBatchSize()) - 1;
                    results = DataTools.arrayToList((Object[])results.toArray(), (int)start, (int)end);
                }
            }
        }
        if (totalRows == -1L) {
            totalRows = results.size();
        }
        dsResponse.setTotalRows(totalRows);
        long startRow = 0L;
        long endRow = 0L;
        if (totalRows != 0L) {
            startRow = req.getStartRow();
            endRow = startRow + (long)results.size();
        }
        dsResponse.setStartRow(startRow);
        dsResponse.setEndRow(endRow);
        dsResponse.setData(results);
        return dsResponse;
    }

    private List transformQueryResult(List results, List fields) {
        ArrayList resultObjects = new ArrayList();
        for (Object singleResult : results) {
            HashMap record = new HashMap();
            if (singleResult != null && singleResult.getClass().isArray()) {
                Object[] arrayResult = (Object[])singleResult;
                for (int y = 0; y < arrayResult.length; ++y) {
                    record.put(fields.get(y), arrayResult[y]);
                }
            } else {
                record.put(fields.get(0), singleResult);
            }
            resultObjects.add(record);
        }
        return resultObjects;
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        log.debug((Object)"Executing add.");
        List keysMissing = req.getMissingPrimaryKeysForAdd();
        if (keysMissing.size() > 0) {
            throw new UpdateWithoutPKException("Criteria received from the client for add operation is missing the following non-sequence primary key fields: " + keysMissing.toString() + ". Either provide all primary " + "key fields that are not sequences, or set " + "allowMultiUpdate on the OperationBinding");
        }
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        Object record = this.beanClass.newInstance();
        this.relatedUpdates = new ArrayList<DSResponse>();
        this.setProperties(req.getValues(), record);
        this.em.persist(record);
        dsResponse.setData(record);
        if (this.generateRelatedUpdates == null || Boolean.TRUE.equals(this.generateRelatedUpdates)) {
            for (DSResponse relatedUpdate : this.relatedUpdates) {
                dsResponse.addRelatedUpdate(relatedUpdate);
            }
        }
        this.increaseOpCount();
        return dsResponse;
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        log.debug((Object)"Executing remove.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        Map returnCriteria = req.getCriteria();
        ArrayList<DSResponse> relatedObjects = new ArrayList<DSResponse>();
        if (req.getAllowMultiUpdate()) {
            Query q = this.createQuery(req)[0];
            List results = q.getResultList();
            for (Object record : results) {
                HashMap relationProperties = Boolean.TRUE.equals(this.generateRelatedUpdates) ? new HashMap(DataTools.getProperties(record, this.relationFields.keySet())) : new HashMap();
                for (String relationFieldName : this.relationFields.keySet()) {
                    DSResponse relatedUpdate;
                    Object relatedObject = relationProperties.get(relationFieldName);
                    if (relatedObject == null) continue;
                    RelationFieldInfo relationFieldInfo = (RelationFieldInfo)this.relationFields.get(relationFieldName);
                    DataSource relatedDS = DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                    if (relatedObject instanceof Map) {
                        for (Object o : ((Map)relatedObject).values()) {
                            relatedUpdate = new DSResponse(relatedDS, o, DSResponse.STATUS_SUCCESS);
                            relatedUpdate.setOperationType("update");
                            relatedObjects.add(relatedUpdate);
                        }
                        continue;
                    }
                    if (relatedObject instanceof Collection) {
                        for (Object o : (Collection)relatedObject) {
                            relatedUpdate = new DSResponse(relatedDS, o, DSResponse.STATUS_SUCCESS);
                            relatedUpdate.setOperationType("update");
                            relatedObjects.add(relatedUpdate);
                        }
                        continue;
                    }
                    DSResponse relatedUpdate2 = new DSResponse(relatedDS, relatedObject, DSResponse.STATUS_SUCCESS);
                    relatedUpdate2.setOperationType("update");
                    relatedObjects.add(relatedUpdate2);
                }
                this.em.remove(record);
            }
            dsResponse.setInvalidateCache(true);
        } else {
            Serializable id = this.createPrimaryKey(req);
            Object record = this.em.find(this.beanClass, (Object)id);
            if (record != null) {
                HashMap relationProperties = Boolean.TRUE.equals(this.generateRelatedUpdates) ? new HashMap(DataTools.getProperties((Object)record, this.relationFields.keySet())) : new HashMap();
                for (String relationFieldName : this.relationFields.keySet()) {
                    DSResponse relatedUpdate;
                    Object relatedObject = relationProperties.get(relationFieldName);
                    if (relatedObject == null) continue;
                    RelationFieldInfo relationFieldInfo = (RelationFieldInfo)this.relationFields.get(relationFieldName);
                    DataSource relatedDS = DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                    if (relatedObject instanceof Map) {
                        for (Object o : ((Map)relatedObject).values()) {
                            relatedUpdate = new DSResponse(relatedDS, o, DSResponse.STATUS_SUCCESS);
                            relatedUpdate.setOperationType("update");
                            relatedObjects.add(relatedUpdate);
                        }
                        continue;
                    }
                    if (relatedObject instanceof Collection) {
                        for (Object o : (Collection)relatedObject) {
                            relatedUpdate = new DSResponse(relatedDS, o, DSResponse.STATUS_SUCCESS);
                            relatedUpdate.setOperationType("update");
                            relatedObjects.add(relatedUpdate);
                        }
                        continue;
                    }
                    DSResponse relatedUpdate3 = new DSResponse(relatedDS, relatedObject, DSResponse.STATUS_SUCCESS);
                    relatedUpdate3.setOperationType("update");
                    relatedObjects.add(relatedUpdate3);
                }
                this.em.remove(record);
            } else {
                log.warn((Object)("Did not remove. Record not found for PK=" + id));
            }
            boolean flushed = false;
            for (DSResponse relatedUpdate : relatedObjects) {
                if (!flushed) {
                    this.em.flush();
                    flushed = true;
                }
                Object o = relatedUpdate.getData();
                try {
                    this.em.refresh(o);
                }
                catch (Exception ex) {
                    relatedUpdate.setData((Object)relatedUpdate.getDataSource().getProperties(o, (Collection)relatedUpdate.getDataSource().getPrimaryKeys()));
                    relatedUpdate.setOperationType("remove");
                }
                dsResponse.addRelatedUpdate(relatedUpdate);
            }
            dsResponse.setData((Object)returnCriteria);
            dsResponse.setBypassDataFilter(Boolean.TRUE);
        }
        this.increaseOpCount();
        return dsResponse;
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        log.debug((Object)"Executing update.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        if (req.getValues() == null) {
            log.warn((Object)"DSRequest with no values passed to executeUpdate(), no records modified.");
            dsResponse.setData(null);
        } else {
            this.relatedUpdates = new ArrayList<DSResponse>();
            if (req.getAllowMultiUpdate()) {
                Query q = this.createQuery(req)[0];
                List results = q.getResultList();
                for (Object record : results) {
                    this.setProperties(req.getValues(), record);
                }
                dsResponse.setData((Object)results);
            } else {
                Serializable id = this.createPrimaryKey(req);
                Object record = this.em.find(this.beanClass, (Object)id);
                if (record != null) {
                    this.setProperties(req.getValues(), record);
                } else {
                    log.warn((Object)("Did not update. Record not found for PK=" + id));
                }
                dsResponse.setData(record);
            }
            if (this.generateRelatedUpdates == null || Boolean.TRUE.equals(this.generateRelatedUpdates)) {
                boolean flushed = false;
                for (DSResponse relatedUpdate : this.relatedUpdates) {
                    if ("remove".equals(relatedUpdate.getOperationType())) {
                        if (!flushed) {
                            this.em.flush();
                            flushed = true;
                        }
                        try {
                            this.em.refresh(relatedUpdate.getData());
                            relatedUpdate.setOperationType("update");
                        }
                        catch (Exception ex) {
                            relatedUpdate.setData((Object)relatedUpdate.getDataSource().getProperties(relatedUpdate.getData(), (Collection)relatedUpdate.getDataSource().getPrimaryKeys()));
                        }
                    }
                    dsResponse.addRelatedUpdate(relatedUpdate);
                }
            }
        }
        this.increaseOpCount();
        return dsResponse;
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        String fieldName = req.getDownloadFieldName();
        Map criteria = req.getCriteria();
        this.downloadDsRequest = new DSRequest(this.getName(), "fetch");
        this.downloadDsRequest.setRPCManager(req.getRPCManager());
        this.downloadDsRequest.setCriteria((Object)criteria);
        this.downloadDsRequest.setFreeOnExecute(req.getFreeOnExecute());
        DSResponse resp = this.downloadDsRequest.execute();
        req.setFreeOnExecute(this.downloadDsRequest.getFreeOnExecute());
        if (resp.getData() instanceof List) {
            resp.setData(this.forceSingleObject(resp.getDataList()));
        }
        return resp;
    }

    private Serializable createPrimaryKey(DSRequest req) throws Exception {
        String primaryKeyFieldName = this.getPrimaryKey();
        if (primaryKeyFieldName != null) {
            Serializable id = null;
            if (this.idClass != null) {
                boolean isIdClass;
                id = (Serializable)this.idClass.newInstance();
                Map values = req.getCriteria();
                boolean bl = isIdClass = DataSourceAnnotations.hasAnnotation((Object)this.beanClass, (Class[])new Class[]{IdClass.class}) || !config.getBoolean((Object)"extIsEmbeddedId", true);
                if (isIdClass) {
                    DataTools.setProperties((Map)req.getValues(), (Object)id);
                } else {
                    HashMap idValues = new HashMap();
                    for (Object primaryKeyPart : this.getPrimaryKeys()) {
                        DSField primaryKeyPartField = this.getField(primaryKeyPart.toString());
                        String beanPropertyName = primaryKeyPartField.getBeanPropertyName();
                        if (beanPropertyName.contains(".")) {
                            beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                        }
                        Object valuePart = values.get(primaryKeyPart);
                        valuePart = DataTools.castValue(valuePart, (Class)DataTools.getPropertyType((Class)this.idClass, (String)beanPropertyName));
                        idValues.put(beanPropertyName, valuePart);
                    }
                    DataTools.setProperties(idValues, (Object)id);
                }
            } else {
                String primaryKeyPropertyName = this.getField(primaryKeyFieldName).getBeanPropertyName();
                id = (Serializable)DataTools.castValue((Object)req.getFieldValue((Object)primaryKeyFieldName), (Class)DataTools.getPropertyType((Class)this.beanClass, (String)primaryKeyPropertyName));
            }
            return id;
        }
        return null;
    }

    private Query[] createQuery(DSRequest req) throws Exception {
        String aliasedPropertyName;
        String selectPart = "";
        String fromPart = "";
        String wherePart = "";
        String groupByPart = "";
        String orderByPart = "";
        if (req.isGroupBy()) {
            int beanNameCounter = 1;
            for (String fieldName : req.getGroupByFields()) {
                Map fieldFunctionsMap;
                DSField field = this.getField(fieldName);
                if (field == null) {
                    log.warn((Object)("Field name: '" + fieldName + "' specified in group-by or field-functions is not defined in data source. Skipping."));
                    continue;
                }
                if (!this.isFieldPersistent(field.getName())) continue;
                String beanPropertyName = field.getBeanPropertyName();
                String fromBean = this.beanName;
                String fromBeanFull = this.beanName;
                if (beanPropertyName.indexOf(46) > 0) {
                    while (beanPropertyName.indexOf(46) > 0) {
                        String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                        fromBeanFull = fromBeanFull + "." + pathPart;
                        fromBean = fromBean + "." + pathPart;
                        if (!this.fromBeans.containsKey(fromBeanFull)) {
                            pathPart = pathPart + beanNameCounter++;
                            this.fromBeans.put(fromBeanFull, pathPart);
                            fromPart = fromPart + " left outer join " + fromBean + " " + pathPart;
                            fromBean = pathPart;
                        } else {
                            fromBean = this.fromBeans.get(fromBeanFull);
                        }
                        beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                    }
                }
                if ((fieldFunctionsMap = req.getFieldFunctions()) != null && fieldFunctionsMap.containsKey(fieldName)) {
                    String functionName = (String)fieldFunctionsMap.get(fieldName);
                    String function = functionName + "(" + fromBean + "." + beanPropertyName + ") as " + fieldName;
                    selectPart = selectPart + ("".equals(selectPart) ? function : ", " + function);
                    continue;
                }
                String s = fromBean + "." + beanPropertyName;
                groupByPart = groupByPart + ("".equals(groupByPart) ? s : ", " + s);
                s = s + " as " + fieldName;
                selectPart = selectPart + ("".equals(selectPart) ? s : ", " + s);
            }
        } else {
            String selectFullBeans = this.beanName;
            List outputs = this.computeOutputColumns(req);
            HashMap<String, String> subSelects = null;
            int beanNameCounter = 1;
            for (Object fieldObject : this.getFields()) {
                DSField field = (DSField)fieldObject;
                boolean fieldRequested = outputs != null && outputs.contains(field.getName());
                String beanPropertyName = field.getBeanPropertyName();
                String fromBeanFull = this.beanName;
                String fromBean = this.beanName;
                if ((fieldRequested || outputs == null) && beanPropertyName.indexOf(46) > 0) {
                    if (field.getProperty("groupFunction") != null) {
                        String functionName = field.getProperty("groupFunction");
                        if ("FIRST".equals(functionName.toUpperCase())) {
                            functionName = "MIN";
                        }
                        if (this.supportsGroupFunction(functionName)) {
                            String subFromBean = null;
                            String subFromPart = null;
                            while (beanPropertyName.indexOf(46) > 0) {
                                String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                                subFromBean = subFromBean == null ? this.beanName + "." + pathPart : subFromBean + "." + pathPart;
                                pathPart = pathPart + beanNameCounter++;
                                subFromPart = subFromPart == null ? subFromBean + " " + pathPart : subFromPart + " left outer join " + subFromBean + " " + pathPart;
                                subFromBean = pathPart;
                                beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                            }
                            if (subSelects == null) {
                                subSelects = new HashMap<String, String>();
                            }
                            subSelects.put(field.getName(), "(select " + functionName + "(" + subFromBean + "." + beanPropertyName + ") from " + subFromPart + ") as " + field.getName());
                        } else {
                            log.warn((Object)("Function name: '" + functionName + "' specified in groupFunction attribute for field '" + this.getName() + "." + field.getName() + "' is not supported by this type of data source. Skipping."));
                        }
                    }
                    if (!(subSelects != null && subSelects.containsKey(field.getName()) || field.get((Object)"useJoin") != null && !field.getBoolean("useJoin"))) {
                        if (!this.isFieldPersistent(field.getName())) continue;
                        while (beanPropertyName.indexOf(46) > 0) {
                            String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                            fromBeanFull = fromBeanFull + "." + pathPart;
                            fromBean = fromBean + "." + pathPart;
                            if (!this.fromBeans.containsKey(fromBeanFull)) {
                                pathPart = pathPart + beanNameCounter++;
                                this.fromBeans.put(fromBeanFull, pathPart);
                                selectFullBeans = selectFullBeans + ", " + pathPart;
                                fromPart = fromPart + " left outer join " + fromBean + " " + pathPart;
                                fromBean = pathPart;
                            } else {
                                fromBean = this.fromBeans.get(fromBeanFull);
                            }
                            beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                        }
                    }
                }
                if (!fieldRequested) continue;
                String s = null;
                s = subSelects != null && subSelects.containsKey(field.getName()) ? (String)subSelects.get(field.getName()) : fromBean + "." + beanPropertyName + " as " + field.getName();
                selectPart = selectPart + ("".equals(selectPart) ? s : ", " + s);
            }
            if ("".equals(selectPart)) {
                selectPart = selectPart + selectFullBeans;
                if (subSelects != null) {
                    for (String fieldName : subSelects.keySet()) {
                        selectPart = selectPart + ", " + (String)subSelects.get(fieldName);
                    }
                    req.setGroupFunctionFields(new ArrayList(subSelects.keySet()));
                }
            }
        }
        int parameterCounter = 0;
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<Class> beanParametersTypes = new ArrayList<Class>();
        Map criteria = req.getCriteria();
        if (criteria != null) {
            if (this.isAdvancedCriteria(criteria)) {
                CriteriaPart criteriaPart;
                this.strictSQLFiltering = false;
                Object strictMode = criteria.get("strictSQLFiltering");
                if (strictMode == null) {
                    strictMode = this.getProperty("strictSQLFiltering");
                }
                if (strictMode != null) {
                    this.strictSQLFiltering = (Boolean)DataTools.castValue(strictMode, Boolean.class);
                }
                if ((criteriaPart = this.parseAdvancedCriteria(criteria, 0, req.getFieldFunctions())) != null) {
                    wherePart = criteriaPart.wherePart;
                    parameterNames.addAll(criteriaPart.parameterNames);
                    parameters.addAll(criteriaPart.parameters);
                    beanParametersTypes.addAll(criteriaPart.beanParameterTypes);
                }
            } else {
                for (String fieldName : criteria.keySet()) {
                    Object typedParameterValue;
                    DSField field = this.getField(fieldName);
                    if (field == null) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is not defined in data source. Skipping."));
                        continue;
                    }
                    if (req.getFieldFunctions() != null && req.getFieldFunctions().containsKey(fieldName)) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is defined in fieldFunctions map," + " applying criteria to aggregated fields is not supported. Skipping."));
                        continue;
                    }
                    if (!this.isFieldPersistent(field.getName())) {
                        log.warn((Object)("Field name: '" + field.getName() + "' specified in criteria is non-persistent. Skipping."));
                        continue;
                    }
                    RelationFieldInfo relationFieldInfo = (RelationFieldInfo)this.relationFields.get(fieldName);
                    aliasedPropertyName = this.getAliasedPropertyName(fieldName);
                    String propertyName = field.getBeanPropertyName();
                    Object value = criteria.get(fieldName);
                    Class propertyType = DataTools.getPropertyType((Class)this.beanClass, (String)propertyName);
                    if (value == null) {
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                            wherePart = wherePart + aliasedPropertyName + " is empty";
                            continue;
                        }
                        wherePart = wherePart + aliasedPropertyName + " is null";
                        continue;
                    }
                    if (value instanceof Iterable) {
                        Iterable valueList = (Iterable)value;
                        boolean hasNulls = false;
                        JPADataSource relatedDS = null;
                        DSField relatedField = null;
                        String relatedpropertyName = null;
                        Class relatedPropertyType = null;
                        if (relationFieldInfo != null) {
                            relatedDS = (JPADataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                            relatedField = relatedDS.getField(relationFieldInfo.getRelatedFieldName());
                            relatedpropertyName = relatedField.getBeanPropertyName();
                            relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                        }
                        String wherePartList = "";
                        for (Object singleValue : valueList) {
                            Object typedParameterValue2 = null;
                            if (relationFieldInfo != null) {
                                if (singleValue == null) {
                                    hasNulls = true;
                                    continue;
                                }
                                if (relationFieldInfo.isObjectEncapsulated()) {
                                    typedParameterValue2 = relatedDS.beanClass.newInstance();
                                    DataTools.setProperties((Map)((Map)singleValue), (Object)typedParameterValue2);
                                    beanParametersTypes.add(relatedDS.beanClass);
                                } else {
                                    try {
                                        typedParameterValue2 = DataTools.castValue(singleValue, (Class)relatedPropertyType, (DataSource)this);
                                        beanParametersTypes.add(relatedPropertyType);
                                    }
                                    catch (Exception ex) {
                                        log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                                        continue;
                                    }
                                }
                                if (!"".equals(wherePartList)) {
                                    wherePartList = wherePartList + ", ";
                                }
                                wherePartList = wherePartList + ":p" + parameterCounter;
                                parameterNames.add("p" + parameterCounter++);
                                parameters.add(typedParameterValue2);
                                continue;
                            }
                            try {
                                typedParameterValue2 = DataTools.castValue(singleValue, (Class)propertyType, (DataSource)this);
                                if (typedParameterValue2 == null) {
                                    hasNulls = true;
                                    continue;
                                }
                                if (!"".equals(wherePartList)) {
                                    wherePartList = wherePartList + " or ";
                                }
                                wherePartList = wherePartList + aliasedPropertyName + " = :p" + parameterCounter;
                                parameterNames.add("p" + parameterCounter++);
                                parameters.add(typedParameterValue2);
                                beanParametersTypes.add(propertyType);
                            }
                            catch (Exception ex) {
                                log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            }
                        }
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        if (!"".equals(wherePartList)) {
                            if (hasNulls) {
                                if (relationFieldInfo != null) {
                                    if (relationFieldInfo.isObjectEncapsulated()) {
                                        wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + wherePartList + ")) or " + aliasedPropertyName + " is empty)";
                                        continue;
                                    }
                                    wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + wherePartList + ")) or " + aliasedPropertyName + " is empty)";
                                    continue;
                                }
                                wherePart = wherePart + "(" + wherePartList + " or " + aliasedPropertyName + " is null)";
                                continue;
                            }
                            if (relationFieldInfo != null) {
                                if (relationFieldInfo.isObjectEncapsulated()) {
                                    wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + wherePartList + ")) and " + aliasedPropertyName + " is not empty)";
                                    continue;
                                }
                                wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + wherePartList + ")) and " + aliasedPropertyName + " is not empty)";
                                continue;
                            }
                            wherePart = wherePart + "((" + wherePartList + ") and " + aliasedPropertyName + " is not null)";
                            continue;
                        }
                        if (hasNulls) {
                            if (relationFieldInfo != null) {
                                wherePart = wherePart + "(" + aliasedPropertyName + " is empty)";
                                continue;
                            }
                            wherePart = wherePart + "(" + aliasedPropertyName + " is null)";
                            continue;
                        }
                        if (relationFieldInfo != null) {
                            wherePart = wherePart + "(" + aliasedPropertyName + " is empty)";
                            continue;
                        }
                        wherePart = wherePart + "1=2";
                        continue;
                    }
                    if (DataTools.isTextType((Class)propertyType) && relationFieldInfo == null) {
                        if (TextMatchStyle.SUBSTRING.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(" + aliasedPropertyName + ") like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(propertyType);
                            continue;
                        }
                        if (TextMatchStyle.STARTS_WITH.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(" + aliasedPropertyName + ") like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(propertyType);
                            continue;
                        }
                        typedParameterValue = null;
                        try {
                            typedParameterValue = DataTools.castValue(value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            continue;
                        }
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        wherePart = wherePart + "(lower(" + aliasedPropertyName + ") = lower(:p" + parameterCounter + "))";
                        parameterNames.add("p" + parameterCounter++);
                        parameters.add(typedParameterValue);
                        beanParametersTypes.add(propertyType);
                        continue;
                    }
                    if (DataTools.isNumberType((Class)propertyType) && relationFieldInfo == null) {
                        if (TextMatchStyle.SUBSTRING.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(concat(" + aliasedPropertyName + ",''))" + " like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(String.class);
                            continue;
                        }
                        if (TextMatchStyle.STARTS_WITH.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(concat(" + aliasedPropertyName + ",''))" + " like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(String.class);
                            continue;
                        }
                        typedParameterValue = null;
                        try {
                            typedParameterValue = DataTools.castValue(value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            continue;
                        }
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        wherePart = wherePart + aliasedPropertyName + " = :p" + parameterCounter;
                        parameterNames.add("p" + parameterCounter++);
                        parameters.add(typedParameterValue);
                        beanParametersTypes.add(propertyType);
                        continue;
                    }
                    typedParameterValue = null;
                    if (relationFieldInfo != null && relationFieldInfo.isObjectEncapsulated()) {
                        JPADataSource relatedDS = (JPADataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                        typedParameterValue = relatedDS.beanClass.newInstance();
                        DataTools.setProperties((Map)((Map)value), (Object)typedParameterValue);
                    } else {
                        try {
                            typedParameterValue = DataTools.castValue(value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            continue;
                        }
                    }
                    if (!"".equals(wherePart)) {
                        wherePart = wherePart + " and ";
                    }
                    wherePart = wherePart + aliasedPropertyName + " = :p" + parameterCounter;
                    parameterNames.add("p" + parameterCounter++);
                    parameters.add(typedParameterValue);
                    beanParametersTypes.add(propertyType);
                }
            }
        }
        List sortBy = req.getSortByFields();
        for (String fieldName : sortBy) {
            DSField field = this.getField(fieldName.startsWith("-") ? fieldName.substring(1) : fieldName);
            if (field == null) {
                log.warn((Object)("Field name: '" + fieldName + "' specified in sort-by is not defined in data source. Skipping."));
                continue;
            }
            aliasedPropertyName = this.getAliasedPropertyName(field.getName());
            if (!"".equals(orderByPart)) {
                orderByPart = orderByPart + ", ";
            }
            if (fieldName.startsWith("-")) {
                orderByPart = orderByPart + aliasedPropertyName + " desc";
                continue;
            }
            orderByPart = orderByPart + aliasedPropertyName;
        }
        String qStr = "select " + selectPart + " from " + (this.useQualifiedClassName != false ? this.beanClass.getName() : this.beanClass.getSimpleName()) + " " + this.beanName + " " + fromPart;
        String qCountStr = "select count(" + this.beanName + ") from ";
        qCountStr = qCountStr + (this.useQualifiedClassName != false ? this.beanClass.getName() : this.beanClass.getSimpleName()) + " " + this.beanName + " " + fromPart;
        if (!"".equals(wherePart)) {
            qStr = qStr + " where " + wherePart;
            qCountStr = qCountStr + " where " + wherePart;
        }
        if (!"".equals(groupByPart)) {
            qStr = qStr + " group by " + groupByPart;
        }
        if (!"".equals(orderByPart)) {
            qStr = qStr + " order by " + orderByPart;
        }
        log.debug((Object)("Query string: " + qStr));
        Query q = this.em.createQuery(qStr);
        Query qCount = req.isGroupBy() ? null : this.em.createQuery(qCountStr);
        for (int i = 0; i < parameters.size(); ++i) {
            String parameterName = (String)parameterNames.get(i);
            Object parameterValue = parameters.get(i);
            Class beanParameterType = (Class)beanParametersTypes.get(i);
            Object typedParameterValue = DataTools.castValue(parameterValue, (Class)beanParameterType, (DataSource)this);
            q.setParameter(parameterName, typedParameterValue);
            if (qCount != null) {
                qCount.setParameter(parameterName, typedParameterValue);
            }
            log.debug((Object)("Parameter " + parameterName + ": " + typedParameterValue));
        }
        Query[] ret = new Query[]{q, qCount};
        return ret;
    }

    public boolean supportsGroupFunction(String functionName) {
        if (functionName == null) {
            return false;
        }
        return supportedAggregationFunctions.contains(functionName.toUpperCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CriteriaPart parseAdvancedCriteria(Map<String, Object> criteria, int nextParameterNumber, Map fieldFunctionsMap) throws Exception {
        Iterator i$;
        int realValueListSize;
        boolean hasNulls;
        Class propertyType;
        String aliasedPropertyName;
        Class relatedPropertyType;
        String relatedpropertyName;
        JPADataSource relatedDS;
        RelationFieldInfo relationFieldInfo;
        String fieldName;
        String op;
        CriteriaPart criteriaPart;
        block347: {
            Iterator<Object> i$2;
            ArrayList<CriteriaPart> restrictions;
            block351: {
                Iterator<Object> i$3;
                ArrayList<CriteriaPart> restrictions2;
                block349: {
                    boolean negate;
                    Object operator;
                    block350: {
                        Object subCriteria;
                        block348: {
                            operator = criteria.get("operator");
                            if (operator == null) {
                                log.warn((Object)"Found criterion with a null operator. Skipping.");
                                return null;
                            }
                            criteriaPart = new CriteriaPart();
                            criteriaPart.nextParameterNumber = nextParameterNumber;
                            op = operator.toString();
                            fieldName = null;
                            try {
                                fieldName = criteria.get("fieldName").toString();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            subCriteria = criteria.get("criteria");
                            if ("not".equalsIgnoreCase(op)) {
                                if (subCriteria == null) {
                                    log.warn((Object)("Found criterion '" + op + "' with no defined sub-criteria. Skipping."));
                                    return null;
                                }
                                if (!(subCriteria instanceof Iterable)) {
                                    log.warn((Object)("Found criterion '" + op + "' with sub-criteria that is not instance of Iterable." + "\nReturning predicate '1=2' (always false)."));
                                    criteriaPart.wherePart = "1=2";
                                    return criteriaPart;
                                }
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "or");
                                criteriaPart = this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                                if (criteriaPart == null) return criteriaPart;
                                criteriaPart.wherePart = "not (" + criteriaPart.wherePart + ")";
                                return criteriaPart;
                            }
                            if (!"or".equalsIgnoreCase(op)) break block348;
                            if (subCriteria == null) {
                                log.warn((Object)("Found criterion '" + op + "' with no defined sub-criteria. Skipping."));
                                return null;
                            }
                            if (!(subCriteria instanceof Iterable)) {
                                log.warn((Object)("Found criterion '" + op + "' with sub-criteria that is not instance of Iterable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            restrictions2 = new ArrayList<CriteriaPart>();
                            i$3 = ((Iterable)subCriteria).iterator();
                            break block349;
                        }
                        if (!"and".equalsIgnoreCase(op)) break block350;
                        if (subCriteria == null) {
                            log.warn((Object)("Found criterion '" + op + "' with no defined sub-criteria. Skipping."));
                            return null;
                        }
                        if (!(subCriteria instanceof Iterable)) {
                            log.warn((Object)("Found criterion '" + op + "' with sub-criteria that is not instance of Iterable." + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        restrictions = new ArrayList<CriteriaPart>();
                        i$2 = ((Iterable)subCriteria).iterator();
                        break block351;
                    }
                    if ("regexp".equalsIgnoreCase(op)) {
                        return null;
                    }
                    if ("iregexp".equalsIgnoreCase(op)) {
                        return null;
                    }
                    if (fieldName == null) {
                        log.warn((Object)("Found criterion '" + op + "' with no field specified. Skipping."));
                        return null;
                    }
                    DSField field = this.getField(fieldName);
                    if (field == null) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is not defined in data source. Skipping."));
                        return null;
                    }
                    if (fieldFunctionsMap != null && fieldFunctionsMap.containsKey(fieldName)) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is defined in fieldFunctions map," + " applying criteria to aggregated fields is not supported. Skipping."));
                        return null;
                    }
                    if (!this.isFieldPersistent(field.getName())) {
                        log.warn((Object)("Field name: '" + field.getName() + "' specified in criteria is non-persistent. Skipping."));
                        return null;
                    }
                    relationFieldInfo = (RelationFieldInfo)this.relationFields.get(fieldName);
                    relatedDS = null;
                    DSField relatedField = null;
                    relatedpropertyName = null;
                    relatedPropertyType = null;
                    if (relationFieldInfo != null) {
                        relatedDS = (JPADataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                        relatedField = relatedDS.getField(relationFieldInfo.getRelatedFieldName());
                        relatedpropertyName = relatedField.getBeanPropertyName();
                        relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                    }
                    aliasedPropertyName = this.getAliasedPropertyName(fieldName);
                    String propertyName = field.getBeanPropertyName();
                    propertyType = DataTools.getPropertyType((Class)this.beanClass, (String)propertyName);
                    if (Collection.class.isAssignableFrom(propertyType) && relationFieldInfo == null) {
                        DataSource typeDS = DataSourceManager.getDataSource((String)field.getType(), null);
                        if (typeDS == null) {
                            log.warn((Object)("In order to filter against '" + field.getName() + "' field 'type' attribute must be declared pointing to related data source. Skipping."));
                            return null;
                        }
                        if (!(typeDS instanceof JPADataSource)) {
                            log.warn((Object)("Related data source '" + relatedDS.getName() + "' for field '" + field.getName() + "' used " + "in criteria is not compatible with '" + this.getName() + "' data source. Skipping."));
                            return null;
                        }
                        relatedDS = (JPADataSource)typeDS;
                        relatedpropertyName = relatedDS.getPrimaryKey();
                        relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                        relationFieldInfo = new RelationFieldInfo(fieldName, field.getType(), relatedDS.getName(), relatedpropertyName, false, true);
                    }
                    Object value = criteria.get("value");
                    Object start = criteria.get("start");
                    Object end = criteria.get("end");
                    if ("equals".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName;
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (relationFieldInfo != null) {
                            if (relationFieldInfo.isMultiple()) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "inSet");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                            }
                            if (relationFieldInfo.isObjectEncapsulated() && value != null) {
                                Object typedParameterValue = relatedDS.beanClass.newInstance();
                                DataTools.setProperties((Map)((Map)value), typedParameterValue);
                                value = typedParameterValue;
                            } else {
                                try {
                                    value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                                }
                                catch (Exception ex) {
                                    log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                    if (this.strictSQLFiltering) {
                                        criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName;
                                        return criteriaPart;
                                    }
                                    criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                                    return criteriaPart;
                                }
                            }
                        } else {
                            try {
                                value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                            }
                            catch (Exception ex) {
                                log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                if (this.strictSQLFiltering) {
                                    criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName;
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                                return criteriaPart;
                            }
                        }
                        if (value != null) {
                            criteriaPart.wherePart = aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = aliasedPropertyName + " is null";
                        return criteriaPart;
                    }
                    if ("notEqual".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " = " + aliasedPropertyName;
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=1 or " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        if (relationFieldInfo != null) {
                            if (relationFieldInfo.isMultiple()) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "notInSet");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                            }
                            if (relationFieldInfo.isObjectEncapsulated() && value != null) {
                                Object typedParameterValue = relatedDS.beanClass.newInstance();
                                DataTools.setProperties((Map)((Map)value), typedParameterValue);
                                value = typedParameterValue;
                            } else {
                                try {
                                    value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                                }
                                catch (Exception ex) {
                                    log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                    if (this.strictSQLFiltering) {
                                        criteriaPart.wherePart = aliasedPropertyName + " = " + aliasedPropertyName;
                                        return criteriaPart;
                                    }
                                    criteriaPart.wherePart = criteriaPart.wherePart + "1=1 or " + aliasedPropertyName + " is null";
                                    return criteriaPart;
                                }
                            }
                        } else {
                            try {
                                value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                            }
                            catch (Exception ex) {
                                log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                if (this.strictSQLFiltering) {
                                    criteriaPart.wherePart = aliasedPropertyName + " = " + aliasedPropertyName;
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + "1=1 or " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> :p" + criteriaPart.nextParameterNumber;
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "(" + aliasedPropertyName + " <> :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                        criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                        criteriaPart.parameters.add(value);
                        criteriaPart.beanParameterTypes.add(propertyType);
                        return criteriaPart;
                    }
                    if ("greaterThan".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                        return criteriaPart;
                    }
                    if ("lessThan".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                        return criteriaPart;
                    }
                    if ("greaterOrEqual".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                        return criteriaPart;
                    }
                    if ("lessOrEqual".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                        return criteriaPart;
                    }
                    if ("between".equalsIgnoreCase(op)) {
                        if (Date.class.isAssignableFrom(propertyType) && (start != null && !Date.class.isAssignableFrom(start.getClass()) || end != null && !Date.class.isAssignableFrom(end.getClass())) || !Date.class.isAssignableFrom(propertyType) && (start != null && Date.class.isAssignableFrom(start.getClass()) || end != null && Date.class.isAssignableFrom(end.getClass()))) {
                            log.warn((Object)("Trying to find " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' within range from " + (start == null ? "null" : (Date.class.isAssignableFrom(start.getClass()) ? "date" : start.getClass().getName())) + " type value to " + (end == null ? "null" : (Date.class.isAssignableFrom(end.getClass()) ? "date" : end.getClass().getName())) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!Comparable.class.isInstance(start)) {
                                log.warn((Object)("Found criterion '" + op + "' with start value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (end != null) {
                                if (!Comparable.class.isInstance(end)) {
                                    log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                    criteriaPart.wherePart = "1=2";
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1);
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!Comparable.class.isInstance(end)) {
                                log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("betweenInclusive".equalsIgnoreCase(op)) {
                        if (Date.class.isAssignableFrom(propertyType) && (start != null && !Date.class.isAssignableFrom(start.getClass()) || end != null && !Date.class.isAssignableFrom(end.getClass())) || !Date.class.isAssignableFrom(propertyType) && (start != null && Date.class.isAssignableFrom(start.getClass()) || end != null && Date.class.isAssignableFrom(end.getClass()))) {
                            log.warn((Object)("Trying to find " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' within range from " + (start == null ? "null" : (Date.class.isAssignableFrom(start.getClass()) ? "date" : start.getClass().getName())) + " type value to " + (end == null ? "null" : (Date.class.isAssignableFrom(end.getClass()) ? "date" : end.getClass().getName())) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!Comparable.class.isInstance(start)) {
                                log.warn((Object)("Found criterion '" + op + "' with start value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (end != null) {
                                if (!Comparable.class.isInstance(end)) {
                                    log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                    criteriaPart.wherePart = "1=2";
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " between :p" + criteriaPart.nextParameterNumber + " and :p" + (criteriaPart.nextParameterNumber + 1);
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!Comparable.class.isInstance(end)) {
                                log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iBetween".equalsIgnoreCase(op)) {
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!DataTools.isTextType(start.getClass()) && !DataTools.isNumberType(start.getClass())) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "between");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                            }
                            if (end != null) {
                                if (!DataTools.isTextType(end.getClass()) && !DataTools.isNumberType(end.getClass())) {
                                    HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                    newCriteria.put("operator", "between");
                                    return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                                }
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(concat(" + aliasedPropertyName + ",'')) < lower(:p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(concat(" + aliasedPropertyName + ",'')) < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > lower(:p" + criteriaPart.nextParameterNumber + ")" + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!DataTools.isTextType(end.getClass()) && !DataTools.isNumberType(end.getClass())) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "between");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) < lower(:p" + (criteriaPart.nextParameterNumber + 1) + "))";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) < :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iBetweenInclusive".equalsIgnoreCase(op)) {
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!DataTools.isTextType(start.getClass()) && !DataTools.isNumberType(start.getClass())) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "betweenInclusive");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                            }
                            if (end != null) {
                                if (!DataTools.isTextType(end.getClass()) && !DataTools.isNumberType(end.getClass())) {
                                    HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                    newCriteria.put("operator", "betweenInclusive");
                                    return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                                }
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) between lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(:p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(concat(" + aliasedPropertyName + ",'')) <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= lower(:p" + criteriaPart.nextParameterNumber + ")" + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!Comparable.class.isInstance(end)) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "betweenInclusive");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) <= lower(:p" + (criteriaPart.nextParameterNumber + 1) + "))";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) <= :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iEquals".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) = '' and " + aliasedPropertyName + " is not null)";
                            return criteriaPart;
                        }
                        if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                            log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) = lower(:p" + criteriaPart.nextParameterNumber + ") and " + aliasedPropertyName + " is not null)";
                        criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                        criteriaPart.parameters.add(value.toString());
                        criteriaPart.beanParameterTypes.add(String.class);
                        return criteriaPart;
                    }
                    if ("iNotEqual".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) <> '' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                            log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) <> lower(:p" + criteriaPart.nextParameterNumber + ") or " + aliasedPropertyName + " is null)";
                        criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                        criteriaPart.parameters.add(value.toString());
                        criteriaPart.beanParameterTypes.add(String.class);
                        return criteriaPart;
                    }
                    if ("contains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("startsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("endsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("iContains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("iStartsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("iEndsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("notContains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("notStartsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("notEndsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iNotContains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iNotStartsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iNotEndsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + JPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("isNull".equalsIgnoreCase(op)) {
                        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                            criteriaPart.wherePart = aliasedPropertyName + " is empty";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = aliasedPropertyName + " is null";
                        return criteriaPart;
                    }
                    if ("notNull".equalsIgnoreCase(op)) {
                        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                            criteriaPart.wherePart = aliasedPropertyName + " is not empty";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = aliasedPropertyName + " is not null";
                        return criteriaPart;
                    }
                    if ("inSet".equalsIgnoreCase(op)) {
                        Iterable valueList;
                        if (value == null) {
                            if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                                criteriaPart.wherePart = aliasedPropertyName + " is empty";
                                return criteriaPart;
                            }
                            log.warn((Object)("Value list is not provided for field '" + fieldName + "' in criterion '" + op + "'" + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (!(value instanceof Iterable)) {
                            value = DataTools.buildList((Object)value);
                        }
                        if ((valueList = (Iterable)value).iterator().hasNext()) {
                            hasNulls = false;
                            realValueListSize = 0;
                            i$ = valueList.iterator();
                            break block347;
                        } else {
                            if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                                criteriaPart.wherePart = aliasedPropertyName + " is empty";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                    }
                    if ("notInSet".equalsIgnoreCase(op)) {
                        HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                        newCriteria.put("operator", "inSet");
                        criteriaPart = this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                        if (criteriaPart != null) {
                            criteriaPart.wherePart = "not (" + criteriaPart.wherePart + ")";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    String otherFieldName = null;
                    try {
                        otherFieldName = value.toString();
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Found criterion '" + op + "' with no 'other' field specified." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    DSField otherField = this.getField(otherFieldName);
                    if (otherField == null) {
                        log.warn((Object)("'Other' field name: '" + otherFieldName + "' specified in criteria is not defined in data source." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    String aliasedOtherPropertyName = this.getAliasedPropertyName(otherField.getName());
                    String otherPropertyName = otherField.getBeanPropertyName();
                    Class otherPropertyType = DataTools.getPropertyType((Class)this.beanClass, (String)otherPropertyName);
                    if ("equalsField".equalsIgnoreCase(op) || "notEqualField".equalsIgnoreCase(op) || "greaterThanField".equalsIgnoreCase(op) || "greaterOrEqualField".equalsIgnoreCase(op) || "lessThanField".equalsIgnoreCase(op) || "lessOrEqualField".equalsIgnoreCase(op)) {
                        HashMap operatorToSql = new HashMap(){
                            {
                                this.put("equalsField", "=");
                                this.put("notEqualField", "<>");
                                this.put("greaterThanField", ">");
                                this.put("greaterOrEqualField", ">=");
                                this.put("lessThanField", "<");
                                this.put("lessOrEqualField", "<=");
                            }
                        };
                        if (!propertyType.isAssignableFrom(otherPropertyType) && !otherPropertyType.isAssignableFrom(propertyType)) {
                            log.warn((Object)("Fields '" + propertyName + "' and '" + otherPropertyName + "' in criterion '" + op + "' are not compatible.\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        StringBuffer ql = new StringBuffer();
                        String propertyString = aliasedPropertyName;
                        String otherString = aliasedOtherPropertyName;
                        if (operator.equals("equalsField")) {
                            ql.append("(" + propertyString + " is null and " + otherString + " is null)");
                        } else if (operator.equals("notEqualField")) {
                            ql.append("((" + propertyString + " is null and " + otherString + " is not null) OR ");
                            ql.append("(" + propertyString + " is not null and " + otherString + " is null))");
                        } else if (operator.equals("lessThanField")) {
                            ql.append("(" + propertyString + " is null and " + otherString + " is not null)");
                        } else if (operator.equals("lessOrEqualField")) {
                            ql.append("(" + propertyString + " is null)");
                        } else if (operator.equals("greaterThanField")) {
                            ql.append("(" + propertyString + " is not null and " + otherString + " is null)");
                        } else {
                            ql.append("(" + otherString + " is null)");
                        }
                        ql.append(" or (" + propertyString + " " + operatorToSql.get(operator) + " ");
                        ql.append(otherString + " and ");
                        ql.append(propertyString + " is not null and " + otherString + " is not null)");
                        criteriaPart.wherePart = ql.toString();
                        return criteriaPart;
                    }
                    if (!("iEqualsField".equalsIgnoreCase(op) || "iNotEqualField".equalsIgnoreCase(op) || "containsField".equalsIgnoreCase(op) || "notContainsField".equalsIgnoreCase(op) || "iContainsField".equalsIgnoreCase(op) || "iNotContainsField".equalsIgnoreCase(op) || "startsWithField".equalsIgnoreCase(op) || "notStartsWithField".equalsIgnoreCase(op) || "iStartsWithField".equalsIgnoreCase(op) || "iNotStartsWithField".equalsIgnoreCase(op) || "endsWithField".equalsIgnoreCase(op) || "notEndsWithField".equalsIgnoreCase(op) || "iEndsWithField".equalsIgnoreCase(op) || "iNotEndsWithField".equalsIgnoreCase(op))) {
                        log.warn((Object)("Not supported criterion '" + op + "'. Skipping."));
                        return null;
                    }
                    boolean matchCase = !op.toLowerCase().startsWith("i".toLowerCase());
                    boolean bl = negate = op.toLowerCase().startsWith("not".toLowerCase()) || op.toLowerCase().startsWith("iNot".toLowerCase());
                    if ((DataTools.isTextType((Class)propertyType) || DataTools.isNumberType((Class)propertyType)) && (DataTools.isTextType((Class)otherPropertyType) || DataTools.isNumberType((Class)otherPropertyType))) {
                        StringBuffer ql = new StringBuffer();
                        String propertyString = DataTools.isTextType((Class)propertyType) ? aliasedPropertyName : "concat(" + aliasedPropertyName + ",'')";
                        String otherString = DataTools.isTextType((Class)otherPropertyType) ? aliasedOtherPropertyName : "concat(" + aliasedOtherPropertyName + ",'')";
                        if (!this.strictSQLFiltering) {
                            ql.append(aliasedOtherPropertyName + " is null");
                            if (op.toLowerCase().contains("Equal".toLowerCase())) {
                                ql.append(" and " + aliasedPropertyName + " is null)");
                                ql.insert(0, "(");
                            }
                            ql.append(" or (");
                        }
                        if (matchCase) {
                            ql.append(propertyString);
                        } else {
                            ql.append("lower(" + propertyString + ")");
                        }
                        ql.append(" like ");
                        if (!matchCase) {
                            ql.append("lower(");
                        }
                        if (op.toLowerCase().contains("endsWith".toLowerCase()) || op.toLowerCase().contains("contains".toLowerCase())) {
                            ql.append("concat('%', ");
                        }
                        if (op.toLowerCase().contains("startsWith".toLowerCase()) || op.toLowerCase().contains("contains".toLowerCase())) {
                            ql.append("concat(" + otherString + ", '%')");
                        } else {
                            ql.append(otherString);
                        }
                        if (op.toLowerCase().contains("endsWith".toLowerCase()) || op.toLowerCase().contains("contains".toLowerCase())) {
                            ql.append(")");
                        }
                        if (!matchCase) {
                            ql.append(")");
                        }
                        if (!this.strictSQLFiltering) {
                            ql.append(" and " + aliasedPropertyName + " is not null ");
                            ql.append(" and " + aliasedOtherPropertyName + " is not null)");
                        }
                        if (negate) {
                            ql.insert(0, "NOT(");
                            ql.append(")");
                        }
                        criteriaPart.wherePart = ql.toString();
                        return criteriaPart;
                    }
                    log.warn((Object)("Fields '" + propertyName + "' and '" + otherPropertyName + "' in criterion '" + op + "' are not compatible.\nReturning predicate '1=2' (always false)."));
                    criteriaPart.wherePart = negate ? "1=1" : "1=2";
                    return criteriaPart;
                }
                while (i$3.hasNext()) {
                    Object criterion = i$3.next();
                    if (criterion instanceof Map) {
                        CriteriaPart restriction = this.parseAdvancedCriteria((Map)criterion, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                        if (restriction == null) continue;
                        restrictions2.add(restriction);
                        criteriaPart.nextParameterNumber = restriction.nextParameterNumber;
                        continue;
                    }
                    log.warn((Object)("Found sub-criterion that is not instance of Map in criterion '" + op + "'. Skipping."));
                }
                if (restrictions2.size() <= 0) return null;
                i$3 = restrictions2.iterator();
                while (true) {
                    if (!i$3.hasNext()) {
                        criteriaPart.wherePart = "(" + criteriaPart.wherePart + ")";
                        return criteriaPart;
                    }
                    CriteriaPart restriction = (CriteriaPart)i$3.next();
                    if (!"".equals(criteriaPart.wherePart)) {
                        criteriaPart.wherePart = criteriaPart.wherePart + " or ";
                    }
                    criteriaPart.wherePart = criteriaPart.wherePart + restriction.wherePart;
                    criteriaPart.parameterNames.addAll(restriction.parameterNames);
                    criteriaPart.parameters.addAll(restriction.parameters);
                    criteriaPart.beanParameterTypes.addAll(restriction.beanParameterTypes);
                }
            }
            while (i$2.hasNext()) {
                Object criterion = i$2.next();
                if (criterion instanceof Map) {
                    CriteriaPart restriction = this.parseAdvancedCriteria((Map)criterion, criteriaPart.nextParameterNumber, fieldFunctionsMap);
                    if (restriction == null) continue;
                    restrictions.add(restriction);
                    criteriaPart.nextParameterNumber = restriction.nextParameterNumber;
                    continue;
                }
                log.warn((Object)("Found sub-criterion that is not instance of Map in criterion '" + op + "'. Skipping."));
            }
            if (restrictions.size() <= 0) return null;
            i$2 = restrictions.iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    criteriaPart.wherePart = "(" + criteriaPart.wherePart + ")";
                    return criteriaPart;
                }
                CriteriaPart restriction = (CriteriaPart)i$2.next();
                if (!"".equals(criteriaPart.wherePart)) {
                    criteriaPart.wherePart = criteriaPart.wherePart + " and ";
                }
                criteriaPart.wherePart = criteriaPart.wherePart + restriction.wherePart;
                criteriaPart.parameterNames.addAll(restriction.parameterNames);
                criteriaPart.parameters.addAll(restriction.parameters);
                criteriaPart.beanParameterTypes.addAll(restriction.beanParameterTypes);
            }
        }
        while (i$.hasNext()) {
            Object singleValue = i$.next();
            Object typedParameterValue = null;
            if (relationFieldInfo != null) {
                if (singleValue == null) {
                    hasNulls = true;
                    continue;
                }
                if (relationFieldInfo.isObjectEncapsulated()) {
                    typedParameterValue = relatedDS.beanClass.newInstance();
                    DataTools.setProperties((Map)((Map)singleValue), (Object)typedParameterValue);
                    criteriaPart.beanParameterTypes.add(relatedDS.beanClass);
                } else {
                    try {
                        if (Map.class.isAssignableFrom(singleValue.getClass())) {
                            Map singleValueMap = (Map)singleValue;
                            relatedpropertyName = (String)singleValueMap.keySet().iterator().next();
                            relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                            typedParameterValue = DataTools.castValue(singleValueMap.get(relatedpropertyName), (Class)relatedPropertyType, (DataSource)this);
                        } else {
                            typedParameterValue = DataTools.castValue(singleValue, (Class)relatedPropertyType, (DataSource)this);
                        }
                        criteriaPart.beanParameterTypes.add(relatedPropertyType);
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                        continue;
                    }
                }
                if (relationFieldInfo.isMultiple()) {
                    if (!"".equals(criteriaPart.wherePart)) {
                        criteriaPart.wherePart = criteriaPart.wherePart + ", ";
                    }
                    criteriaPart.wherePart = criteriaPart.wherePart + ":p" + criteriaPart.nextParameterNumber;
                    criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                    criteriaPart.parameters.add(typedParameterValue);
                } else {
                    if (!"".equals(criteriaPart.wherePart)) {
                        criteriaPart.wherePart = criteriaPart.wherePart + " or ";
                    }
                    criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                    criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                    criteriaPart.parameters.add(typedParameterValue);
                }
                ++realValueListSize;
                continue;
            }
            try {
                typedParameterValue = DataTools.castValue(singleValue, (Class)propertyType, (DataSource)this);
                if (typedParameterValue == null) {
                    hasNulls = true;
                    continue;
                }
                if (!"".equals(criteriaPart.wherePart)) {
                    criteriaPart.wherePart = criteriaPart.wherePart + " or ";
                }
                criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                criteriaPart.parameters.add(typedParameterValue);
                criteriaPart.beanParameterTypes.add(propertyType);
                ++realValueListSize;
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nSkipping value: '" + singleValue.toString() + "'"));
            }
        }
        if (realValueListSize > 0) {
            if (hasNulls) {
                if (relationFieldInfo == null) {
                    criteriaPart.wherePart = "(" + criteriaPart.wherePart + " or " + aliasedPropertyName + " is null)";
                    return criteriaPart;
                }
                if (!relationFieldInfo.isMultiple()) {
                    criteriaPart.wherePart = "(" + criteriaPart.wherePart + " or " + aliasedPropertyName + " is null)";
                    return criteriaPart;
                }
                if (relationFieldInfo.isObjectEncapsulated()) {
                    criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + criteriaPart.wherePart + ")) or " + aliasedPropertyName + " is empty)";
                    return criteriaPart;
                }
                criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + criteriaPart.wherePart + ")) or " + aliasedPropertyName + " is empty)";
                return criteriaPart;
            }
            if (relationFieldInfo == null) {
                criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") and " + aliasedPropertyName + " is not null)";
                return criteriaPart;
            }
            if (!relationFieldInfo.isMultiple()) {
                criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") and " + aliasedPropertyName + " is not null)";
                return criteriaPart;
            }
            if (relationFieldInfo.isObjectEncapsulated()) {
                criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + criteriaPart.wherePart + ")) and " + aliasedPropertyName + " is not empty)";
                return criteriaPart;
            }
            criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + criteriaPart.wherePart + ")) and " + aliasedPropertyName + " is not empty)";
            return criteriaPart;
        }
        if (hasNulls) {
            if (relationFieldInfo != null) {
                criteriaPart.wherePart = aliasedPropertyName + " is empty";
                return criteriaPart;
            }
            criteriaPart.wherePart = aliasedPropertyName + " is null";
            return criteriaPart;
        }
        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
            criteriaPart.wherePart = aliasedPropertyName + " is empty";
            return criteriaPart;
        }
        criteriaPart.wherePart = "1=2";
        return criteriaPart;
    }

    public static String escapeValueForFilter(Object value, char escapeChar) {
        if (value == null) {
            return "";
        }
        String stringValue = value.toString();
        stringValue = stringValue.replaceAll("" + escapeChar, "" + escapeChar + escapeChar);
        stringValue = stringValue.replaceAll("_", "" + escapeChar + "_");
        stringValue = stringValue.replaceAll("%", "" + escapeChar + "%");
        return stringValue;
    }

    public void markTransactionForRollBack(DSResponse dsResponse) {
        this.shouldRollBackTransaction = true;
        if (dsResponse != null) {
            dsResponse.setFailure();
        }
        log.debug((Object)"Marking transaction for roll back.");
    }

    public void freeResources(DSRequest req) {
        this.additionalFields = null;
        log.debug((Object)"Releasing entity manager.");
        if (this.connectionHolder == null) {
            EMF.returnEntityManager(this.configName, this.em);
        } else {
            EMF.returnEntityManager(this.configName, this.connectionHolder.getEntityManager());
        }
        super.freeResources(req);
    }

    public String getTransactionObjectKey() {
        return "_isc_jpa_transaction_";
    }

    public void onSuccess() throws Exception {
        log.debug((Object)"Committing current transaction.");
        EMF.commitTransaction(this.configName, this.tx);
    }

    public void onSuccess(RPCManager rpc) throws Exception {
        if (this.connectionHolder == null) {
            try {
                this.onSuccess();
            }
            catch (Exception ex) {
                this.onFailure(true);
                throw ex;
            }
        }
        try {
            log.debug((Object)("Committing transaction for " + this.connectionHolder.getOpCount() + " queued operation(s)."));
            EMF.commitTransaction(this.configName, this.connectionHolder.getTransaction());
        }
        catch (Exception ex) {
            EMF.rollbackTransaction(this.configName, this.connectionHolder.getTransaction());
            log.error((Object)"Failed to commit transaction. Rolling back.", (Throwable)ex);
            throw ex;
        }
    }

    public void onFailure(boolean transactionFailed) {
        if (transactionFailed) {
            log.debug((Object)"Rolling back current transaction after failing to commit.");
        } else {
            log.debug((Object)"Rolling back current transaction.");
        }
        EMF.rollbackTransaction(this.configName, this.tx);
    }

    public void onFailure(RPCManager rpc, boolean transactionFailed) throws Exception {
        if (this.connectionHolder == null) {
            this.onFailure(transactionFailed);
        } else {
            log.debug((Object)("Rolling back transaction for " + this.connectionHolder.getOpCount() + " queued operation(s)."));
            EMF.rollbackTransaction(this.configName, this.connectionHolder.getTransaction());
        }
    }

    public void increaseOpCount() {
        if (this.connectionHolder != null) {
            this.connectionHolder.increaseOpCount();
        }
    }

    public boolean canJoinIncludedFields() {
        return true;
    }

    public boolean handlesRelations() {
        return true;
    }

    protected Object getRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, List recursedList, ValidationContext vc) throws Exception {
        if (obj == null) {
            return null;
        }
        if (this.beanClass.isInstance(obj)) {
            Object value = DataTools.getProperties((Object)obj, (Collection)DataTools.buildList((Object)relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
            if (value == null) {
                return null;
            }
            DataSource relatedDS = DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
            if (relationFieldInfo.isMultiple()) {
                if (value instanceof Map) {
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        HashMap pkMap = new HashMap();
                        for (Object key : ((Map)value).keySet()) {
                            Object singleValue = ((Map)value).get(key);
                            if (!DataTools.containsByReference((Collection)recursedList, singleValue)) {
                                pkMap.put(key, relatedDS.getProperties(singleValue, null, true, true, vc, recursedList));
                                continue;
                            }
                            log.warn((Object)(singleValue.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                        }
                        return pkMap;
                    }
                    HashMap pkMap = new HashMap();
                    for (Object key : ((Map)value).keySet()) {
                        Object singleValue = ((Map)value).get(key);
                        pkMap.put(key, DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName()));
                    }
                    return pkMap;
                }
                if (value instanceof Collection) {
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        ArrayList<Map> pkList = new ArrayList<Map>();
                        for (Object singleValue : (Collection)value) {
                            if (!DataTools.containsByReference((Collection)recursedList, singleValue)) {
                                pkList.add(relatedDS.getProperties(singleValue, null, true, true, vc, recursedList));
                                continue;
                            }
                            log.warn((Object)(singleValue.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                        }
                        return pkList;
                    }
                    ArrayList pkList = new ArrayList();
                    for (Object singleValue : (Collection)value) {
                        pkList.add(DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName()));
                    }
                    return pkList;
                }
                if (relationFieldInfo.isObjectEncapsulated()) {
                    if (!DataTools.containsByReference((Collection)recursedList, value)) {
                        return DataTools.buildList((Object)relatedDS.getProperties(value, null, true, true, vc, recursedList));
                    }
                    log.warn((Object)(value.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                    return null;
                }
                return DataTools.getProperties(value, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
            }
            if (relationFieldInfo.isObjectEncapsulated()) {
                if (!DataTools.containsByReference((Collection)recursedList, value)) {
                    return relatedDS.getProperties(value, null, true, true, vc, recursedList);
                }
                log.warn((Object)(value.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                return null;
            }
            return DataTools.getProperties(value, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
        }
        throw new Exception("Specified object is not instance of " + this.beanClass.getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, Object value) throws Exception {
        JPADataSource relatedDS = (JPADataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
        if (!this.beanClass.isInstance(obj)) throw new Exception("Can not set related value to specified object. Not instance of " + this.beanClass.getName());
        Object oldValue = DataTools.getProperties((Object)obj, (Collection)DataTools.buildList((Object)relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
        if (relationFieldInfo.isMultiple()) {
            if (oldValue == null) {
                Class propertyType = DataTools.getPropertyType((Class)this.beanClass, (String)relationFieldInfo.getFieldName());
                if (Collection.class.isAssignableFrom(propertyType)) {
                    oldValue = new ArrayList();
                } else if (Map.class.isAssignableFrom(propertyType)) {
                    oldValue = new HashMap();
                }
                if (oldValue != null) {
                    DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), oldValue), (Object)obj);
                    oldValue = DataTools.getProperties((Object)obj, (Collection)DataTools.buildList((Object)relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
                }
            }
            if (oldValue instanceof Map) {
                if (value == null) {
                    value = new HashMap();
                }
                if (!(value instanceof Map)) throw new Exception("Can not update relation. Field " + relationFieldInfo.getFieldName() + " is Map but passed value is not Map");
                ArrayList keysToRemove = new ArrayList();
                for (Object k : ((Map)oldValue).keySet()) {
                    if (((Map)value).containsKey(k)) continue;
                    keysToRemove.add(k);
                }
                for (Object object : keysToRemove) {
                    Object valueToRemove = ((Map)oldValue).remove(object);
                    DSResponse relatedUpdate = new DSResponse((DataSource)relatedDS, valueToRemove, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType("remove");
                    this.relatedUpdates.add(relatedUpdate);
                }
                for (Object object : ((Map)value).keySet()) {
                    String relatedOperationType;
                    Object singleValue = ((Map)value).get(object);
                    if (((Map)oldValue).containsKey(object)) {
                        Object currentValue = ((Map)oldValue).get(object);
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), currentValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), currentValue);
                            }
                        }
                        DSResponse dSResponse = new DSResponse((DataSource)relatedDS, currentValue, DSResponse.STATUS_SUCCESS);
                        dSResponse.setOperationType("update");
                        this.relatedUpdates.add(dSResponse);
                        continue;
                    }
                    Object relatedId = singleValue;
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        relatedId = singleValue instanceof Map ? ((Map)singleValue).get(relationFieldInfo.getRelatedFieldName()) : DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
                    }
                    Query query = this.em.createQuery("select " + relatedDS.beanName + " from " + (this.useQualifiedClassName != false ? relatedDS.beanClass.getName() : relatedDS.beanClass.getSimpleName()) + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relationFieldInfo.getRelatedFieldName() + " = :p0");
                    query.setParameter("p0", DataTools.castValue(relatedId, (Class)DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relationFieldInfo.getRelatedFieldName())));
                    List resultList = query.getResultList();
                    Object newValue = null;
                    if (resultList != null && !resultList.isEmpty()) {
                        newValue = resultList.get(0);
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), newValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), newValue);
                            }
                        }
                        relatedOperationType = "update";
                    } else {
                        newValue = relatedDS.beanClass.newInstance();
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), newValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), newValue);
                            }
                        } else {
                            DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getRelatedFieldName(), singleValue), newValue);
                        }
                        this.em.persist(newValue);
                        relatedOperationType = "add";
                    }
                    ((Map)oldValue).put(object, newValue);
                    DSResponse relatedUpdate = new DSResponse((DataSource)relatedDS, newValue, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType(relatedOperationType);
                    this.relatedUpdates.add(relatedUpdate);
                }
                return;
            } else {
                DSResponse relatedUpdate;
                if (!(oldValue instanceof Collection)) throw new Exception("Can not update relation. Field " + relationFieldInfo.getFieldName() + " is neither Map nor Collection");
                if (value == null) {
                    value = new ArrayList();
                }
                if (!(value instanceof Collection)) {
                    value = DataTools.buildList(value);
                }
                ArrayList<void> newValues = new ArrayList<void>();
                ArrayList addedValues = new ArrayList();
                Object var8_16 = null;
                Iterator i$ = ((Collection)value).iterator();
                while (i$.hasNext()) {
                    void var8_22;
                    void var8_20;
                    void var11_37;
                    Object singleValue;
                    Object e = singleValue = i$.next();
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        if (singleValue instanceof Map) {
                            Object v = ((Map)singleValue).get(relationFieldInfo.getRelatedFieldName());
                        } else {
                            Object v = DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
                        }
                    }
                    Query q = this.em.createQuery("select " + relatedDS.beanName + " from " + (this.useQualifiedClassName != false ? relatedDS.beanClass.getName() : relatedDS.beanClass.getSimpleName()) + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relationFieldInfo.getRelatedFieldName() + " = :p0");
                    q.setParameter("p0", DataTools.castValue((Object)var11_37, (Class)DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relationFieldInfo.getRelatedFieldName())));
                    List resultList = q.getResultList();
                    Object var8_18 = null;
                    if (resultList != null && !resultList.isEmpty()) {
                        Object e2 = resultList.get(0);
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), e2);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), e2);
                            }
                        }
                        DSResponse relatedUpdate2 = new DSResponse((DataSource)relatedDS, e2, DSResponse.STATUS_SUCCESS);
                        relatedUpdate2.setOperationType("update");
                        this.relatedUpdates.add(relatedUpdate2);
                    }
                    if (var8_20 == null) {
                        Object t = relatedDS.beanClass.newInstance();
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), t);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), t);
                            }
                        } else {
                            DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getRelatedFieldName(), singleValue), t);
                        }
                        this.em.persist(t);
                        addedValues.add(t);
                    }
                    newValues.add(var8_22);
                }
                ArrayList valuesToRemove = new ArrayList();
                ArrayList valuesToAdd = new ArrayList();
                for (Object singleValue : (Collection)oldValue) {
                    if (newValues.contains(singleValue)) continue;
                    valuesToRemove.add(singleValue);
                }
                for (Object singleValue : newValues) {
                    if (((Collection)oldValue).contains(singleValue)) continue;
                    valuesToAdd.add(singleValue);
                }
                ((Collection)oldValue).removeAll(valuesToRemove);
                for (Object valueToRemove : valuesToRemove) {
                    relatedUpdate = new DSResponse((DataSource)relatedDS, valueToRemove, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType("remove");
                    this.relatedUpdates.add(relatedUpdate);
                }
                ((Collection)oldValue).addAll(valuesToAdd);
                for (Object addedValue : addedValues) {
                    relatedUpdate = new DSResponse((DataSource)relatedDS, addedValue, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType("add");
                    this.relatedUpdates.add(relatedUpdate);
                }
            }
            return;
        } else {
            boolean relatedRemove = false;
            Object newValue = null;
            Object var8_23 = null;
            if (value == null) {
                if (oldValue != null) {
                    relatedRemove = true;
                }
                DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), null), (Object)obj, (DataSource)this);
            } else {
                void var8_27;
                if (relationFieldInfo.isObjectEncapsulated()) {
                    if (value instanceof Map) {
                        Object v = ((Map)value).get(relationFieldInfo.getRelatedFieldName());
                    } else {
                        Object v = DataTools.getProperties(value, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
                    }
                } else {
                    HashMap hashMap = value;
                }
                Query q = this.em.createQuery("select " + relatedDS.beanName + " from " + (this.useQualifiedClassName != false ? relatedDS.beanClass.getName() : relatedDS.beanClass.getSimpleName()) + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relationFieldInfo.getRelatedFieldName() + " = :p0");
                q.setParameter("p0", DataTools.castValue((Object)var8_27, (Class)DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relationFieldInfo.getRelatedFieldName())));
                List resultList = q.getResultList();
                if (resultList != null && !resultList.isEmpty()) {
                    newValue = resultList.get(0);
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        if (value instanceof Map) {
                            DataTools.setProperties((Map)((Map)value), newValue);
                        } else {
                            DataTools.setProperties((Map)DataTools.getProperties((Object)value), newValue);
                        }
                    }
                    if (oldValue != null && !oldValue.equals(newValue)) {
                        relatedRemove = true;
                    }
                    DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), newValue), (Object)obj, (DataSource)this);
                    DSResponse dSResponse = new DSResponse((DataSource)relatedDS, newValue, DSResponse.STATUS_SUCCESS);
                    dSResponse.setOperationType("update");
                    this.relatedUpdates.add(dSResponse);
                }
                if (newValue == null) {
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        newValue = relatedDS.beanClass.newInstance();
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (value instanceof Map) {
                                DataTools.setProperties((Map)((Map)value), newValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties((Object)value), newValue);
                            }
                            this.em.persist(newValue);
                            if (oldValue != null) {
                                relatedRemove = true;
                            }
                            DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), newValue), (Object)obj, (DataSource)this);
                            DSResponse dSResponse = new DSResponse((DataSource)relatedDS, newValue, DSResponse.STATUS_SUCCESS);
                            dSResponse.setOperationType("add");
                            this.relatedUpdates.add(dSResponse);
                        }
                    } else {
                        if (var8_27 != null) {
                            log.warn((Object)("Can not find related object with id=" + var8_27.toString() + ". Setting to NULL."));
                        }
                        if (oldValue != null) {
                            relatedRemove = true;
                        }
                        DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), null), (Object)obj, (DataSource)this);
                    }
                }
            }
            if (!relatedRemove) return;
            DSResponse relatedUpdate = new DSResponse((DataSource)relatedDS, oldValue, DSResponse.STATUS_SUCCESS);
            relatedUpdate.setOperationType("remove");
            this.relatedUpdates.add(relatedUpdate);
        }
    }

    protected boolean getDefaultAllowAdvancedCriteria() {
        return true;
    }

    protected Boolean autoJoinAtProviderLevel(DSRequest req) {
        String autoJoin = config.getString((Object)"jpa.autoJoinTransactions");
        if (autoJoin == null) {
            return null;
        }
        if (autoJoin.equalsIgnoreCase("true") || autoJoin.equalsIgnoreCase("ALL")) {
            return Boolean.TRUE;
        }
        if (autoJoin.equalsIgnoreCase("false") || autoJoin.equalsIgnoreCase("NONE")) {
            return Boolean.FALSE;
        }
        if (req != null && req.rpc != null) {
            if (autoJoin.equalsIgnoreCase("FROM_FIRST_CHANGE")) {
                return req.rpc.requestQueueIncludesUpdates();
            }
            if (autoJoin.equalsIgnoreCase("ANY_CHANGE")) {
                return req.rpc.requestQueueIncludesUpdates();
            }
        }
        return null;
    }

    public boolean isCacheable() {
        return false;
    }

    static {
        if (config.getBoolean((Object)"datasources.jpa.trace.creation", false)) {
            createTrace = new ArrayList<Map>();
        }
        supportedAggregationFunctions = new ArrayList(){
            {
                this.add("MIN");
                this.add("MAX");
                this.add("AVG");
                this.add("SUM");
                this.add("COUNT");
            }
        };
    }

    private class CriteriaPart {
        String wherePart = "";
        int nextParameterNumber = 0;
        List<String> parameterNames = new ArrayList<String>();
        List<Object> parameters = new ArrayList<Object>();
        List<Class> beanParameterTypes = new ArrayList<Class>();

        private CriteriaPart() {
        }
    }
}

