/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.IType;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.velocity.DataSourcesHandler;
import com.isomorphic.xml.XML;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Element;

public class ValidationContext
extends HashMap {
    static Logger log = new Logger(ValidationContext.class.getName());
    boolean propertiesOnly = false;
    boolean useSchema = true;
    boolean idAllowed = false;
    String path = "";
    String fieldName = "";
    Element currentElement = null;
    Stack iterationCounterStack = new Stack();
    Map currentRecord = null;
    DataSource currentDataSource = null;
    DSRequest dsRequest = null;
    RPCManager rpcManager = null;
    RequestContext requestContext = null;
    Object resultingValue = null;
    boolean valueIsSet = false;
    boolean restrictedXMLMode = false;
    Map errors = null;
    Map<String, BasicDataSource> typeCache = new HashMap<String, BasicDataSource>();
    Map<String, IType> customSimpleTypeCache = new HashMap<String, IType>();
    public static int typeLookupTime;
    protected Map templateContext;
    protected Map templateContextClassNames;
    String bundleName;

    public boolean isPropertiesOnly() {
        return this.propertiesOnly;
    }

    public void setPropertiesOnly() {
        this.setPropertiesOnly(true);
    }

    public void setPropertiesOnly(boolean value) {
        this.propertiesOnly = value;
    }

    public void setUseSchema() {
        this.setUseSchema(true);
    }

    public void setUseSchema(boolean value) {
        this.useSchema = value;
    }

    public boolean idAllowed() {
        return this.idAllowed;
    }

    public void setIdAllowed() {
        this.setIdAllowed(true);
    }

    public void setIdAllowed(boolean value) {
        this.idAllowed = value;
    }

    public String getPath() {
        return this.path;
    }

    public void addPath(String segment) {
        this.path = this.path + "/" + segment;
        this.fieldName = segment;
    }

    public void removePathSegment() {
        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
        this.fieldName = this.path.substring(this.path.lastIndexOf("/") + 1, this.path.length());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setCurrentElement(Element element) {
        this.currentElement = element;
    }

    public Integer getIterationCounter() {
        if (this.iterationCounterStack.empty()) {
            return null;
        }
        return (Integer)this.iterationCounterStack.peek();
    }

    public Integer popIterationCounter() {
        if (this.iterationCounterStack.empty()) {
            return null;
        }
        return (Integer)this.iterationCounterStack.pop();
    }

    public void pushIterationCounter(Integer counter) {
        this.iterationCounterStack.push(counter);
    }

    public void setCurrentRecord(Map record) {
        this.currentRecord = record;
    }

    public Map getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentDataSource(DataSource dataSource) {
        this.currentDataSource = dataSource;
    }

    public DataSource getCurrentDataSource() {
        return this.currentDataSource;
    }

    public void setDSRequest(DSRequest dsRequest) {
        this.dsRequest = dsRequest;
    }

    public DSRequest getDSRequest() {
        return this.dsRequest;
    }

    public void setRPCManager(RPCManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    public RPCManager getRPCManager() {
        return this.rpcManager;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setResultingValue(Object value) {
        this.valueIsSet = true;
        this.resultingValue = value;
    }

    public Object getResultingValue() {
        return this.resultingValue;
    }

    public boolean resultingValueIsSet() {
        return this.valueIsSet;
    }

    public void clearResultingValue() {
        this.valueIsSet = false;
    }

    public void setRestrictedXMLMode(boolean restrictedXMLMode) {
        this.restrictedXMLMode = restrictedXMLMode;
    }

    public boolean getRestrictedXMLMode() {
        return this.restrictedXMLMode;
    }

    public Map getErrors() {
        return this.errors;
    }

    public void addError(Object newErrors) {
        this.addError(this.fieldName, newErrors);
    }

    public void addError(String fieldName, Object newErrors) {
        if (newErrors == null) {
            return;
        }
        if (this.errors == null) {
            this.errors = new HashMap();
        }
        log.debug("Adding validation errors at path '" + this.path + "/" + fieldName + "': " + newErrors);
        String recordPath = this.getCurrentRecordPath(fieldName);
        ErrorReport report = (ErrorReport)this.errors.get(recordPath);
        if (report == null) {
            report = new ErrorReport();
            report.put("recordPath", recordPath);
            if (this.currentElement != null) {
                report.put("xpath", XML.getXPath(this.currentElement));
            }
            this.errors.put(recordPath, report);
        }
        DataTools.putCombinedList((Map)((Object)report), fieldName, newErrors);
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    public void clearErrors() {
        this.errors = null;
    }

    public String getCurrentRecordPath(String fieldName) {
        String recordPath = this.path;
        if (fieldName != null && recordPath.endsWith("/" + fieldName)) {
            recordPath = recordPath.substring(0, recordPath.lastIndexOf("/"));
        }
        return recordPath;
    }

    public ErrorReport getCurrentErrorReport() {
        if (this.errors == null) {
            return null;
        }
        return (ErrorReport)this.errors.get(this.getCurrentRecordPath(null));
    }

    public BasicDataSource getType(String typeName) throws Exception {
        return this.getType(typeName, false);
    }

    public BasicDataSource getType(String typeName, boolean isSchemaless) throws Exception {
        if (typeName == null || "".equals(typeName)) {
            return null;
        }
        if (!this.useSchema && !"Object".equals(typeName)) {
            return null;
        }
        if (this.typeCache.containsKey(typeName)) {
            return this.typeCache.get(typeName);
        }
        if (DataSource.getBuiltinType(typeName) != null) {
            return null;
        }
        long start = System.currentTimeMillis();
        BasicDataSource ds = (BasicDataSource)DataSourceManager.getDataSource(typeName, this.getDSRequest(), isSchemaless);
        long end = System.currentTimeMillis();
        typeLookupTime = (int)((long)typeLookupTime + (end - start));
        this.typeCache.put(typeName, ds);
        return ds;
    }

    IType getCustomSimpleType(String typeName, BasicDataSource dataSource) throws Exception {
        if (typeName == null || "".equals(typeName)) {
            return null;
        }
        IType res = this.typeCache.get(typeName);
        if (res != null) {
            return res;
        }
        String typeConfigFile = DataStructCache.getInstanceFile(typeName, "datasources", "type");
        if (typeConfigFile == null) {
            return null;
        }
        Object typeConfig = DataStructCache.loadInstance(typeConfigFile, typeName, "type");
        res = dataSource.makeType(typeName, (Map)typeConfig);
        this.customSimpleTypeCache.put(typeName, res);
        return res;
    }

    public Map getTemplateContext() {
        return this.templateContext;
    }

    public Map getTemplateContextClassNames() {
        return this.templateContextClassNames;
    }

    public void setTemplateContext(Map templateContext) {
        this.templateContext = templateContext;
    }

    public void setTemplateContextClassNames(Map templateContextClassNames) {
        this.templateContextClassNames = templateContextClassNames;
    }

    public void addToTemplateContext(Map addMap) {
        if (this.templateContext == null) {
            this.initTemplateContext();
        }
        for (Object key : addMap.keySet()) {
            Object value = addMap.get(key);
            this.templateContext.put(key, value);
        }
    }

    public void addToTemplateContextClassNames(Map addMap) {
        if (this.templateContextClassNames == null) {
            this.initTemplateContext();
        }
        for (Object key : addMap.keySet()) {
            Object value = addMap.get(key);
            this.templateContextClassNames.put(key, value);
        }
    }

    public void addToTemplateContext(Object key, Object value) {
        this.addToTemplateContext(key, value, null);
    }

    public void addToTemplateContext(Object key, Object value, Class valueClass) {
        if (this.templateContext == null) {
            this.initTemplateContext();
        }
        this.templateContext.put(key, value);
        if (value != null) {
            this.templateContextClassNames.put(key, value.getClass().getName());
        } else if (valueClass != null) {
            this.templateContextClassNames.put(key, valueClass.getName());
        }
    }

    public void addToTemplateContextClassNames(Object key, Object value) {
        if (this.templateContextClassNames == null) {
            this.initTemplateContext();
        }
        this.templateContextClassNames.put(key, value);
    }

    private void initTemplateContext() {
        this.templateContext = new HashMap();
        this.templateContext.put("dataSources", new DataSourcesHandler(this.getDSRequest()));
        this.templateContext.put("util", new DataTools());
        this.templateContextClassNames = new HashMap();
        this.templateContextClassNames.put("dataSources", DataSourcesHandler.class.getName());
        this.templateContextClassNames.put("util", DataTools.class.getName());
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void finalize() throws Throwable {
        if (this.typeCache.size() > 0) {
            Iterator<String> i = this.typeCache.keySet().iterator();
            while (i.hasNext()) {
                DataSourceManager.free(this.typeCache.get(i.next()));
            }
        }
    }

    public void freeResources() {
        Iterator<Map.Entry<String, BasicDataSource>> i = this.typeCache.entrySet().iterator();
        while (i.hasNext()) {
            DataSourceManager.free(this.typeCache.get(i.next().getValue()));
            i.remove();
        }
    }
}

