/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.mail;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.RecipientNotSetException;
import com.isomorphic.mail.SenderNotSetException;
import com.isomorphic.mail.SubjectNotSetException;
import com.isomorphic.naming.DNS;
import com.isomorphic.util.DataTools;
import com.sun.mail.smtp.SMTPMessage;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MailMessage
extends Base {
    protected Session session;
    protected SMTPMessage message;
    private static final String subjectPrefix = config.getString("mail.subjectPrefix");
    protected Map recipients;
    protected Map headers;
    protected String subject;
    protected String sender;
    protected List<String> replyTo = new ArrayList<String>();
    protected StringWriter body;
    protected String priority;
    protected List attachments = new ArrayList();
    private static Logger log = new Logger(MailMessage.class.getName());
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";

    public MailMessage() {
        this.reset();
    }

    public void setFrom(String sender) {
        if (sender != null) {
            this.sender = sender.trim();
        }
    }

    public void addReplyTo(String replyTo) {
        if (replyTo != null) {
            this.replyTo.add(replyTo.trim());
        }
    }

    public void setReplyTo(String replyTo) {
        if (replyTo == null) {
            return;
        }
        this.replyTo.clear();
        String[] cs = replyTo.split(",");
        for (int i = 0; i < cs.length; ++i) {
            this.replyTo.add(cs[i].trim());
        }
    }

    public void setReplyTo(List replyTo) {
        this.replyTo = new ArrayList<String>(replyTo);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void addHeader(String field, String value) {
        this.headers.put(field, value);
    }

    public void addHeaders(Map headers) {
        DataTools.mapMerge(headers, this.headers);
    }

    public void addRecipient(String recipient) {
        this.addRecipient(recipient, Message.RecipientType.TO);
    }

    public void setRecipient(String recipient) {
        this.addRecipient(recipient);
    }

    public void addRecipients(List recipients) {
        this.addRecipients(recipients, Message.RecipientType.TO);
    }

    public void addRecipients(String recipients) {
        this.addRecipients(recipients, Message.RecipientType.TO);
    }

    public void addRecipient(String recipient, Message.RecipientType type) {
        if (recipient == null) {
            return;
        }
        this.recipients.put(recipient.trim(), type);
    }

    public void addRecipients(List recipients, Message.RecipientType type) {
        if (recipients == null) {
            return;
        }
        Iterator re = recipients.iterator();
        while (re.hasNext()) {
            this.addRecipient((String)re.next(), type);
        }
    }

    public void addRecipients(String recipients, Message.RecipientType type) {
        if (recipients == null) {
            return;
        }
        StringTokenizer rt = new StringTokenizer(recipients, ",");
        while (rt.hasMoreTokens()) {
            this.addRecipient((String)rt.nextElement(), type);
        }
    }

    public void setBody(String newBody) {
        if (newBody == null) {
            return;
        }
        this.body = new StringWriter();
        this.body.write(newBody);
    }

    public void addAttachment(DataSource ds) {
        this.attachments.add(ds);
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public Writer getBodyWriter() {
        if (this.body == null) {
            this.body = new StringWriter();
        }
        return this.body;
    }

    void buildMessage() throws Exception {
        if (this.message == null) {
            this.initMessage();
        }
        this.processMessageText();
        if (this.sender == null) {
            String configuredSender = config.getString("mail.system.mail.smtp.from");
            if (configuredSender != null) {
                this.sender = configuredSender;
            } else {
                throw new SenderNotSetException("Must specify the sender");
            }
        }
        if (this.recipients.size() == 0) {
            throw new RecipientNotSetException("Must specify a recipient");
        }
        if (this.subject == null) {
            throw new SubjectNotSetException("Must set a subject");
        }
        if (subjectPrefix != null) {
            this.subject = subjectPrefix + this.subject;
        }
        if (this.headers.size() > 0) {
            for (String field : this.headers.keySet()) {
                String value = (String)this.headers.get(field);
                this.message.addHeader(field, value);
            }
        }
        this.message.setFrom((Address)new InternetAddress(this.sender));
        if (this.replyTo.size() > 0) {
            Address[] replyToAddress = new Address[this.replyTo.size()];
            for (int i = 0; i < this.replyTo.size(); ++i) {
                replyToAddress[i] = new InternetAddress(this.replyTo.get(i));
            }
            this.message.setReplyTo(replyToAddress);
        }
        for (String mail : this.recipients.keySet()) {
            Message.RecipientType type = (Message.RecipientType)this.recipients.get(mail);
            this.message.addRecipients(type, (Address[])new InternetAddress[]{new InternetAddress(mail)});
        }
        this.message.setSubject(this.subject);
        if (this.priority != null) {
            this.message.addHeader("X-Priority", this.priority);
        }
        this.message.setSentDate(new Date());
    }

    void processMessageText() throws Exception {
    }

    private void initMessage() throws Exception {
        Properties defaultProps = Config.buildProperties((Map)((Object)config.getSubtree("mail.system")));
        String hostProp = defaultProps.getProperty("mail.smtp.host");
        Map mxMap = DNS.mxMapForList(hostProp);
        if (mxMap == null || mxMap.isEmpty()) {
            log.error((Object)"No SMTP host list was returned for", hostProp);
            throw new Exception("No SMTP host list was returned");
        }
        TreeMap treemap = new TreeMap(mxMap);
        Properties props = Config.buildProperties((Map)((Object)config.getSubtree("mail.system")));
        boolean connected = false;
        for (List hosts : treemap.values()) {
            Iterator ii = hosts.iterator();
            while (ii.hasNext()) {
                block11: {
                    String host = ((String)ii.next()).trim();
                    log.info("trying to connect to " + host);
                    props.setProperty("mail.smtp.host", host);
                    try {
                        boolean authEnabled = props.getProperty("mail.smtp.auth", "false") != "false";
                        final String smtpUser = props.getProperty("mail.smtp.user", null);
                        final String smtpPassword = props.getProperty("mail.smtp.password", null);
                        if (authEnabled) {
                            if (smtpUser != null && smtpPassword != null) {
                                Authenticator auth = new Authenticator(){

                                    protected PasswordAuthentication getPasswordAuthentication() {
                                        return new PasswordAuthentication(smtpUser, smtpPassword);
                                    }
                                };
                                this.session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
                            } else {
                                log.warn("SMTP authentication enabled, but mail.smtp.user or mail.smtp.password are not set. Disabling authentication.");
                                this.session = Session.getDefaultInstance((Properties)props);
                            }
                        } else {
                            this.session = Session.getDefaultInstance((Properties)props);
                        }
                        Transport transport = this.session.getTransport("smtp");
                        transport.connect();
                        if (transport != null && transport.isConnected()) {
                            connected = true;
                        }
                    }
                    catch (MessagingException e) {
                        if (!log.isDebugEnabled()) break block11;
                        e.printStackTrace();
                    }
                }
                if (!connected) continue;
                break;
            }
            if (!connected) continue;
            break;
        }
        if (!connected) {
            log.error((Object)"no smtp servers available, I tried", hostProp);
            throw new Exception("no SMTP servers available");
        }
        this.message = new SMTPMessage(this.session);
    }

    public void send() throws Exception {
        if (this.message == null) {
            this.buildMessage();
        }
        if (this.body != null) {
            this.body.flush();
        }
        if (this.attachments.size() == 0) {
            String contentType = this.getContentType();
            String encoding = this.getEncoding();
            if (contentType == null) {
                contentType = DEFAULT_CONTENT_TYPE;
            }
            if (encoding == null) {
                encoding = config.getString("mail.system.default.encoding");
            }
            if (contentType.indexOf("charset=") == -1) {
                contentType = contentType + "; charset=" + encoding;
            }
            this.message.setContent((Object)this.body.toString(), contentType);
        } else {
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(this.body.toString());
            mp.addBodyPart((BodyPart)textPart);
            for (DataSource mds : this.attachments) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(new DataHandler(mds));
                part.setFileName(mds.getName());
                mp.addBodyPart((BodyPart)part);
            }
            this.message.setContent((Multipart)mp);
        }
        Transport.send((Message)this.message);
        this.reset();
    }

    public void reset() {
        this.sender = null;
        this.recipients = new HashMap();
        this.headers = new HashMap();
        this.subject = null;
        this.body = null;
        this.attachments = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void parse(String message) throws IOException {
        Perl5Util regex = new Perl5Util();
        String to = "";
        String cc = "";
        String bcc = "";
        BufferedReader mr = new BufferedReader(new StringReader(message));
        this.body = new StringWriter();
        try {
            String line;
            block2: while ((line = mr.readLine()) != null) {
                StringTokenizer st;
                if (regex.match("m/^From:/m", line)) {
                    if (regex.match("m/^From:\\s*(\\S+.*)$/m", line)) {
                        this.setFrom(regex.group(1));
                        continue;
                    }
                    if (!regex.match("m/^From:.*<([^>]+)>/m", line)) continue;
                    this.setFrom(regex.group(1));
                    continue;
                }
                if (regex.match("m/^Subject:/m", line)) {
                    if (!regex.match("m/^Subject:\\s*(\\S+.*)$/m", line) || regex.groups() <= 0) continue;
                    this.setSubject(regex.group(1));
                    continue;
                }
                if (regex.match("m/^To:/m", line) && regex.match("m/^To:\\s*(\\S+.*)$/m", line)) {
                    if (regex.groups() <= 0 || (to = regex.group(1)).length() == 0) continue;
                    st = new StringTokenizer(to, ",");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block2;
                        this.addRecipient(st.nextToken());
                    }
                }
                if (regex.match("m/^Cc:/m", line) && regex.match("m/^Cc:\\s*(\\S+.*)$/m", line)) {
                    if (regex.groups() <= 0 || (cc = regex.group(1)).length() == 0) continue;
                    st = new StringTokenizer(cc, ",");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block2;
                        this.addRecipient(st.nextToken(), Message.RecipientType.CC);
                    }
                }
                if (regex.match("m/^Bcc:/m", line) && regex.match("m/^Bcc:\\s*(\\S+.*)$/m", line)) {
                    if (regex.groups() <= 0 || (bcc = regex.group(1)).length() == 0) continue;
                    st = new StringTokenizer(bcc, ",");
                    while (true) {
                        if (!st.hasMoreTokens()) continue block2;
                        this.addRecipient(st.nextToken(), Message.RecipientType.BCC);
                    }
                }
                if (regex.match("m/^Reply-To:/m", line)) {
                    if (!regex.match("m/^Reply-To:\\s*(\\S+.*)$/m", line) || regex.groups() <= 0) continue;
                    this.setReplyTo(regex.group(1));
                    continue;
                }
                this.body.write(line + "\r\n");
            }
            return;
        }
        catch (IOException ioe) {
            String error = "Error parsing mail message";
            log.error((Object)error, ioe);
            throw ioe;
        }
    }

    protected String getContentType() throws MessagingException {
        String[] contentType = this.message.getHeader("Content-Type");
        if (contentType == null || contentType.length == 0) {
            return null;
        }
        return contentType[0];
    }

    protected String getEncoding() {
        return null;
    }

    static {
        config.setIfNull("mail.system.mail.smtp.port", "25");
        config.setIfNull("mail.system.mail.smtp.host", "localhost");
        config.setIfNull("mail.system.mail.smtp.connectiontimeout", "2000");
        config.setIfNull("mail.system.mail.smtp.sendpartial", "true");
        config.setIfNull("mail.system.default.encoding", "UTF-8");
    }
}

