/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class DataSourceLoader
extends BaseServlet {
    public static final String OUTPUT_SC_DETECTION_CODE = "outputSCDetectionCode";
    private boolean outputSCDetectionCode;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/json;charset=" + encoding);
        }
        PrintWriter writer = response.getWriter();
        HashMap<String, DataSource> processed = new HashMap<String, DataSource>();
        String lastProcessedDS = null;
        try {
            String ids = request.getParameter("dataSource");
            if (ids == null) {
                throw new Exception("No 'dataSource' parameter provided");
            }
            boolean stubWritten = false;
            String[] multipleIDs = ids.split(",");
            for (int i = 0; i < multipleIDs.length; ++i) {
                String id;
                lastProcessedDS = id = multipleIDs[i].trim();
                if (processed.containsKey(id)) continue;
                DataSource ds = DataSourceManager.getDataSource(id, null);
                if (ds == null) {
                    BasicDataSource bds = new BasicDataSource();
                    ValidationContext vc = new ValidationContext();
                    IType cst = bds.getSimpleType(id, vc);
                    if (cst != null) {
                        JSTranslater jstran = JSTranslater.get();
                        Locale locale = null;
                        String localeName = request.getParameter("locale");
                        if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
                            this.log.warn("Locale name " + localeName + " is not valid - ignoring");
                        }
                        if (locale == null) {
                            locale = request.getLocale();
                        }
                        jstran.setLocale(locale);
                        if (this.outputSCDetectionCode && !stubWritten) {
                            writer.write("if (window.isc == undefined || window.isc.DataSource == undefined){");
                            writer.write("  alert(\"Can't load DataSources - SmartClient runtime not loaded\");");
                            writer.write("}");
                            stubWritten = true;
                        }
                        jstran.toJS(cst, writer);
                        continue;
                    }
                    throw new JspException("Unable to load DataSource for ID: " + DataTools.escapeHTML(id));
                }
                this.log.debug("For DataSource '" + id + "', got instanceId " + ds.getInstanceId());
                ds._cloneConfigForSecurityAnnotations();
                DeclarativeSecurity.annotateDataSourceFields(ds, (ServletRequest)request);
                JSTranslater jstran = JSTranslater.get();
                Locale locale = null;
                String localeName = request.getParameter("locale");
                if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
                    this.log.warn("Locale name " + localeName + " is not valid - ignoring");
                }
                if (locale == null) {
                    locale = request.getLocale();
                }
                jstran.setLocale(locale);
                if (this.outputSCDetectionCode && !stubWritten) {
                    writer.write("if (window.isc == undefined || window.isc.DataSource == undefined){");
                    writer.write("  alert(\"Can't load DataSources - SmartClient runtime not loaded\");");
                    writer.write("}");
                    stubWritten = true;
                }
                jstran.toJS(ds, writer);
                processed.put(id, ds);
                if ("true".equals(request.getParameter("loadParents"))) {
                    String inheritsFrom = (String)ds.getConfig().get("inheritsFrom");
                    while (inheritsFrom != null) {
                        if (!processed.containsKey(inheritsFrom)) {
                            ds = DataSourceManager.getDataSource(inheritsFrom, null);
                            if (ds == null) {
                                throw new JspException("Unable to load DataSource for ID '" + DataTools.escapeHTML(inheritsFrom) + "' when loading " + "parent DataSources for DataSource '" + DataTools.escapeHTML(id) + "'");
                            }
                            ds._cloneConfigForSecurityAnnotations();
                            DeclarativeSecurity.annotateDataSourceFields(ds, (ServletRequest)request);
                            jstran = JSTranslater.get();
                            jstran.setLocale(locale);
                            jstran.toJS(ds, writer);
                            processed.put(inheritsFrom, ds);
                        } else {
                            ds = (DataSource)processed.get(inheritsFrom);
                        }
                        inheritsFrom = (String)ds.getConfig().get("inheritsFrom");
                    }
                }
                Iterator dsIter = processed.keySet().iterator();
                while (dsIter.hasNext()) {
                    DataSourceManager.free((DataSource)processed.get(dsIter.next()));
                }
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to load a DataSource", e);
            throw new ServletException("DataSource '" + lastProcessedDS + "' failed to load due to an exception on the server:\n" + e.getMessage() + "\nSee the server-side log for additional details.");
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (IOException ids) {}
        }
    }

    public void init() throws ServletException {
        super.init();
        this.outputSCDetectionCode = true;
        String parameterOutputSCDetectionCode = this.getInitParameter(OUTPUT_SC_DETECTION_CODE);
        if (parameterOutputSCDetectionCode != null) {
            this.outputSCDetectionCode = new Boolean(parameterOutputSCDetectionCode);
        }
    }
}

