/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByScLocator
extends By {
    public static final String GET_ELEMENT = "isc.AutoTest.getElement";
    private final String scLocator;

    ByScLocator(String scLocator) {
        this.scLocator = scLocator.replaceAll("\\\"", "'").replaceAll("\\'", "'").trim();
    }

    public List<WebElement> findElements(SearchContext context) {
        String[] components;
        String lastComponent;
        boolean multiple = false;
        if (this.scLocator != null && (lastComponent = (components = this.scLocator.split("/"))[components.length - 1]).length() > 0 && !lastComponent.contains("[")) {
            multiple = true;
        }
        JavascriptExecutor js = (JavascriptExecutor)context;
        ArrayList<WebElement> list = new ArrayList<WebElement>();
        if (multiple) {
            Object element;
            int i = 0;
            while ((element = js.executeScript("return isc.AutoTest.getElement(\"" + this.scLocator + "[" + i + "]\")", new Object[0])) != null) {
                list.add((WebElement)element);
                ++i;
            }
        } else {
            Object element = js.executeScript("return isc.AutoTest.getElement(\"" + this.scLocator + "\")", new Object[0]);
            if (element != null) {
                list.add((WebElement)element);
            }
        }
        return list;
    }

    public WebElement findElement(SearchContext context) {
        JavascriptExecutor js = (JavascriptExecutor)context;
        Object element = null;
        try {
            element = js.executeScript("return isc.AutoTest.getElement(\"" + this.scLocator + "\")", new Object[0]);
        }
        catch (Exception e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            element = js.executeScript("return isc.AutoTest.getElement(\"" + this.scLocator + "\")", new Object[0]);
        }
        if (element == null) {
            throw new NoSuchElementException(this.scLocator);
        }
        return (WebElement)element;
    }

    public String toJavaString() {
        return "ByScLocator.scLocator(\"" + this.scLocator.replace("\"", "\\\"") + "\")";
    }

    public String toString() {
        return "By.scLocator: " + this.scLocator;
    }

    public String getLocatorString() {
        return this.scLocator.replace("\\", "");
    }

    public static By scLocator(String scLocator) {
        if (scLocator == null) {
            throw new IllegalArgumentException("Cannot find elements with a null scLocator attribute.");
        }
        return new ByScLocator(scLocator);
    }

    int getEdgeOffsetX(long width, long margin) {
        if (this.getPartLocator().contains("L")) {
            return (int)margin;
        }
        if (this.getPartLocator().contains("R")) {
            return (int)(width - margin);
        }
        return (int)(width / 2L);
    }

    int getEdgeOffsetY(long height, long margin) {
        if (this.getPartLocator().contains("T")) {
            return (int)margin;
        }
        if (this.getPartLocator().contains("B")) {
            return (int)(height - margin);
        }
        return (int)(height / 2L);
    }

    boolean isEdgeLocator() {
        String partLocator = this.getPartLocator();
        if (partLocator.length() == 1) {
            return "TBLR".contains(partLocator);
        }
        if (partLocator.length() == 2) {
            return !(!partLocator.startsWith("T") && !partLocator.startsWith("B") || !partLocator.endsWith("L") && !partLocator.endsWith("R"));
        }
        return false;
    }

    String getBaseLocator() {
        return this.scLocator.substring(0, this.scLocator.lastIndexOf(47));
    }

    private String getPartLocator() {
        if (this.scLocator != null && this.scLocator.contains("/")) {
            return this.scLocator.substring(this.scLocator.lastIndexOf(47) + 1);
        }
        return "";
    }
}

