/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.taglib.VirtualTag;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class LoadDSTag
extends VirtualTag {
    public String ID = null;
    public String serverType = null;
    public String tableName = null;
    public String dbName = null;
    public String repo = null;
    public String locale = null;

    public int doStartTag() throws JspException {
        this.init();
        try {
            if (this.ID == null) {
                throw new JspException("DataSource ID not set in tag - unable to proceed.");
            }
            if (virtualize) {
                return this.virtualizeTag("ds", this.ID);
            }
            LoadDSTag.outputJS(this.ID, this.repo, this.pageContext, this.locale, this.log);
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadDS tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public static void outputJS(String ID, String repo, PageContext pageContext, String localeName, Logger log) throws Exception {
        String[] multipleIDs = ID.split(",");
        for (int i = 0; i < multipleIDs.length; ++i) {
            DataSource ds = null;
            ds = repo == null || "".equals(repo) ? DataSourceManager.getDataSource(multipleIDs[i].trim(), new DSRequest()) : DataSource.forName(ID, repo, null);
            if (ds == null) {
                BasicDataSource bds = new BasicDataSource();
                IType cst = bds.getSimpleType(multipleIDs[i], new ValidationContext());
                if (cst != null) {
                    LoadDSTag.printObjectAsJS(pageContext, localeName, log, cst);
                    continue;
                }
                throw new JspException("Unable to load DataSource for ID: " + multipleIDs[i]);
            }
            ds._cloneConfigForSecurityAnnotations();
            DeclarativeSecurity.annotateDataSourceFields(ds, pageContext.getRequest());
            LoadDSTag.printObjectAsJS(pageContext, localeName, log, ds);
            if (repo != null && !"".equals(repo)) {
                pageContext.getOut().write(";" + ID + ".repo='" + repo + "';");
                continue;
            }
            DataSourceManager.free(ds);
        }
    }

    private static void printObjectAsJS(PageContext pageContext, String localeName, Logger log, IType cst) throws UnconvertableException, IOException {
        JSTranslater jstran = JSTranslater.get();
        Locale locale = null;
        if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
            log.warn("Locale name " + localeName + " is not valid - ignoring");
        }
        if (locale == null) {
            locale = pageContext.getRequest().getLocale();
        }
        jstran.setLocale(locale);
        jstran.toJS(cst, (Writer)pageContext.getOut());
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    public void setName(String name) {
        this.ID = name;
    }

    public String getName() {
        return this.ID;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setRepo(String repo) {
        this.repo = repo;
    }

    public String getRepo() {
        return this.repo;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }
}

