/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.TestRunnerSelenium;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.log.Logger;
import java.io.File;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;

public class TestRunnerHTMLLauncher
extends HTMLLauncher {
    private TestRunnerSelenium selenium;
    private TestResult result;
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : System.getProperty("java.io.tmpdir");
    private static Logger log = new Logger(TestRunnerHTMLLauncher.class.getName());

    public TestRunnerHTMLLauncher(SeleniumServer remoteControl, TestRunnerSelenium selenium, TestResult result) {
        super(remoteControl);
        this.selenium = selenium;
        this.result = result;
    }

    protected void sleepTight(long timeoutInMs) {
        super.sleepTight(timeoutInMs);
        TestRunnerConfiguration config = TestRunner.getConfiguration();
        if (config.shouldCaptureScreenshot()) {
            try {
                File tmpDir = new File(TestRunnerHTMLLauncher.tmpDir);
                String prefix = Utils.getUnqualifiedFileName(this.result.getTestFile(), true) + "-";
                String imageFile = File.createTempFile(prefix, ".png", tmpDir).getCanonicalPath();
                this.selenium.captureScreenshot(imageFile);
                this.result.setImageSize(new File(imageFile).length());
                this.result.setImageFile(imageFile);
            }
            catch (Exception e) {
                log.error((Object)("encountered exception trying to add screenshot for test " + this.result.getTestFile() + " #" + this.result.getTestNumber() + ": "), (Throwable)e);
            }
        }
    }
}

