/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.DetailViewParser;
import com.isomorphic.autotest.SeleniumServerHelper;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerHTMLLauncher;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestRunnerSelenium;
import com.isomorphic.autotest.TestSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class TestRunnerHelper
extends ConfiguredBase {
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    protected static final String GET_ACTIVE_WINDOW = "selenium.browserbot.getCurrentWindow()";
    protected static final String TESTRUNNER_OBJECT = "isc.TestRunner.getSingletonInstance()";
    protected static final String EXTRACT_TESTRUNNER_OBJECT = "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner";
    protected static final String EXTRACT_TESTCONFIG_OBJECT = "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner.testConfig";
    public static final String DETAILS_SEPARATOR = "ISC_DEVELOPER_MESSAGES: ";
    private static Logger log = new Logger(TestRunnerHelper.class.getName());

    public static void testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] scripts, boolean batchRun, TestCallback callback) {
        List<String> testFiles;
        SeleniumServerHelper seleniumServerHelper = SeleniumServerHelper.getInstance();
        seleniumServerHelper.startSeleniumServer();
        String testRootPath = config.getTestRoot(null);
        if (runUsualTests && (testFiles = ((TestRunnerLauncher)config).getTestScripts(testRootPath, scripts, "\\.*\\.test(\\.(jsp|isc|html))?$")) != null && testFiles.size() > 0) {
            TestRunnerHelper.processUsualTests(testFiles, browser, callback, testRootPath, batchRun);
        }
        if (runSelenium && (testFiles = ((TestRunnerLauncher)config).getTestScripts(testRootPath, scripts, "\\.*\\.rctest(\\.(jsp|isc|html))?$")) != null && testFiles.size() > 0) {
            TestRunnerHelper.processSeleniumTests(testFiles, browser, callback, seleniumServerHelper, testRootPath);
        }
        seleniumServerHelper.stopSeleniumServer();
    }

    protected static void processSeleniumTests(List testFiles, String browser, TestCallback callback, SeleniumServerHelper seleniumServerHelper, String testRootPath) {
        String browserURL = config.getHttpBaseURL(null);
        for (Object object : testFiles) {
            try {
                TestCaseResults tcr = TestRunnerHelper.testRctest(browserURL, testRootPath, (String)object, browser, seleniumServerHelper);
                callback.onTestResults(tcr);
            }
            catch (IOException e) {
                log.error((Object)("Problems with selenium test: " + object), (Throwable)e);
            }
        }
    }

    protected static void processUsualTests(List testFiles, String browser, TestCallback callback, String testRootPath, boolean batch) {
        if (!"localhost".equals(config.getHttpTarget())) {
            log.warn((Object)"Attempting to run .test TestRunner.js tests on a remote machine. This is unpredictable because the list of tests to run is generated locally, yet the files are then loaded by the remote browser.  If the two hiearchies differ, tests may not load and may time out.");
        }
        if (batch) {
            String browserURL = config.getHttpBaseURL(null);
            String fileRootPath = config.getFileRoot();
            int port = SeleniumServerHelper.getInstance().getSeleniumPort();
            TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, browserURL);
            selenium.start();
            for (Object object : testFiles) {
                String name = ((String)object).substring(testRootPath.length() + 1);
                String filePath = ((String)object).substring(fileRootPath.length() + 1);
                TestSpecifier ts = new TestSpecifier(browserURL + filePath, name);
                TestCaseResults tcr = TestRunnerHelper.test(ts, browser, (Selenium)selenium, null, true);
                if (tcr != null) {
                    callback.onTestResults(tcr);
                    continue;
                }
                TestRunnerHelper.processUsualTest((String)object, browser, callback, testRootPath);
            }
            selenium.stop();
        } else {
            for (Object object : testFiles) {
                TestRunnerHelper.processUsualTest((String)object, browser, callback, testRootPath);
            }
        }
    }

    public static List<TestCaseResults> testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] scripts, boolean batchRun) {
        final ArrayList<TestCaseResults> result = new ArrayList<TestCaseResults>();
        TestRunnerHelper.testAll(browser, runSelenium, runUsualTests, scripts, batchRun, new TestCallback(){

            @Override
            public void onTestResults(TestCaseResults testCaseResults) {
                result.add(testCaseResults);
            }
        });
        return result;
    }

    protected static void processUsualTest(String testFile, String browser, TestCallback callback, String testRootPath) {
        String browserURL = config.getHttpBaseURL(null);
        String fileRootPath = config.getFileRoot();
        int port = SeleniumServerHelper.getInstance().getSeleniumPort();
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, browserURL);
        selenium.start();
        String name = testFile.substring(testRootPath.length() + 1);
        String filePath = testFile.substring(fileRootPath.length() + 1);
        TestSpecifier ts = new TestSpecifier(browserURL + filePath, name);
        TestCaseResults tcr = TestRunnerHelper.test(ts, browser, (Selenium)selenium, null, false);
        callback.onTestResults(tcr);
        selenium.stop();
    }

    public static TestCaseResults testRctest(String browserURL, String filePathPrefix, String filePath, String browser, SeleniumServerHelper seleniumServerHelper) throws IOException {
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        SeleniumServer server = seleniumServerHelper.getSeleniumServer();
        int serverPort = server.getConfiguration().getPortDriversShouldContact();
        File tmpDir = new File(TestRunnerHelper.tmpDir);
        File testOrig = new File(filePath);
        File testCopy = File.createTempFile(Utils.getUnqualifiedFileName(filePath, true), ".rctest.html", tmpDir);
        FileUtils.copyFile((File)testOrig, (File)testCopy);
        ISCFile templateFile = new ISCFile(config.getSeleniumTemplateFile());
        InputStream templateStream = templateFile.getInputStream();
        String templateData = IOUtils.toString((InputStream)templateStream);
        IOUtils.closeQuietly((InputStream)templateStream);
        String testFilePath = Utils.getSeleniumFilePath(testCopy.getName(), serverPort);
        templateData = templateData.replace("{url}", testFilePath);
        File suite = new File(tmpDir, "suite.html");
        server.addNewStaticContent(suite.getParentFile());
        FileWriter fw = new FileWriter(suite);
        IOUtils.write((String)templateData, (Writer)fw);
        fw.flush();
        IOUtils.closeQuietly((Writer)fw);
        String suiteURL = Utils.getSeleniumFilePath(suite.getName(), serverPort);
        String filename = Utils.getTestName(filePath, filePathPrefix);
        if (launcher.shouldMaximizeBrowser()) {
            suiteURL = Utils.addURLArgument(suiteURL, "maximize=true");
        }
        if (launcher.shouldSaveMessages()) {
            suiteURL = Utils.addURLArgument(suiteURL, "addMessages=true");
        }
        File outputFile = new File(tmpDir, "test.out.html");
        int timeout = config.getSeleniumTimeout();
        TestCaseResults results = new TestCaseResults();
        results.setStartTime(new Date());
        results.setTestName(filename);
        TestResult res = new TestResult();
        res.setStartTime(results.getStartTime());
        res.setTestFile(filename);
        res.setTestNumber(1);
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", serverPort, browser, browserURL);
        TestRunnerHTMLLauncher l = new TestRunnerHTMLLauncher(server, selenium, res);
        try {
            String status = l.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeout, launcher.shouldMaximizeBrowser() || launcher.shouldCaptureScreenshot());
            results.setEndTime(new Date());
            res.setEndTime(results.getEndTime());
            res.setResult("PASSED".equals(status) ? "success" : "failure");
            HTMLTestResults htr = l.getResults();
            StringWriter sw = new StringWriter();
            htr.write((Writer)sw);
            res.setContent(StringUtils.substringBetween((String)sw.toString(), (String)"<pre>", (String)"</pre>"));
            sw.close();
        }
        catch (IOException e) {
            log.error((Object)"test suite cannot be run", (Throwable)e);
        }
        catch (SeleniumCommandTimedOutException te) {
            res.setResult("timeout");
            results.setEndTime(new Date());
            res.setEndTime(results.getEndTime());
            res.setDetails("TestCase results have not appeared after " + timeout + " seconds");
        }
        testCopy.delete();
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        testResults.add(res);
        results.setTestResults(testResults);
        return results;
    }

    public static TestCaseResults test(TestSpecifier specifier, String browser, Selenium selenium, ShowcaseSpecifier showcase, boolean batch) {
        TestCaseResults results = new TestCaseResults();
        results.setTestName(specifier.getTestName());
        Date testStartTime = new Date();
        try {
            specifier.run(selenium);
            int timeout = TestRunnerHelper.getTestSuiteTimeout(showcase == null, selenium);
            if (batch && showcase == null && TestRunnerHelper.shouldUseSeparateBrowser(selenium)) {
                return null;
            }
            boolean success = TestRunnerHelper.configureBrowserAndWaitForElementPresent(selenium, "scLocator=//DetailViewer[ID='isc_AutoTest_DetailViewer']", timeout);
            Date testEndTime = new Date();
            if (success) {
                String html = selenium.getHtmlSource();
                try {
                    List<Map<String, String>> testResults = DetailViewParser.parse(html);
                    ArrayList<TestResult> trs = new ArrayList<TestResult>();
                    boolean saveMessages = config.shouldSaveMessages();
                    int testNumber = 0;
                    for (Map<String, String> testData : testResults) {
                        ++testNumber;
                        TestResult tr = new TestResult();
                        tr.setStartTime(testStartTime);
                        tr.setEndTime(testEndTime);
                        tr.setResult(testData.get("result"));
                        tr.setDescription(testData.get("description"));
                        tr.setDetails(testData.get("detail"));
                        tr.setTestFile(specifier.getTestName());
                        tr.setTestNumber(testNumber);
                        if (saveMessages) {
                            String messages = showcase != null ? Utils.getDeveloperConsoleMessages(selenium) : TestRunnerHelper.getMessagesForTest(selenium, testNumber);
                            tr.setMessages(messages);
                        }
                        trs.add(tr);
                    }
                    results.setTestResults(trs);
                }
                catch (Exception e) {
                    log.error((Object)"Parsing detail viewer data failed:", (Throwable)e);
                    try {
                        results.setUnparsableResponse(DetailViewParser.getDetailViewerHtml(html));
                    }
                    catch (Exception e2) {
                        results.setUnparsableResponse(html);
                    }
                }
            } else {
                results.setTimeoutError(true);
                results.setStartTime(testStartTime);
                results.setEndTime(testEndTime);
                results.setTimeoutInSeconds(timeout);
                String report = ShowcaseSpecifier.getPartialReportForTimedoutTest(selenium, showcase);
                results.setPartialReport(report);
            }
            specifier.complete(selenium);
        }
        catch (SeleniumException se) {
            log.error((Object)"Selenium error: ", (Throwable)se);
            results.setStartTime(testStartTime);
            results.setEndTime(new Date());
            results.setSeleniumError(se.getMessage());
        }
        return results;
    }

    protected static String getMessagesForTest(Selenium selenium, int naturalIndex) {
        return Utils.getEvalWithTry(selenium, "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner.getMessages(" + (naturalIndex - 1) + ")");
    }

    protected static boolean waitForElementPresent(Selenium selenium, String element, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        do {
            try {
                if (selenium.isElementPresent(element)) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Utils.sleep(500);
        } while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000));
        return false;
    }

    protected static boolean waitForTestConfigPresent(Selenium selenium, int timeoutInSeconds) {
        String jsQuery = "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner.testConfig != null";
        long startTime = System.currentTimeMillis();
        do {
            try {
                if (Boolean.parseBoolean(Utils.getEvalWithTry(selenium, jsQuery))) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Utils.sleep(250);
        } while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000));
        return false;
    }

    protected static boolean shouldMaximizeBrowser(Selenium selenium) {
        String testConfigJs = EXTRACT_TESTCONFIG_OBJECT;
        return Boolean.parseBoolean(Utils.getEvalWithTry(selenium, testConfigJs + ".maximize"));
    }

    protected static boolean shouldUseSeparateBrowser(Selenium selenium) {
        String testConfigJs = EXTRACT_TESTCONFIG_OBJECT;
        return Boolean.parseBoolean(Utils.getEvalWithTry(selenium, testConfigJs + ".separate"));
    }

    protected static boolean configureBrowserAndWaitForElementPresent(Selenium selenium, String element, int timeoutInSeconds) {
        boolean maximize = TestRunnerHelper.shouldMaximizeBrowser(selenium);
        if (maximize) {
            Utils.setBrowserMaximization(selenium, true);
        }
        boolean found = TestRunnerHelper.waitForElementPresent(selenium, element, timeoutInSeconds);
        if (maximize) {
            Utils.setBrowserMaximization(selenium, false);
        }
        return found;
    }

    public static int getTestSuiteTimeout(boolean isDotTestSuite, Selenium selenium) {
        String testConfigJs;
        String testTimeout;
        if (!isDotTestSuite) {
            return config.getSeleniumTimeout();
        }
        int timeout = config.getDotTestTimeout();
        if (!TestRunnerHelper.waitForTestConfigPresent(selenium, 10)) {
            log.error((Object)"Attempt to read TestRunner.testConfig timed out. Selenium will not be able to apply any custom test configuration.");
        }
        if ((testTimeout = Utils.getEvalWithTry(selenium, (testConfigJs = EXTRACT_TESTCONFIG_OBJECT) + ".timeout")) == null || "null".equalsIgnoreCase(testTimeout)) {
            return timeout;
        }
        if (timeout < Integer.parseInt(testTimeout) / 1000) {
            timeout = Integer.parseInt(testTimeout) / 1000;
        }
        return timeout;
    }

    public static TestCaseResults test(String url, String browser) {
        SeleniumServerHelper seleniumServerHelper = SeleniumServerHelper.getInstance();
        seleniumServerHelper.startSeleniumServer();
        int port = seleniumServerHelper.getSeleniumPort();
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, config.getHttpBaseURL(null));
        selenium.start();
        TestCaseResults result = TestRunnerHelper.test(new TestSpecifier(url, null), browser, (Selenium)selenium, null, false);
        selenium.stop();
        seleniumServerHelper.stopSeleniumServer();
        return result;
    }

    public static interface TestCallback {
        public void onTestResults(TestCaseResults var1);
    }
}

