/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.annotations.DataSourceAnnotations;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.RelationFieldInfo;
import com.isomorphic.datasource.TextMatchStyle;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.hibernate.HibernateDSGenerator;
import com.isomorphic.hibernate.HibernateTransaction;
import com.isomorphic.interfaces.IHibernateDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCManagerCompletionCallback;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.IdClass;
import org.apache.commons.collections.map.LinkedMap;
import org.hibernate.Criteria;
import org.hibernate.DuplicateMappingException;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.MappingNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.dialect.Cache71Dialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.Type;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDataSource
extends BasicDataSource
implements IHibernateDataSource,
RPCManagerCompletionCallback {
    private static Logger log = new Logger(HibernateDataSource.class.getName());
    private static List openSessions = new ArrayList();
    private static Object stillMapping = new Object();
    public static final Character ESCAPE_CHARACTER = Character.valueOf('~');
    protected static Configuration hibernateConfig;
    protected static SessionFactory sessionFactory;
    protected static boolean springConfigured;
    private static long count;
    private static List<Map> createTrace;
    protected Configuration localHibernateConfig;
    protected SessionFactory localSessionFactory;
    protected String entityName;
    protected Class beanClass;
    protected Class idClass;
    protected boolean strictSQLFiltering = false;
    protected long totalRows;
    protected String beanName;
    protected Map<String, String> fromBeans;
    protected Map<String, PropertyPath> pathAliases;
    protected Map<String, PropertyPath> usedPathAliases;
    protected Map<String, Object> extendedConfig;
    protected List<Map<String, Object>> extendedConfigFields;
    protected List<DSResponse> relatedUpdates;
    protected Boolean generateRelatedUpdates;
    protected Map<String, DSField> additionalFields;
    Transaction inlineTransaction = null;
    Transaction currentTransaction = null;
    private static final List supportedAggregationFunctions;
    private DSRequest downloadDsRequest;

    public static long getCreationCount() {
        return count;
    }

    public static void dumpCreateTrace(String dsName, String filename, boolean dumpStack, boolean dumpConfig) throws Exception {
        if (!config.getBoolean((Object)"datasources.hibernate.trace.creation", false)) {
            return;
        }
        HibernateDataSource.dumpCreateTrace(createTrace, (String)dsName, (String)filename, (boolean)dumpStack, (boolean)dumpConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        Object idClassProperty;
        Object fields;
        ++count;
        if (config.getBoolean((Object)"datasources.hibernate.trace.creation", false)) {
            LinkedMap map = new LinkedMap();
            map.put("time", System.currentTimeMillis());
            map.put("ID", theConfig.get("ID"));
            map.put("config", theConfig);
            map.put("stack", new Exception().getStackTrace());
        }
        Object autoDerive = theConfig.get("autoDeriveSchema");
        boolean hadSchemaBean = false;
        String schemaBean = (String)theConfig.get("schemaBean");
        if (schemaBean == null) {
            schemaBean = (String)theConfig.get("beanClassName");
        } else {
            hadSchemaBean = true;
        }
        if (autoDerive != null && autoDerive.toString().equals("true") || hadSchemaBean) {
            String ID = (String)theConfig.get("ID") + "_inheritsFrom";
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile((String)ID);
            if (dsObject instanceof DataSource) {
                this.autoDeriveDS = (DataSource)dsObject;
                if (theConfig.get("beanClassName") == null) {
                    theConfig.put("beanClassName", this.autoDeriveDS.getConfig().get("beanClassName"));
                }
                if (theConfig.get("idClassName") == null) {
                    theConfig.put("idClassName", this.autoDeriveDS.getConfig().get("idClassName"));
                }
            } else {
                ID = (String)theConfig.get("ID");
                if (schemaBean != null) {
                    this.autoDeriveDS = HibernateDSGenerator.fromMapping(schemaBean, ID, true, theConfig);
                    if (this.autoDeriveDS == null) {
                        log.warn((Object)("Declared schemaBean '" + theConfig.get("schemaBean") + "' was not found among existing Hibernate mappings. " + "Falling back to examining the POJO."));
                    } else {
                        if (theConfig.get("beanClassName") == null) {
                            theConfig.put("beanClassName", schemaBean);
                        }
                        if (theConfig.get("idClassName") == null) {
                            theConfig.put("idClassName", this.autoDeriveDS.getConfig().get("idClassName"));
                        }
                    }
                }
                if (this.autoDeriveDS == null && schemaBean != null) {
                    Object dsConfigFromJavaClass = HibernateDSGenerator.getConfigFromJavaClass(schemaBean, ID, true, theConfig);
                    if (dsConfigFromJavaClass != null && dsConfigFromJavaClass instanceof Map) {
                        this.autoDeriveDS = DataSource.fromConfig((Map)((Map)dsConfigFromJavaClass), null);
                        DataStructCache.addCachedObjectWithNoConfigFile((String)(ID + "_inheritsFrom"), (Object)this.autoDeriveDS);
                        if (theConfig.get("beanClassName") == null) {
                            theConfig.put("beanClassName", schemaBean);
                        }
                        if (theConfig.get("idClassName") == null) {
                            theConfig.put("idClassName", this.autoDeriveDS.getConfig().get("idClassName"));
                        }
                    } else {
                        log.warn((Object)("Declared schemaBean '" + schemaBean + "' was not found among existing Hibernate mappings. " + "Falling back to examining the JDBC metadata."));
                    }
                }
                if (this.autoDeriveDS == null) {
                    String tableName = (String)theConfig.get("tableName");
                    if (tableName == null) {
                        tableName = (String)theConfig.get("ID");
                    }
                    tableName = tableName + "_inheritsFrom";
                    String schema = (String)theConfig.get("schema");
                    fields = theConfig.get("fields");
                    if (!(fields instanceof Map)) {
                        fields = DataTools.indexOnProperty((Collection)((List)fields), (String)"name");
                    }
                    this.autoDeriveDS = HibernateDSGenerator.fromTable(tableName, schema, ID, true, (Map)fields);
                }
            }
            if (this.autoDeriveDS == null) {
                throw new Exception("Unable to create autoDerive datasource for DataSource " + theConfig.get("ID") + ". 'schemaBean' did not refer to a valid " + "mapped Hibernate bean, or 'tableName' did not refer to an existing " + "table, or both.");
            }
            theConfig.put("autoDeriveSchema", true);
        }
        this.idClass = (idClassProperty = theConfig.get("idClassName")) != null ? Reflection.classForName((String)idClassProperty.toString()) : null;
        super.init(theConfig, dsRequest);
        this.initConfigAndSessionFactory();
        String entityNameFromConfig = (String)this.dsConfig.get("entityName");
        String beanClassName = (String)this.dsConfig.get("beanClassName");
        this.entityName = entityNameFromConfig;
        if (this.entityName == null) {
            this.entityName = beanClassName;
            if (this.entityName == null) {
                this.entityName = this.getName();
            } else {
                this.beanClass = Reflection.classForName((String)beanClassName);
            }
        }
        this.beanName = this.entityName.contains(".") ? "_" + this.entityName.substring(this.entityName.lastIndexOf(".") + 1) : "_" + this.entityName;
        Configuration hbConfig = this.getHibernateConfig();
        fields = stillMapping;
        synchronized (fields) {
            if (hbConfig.getClassMapping(this.entityName) == null) {
                try {
                    if (beanClassName == null) {
                        if (springConfigured) {
                            throw new Exception("Entity mapping '" + this.entityName + "' not found.  Your Hibernate configuration " + "is being provided by Spring bean '" + config.getString((Object)"hibernate.config.bean") + "' - you need to ensure that this bean contains atrributes to describe your " + "mappings, or set the 'configLocation' attribute to point it at a .cfg.xml " + "file that defines your mappings.  Note that 'beanless mode' (where we " + "automatically bind missing entities to a HashMap at runtime) is not supported " + "where Hibernate is configured via Spring");
                        }
                        log.info((Object)("dynamically binding entity: " + this.entityName));
                        Reader reader = null;
                        if (theConfig.get("xmlFromConfig") != null) {
                            reader = new StringReader(this.toXML(theConfig));
                        } else {
                            String dsConfigFile = DataStructCache.getInstanceFile((String)this.dsName, (String)"datasources", (String)"DS");
                            if (dsConfigFile != null) {
                                reader = new ISCFile(dsConfigFile).getReader();
                            }
                        }
                        StringWriter sw = new StringWriter();
                        if (reader != null) {
                            XML.applyXSLT((Reader)reader, (Reader)new ISCFile(config.getPath("systemDir") + "/schema/hibernateTranslator.xsl").getReader(), (Writer)sw);
                            hbConfig.addDocument(XML.parseXML((InputSource)new InputSource(new StringReader(sw.toString()))));
                        }
                    } else {
                        try {
                            hbConfig.addClass(this.beanClass);
                        }
                        catch (MappingNotFoundException mnfe) {
                            hbConfig.addAnnotatedClass(this.beanClass);
                        }
                    }
                    sessionFactory = hbConfig.buildSessionFactory();
                }
                catch (DuplicateMappingException duplicateMappingException) {
                    // empty catch block
                }
            }
        }
        try {
            this.extendedConfig = HibernateDSGenerator.getConfigFromMapping(this.entityName, (String)theConfig.get("ID"), false, true);
            this.extendedConfigFields = (List)this.extendedConfig.get("fields");
            if (this.extendedConfigFields == null) {
                this.extendedConfigFields = new ArrayList<Map<String, Object>>();
            }
        }
        catch (Exception ex) {
            this.extendedConfig = null;
            this.extendedConfigFields = null;
        }
        if (this.dsConfig.containsKey("_inheritsFrom")) {
            this.dsName = this.dsName + "_inheritsFrom";
            this.dsConfig.put("ID", this.dsName);
            this.dsConfig.remove("_inheritsFrom");
        }
        this.pathAliases = new HashMap<String, PropertyPath>();
        this.usedPathAliases = new HashMap<String, PropertyPath>();
        this.initAliases();
    }

    public static Dialect getDialect(SessionFactory sessionFactory) {
        try {
            Method method = Reflection.findMethod((Object)sessionFactory, (String)"getDialect");
            return (Dialect)method.invoke((Object)sessionFactory, (Object[])null);
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to acquire Hibernate dialect. Using default.", (Throwable)ex);
            return Dialect.getDialect();
        }
    }

    public Configuration getHibernateConfig() throws Exception {
        this.initConfigAndSessionFactory();
        if (this.localHibernateConfig != null) {
            return this.localHibernateConfig;
        }
        return hibernateConfig;
    }

    public SessionFactory getSessionFactory() throws Exception {
        this.initConfigAndSessionFactory();
        if (this.localSessionFactory != null) {
            return this.localSessionFactory;
        }
        return sessionFactory;
    }

    public static Configuration getStaticHibernateConfig() throws Exception {
        HibernateDataSource.initStaticConfigAndSessionFactory();
        return hibernateConfig;
    }

    public static SessionFactory getStaticSessionFactory() throws Exception {
        HibernateDataSource.initStaticConfigAndSessionFactory();
        return sessionFactory;
    }

    private synchronized void initConfigAndSessionFactory() throws Exception {
        if (this.localHibernateConfig == null && this.dsConfig.get("configBean") != null) {
            log.debug((Object)("Obtaining local Hibernate config for DataSource '" + this.getName() + "' via Spring bean '" + this.dsConfig.get("configBean") + "'."));
            HashMap<String, String> serverObjectConfig = new HashMap<String, String>();
            serverObjectConfig.put("bean", "&" + this.dsConfig.get("configBean"));
            serverObjectConfig.put("lookupStyle", "spring");
            RequestContext context = new RequestContext();
            context.servletContext = ISCFile.servletContext;
            ServerObject serverObject = new ServerObject(serverObjectConfig, context, "Initializing local HibernateDataSource config");
            if (serverObject == null) {
                log.error((Object)("Attempted lookup of DataSource-specific Hibernate config for DataSource '" + this.getName() + "' failed; the returned object was " + "null.  We will use the system-level config instead."));
            } else {
                Class factoryBeanClassV3 = null;
                Class factoryBeanClassV4 = null;
                try {
                    factoryBeanClassV3 = Reflection.classForName((String)"org.springframework.orm.hibernate3.LocalSessionFactoryBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                try {
                    factoryBeanClassV4 = Reflection.classForName((String)"org.springframework.orm.hibernate4.LocalSessionFactoryBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (factoryBeanClassV3 == null && factoryBeanClassV4 == null) {
                    log.warn((Object)"Found neither org.springframework.orm.hibernate3.LocalSessionFactoryBean nor org.springframework.orm.hibernate4.LocalSessionFactoryBean class when attempting to obtain Hibernate config from Spring - is Spring correctly installed and configured?");
                }
                Object factoryBean = serverObject.getInstance();
                if (!(factoryBeanClassV3 != null && factoryBeanClassV3.isAssignableFrom(factoryBean.getClass()) || factoryBeanClassV4 != null && factoryBeanClassV4.isAssignableFrom(factoryBean.getClass()))) {
                    log.warn((Object)"Factory bean is not an instance of either org.springframework.orm.hibernate3.LocalSessionFactoryBean or org.springframework.orm.hibernate4.LocalSessionFactoryBean class - is Spring correctly installed and configured?");
                }
                try {
                    Method method = Reflection.findMethod((Object)factoryBean, (String)"getConfiguration");
                    this.localHibernateConfig = (Configuration)method.invoke(factoryBean, null);
                    method = Reflection.findMethod((Object)factoryBean, (String)"getObject");
                    this.localSessionFactory = (SessionFactory)method.invoke(factoryBean, null);
                    springConfigured = true;
                }
                catch (Exception ex) {
                    if (ex instanceof NoSuchMethodException && factoryBeanClassV4 != null && factoryBeanClassV4.isAssignableFrom(factoryBean.getClass()) && ex.getMessage().contains("getConfiguration")) {
                        log.error((Object)"This Spring version does not have method getConfiguration() in org.springframework.orm.hibernate4.LocalSessionFactoryBean class. Upgrade Spring minimum to 3.1.1 version.");
                    }
                    throw new Exception("Failed to lookup Hibernate sessionFactory for DataSource '" + this.getName() + "'via Spring bean " + serverObjectConfig.get("bean") + ".", ex);
                }
            }
        }
        HibernateDataSource.initStaticConfigAndSessionFactory();
    }

    private static synchronized void initStaticConfigAndSessionFactory() throws Exception {
        if (hibernateConfig == null) {
            if (config.getString((Object)"hibernate.config.lookupStyle") != null) {
                log.debug((Object)("Looking up session factory with lookup style '" + config.getString((Object)"hibernate.config.lookupStyle") + "'"));
                HashMap<String, String> serverObjectConfig = new HashMap<String, String>();
                serverObjectConfig.put("attributeName", config.getString((Object)"hibernate.config.attributeName"));
                serverObjectConfig.put("attributeScope", config.getString((Object)"hibernate.config.attributeScope"));
                serverObjectConfig.put("bean", "&" + config.getString((Object)"hibernate.config.bean"));
                serverObjectConfig.put("className", config.getString((Object)"hibernate.config.className"));
                serverObjectConfig.put("lookupStyle", config.getString((Object)"hibernate.config.lookupStyle"));
                RequestContext context = new RequestContext();
                context.servletContext = ISCFile.servletContext;
                ServerObject serverObject = new ServerObject(serverObjectConfig, context, "Initializing HibernateDataSource");
                if (serverObject.getInstance() == null) {
                    log.error((Object)("Attempted lookup of Hibernate config with lookupStyle '" + serverObjectConfig.get("lookupStyle") + "' failed; the returned " + "object was null.  Attempting to use a .cfg.xml file instead."));
                } else {
                    if (config.getString((Object)"hibernate.config.lookupStyle").equals("spring")) {
                        Object factoryBean;
                        Class factoryBeanClassV3 = null;
                        Class factoryBeanClassV4 = null;
                        try {
                            factoryBeanClassV3 = Reflection.classForName((String)"org.springframework.orm.hibernate3.LocalSessionFactoryBean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        try {
                            factoryBeanClassV4 = Reflection.classForName((String)"org.springframework.orm.hibernate4.LocalSessionFactoryBean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (factoryBeanClassV3 == null && factoryBeanClassV4 == null) {
                            log.warn((Object)"Found neither org.springframework.orm.hibernate3.LocalSessionFactoryBean nor org.springframework.orm.hibernate4.LocalSessionFactoryBean class when attempting to obtain Hibernate config from Spring - is Spring correctly installed and configured?");
                        }
                        if (!factoryBeanClassV3.isAssignableFrom((factoryBean = serverObject.getInstance()).getClass()) && !factoryBeanClassV4.isAssignableFrom(factoryBean.getClass())) {
                            log.warn((Object)"Factory bean is not an instance of either org.springframework.orm.hibernate3.LocalSessionFactoryBean or org.springframework.orm.hibernate4.LocalSessionFactoryBean class - is Spring correctly installed and configured?");
                        }
                        try {
                            Method method = Reflection.findMethod((Object)factoryBean, (String)"getConfiguration");
                            hibernateConfig = (Configuration)method.invoke(factoryBean, null);
                            method = Reflection.findMethod((Object)factoryBean, (String)"getObject");
                            sessionFactory = (SessionFactory)method.invoke(factoryBean, null);
                            springConfigured = true;
                        }
                        catch (Exception ex) {
                            if (ex instanceof NoSuchMethodException && factoryBeanClassV4 != null && factoryBeanClassV4.isAssignableFrom(factoryBean.getClass()) && ex.getMessage().contains("getConfiguration")) {
                                log.error((Object)"This Spring version does not have method getConfiguration() in org.springframework.orm.hibernate4.LocalSessionFactoryBean class. Upgrade Spring minimum to 3.1.1 version.");
                            }
                            throw new Exception("Failed to lookup Hibernate sessionFactory via Spring bean " + serverObjectConfig.get("bean") + ".", ex);
                        }
                    }
                    if (serverObject.getInstance() instanceof Configuration) {
                        hibernateConfig = (Configuration)serverObject.getInstance();
                        sessionFactory = hibernateConfig.buildSessionFactory();
                    }
                }
            }
            if (hibernateConfig == null) {
                String configPath = config.getPath("hibernate.config");
                log.debug((Object)("Instantiating Hibernate config and session factory from file " + configPath));
                ISCFile configFile = new ISCFile(configPath);
                hibernateConfig = new Configuration().configure(XML.parseXML((InputSource)new InputSource(configFile.getInputStream())));
                sessionFactory = hibernateConfig.buildSessionFactory();
            }
        }
    }

    private static Map replaceCriteriaValuesWithVariableNames(Map criteria) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set keys = criteria.keySet();
        for (String key : keys) {
            map.put(key, ":" + key);
        }
        return map;
    }

    public List getFieldNames(boolean dropIgnored) {
        ArrayList<String> fieldNames = new ArrayList<String>(super.getFieldNames(dropIgnored));
        if (this.additionalFields != null) {
            fieldNames.addAll(this.additionalFields.keySet());
        }
        return fieldNames;
    }

    public DSField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        DSField field = super.getField(fieldName);
        if (field == null && this.additionalFields != null) {
            field = this.additionalFields.get(fieldName);
        }
        return field;
    }

    public String getAliasedPropertyName(String fieldName) {
        DSField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        String beanPropertyName = field.getBeanPropertyName();
        if (beanPropertyName.indexOf(46) > 0) {
            String pathPart = beanPropertyName.substring(0, beanPropertyName.lastIndexOf(46));
            if (this.fromBeans.containsKey(this.beanName + "." + pathPart)) {
                return this.fromBeans.get(this.beanName + "." + pathPart) + beanPropertyName.substring(beanPropertyName.lastIndexOf(46));
            }
        }
        return this.beanName + "." + beanPropertyName;
    }

    protected boolean isFieldPersistent(String fieldName) {
        String xPath;
        if (fieldName == null) {
            return false;
        }
        if (this.extendedConfigFields == null) {
            return true;
        }
        for (Map<String, Object> field : this.extendedConfigFields) {
            if (!fieldName.equals(field.get("name"))) continue;
            return !Boolean.TRUE.equals(field.get("extIsFinal")) && !Boolean.TRUE.equals(field.get("extIsStatic")) && !Boolean.TRUE.equals(field.get("extIsTransient"));
        }
        if (this.relationFields.get(fieldName) != null) {
            return true;
        }
        DSField field = this.getField(fieldName);
        return field != null && (xPath = field.getValueXPath()) != null;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    /*
     * WARNING - void declaration
     */
    protected DSResponse processRequest(DSRequest req) throws Exception {
        List keysMissing;
        String operationType;
        this.fromBeans = new HashMap<String, String>();
        req.setFreeOnExecute(false);
        if (req != null && req.getIncludeFrom() != null && this.getName().equals(req.getDataSourceName())) {
            for (IncludeFromDefinition incFrom : req.getIncludeFrom()) {
                if (!incFrom.isDynamic() || this.getField(incFrom.getThisFieldName()) != null) continue;
                if (this.additionalFields == null) {
                    this.additionalFields = new HashMap<String, DSField>();
                }
                this.additionalFields.put(incFrom.getThisFieldName(), incFrom.getThisField());
            }
        }
        if (HibernateDataSource.isFetch((String)(operationType = req.getOperationType())) || HibernateDataSource.isAdd((String)operationType) || HibernateDataSource.isRemove((String)operationType) || HibernateDataSource.isUpdate((String)operationType) || HibernateDataSource.isCustom((String)operationType) || operationType.equals("replace")) {
            DSResponse validationFailure = this.validateDSRequest(req);
            if (validationFailure != null) {
                return validationFailure;
            }
        } else {
            return super.execute(req);
        }
        req.setRequestStarted(true);
        Map opConfig = req.operationConfig();
        String opType = req.getOperationType();
        if (log.isInfoEnabled()) {
            List values = req.getValueSets();
            JSTranslater jsTrans = JSTranslater.instance().enablePrettyPrinting(false);
            String valuesString = "";
            if (values != null) {
                valuesString = values.size() == 1 ? "\tvalues: " + jsTrans.toJS(values.get(0)) : "\tvalues: " + values.size() + " valueSets";
            }
            log.info((Object)("Performing " + opType + " operation with\n" + (req.constraints() != null ? "\tconstraints: " + req.constraints() : "") + (req.outputs() != null ? "\toutputs: " + req.outputs() : "") + (req.getRawCriteria() != null ? "\tcriteria: " + jsTrans.toJS(req.getRawCriteria()) : "") + valuesString));
        }
        if (HibernateDataSource.isAdd((String)opType) && (keysMissing = req.getMissingPrimaryKeysForAdd()).size() > 0) {
            throw new UpdateWithoutPKException("Criteria received from the client for add operation is missing the following non-sequence primary key fields: " + keysMissing.toString() + ". Either provide all primary " + "key fields that are not sequences, or set " + "allowMultiUpdate on the OperationBinding");
        }
        Transaction trx = null;
        Session session = null;
        if (this.shouldAutoJoinTransaction(req)) {
            trx = (Transaction)this.getTransactionObject(req);
            if (trx == null) {
                if (this.shouldAutoStartTransaction(req, false)) {
                    trx = this.getOrStartTransaction(req);
                } else {
                    this.inlineTransaction = trx = HibernateTransaction.startTransaction(null, this);
                }
                if (trx != null) {
                    req.setPartOfTransaction(true);
                }
            }
        } else {
            this.inlineTransaction = trx = HibernateTransaction.startTransaction(null, this);
        }
        this.currentTransaction = trx;
        session = HibernateTransaction.getTransactionSession(trx);
        this.usedPathAliases = new HashMap<String, PropertyPath>();
        this.generateRelatedUpdates = req.getGenerateRelatedUpdates();
        try {
            DSResponse dsResponse = new DSResponse((DataSource)this);
            dsResponse.setSuccess();
            Map operationBinding = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
            String customHQL = null;
            String customSQL = null;
            if (operationBinding != null) {
                customHQL = (String)operationBinding.get("customHQL");
                customSQL = (String)operationBinding.get("customSQL");
            }
            if (HibernateDataSource.isCustom((String)opType) && customHQL == null && customSQL == null) {
                log.warn((Object)("Operation '" + operationBinding.get("operationId") + "' on " + "DataSource '" + req.getDataSource().getName() + "' is of type 'custom', " + "but does not specify a 'customSQL' or 'customHQL' property. This is not " + "valid - 'custom' operations have no built-in behavior"));
                return dsResponse;
            }
            if (HibernateDataSource.isFetch((String)opType) || HibernateDataSource.isCustom((String)opType) && !"update".equals(operationBinding.get("sqlType"))) {
                List results = null;
                if (customHQL != null || customSQL != null) {
                    void var17_71;
                    boolean bl;
                    Map parameters = Velocity.getStandardContextMap((DSRequest)req);
                    Map criteriaNames = HibernateDataSource.replaceCriteriaValuesWithVariableNames(req.getCriteria());
                    parameters.put("criteria", criteriaNames);
                    parameters.put("where", criteriaNames);
                    Map valueNames = HibernateDataSource.replaceCriteriaValuesWithVariableNames(req.getValues());
                    parameters.put("values", valueNames);
                    Query q = null;
                    boolean bl2 = false;
                    Object var17_69 = null;
                    if (customHQL != null) {
                        String string = Velocity.evaluateAsString((String)customHQL, (Map)parameters, (String)opType, (DataSource)this, (boolean)true);
                        q = session.createQuery(string);
                        String[] stringArray = q.getReturnAliases();
                        if (stringArray != null && string.trim().toLowerCase().startsWith("select ")) {
                            int i;
                            String selectClause = string.trim().substring(7, string.trim().toLowerCase().indexOf(" from "));
                            Dialect dialect = HibernateDataSource.getDialect(this.getSessionFactory());
                            String[] fieldNames = new String[stringArray.length];
                            int inParens = 0;
                            int tokenStart = 0;
                            int token = 0;
                            boolean inQuotes = false;
                            for (i = 0; i < selectClause.length(); ++i) {
                                char c = selectClause.charAt(i);
                                if (c == '(' && !inQuotes) {
                                    ++inParens;
                                }
                                if (c == ')' && !inQuotes) {
                                    --inParens;
                                }
                                if (c == '\'') {
                                    boolean bl3 = inQuotes = !inQuotes;
                                }
                                if (c != ',' || inParens != 0 || inQuotes) continue;
                                fieldNames[token] = selectClause.substring(tokenStart, i).trim();
                                if (fieldNames[token].startsWith("`\"[")) {
                                    fieldNames[token] = fieldNames[token].substring("`\"[".length());
                                }
                                if (fieldNames[token].endsWith("`\"]")) {
                                    fieldNames[token] = fieldNames[token].substring(0, fieldNames[token].length() - "`\"]".length());
                                }
                                tokenStart = i + 1;
                                ++token;
                            }
                            if (stringArray.length > 0) {
                                fieldNames[token] = selectClause.substring(tokenStart).trim();
                                if (fieldNames[token].startsWith("`\"[")) {
                                    fieldNames[token] = fieldNames[token].substring("`\"[".length());
                                }
                                if (fieldNames[token].endsWith("`\"]")) {
                                    fieldNames[token] = fieldNames[token].substring(0, fieldNames[token].length() - "`\"]".length());
                                }
                            }
                            for (i = 0; i < stringArray.length; ++i) {
                                int field = -1;
                                try {
                                    field = Integer.parseInt(stringArray[i]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (field == -1) continue;
                                bl = true;
                                stringArray[i] = fieldNames[field].trim();
                                if (stringArray[i].indexOf(32) == -1 && stringArray[i].indexOf(43) == -1 && stringArray[i].indexOf(124) == -1 && stringArray[i].indexOf(38) == -1 && stringArray[i].indexOf(47) == -1 && stringArray[i].indexOf(42) == -1) continue;
                                log.warn((Object)("Found unlikely-looking field name '" + stringArray[i] + "' whilst parsing HQL query. If this is an expression," + " try giving it an alias"));
                            }
                        }
                        if (stringArray != null && !bl) {
                            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                        }
                    } else {
                        String string = Velocity.evaluateAsString((String)customSQL, (Map)parameters, (String)opType, (DataSource)this, (boolean)true);
                        q = session.createSQLQuery(string);
                        q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                    }
                    HibernateDataSource.attachNamedParameters(q, req.getCriteria());
                    HibernateDataSource.attachNamedParameters(q, req.getValues());
                    this.totalRows = -1L;
                    if (req.isPaged() && req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                        req.setBatchSize(req.getEndRow() - req.getStartRow());
                    }
                    results = q.list();
                    this.totalRows = results.size();
                    if (results != null && !results.isEmpty()) {
                        if (results.get(0).getClass().isArray()) {
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            for (Object e : results) {
                                arrayList.add(((Object[])e)[0]);
                            }
                            results = arrayList;
                        }
                        if (req.isPaged()) {
                            int n = (int)req.getStartRow();
                            int end = Math.min(results.size(), (int)req.getStartRow() + (int)req.getBatchSize()) - 1;
                            results = DataTools.arrayToList((Object[])results.toArray(), (int)n, (int)end);
                        }
                    }
                    if (var17_71 != null && bl) {
                        void var18_85;
                        boolean bl4 = false;
                        while (var18_85 < results.size()) {
                            Object[] values = (Object[])results.get((int)var18_85);
                            HashMap<void, Object> hashMap = new HashMap<void, Object>();
                            for (int j = 0; j < values.length; ++j) {
                                hashMap.put(var17_71[j], values[j]);
                            }
                            results.set((int)var18_85, hashMap);
                            ++var18_85;
                        }
                    }
                } else if ("criteria".equals(this.getProperty("queryVia"))) {
                    Criteria criteria = this.buildCriteria(req, session);
                    if (this.totalRows == 0L) {
                        results = new ArrayList();
                    } else {
                        List sortBy = req.getSortByFields();
                        for (String sortByField : sortBy) {
                            boolean bl;
                            DSField dSField = this.getField(sortByField.startsWith("-") ? sortByField.substring(1).trim() : sortByField);
                            if (dSField != null && dSField.get((Object)"customSQL") != null && (bl = dSField.get((Object)"customSQL").toString().toLowerCase().equals("true"))) continue;
                            if (sortByField.startsWith("-")) {
                                criteria.addOrder(Order.desc((String)this.getFieldHQLName(dSField)));
                                continue;
                            }
                            criteria.addOrder(Order.asc((String)this.getFieldHQLName(dSField)));
                        }
                        results = criteria.list();
                        if (results != null && !results.isEmpty() && results.get(0).getClass().isArray()) {
                            ArrayList<Object> resultObjects = new ArrayList<Object>();
                            for (Object e : results) {
                                resultObjects.add(((Object[])e)[0]);
                            }
                            results = resultObjects;
                        }
                    }
                } else {
                    Query[] queries = this.createQuery(req, session);
                    Query q = queries[0];
                    Query qCount = queries[1];
                    this.totalRows = -1L;
                    if (req.isPaged()) {
                        if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                            req.setBatchSize(req.getEndRow() - req.getStartRow());
                        }
                        if (qCount != null) {
                            Long rowCount = Long.parseLong(qCount.uniqueResult().toString());
                            this.totalRows = rowCount == null ? 0L : rowCount;
                            q.setFirstResult((int)req.getStartRow());
                            q.setMaxResults((int)req.getBatchSize());
                        }
                    }
                    results = null;
                    if (this.totalRows == 0L) {
                        results = new ArrayList();
                    } else {
                        results = q.list();
                        if (results != null && !results.isEmpty()) {
                            if (results.get(0).getClass().isArray()) {
                                ArrayList<Object> resultObjects;
                                if (req.getGroupFunctionFields() == null) {
                                    resultObjects = new ArrayList<Object>();
                                    for (Object e : results) {
                                        resultObjects.add(((Object[])e)[0]);
                                    }
                                    results = resultObjects;
                                } else {
                                    resultObjects = new ArrayList();
                                    ArrayList<Object> arrayList = new ArrayList<Object>();
                                    for (Object[] objectArray : results) {
                                        arrayList.add(objectArray[0]);
                                        Map record = this.getProperties(objectArray[0], null, true, true, null, null, req.getGroupFunctionFields());
                                        int n = 1;
                                        for (int i = req.getGroupFunctionFields().size() - 1; i >= 0; --i) {
                                            record.put(req.getGroupFunctionFields().get(i), objectArray[objectArray.length - n]);
                                            ++n;
                                        }
                                        resultObjects.add(record);
                                    }
                                    results = resultObjects;
                                    dsResponse.setBeanList(arrayList);
                                }
                            }
                            if (qCount == null && req.isPaged()) {
                                int start = (int)req.getStartRow();
                                int n = Math.min(results.size() + 1, (int)req.getStartRow() + (int)req.getBatchSize()) - 1;
                                results = DataTools.arrayToList((Object[])results.toArray(), (int)start, (int)n);
                            }
                        }
                    }
                }
                if (this.totalRows == -1L) {
                    this.totalRows = results.size();
                }
                dsResponse.setTotalRows(this.totalRows);
                long startRow = 0L;
                long endRow = 0L;
                if (this.totalRows != 0L) {
                    startRow = req.getStartRow();
                    endRow = startRow + (long)results.size();
                }
                dsResponse.setStartRow(startRow);
                dsResponse.setEndRow(endRow);
                dsResponse.setData(results);
            } else if (customSQL != null || customHQL != null) {
                String queryString;
                HashMap<String, Map> parameters = new HashMap<String, Map>();
                Map criteriaNames = HibernateDataSource.replaceCriteriaValuesWithVariableNames(req.getCriteria());
                Map valueNames = HibernateDataSource.replaceCriteriaValuesWithVariableNames(req.getValues());
                parameters.put("criteria", criteriaNames);
                parameters.put("where", criteriaNames);
                parameters.put("values", valueNames);
                Query q = null;
                if (customHQL != null) {
                    queryString = Velocity.evaluateAsString((String)customHQL, parameters, (String)opType, (DataSource)this, (boolean)true);
                    q = session.createQuery(queryString);
                } else {
                    queryString = Velocity.evaluateAsString((String)customSQL, parameters, (String)opType, (DataSource)this, (boolean)true);
                    q = session.createSQLQuery(queryString);
                }
                HibernateDataSource.attachNamedParameters(q, req.getCriteria());
                HibernateDataSource.attachNamedParameters(q, req.getValues());
                int affectedRows = q.executeUpdate();
                dsResponse.setAffectedRows((long)affectedRows);
                if (affectedRows > 0) {
                    dsResponse.setInvalidateCache(true);
                } else {
                    log.warning((Object)(opType + " operation affected no rows"));
                }
                if (HibernateDataSource.isRemove((String)opType)) {
                    dsResponse.setData((Object)req.getCriteria());
                } else if (!HibernateDataSource.isCustom((String)opType)) {
                    dsResponse.setData((Object)req.getValues());
                }
            } else if (HibernateDataSource.isRemove((String)opType)) {
                Map returnCriteria = req.getCriteria();
                ArrayList<DSResponse> relatedObjects = new ArrayList<DSResponse>();
                if (req.getAllowMultiUpdate()) {
                    Query q = this.createQuery(req, session)[0];
                    List results = q.list();
                    for (Object e : results) {
                        HashMap relationProperties = Boolean.TRUE.equals(this.generateRelatedUpdates) ? new HashMap(DataTools.getProperties(e, this.relationFields.keySet())) : new HashMap();
                        for (String relationFieldName : this.relationFields.keySet()) {
                            DSResponse relatedUpdate;
                            Object v = relationProperties.get(relationFieldName);
                            if (v == null) continue;
                            RelationFieldInfo relationFieldInfo = (RelationFieldInfo)this.relationFields.get(relationFieldName);
                            DataSource relatedDS = DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                            if (v instanceof Map) {
                                for (Object o : ((Map)v).values()) {
                                    relatedUpdate = new DSResponse(relatedDS, o, DSResponse.STATUS_SUCCESS);
                                    relatedUpdate.setOperationType("update");
                                    relatedObjects.add(relatedUpdate);
                                }
                                continue;
                            }
                            if (v instanceof Collection) {
                                for (Object o : (Collection)v) {
                                    relatedUpdate = new DSResponse(relatedDS, o, DSResponse.STATUS_SUCCESS);
                                    relatedUpdate.setOperationType("update");
                                    relatedObjects.add(relatedUpdate);
                                }
                                continue;
                            }
                            DSResponse relatedUpdate2 = new DSResponse(relatedDS, v, DSResponse.STATUS_SUCCESS);
                            relatedUpdate2.setOperationType("update");
                            relatedObjects.add(relatedUpdate2);
                        }
                        session.delete(e);
                    }
                    dsResponse.setInvalidateCache(true);
                } else {
                    Serializable id = this.createPrimaryKey(req);
                    Object record = session.get(this.entityName, id);
                    if (record != null) {
                        HashMap relationProperties = Boolean.TRUE.equals(this.generateRelatedUpdates) ? new HashMap(DataTools.getProperties((Object)record, this.relationFields.keySet())) : new HashMap();
                        for (String string : this.relationFields.keySet()) {
                            DSResponse relatedUpdate;
                            Object v = relationProperties.get(string);
                            if (v == null) continue;
                            RelationFieldInfo relationFieldInfo = (RelationFieldInfo)this.relationFields.get(string);
                            DataSource dataSource = DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                            if (v instanceof Map) {
                                for (Object o : ((Map)v).values()) {
                                    relatedUpdate = new DSResponse(dataSource, o, DSResponse.STATUS_SUCCESS);
                                    relatedUpdate.setOperationType("update");
                                    relatedObjects.add(relatedUpdate);
                                }
                                continue;
                            }
                            if (v instanceof Collection) {
                                for (Object o : (Collection)v) {
                                    relatedUpdate = new DSResponse(dataSource, o, DSResponse.STATUS_SUCCESS);
                                    relatedUpdate.setOperationType("update");
                                    relatedObjects.add(relatedUpdate);
                                }
                                continue;
                            }
                            DSResponse relatedUpdate3 = new DSResponse(dataSource, v, DSResponse.STATUS_SUCCESS);
                            relatedUpdate3.setOperationType("update");
                            relatedObjects.add(relatedUpdate3);
                        }
                        session.delete(record);
                    } else {
                        log.warn((Object)("Did not remove. Record not found for PK=" + id));
                    }
                    boolean bl = false;
                    for (DSResponse dSResponse : relatedObjects) {
                        boolean bl5;
                        if (!bl5) {
                            session.flush();
                            bl5 = true;
                        }
                        Object o = dSResponse.getData();
                        try {
                            session.refresh(o);
                        }
                        catch (Exception exception) {
                            dSResponse.setData((Object)dSResponse.getDataSource().getProperties(o, (Collection)dSResponse.getDataSource().getPrimaryKeys()));
                            dSResponse.setOperationType("remove");
                        }
                        dsResponse.addRelatedUpdate(dSResponse);
                    }
                    dsResponse.setData((Object)returnCriteria);
                    dsResponse.setBypassDataFilter(Boolean.TRUE);
                }
            } else {
                if (HibernateDataSource.isDownload((String)opType)) {
                    return this.executeDownload(req);
                }
                List valueSets = req.getValueSets();
                if (HibernateDataSource.isAdd((String)req.getOperationType()) && valueSets.size() > 1) {
                    this.relatedUpdates = new ArrayList<DSResponse>();
                    for (Map rec : valueSets) {
                        if (this.beanClass != null) {
                            Object bean = Reflection.instantiateClass((String)this.entityName);
                            this.setProperties(rec, bean, req);
                            try {
                                session.saveOrUpdate(this.entityName, bean);
                                HibernateTransaction.incrementTransactionOpCount(trx);
                                continue;
                            }
                            catch (Exception e) {
                                log.error((Object)("Failed to saveOrUpdate record: " + DataTools.prettyPrint((Object)bean)));
                                throw e;
                            }
                        }
                        try {
                            session.saveOrUpdate(this.entityName, (Object)rec);
                            HibernateTransaction.incrementTransactionOpCount(trx);
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to saveOrUpdate record: " + DataTools.prettyPrint((Object)rec)));
                            throw e;
                        }
                    }
                } else if (HibernateDataSource.isAdd((String)req.getOperationType())) {
                    Map record = this.beanClass != null ? Reflection.instantiateClass((String)this.entityName) : new HashMap();
                    this.relatedUpdates = new ArrayList<DSResponse>();
                    if (record instanceof Map) {
                        record = DataTools.mapMerge((Map)req.getValues(), (Map)record);
                    } else {
                        this.setProperties(req.getValues(), record, req);
                    }
                    try {
                        session.save(this.entityName, record);
                        HibernateTransaction.incrementTransactionOpCount(trx);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to save record of type: " + record.getClass().getName() + " with values: " + DataTools.prettyPrint(record) + " exception: " + e));
                        throw e;
                    }
                    dsResponse.setData(record);
                    boolean flushed = false;
                    for (DSResponse relatedUpdate : this.relatedUpdates) {
                        if ("remove".equals(relatedUpdate.getOperationType())) {
                            if (!flushed) {
                                session.flush();
                                flushed = true;
                            }
                            try {
                                session.refresh(relatedUpdate.getData());
                                relatedUpdate.setOperationType("update");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        dsResponse.addRelatedUpdate(relatedUpdate);
                    }
                } else if (req.getValues() == null) {
                    log.warn((Object)"DSRequest with no values passed to executeUpdate(), no records modified.");
                    dsResponse.setData(null);
                } else {
                    this.relatedUpdates = new ArrayList<DSResponse>();
                    if (req.getAllowMultiUpdate()) {
                        Query q = this.createQuery(req, session)[0];
                        List results = q.list();
                        for (Object record : results) {
                            if (record instanceof Map) {
                                record = DataTools.mapMerge((Map)req.getValues(), (Map)((Map)record));
                                continue;
                            }
                            this.setProperties(req.getValues(), record);
                        }
                        dsResponse.setData((Object)results);
                    } else {
                        Serializable id = this.createPrimaryKey(req);
                        Object record = session.get(this.entityName, id);
                        if (record != null) {
                            if (record instanceof Map) {
                                record = DataTools.mapMerge((Map)req.getValues(), (Map)((Map)record));
                            } else {
                                this.setProperties(req.getValues(), record);
                            }
                        } else {
                            log.warn((Object)("Did not update. Record not found for PK=" + id));
                        }
                        dsResponse.setData(record);
                    }
                    boolean flushed = false;
                    for (DSResponse relatedUpdate : this.relatedUpdates) {
                        if ("remove".equals(relatedUpdate.getOperationType())) {
                            if (!flushed) {
                                session.flush();
                                flushed = true;
                            }
                            try {
                                session.refresh(relatedUpdate.getData());
                                relatedUpdate.setOperationType("update");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        dsResponse.addRelatedUpdate(relatedUpdate);
                    }
                }
            }
            if (this.inlineTransaction != null) {
                HibernateTransaction.commitTransaction(trx);
            }
            return dsResponse;
        }
        catch (Exception ex) {
            if (this.inlineTransaction != null) {
                HibernateTransaction.rollbackTransaction(trx);
            }
            throw ex;
        }
    }

    private Serializable createPrimaryKey(DSRequest req) throws Exception {
        String primaryKeyFieldName = this.getPrimaryKey();
        if (primaryKeyFieldName != null) {
            Serializable id = null;
            if (this.idClass != null) {
                boolean isIdClass;
                id = (Serializable)this.idClass.newInstance();
                Map values = req.getCriteria();
                boolean bl = isIdClass = DataSourceAnnotations.hasAnnotation((Object)this.beanClass, (Class[])new Class[]{IdClass.class}) || !config.getBoolean((Object)"extIsEmbeddedId", true);
                if (isIdClass) {
                    DataTools.setProperties((Map)req.getValues(), (Object)id);
                } else {
                    HashMap idValues = new HashMap();
                    for (Object primaryKeyPart : this.getPrimaryKeys()) {
                        DSField primaryKeyPartField = this.getField(primaryKeyPart.toString());
                        String beanPropertyName = primaryKeyPartField.getBeanPropertyName();
                        if (beanPropertyName.contains(".")) {
                            beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                        }
                        Object valuePart = values.get(primaryKeyPart);
                        valuePart = DataTools.castValue(valuePart, (Class)DataTools.getPropertyType((Class)this.idClass, (String)beanPropertyName));
                        idValues.put(beanPropertyName, valuePart);
                    }
                    DataTools.setProperties(idValues, (Object)id);
                }
            } else {
                String primaryKeyPropertyName = this.getField(primaryKeyFieldName).getBeanPropertyName();
                Class primaryKeyPropertyType = this.beanClass == null ? this.getSessionFactory().getClassMetadata(this.entityName).getPropertyType(primaryKeyPropertyName).getReturnedClass() : DataTools.getPropertyType((Class)this.beanClass, (String)primaryKeyPropertyName);
                id = (Serializable)DataTools.castValue((Object)req.getFieldValue((Object)primaryKeyFieldName), (Class)primaryKeyPropertyType);
            }
            return id;
        }
        return null;
    }

    private Query[] createQuery(DSRequest req, Session session) throws Exception {
        Query qCount;
        Object typedParameterValue;
        String aliasedPropertyName;
        String selectPart = "";
        String fromPart = "";
        String wherePart = "";
        String groupByPart = "";
        String orderByPart = "";
        boolean outputsUsed = false;
        if (req.isGroupBy()) {
            int beanNameCounter = 1;
            for (String fieldName : req.getGroupByFields()) {
                Map fieldFunctionsMap;
                DSField field = this.getField(fieldName);
                String beanPropertyName = field.getBeanPropertyName();
                String fromBean = this.beanName;
                String fromBeanFull = this.beanName;
                if (beanPropertyName.indexOf(46) > 0) {
                    while (beanPropertyName.indexOf(46) > 0) {
                        String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                        fromBeanFull = fromBeanFull + "." + pathPart;
                        fromBean = fromBean + "." + pathPart;
                        if (!this.fromBeans.containsKey(fromBeanFull)) {
                            pathPart = pathPart + beanNameCounter++;
                            this.fromBeans.put(fromBeanFull, pathPart);
                            fromPart = fromPart + " left outer join " + fromBean + " " + pathPart;
                            fromBean = pathPart;
                        } else {
                            fromBean = this.fromBeans.get(fromBeanFull);
                        }
                        beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                    }
                }
                if ((fieldFunctionsMap = req.getFieldFunctions()) != null && fieldFunctionsMap.containsKey(fieldName)) {
                    String functionName = (String)fieldFunctionsMap.get(fieldName);
                    String function = functionName + "(" + fromBean + "." + beanPropertyName + ") as " + fieldName;
                    selectPart = selectPart + ("".equals(selectPart) ? function : ", " + function);
                    continue;
                }
                String s = fromBean + "." + beanPropertyName;
                groupByPart = groupByPart + ("".equals(groupByPart) ? s : ", " + s);
                s = s + " as " + fieldName;
                selectPart = selectPart + ("".equals(selectPart) ? s : ", " + s);
            }
        } else {
            String selectFullBeans = this.beanName;
            List outputs = this.computeOutputColumns(req);
            HashMap<String, String> subSelects = null;
            int beanNameCounter = 1;
            for (Object fieldObject : this.getFields()) {
                DSField field = (DSField)fieldObject;
                boolean fieldRequested = outputs != null && outputs.contains(field.getName());
                String beanPropertyName = field.getBeanPropertyName();
                String fromBeanFull = this.beanName;
                String fromBean = this.beanName;
                if ((fieldRequested || outputs == null) && beanPropertyName.indexOf(46) > 0) {
                    if (field.getProperty("groupFunction") != null) {
                        String functionName = field.getProperty("groupFunction");
                        if ("FIRST".equals(functionName.toUpperCase())) {
                            functionName = "MIN";
                        }
                        if (this.supportsGroupFunction(functionName)) {
                            String subFromBean = null;
                            String subFromPart = null;
                            while (beanPropertyName.indexOf(46) > 0) {
                                String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                                subFromBean = subFromBean == null ? this.beanName + "." + pathPart : subFromBean + "." + pathPart;
                                pathPart = pathPart + beanNameCounter++;
                                subFromPart = subFromPart == null ? subFromBean + " " + pathPart : subFromPart + " left outer join " + subFromBean + " " + pathPart;
                                subFromBean = pathPart;
                                beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                            }
                            if (subSelects == null) {
                                subSelects = new HashMap<String, String>();
                            }
                            subSelects.put(field.getName(), "(select " + functionName + "(" + subFromBean + "." + beanPropertyName + ") from " + subFromPart + ") as " + field.getName());
                        } else {
                            log.warn((Object)("Function name: '" + functionName + "' specified in groupFunction attribute for field '" + this.getName() + "." + field.getName() + "' is not supported by this type of data source. Skipping."));
                        }
                    }
                    if (!(subSelects != null && subSelects.containsKey(field.getName()) || field.get((Object)"useJoin") != null && !field.getBoolean("useJoin"))) {
                        while (beanPropertyName.indexOf(46) > 0) {
                            String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                            fromBeanFull = fromBeanFull + "." + pathPart;
                            fromBean = fromBean + "." + pathPart;
                            if (!this.fromBeans.containsKey(fromBeanFull)) {
                                pathPart = pathPart + beanNameCounter++;
                                this.fromBeans.put(fromBeanFull, pathPart);
                                selectFullBeans = selectFullBeans + ", " + pathPart;
                                fromPart = fromPart + " left outer join " + fromBean + " " + pathPart;
                                fromBean = pathPart;
                            } else {
                                fromBean = this.fromBeans.get(fromBeanFull);
                            }
                            beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
                        }
                    }
                }
                if (!fieldRequested) continue;
                String s = null;
                s = subSelects != null && subSelects.containsKey(field.getName()) ? (String)subSelects.get(field.getName()) : fromBean + "." + beanPropertyName + " as " + field.getName();
                selectPart = selectPart + ("".equals(selectPart) ? s : ", " + s);
            }
            if ("".equals(selectPart)) {
                selectPart = selectPart + selectFullBeans;
                if (subSelects != null) {
                    for (String fieldName : subSelects.keySet()) {
                        selectPart = selectPart + ", " + (String)subSelects.get(fieldName);
                    }
                    req.setGroupFunctionFields(new ArrayList(subSelects.keySet()));
                }
            } else {
                outputsUsed = true;
            }
        }
        int parameterCounter = 0;
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<Class> beanParametersTypes = new ArrayList<Class>();
        Map criteria = req.getCriteria();
        if (criteria != null) {
            if (this.isAdvancedCriteria(criteria)) {
                CriteriaPart criteriaPart;
                this.strictSQLFiltering = false;
                Object strictMode = criteria.get("strictSQLFiltering");
                if (strictMode == null) {
                    strictMode = this.getProperty("strictSQLFiltering");
                }
                if (strictMode != null) {
                    this.strictSQLFiltering = (Boolean)DataTools.castValue(strictMode, Boolean.class);
                }
                if ((criteriaPart = this.parseAdvancedCriteria(criteria, 0, req)) != null) {
                    wherePart = criteriaPart.wherePart;
                    parameterNames.addAll(criteriaPart.parameterNames);
                    parameters.addAll(criteriaPart.parameters);
                    beanParametersTypes.addAll(criteriaPart.beanParameterTypes);
                }
            } else {
                for (String fieldName : criteria.keySet()) {
                    DSField field = this.getField(fieldName);
                    if (field == null) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is not defined in data source. Skipping."));
                        continue;
                    }
                    if (req.getFieldFunctions() != null && req.getFieldFunctions().containsKey(fieldName)) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is defined in fieldFunctions map," + " applying criteria to aggregated fields is not supported. Skipping."));
                        continue;
                    }
                    if (!this.isFieldPersistent(field.getName())) {
                        log.warn((Object)("Field name: '" + field.getName() + "' specified in criteria is non-persistent. Skipping."));
                        continue;
                    }
                    RelationFieldInfo relationFieldInfo = (RelationFieldInfo)this.relationFields.get(fieldName);
                    aliasedPropertyName = this.getAliasedPropertyName(fieldName);
                    String propertyName = field.getBeanPropertyName();
                    Object value = criteria.get(fieldName);
                    Class propertyType = this.beanClass == null ? session.getSessionFactory().getClassMetadata(this.entityName).getPropertyType(propertyName).getReturnedClass() : DataTools.getPropertyType((Class)this.beanClass, (String)propertyName);
                    if (value == null) {
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                            wherePart = wherePart + aliasedPropertyName + " is empty";
                            continue;
                        }
                        wherePart = wherePart + aliasedPropertyName + " is null";
                        continue;
                    }
                    if (value instanceof Iterable) {
                        Iterable valueList = (Iterable)value;
                        boolean hasNulls = false;
                        HibernateDataSource relatedDS = null;
                        DSField relatedField = null;
                        String relatedpropertyName = null;
                        Class relatedPropertyType = null;
                        if (relationFieldInfo != null) {
                            relatedDS = (HibernateDataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                            relatedField = relatedDS.getField(relationFieldInfo.getRelatedFieldName());
                            relatedpropertyName = relatedField.getBeanPropertyName();
                            relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                        }
                        String wherePartList = "";
                        for (Object singleValue : valueList) {
                            Object typedParameterValue2 = null;
                            if (relationFieldInfo != null) {
                                if (singleValue == null) {
                                    hasNulls = true;
                                    continue;
                                }
                                if (relationFieldInfo.isObjectEncapsulated()) {
                                    typedParameterValue2 = relatedDS.beanClass.newInstance();
                                    DataTools.setProperties((Map)((Map)singleValue), (Object)typedParameterValue2);
                                    beanParametersTypes.add(relatedDS.beanClass);
                                } else {
                                    try {
                                        typedParameterValue2 = DataTools.castValue(singleValue, (Class)relatedPropertyType, (DataSource)this);
                                        beanParametersTypes.add(relatedPropertyType);
                                    }
                                    catch (Exception ex) {
                                        log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                                        continue;
                                    }
                                }
                                if (!"".equals(wherePartList)) {
                                    wherePartList = wherePartList + ", ";
                                }
                                wherePartList = wherePartList + ":p" + parameterCounter;
                                parameterNames.add("p" + parameterCounter++);
                                parameters.add(typedParameterValue2);
                                continue;
                            }
                            try {
                                typedParameterValue2 = DataTools.castValue(singleValue, (Class)propertyType, (DataSource)this);
                                if (typedParameterValue2 == null) {
                                    hasNulls = true;
                                    continue;
                                }
                                if (!"".equals(wherePartList)) {
                                    wherePartList = wherePartList + " or ";
                                }
                                wherePartList = wherePartList + aliasedPropertyName + " = :p" + parameterCounter;
                                parameterNames.add("p" + parameterCounter++);
                                parameters.add(typedParameterValue2);
                                beanParametersTypes.add(propertyType);
                            }
                            catch (Exception ex) {
                                log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            }
                        }
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        if (!"".equals(wherePartList)) {
                            if (hasNulls) {
                                if (relationFieldInfo != null) {
                                    if (relationFieldInfo.isObjectEncapsulated()) {
                                        wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + wherePartList + ")) or " + aliasedPropertyName + " is empty)";
                                        continue;
                                    }
                                    wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + wherePartList + ")) or " + aliasedPropertyName + " is empty)";
                                    continue;
                                }
                                wherePart = wherePart + "(" + wherePartList + " or " + aliasedPropertyName + " is null)";
                                continue;
                            }
                            if (relationFieldInfo != null) {
                                if (relationFieldInfo.isObjectEncapsulated()) {
                                    wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + wherePartList + ")) and " + aliasedPropertyName + " is not empty)";
                                    continue;
                                }
                                wherePart = wherePart + "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + wherePartList + ")) and " + aliasedPropertyName + " is not empty)";
                                continue;
                            }
                            wherePart = wherePart + "((" + wherePartList + ") and " + aliasedPropertyName + " is not null)";
                            continue;
                        }
                        if (hasNulls) {
                            if (relationFieldInfo != null) {
                                wherePart = wherePart + "(" + aliasedPropertyName + " is empty)";
                                continue;
                            }
                            wherePart = wherePart + "(" + aliasedPropertyName + " is null)";
                            continue;
                        }
                        if (relationFieldInfo != null) {
                            wherePart = wherePart + "(" + aliasedPropertyName + " is empty)";
                            continue;
                        }
                        wherePart = wherePart + "1=2";
                        continue;
                    }
                    if (DataTools.isTextType((Class)propertyType) && relationFieldInfo == null) {
                        if (TextMatchStyle.SUBSTRING.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(" + aliasedPropertyName + ") like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(propertyType);
                            continue;
                        }
                        if (TextMatchStyle.STARTS_WITH.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(" + aliasedPropertyName + ") like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(propertyType);
                            continue;
                        }
                        typedParameterValue = null;
                        try {
                            typedParameterValue = DataTools.castValue(value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            continue;
                        }
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        wherePart = wherePart + "(lower(" + aliasedPropertyName + ") = lower(:p" + parameterCounter + "))";
                        parameterNames.add("p" + parameterCounter++);
                        parameters.add(typedParameterValue);
                        beanParametersTypes.add(propertyType);
                        continue;
                    }
                    if (DataTools.isNumberType((Class)propertyType) && relationFieldInfo == null) {
                        if (TextMatchStyle.SUBSTRING.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(concat(" + aliasedPropertyName + ",''))" + " like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(String.class);
                            continue;
                        }
                        if (TextMatchStyle.STARTS_WITH.getValue().equals(req.getTextMatchStyle())) {
                            if (!"".equals(wherePart)) {
                                wherePart = wherePart + " and ";
                            }
                            wherePart = wherePart + "(lower(concat(" + aliasedPropertyName + ",''))" + " like lower(:p" + parameterCounter + ") escape '" + ESCAPE_CHARACTER + "')";
                            parameterNames.add("p" + parameterCounter++);
                            parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            beanParametersTypes.add(String.class);
                            continue;
                        }
                        typedParameterValue = null;
                        try {
                            typedParameterValue = DataTools.castValue(value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            continue;
                        }
                        if (!"".equals(wherePart)) {
                            wherePart = wherePart + " and ";
                        }
                        wherePart = wherePart + aliasedPropertyName + " = :p" + parameterCounter;
                        parameterNames.add("p" + parameterCounter++);
                        parameters.add(typedParameterValue);
                        beanParametersTypes.add(propertyType);
                        continue;
                    }
                    typedParameterValue = null;
                    if (relationFieldInfo != null && relationFieldInfo.isObjectEncapsulated()) {
                        HibernateDataSource relatedDS = (HibernateDataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                        typedParameterValue = relatedDS.beanClass.newInstance();
                        DataTools.setProperties((Map)((Map)value), (Object)typedParameterValue);
                    } else {
                        try {
                            typedParameterValue = DataTools.castValue(value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                            continue;
                        }
                    }
                    if (!"".equals(wherePart)) {
                        wherePart = wherePart + " and ";
                    }
                    wherePart = wherePart + aliasedPropertyName + " = :p" + parameterCounter;
                    parameterNames.add("p" + parameterCounter++);
                    parameters.add(typedParameterValue);
                    beanParametersTypes.add(propertyType);
                }
            }
        }
        List sortBy = req.getSortByFields();
        for (String fieldName : sortBy) {
            DSField field = this.getField(fieldName.startsWith("-") ? fieldName.substring(1) : fieldName);
            if (field == null) {
                log.warn((Object)("Field name: '" + fieldName + "' specified in sort-by is not defined in data source. Skipping."));
                continue;
            }
            aliasedPropertyName = this.getAliasedPropertyName(field.getName());
            if (!"".equals(orderByPart)) {
                orderByPart = orderByPart + ", ";
            }
            if (fieldName.startsWith("-")) {
                orderByPart = orderByPart + aliasedPropertyName + " desc";
                continue;
            }
            orderByPart = orderByPart + aliasedPropertyName;
        }
        String qStr = "select " + selectPart + " from " + this.entityName + " " + this.beanName + " " + fromPart;
        String qCountStr = "select count(*) from " + this.entityName + " " + this.beanName + " " + fromPart;
        if (!"".equals(wherePart)) {
            qStr = qStr + " where " + wherePart;
            qCountStr = qCountStr + " where " + wherePart;
        }
        if (!"".equals(groupByPart)) {
            qStr = qStr + " group by " + groupByPart;
        }
        if (!"".equals(orderByPart)) {
            qStr = qStr + " order by " + orderByPart;
        }
        log.info((Object)("Query string: " + qStr));
        Query q = session.createQuery(qStr);
        Query query = qCount = req.isGroupBy() ? null : session.createQuery(qCountStr);
        if (req.isGroupBy() || outputsUsed) {
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameterValue = parameters.get(i);
            Class beanParameterType = (Class)beanParametersTypes.get(i);
            typedParameterValue = DataTools.castValue(parameterValue, (Class)beanParameterType, (DataSource)this);
            q.setParameter((String)parameterNames.get(i), typedParameterValue);
            if (qCount != null) {
                qCount.setParameter((String)parameterNames.get(i), typedParameterValue);
            }
            log.debug((Object)("Parameter " + (String)parameterNames.get(i) + ": " + typedParameterValue));
        }
        Query[] ret = new Query[]{q, qCount};
        return ret;
    }

    public boolean supportsGroupFunction(String functionName) {
        if (functionName == null) {
            return false;
        }
        return supportedAggregationFunctions.contains(functionName.toUpperCase());
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        String fieldName = req.getDownloadFieldName();
        Map criteria = req.getCriteria();
        this.downloadDsRequest = new DSRequest(this.getName(), "fetch");
        this.downloadDsRequest.setRPCManager(req.getRPCManager());
        this.downloadDsRequest.setCriteria((Object)criteria);
        this.downloadDsRequest.setFreeOnExecute(req.getFreeOnExecute());
        DSResponse resp = this.downloadDsRequest.execute();
        req.setFreeOnExecute(this.downloadDsRequest.getFreeOnExecute());
        if (resp.getData() instanceof List) {
            resp.setData(this.forceSingleObject(resp.getDataList()));
        }
        return resp;
    }

    private static void attachNamedParameters(Query q, Map criteria) {
        String[] named = q.getNamedParameters();
        if (criteria != null && criteria.size() > 0) {
            Set keys = criteria.keySet();
            for (String key : keys) {
                Object value = criteria.get(key);
                boolean mapIt = false;
                for (int j = 0; j < named.length; ++j) {
                    if (!named[j].equals(key)) continue;
                    mapIt = true;
                    break;
                }
                if (!mapIt) continue;
                if (value instanceof Long) {
                    q.setLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    q.setInteger(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Float) {
                    q.setFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    q.setDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                q.setParameter(key, criteria.get(key));
            }
        }
    }

    public static String escapeValueForFilter(Object value, char escapeChar) {
        if (value == null) {
            return "";
        }
        String stringValue = value.toString();
        stringValue = stringValue.replaceAll("" + escapeChar, "" + escapeChar + escapeChar);
        stringValue = stringValue.replaceAll("_", "" + escapeChar + "_");
        stringValue = stringValue.replaceAll("%", "" + escapeChar + "%");
        return stringValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CriteriaPart parseAdvancedCriteria(Map<String, Object> criteria, int nextParameterNumber, DSRequest request) throws Exception {
        Iterator i$;
        int realValueListSize;
        boolean hasNulls;
        Class propertyType;
        String aliasedPropertyName;
        Class relatedPropertyType;
        String relatedpropertyName;
        HibernateDataSource relatedDS;
        RelationFieldInfo relationFieldInfo;
        String fieldName;
        String op;
        CriteriaPart criteriaPart;
        block353: {
            Iterator<Object> i$2;
            ArrayList<CriteriaPart> restrictions;
            block358: {
                Iterator<Object> i$3;
                ArrayList<CriteriaPart> restrictions2;
                block356: {
                    boolean negate;
                    Object operator;
                    block357: {
                        Object subCriteria;
                        block355: {
                            operator = criteria.get("operator");
                            if (operator == null) {
                                log.warn((Object)"Found criterion with a null operator. Skipping.");
                                return null;
                            }
                            criteriaPart = new CriteriaPart();
                            criteriaPart.nextParameterNumber = nextParameterNumber;
                            op = operator.toString();
                            fieldName = null;
                            try {
                                fieldName = criteria.get("fieldName").toString();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            subCriteria = criteria.get("criteria");
                            if ("not".equalsIgnoreCase(op)) {
                                if (subCriteria == null) {
                                    log.warn((Object)("Found criterion '" + op + "' with no defined sub-criteria. Skipping."));
                                    return null;
                                }
                                if (!(subCriteria instanceof Iterable)) {
                                    log.warn((Object)("Found criterion '" + op + "' with sub-criteria that is not instance of Iterable." + "\nReturning predicate '1=2' (always false)."));
                                    criteriaPart.wherePart = "1=2";
                                    return criteriaPart;
                                }
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "or");
                                criteriaPart = this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                                if (criteriaPart == null) return criteriaPart;
                                criteriaPart.wherePart = "not (" + criteriaPart.wherePart + ")";
                                return criteriaPart;
                            }
                            if (!"or".equalsIgnoreCase(op)) break block355;
                            if (subCriteria == null) {
                                log.warn((Object)("Found criterion '" + op + "' with no defined sub-criteria. Skipping."));
                                return null;
                            }
                            if (!(subCriteria instanceof Iterable)) {
                                log.warn((Object)("Found criterion '" + op + "' with sub-criteria that is not instance of Iterable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            restrictions2 = new ArrayList<CriteriaPart>();
                            i$3 = ((Iterable)subCriteria).iterator();
                            break block356;
                        }
                        if (!"and".equalsIgnoreCase(op)) break block357;
                        if (subCriteria == null) {
                            log.warn((Object)("Found criterion '" + op + "' with no defined sub-criteria. Skipping."));
                            return null;
                        }
                        if (!(subCriteria instanceof Iterable)) {
                            log.warn((Object)("Found criterion '" + op + "' with sub-criteria that is not instance of Iterable." + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        restrictions = new ArrayList<CriteriaPart>();
                        i$2 = ((Iterable)subCriteria).iterator();
                        break block358;
                    }
                    if ("regexp".equalsIgnoreCase(op)) {
                        return null;
                    }
                    if ("iregexp".equalsIgnoreCase(op)) {
                        return null;
                    }
                    if (fieldName == null) {
                        log.warn((Object)("Found criterion '" + op + "' with no field specified. Skipping."));
                        return null;
                    }
                    DSField field = this.getField(fieldName);
                    if (field == null) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is not defined in data source. Skipping."));
                        return null;
                    }
                    if (request.getFieldFunctions() != null && request.getFieldFunctions().containsKey(fieldName)) {
                        log.warn((Object)("Field name: '" + fieldName + "' specified in criteria is defined in fieldFunctions map," + " applying criteria to aggregated fields is not supported. Skipping."));
                        return null;
                    }
                    if (!this.isFieldPersistent(field.getName())) {
                        log.warn((Object)("Field name: '" + field.getName() + "' specified in criteria is non-persistent. Skipping."));
                        return null;
                    }
                    relationFieldInfo = (RelationFieldInfo)this.relationFields.get(fieldName);
                    relatedDS = null;
                    DSField relatedField = null;
                    relatedpropertyName = null;
                    relatedPropertyType = null;
                    if (relationFieldInfo != null) {
                        relatedDS = (HibernateDataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
                        relatedField = relatedDS.getField(relationFieldInfo.getRelatedFieldName());
                        relatedpropertyName = relatedField.getBeanPropertyName();
                        relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                    }
                    aliasedPropertyName = this.getAliasedPropertyName(fieldName);
                    String propertyName = field.getBeanPropertyName();
                    propertyType = this.beanClass == null ? this.getSessionFactory().getClassMetadata(this.entityName).getPropertyType(propertyName).getReturnedClass() : DataTools.getPropertyType((Class)this.beanClass, (String)propertyName);
                    if (Collection.class.isAssignableFrom(propertyType) && relationFieldInfo == null) {
                        DataSource typeDS = DataSourceManager.getDataSource((String)field.getType(), (DSRequest)request);
                        if (typeDS == null) {
                            log.warn((Object)("In order to filter against '" + field.getName() + "' field 'type' attribute must be declared pointing to related data source. Skipping."));
                            return null;
                        }
                        if (!(typeDS instanceof HibernateDataSource)) {
                            log.warn((Object)("Related data source '" + relatedDS.getName() + "' for field '" + field.getName() + "' used " + "in criteria is not compatible with '" + this.getName() + "' data source. Skipping."));
                            return null;
                        }
                        relatedDS = (HibernateDataSource)typeDS;
                        relatedpropertyName = relatedDS.getPrimaryKey();
                        relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                        relationFieldInfo = new RelationFieldInfo(fieldName, field.getType(), relatedDS.getName(), relatedpropertyName, false, true);
                    }
                    Object value = criteria.get("value");
                    Object start = criteria.get("start");
                    Object end = criteria.get("end");
                    if ("equals".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName;
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (relationFieldInfo != null) {
                            if (relationFieldInfo.isMultiple()) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "inSet");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                            }
                            if (relationFieldInfo.isObjectEncapsulated() && value != null) {
                                Object typedParameterValue = relatedDS.beanClass.newInstance();
                                DataTools.setProperties((Map)((Map)value), typedParameterValue);
                                value = typedParameterValue;
                            } else {
                                try {
                                    value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                                }
                                catch (Exception ex) {
                                    log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                    if (this.strictSQLFiltering) {
                                        criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName;
                                        return criteriaPart;
                                    }
                                    criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                                    return criteriaPart;
                                }
                            }
                        } else {
                            try {
                                value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                            }
                            catch (Exception ex) {
                                log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                if (this.strictSQLFiltering) {
                                    criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName;
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                                return criteriaPart;
                            }
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "cast (" + aliasedPropertyName + " as binary) = cast (:p" + criteriaPart.nextParameterNumber + " as binary)" : aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                        criteriaPart.wherePart = aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                        criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                        criteriaPart.parameters.add(value);
                        criteriaPart.beanParameterTypes.add(propertyType);
                        if (this.strictSQLFiltering) return criteriaPart;
                        criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                        return criteriaPart;
                    }
                    if ("notEqual".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " = " + aliasedPropertyName;
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=1 or " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        if (relationFieldInfo != null) {
                            if (relationFieldInfo.isMultiple()) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "notInSet");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                            }
                            if (relationFieldInfo.isObjectEncapsulated() && value != null) {
                                Object typedParameterValue = relatedDS.beanClass.newInstance();
                                DataTools.setProperties((Map)((Map)value), typedParameterValue);
                                value = typedParameterValue;
                            } else {
                                try {
                                    value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                                }
                                catch (Exception ex) {
                                    log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                    if (this.strictSQLFiltering) {
                                        criteriaPart.wherePart = aliasedPropertyName + " = " + aliasedPropertyName;
                                        return criteriaPart;
                                    }
                                    criteriaPart.wherePart = criteriaPart.wherePart + "1=1 or " + aliasedPropertyName + " is null";
                                    return criteriaPart;
                                }
                            }
                        } else {
                            try {
                                value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                            }
                            catch (Exception ex) {
                                log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                                if (this.strictSQLFiltering) {
                                    criteriaPart.wherePart = aliasedPropertyName + " = " + aliasedPropertyName;
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + "1=1 or " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> :p" + criteriaPart.nextParameterNumber;
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) <> cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " <> :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                        criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                        criteriaPart.parameters.add(value);
                        criteriaPart.beanParameterTypes.add(propertyType);
                        return criteriaPart;
                    }
                    if ("greaterThan".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) > cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " and " + aliasedPropertyName + " is not null)" : "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                        return criteriaPart;
                    }
                    if ("lessThan".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) < cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                        return criteriaPart;
                    }
                    if ("greaterOrEqual".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) >= cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " and " + aliasedPropertyName + " is not null)" : "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + "1=2 and " + aliasedPropertyName + " is not null";
                        return criteriaPart;
                    }
                    if ("lessOrEqual".equalsIgnoreCase(op)) {
                        if (value != null && (Date.class.isAssignableFrom(propertyType) && !Date.class.isAssignableFrom(value.getClass()) || !Date.class.isAssignableFrom(propertyType) && Date.class.isAssignableFrom(value.getClass()))) {
                            log.warn((Object)("Trying to compare " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' with " + (Date.class.isAssignableFrom(value.getClass()) ? "date" : value.getClass().getName()) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (Comparable.class.isInstance(value)) {
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber;
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(value);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) <= cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(value);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with value that is not instance of Comparable."));
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " is null";
                        return criteriaPart;
                    }
                    if ("between".equalsIgnoreCase(op)) {
                        if (Date.class.isAssignableFrom(propertyType) && (start != null && !Date.class.isAssignableFrom(start.getClass()) || end != null && !Date.class.isAssignableFrom(end.getClass())) || !Date.class.isAssignableFrom(propertyType) && (start != null && Date.class.isAssignableFrom(start.getClass()) || end != null && Date.class.isAssignableFrom(end.getClass()))) {
                            log.warn((Object)("Trying to find " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' within range from " + (start == null ? "null" : (Date.class.isAssignableFrom(start.getClass()) ? "date" : start.getClass().getName())) + " type value to " + (end == null ? "null" : (Date.class.isAssignableFrom(end.getClass()) ? "date" : end.getClass().getName())) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!Comparable.class.isInstance(start)) {
                                log.warn((Object)("Found criterion '" + op + "' with start value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (end != null) {
                                if (!Comparable.class.isInstance(end)) {
                                    log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                    criteriaPart.wherePart = "1=2";
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) > cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " and cast (" + aliasedPropertyName + " as binary) < cast (:p" + (criteriaPart.nextParameterNumber + 1) + " as binary)" : "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1);
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) > cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " and " + aliasedPropertyName + " is not null)" : "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!Comparable.class.isInstance(end)) {
                                log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) < cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " < :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " > :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("betweenInclusive".equalsIgnoreCase(op)) {
                        if (Date.class.isAssignableFrom(propertyType) && (start != null && !Date.class.isAssignableFrom(start.getClass()) || end != null && !Date.class.isAssignableFrom(end.getClass())) || !Date.class.isAssignableFrom(propertyType) && (start != null && Date.class.isAssignableFrom(start.getClass()) || end != null && Date.class.isAssignableFrom(end.getClass()))) {
                            log.warn((Object)("Trying to find " + (Date.class.isAssignableFrom(propertyType) ? "date" : propertyType.getName()) + " type field '" + fieldName + "' within range from " + (start == null ? "null" : (Date.class.isAssignableFrom(start.getClass()) ? "date" : start.getClass().getName())) + " type value to " + (end == null ? "null" : (Date.class.isAssignableFrom(end.getClass()) ? "date" : end.getClass().getName())) + " type value in criterion '" + op + "'"));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!Comparable.class.isInstance(start)) {
                                log.warn((Object)("Found criterion '" + op + "' with start value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (end != null) {
                                if (!Comparable.class.isInstance(end)) {
                                    log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                    criteriaPart.wherePart = "1=2";
                                    return criteriaPart;
                                }
                                criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) between cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " and cast (:p" + (criteriaPart.nextParameterNumber + 1) + " as binary)" : "(" + aliasedPropertyName + " between :p" + criteriaPart.nextParameterNumber + " and :p" + (criteriaPart.nextParameterNumber + 1);
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) >= cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " and " + aliasedPropertyName + " is not null)" : "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!Comparable.class.isInstance(end)) {
                                log.warn((Object)("Found criterion '" + op + "' with end value that is not instance of Comparable." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = DataTools.isTextType((Class)propertyType) && "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) <= cast (:p" + criteriaPart.nextParameterNumber + " as binary)" + " or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " <= :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(" + aliasedPropertyName + " >= :p" + criteriaPart.nextParameterNumber + " and " + aliasedPropertyName + " <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iBetween".equalsIgnoreCase(op)) {
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!DataTools.isTextType(start.getClass()) && !DataTools.isNumberType(start.getClass())) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "between");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                            }
                            if (end != null) {
                                if (!DataTools.isTextType(end.getClass()) && !DataTools.isNumberType(end.getClass())) {
                                    HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                    newCriteria.put("operator", "between");
                                    return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                                }
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(concat(" + aliasedPropertyName + ",'')) < lower(:p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(concat(" + aliasedPropertyName + ",'')) < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > lower(:p" + criteriaPart.nextParameterNumber + ")" + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!DataTools.isTextType(end.getClass()) && !DataTools.isNumberType(end.getClass())) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "between");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) < lower(:p" + (criteriaPart.nextParameterNumber + 1) + "))";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) < :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) > :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) < :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iBetweenInclusive".equalsIgnoreCase(op)) {
                        try {
                            start = DataTools.castValue((Object)start, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast start value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        try {
                            end = DataTools.castValue((Object)end, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast end value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage()));
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = aliasedPropertyName + " <> " + aliasedPropertyName + " and " + aliasedPropertyName + " is null";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (start != null) {
                            if (!DataTools.isTextType(start.getClass()) && !DataTools.isNumberType(start.getClass())) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "betweenInclusive");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                            }
                            if (end != null) {
                                if (!DataTools.isTextType(end.getClass()) && !DataTools.isNumberType(end.getClass())) {
                                    HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                    newCriteria.put("operator", "betweenInclusive");
                                    return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                                }
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) between lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(:p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                if (!this.strictSQLFiltering) {
                                    criteriaPart.wherePart = criteriaPart.wherePart + " and " + aliasedPropertyName + " is not null";
                                }
                                criteriaPart.wherePart = criteriaPart.wherePart + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= lower(:p" + criteriaPart.nextParameterNumber + ")" + " and lower(concat(" + aliasedPropertyName + ",'')) <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= lower(:p" + criteriaPart.nextParameterNumber + ")" + " and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (end != null) {
                            if (!Comparable.class.isInstance(end)) {
                                HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                                newCriteria.put("operator", "betweenInclusive");
                                return this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                            }
                            if (this.strictSQLFiltering) {
                                criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) <= lower(:p" + (criteriaPart.nextParameterNumber + 1) + "))";
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(start);
                                criteriaPart.beanParameterTypes.add(propertyType);
                                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                                criteriaPart.parameters.add(end.toString());
                                criteriaPart.beanParameterTypes.add(String.class);
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) <= :p" + criteriaPart.nextParameterNumber + " or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end.toString());
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        if (this.strictSQLFiltering) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) >= :p" + criteriaPart.nextParameterNumber + " and lower(concat(" + aliasedPropertyName + ",'')) <= :p" + (criteriaPart.nextParameterNumber + 1) + ")";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(start);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(end);
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iEquals".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) = '' and " + aliasedPropertyName + " is not null)";
                            return criteriaPart;
                        }
                        if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                            log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) = lower(:p" + criteriaPart.nextParameterNumber + ") and " + aliasedPropertyName + " is not null)";
                        criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                        criteriaPart.parameters.add(value.toString());
                        criteriaPart.beanParameterTypes.add(String.class);
                        return criteriaPart;
                    }
                    if ("iNotEqual".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) <> '' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                            log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) <> lower(:p" + criteriaPart.nextParameterNumber + ") or " + aliasedPropertyName + " is null)";
                        criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                        criteriaPart.parameters.add(value.toString());
                        criteriaPart.beanParameterTypes.add(String.class);
                        return criteriaPart;
                    }
                    if ("contains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) like cast (:p" + criteriaPart.nextParameterNumber + " as binary) escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)" : "(" + aliasedPropertyName + " like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("startsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) like cast (:p" + criteriaPart.nextParameterNumber + " as binary) escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)" : "(" + aliasedPropertyName + " like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("endsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) like cast (:p" + criteriaPart.nextParameterNumber + " as binary) escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)" : "(" + aliasedPropertyName + " like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("iContains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("iStartsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("iEndsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                                criteriaPart.wherePart = "1=2";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = aliasedPropertyName + " is not null";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' and " + aliasedPropertyName + " is not null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=2' (always false)."));
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    if ("notContains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) not like cast (:p" + criteriaPart.nextParameterNumber + " as binary) escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("notStartsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) not like cast (:p" + criteriaPart.nextParameterNumber + " as binary) escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("notEndsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType()) ? "(cast (" + aliasedPropertyName + " as binary) not like cast (:p" + criteriaPart.nextParameterNumber + " as binary) escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)" : "(" + aliasedPropertyName + " not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like :p" + criteriaPart.nextParameterNumber + " escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iNotContains".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iNotStartsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add(HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("iNotEndsWith".equalsIgnoreCase(op)) {
                        try {
                            value = DataTools.castValue((Object)value, (Class)propertyType, (DataSource)this);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nReturning predicate '1=1' (always true)."));
                            criteriaPart.wherePart = "1=1";
                            return criteriaPart;
                        }
                        if (value == null) {
                            if (!DataTools.isTextType((Class)propertyType) && !DataTools.isNumberType((Class)propertyType)) {
                                log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                                criteriaPart.wherePart = "1=1";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "(concat(" + aliasedPropertyName + ",'') not like '%' or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isTextType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(" + aliasedPropertyName + ") not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(propertyType);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        if (DataTools.isNumberType((Class)propertyType)) {
                            criteriaPart.wherePart = "(lower(concat(" + aliasedPropertyName + ",'')) not like lower(:p" + criteriaPart.nextParameterNumber + ") escape '" + ESCAPE_CHARACTER + "' or " + aliasedPropertyName + " is null)";
                            criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                            criteriaPart.parameters.add("%" + HibernateDataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()));
                            criteriaPart.beanParameterTypes.add(String.class);
                            if (this.strictSQLFiltering) return criteriaPart;
                            criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") or " + aliasedPropertyName + " is null)";
                            return criteriaPart;
                        }
                        log.warn((Object)("Found criterion '" + op + "' with field '" + fieldName + "' that is neither instance of String " + "nor instance of Character nor instance of Number." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    if ("isNull".equalsIgnoreCase(op)) {
                        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                            criteriaPart.wherePart = aliasedPropertyName + " is empty";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = aliasedPropertyName + " is null";
                        return criteriaPart;
                    }
                    if ("notNull".equalsIgnoreCase(op)) {
                        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                            criteriaPart.wherePart = aliasedPropertyName + " is not empty";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = aliasedPropertyName + " is not null";
                        return criteriaPart;
                    }
                    if ("inSet".equalsIgnoreCase(op)) {
                        Iterable valueList;
                        if (value == null) {
                            if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                                criteriaPart.wherePart = aliasedPropertyName + " is empty";
                                return criteriaPart;
                            }
                            log.warn((Object)("Value list is not provided for field '" + fieldName + "' in criterion '" + op + "'" + "\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        if (!(value instanceof Iterable)) {
                            value = DataTools.buildList((Object)value);
                        }
                        if ((valueList = (Iterable)value).iterator().hasNext()) {
                            hasNulls = false;
                            realValueListSize = 0;
                            i$ = valueList.iterator();
                            break block353;
                        } else {
                            if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
                                criteriaPart.wherePart = aliasedPropertyName + " is empty";
                                return criteriaPart;
                            }
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                    }
                    if ("notInSet".equalsIgnoreCase(op)) {
                        HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
                        newCriteria.put("operator", "inSet");
                        criteriaPart = this.parseAdvancedCriteria(newCriteria, criteriaPart.nextParameterNumber, request);
                        if (criteriaPart != null) {
                            criteriaPart.wherePart = "not (" + criteriaPart.wherePart + ")";
                            return criteriaPart;
                        }
                        criteriaPart.wherePart = "1=2";
                        return criteriaPart;
                    }
                    String otherFieldName = null;
                    try {
                        otherFieldName = value.toString();
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Found criterion '" + op + "' with no 'other' field specified." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    DSField otherField = this.getField(otherFieldName);
                    if (otherField == null) {
                        log.warn((Object)("'Other' field name: '" + otherFieldName + "' specified in criteria is not defined in data source." + "\nReturning predicate '1=1' (always true)."));
                        criteriaPart.wherePart = "1=1";
                        return criteriaPart;
                    }
                    String aliasedOtherPropertyName = this.getAliasedPropertyName(otherField.getName());
                    String otherPropertyName = otherField.getBeanPropertyName();
                    Class otherPropertyType = this.beanClass == null ? this.getSessionFactory().getClassMetadata(this.entityName).getPropertyType(otherPropertyName).getReturnedClass() : DataTools.getPropertyType((Class)this.beanClass, (String)otherPropertyName);
                    if ("equalsField".equalsIgnoreCase(op) || "notEqualField".equalsIgnoreCase(op) || "greaterThanField".equalsIgnoreCase(op) || "greaterOrEqualField".equalsIgnoreCase(op) || "lessThanField".equalsIgnoreCase(op) || "lessOrEqualField".equalsIgnoreCase(op)) {
                        String otherString;
                        String propertyString;
                        HashMap operatorToSql = new HashMap(){
                            {
                                this.put("equalsField", "=");
                                this.put("notEqualField", "<>");
                                this.put("greaterThanField", ">");
                                this.put("greaterOrEqualField", ">=");
                                this.put("lessThanField", "<");
                                this.put("lessOrEqualField", "<=");
                            }
                        };
                        if (!propertyType.isAssignableFrom(otherPropertyType) && !otherPropertyType.isAssignableFrom(propertyType)) {
                            log.warn((Object)("Fields '" + propertyName + "' and '" + otherPropertyName + "' in criterion '" + op + "' are not compatible.\nReturning predicate '1=2' (always false)."));
                            criteriaPart.wherePart = "1=2";
                            return criteriaPart;
                        }
                        StringBuffer ql = new StringBuffer();
                        if ("mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType())) {
                            propertyString = "cast(" + aliasedPropertyName + " as binary)";
                            otherString = "cast(" + aliasedOtherPropertyName + " as binary)";
                        } else {
                            propertyString = aliasedPropertyName;
                            otherString = aliasedOtherPropertyName;
                        }
                        ql.append("(");
                        if (operator.equals("equalsField")) {
                            ql.append("(" + propertyString + " is null and " + otherString + " is null)");
                        } else if (operator.equals("notEqualField")) {
                            ql.append("((" + propertyString + " is null and " + otherString + " is not null) OR ");
                            ql.append("(" + propertyString + " is not null and " + otherString + " is null))");
                        } else if (operator.equals("lessThanField")) {
                            ql.append("(" + propertyString + " is null and " + otherString + " is not null)");
                        } else if (operator.equals("lessOrEqualField")) {
                            ql.append("(" + propertyString + " is null)");
                        } else if (operator.equals("greaterThanField")) {
                            ql.append("(" + propertyString + " is not null and " + otherString + " is null)");
                        } else {
                            ql.append("(" + otherString + " is null)");
                        }
                        ql.append(" or (" + propertyString + " " + operatorToSql.get(operator) + " ");
                        ql.append(otherString + " and ");
                        ql.append(propertyString + " is not null and " + otherString + " is not null)");
                        ql.append(")");
                        criteriaPart.wherePart = ql.toString();
                        return criteriaPart;
                    }
                    if (!("iEqualsField".equalsIgnoreCase(op) || "iNotEqualField".equalsIgnoreCase(op) || "containsField".equalsIgnoreCase(op) || "notContainsField".equalsIgnoreCase(op) || "iContainsField".equalsIgnoreCase(op) || "iNotContainsField".equalsIgnoreCase(op) || "startsWithField".equalsIgnoreCase(op) || "notStartsWithField".equalsIgnoreCase(op) || "iStartsWithField".equalsIgnoreCase(op) || "iNotStartsWithField".equalsIgnoreCase(op) || "endsWithField".equalsIgnoreCase(op) || "notEndsWithField".equalsIgnoreCase(op) || "iEndsWithField".equalsIgnoreCase(op) || "iNotEndsWithField".equalsIgnoreCase(op))) {
                        log.warn((Object)("Not supported criterion '" + op + "'. Skipping."));
                        return null;
                    }
                    boolean matchCase = !op.toLowerCase().startsWith("i".toLowerCase());
                    boolean bl = negate = op.toLowerCase().startsWith("not".toLowerCase()) || op.toLowerCase().startsWith("iNot".toLowerCase());
                    if ((DataTools.isTextType((Class)propertyType) || DataTools.isNumberType((Class)propertyType)) && (DataTools.isTextType((Class)otherPropertyType) || DataTools.isNumberType((Class)otherPropertyType))) {
                        StringBuffer ql = new StringBuffer();
                        String propertyString = DataTools.isTextType((Class)propertyType) ? aliasedPropertyName : "concat(" + aliasedPropertyName + ",'')";
                        String otherString = DataTools.isTextType((Class)otherPropertyType) ? aliasedOtherPropertyName : "concat(" + aliasedOtherPropertyName + ",'')";
                        if (!this.strictSQLFiltering) {
                            ql.append(aliasedOtherPropertyName + " is null");
                            if (op.toLowerCase().contains("Equal".toLowerCase())) {
                                ql.append(" and " + aliasedPropertyName + " is null)");
                                ql.insert(0, "(");
                            }
                            ql.append(" or (");
                        }
                        if (matchCase) {
                            if ("mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType())) {
                                ql.append("cast (" + propertyString + " as binary)");
                            } else {
                                ql.append(propertyString);
                            }
                        } else if ("mysql".equalsIgnoreCase(this.getHibernateDialectAsSmartClientDbType())) {
                            ql.append(propertyString);
                        } else {
                            ql.append("lower(" + propertyString + ")");
                        }
                        ql.append(" like ");
                        if (!matchCase) {
                            ql.append("lower(");
                        }
                        if (op.toLowerCase().contains("endsWith".toLowerCase()) || op.toLowerCase().contains("contains".toLowerCase())) {
                            ql.append("concat('%', ");
                        }
                        if (op.toLowerCase().contains("startsWith".toLowerCase()) || op.toLowerCase().contains("contains".toLowerCase())) {
                            ql.append("concat(" + otherString + ", '%')");
                        } else {
                            ql.append(otherString);
                        }
                        if (op.toLowerCase().contains("endsWith".toLowerCase()) || op.toLowerCase().contains("contains".toLowerCase())) {
                            ql.append(")");
                        }
                        if (!matchCase) {
                            ql.append(")");
                        }
                        if (!this.strictSQLFiltering) {
                            ql.append(" and " + aliasedPropertyName + " is not null ");
                            ql.append(" and " + aliasedOtherPropertyName + " is not null)");
                        }
                        if (negate) {
                            ql.insert(0, "not(");
                            ql.append(")");
                        }
                        criteriaPart.wherePart = ql.toString();
                        return criteriaPart;
                    }
                    log.warn((Object)("Fields '" + propertyName + "' and '" + otherPropertyName + "' in criterion '" + op + "' are not compatible.\nReturning predicate '1=2' (always false)."));
                    criteriaPart.wherePart = negate ? "1=1" : "1=2";
                    return criteriaPart;
                }
                while (i$3.hasNext()) {
                    Object criterion = i$3.next();
                    if (criterion instanceof Map) {
                        CriteriaPart restriction = this.parseAdvancedCriteria((Map)criterion, criteriaPart.nextParameterNumber, request);
                        if (restriction == null) continue;
                        restrictions2.add(restriction);
                        criteriaPart.nextParameterNumber = restriction.nextParameterNumber;
                        continue;
                    }
                    log.warn((Object)("Found sub-criterion that is not instance of Map in criterion '" + op + "'. Skipping."));
                }
                if (restrictions2.size() <= 0) return null;
                i$3 = restrictions2.iterator();
                while (true) {
                    if (!i$3.hasNext()) {
                        criteriaPart.wherePart = "(" + criteriaPart.wherePart + ")";
                        return criteriaPart;
                    }
                    CriteriaPart restriction = (CriteriaPart)i$3.next();
                    if (!"".equals(criteriaPart.wherePart)) {
                        criteriaPart.wherePart = criteriaPart.wherePart + " or ";
                    }
                    criteriaPart.wherePart = criteriaPart.wherePart + restriction.wherePart;
                    criteriaPart.parameterNames.addAll(restriction.parameterNames);
                    criteriaPart.parameters.addAll(restriction.parameters);
                    criteriaPart.beanParameterTypes.addAll(restriction.beanParameterTypes);
                }
            }
            while (i$2.hasNext()) {
                Object criterion = i$2.next();
                if (criterion instanceof Map) {
                    CriteriaPart restriction = this.parseAdvancedCriteria((Map)criterion, criteriaPart.nextParameterNumber, request);
                    if (restriction == null) continue;
                    restrictions.add(restriction);
                    criteriaPart.nextParameterNumber = restriction.nextParameterNumber;
                    continue;
                }
                log.warn((Object)("Found sub-criterion that is not instance of Map in criterion '" + op + "'. Skipping."));
            }
            if (restrictions.size() <= 0) return null;
            i$2 = restrictions.iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    criteriaPart.wherePart = "(" + criteriaPart.wherePart + ")";
                    return criteriaPart;
                }
                CriteriaPart restriction = (CriteriaPart)i$2.next();
                if (!"".equals(criteriaPart.wherePart)) {
                    criteriaPart.wherePart = criteriaPart.wherePart + " and ";
                }
                criteriaPart.wherePart = criteriaPart.wherePart + restriction.wherePart;
                criteriaPart.parameterNames.addAll(restriction.parameterNames);
                criteriaPart.parameters.addAll(restriction.parameters);
                criteriaPart.beanParameterTypes.addAll(restriction.beanParameterTypes);
            }
        }
        while (i$.hasNext()) {
            Object singleValue = i$.next();
            Object typedParameterValue = null;
            if (relationFieldInfo != null) {
                if (singleValue == null) {
                    hasNulls = true;
                    continue;
                }
                if (relationFieldInfo.isObjectEncapsulated()) {
                    typedParameterValue = relatedDS.beanClass.newInstance();
                    DataTools.setProperties((Map)((Map)singleValue), (Object)typedParameterValue);
                    criteriaPart.beanParameterTypes.add(relatedDS.beanClass);
                } else {
                    try {
                        if (Map.class.isAssignableFrom(singleValue.getClass())) {
                            Map singleValueMap = (Map)singleValue;
                            relatedpropertyName = (String)singleValueMap.keySet().iterator().next();
                            relatedPropertyType = DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relatedpropertyName);
                            typedParameterValue = DataTools.castValue(singleValueMap.get(relatedpropertyName), (Class)relatedPropertyType, (DataSource)this);
                        } else {
                            typedParameterValue = DataTools.castValue(singleValue, (Class)relatedPropertyType, (DataSource)this);
                        }
                        criteriaPart.beanParameterTypes.add(relatedPropertyType);
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Failed to cast value for field '" + fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                        continue;
                    }
                }
                if (relationFieldInfo.isMultiple()) {
                    if (!"".equals(criteriaPart.wherePart)) {
                        criteriaPart.wherePart = criteriaPart.wherePart + ", ";
                    }
                    criteriaPart.wherePart = criteriaPart.wherePart + ":p" + criteriaPart.nextParameterNumber;
                    criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                    criteriaPart.parameters.add(typedParameterValue);
                } else {
                    if (!"".equals(criteriaPart.wherePart)) {
                        criteriaPart.wherePart = criteriaPart.wherePart + " or ";
                    }
                    criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                    criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                    criteriaPart.parameters.add(typedParameterValue);
                }
                ++realValueListSize;
                continue;
            }
            try {
                typedParameterValue = DataTools.castValue(singleValue, (Class)propertyType, (DataSource)this);
                if (typedParameterValue == null) {
                    hasNulls = true;
                    continue;
                }
                if (!"".equals(criteriaPart.wherePart)) {
                    criteriaPart.wherePart = criteriaPart.wherePart + " or ";
                }
                criteriaPart.wherePart = criteriaPart.wherePart + aliasedPropertyName + " = :p" + criteriaPart.nextParameterNumber;
                criteriaPart.parameterNames.add("p" + criteriaPart.nextParameterNumber++);
                criteriaPart.parameters.add(typedParameterValue);
                criteriaPart.beanParameterTypes.add(propertyType);
                ++realValueListSize;
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to cast value for field '" + fieldName + "' in criterion '" + op + "'.\n" + ex.getMessage() + "\nSkipping value: '" + singleValue.toString() + "'"));
            }
        }
        if (realValueListSize > 0) {
            if (hasNulls) {
                if (relationFieldInfo == null) {
                    criteriaPart.wherePart = "(" + criteriaPart.wherePart + " or " + aliasedPropertyName + " is null)";
                    return criteriaPart;
                }
                if (!relationFieldInfo.isMultiple()) {
                    criteriaPart.wherePart = "(" + criteriaPart.wherePart + " or " + aliasedPropertyName + " is null)";
                    return criteriaPart;
                }
                if (relationFieldInfo.isObjectEncapsulated()) {
                    criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + criteriaPart.wherePart + ")) or " + aliasedPropertyName + " is empty)";
                    return criteriaPart;
                }
                criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + criteriaPart.wherePart + ")) or " + aliasedPropertyName + " is empty)";
                return criteriaPart;
            }
            if (relationFieldInfo == null) {
                criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") and " + aliasedPropertyName + " is not null)";
                return criteriaPart;
            }
            if (!relationFieldInfo.isMultiple()) {
                criteriaPart.wherePart = "((" + criteriaPart.wherePart + ") and " + aliasedPropertyName + " is not null)";
                return criteriaPart;
            }
            if (relationFieldInfo.isObjectEncapsulated()) {
                criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + " in (" + criteriaPart.wherePart + ")) and " + aliasedPropertyName + " is not empty)";
                return criteriaPart;
            }
            criteriaPart.wherePart = "(exists (select " + relatedDS.beanName + " from " + aliasedPropertyName + " " + relatedDS.beanName + " where " + relatedDS.beanName + "." + relatedpropertyName + " in (" + criteriaPart.wherePart + ")) and " + aliasedPropertyName + " is not empty)";
            return criteriaPart;
        }
        if (hasNulls) {
            if (relationFieldInfo != null) {
                criteriaPart.wherePart = aliasedPropertyName + " is empty";
                return criteriaPart;
            }
            criteriaPart.wherePart = aliasedPropertyName + " is null";
            return criteriaPart;
        }
        if (relationFieldInfo != null && relationFieldInfo.isMultiple()) {
            criteriaPart.wherePart = aliasedPropertyName + " is empty";
            return criteriaPart;
        }
        criteriaPart.wherePart = "1=2";
        return criteriaPart;
    }

    private Criteria addAllCriterions(Criteria criteria, List criterions) {
        Iterator i = criterions.iterator();
        while (i.hasNext()) {
            criteria.add((Criterion)i.next());
        }
        return criteria;
    }

    public Criteria getCriteria(DSRequest dsRequest) throws Exception {
        Session session = HibernateTransaction.openSession(this.getSessionFactory());
        Criteria crit = this.buildCriteria(dsRequest, session);
        return crit;
    }

    protected void initAliases() {
        int aliasNameCounter = 1;
        for (Object fieldObject : this.getFields()) {
            DSField field = (DSField)fieldObject;
            String beanPropertyName = field.getBeanPropertyName();
            if (beanPropertyName.indexOf(46) <= 0) continue;
            String propertyPath = "";
            PropertyPath parentPropertyPath = null;
            while (beanPropertyName.indexOf(46) > 0) {
                String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                if (!"".equals(propertyPath)) {
                    propertyPath = propertyPath + ".";
                }
                if (!this.pathAliases.containsKey(propertyPath = propertyPath + pathPart)) {
                    PropertyPath path = new PropertyPath(propertyPath, "_ALIAS_" + aliasNameCounter++, parentPropertyPath);
                    this.pathAliases.put(propertyPath, path);
                    parentPropertyPath = path;
                } else {
                    parentPropertyPath = this.pathAliases.get(propertyPath);
                }
                beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
            }
        }
    }

    protected String getFieldHQLName(DSField field) {
        if (field == null) {
            return "";
        }
        String beanPropertyName = field.getBeanPropertyName();
        if (beanPropertyName.indexOf(46) > 0) {
            String propertyPath = beanPropertyName.substring(0, beanPropertyName.lastIndexOf(46));
            String propertyName = beanPropertyName.substring(beanPropertyName.lastIndexOf(46) + 1);
            PropertyPath path = this.pathAliases.get(propertyPath);
            if (path != null) {
                this.usedPathAliases.put(propertyPath, path);
                return path.getAlias() + "." + propertyName;
            }
        }
        return beanPropertyName;
    }

    protected Criteria addAliases(Criteria criteria) {
        for (String propertyPath : this.usedPathAliases.keySet()) {
            PropertyPath path = this.usedPathAliases.get(propertyPath);
            criteria.createAlias(path.getPath(), path.getAlias(), 1);
            while (path.getParentPropertyPath() != null) {
                path = path.getParentPropertyPath();
                criteria.createAlias(path.getPath(), path.getAlias(), 1);
            }
        }
        return criteria;
    }

    private Criteria addJoins(Criteria criteria) {
        int beanNameCounter = 1;
        ArrayList<String> fromBeans = new ArrayList<String>();
        for (Object fieldObject : this.getFields()) {
            DSField field = (DSField)fieldObject;
            String beanPropertyName = field.getBeanPropertyName();
            if (beanPropertyName.indexOf(46) <= 0 || field.get((Object)"useJoin") != null && !field.getBoolean("useJoin")) continue;
            String fromBeanFull = "";
            while (beanPropertyName.indexOf(46) > 0) {
                String pathPart = beanPropertyName.substring(0, beanPropertyName.indexOf(46));
                if (!"".equals(fromBeanFull)) {
                    fromBeanFull = fromBeanFull + ".";
                }
                if (!fromBeans.contains(fromBeanFull = fromBeanFull + pathPart)) {
                    pathPart = pathPart + beanNameCounter++;
                    fromBeans.add(fromBeanFull);
                    criteria.setFetchMode(fromBeanFull, FetchMode.JOIN);
                }
                beanPropertyName = beanPropertyName.substring(beanPropertyName.indexOf(46) + 1);
            }
        }
        return criteria;
    }

    private Criteria buildCriteria(DSRequest req, Session session) throws Exception {
        ArrayList<Object> criterions = new ArrayList<Object>();
        Map rCriteria = req.getCriteria();
        if (rCriteria != null) {
            if (this.isAdvancedCriteria(rCriteria)) {
                Criterion wk;
                this.strictSQLFiltering = false;
                String strictMode = null;
                strictMode = (String)rCriteria.get("strictSQLFiltering");
                if (strictMode == null) {
                    strictMode = this.getProperty("strictSQLFiltering");
                }
                if (strictMode != null && (strictMode instanceof Boolean && strictMode.equals(Boolean.TRUE) || strictMode instanceof String && strictMode.equals("true"))) {
                    this.strictSQLFiltering = true;
                }
                if ((wk = this.parseAdvancedCriteria(rCriteria, req)) != null) {
                    criterions.add(wk);
                }
            } else {
                boolean isFilter = "substring".equals(req.getTextMatchStyle());
                boolean startsWith = "startsWith".equals(req.getTextMatchStyle());
                for (String fieldName : rCriteria.keySet()) {
                    Object value = this.castValue(rCriteria.get(fieldName), fieldName, req);
                    Disjunction criterion = null;
                    DSField field = this.getField(fieldName);
                    if (field == null) {
                        log.info((Object)("ignoring criteria for undeclared field '" + fieldName + "'"));
                        continue;
                    }
                    String fieldType = field.getType();
                    if (value instanceof List) {
                        criterion = Restrictions.disjunction();
                        Iterator j = ((List)value).iterator();
                        while (j.hasNext()) {
                            criterion.add((Criterion)Restrictions.eq((String)fieldName, j.next()));
                        }
                    } else if (isFilter && ("text".equals(fieldType) || "string".equals(fieldType))) {
                        criterion = Restrictions.like((String)this.getFieldHQLName(field), (String)value.toString(), (MatchMode)MatchMode.ANYWHERE);
                    } else if (startsWith && ("text".equals(fieldType) || "string".equals(fieldType))) {
                        criterion = Restrictions.like((String)this.getFieldHQLName(field), (String)value.toString(), (MatchMode)MatchMode.START);
                    } else if ((isFilter || startsWith) && ("integer".equals(fieldType) || "float".equals(fieldType) || "number".equals(fieldType) || "sequence".equals(fieldType))) {
                        String sql = "{alias}." + field.getBeanPropertyName() + " LIKE '";
                        if (isFilter) {
                            sql = sql + "%";
                        }
                        sql = sql + value.toString() + "%'";
                        criterion = Restrictions.sqlRestriction((String)sql);
                    } else {
                        criterion = Restrictions.eq((String)this.getFieldHQLName(field), (Object)value);
                    }
                    criterions.add(criterion);
                }
            }
        }
        Criteria criteria = session.createCriteria(this.entityName);
        this.addJoins(criteria);
        this.addAliases(criteria);
        this.addAllCriterions(criteria, criterions);
        this.totalRows = -1L;
        if (req.isPaged()) {
            if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                req.setBatchSize(req.getEndRow() - req.getStartRow());
            }
            criteria.setProjection(Projections.rowCount());
            Object rowCount = criteria.uniqueResult();
            this.totalRows = rowCount instanceof Integer ? (long)((Integer)rowCount).intValue() : (rowCount instanceof Long ? (long)((Long)rowCount).intValue() : 0L);
            if (req.getStartRow() > this.totalRows || this.totalRows - req.getStartRow() < req.getBatchSize()) {
                long newStartRow = Math.max(this.totalRows - req.getBatchSize(), 0L);
                req.setStartRow(newStartRow);
            }
            criteria = session.createCriteria(this.entityName);
            this.addJoins(criteria);
            this.addAliases(criteria);
            this.addAllCriterions(criteria, criterions);
            criteria.setMaxResults((int)req.getBatchSize());
            criteria.setFirstResult((int)req.getStartRow());
        }
        return criteria;
    }

    private Criterion parseAdvancedCriteria(Map rCrit, DSRequest dsRequest) throws Exception {
        return this.parseCriteriaRecursively(rCrit, dsRequest);
    }

    private Criterion parseCriteriaRecursively(Map rCrit, DSRequest dsRequest) throws Exception {
        boolean customSQL;
        DSField field;
        Object hbCriterion = null;
        ArrayList<Criterion> subCriterions = new ArrayList<Criterion>();
        Object subCriteria = rCrit.get("criteria");
        if (subCriteria != null) {
            if (!(subCriteria instanceof List)) {
                log.warn((Object)"Found a subcriteria that was not a List - using empty ArrayList");
                subCriteria = new ArrayList();
            }
            for (Object map : (List)subCriteria) {
                if (!(map instanceof Map)) {
                    log.error((Object)"Found a subcriterion that was not a Map");
                    continue;
                }
                hbCriterion = this.parseCriteriaRecursively((Map)map, dsRequest);
                if (hbCriterion == null) continue;
                subCriterions.add((Criterion)hbCriterion);
            }
        }
        if ((field = this.getField((String)rCrit.get("fieldName"))) != null && field.get((Object)"customSQL") != null && (customSQL = field.get((Object)"customSQL").toString().toLowerCase().equals("true"))) {
            return null;
        }
        String operator = (String)rCrit.get("operator");
        if (operator == null) {
            log.error((Object)"Found a null operator");
        } else if (operator.equals("and") || operator.equals("or") || operator.equals("not")) {
            hbCriterion = operator.equals("and") ? Restrictions.conjunction() : Restrictions.disjunction();
            for (int i = 0; i < subCriterions.size(); ++i) {
                ((Junction)hbCriterion).add((Criterion)subCriterions.get(i));
            }
            if (operator.equals("not")) {
                hbCriterion = Restrictions.not((Criterion)hbCriterion);
            }
        } else if (operator.equals("contains") || operator.equals("iContains") || operator.equals("startsWith") || operator.equals("iStartsWith") || operator.equals("endsWith") || operator.equals("iEndsWith") || operator.equals("iEquals")) {
            hbCriterion = this.stringComparison(operator, rCrit, false);
        } else if (operator.equals("notContains") || operator.equals("iNotContains") || operator.equals("notStartsWith") || operator.equals("iNotStartsWith") || operator.equals("notEndsWith") || operator.equals("iNotEndsWith") || operator.equals("iNotEqual")) {
            hbCriterion = this.stringComparison(operator, rCrit, true);
        } else if (operator.equals("equals") || operator.equals("notEqual") || operator.equals("greaterThan") || operator.equals("greaterOrEqual") || operator.equals("lessThan") || operator.equals("lessOrEqual") || operator.equals("between") || operator.equals("betweenInclusive") || operator.equals("iBetween") || operator.equals("iBetweenInclusive")) {
            hbCriterion = this.valueComparison(operator, rCrit, dsRequest);
        } else if (operator.equals("isNull") || operator.equals("notNull")) {
            hbCriterion = this.nullComparison(operator, rCrit);
        } else if (operator.equals("inSet") || operator.equals("notInSet")) {
            hbCriterion = this.setComparison(operator, rCrit, operator.equals("notInSet"), dsRequest);
        } else if (operator.equals("equalsField") || operator.equals("notEqualField")) {
            hbCriterion = this.fieldComparison(operator, rCrit, operator.equals("notEqualField"));
        } else if (operator.equals("regexp") || operator.equals("iregexp")) {
            log.info((Object)"'regexp' and 'iregexp' conditions are ignored on the server");
        } else {
            log.warn((Object)("Found unknown operator " + operator));
        }
        return hbCriterion;
    }

    private Criterion stringComparison(String operator, Map rCrit, boolean negate) throws Exception {
        Object objVal;
        Criterion hbCriterion = null;
        String fieldName = (String)rCrit.get("fieldName");
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return null;
        }
        DSField thisField = this.getField(fieldName);
        if (thisField == null) {
            log.error((Object)("Field " + fieldName + " is unknown!"));
            return null;
        }
        String columnType = this.getSimpleBaseType(thisField.getType());
        if (columnType == null) {
            columnType = "text";
        }
        if ((objVal = rCrit.get("value")) == null) {
            objVal = "";
        }
        String value = objVal.toString();
        if (!"text".equals(columnType)) {
            if (!("integer".equals(columnType) || "float".equals(columnType) || "number".equals(columnType) || "sequence".equals(columnType))) {
                if (negate) {
                    return null;
                }
                return Restrictions.sqlRestriction((String)"1 = 2");
            }
            String sql = "{alias}." + thisField.getBeanPropertyName() + " LIKE '";
            if (operator.indexOf("ontains") != -1 || operator.indexOf("ndsWith") != -1) {
                sql = sql + "%";
            }
            sql = sql + value;
            if (operator.indexOf("ontains") != -1 || operator.indexOf("artsWith") != -1) {
                sql = sql + "%";
            }
            sql = sql + "'";
            return Restrictions.sqlRestriction((String)sql);
        }
        MatchMode matchMode = operator.indexOf("ontains") != -1 ? MatchMode.ANYWHERE : (operator.indexOf("artsWith") != -1 ? MatchMode.START : (operator.indexOf("ndsWith") != -1 ? MatchMode.END : MatchMode.EXACT));
        if (operator.startsWith("i")) {
            hbCriterion = Restrictions.ilike((String)this.getFieldHQLName(thisField), (String)value, (MatchMode)matchMode);
        } else if (HibernateDataSource.getDialect(this.getSessionFactory()) instanceof MySQLDialect) {
            String sql = "{alias}." + thisField.getBeanPropertyName() + " like binary ?";
            String compare = value;
            if (matchMode == MatchMode.ANYWHERE || matchMode == MatchMode.END) {
                compare = "%" + compare;
            }
            if (matchMode == MatchMode.ANYWHERE || matchMode == MatchMode.START) {
                compare = compare + "%";
            }
            hbCriterion = Restrictions.sqlRestriction((String)sql, (Object)compare, (Type)Hibernate.STRING);
        } else {
            hbCriterion = Restrictions.like((String)this.getFieldHQLName(thisField), (String)value, (MatchMode)matchMode);
        }
        if (!this.strictSQLFiltering) {
            hbCriterion = Restrictions.and((Criterion)hbCriterion, (Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
        }
        if (negate) {
            hbCriterion = Restrictions.not((Criterion)hbCriterion);
        }
        return hbCriterion;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Criterion valueComparison(String operator, Map rCrit, DSRequest dsRequest) throws Exception {
        void var4_37;
        Object var4_4 = null;
        String fieldName = (String)rCrit.get("fieldName");
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return null;
        }
        DSField thisField = this.getField(fieldName);
        if (thisField == null) {
            log.error((Object)("Field " + fieldName + " is unknown!"));
            return null;
        }
        Object v = rCrit.get("value");
        Object v2 = rCrit.get("start");
        Object v3 = rCrit.get("end");
        String columnType = this.getSimpleBaseType(thisField.getType());
        if (columnType == null) {
            columnType = "text";
        }
        if ("text".equals(columnType) && (v instanceof Date || v2 instanceof Date || v3 instanceof Date)) {
            if (!operator.equals("notEqual")) return Restrictions.sqlRestriction((String)"1 = 2");
            return null;
        }
        Object object = this.castValue(v, fieldName, dsRequest);
        Object object2 = this.castValue(v2, fieldName, dsRequest);
        Object object3 = this.castValue(v3, fieldName, dsRequest);
        if (this.beanClass == null && ("integer".equals(columnType) && object != null && !(object instanceof Long) || "float".equals(columnType) && object != null && !(object instanceof Double) || "date".equals(columnType) && object != null && !(object instanceof Date) || "integer".equals(columnType) && object2 != null && !(object2 instanceof Long) || "float".equals(columnType) && object2 != null && !(object2 instanceof Double) || "date".equals(columnType) && object2 != null && !(object2 instanceof Date) || "integer".equals(columnType) && object3 != null && !(object3 instanceof Long) || "float".equals(columnType) && object3 != null && !(object3 instanceof Double) || "date".equals(columnType) && object3 != null && !(object3 instanceof Date))) {
            if (operator.equals("notEqual")) {
                if (!this.strictSQLFiltering) return null;
                return Restrictions.eqProperty((String)this.getFieldHQLName(thisField), (String)this.getFieldHQLName(thisField));
            }
            if (operator.equals("lessThan") || operator.equals("lessOrEqual")) {
                if (!this.strictSQLFiltering) return Restrictions.isNull((String)this.getFieldHQLName(thisField));
                return Restrictions.and((Criterion)Restrictions.neProperty((String)this.getFieldHQLName(thisField), (String)this.getFieldHQLName(thisField)), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
            }
            if (!this.strictSQLFiltering) return Restrictions.sqlRestriction((String)"1 = 2");
            return Restrictions.and((Criterion)Restrictions.neProperty((String)this.getFieldHQLName(thisField), (String)this.getFieldHQLName(thisField)), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
        }
        if (operator.equals("equals")) {
            if (this.strictSQLFiltering) {
                SimpleExpression simpleExpression = Restrictions.eq((String)this.getFieldHQLName(thisField), (Object)object);
                return var4_37;
            } else if (object != null) {
                LogicalExpression logicalExpression = Restrictions.and((Criterion)Restrictions.eq((String)this.getFieldHQLName(thisField), (Object)object), (Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
                return var4_37;
            } else {
                Criterion criterion = Restrictions.isNull((String)this.getFieldHQLName(thisField));
            }
            return var4_37;
        } else if (operator.equals("notEqual")) {
            if (this.strictSQLFiltering) {
                SimpleExpression simpleExpression = Restrictions.ne((String)this.getFieldHQLName(thisField), (Object)object);
                return var4_37;
            } else if (object != null) {
                LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.ne((String)this.getFieldHQLName(thisField), (Object)object), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
                return var4_37;
            } else {
                Criterion criterion = Restrictions.isNotNull((String)this.getFieldHQLName(thisField));
            }
            return var4_37;
        } else if (operator.equals("greaterThan")) {
            if (this.strictSQLFiltering) {
                SimpleExpression simpleExpression = Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object);
                return var4_37;
            } else {
                if (object == null) return var4_37;
                LogicalExpression logicalExpression = Restrictions.and((Criterion)Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object), (Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
            }
            return var4_37;
        } else if (operator.equals("greaterOrEqual")) {
            if (this.strictSQLFiltering) {
                SimpleExpression simpleExpression = Restrictions.ge((String)this.getFieldHQLName(thisField), (Object)object);
                return var4_37;
            } else {
                if (object == null) return var4_37;
                LogicalExpression logicalExpression = Restrictions.and((Criterion)Restrictions.ge((String)this.getFieldHQLName(thisField), (Object)object), (Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
            }
            return var4_37;
        } else if (operator.equals("lessThan")) {
            if (this.strictSQLFiltering) {
                SimpleExpression simpleExpression = Restrictions.lt((String)this.getFieldHQLName(thisField), (Object)object);
                return var4_37;
            } else {
                if (object == null) return var4_37;
                LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.lt((String)this.getFieldHQLName(thisField), (Object)object), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
            }
            return var4_37;
        } else if (operator.equals("lessOrEqual")) {
            if (this.strictSQLFiltering) {
                SimpleExpression simpleExpression = Restrictions.le((String)this.getFieldHQLName(thisField), (Object)object);
                return var4_37;
            } else {
                if (object == null) return var4_37;
                LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.le((String)this.getFieldHQLName(thisField), (Object)object), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
            }
            return var4_37;
        } else if (operator.equals("between")) {
            if (this.strictSQLFiltering) {
                LogicalExpression logicalExpression = Restrictions.and((Criterion)Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object2), (Criterion)Restrictions.lt((String)this.getFieldHQLName(thisField), (Object)object3));
                return var4_37;
            } else if (object2 == null && object3 != null) {
                LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.lt((String)this.getFieldHQLName(thisField), (Object)object3), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
                return var4_37;
            } else if (object2 != null && object3 == null) {
                SimpleExpression simpleExpression = Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object2);
                return var4_37;
            } else {
                if (object2 == null || object3 == null) return var4_37;
                Junction junction = Restrictions.conjunction().add((Criterion)Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object2)).add((Criterion)Restrictions.lt((String)this.getFieldHQLName(thisField), (Object)object3)).add(Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
            }
            return var4_37;
        } else if (operator.equals("betweenInclusive")) {
            if (this.strictSQLFiltering) {
                Criterion criterion = Restrictions.between((String)this.getFieldHQLName(thisField), (Object)object2, (Object)object3);
                return var4_37;
            } else if (object2 == null && object3 != null) {
                LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.le((String)this.getFieldHQLName(thisField), (Object)object3), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
                return var4_37;
            } else if (object2 != null && object3 == null) {
                SimpleExpression simpleExpression = Restrictions.ge((String)this.getFieldHQLName(thisField), (Object)object2);
                return var4_37;
            } else {
                if (object2 == null || object3 == null) return var4_37;
                LogicalExpression logicalExpression = Restrictions.and((Criterion)Restrictions.between((String)this.getFieldHQLName(thisField), (Object)object2, (Object)object3), (Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
            }
            return var4_37;
        } else if (operator.equals("iBetween")) {
            if (!"text".equals(columnType)) return this.valueComparison("between", rCrit, dsRequest);
            SimpleExpression gt = Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object2);
            if (object2 != null) {
                gt = gt.ignoreCase();
            }
            SimpleExpression lt = Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object3);
            if (object3 != null) {
                lt = lt.ignoreCase();
            }
            if (this.strictSQLFiltering) {
                LogicalExpression logicalExpression = Restrictions.and((Criterion)gt, (Criterion)lt);
                return var4_37;
            } else if (object2 == null && object3 != null) {
                LogicalExpression logicalExpression = Restrictions.or((Criterion)lt, (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
                return var4_37;
            } else if (object2 != null && object3 == null) {
                SimpleExpression simpleExpression = gt;
                return var4_37;
            } else {
                if (object2 == null || object3 == null) return var4_37;
                Junction junction = Restrictions.conjunction().add((Criterion)gt).add((Criterion)lt).add(Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
            }
            return var4_37;
        } else {
            if (!operator.equals("iBetweenInclusive")) return var4_37;
            if (!"text".equals(columnType)) return this.valueComparison("betweenInclusive", rCrit, dsRequest);
            SimpleExpression ge = Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object2);
            if (object2 != null) {
                ge = ge.ignoreCase();
            }
            SimpleExpression le = Restrictions.gt((String)this.getFieldHQLName(thisField), (Object)object3);
            if (object3 != null) {
                le = le.ignoreCase();
            }
            if (this.strictSQLFiltering) {
                LogicalExpression logicalExpression = Restrictions.and((Criterion)ge, (Criterion)le);
                return var4_37;
            } else if (object2 == null && object3 != null) {
                LogicalExpression logicalExpression = Restrictions.or((Criterion)le, (Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)));
                return var4_37;
            } else if (object2 != null && object3 == null) {
                SimpleExpression simpleExpression = ge;
                return var4_37;
            } else {
                if (object2 == null || object3 == null) return var4_37;
                Junction junction = Restrictions.conjunction().add((Criterion)ge).add((Criterion)le).add(Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
            }
        }
        return var4_37;
    }

    private Criterion nullComparison(String operator, Map rCrit) {
        Criterion hbCriterion = null;
        String fieldName = (String)rCrit.get("fieldName");
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return null;
        }
        DSField thisField = this.getField(fieldName);
        if (thisField == null) {
            log.error((Object)("Field " + fieldName + " is unknown!"));
            return null;
        }
        if (operator.equals("isNull")) {
            hbCriterion = Restrictions.isNull((String)this.getFieldHQLName(thisField));
        } else if (operator.equals("notNull")) {
            hbCriterion = Restrictions.isNotNull((String)this.getFieldHQLName(thisField));
        }
        return hbCriterion;
    }

    private Criterion setComparison(String operator, Map rCrit, boolean negate, DSRequest dsRequest) {
        Object hbCriterion = null;
        String fieldName = (String)rCrit.get("fieldName");
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return null;
        }
        DSField thisField = this.getField(fieldName);
        if (thisField == null) {
            log.error((Object)("Field " + fieldName + " is unknown!"));
            return null;
        }
        Object value = rCrit.get("value");
        if (value == null) {
            value = new ArrayList();
        }
        if (!(value instanceof List)) {
            Object val = value;
            value = new ArrayList();
            ((List)value).add(val);
        }
        boolean containsNull = ((List)value).contains(null);
        int size = ((List)value).size();
        for (int i = 0; i < size; ++i) {
            Object work = ((List)value).get(i);
            work = this.castValue(work, fieldName, dsRequest);
            if ("integer".equals(thisField.getType()) && work != null && !(work instanceof Long) || "float".equals(thisField.getType()) && work != null && !(work instanceof Double) || "date".equals(thisField.getType()) && work != null && !(work instanceof Date)) {
                ((List)value).set(i, null);
                continue;
            }
            ((List)value).set(i, work);
        }
        while (((List)value).contains(null)) {
            ((List)value).remove(null);
        }
        if (containsNull) {
            ((List)value).add(null);
        }
        hbCriterion = ((List)value).isEmpty() ? Restrictions.sqlRestriction((String)"2 = 1") : Restrictions.and((Criterion)Restrictions.in((String)this.getFieldHQLName(thisField), (Collection)((List)value)), (Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(thisField)));
        if (negate) {
            hbCriterion = Restrictions.not((Criterion)hbCriterion);
        }
        return hbCriterion;
    }

    private Criterion fieldComparison(String operator, Map rCrit, boolean negate) {
        LogicalExpression hbCriterion = null;
        String fieldName = (String)rCrit.get("fieldName");
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return null;
        }
        DSField thisField = this.getField(fieldName);
        if (thisField == null) {
            log.error((Object)("Field " + fieldName + " is unknown!"));
            return null;
        }
        String otherFieldName = (String)rCrit.get("value");
        if (otherFieldName == null) {
            log.error((Object)"Found a null 'other' fieldName in a field comparison");
            return null;
        }
        DSField otherField = (DSField)this.dsFields.get(otherFieldName);
        if (thisField == null) {
            log.error((Object)("'Other' field " + otherFieldName + " is unknown!"));
            return null;
        }
        if (!thisField.getType().equals(otherField.getType())) {
            if (negate) {
                return null;
            }
            return Restrictions.sqlRestriction((String)"1 = 2");
        }
        hbCriterion = Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.isNull((String)this.getFieldHQLName(thisField)), (Criterion)Restrictions.isNull((String)this.getFieldHQLName(otherField))), (Criterion)Restrictions.and((Criterion)Restrictions.eqProperty((String)this.getFieldHQLName(thisField), (String)this.getFieldHQLName(otherField)), (Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(thisField)), (Criterion)Restrictions.isNotNull((String)this.getFieldHQLName(otherField)))));
        if (negate) {
            hbCriterion = Restrictions.not((Criterion)hbCriterion);
        }
        return hbCriterion;
    }

    private Object castValue(Object value, String fieldName, DSRequest dsRequest) {
        DSField thisField = this.getField(fieldName);
        if (this.beanClass != null) {
            try {
                return DataTools.coerceProperty((String)fieldName, (Object)value, (Class)this.beanClass, (DataSource)this, (DSRequest)dsRequest);
            }
            catch (Exception e) {
                log.warn((Object)e);
                return value;
            }
        }
        if (value instanceof String) {
            try {
                Number temp;
                if ("integer".equals(thisField.getType()) || "sequence".equals(thisField.getType())) {
                    temp = new Long((String)value);
                    value = temp;
                }
                if ("float".equals(thisField.getType())) {
                    temp = new Double((String)value);
                    value = temp;
                }
            }
            catch (Exception e) {
                log.warn((Object)("String '" + value + "' was passed as filter criteria for non-" + "String field " + fieldName + ". We could not parse it."));
            }
        }
        if (value != null && !(value instanceof String) && "text".equals(thisField.getType())) {
            value = value.toString();
        }
        return value;
    }

    public static synchronized Connection getConnection() throws Exception {
        HibernateDataSource.initStaticConfigAndSessionFactory();
        Session newSession = HibernateTransaction.openSession(HibernateDataSource.getStaticSessionFactory());
        if (HibernateDataSource.isHibernateConnection(newSession.connection())) {
            throw new Exception("New session's connection is already in use");
        }
        openSessions.add(newSession);
        log.debug((Object)("Opened new session \"" + newSession.hashCode() + "\""));
        return newSession.connection();
    }

    public static synchronized void freeConnection(Connection conn) throws Exception {
        Iterator i = openSessions.iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            if (session.connection() != conn) continue;
            log.debug((Object)("Closed session \"" + session.hashCode() + "\""));
            i.remove();
            try {
                session.connection().commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                session.close();
            }
            catch (Exception exception) {}
            break;
        }
    }

    public static synchronized boolean isHibernateConnection(Connection conn) throws Exception {
        for (Session session : openSessions) {
            if (session.connection() != conn) continue;
            return true;
        }
        return false;
    }

    public boolean isStaticHibernateConnection(Connection conn) throws Exception {
        return HibernateDataSource.isHibernateConnection(conn);
    }

    public Connection getStaticConnection() throws Exception {
        return HibernateDataSource.getConnection();
    }

    public void freeStaticConnection(Connection conn) throws Exception {
        HibernateDataSource.freeConnection(conn);
    }

    public synchronized String getHibernateDialectAsSmartClientDbType() throws Exception {
        this.initConfigAndSessionFactory();
        Dialect dialect = HibernateDataSource.getDialect(this.getSessionFactory());
        String dbType = null;
        if (dialect instanceof Cache71Dialect) {
            dbType = "cache";
        } else if (dialect instanceof DB2Dialect) {
            dbType = "db2";
        } else if (dialect instanceof HSQLDialect) {
            dbType = "hsqldb";
        } else if (dialect instanceof MySQLDialect) {
            dbType = "mysql";
        } else if (dialect instanceof OracleDialect) {
            dbType = "oracle";
        } else if (dialect instanceof PostgreSQLDialect) {
            dbType = "postgresql";
        } else if (dialect instanceof SQLServerDialect) {
            dbType = "sqlserver";
        }
        return dbType;
    }

    public Transaction getOrStartTransaction(DSRequest req) throws Exception {
        Transaction trx = (Transaction)this.getTransactionObject(req);
        if (trx == null) {
            trx = HibernateTransaction.startTransaction(req == null ? null : req.rpc, this);
            if (req != null && req.rpc != null) {
                req.rpc.registerCallback((RPCManagerCompletionCallback)this);
            }
        }
        return trx;
    }

    public String getTransactionObjectKey() throws Exception {
        return "_isc_hibernate_transaction_";
    }

    public void onSuccess(RPCManager rpc) throws Exception {
        HibernateTransaction.commitTransaction(rpc);
    }

    public void onFailure(RPCManager rpc, boolean transactionFailed) throws Exception {
        if (transactionFailed) {
            log.debug((Object)"Rolling back current transaction after failing to commit.");
        } else {
            log.debug((Object)"Rolling back current transaction.");
        }
        HibernateTransaction.rollbackTransaction(rpc);
    }

    protected Boolean autoJoinAtProviderLevel(DSRequest req) {
        String autoJoin = config.getString((Object)"hibernate.autoJoinTransactions");
        if (autoJoin == null) {
            return null;
        }
        if (autoJoin.toLowerCase().equals("true") || autoJoin.toLowerCase().equals("ALL")) {
            return Boolean.TRUE;
        }
        if (autoJoin.toLowerCase().equals("false") || autoJoin.toLowerCase().equals("NONE")) {
            return Boolean.FALSE;
        }
        if (req != null && req.rpc != null) {
            if (autoJoin.equals("FROM_FIRST_CHANGE")) {
                return req.rpc.requestQueueIncludesUpdates();
            }
            if (autoJoin.equals("ANY_CHANGE")) {
                return req.rpc.requestQueueIncludesUpdates();
            }
        }
        return null;
    }

    public static Transaction startTransaction() throws Exception {
        return HibernateTransaction.startTransaction(null, null);
    }

    public static void rollbackTransaction(Transaction trx) throws Exception {
        HibernateTransaction.rollbackTransaction(trx, null);
    }

    public static void commitTransaction(Transaction trx) throws Exception {
        HibernateTransaction.commitTransaction(trx, null);
    }

    public void freeResources(DSRequest req) {
        if (this.isPassive()) {
            return;
        }
        this.additionalFields = null;
        if (this.inlineTransaction != null) {
            try {
                HibernateTransaction.closeSession(this.inlineTransaction);
            }
            catch (Exception e) {
                log.warn((Object)"Encountered exception closing session during freeResources()", (Throwable)e);
            }
            this.inlineTransaction = null;
        } else if (req != null && req.getRPCManager() != null) {
            try {
                HibernateTransaction.closeSession(req.getRPCManager());
            }
            catch (Exception e) {
                log.warn((Object)"Encountered exception closing session during freeResources()", (Throwable)e);
            }
        }
        super.freeResources(req);
    }

    public boolean handlesRelations() {
        return true;
    }

    protected Object getRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, List recursedList, ValidationContext vc) throws Exception {
        if (obj == null) {
            return null;
        }
        if (this.beanClass.isInstance(obj)) {
            Object value = DataTools.getProperties((Object)obj, (Collection)DataTools.buildList((Object)relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
            if (value == null) {
                return null;
            }
            DataSource relatedDS = DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
            if (relationFieldInfo.isMultiple()) {
                if (value instanceof Map) {
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        HashMap pkMap = new HashMap();
                        for (Object key : ((Map)value).keySet()) {
                            Object singleValue = ((Map)value).get(key);
                            if (!DataTools.containsByReference((Collection)recursedList, singleValue)) {
                                pkMap.put(key, relatedDS.getProperties(singleValue, null, true, true, vc, recursedList));
                                continue;
                            }
                            log.warn((Object)(singleValue.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                        }
                        return pkMap;
                    }
                    HashMap pkMap = new HashMap();
                    for (Object key : ((Map)value).keySet()) {
                        Object singleValue = ((Map)value).get(key);
                        pkMap.put(key, DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName()));
                    }
                    return pkMap;
                }
                if (value instanceof Collection) {
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        ArrayList<Map> pkList = new ArrayList<Map>();
                        for (Object singleValue : (Collection)value) {
                            if (!DataTools.containsByReference((Collection)recursedList, singleValue)) {
                                pkList.add(relatedDS.getProperties(singleValue, null, true, true, vc, recursedList));
                                continue;
                            }
                            log.warn((Object)(singleValue.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                        }
                        return pkList;
                    }
                    ArrayList pkList = new ArrayList();
                    for (Object singleValue : (Collection)value) {
                        pkList.add(DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName()));
                    }
                    return pkList;
                }
                if (relationFieldInfo.isObjectEncapsulated()) {
                    if (!DataTools.containsByReference((Collection)recursedList, value)) {
                        return DataTools.buildList((Object)relatedDS.getProperties(value, null, true, true, vc, recursedList));
                    }
                    log.warn((Object)(value.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                    return null;
                }
                return DataTools.getProperties(value, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
            }
            if (relationFieldInfo.isObjectEncapsulated()) {
                if (!DataTools.containsByReference((Collection)recursedList, value)) {
                    return relatedDS.getProperties(value, null, true, true, vc, recursedList);
                }
                log.warn((Object)(value.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value."));
                return null;
            }
            return DataTools.getProperties(value, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
        }
        throw new Exception("Specified object is not instance of " + this.beanClass.getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setRelationFieldValue(RelationFieldInfo relationFieldInfo, Object obj, Object value) throws Exception {
        HibernateDataSource relatedDS = (HibernateDataSource)DataSourceManager.getDataSource((String)relationFieldInfo.getRelatedDSName(), null);
        if (!this.beanClass.isInstance(obj)) throw new Exception("Can not set related value to specified object. Not instance of " + this.beanClass.getName());
        Session session = HibernateTransaction.getTransactionSession(this.currentTransaction);
        Object oldValue = DataTools.getProperties((Object)obj, (Collection)DataTools.buildList((Object)relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
        if (relationFieldInfo.isMultiple()) {
            if (oldValue == null) {
                Class propertyType = DataTools.getPropertyType((Class)this.beanClass, (String)relationFieldInfo.getFieldName());
                if (Collection.class.isAssignableFrom(propertyType)) {
                    oldValue = new ArrayList();
                } else if (Map.class.isAssignableFrom(propertyType)) {
                    oldValue = new HashMap();
                }
                if (oldValue != null) {
                    DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), oldValue), (Object)obj);
                    oldValue = DataTools.getProperties((Object)obj, (Collection)DataTools.buildList((Object)relationFieldInfo.getFieldName())).get(relationFieldInfo.getFieldName());
                }
            }
            if (oldValue instanceof Map) {
                if (value == null) {
                    value = new HashMap();
                }
                if (!(value instanceof Map)) throw new Exception("Can not update relation. Field " + relationFieldInfo.getFieldName() + " is Map but passed value is not Map");
                ArrayList keysToRemove = new ArrayList();
                for (Object k : ((Map)oldValue).keySet()) {
                    if (((Map)value).containsKey(k)) continue;
                    keysToRemove.add(k);
                }
                for (Object object : keysToRemove) {
                    Object valueToRemove = ((Map)oldValue).remove(object);
                    DSResponse relatedUpdate = new DSResponse((DataSource)relatedDS, valueToRemove, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType("remove");
                    this.relatedUpdates.add(relatedUpdate);
                }
                for (Object object : ((Map)value).keySet()) {
                    String relatedOperationType;
                    Object singleValue = ((Map)value).get(object);
                    if (((Map)oldValue).containsKey(object)) {
                        Object currentValue = ((Map)oldValue).get(object);
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), currentValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), currentValue);
                            }
                        }
                        DSResponse dSResponse = new DSResponse((DataSource)relatedDS, currentValue, DSResponse.STATUS_SUCCESS);
                        dSResponse.setOperationType("update");
                        this.relatedUpdates.add(dSResponse);
                        continue;
                    }
                    Object relatedId = singleValue;
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        relatedId = singleValue instanceof Map ? ((Map)singleValue).get(relationFieldInfo.getRelatedFieldName()) : DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
                    }
                    Query query = session.createQuery("select _" + relatedDS.beanName + " from " + relatedDS.entityName + " _" + relatedDS.beanName + " where _" + relatedDS.beanName + "." + relationFieldInfo.getRelatedFieldName() + " = :p0");
                    query.setParameter("p0", DataTools.castValue(relatedId, (Class)DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relationFieldInfo.getRelatedFieldName())));
                    List resultList = query.list();
                    Object newValue = null;
                    if (resultList != null && !resultList.isEmpty()) {
                        newValue = resultList.get(0);
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), newValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), newValue);
                            }
                        }
                        relatedOperationType = "update";
                    } else {
                        newValue = relatedDS.beanClass.newInstance();
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), newValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), newValue);
                            }
                        } else {
                            DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getRelatedFieldName(), singleValue), newValue);
                        }
                        session.save(newValue);
                        relatedOperationType = "add";
                    }
                    ((Map)oldValue).put(object, newValue);
                    DSResponse relatedUpdate = new DSResponse((DataSource)relatedDS, newValue, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType(relatedOperationType);
                    this.relatedUpdates.add(relatedUpdate);
                }
                return;
            } else {
                DSResponse relatedUpdate;
                if (!(oldValue instanceof Collection)) throw new Exception("Can not update relation. Field " + relationFieldInfo.getFieldName() + " is neither Map nor Collection");
                if (value == null) {
                    value = new ArrayList();
                }
                if (!(value instanceof Collection)) {
                    value = DataTools.buildList(value);
                }
                ArrayList<void> newValues = new ArrayList<void>();
                ArrayList addedValues = new ArrayList();
                Object var9_17 = null;
                Iterator i$ = ((Collection)value).iterator();
                while (i$.hasNext()) {
                    void var9_23;
                    void var9_21;
                    void var12_38;
                    Object singleValue;
                    Object e = singleValue = i$.next();
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        if (singleValue instanceof Map) {
                            Object v = ((Map)singleValue).get(relationFieldInfo.getRelatedFieldName());
                        } else {
                            Object v = DataTools.getProperties(singleValue, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
                        }
                    }
                    Query q = session.createQuery("select _" + relatedDS.beanName + " from " + relatedDS.entityName + " _" + relatedDS.beanName + " where _" + relatedDS.beanName + "." + relationFieldInfo.getRelatedFieldName() + " = :p0");
                    q.setParameter("p0", DataTools.castValue((Object)var12_38, (Class)DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relationFieldInfo.getRelatedFieldName())));
                    List resultList = q.list();
                    Object var9_19 = null;
                    if (resultList != null && !resultList.isEmpty()) {
                        Object e2 = resultList.get(0);
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), e2);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), e2);
                            }
                        }
                        DSResponse relatedUpdate2 = new DSResponse((DataSource)relatedDS, e2, DSResponse.STATUS_SUCCESS);
                        relatedUpdate2.setOperationType("update");
                        this.relatedUpdates.add(relatedUpdate2);
                    }
                    if (var9_21 == null) {
                        Object t = relatedDS.beanClass.newInstance();
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (singleValue instanceof Map) {
                                DataTools.setProperties((Map)((Map)singleValue), t);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties(singleValue), t);
                            }
                        } else {
                            DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getRelatedFieldName(), singleValue), t);
                        }
                        session.save(t);
                        addedValues.add(t);
                    }
                    newValues.add(var9_23);
                }
                ArrayList valuesToRemove = new ArrayList();
                ArrayList valuesToAdd = new ArrayList();
                for (Object singleValue : (Collection)oldValue) {
                    if (newValues.contains(singleValue)) continue;
                    valuesToRemove.add(singleValue);
                }
                for (Object singleValue : newValues) {
                    if (((Collection)oldValue).contains(singleValue)) continue;
                    valuesToAdd.add(singleValue);
                }
                ((Collection)oldValue).removeAll(valuesToRemove);
                for (Object valueToRemove : valuesToRemove) {
                    relatedUpdate = new DSResponse((DataSource)relatedDS, valueToRemove, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType("remove");
                    this.relatedUpdates.add(relatedUpdate);
                }
                ((Collection)oldValue).addAll(valuesToAdd);
                for (Object addedValue : addedValues) {
                    relatedUpdate = new DSResponse((DataSource)relatedDS, addedValue, DSResponse.STATUS_SUCCESS);
                    relatedUpdate.setOperationType("add");
                    this.relatedUpdates.add(relatedUpdate);
                }
            }
            return;
        } else {
            boolean relatedRemove = false;
            Object newValue = null;
            Object var9_24 = null;
            if (value == null) {
                if (oldValue != null) {
                    relatedRemove = true;
                }
                DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), null), (Object)obj, (DataSource)this);
            } else {
                void var9_28;
                if (relationFieldInfo.isObjectEncapsulated()) {
                    if (value instanceof Map) {
                        Object v = ((Map)value).get(relationFieldInfo.getRelatedFieldName());
                    } else {
                        Object v = DataTools.getProperties(value, (Collection)DataTools.buildList((Object)relationFieldInfo.getRelatedFieldName())).get(relationFieldInfo.getRelatedFieldName());
                    }
                } else {
                    HashMap hashMap = value;
                }
                Query q = session.createQuery("select _" + relatedDS.beanName + " from " + relatedDS.entityName + " _" + relatedDS.beanName + " where _" + relatedDS.beanName + "." + relationFieldInfo.getRelatedFieldName() + " = :p0");
                q.setParameter("p0", DataTools.castValue((Object)var9_28, (Class)DataTools.getPropertyType((Class)relatedDS.beanClass, (String)relationFieldInfo.getRelatedFieldName())));
                List resultList = q.list();
                if (resultList != null && !resultList.isEmpty()) {
                    newValue = resultList.get(0);
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        if (value instanceof Map) {
                            DataTools.setProperties((Map)((Map)value), newValue);
                        } else {
                            DataTools.setProperties((Map)DataTools.getProperties((Object)value), newValue);
                        }
                    }
                    if (oldValue != null && !oldValue.equals(newValue)) {
                        relatedRemove = true;
                    }
                    DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), newValue), (Object)obj, (DataSource)this);
                    DSResponse dSResponse = new DSResponse((DataSource)relatedDS, newValue, DSResponse.STATUS_SUCCESS);
                    dSResponse.setOperationType("update");
                    this.relatedUpdates.add(dSResponse);
                }
                if (newValue == null) {
                    if (relationFieldInfo.isObjectEncapsulated()) {
                        newValue = relatedDS.beanClass.newInstance();
                        if (relationFieldInfo.isObjectEncapsulated()) {
                            if (value instanceof Map) {
                                DataTools.setProperties((Map)((Map)value), newValue);
                            } else {
                                DataTools.setProperties((Map)DataTools.getProperties((Object)value), newValue);
                            }
                            session.save(newValue);
                            if (oldValue != null) {
                                relatedRemove = true;
                            }
                            DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), newValue), (Object)obj, (DataSource)this);
                            DSResponse dSResponse = new DSResponse((DataSource)relatedDS, newValue, DSResponse.STATUS_SUCCESS);
                            dSResponse.setOperationType("add");
                            this.relatedUpdates.add(dSResponse);
                        }
                    } else {
                        if (var9_28 != null) {
                            log.warn((Object)("Can not find related object with id=" + var9_28.toString() + ". Setting to NULL."));
                        }
                        if (oldValue != null) {
                            relatedRemove = true;
                        }
                        DataTools.setProperties((Map)DataTools.buildMap((Object)relationFieldInfo.getFieldName(), null), (Object)obj, (DataSource)this);
                    }
                }
            }
            if (!relatedRemove) return;
            DSResponse relatedUpdate = new DSResponse((DataSource)relatedDS, oldValue, DSResponse.STATUS_SUCCESS);
            relatedUpdate.setOperationType("remove");
            this.relatedUpdates.add(relatedUpdate);
        }
    }

    public boolean canJoinIncludedFields() {
        return true;
    }

    protected boolean getDefaultAllowAdvancedCriteria() {
        return true;
    }

    public boolean isCacheable() {
        return false;
    }

    static {
        springConfigured = false;
        count = 0L;
        if (config.getBoolean((Object)"datasources.hibernate.trace.creation", false)) {
            createTrace = new ArrayList<Map>();
        }
        supportedAggregationFunctions = new ArrayList(){
            {
                this.add("MIN");
                this.add("MAX");
                this.add("AVG");
                this.add("SUM");
                this.add("COUNT");
            }
        };
    }

    protected class PropertyPath {
        private String path;
        private String alias;
        private PropertyPath parentPropertyPath;

        public PropertyPath(String path, String alias, PropertyPath parentPropertyPath) {
            this.path = path;
            this.alias = alias;
            this.parentPropertyPath = parentPropertyPath;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public PropertyPath getParentPropertyPath() {
            return this.parentPropertyPath;
        }

        public void setParentPropertyPath(PropertyPath parentPropertyPath) {
            this.parentPropertyPath = parentPropertyPath;
        }

        public String toString() {
            return this.getClass().getName() + "[" + "path=" + (this.getPath() == null ? "null" : this.getPath().toString()) + ", " + "alias=" + (this.getAlias() == null ? "null" : this.getAlias().toString()) + ", " + "parentPropertyPath=" + (this.getParentPropertyPath() == null ? "null" : this.getParentPropertyPath().toString()) + "]";
        }
    }

    private class CriteriaPart {
        String wherePart = "";
        int nextParameterNumber = 0;
        List<String> parameterNames = new ArrayList<String>();
        List<Object> parameters = new ArrayList<Object>();
        List<Class> beanParameterTypes = new ArrayList<Class>();

        private CriteriaPart() {
        }
    }
}

