/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.LocaleMessage;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CacheDriver
extends SQLDriver {
    private static Logger log = new Logger(CacheDriver.class.getName());

    public CacheDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public CacheDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new CacheDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new CacheDriver(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        throw new Exception("Not supported.");
    }

    public String formatValue(Object value) {
        return value.toString();
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        String val = value.toString();
        if (val.equals("")) {
            return "\"\"";
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/g", value.toString());
        if (escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\\\\\'g", escaped);
            escaped = globalPerl.substitute("s'%'\\\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\\\_'g", escaped);
        }
        return escaped;
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        throw new Exception("Not Supported");
    }

    public String getCurrentSequenceValue(String columnName) throws Exception {
        throw new Exception("Not Supported");
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue;
            if (valueMap.get(actualValue) instanceof LocaleMessage) {
                Locale locale = request != null ? request.context.getLocale() : Locale.getDefault();
                displayValue = ((LocaleMessage)valueMap.get(actualValue)).getMessage(locale);
            } else {
                displayValue = valueMap.get(actualValue) == null ? null : valueMap.get(actualValue).toString();
            }
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " END";
        return expr;
    }

    public int caseInsensitiveStrategy() {
        return 0;
    }

    public String getNaturalTableName(String tableName) {
        return tableName;
    }
}

